.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-shlibdeps 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-shlibdeps \- generate shared library substvar dependencies
.
.SH SYNOPSIS
.B dpkg\-shlibdeps
.RI [ option "...] [" \fB\-e\fP ] executable " [" option ...]
.
.SH DESCRIPTION
.B dpkg\-shlibdeps
calculates shared library dependencies for executables named in its
arguments. The dependencies are added to the substitution
variables file
.B debian/substvars
as variable names
.BI shlibs: dependency-field
where
.I dependency-field
is a dependency field name. Any other variables starting with
.B shlibs:
are removed from the file.
.P
.B dpkg\-shlibdeps
has two possible sources of information to generate dependency
information. Either
.I symbols
files or
.I shlibs
files. For each binary that
.B dpkg\-shlibdeps
analyzes, it finds out the list of libraries that it's linked with.
Then, for each library, it looks up either the
.I symbols
file, or the
.I shlibs
file (if the former doesn't exist or if debian/shlibs.local contains
the relevant dependency). Both files are supposed to be provided
by the library package and should thus be available as
%ADMINDIR%/info/\fIpackage\fR.\fIsymbols\fR
or %ADMINDIR%/info/\fIpackage\fR.\fIshlibs\fR. The package name is
identified in two steps: find the library file on the system (looking in
the same directories that \fBld.so\fR would use), then use
.BI "dpkg \-S " library-file
to lookup the package providing the library.
.SS Symbols files
Symbols files contain finer-grained dependency information by providing
the minimum dependency for each symbol that the library exports. The
script tries to find a symbols file associated to a library package
in the following places (first match is used):
.IP debian/*/DEBIAN/symbols
Shared library information generated by the current build process that also invoked
.BR dpkg\-shlibdeps .
They are generated by
.BR dpkg\-gensymbols (1).
They are only used if the library is found in a package's build tree. The
symbols file in that build tree takes precedence over symbols files from
other binary packages.
.IP %PKGCONFDIR%/symbols/\fIpackage\fR.symbols.\fIarch\fR
.IP %PKGCONFDIR%/symbols/\fIpackage\fR.symbols
Per-system overriding shared library dependency information.
\fIarch\fR is the architecture of the current system (obtained by
.BR "dpkg\-architecture \-qDEB_HOST_ARCH" ).
.IP "Output from “\fBdpkg\-query \-\-control\-path\fR \fIpackage\fR symbols”"
Package-provided shared library dependency information.
Unless overridden by \fB\-\-admindir\fP, those files are located in
%ADMINDIR%.
.P
While scanning the symbols used by all binaries,
.B dpkg\-shlibdeps
remembers the (biggest) minimal version needed for each library. At the end
of the process, it is able to write out the minimal dependency for every
library used (provided that the information of the \fIsymbols\fR files are
accurate).
.P
As a safe-guard measure, a symbols file can provide a
\fBBuild\-Depends\-Package\fP meta-information field and
.B dpkg\-shlibdeps
will extract the minimal version required by the corresponding package in
the \fBBuild\-Depends\fP field and use this version if it's higher than the
minimal version computed by scanning symbols.
.SS Shlibs files
Shlibs files associate directly a library to a dependency (without looking
at the symbols). It's thus often stronger than really needed but very safe
and easy to handle.
.P
The dependencies for a library are looked up in several places. The first
file providing information for the library of interest is used:
.IP debian/shlibs.local
Package-local overriding shared library dependency information.
.IP %PKGCONFDIR%/shlibs.override
Per-system overriding shared library dependency information.
.IP debian/*/DEBIAN/shlibs
Shared library information generated by the current build process that also invoked
.BR dpkg\-shlibdeps .
They are only used if the library is found in a package's build tree. The
shlibs file in that build tree takes precedence over shlibs files from
other binary packages.
.IP "Output from “\fBdpkg\-query \-\-control\-path\fP \fIpackage\fR shlibs”"
Package-provided shared library dependency information.
Unless overridden by \fB\-\-admindir\fP, those files are located in
%ADMINDIR%.
.IP %PKGCONFDIR%/shlibs.default
Per-system default shared library dependency information.
.P
The extracted dependencies are then directly used (except if they are
filtered out because they have been identified as duplicate, or as weaker
than another dependency).
.SH OPTIONS
.B dpkg\-shlibdeps
interprets non-option arguments as executable names, just as if they'd
been supplied as
.BI \-e executable\fR.
.TP
.BI \-e executable
Include dependencies appropriate for the shared libraries required by
.IR executable .
This option can be used multiple times.
.TP
.BI \-l directory
Prepend
.I directory
to the list of directories to search for private shared libraries
(since dpkg 1.17.0). This option can be used multiple times.

Note: Use this option instead of setting \fBLD_LIBRARY_PATH\fP,
as that environment variable is used to control the run-time linker
and abusing it to set the shared library paths at build-time can be
problematic when cross-compiling for example.
.TP
.BI \-d dependency-field
Add dependencies to be added to the control file dependency field
.IR dependency-field .
(The dependencies for this field are placed in the variable
.BI shlibs: dependency-field\fR.)

The
.BI \-d dependency-field
option takes effect for all executables after the option, until the
next
.BI \-d dependency-field\fR.
The default
.I dependency-field
is
.BR Depends .

If the same dependency entry (or set of alternatives) appears in more
than one of the recognized dependency field names
.BR Pre\-Depends ", " Depends ", " Recommends ", " Enhances " or " Suggests
then
.B dpkg\-shlibdeps
will automatically remove the dependency from all fields except the
one representing the most important dependencies.
.TP
.BI \-p varname-prefix
Start substitution variables with
.IB varname-prefix :
instead of
.BR shlibs: .
Likewise, any existing substitution variables starting with
.IB varname-prefix :
(rather than
.BR shlibs: )
are removed from the substitution variables file.
.TP
.BR \-O [\fIfilename\fP]
Print substitution variable settings to standard output (or \fIfilename\fP
if specified, since dpkg 1.17.2), rather than being added to the
substitution variables file
.RB ( debian/substvars
by default).
.TP
.BI \-t type
Prefer shared library dependency information tagged for the given
package type. If no tagged information is available, falls back to untagged
information. The default package type is \fBdeb\fP. Shared library dependency
information is tagged for a given type by prefixing it with the name of the
type, a colon, and whitespace.
.TP
.BI \-L local-shlibs-file
Read overriding shared library dependency information from
.I local-shlibs-file
instead of
.BR debian/shlibs.local .
.TP
.BI \-T substvars-file
Write substitution variables in
.IR substvars-file ;
the default is
.BR debian/substvars .
.TP
.BI \-v
Enable verbose mode (since dpkg 1.14.8).
Numerous messages are displayed to explain what
.B dpkg\-shlibdeps
does.
.TP
.BI \-x package
Exclude the package from the generated dependencies (since dpkg 1.14.8).
This is useful to
avoid self-dependencies for packages which provide ELF binaries
(executables or library plugins) using a library contained in the same
package. This option can be used multiple times to exclude several
packages.
.TP
.BI \-S package-build-dir
Look into \fIpackage-build-dir\fP first when trying to find a library
(since dpkg 1.14.15).
This is
useful when the source package builds multiple flavors of the same library
and you want to ensure that you get the dependency from a given binary
package. You can use this option multiple times: directories will be
tried in the same order before directories of other binary packages.
.TP
.BI \-I package-build-dir
Ignore \fIpackage-build-dir\fP when looking for shlibs, symbols, and shared
library files (since dpkg 1.18.5).
You can use this option multiple times.
.TP
.BI \-\-ignore\-missing\-info
Do not fail if dependency information can't be found for a shared library
(since dpkg 1.14.8).
Usage of this option is discouraged, all libraries should provide
dependency information (either with shlibs files, or with symbols files)
even if they are not yet used by other packages.
.TP
.BI \-\-warnings= value
\fIvalue\fP is a bit field defining the set of warnings that
can be emitted by \fBdpkg\-shlibdeps\fP (since dpkg 1.14.17).
Bit 0 (value=1) enables the warning “symbol \fIsym\fP used by \fIbinary\fP
found in none of the libraries”, bit 1 (value=2) enables the warning
“package could avoid a useless dependency” and bit 2 (value=4) enables
the warning “\fIbinary\fP should not be linked against \fIlibrary\fP”.
The default \fIvalue\fP is 3: the first two warnings are active by
default, the last one is not. Set \fIvalue\fP to 7 if you want all
warnings to be active.
.TP
.BI \-\-admindir= dir
Change the location of the \fBdpkg\fR database (since dpkg 1.14.0).
The default location is \fI%ADMINDIR%\fP.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH DIAGNOSTICS
.SS Warnings
Since
.B dpkg\-shlibdeps
analyzes the set of symbols used by each binary of the generated package,
it is able to emit warnings in several cases. They inform you of things
that can be improved in the package. In most cases, those improvements
concern the upstream sources directly. By order of decreasing importance,
here are the various warnings that you can encounter:
.TP
.BI symbol " sym" " used by " binary " found in none of the libraries."
The indicated symbol has not been found in the libraries linked with the
binary. The \fIbinary\fR is most likely a library and it needs to be linked
with an additional library during the build process (option
\fB\-l\fR\fIlibrary\fR of the linker).
.TP
.IB binary " contains an unresolvable reference to symbol " sym ": it's probably a plugin
The indicated symbol has not been found in the libraries linked with the
binary. The \fIbinary\fR is most likely a plugin and the symbol is
probably provided by the program that loads this plugin. In theory a
plugin doesn't have any SONAME but this binary does have one and as such
it could not be clearly identified as such. However the fact that the
binary is stored in a non-public directory is a strong indication
that's it's not a normal shared library. If the binary is really a
plugin, then disregard this warning. But there's always the possibility
that it's a real library and that programs linking to it are using an
RPATH so that the dynamic loader finds it. In that case, the library is
broken and needs to be fixed.
.TP
.BI "package could avoid a useless dependency if " binary " was not linked against " library " (it uses none of the library's symbols)"
None of the \fIbinaries\fP that are linked with \fPlibrary\fP use any of the
symbols provided by the library. By fixing all the binaries, you would avoid
the dependency associated to this library (unless the same dependency is
also generated by another library that is really used).
.TP
.BI "package could avoid a useless dependency if " binaries " were not linked against " library " (they use none of the library's symbols)"
Exactly the same as the above warning, but for multiple binaries.
.TP
.IB binary " should not be linked against " library " (it uses none of the library's symbols)"
The \fIbinary\fR is linked to a library that it doesn't need. It's not a
problem but some small performance improvements in binary load time can be
obtained by not linking this library to this binary. This warning checks
the same information as the previous one but does it for each binary
instead of doing the check globally on all binaries analyzed.
.SS Errors
.B dpkg\-shlibdeps
will fail if it can't find a public library used by a binary or if this
library has no associated dependency information (either shlibs file or
symbols file). A public library has a SONAME and is versioned
(libsomething.so.\fIX\fR). A private library (like a plugin) should not
have a SONAME and doesn't need to be versioned.
.TP
.BI "couldn't find library " library-soname " needed by " binary " (its RPATH is '" rpath "')"
The \fIbinary\fR uses a library called \fIlibrary-soname\fR but
.B dpkg\-shlibdeps
has been unable to find the library.
.B dpkg\-shlibdeps
creates a list of directories to check as following: directories listed in
the RPATH of the binary, directories added by the \fB\-l\fP option, directories
listed in the \fBLD_LIBRARY_PATH\fP environment variable, cross multiarch
directories (ex. /lib/arm64-linux-gnu, /usr/lib/arm64-linux-gnu), standard
public directories (/lib, /usr/lib), directories listed in /etc/ld.so.conf,
and obsolete multilib directories (/lib32, /usr/lib32, /lib64, /usr/lib64).
Then it checks those directories in the package's build tree
of the binary being analyzed, in the packages' build trees indicated with
the \fB\-S\fP command-line option, in other packages' build trees that contains
a DEBIAN/shlibs or DEBIAN/symbols file and finally in the root directory.
If the library is not found in any of those directories, then you get this
error.

If the library not found is in a private directory of the same package,
then you want to add the directory with \fB\-l\fP. If it's in another
binary package being built, you want to make sure that the shlibs/symbols
file of this package is already created and that \fB\-l\fP
contains the appropriate directory if it also is in a private directory.
.TP
.BI "no dependency information found for " library-file " (used by " binary ")."
The library needed by \fIbinary\fR has been found by
.B dpkg\-shlibdeps
in \fIlibrary-file\fR but
.B dpkg\-shlibdeps
has been unable to find any dependency information for that library. To
find out the dependency, it has tried to map the library to a Debian
package with the help of
.BI "dpkg \-S " library-file\fR.
Then it checked the corresponding shlibs and symbols files in
%ADMINDIR%/info/, and in the various package's build trees
(debian/*/DEBIAN/).

This failure can be caused by a bad or missing shlibs or symbols file
in the package of the library. It might also happen if the library is
built within the same source package and if the shlibs files has not yet
been created (in which case you must fix debian/rules to create
the shlibs before calling \fBdpkg\-shlibdeps\fR). Bad RPATH can also
lead to the library being found under a non-canonical name (example:
/usr/lib/openoffice.org/../lib/libssl.so.0.9.8 instead of
/usr/lib/libssl.so.0.9.8) that's not associated to any package,
.B dpkg\-shlibdeps
tries to work around this by trying to fallback on a canonical name (using
.BR realpath (3))
but it might not always work. It's always best to clean up the RPATH
of the binary to avoid problems.

Calling
.B dpkg\-shlibdeps
in verbose mode (\fB\-v\fP) will provide much more information about where it
tried to find the dependency information. This might be useful if you
don't understand why it's giving you this error.
.SH SEE ALSO
.BR deb\-shlibs (5),
.BR deb\-symbols (5),
.BR dpkg\-gensymbols (1).
