/*
 * Copyright 2016-2024 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * https://www.openssl.org/source/license.html
 * or in the file LICENSE in the source distribution.
 */

/* Shamelessly copied from BoringSSL and converted to C. */

/* Test first part of SSL server handshake. */

/* We need to use some deprecated APIs */
#define OPENSSL_SUPPRESS_DEPRECATED

#include <time.h>
#include <openssl/rand.h>
#include <openssl/ssl.h>
#include <openssl/rsa.h>
#include <openssl/dsa.h>
#include <openssl/ec.h>
#include <openssl/dh.h>
#include <openssl/err.h>
#include "fuzzer.h"

/*
-----BEGIN CERTIFICATE-----
MIIDozCCAougAwIBAgIUSKwQD1qRtS+lridawmaYK6cej2kwDQYJKoZIhvcNAQEL
BQAwYTELMAkGA1UEBhMCbm8xCzAJBgNVBAgMAm5vMQswCQYDVQQHDAJubzELMAkG
A1UECgwCbm8xCzAJBgNVBAsMAm5vMQswCQYDVQQDDAJubzERMA8GCSqGSIb3DQEJ
ARYCbm8wHhcNMjQwMjI4MTkzNzEwWhcNMjUwMjI3MTkzNzEwWjBhMQswCQYDVQQG
EwJubzELMAkGA1UECAwCbm8xCzAJBgNVBAcMAm5vMQswCQYDVQQKDAJubzELMAkG
A1UECwwCbm8xCzAJBgNVBAMMAm5vMREwDwYJKoZIhvcNAQkBFgJubzCCASIwDQYJ
KoZIhvcNAQEBBQADggEPADCCAQoCggEBALWZB9Mtas0V9Sya+UhEabwzs3Eol+/M
hwUFWIFrr8tVyYvg8Xs/KnC2VaEpnEltBNLaOADZGUuXzz5Ebccb2i18ghvMDX5o
OwAAidL3tv6lh8/Vuj8tpLA53SDR5VTQcxitipsccjacHDftTqDA7+94STT8QSHt
Wu5FmXPKvJLmPuKQJMbOJSGDJLvdT/0dyM9aU3xKw64iv7S3laERWyW4/OemMQXs
i+kbanpVNJVmqTtS+q/FyYvvr1NpX0Oc/A5H2HYQ6f6P3nvJ22IOXoIcNjI1FmKb
X3NJHetHXtyZKXcfpizljsNvbffsL6twxjjCR3JdUqP1xECeuoLBMzkCAwEAAaNT
MFEwHQYDVR0OBBYEFKZ2b9IJ3YWCYyMkROjtjF7CxsfaMB8GA1UdIwQYMBaAFKZ2
b9IJ3YWCYyMkROjtjF7CxsfaMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL
BQADggEBAGJoHDTsAiuRtACTGiGz/oyNZfH/OUJaijUMaLbHd/JG2L6gtpACYY2b
AoLkIcCl38nsLYMLZ32Bbc5jnP/Qy3d2HKsTJ5It4qxDgtbtpU8e5MhEeJoeMHOC
fizbcWc7W7m2SLfpeQJWMgu2Da0HYEDS/xzLn7pxQgZpOrMQ7Ihi1jwXfKFqIIal
g6SijRGXh7onEAxEmKLkpVQRq633BYPV6odxtXDhxyJKyGjSJsQoKv9oCF2kAdAi
CvvatqRWRwgIeln1Sw9Ee6cTYZCG2U+/Uf+Ls7fjN8trb/Shmxo8do/npBnz8j+1
a2vbz3gpOsl87U0c01JCl9SZXDSO09w=
-----END CERTIFICATE-----
 */
static const uint8_t RSACertificatePEM[] = {
0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49,
0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x44,
0x6f, 0x7a, 0x43, 0x43, 0x41, 0x6f, 0x75, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55,
0x53, 0x4b, 0x77, 0x51, 0x44, 0x31, 0x71, 0x52, 0x74, 0x53, 0x2b, 0x6c, 0x72, 0x69, 0x64, 0x61,
0x77, 0x6d, 0x61, 0x59, 0x4b, 0x36, 0x63, 0x65, 0x6a, 0x32, 0x6b, 0x77, 0x44, 0x51, 0x59, 0x4a,
0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x4c, 0x0a, 0x42, 0x51, 0x41,
0x77, 0x59, 0x54, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47, 0x41, 0x31, 0x55, 0x45, 0x42, 0x68, 0x4d,
0x43, 0x62, 0x6d, 0x38, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x67,
0x4d, 0x41, 0x6d, 0x35, 0x76, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51,
0x48, 0x44, 0x41, 0x4a, 0x75, 0x62, 0x7a, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47, 0x0a, 0x41, 0x31,
0x55, 0x45, 0x43, 0x67, 0x77, 0x43, 0x62, 0x6d, 0x38, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67,
0x4e, 0x56, 0x42, 0x41, 0x73, 0x4d, 0x41, 0x6d, 0x35, 0x76, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51,
0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x44, 0x41, 0x4a, 0x75, 0x62, 0x7a, 0x45, 0x52, 0x4d, 0x41,
0x38, 0x47, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44, 0x51, 0x45, 0x4a, 0x0a, 0x41,
0x52, 0x59, 0x43, 0x62, 0x6d, 0x38, 0x77, 0x48, 0x68, 0x63, 0x4e, 0x4d, 0x6a, 0x51, 0x77, 0x4d,
0x6a, 0x49, 0x34, 0x4d, 0x54, 0x6b, 0x7a, 0x4e, 0x7a, 0x45, 0x77, 0x57, 0x68, 0x63, 0x4e, 0x4d,
0x6a, 0x55, 0x77, 0x4d, 0x6a, 0x49, 0x33, 0x4d, 0x54, 0x6b, 0x7a, 0x4e, 0x7a, 0x45, 0x77, 0x57,
0x6a, 0x42, 0x68, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x0a,
0x45, 0x77, 0x4a, 0x75, 0x62, 0x7a, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47, 0x41, 0x31, 0x55, 0x45,
0x43, 0x41, 0x77, 0x43, 0x62, 0x6d, 0x38, 0x78, 0x43, 0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56,
0x42, 0x41, 0x63, 0x4d, 0x41, 0x6d, 0x35, 0x76, 0x4d, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59, 0x44,
0x56, 0x51, 0x51, 0x4b, 0x44, 0x41, 0x4a, 0x75, 0x62, 0x7a, 0x45, 0x4c, 0x4d, 0x41, 0x6b, 0x47,
0x0a, 0x41, 0x31, 0x55, 0x45, 0x43, 0x77, 0x77, 0x43, 0x62, 0x6d, 0x38, 0x78, 0x43, 0x7a, 0x41,
0x4a, 0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x4d, 0x4d, 0x41, 0x6d, 0x35, 0x76, 0x4d, 0x52, 0x45,
0x77, 0x44, 0x77, 0x59, 0x4a, 0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x6b,
0x42, 0x46, 0x67, 0x4a, 0x75, 0x62, 0x7a, 0x43, 0x43, 0x41, 0x53, 0x49, 0x77, 0x44, 0x51, 0x59,
0x4a, 0x0a, 0x4b, 0x6f, 0x5a, 0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x42, 0x42, 0x51,
0x41, 0x44, 0x67, 0x67, 0x45, 0x50, 0x41, 0x44, 0x43, 0x43, 0x41, 0x51, 0x6f, 0x43, 0x67, 0x67,
0x45, 0x42, 0x41, 0x4c, 0x57, 0x5a, 0x42, 0x39, 0x4d, 0x74, 0x61, 0x73, 0x30, 0x56, 0x39, 0x53,
0x79, 0x61, 0x2b, 0x55, 0x68, 0x45, 0x61, 0x62, 0x77, 0x7a, 0x73, 0x33, 0x45, 0x6f, 0x6c, 0x2b,
0x2f, 0x4d, 0x0a, 0x68, 0x77, 0x55, 0x46, 0x57, 0x49, 0x46, 0x72, 0x72, 0x38, 0x74, 0x56, 0x79,
0x59, 0x76, 0x67, 0x38, 0x58, 0x73, 0x2f, 0x4b, 0x6e, 0x43, 0x32, 0x56, 0x61, 0x45, 0x70, 0x6e,
0x45, 0x6c, 0x74, 0x42, 0x4e, 0x4c, 0x61, 0x4f, 0x41, 0x44, 0x5a, 0x47, 0x55, 0x75, 0x58, 0x7a,
0x7a, 0x35, 0x45, 0x62, 0x63, 0x63, 0x62, 0x32, 0x69, 0x31, 0x38, 0x67, 0x68, 0x76, 0x4d, 0x44,
0x58, 0x35, 0x6f, 0x0a, 0x4f, 0x77, 0x41, 0x41, 0x69, 0x64, 0x4c, 0x33, 0x74, 0x76, 0x36, 0x6c,
0x68, 0x38, 0x2f, 0x56, 0x75, 0x6a, 0x38, 0x74, 0x70, 0x4c, 0x41, 0x35, 0x33, 0x53, 0x44, 0x52,
0x35, 0x56, 0x54, 0x51, 0x63, 0x78, 0x69, 0x74, 0x69, 0x70, 0x73, 0x63, 0x63, 0x6a, 0x61, 0x63,
0x48, 0x44, 0x66, 0x74, 0x54, 0x71, 0x44, 0x41, 0x37, 0x2b, 0x39, 0x34, 0x53, 0x54, 0x54, 0x38,
0x51, 0x53, 0x48, 0x74, 0x0a, 0x57, 0x75, 0x35, 0x46, 0x6d, 0x58, 0x50, 0x4b, 0x76, 0x4a, 0x4c,
0x6d, 0x50, 0x75, 0x4b, 0x51, 0x4a, 0x4d, 0x62, 0x4f, 0x4a, 0x53, 0x47, 0x44, 0x4a, 0x4c, 0x76,
0x64, 0x54, 0x2f, 0x30, 0x64, 0x79, 0x4d, 0x39, 0x61, 0x55, 0x33, 0x78, 0x4b, 0x77, 0x36, 0x34,
0x69, 0x76, 0x37, 0x53, 0x33, 0x6c, 0x61, 0x45, 0x52, 0x57, 0x79, 0x57, 0x34, 0x2f, 0x4f, 0x65,
0x6d, 0x4d, 0x51, 0x58, 0x73, 0x0a, 0x69, 0x2b, 0x6b, 0x62, 0x61, 0x6e, 0x70, 0x56, 0x4e, 0x4a,
0x56, 0x6d, 0x71, 0x54, 0x74, 0x53, 0x2b, 0x71, 0x2f, 0x46, 0x79, 0x59, 0x76, 0x76, 0x72, 0x31,
0x4e, 0x70, 0x58, 0x30, 0x4f, 0x63, 0x2f, 0x41, 0x35, 0x48, 0x32, 0x48, 0x59, 0x51, 0x36, 0x66,
0x36, 0x50, 0x33, 0x6e, 0x76, 0x4a, 0x32, 0x32, 0x49, 0x4f, 0x58, 0x6f, 0x49, 0x63, 0x4e, 0x6a,
0x49, 0x31, 0x46, 0x6d, 0x4b, 0x62, 0x0a, 0x58, 0x33, 0x4e, 0x4a, 0x48, 0x65, 0x74, 0x48, 0x58,
0x74, 0x79, 0x5a, 0x4b, 0x58, 0x63, 0x66, 0x70, 0x69, 0x7a, 0x6c, 0x6a, 0x73, 0x4e, 0x76, 0x62,
0x66, 0x66, 0x73, 0x4c, 0x36, 0x74, 0x77, 0x78, 0x6a, 0x6a, 0x43, 0x52, 0x33, 0x4a, 0x64, 0x55,
0x71, 0x50, 0x31, 0x78, 0x45, 0x43, 0x65, 0x75, 0x6f, 0x4c, 0x42, 0x4d, 0x7a, 0x6b, 0x43, 0x41,
0x77, 0x45, 0x41, 0x41, 0x61, 0x4e, 0x54, 0x0a, 0x4d, 0x46, 0x45, 0x77, 0x48, 0x51, 0x59, 0x44,
0x56, 0x52, 0x30, 0x4f, 0x42, 0x42, 0x59, 0x45, 0x46, 0x4b, 0x5a, 0x32, 0x62, 0x39, 0x49, 0x4a,
0x33, 0x59, 0x57, 0x43, 0x59, 0x79, 0x4d, 0x6b, 0x52, 0x4f, 0x6a, 0x74, 0x6a, 0x46, 0x37, 0x43,
0x78, 0x73, 0x66, 0x61, 0x4d, 0x42, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64, 0x49, 0x77, 0x51, 0x59,
0x4d, 0x42, 0x61, 0x41, 0x46, 0x4b, 0x5a, 0x32, 0x0a, 0x62, 0x39, 0x49, 0x4a, 0x33, 0x59, 0x57,
0x43, 0x59, 0x79, 0x4d, 0x6b, 0x52, 0x4f, 0x6a, 0x74, 0x6a, 0x46, 0x37, 0x43, 0x78, 0x73, 0x66,
0x61, 0x4d, 0x41, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45, 0x77, 0x45, 0x42, 0x2f, 0x77, 0x51,
0x46, 0x4d, 0x41, 0x4d, 0x42, 0x41, 0x66, 0x38, 0x77, 0x44, 0x51, 0x59, 0x4a, 0x4b, 0x6f, 0x5a,
0x49, 0x68, 0x76, 0x63, 0x4e, 0x41, 0x51, 0x45, 0x4c, 0x0a, 0x42, 0x51, 0x41, 0x44, 0x67, 0x67,
0x45, 0x42, 0x41, 0x47, 0x4a, 0x6f, 0x48, 0x44, 0x54, 0x73, 0x41, 0x69, 0x75, 0x52, 0x74, 0x41,
0x43, 0x54, 0x47, 0x69, 0x47, 0x7a, 0x2f, 0x6f, 0x79, 0x4e, 0x5a, 0x66, 0x48, 0x2f, 0x4f, 0x55,
0x4a, 0x61, 0x69, 0x6a, 0x55, 0x4d, 0x61, 0x4c, 0x62, 0x48, 0x64, 0x2f, 0x4a, 0x47, 0x32, 0x4c,
0x36, 0x67, 0x74, 0x70, 0x41, 0x43, 0x59, 0x59, 0x32, 0x62, 0x0a, 0x41, 0x6f, 0x4c, 0x6b, 0x49,
0x63, 0x43, 0x6c, 0x33, 0x38, 0x6e, 0x73, 0x4c, 0x59, 0x4d, 0x4c, 0x5a, 0x33, 0x32, 0x42, 0x62,
0x63, 0x35, 0x6a, 0x6e, 0x50, 0x2f, 0x51, 0x79, 0x33, 0x64, 0x32, 0x48, 0x4b, 0x73, 0x54, 0x4a,
0x35, 0x49, 0x74, 0x34, 0x71, 0x78, 0x44, 0x67, 0x74, 0x62, 0x74, 0x70, 0x55, 0x38, 0x65, 0x35,
0x4d, 0x68, 0x45, 0x65, 0x4a, 0x6f, 0x65, 0x4d, 0x48, 0x4f, 0x43, 0x0a, 0x66, 0x69, 0x7a, 0x62,
0x63, 0x57, 0x63, 0x37, 0x57, 0x37, 0x6d, 0x32, 0x53, 0x4c, 0x66, 0x70, 0x65, 0x51, 0x4a, 0x57,
0x4d, 0x67, 0x75, 0x32, 0x44, 0x61, 0x30, 0x48, 0x59, 0x45, 0x44, 0x53, 0x2f, 0x78, 0x7a, 0x4c,
0x6e, 0x37, 0x70, 0x78, 0x51, 0x67, 0x5a, 0x70, 0x4f, 0x72, 0x4d, 0x51, 0x37, 0x49, 0x68, 0x69,
0x31, 0x6a, 0x77, 0x58, 0x66, 0x4b, 0x46, 0x71, 0x49, 0x49, 0x61, 0x6c, 0x0a, 0x67, 0x36, 0x53,
0x69, 0x6a, 0x52, 0x47, 0x58, 0x68, 0x37, 0x6f, 0x6e, 0x45, 0x41, 0x78, 0x45, 0x6d, 0x4b, 0x4c,
0x6b, 0x70, 0x56, 0x51, 0x52, 0x71, 0x36, 0x33, 0x33, 0x42, 0x59, 0x50, 0x56, 0x36, 0x6f, 0x64,
0x78, 0x74, 0x58, 0x44, 0x68, 0x78, 0x79, 0x4a, 0x4b, 0x79, 0x47, 0x6a, 0x53, 0x4a, 0x73, 0x51,
0x6f, 0x4b, 0x76, 0x39, 0x6f, 0x43, 0x46, 0x32, 0x6b, 0x41, 0x64, 0x41, 0x69, 0x0a, 0x43, 0x76,
0x76, 0x61, 0x74, 0x71, 0x52, 0x57, 0x52, 0x77, 0x67, 0x49, 0x65, 0x6c, 0x6e, 0x31, 0x53, 0x77,
0x39, 0x45, 0x65, 0x36, 0x63, 0x54, 0x59, 0x5a, 0x43, 0x47, 0x32, 0x55, 0x2b, 0x2f, 0x55, 0x66,
0x2b, 0x4c, 0x73, 0x37, 0x66, 0x6a, 0x4e, 0x38, 0x74, 0x72, 0x62, 0x2f, 0x53, 0x68, 0x6d, 0x78,
0x6f, 0x38, 0x64, 0x6f, 0x2f, 0x6e, 0x70, 0x42, 0x6e, 0x7a, 0x38, 0x6a, 0x2b, 0x31, 0x0a, 0x61,
0x32, 0x76, 0x62, 0x7a, 0x33, 0x67, 0x70, 0x4f, 0x73, 0x6c, 0x38, 0x37, 0x55, 0x30, 0x63, 0x30,
0x31, 0x4a, 0x43, 0x6c, 0x39, 0x53, 0x5a, 0x58, 0x44, 0x53, 0x4f, 0x30, 0x39, 0x77, 0x3d, 0x0a,
0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
};

#ifndef OPENSSL_NO_DEPRECATED_3_0
/*
-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC1mQfTLWrNFfUs
mvlIRGm8M7NxKJfvzIcFBViBa6/LVcmL4PF7PypwtlWhKZxJbQTS2jgA2RlLl88+
RG3HG9otfIIbzA1+aDsAAInS97b+pYfP1bo/LaSwOd0g0eVU0HMYrYqbHHI2nBw3
7U6gwO/veEk0/EEh7VruRZlzyryS5j7ikCTGziUhgyS73U/9HcjPWlN8SsOuIr+0
t5WhEVsluPznpjEF7IvpG2p6VTSVZqk7UvqvxcmL769TaV9DnPwOR9h2EOn+j957
ydtiDl6CHDYyNRZim19zSR3rR17cmSl3H6Ys5Y7Db2337C+rcMY4wkdyXVKj9cRA
nrqCwTM5AgMBAAECggEAFOD+XFJZeDDxGmrLBHsRKRlMpVMEfQan83TU4zRtZtR7
MsDvIrt1drYQDFKLbInDRzbdv4M2fFF8+2zErmLOZ/JrxyRj3MfBGNP3BLGEcay4
e7XYDxGBYN2WRgK7+k9pHEo/qGvR2eOC/w8ivirQq1jKGfRyzKLMlJ6d8Qk7OyxZ
n0u3v2EJ9CWoNDgUH4exCil/Oe4h5WA59xT5NAkx4RUojsJiExWZpzT/VX1d21mN
WMb5EO8eyi6FyZlAcb9MID0kMF6Q3hUv+jTw+X9yig+3B9bg2Z0I+IKHl9InShkC
ndYn4ad0zd/ggMVkloomh4uaSqZxUi3ywtszZkRbzQKBgQD7Pvx1ErKm5lZDAS2b
b4rltzqJRUEKyEqjqzPzgasOa0jWEq/fxuGc/bixg/EBaQ8yyTGYdIYyr7DKYYjC
0AGVnBCh0+TFUDB1kfwkbef2b8yufQ/vJwcOJ+5kBXQZx8+L8U9iWKANXxkEeCX2
iWPZPz52pTTYlf90PLzEW6QyDwKBgQC5CKyfUwx3Ba2iXtfIreyPqDobbybyTEYk
ayA2oElSdejgVkWwJ+q77gwrnF5Pe9zbpUBoc7VJjrRhUojI7LOySyto3WYYoczX
LprzPnj2yEVeV2lrTS6lKNpdraO8QZcSD7mUUmiNRZnoPK16Mm9qjkk29HnY7Msq
pkiOg4huNwKBgQCkh2HBtOXjH/GbXVklcc0Ok4e0vvJSAknGlmWl7+M5xQ3kikY8
D7xNF2XscY/QsaDvTAu7X4tGBAGM9oQdtyNietn1b5JfmByz0U7B+Gsv2ZS7K1DU
9sTLA2E8hMm73DpQ1Ux8BbeCKiVy5M9PfDcz3BOmlJdfwhKQZvniyHRlBwKBgQCH
/sAhOcDnmdzMgjjG3k4IJ/TNRRyy6SyEh9fdTmGVoePPPplpp2z3Qzbetsb6VGc3
aHW2T5Tmw2QAQ9EVHCPW3zjAkjj/0avkW/S24yu09e1GMajhnJC0Axq7z2uQagTG
2ZfkU81UR9uevTojnf4Vqw5UvcrwjNmmNyEM3c/gcQKBgHa2dT5svzM1jReiO3Vt
dAUDztGKUE3clPV35L2xmJeJDXPOqCL3qoZ9A6hHmDw6gmg82gQDQeJbL/+jKkon
e6atH/Dfr+M4nPft9Lt4fOAWOQ3tDsDuCkOMjSTn8cLMZLGcwT2H1H2vBocM+UTd
hljAVnB9v6NMfcRERTx10SUc
-----END PRIVATE KEY-----
 */
static const uint8_t RSAPrivateKeyPEM[] = {
0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41,
0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x45,
0x76, 0x67, 0x49, 0x42, 0x41, 0x44, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47,
0x39, 0x77, 0x30, 0x42, 0x41, 0x51, 0x45, 0x46, 0x41, 0x41, 0x53, 0x43, 0x42, 0x4b, 0x67, 0x77,
0x67, 0x67, 0x53, 0x6b, 0x41, 0x67, 0x45, 0x41, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x51, 0x43, 0x31,
0x6d, 0x51, 0x66, 0x54, 0x4c, 0x57, 0x72, 0x4e, 0x46, 0x66, 0x55, 0x73, 0x0a, 0x6d, 0x76, 0x6c,
0x49, 0x52, 0x47, 0x6d, 0x38, 0x4d, 0x37, 0x4e, 0x78, 0x4b, 0x4a, 0x66, 0x76, 0x7a, 0x49, 0x63,
0x46, 0x42, 0x56, 0x69, 0x42, 0x61, 0x36, 0x2f, 0x4c, 0x56, 0x63, 0x6d, 0x4c, 0x34, 0x50, 0x46,
0x37, 0x50, 0x79, 0x70, 0x77, 0x74, 0x6c, 0x57, 0x68, 0x4b, 0x5a, 0x78, 0x4a, 0x62, 0x51, 0x54,
0x53, 0x32, 0x6a, 0x67, 0x41, 0x32, 0x52, 0x6c, 0x4c, 0x6c, 0x38, 0x38, 0x2b, 0x0a, 0x52, 0x47,
0x33, 0x48, 0x47, 0x39, 0x6f, 0x74, 0x66, 0x49, 0x49, 0x62, 0x7a, 0x41, 0x31, 0x2b, 0x61, 0x44,
0x73, 0x41, 0x41, 0x49, 0x6e, 0x53, 0x39, 0x37, 0x62, 0x2b, 0x70, 0x59, 0x66, 0x50, 0x31, 0x62,
0x6f, 0x2f, 0x4c, 0x61, 0x53, 0x77, 0x4f, 0x64, 0x30, 0x67, 0x30, 0x65, 0x56, 0x55, 0x30, 0x48,
0x4d, 0x59, 0x72, 0x59, 0x71, 0x62, 0x48, 0x48, 0x49, 0x32, 0x6e, 0x42, 0x77, 0x33, 0x0a, 0x37,
0x55, 0x36, 0x67, 0x77, 0x4f, 0x2f, 0x76, 0x65, 0x45, 0x6b, 0x30, 0x2f, 0x45, 0x45, 0x68, 0x37,
0x56, 0x72, 0x75, 0x52, 0x5a, 0x6c, 0x7a, 0x79, 0x72, 0x79, 0x53, 0x35, 0x6a, 0x37, 0x69, 0x6b,
0x43, 0x54, 0x47, 0x7a, 0x69, 0x55, 0x68, 0x67, 0x79, 0x53, 0x37, 0x33, 0x55, 0x2f, 0x39, 0x48,
0x63, 0x6a, 0x50, 0x57, 0x6c, 0x4e, 0x38, 0x53, 0x73, 0x4f, 0x75, 0x49, 0x72, 0x2b, 0x30, 0x0a,
0x74, 0x35, 0x57, 0x68, 0x45, 0x56, 0x73, 0x6c, 0x75, 0x50, 0x7a, 0x6e, 0x70, 0x6a, 0x45, 0x46,
0x37, 0x49, 0x76, 0x70, 0x47, 0x32, 0x70, 0x36, 0x56, 0x54, 0x53, 0x56, 0x5a, 0x71, 0x6b, 0x37,
0x55, 0x76, 0x71, 0x76, 0x78, 0x63, 0x6d, 0x4c, 0x37, 0x36, 0x39, 0x54, 0x61, 0x56, 0x39, 0x44,
0x6e, 0x50, 0x77, 0x4f, 0x52, 0x39, 0x68, 0x32, 0x45, 0x4f, 0x6e, 0x2b, 0x6a, 0x39, 0x35, 0x37,
0x0a, 0x79, 0x64, 0x74, 0x69, 0x44, 0x6c, 0x36, 0x43, 0x48, 0x44, 0x59, 0x79, 0x4e, 0x52, 0x5a,
0x69, 0x6d, 0x31, 0x39, 0x7a, 0x53, 0x52, 0x33, 0x72, 0x52, 0x31, 0x37, 0x63, 0x6d, 0x53, 0x6c,
0x33, 0x48, 0x36, 0x59, 0x73, 0x35, 0x59, 0x37, 0x44, 0x62, 0x32, 0x33, 0x33, 0x37, 0x43, 0x2b,
0x72, 0x63, 0x4d, 0x59, 0x34, 0x77, 0x6b, 0x64, 0x79, 0x58, 0x56, 0x4b, 0x6a, 0x39, 0x63, 0x52,
0x41, 0x0a, 0x6e, 0x72, 0x71, 0x43, 0x77, 0x54, 0x4d, 0x35, 0x41, 0x67, 0x4d, 0x42, 0x41, 0x41,
0x45, 0x43, 0x67, 0x67, 0x45, 0x41, 0x46, 0x4f, 0x44, 0x2b, 0x58, 0x46, 0x4a, 0x5a, 0x65, 0x44,
0x44, 0x78, 0x47, 0x6d, 0x72, 0x4c, 0x42, 0x48, 0x73, 0x52, 0x4b, 0x52, 0x6c, 0x4d, 0x70, 0x56,
0x4d, 0x45, 0x66, 0x51, 0x61, 0x6e, 0x38, 0x33, 0x54, 0x55, 0x34, 0x7a, 0x52, 0x74, 0x5a, 0x74,
0x52, 0x37, 0x0a, 0x4d, 0x73, 0x44, 0x76, 0x49, 0x72, 0x74, 0x31, 0x64, 0x72, 0x59, 0x51, 0x44,
0x46, 0x4b, 0x4c, 0x62, 0x49, 0x6e, 0x44, 0x52, 0x7a, 0x62, 0x64, 0x76, 0x34, 0x4d, 0x32, 0x66,
0x46, 0x46, 0x38, 0x2b, 0x32, 0x7a, 0x45, 0x72, 0x6d, 0x4c, 0x4f, 0x5a, 0x2f, 0x4a, 0x72, 0x78,
0x79, 0x52, 0x6a, 0x33, 0x4d, 0x66, 0x42, 0x47, 0x4e, 0x50, 0x33, 0x42, 0x4c, 0x47, 0x45, 0x63,
0x61, 0x79, 0x34, 0x0a, 0x65, 0x37, 0x58, 0x59, 0x44, 0x78, 0x47, 0x42, 0x59, 0x4e, 0x32, 0x57,
0x52, 0x67, 0x4b, 0x37, 0x2b, 0x6b, 0x39, 0x70, 0x48, 0x45, 0x6f, 0x2f, 0x71, 0x47, 0x76, 0x52,
0x32, 0x65, 0x4f, 0x43, 0x2f, 0x77, 0x38, 0x69, 0x76, 0x69, 0x72, 0x51, 0x71, 0x31, 0x6a, 0x4b,
0x47, 0x66, 0x52, 0x79, 0x7a, 0x4b, 0x4c, 0x4d, 0x6c, 0x4a, 0x36, 0x64, 0x38, 0x51, 0x6b, 0x37,
0x4f, 0x79, 0x78, 0x5a, 0x0a, 0x6e, 0x30, 0x75, 0x33, 0x76, 0x32, 0x45, 0x4a, 0x39, 0x43, 0x57,
0x6f, 0x4e, 0x44, 0x67, 0x55, 0x48, 0x34, 0x65, 0x78, 0x43, 0x69, 0x6c, 0x2f, 0x4f, 0x65, 0x34,
0x68, 0x35, 0x57, 0x41, 0x35, 0x39, 0x78, 0x54, 0x35, 0x4e, 0x41, 0x6b, 0x78, 0x34, 0x52, 0x55,
0x6f, 0x6a, 0x73, 0x4a, 0x69, 0x45, 0x78, 0x57, 0x5a, 0x70, 0x7a, 0x54, 0x2f, 0x56, 0x58, 0x31,
0x64, 0x32, 0x31, 0x6d, 0x4e, 0x0a, 0x57, 0x4d, 0x62, 0x35, 0x45, 0x4f, 0x38, 0x65, 0x79, 0x69,
0x36, 0x46, 0x79, 0x5a, 0x6c, 0x41, 0x63, 0x62, 0x39, 0x4d, 0x49, 0x44, 0x30, 0x6b, 0x4d, 0x46,
0x36, 0x51, 0x33, 0x68, 0x55, 0x76, 0x2b, 0x6a, 0x54, 0x77, 0x2b, 0x58, 0x39, 0x79, 0x69, 0x67,
0x2b, 0x33, 0x42, 0x39, 0x62, 0x67, 0x32, 0x5a, 0x30, 0x49, 0x2b, 0x49, 0x4b, 0x48, 0x6c, 0x39,
0x49, 0x6e, 0x53, 0x68, 0x6b, 0x43, 0x0a, 0x6e, 0x64, 0x59, 0x6e, 0x34, 0x61, 0x64, 0x30, 0x7a,
0x64, 0x2f, 0x67, 0x67, 0x4d, 0x56, 0x6b, 0x6c, 0x6f, 0x6f, 0x6d, 0x68, 0x34, 0x75, 0x61, 0x53,
0x71, 0x5a, 0x78, 0x55, 0x69, 0x33, 0x79, 0x77, 0x74, 0x73, 0x7a, 0x5a, 0x6b, 0x52, 0x62, 0x7a,
0x51, 0x4b, 0x42, 0x67, 0x51, 0x44, 0x37, 0x50, 0x76, 0x78, 0x31, 0x45, 0x72, 0x4b, 0x6d, 0x35,
0x6c, 0x5a, 0x44, 0x41, 0x53, 0x32, 0x62, 0x0a, 0x62, 0x34, 0x72, 0x6c, 0x74, 0x7a, 0x71, 0x4a,
0x52, 0x55, 0x45, 0x4b, 0x79, 0x45, 0x71, 0x6a, 0x71, 0x7a, 0x50, 0x7a, 0x67, 0x61, 0x73, 0x4f,
0x61, 0x30, 0x6a, 0x57, 0x45, 0x71, 0x2f, 0x66, 0x78, 0x75, 0x47, 0x63, 0x2f, 0x62, 0x69, 0x78,
0x67, 0x2f, 0x45, 0x42, 0x61, 0x51, 0x38, 0x79, 0x79, 0x54, 0x47, 0x59, 0x64, 0x49, 0x59, 0x79,
0x72, 0x37, 0x44, 0x4b, 0x59, 0x59, 0x6a, 0x43, 0x0a, 0x30, 0x41, 0x47, 0x56, 0x6e, 0x42, 0x43,
0x68, 0x30, 0x2b, 0x54, 0x46, 0x55, 0x44, 0x42, 0x31, 0x6b, 0x66, 0x77, 0x6b, 0x62, 0x65, 0x66,
0x32, 0x62, 0x38, 0x79, 0x75, 0x66, 0x51, 0x2f, 0x76, 0x4a, 0x77, 0x63, 0x4f, 0x4a, 0x2b, 0x35,
0x6b, 0x42, 0x58, 0x51, 0x5a, 0x78, 0x38, 0x2b, 0x4c, 0x38, 0x55, 0x39, 0x69, 0x57, 0x4b, 0x41,
0x4e, 0x58, 0x78, 0x6b, 0x45, 0x65, 0x43, 0x58, 0x32, 0x0a, 0x69, 0x57, 0x50, 0x5a, 0x50, 0x7a,
0x35, 0x32, 0x70, 0x54, 0x54, 0x59, 0x6c, 0x66, 0x39, 0x30, 0x50, 0x4c, 0x7a, 0x45, 0x57, 0x36,
0x51, 0x79, 0x44, 0x77, 0x4b, 0x42, 0x67, 0x51, 0x43, 0x35, 0x43, 0x4b, 0x79, 0x66, 0x55, 0x77,
0x78, 0x33, 0x42, 0x61, 0x32, 0x69, 0x58, 0x74, 0x66, 0x49, 0x72, 0x65, 0x79, 0x50, 0x71, 0x44,
0x6f, 0x62, 0x62, 0x79, 0x62, 0x79, 0x54, 0x45, 0x59, 0x6b, 0x0a, 0x61, 0x79, 0x41, 0x32, 0x6f,
0x45, 0x6c, 0x53, 0x64, 0x65, 0x6a, 0x67, 0x56, 0x6b, 0x57, 0x77, 0x4a, 0x2b, 0x71, 0x37, 0x37,
0x67, 0x77, 0x72, 0x6e, 0x46, 0x35, 0x50, 0x65, 0x39, 0x7a, 0x62, 0x70, 0x55, 0x42, 0x6f, 0x63,
0x37, 0x56, 0x4a, 0x6a, 0x72, 0x52, 0x68, 0x55, 0x6f, 0x6a, 0x49, 0x37, 0x4c, 0x4f, 0x79, 0x53,
0x79, 0x74, 0x6f, 0x33, 0x57, 0x59, 0x59, 0x6f, 0x63, 0x7a, 0x58, 0x0a, 0x4c, 0x70, 0x72, 0x7a,
0x50, 0x6e, 0x6a, 0x32, 0x79, 0x45, 0x56, 0x65, 0x56, 0x32, 0x6c, 0x72, 0x54, 0x53, 0x36, 0x6c,
0x4b, 0x4e, 0x70, 0x64, 0x72, 0x61, 0x4f, 0x38, 0x51, 0x5a, 0x63, 0x53, 0x44, 0x37, 0x6d, 0x55,
0x55, 0x6d, 0x69, 0x4e, 0x52, 0x5a, 0x6e, 0x6f, 0x50, 0x4b, 0x31, 0x36, 0x4d, 0x6d, 0x39, 0x71,
0x6a, 0x6b, 0x6b, 0x32, 0x39, 0x48, 0x6e, 0x59, 0x37, 0x4d, 0x73, 0x71, 0x0a, 0x70, 0x6b, 0x69,
0x4f, 0x67, 0x34, 0x68, 0x75, 0x4e, 0x77, 0x4b, 0x42, 0x67, 0x51, 0x43, 0x6b, 0x68, 0x32, 0x48,
0x42, 0x74, 0x4f, 0x58, 0x6a, 0x48, 0x2f, 0x47, 0x62, 0x58, 0x56, 0x6b, 0x6c, 0x63, 0x63, 0x30,
0x4f, 0x6b, 0x34, 0x65, 0x30, 0x76, 0x76, 0x4a, 0x53, 0x41, 0x6b, 0x6e, 0x47, 0x6c, 0x6d, 0x57,
0x6c, 0x37, 0x2b, 0x4d, 0x35, 0x78, 0x51, 0x33, 0x6b, 0x69, 0x6b, 0x59, 0x38, 0x0a, 0x44, 0x37,
0x78, 0x4e, 0x46, 0x32, 0x58, 0x73, 0x63, 0x59, 0x2f, 0x51, 0x73, 0x61, 0x44, 0x76, 0x54, 0x41,
0x75, 0x37, 0x58, 0x34, 0x74, 0x47, 0x42, 0x41, 0x47, 0x4d, 0x39, 0x6f, 0x51, 0x64, 0x74, 0x79,
0x4e, 0x69, 0x65, 0x74, 0x6e, 0x31, 0x62, 0x35, 0x4a, 0x66, 0x6d, 0x42, 0x79, 0x7a, 0x30, 0x55,
0x37, 0x42, 0x2b, 0x47, 0x73, 0x76, 0x32, 0x5a, 0x53, 0x37, 0x4b, 0x31, 0x44, 0x55, 0x0a, 0x39,
0x73, 0x54, 0x4c, 0x41, 0x32, 0x45, 0x38, 0x68, 0x4d, 0x6d, 0x37, 0x33, 0x44, 0x70, 0x51, 0x31,
0x55, 0x78, 0x38, 0x42, 0x62, 0x65, 0x43, 0x4b, 0x69, 0x56, 0x79, 0x35, 0x4d, 0x39, 0x50, 0x66,
0x44, 0x63, 0x7a, 0x33, 0x42, 0x4f, 0x6d, 0x6c, 0x4a, 0x64, 0x66, 0x77, 0x68, 0x4b, 0x51, 0x5a,
0x76, 0x6e, 0x69, 0x79, 0x48, 0x52, 0x6c, 0x42, 0x77, 0x4b, 0x42, 0x67, 0x51, 0x43, 0x48, 0x0a,
0x2f, 0x73, 0x41, 0x68, 0x4f, 0x63, 0x44, 0x6e, 0x6d, 0x64, 0x7a, 0x4d, 0x67, 0x6a, 0x6a, 0x47,
0x33, 0x6b, 0x34, 0x49, 0x4a, 0x2f, 0x54, 0x4e, 0x52, 0x52, 0x79, 0x79, 0x36, 0x53, 0x79, 0x45,
0x68, 0x39, 0x66, 0x64, 0x54, 0x6d, 0x47, 0x56, 0x6f, 0x65, 0x50, 0x50, 0x50, 0x70, 0x6c, 0x70,
0x70, 0x32, 0x7a, 0x33, 0x51, 0x7a, 0x62, 0x65, 0x74, 0x73, 0x62, 0x36, 0x56, 0x47, 0x63, 0x33,
0x0a, 0x61, 0x48, 0x57, 0x32, 0x54, 0x35, 0x54, 0x6d, 0x77, 0x32, 0x51, 0x41, 0x51, 0x39, 0x45,
0x56, 0x48, 0x43, 0x50, 0x57, 0x33, 0x7a, 0x6a, 0x41, 0x6b, 0x6a, 0x6a, 0x2f, 0x30, 0x61, 0x76,
0x6b, 0x57, 0x2f, 0x53, 0x32, 0x34, 0x79, 0x75, 0x30, 0x39, 0x65, 0x31, 0x47, 0x4d, 0x61, 0x6a,
0x68, 0x6e, 0x4a, 0x43, 0x30, 0x41, 0x78, 0x71, 0x37, 0x7a, 0x32, 0x75, 0x51, 0x61, 0x67, 0x54,
0x47, 0x0a, 0x32, 0x5a, 0x66, 0x6b, 0x55, 0x38, 0x31, 0x55, 0x52, 0x39, 0x75, 0x65, 0x76, 0x54,
0x6f, 0x6a, 0x6e, 0x66, 0x34, 0x56, 0x71, 0x77, 0x35, 0x55, 0x76, 0x63, 0x72, 0x77, 0x6a, 0x4e,
0x6d, 0x6d, 0x4e, 0x79, 0x45, 0x4d, 0x33, 0x63, 0x2f, 0x67, 0x63, 0x51, 0x4b, 0x42, 0x67, 0x48,
0x61, 0x32, 0x64, 0x54, 0x35, 0x73, 0x76, 0x7a, 0x4d, 0x31, 0x6a, 0x52, 0x65, 0x69, 0x4f, 0x33,
0x56, 0x74, 0x0a, 0x64, 0x41, 0x55, 0x44, 0x7a, 0x74, 0x47, 0x4b, 0x55, 0x45, 0x33, 0x63, 0x6c,
0x50, 0x56, 0x33, 0x35, 0x4c, 0x32, 0x78, 0x6d, 0x4a, 0x65, 0x4a, 0x44, 0x58, 0x50, 0x4f, 0x71,
0x43, 0x4c, 0x33, 0x71, 0x6f, 0x5a, 0x39, 0x41, 0x36, 0x68, 0x48, 0x6d, 0x44, 0x77, 0x36, 0x67,
0x6d, 0x67, 0x38, 0x32, 0x67, 0x51, 0x44, 0x51, 0x65, 0x4a, 0x62, 0x4c, 0x2f, 0x2b, 0x6a, 0x4b,
0x6b, 0x6f, 0x6e, 0x0a, 0x65, 0x36, 0x61, 0x74, 0x48, 0x2f, 0x44, 0x66, 0x72, 0x2b, 0x4d, 0x34,
0x6e, 0x50, 0x66, 0x74, 0x39, 0x4c, 0x74, 0x34, 0x66, 0x4f, 0x41, 0x57, 0x4f, 0x51, 0x33, 0x74,
0x44, 0x73, 0x44, 0x75, 0x43, 0x6b, 0x4f, 0x4d, 0x6a, 0x53, 0x54, 0x6e, 0x38, 0x63, 0x4c, 0x4d,
0x5a, 0x4c, 0x47, 0x63, 0x77, 0x54, 0x32, 0x48, 0x31, 0x48, 0x32, 0x76, 0x42, 0x6f, 0x63, 0x4d,
0x2b, 0x55, 0x54, 0x64, 0x0a, 0x68, 0x6c, 0x6a, 0x41, 0x56, 0x6e, 0x42, 0x39, 0x76, 0x36, 0x4e,
0x4d, 0x66, 0x63, 0x52, 0x45, 0x52, 0x54, 0x78, 0x31, 0x30, 0x53, 0x55, 0x63, 0x0a, 0x2d, 0x2d,
0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b,
0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
};
#endif

#ifndef OPENSSL_NO_EC
# ifndef OPENSSL_NO_DEPRECATED_3_0
/*
-----BEGIN EC PRIVATE KEY-----
MHcCAQEEIJLyl7hJjpQL/RhP1x2zS79xdiPJQB683gWeqcqHPeZkoAoGCCqGSM49
AwEHoUQDQgAEdsjygVYjjaKBF4CNECVllNf017p5/MxNSWDoTHy9I2GeDwEDDazI
D/xy8JiYjtPKVE/Zqwbmivp2UwtH28a7NQ==
-----END EC PRIVATE KEY-----
 */
static const char ECDSAPrivateKeyPEM[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x45,
    0x43, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45,
    0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x48, 0x63, 0x43, 0x41,
    0x51, 0x45, 0x45, 0x49, 0x4a, 0x4c, 0x79, 0x6c, 0x37, 0x68, 0x4a, 0x6a,
    0x70, 0x51, 0x4c, 0x2f, 0x52, 0x68, 0x50, 0x31, 0x78, 0x32, 0x7a, 0x53,
    0x37, 0x39, 0x78, 0x64, 0x69, 0x50, 0x4a, 0x51, 0x42, 0x36, 0x38, 0x33,
    0x67, 0x57, 0x65, 0x71, 0x63, 0x71, 0x48, 0x50, 0x65, 0x5a, 0x6b, 0x6f,
    0x41, 0x6f, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x0a,
    0x41, 0x77, 0x45, 0x48, 0x6f, 0x55, 0x51, 0x44, 0x51, 0x67, 0x41, 0x45,
    0x64, 0x73, 0x6a, 0x79, 0x67, 0x56, 0x59, 0x6a, 0x6a, 0x61, 0x4b, 0x42,
    0x46, 0x34, 0x43, 0x4e, 0x45, 0x43, 0x56, 0x6c, 0x6c, 0x4e, 0x66, 0x30,
    0x31, 0x37, 0x70, 0x35, 0x2f, 0x4d, 0x78, 0x4e, 0x53, 0x57, 0x44, 0x6f,
    0x54, 0x48, 0x79, 0x39, 0x49, 0x32, 0x47, 0x65, 0x44, 0x77, 0x45, 0x44,
    0x44, 0x61, 0x7a, 0x49, 0x0a, 0x44, 0x2f, 0x78, 0x79, 0x38, 0x4a, 0x69,
    0x59, 0x6a, 0x74, 0x50, 0x4b, 0x56, 0x45, 0x2f, 0x5a, 0x71, 0x77, 0x62,
    0x6d, 0x69, 0x76, 0x70, 0x32, 0x55, 0x77, 0x74, 0x48, 0x32, 0x38, 0x61,
    0x37, 0x4e, 0x51, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
    0x4e, 0x44, 0x20, 0x45, 0x43, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54,
    0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};
# endif

/*
-----BEGIN CERTIFICATE-----
MIIBXzCCAQagAwIBAgIJAK6/Yvf/ain6MAoGCCqGSM49BAMCMBIxEDAOBgNVBAoM
B0FjbWUgQ28wHhcNMTYxMjI1MTEzOTI3WhcNMjYxMjI1MTEzOTI3WjASMRAwDgYD
VQQKDAdBY21lIENvMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdsjygVYjjaKB
F4CNECVllNf017p5/MxNSWDoTHy9I2GeDwEDDazID/xy8JiYjtPKVE/Zqwbmivp2
UwtH28a7NaNFMEMwCQYDVR0TBAIwADALBgNVHQ8EBAMCBaAwEwYDVR0lBAwwCgYI
KwYBBQUHAwEwFAYDVR0RBA0wC4IJbG9jYWxob3N0MAoGCCqGSM49BAMCA0cAMEQC
IEzr3t/jejVE9oSnBp8c3P2p+lDLVRrB8zxLyjZvirUXAiAyQPaE9MNcL8/nRpuu
99I1enCSmWIAJ57IwuJ/n1d45Q==
-----END CERTIFICATE-----
 */
static const char ECDSACertPEM[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43,
    0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42, 0x58, 0x7a, 0x43, 0x43,
    0x41, 0x51, 0x61, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x4a,
    0x41, 0x4b, 0x36, 0x2f, 0x59, 0x76, 0x66, 0x2f, 0x61, 0x69, 0x6e, 0x36,
    0x4d, 0x41, 0x6f, 0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39,
    0x42, 0x41, 0x4d, 0x43, 0x4d, 0x42, 0x49, 0x78, 0x45, 0x44, 0x41, 0x4f,
    0x42, 0x67, 0x4e, 0x56, 0x42, 0x41, 0x6f, 0x4d, 0x0a, 0x42, 0x30, 0x46,
    0x6a, 0x62, 0x57, 0x55, 0x67, 0x51, 0x32, 0x38, 0x77, 0x48, 0x68, 0x63,
    0x4e, 0x4d, 0x54, 0x59, 0x78, 0x4d, 0x6a, 0x49, 0x31, 0x4d, 0x54, 0x45,
    0x7a, 0x4f, 0x54, 0x49, 0x33, 0x57, 0x68, 0x63, 0x4e, 0x4d, 0x6a, 0x59,
    0x78, 0x4d, 0x6a, 0x49, 0x31, 0x4d, 0x54, 0x45, 0x7a, 0x4f, 0x54, 0x49,
    0x33, 0x57, 0x6a, 0x41, 0x53, 0x4d, 0x52, 0x41, 0x77, 0x44, 0x67, 0x59,
    0x44, 0x0a, 0x56, 0x51, 0x51, 0x4b, 0x44, 0x41, 0x64, 0x42, 0x59, 0x32,
    0x31, 0x6c, 0x49, 0x45, 0x4e, 0x76, 0x4d, 0x46, 0x6b, 0x77, 0x45, 0x77,
    0x59, 0x48, 0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x43, 0x41, 0x51,
    0x59, 0x49, 0x4b, 0x6f, 0x5a, 0x49, 0x7a, 0x6a, 0x30, 0x44, 0x41, 0x51,
    0x63, 0x44, 0x51, 0x67, 0x41, 0x45, 0x64, 0x73, 0x6a, 0x79, 0x67, 0x56,
    0x59, 0x6a, 0x6a, 0x61, 0x4b, 0x42, 0x0a, 0x46, 0x34, 0x43, 0x4e, 0x45,
    0x43, 0x56, 0x6c, 0x6c, 0x4e, 0x66, 0x30, 0x31, 0x37, 0x70, 0x35, 0x2f,
    0x4d, 0x78, 0x4e, 0x53, 0x57, 0x44, 0x6f, 0x54, 0x48, 0x79, 0x39, 0x49,
    0x32, 0x47, 0x65, 0x44, 0x77, 0x45, 0x44, 0x44, 0x61, 0x7a, 0x49, 0x44,
    0x2f, 0x78, 0x79, 0x38, 0x4a, 0x69, 0x59, 0x6a, 0x74, 0x50, 0x4b, 0x56,
    0x45, 0x2f, 0x5a, 0x71, 0x77, 0x62, 0x6d, 0x69, 0x76, 0x70, 0x32, 0x0a,
    0x55, 0x77, 0x74, 0x48, 0x32, 0x38, 0x61, 0x37, 0x4e, 0x61, 0x4e, 0x46,
    0x4d, 0x45, 0x4d, 0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x54,
    0x42, 0x41, 0x49, 0x77, 0x41, 0x44, 0x41, 0x4c, 0x42, 0x67, 0x4e, 0x56,
    0x48, 0x51, 0x38, 0x45, 0x42, 0x41, 0x4d, 0x43, 0x42, 0x61, 0x41, 0x77,
    0x45, 0x77, 0x59, 0x44, 0x56, 0x52, 0x30, 0x6c, 0x42, 0x41, 0x77, 0x77,
    0x43, 0x67, 0x59, 0x49, 0x0a, 0x4b, 0x77, 0x59, 0x42, 0x42, 0x51, 0x55,
    0x48, 0x41, 0x77, 0x45, 0x77, 0x46, 0x41, 0x59, 0x44, 0x56, 0x52, 0x30,
    0x52, 0x42, 0x41, 0x30, 0x77, 0x43, 0x34, 0x49, 0x4a, 0x62, 0x47, 0x39,
    0x6a, 0x59, 0x57, 0x78, 0x6f, 0x62, 0x33, 0x4e, 0x30, 0x4d, 0x41, 0x6f,
    0x47, 0x43, 0x43, 0x71, 0x47, 0x53, 0x4d, 0x34, 0x39, 0x42, 0x41, 0x4d,
    0x43, 0x41, 0x30, 0x63, 0x41, 0x4d, 0x45, 0x51, 0x43, 0x0a, 0x49, 0x45,
    0x7a, 0x72, 0x33, 0x74, 0x2f, 0x6a, 0x65, 0x6a, 0x56, 0x45, 0x39, 0x6f,
    0x53, 0x6e, 0x42, 0x70, 0x38, 0x63, 0x33, 0x50, 0x32, 0x70, 0x2b, 0x6c,
    0x44, 0x4c, 0x56, 0x52, 0x72, 0x42, 0x38, 0x7a, 0x78, 0x4c, 0x79, 0x6a,
    0x5a, 0x76, 0x69, 0x72, 0x55, 0x58, 0x41, 0x69, 0x41, 0x79, 0x51, 0x50,
    0x61, 0x45, 0x39, 0x4d, 0x4e, 0x63, 0x4c, 0x38, 0x2f, 0x6e, 0x52, 0x70,
    0x75, 0x75, 0x0a, 0x39, 0x39, 0x49, 0x31, 0x65, 0x6e, 0x43, 0x53, 0x6d,
    0x57, 0x49, 0x41, 0x4a, 0x35, 0x37, 0x49, 0x77, 0x75, 0x4a, 0x2f, 0x6e,
    0x31, 0x64, 0x34, 0x35, 0x51, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d,
    0x2d, 0x45, 0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
    0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};
#endif

#if !defined(OPENSSL_NO_DSA) && !defined(OPENSSL_NO_DEPRECATED_3_0)
/*
-----BEGIN DSA PRIVATE KEY-----
MIIBuwIBAAKBgQDdkFKzNABLOha7Eqj7004+p5fhtR6bxpujToMmSZTYi8igVVXP
Wzf03ULKS5UKjA6WpR6EiZAhm+PdxusZ5xfAuRZLdKy0bgxn1f348Rwh+EQNaEM8
0TGcnw5ijwKmSw5yyHPDWdiHzoqEBlhAf8Nl22YTXax/clsc/pu/RRLAdwIVAIEg
QqWRf/1EIZZcgM65Qpd65YuxAoGBAKBauV/RuloFHoSy5iWXESDywiS380tN5974
GukGwoYdZo5uSIH6ahpeNSef0MbHGAzr7ZVEnhCQfRAwH1gRvSHoq/Rbmcvtd3r+
QtQHOwvQHgLAynhI4i73c794czHaR+439bmcaSwDnQduRM85Mho/jiiZzAVPxBmG
POIMWNXXAoGAI6Ep5IE7yn3JzkXO9B6tC3bbDM+ZzuuInwZLbtZ8lim7Dsqabg4k
2YbE4R95Bnfwnjsyl80mq/DbQN5lAHBvjDrkC6ItojBGKI3+iIrqGUEJdxvl4ulj
F0PmSD7zvIG8BfocKOel+EHH0YryExiW6krV1KW2ZRmJrqSFw6KCjV0CFFQFbPfU
xy5PmKytJmXR8BmppkIO
-----END DSA PRIVATE KEY-----
 */
static const char DSAPrivateKeyPEM[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x44,
    0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b,
    0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42,
    0x75, 0x77, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x42, 0x67, 0x51, 0x44, 0x64,
    0x6b, 0x46, 0x4b, 0x7a, 0x4e, 0x41, 0x42, 0x4c, 0x4f, 0x68, 0x61, 0x37,
    0x45, 0x71, 0x6a, 0x37, 0x30, 0x30, 0x34, 0x2b, 0x70, 0x35, 0x66, 0x68,
    0x74, 0x52, 0x36, 0x62, 0x78, 0x70, 0x75, 0x6a, 0x54, 0x6f, 0x4d, 0x6d,
    0x53, 0x5a, 0x54, 0x59, 0x69, 0x38, 0x69, 0x67, 0x56, 0x56, 0x58, 0x50,
    0x0a, 0x57, 0x7a, 0x66, 0x30, 0x33, 0x55, 0x4c, 0x4b, 0x53, 0x35, 0x55,
    0x4b, 0x6a, 0x41, 0x36, 0x57, 0x70, 0x52, 0x36, 0x45, 0x69, 0x5a, 0x41,
    0x68, 0x6d, 0x2b, 0x50, 0x64, 0x78, 0x75, 0x73, 0x5a, 0x35, 0x78, 0x66,
    0x41, 0x75, 0x52, 0x5a, 0x4c, 0x64, 0x4b, 0x79, 0x30, 0x62, 0x67, 0x78,
    0x6e, 0x31, 0x66, 0x33, 0x34, 0x38, 0x52, 0x77, 0x68, 0x2b, 0x45, 0x51,
    0x4e, 0x61, 0x45, 0x4d, 0x38, 0x0a, 0x30, 0x54, 0x47, 0x63, 0x6e, 0x77,
    0x35, 0x69, 0x6a, 0x77, 0x4b, 0x6d, 0x53, 0x77, 0x35, 0x79, 0x79, 0x48,
    0x50, 0x44, 0x57, 0x64, 0x69, 0x48, 0x7a, 0x6f, 0x71, 0x45, 0x42, 0x6c,
    0x68, 0x41, 0x66, 0x38, 0x4e, 0x6c, 0x32, 0x32, 0x59, 0x54, 0x58, 0x61,
    0x78, 0x2f, 0x63, 0x6c, 0x73, 0x63, 0x2f, 0x70, 0x75, 0x2f, 0x52, 0x52,
    0x4c, 0x41, 0x64, 0x77, 0x49, 0x56, 0x41, 0x49, 0x45, 0x67, 0x0a, 0x51,
    0x71, 0x57, 0x52, 0x66, 0x2f, 0x31, 0x45, 0x49, 0x5a, 0x5a, 0x63, 0x67,
    0x4d, 0x36, 0x35, 0x51, 0x70, 0x64, 0x36, 0x35, 0x59, 0x75, 0x78, 0x41,
    0x6f, 0x47, 0x42, 0x41, 0x4b, 0x42, 0x61, 0x75, 0x56, 0x2f, 0x52, 0x75,
    0x6c, 0x6f, 0x46, 0x48, 0x6f, 0x53, 0x79, 0x35, 0x69, 0x57, 0x58, 0x45,
    0x53, 0x44, 0x79, 0x77, 0x69, 0x53, 0x33, 0x38, 0x30, 0x74, 0x4e, 0x35,
    0x39, 0x37, 0x34, 0x0a, 0x47, 0x75, 0x6b, 0x47, 0x77, 0x6f, 0x59, 0x64,
    0x5a, 0x6f, 0x35, 0x75, 0x53, 0x49, 0x48, 0x36, 0x61, 0x68, 0x70, 0x65,
    0x4e, 0x53, 0x65, 0x66, 0x30, 0x4d, 0x62, 0x48, 0x47, 0x41, 0x7a, 0x72,
    0x37, 0x5a, 0x56, 0x45, 0x6e, 0x68, 0x43, 0x51, 0x66, 0x52, 0x41, 0x77,
    0x48, 0x31, 0x67, 0x52, 0x76, 0x53, 0x48, 0x6f, 0x71, 0x2f, 0x52, 0x62,
    0x6d, 0x63, 0x76, 0x74, 0x64, 0x33, 0x72, 0x2b, 0x0a, 0x51, 0x74, 0x51,
    0x48, 0x4f, 0x77, 0x76, 0x51, 0x48, 0x67, 0x4c, 0x41, 0x79, 0x6e, 0x68,
    0x49, 0x34, 0x69, 0x37, 0x33, 0x63, 0x37, 0x39, 0x34, 0x63, 0x7a, 0x48,
    0x61, 0x52, 0x2b, 0x34, 0x33, 0x39, 0x62, 0x6d, 0x63, 0x61, 0x53, 0x77,
    0x44, 0x6e, 0x51, 0x64, 0x75, 0x52, 0x4d, 0x38, 0x35, 0x4d, 0x68, 0x6f,
    0x2f, 0x6a, 0x69, 0x69, 0x5a, 0x7a, 0x41, 0x56, 0x50, 0x78, 0x42, 0x6d,
    0x47, 0x0a, 0x50, 0x4f, 0x49, 0x4d, 0x57, 0x4e, 0x58, 0x58, 0x41, 0x6f,
    0x47, 0x41, 0x49, 0x36, 0x45, 0x70, 0x35, 0x49, 0x45, 0x37, 0x79, 0x6e,
    0x33, 0x4a, 0x7a, 0x6b, 0x58, 0x4f, 0x39, 0x42, 0x36, 0x74, 0x43, 0x33,
    0x62, 0x62, 0x44, 0x4d, 0x2b, 0x5a, 0x7a, 0x75, 0x75, 0x49, 0x6e, 0x77,
    0x5a, 0x4c, 0x62, 0x74, 0x5a, 0x38, 0x6c, 0x69, 0x6d, 0x37, 0x44, 0x73,
    0x71, 0x61, 0x62, 0x67, 0x34, 0x6b, 0x0a, 0x32, 0x59, 0x62, 0x45, 0x34,
    0x52, 0x39, 0x35, 0x42, 0x6e, 0x66, 0x77, 0x6e, 0x6a, 0x73, 0x79, 0x6c,
    0x38, 0x30, 0x6d, 0x71, 0x2f, 0x44, 0x62, 0x51, 0x4e, 0x35, 0x6c, 0x41,
    0x48, 0x42, 0x76, 0x6a, 0x44, 0x72, 0x6b, 0x43, 0x36, 0x49, 0x74, 0x6f,
    0x6a, 0x42, 0x47, 0x4b, 0x49, 0x33, 0x2b, 0x69, 0x49, 0x72, 0x71, 0x47,
    0x55, 0x45, 0x4a, 0x64, 0x78, 0x76, 0x6c, 0x34, 0x75, 0x6c, 0x6a, 0x0a,
    0x46, 0x30, 0x50, 0x6d, 0x53, 0x44, 0x37, 0x7a, 0x76, 0x49, 0x47, 0x38,
    0x42, 0x66, 0x6f, 0x63, 0x4b, 0x4f, 0x65, 0x6c, 0x2b, 0x45, 0x48, 0x48,
    0x30, 0x59, 0x72, 0x79, 0x45, 0x78, 0x69, 0x57, 0x36, 0x6b, 0x72, 0x56,
    0x31, 0x4b, 0x57, 0x32, 0x5a, 0x52, 0x6d, 0x4a, 0x72, 0x71, 0x53, 0x46,
    0x77, 0x36, 0x4b, 0x43, 0x6a, 0x56, 0x30, 0x43, 0x46, 0x46, 0x51, 0x46,
    0x62, 0x50, 0x66, 0x55, 0x0a, 0x78, 0x79, 0x35, 0x50, 0x6d, 0x4b, 0x79,
    0x74, 0x4a, 0x6d, 0x58, 0x52, 0x38, 0x42, 0x6d, 0x70, 0x70, 0x6b, 0x49,
    0x4f, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x44,
    0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b,
    0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a
};

/*
-----BEGIN CERTIFICATE-----
MIICqTCCAmegAwIBAgIJAILDGUk37fWGMAsGCWCGSAFlAwQDAjASMRAwDgYDVQQK
DAdBY21lIENvMB4XDTE2MTIyNTEzMjUzNloXDTI2MTIyNTEzMjUzNlowEjEQMA4G
A1UECgwHQWNtZSBDbzCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQDdkFKzNABLOha7
Eqj7004+p5fhtR6bxpujToMmSZTYi8igVVXPWzf03ULKS5UKjA6WpR6EiZAhm+Pd
xusZ5xfAuRZLdKy0bgxn1f348Rwh+EQNaEM80TGcnw5ijwKmSw5yyHPDWdiHzoqE
BlhAf8Nl22YTXax/clsc/pu/RRLAdwIVAIEgQqWRf/1EIZZcgM65Qpd65YuxAoGB
AKBauV/RuloFHoSy5iWXESDywiS380tN5974GukGwoYdZo5uSIH6ahpeNSef0MbH
GAzr7ZVEnhCQfRAwH1gRvSHoq/Rbmcvtd3r+QtQHOwvQHgLAynhI4i73c794czHa
R+439bmcaSwDnQduRM85Mho/jiiZzAVPxBmGPOIMWNXXA4GEAAKBgCOhKeSBO8p9
yc5FzvQerQt22wzPmc7riJ8GS27WfJYpuw7Kmm4OJNmGxOEfeQZ38J47MpfNJqvw
20DeZQBwb4w65AuiLaIwRiiN/oiK6hlBCXcb5eLpYxdD5kg+87yBvAX6HCjnpfhB
x9GK8hMYlupK1dSltmUZia6khcOigo1do0UwQzAJBgNVHRMEAjAAMAsGA1UdDwQE
AwIFoDATBgNVHSUEDDAKBggrBgEFBQcDATAUBgNVHREEDTALgglsb2NhbGhvc3Qw
CwYJYIZIAWUDBAMCAy8AMCwCFClxInXTRWNJEWdi5ilNr/fbM1bKAhQy4B7wtmfd
I+zV6g3w9qBkNqStpA==
-----END CERTIFICATE-----
 */
static const char DSACertPEM[] = {
    0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x43,
    0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d,
    0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43, 0x71, 0x54, 0x43, 0x43,
    0x41, 0x6d, 0x65, 0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x4a,
    0x41, 0x49, 0x4c, 0x44, 0x47, 0x55, 0x6b, 0x33, 0x37, 0x66, 0x57, 0x47,
    0x4d, 0x41, 0x73, 0x47, 0x43, 0x57, 0x43, 0x47, 0x53, 0x41, 0x46, 0x6c,
    0x41, 0x77, 0x51, 0x44, 0x41, 0x6a, 0x41, 0x53, 0x4d, 0x52, 0x41, 0x77,
    0x44, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4b, 0x0a, 0x44, 0x41, 0x64,
    0x42, 0x59, 0x32, 0x31, 0x6c, 0x49, 0x45, 0x4e, 0x76, 0x4d, 0x42, 0x34,
    0x58, 0x44, 0x54, 0x45, 0x32, 0x4d, 0x54, 0x49, 0x79, 0x4e, 0x54, 0x45,
    0x7a, 0x4d, 0x6a, 0x55, 0x7a, 0x4e, 0x6c, 0x6f, 0x58, 0x44, 0x54, 0x49,
    0x32, 0x4d, 0x54, 0x49, 0x79, 0x4e, 0x54, 0x45, 0x7a, 0x4d, 0x6a, 0x55,
    0x7a, 0x4e, 0x6c, 0x6f, 0x77, 0x45, 0x6a, 0x45, 0x51, 0x4d, 0x41, 0x34,
    0x47, 0x0a, 0x41, 0x31, 0x55, 0x45, 0x43, 0x67, 0x77, 0x48, 0x51, 0x57,
    0x4e, 0x74, 0x5a, 0x53, 0x42, 0x44, 0x62, 0x7a, 0x43, 0x43, 0x41, 0x62,
    0x63, 0x77, 0x67, 0x67, 0x45, 0x73, 0x42, 0x67, 0x63, 0x71, 0x68, 0x6b,
    0x6a, 0x4f, 0x4f, 0x41, 0x51, 0x42, 0x4d, 0x49, 0x49, 0x42, 0x48, 0x77,
    0x4b, 0x42, 0x67, 0x51, 0x44, 0x64, 0x6b, 0x46, 0x4b, 0x7a, 0x4e, 0x41,
    0x42, 0x4c, 0x4f, 0x68, 0x61, 0x37, 0x0a, 0x45, 0x71, 0x6a, 0x37, 0x30,
    0x30, 0x34, 0x2b, 0x70, 0x35, 0x66, 0x68, 0x74, 0x52, 0x36, 0x62, 0x78,
    0x70, 0x75, 0x6a, 0x54, 0x6f, 0x4d, 0x6d, 0x53, 0x5a, 0x54, 0x59, 0x69,
    0x38, 0x69, 0x67, 0x56, 0x56, 0x58, 0x50, 0x57, 0x7a, 0x66, 0x30, 0x33,
    0x55, 0x4c, 0x4b, 0x53, 0x35, 0x55, 0x4b, 0x6a, 0x41, 0x36, 0x57, 0x70,
    0x52, 0x36, 0x45, 0x69, 0x5a, 0x41, 0x68, 0x6d, 0x2b, 0x50, 0x64, 0x0a,
    0x78, 0x75, 0x73, 0x5a, 0x35, 0x78, 0x66, 0x41, 0x75, 0x52, 0x5a, 0x4c,
    0x64, 0x4b, 0x79, 0x30, 0x62, 0x67, 0x78, 0x6e, 0x31, 0x66, 0x33, 0x34,
    0x38, 0x52, 0x77, 0x68, 0x2b, 0x45, 0x51, 0x4e, 0x61, 0x45, 0x4d, 0x38,
    0x30, 0x54, 0x47, 0x63, 0x6e, 0x77, 0x35, 0x69, 0x6a, 0x77, 0x4b, 0x6d,
    0x53, 0x77, 0x35, 0x79, 0x79, 0x48, 0x50, 0x44, 0x57, 0x64, 0x69, 0x48,
    0x7a, 0x6f, 0x71, 0x45, 0x0a, 0x42, 0x6c, 0x68, 0x41, 0x66, 0x38, 0x4e,
    0x6c, 0x32, 0x32, 0x59, 0x54, 0x58, 0x61, 0x78, 0x2f, 0x63, 0x6c, 0x73,
    0x63, 0x2f, 0x70, 0x75, 0x2f, 0x52, 0x52, 0x4c, 0x41, 0x64, 0x77, 0x49,
    0x56, 0x41, 0x49, 0x45, 0x67, 0x51, 0x71, 0x57, 0x52, 0x66, 0x2f, 0x31,
    0x45, 0x49, 0x5a, 0x5a, 0x63, 0x67, 0x4d, 0x36, 0x35, 0x51, 0x70, 0x64,
    0x36, 0x35, 0x59, 0x75, 0x78, 0x41, 0x6f, 0x47, 0x42, 0x0a, 0x41, 0x4b,
    0x42, 0x61, 0x75, 0x56, 0x2f, 0x52, 0x75, 0x6c, 0x6f, 0x46, 0x48, 0x6f,
    0x53, 0x79, 0x35, 0x69, 0x57, 0x58, 0x45, 0x53, 0x44, 0x79, 0x77, 0x69,
    0x53, 0x33, 0x38, 0x30, 0x74, 0x4e, 0x35, 0x39, 0x37, 0x34, 0x47, 0x75,
    0x6b, 0x47, 0x77, 0x6f, 0x59, 0x64, 0x5a, 0x6f, 0x35, 0x75, 0x53, 0x49,
    0x48, 0x36, 0x61, 0x68, 0x70, 0x65, 0x4e, 0x53, 0x65, 0x66, 0x30, 0x4d,
    0x62, 0x48, 0x0a, 0x47, 0x41, 0x7a, 0x72, 0x37, 0x5a, 0x56, 0x45, 0x6e,
    0x68, 0x43, 0x51, 0x66, 0x52, 0x41, 0x77, 0x48, 0x31, 0x67, 0x52, 0x76,
    0x53, 0x48, 0x6f, 0x71, 0x2f, 0x52, 0x62, 0x6d, 0x63, 0x76, 0x74, 0x64,
    0x33, 0x72, 0x2b, 0x51, 0x74, 0x51, 0x48, 0x4f, 0x77, 0x76, 0x51, 0x48,
    0x67, 0x4c, 0x41, 0x79, 0x6e, 0x68, 0x49, 0x34, 0x69, 0x37, 0x33, 0x63,
    0x37, 0x39, 0x34, 0x63, 0x7a, 0x48, 0x61, 0x0a, 0x52, 0x2b, 0x34, 0x33,
    0x39, 0x62, 0x6d, 0x63, 0x61, 0x53, 0x77, 0x44, 0x6e, 0x51, 0x64, 0x75,
    0x52, 0x4d, 0x38, 0x35, 0x4d, 0x68, 0x6f, 0x2f, 0x6a, 0x69, 0x69, 0x5a,
    0x7a, 0x41, 0x56, 0x50, 0x78, 0x42, 0x6d, 0x47, 0x50, 0x4f, 0x49, 0x4d,
    0x57, 0x4e, 0x58, 0x58, 0x41, 0x34, 0x47, 0x45, 0x41, 0x41, 0x4b, 0x42,
    0x67, 0x43, 0x4f, 0x68, 0x4b, 0x65, 0x53, 0x42, 0x4f, 0x38, 0x70, 0x39,
    0x0a, 0x79, 0x63, 0x35, 0x46, 0x7a, 0x76, 0x51, 0x65, 0x72, 0x51, 0x74,
    0x32, 0x32, 0x77, 0x7a, 0x50, 0x6d, 0x63, 0x37, 0x72, 0x69, 0x4a, 0x38,
    0x47, 0x53, 0x32, 0x37, 0x57, 0x66, 0x4a, 0x59, 0x70, 0x75, 0x77, 0x37,
    0x4b, 0x6d, 0x6d, 0x34, 0x4f, 0x4a, 0x4e, 0x6d, 0x47, 0x78, 0x4f, 0x45,
    0x66, 0x65, 0x51, 0x5a, 0x33, 0x38, 0x4a, 0x34, 0x37, 0x4d, 0x70, 0x66,
    0x4e, 0x4a, 0x71, 0x76, 0x77, 0x0a, 0x32, 0x30, 0x44, 0x65, 0x5a, 0x51,
    0x42, 0x77, 0x62, 0x34, 0x77, 0x36, 0x35, 0x41, 0x75, 0x69, 0x4c, 0x61,
    0x49, 0x77, 0x52, 0x69, 0x69, 0x4e, 0x2f, 0x6f, 0x69, 0x4b, 0x36, 0x68,
    0x6c, 0x42, 0x43, 0x58, 0x63, 0x62, 0x35, 0x65, 0x4c, 0x70, 0x59, 0x78,
    0x64, 0x44, 0x35, 0x6b, 0x67, 0x2b, 0x38, 0x37, 0x79, 0x42, 0x76, 0x41,
    0x58, 0x36, 0x48, 0x43, 0x6a, 0x6e, 0x70, 0x66, 0x68, 0x42, 0x0a, 0x78,
    0x39, 0x47, 0x4b, 0x38, 0x68, 0x4d, 0x59, 0x6c, 0x75, 0x70, 0x4b, 0x31,
    0x64, 0x53, 0x6c, 0x74, 0x6d, 0x55, 0x5a, 0x69, 0x61, 0x36, 0x6b, 0x68,
    0x63, 0x4f, 0x69, 0x67, 0x6f, 0x31, 0x64, 0x6f, 0x30, 0x55, 0x77, 0x51,
    0x7a, 0x41, 0x4a, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x52, 0x4d, 0x45, 0x41,
    0x6a, 0x41, 0x41, 0x4d, 0x41, 0x73, 0x47, 0x41, 0x31, 0x55, 0x64, 0x44,
    0x77, 0x51, 0x45, 0x0a, 0x41, 0x77, 0x49, 0x46, 0x6f, 0x44, 0x41, 0x54,
    0x42, 0x67, 0x4e, 0x56, 0x48, 0x53, 0x55, 0x45, 0x44, 0x44, 0x41, 0x4b,
    0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46, 0x42, 0x51, 0x63, 0x44,
    0x41, 0x54, 0x41, 0x55, 0x42, 0x67, 0x4e, 0x56, 0x48, 0x52, 0x45, 0x45,
    0x44, 0x54, 0x41, 0x4c, 0x67, 0x67, 0x6c, 0x73, 0x62, 0x32, 0x4e, 0x68,
    0x62, 0x47, 0x68, 0x76, 0x63, 0x33, 0x51, 0x77, 0x0a, 0x43, 0x77, 0x59,
    0x4a, 0x59, 0x49, 0x5a, 0x49, 0x41, 0x57, 0x55, 0x44, 0x42, 0x41, 0x4d,
    0x43, 0x41, 0x79, 0x38, 0x41, 0x4d, 0x43, 0x77, 0x43, 0x46, 0x43, 0x6c,
    0x78, 0x49, 0x6e, 0x58, 0x54, 0x52, 0x57, 0x4e, 0x4a, 0x45, 0x57, 0x64,
    0x69, 0x35, 0x69, 0x6c, 0x4e, 0x72, 0x2f, 0x66, 0x62, 0x4d, 0x31, 0x62,
    0x4b, 0x41, 0x68, 0x51, 0x79, 0x34, 0x42, 0x37, 0x77, 0x74, 0x6d, 0x66,
    0x64, 0x0a, 0x49, 0x2b, 0x7a, 0x56, 0x36, 0x67, 0x33, 0x77, 0x39, 0x71,
    0x42, 0x6b, 0x4e, 0x71, 0x53, 0x74, 0x70, 0x41, 0x3d, 0x3d, 0x0a, 0x2d,
    0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54,
    0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
    0x0a
};
#endif

/* unused, to avoid warning. */
static int idx;

#define FUZZTIME 1485898104

#define TIME_IMPL(t) { if (t != NULL) *t = FUZZTIME; return FUZZTIME; }

/*
 * This might not work in all cases (and definitely not on Windows
 * because of the way linkers are) and callees can still get the
 * current time instead of the fixed time. This will just result
 * in things not being fully reproducible and have a slightly
 * different coverage.
 */
#if !defined(_WIN32)
time_t time(time_t *t) TIME_IMPL(t)
#endif

int FuzzerInitialize(int *argc, char ***argv)
{
    STACK_OF(SSL_COMP) *comp_methods;

    FuzzerSetRand();
    OPENSSL_init_crypto(OPENSSL_INIT_LOAD_CRYPTO_STRINGS | OPENSSL_INIT_ASYNC, NULL);
    OPENSSL_init_ssl(OPENSSL_INIT_LOAD_SSL_STRINGS, NULL);
    ERR_clear_error();
    CRYPTO_free_ex_index(0, -1);
    idx = SSL_get_ex_data_X509_STORE_CTX_idx();
    comp_methods = SSL_COMP_get_compression_methods();
    if (comp_methods != NULL)
        sk_SSL_COMP_sort(comp_methods);

    return 1;
}

int FuzzerTestOneInput(const uint8_t *buf, size_t len)
{
    SSL *server;
    BIO *in;
    BIO *out;
#if !defined(OPENSSL_NO_EC)                     \
    || (!defined(OPENSSL_NO_DSA) && !defined(OPENSSL_NO_DEPRECATED_3_0))
    BIO *bio_buf;
#endif
    SSL_CTX *ctx;
    int ret;
#ifndef OPENSSL_NO_DEPRECATED_3_0
    RSA *privkey;
#endif
#if !defined(OPENSSL_NO_DEPRECATED_3_0)
    EVP_PKEY *pkey;
#endif
    X509 *cert;
#ifndef OPENSSL_NO_DEPRECATED_3_0
# ifndef OPENSSL_NO_EC
    EC_KEY *ecdsakey = NULL;
# endif
#endif
#if !defined(OPENSSL_NO_DSA) && !defined(OPENSSL_NO_DEPRECATED_3_0)
    DSA *dsakey = NULL;
#endif

    if (len < 2)
        return 0;

    /* This only fuzzes the initial flow from the client so far. */
    ctx = SSL_CTX_new(DTLS_server_method());

    ret = SSL_CTX_set_min_proto_version(ctx, 0);
    OPENSSL_assert(ret == 1);
    ret = SSL_CTX_set_cipher_list(ctx, "ALL:eNULL:@SECLEVEL=0");
    OPENSSL_assert(ret == 1);

#ifndef OPENSSL_NO_DEPRECATED_3_0
    /* RSA */
    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, RSAPrivateKeyPEM, sizeof(RSAPrivateKeyPEM)) == sizeof(RSAPrivateKeyPEM));
    privkey = PEM_read_bio_RSAPrivateKey(bio_buf, NULL, NULL, NULL);
    ERR_print_errors_fp(stderr);
    OPENSSL_assert(privkey != NULL);
    BIO_free(bio_buf);
    pkey = EVP_PKEY_new();
    EVP_PKEY_assign_RSA(pkey, privkey);
    ret = SSL_CTX_use_PrivateKey(ctx, pkey);
    OPENSSL_assert(ret == 1);
    EVP_PKEY_free(pkey);
#endif

    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, RSACertificatePEM, sizeof(RSACertificatePEM)) == sizeof(RSACertificatePEM));
    cert = PEM_read_bio_X509(bio_buf, NULL, NULL, NULL);
    BIO_free(bio_buf);
    OPENSSL_assert(cert != NULL);
    ret = SSL_CTX_use_certificate(ctx, cert);
    OPENSSL_assert(ret == 1);
    X509_free(cert);

#ifndef OPENSSL_NO_EC
# ifndef OPENSSL_NO_DEPRECATED_3_0
    /* ECDSA */
    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, ECDSAPrivateKeyPEM, sizeof(ECDSAPrivateKeyPEM)) == sizeof(ECDSAPrivateKeyPEM));
    ecdsakey = PEM_read_bio_ECPrivateKey(bio_buf, NULL, NULL, NULL);
    ERR_print_errors_fp(stderr);
    OPENSSL_assert(ecdsakey != NULL);
    BIO_free(bio_buf);
    pkey = EVP_PKEY_new();
    EVP_PKEY_assign_EC_KEY(pkey, ecdsakey);
    ret = SSL_CTX_use_PrivateKey(ctx, pkey);
    OPENSSL_assert(ret == 1);
    EVP_PKEY_free(pkey);
# endif
    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, ECDSACertPEM, sizeof(ECDSACertPEM)) == sizeof(ECDSACertPEM));
    cert = PEM_read_bio_X509(bio_buf, NULL, NULL, NULL);
    OPENSSL_assert(cert != NULL);
    BIO_free(bio_buf);
    ret = SSL_CTX_use_certificate(ctx, cert);
    OPENSSL_assert(ret == 1);
    X509_free(cert);
#endif

#if !defined(OPENSSL_NO_DSA) && !defined(OPENSSL_NO_DEPRECATED_3_0)
    /* DSA */
    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, DSAPrivateKeyPEM, sizeof(DSAPrivateKeyPEM)) == sizeof(DSAPrivateKeyPEM));
    dsakey = PEM_read_bio_DSAPrivateKey(bio_buf, NULL, NULL, NULL);
    ERR_print_errors_fp(stderr);
    OPENSSL_assert(dsakey != NULL);
    BIO_free(bio_buf);
    pkey = EVP_PKEY_new();
    EVP_PKEY_assign_DSA(pkey, dsakey);
    ret = SSL_CTX_use_PrivateKey(ctx, pkey);
    OPENSSL_assert(ret == 1);
    EVP_PKEY_free(pkey);

    bio_buf = BIO_new(BIO_s_mem());
    OPENSSL_assert((size_t)BIO_write(bio_buf, DSACertPEM, sizeof(DSACertPEM)) == sizeof(DSACertPEM));
    cert = PEM_read_bio_X509(bio_buf, NULL, NULL, NULL);
    OPENSSL_assert(cert != NULL);
    BIO_free(bio_buf);
    ret = SSL_CTX_use_certificate(ctx, cert);
    OPENSSL_assert(ret == 1);
    X509_free(cert);
#endif

    server = SSL_new(ctx);
    in = BIO_new(BIO_s_mem());
    out = BIO_new(BIO_s_mem());
    SSL_set_bio(server, in, out);
    SSL_set_accept_state(server);

    OPENSSL_assert((size_t)BIO_write(in, buf, len) == len);

    if (SSL_do_handshake(server) == 1) {
        /* Keep reading application data until error or EOF. */
        uint8_t tmp[1024];
        for (;;) {
            if (SSL_read(server, tmp, sizeof(tmp)) <= 0) {
                break;
            }
        }
    }
    SSL_free(server);
    ERR_clear_error();
    SSL_CTX_free(ctx);

    return 0;
}

void FuzzerCleanup(void)
{
    FuzzerClearRand();
}
