// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's public_suffix_list.dat, git revision 1f3ad51 (2015-12-05)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 1534

// Text is the combined text of all labels.
const text = "bievatmallorcafederationhsangoceanographiquebifukagawalterbihoro" +
	"logyusuisservicesanjotateyamabikedagestangebilbaogakievenesannan" +
	"ikinuyamanouchikuhokuryugasakitashiobarabillustrationikkoebenhav" +
	"nikolaeverbankasukabeeldengeluidunloppacificartoonartdecoffeedba" +
	"ckasumigaurawa-mazowszextraspace-to-rentalstomakomaibarabioddabi" +
	"rdartcenterprisesakikonairbusantiquest-a-la-maisondre-landebudej" +
	"judygarlandunsagamiharabirkenesoddtangenovaravennagatorogersvpal" +
	"anaklodzkodairabirthplacebjarkoyuudmurtiabjerkreimmobilienikonan" +
	"tanangerbjugninohelplfinancialipetskasuyakutiablockbusternidupon" +
	"tariomutashinainvestmentsannohelsinkitahiroshimarshallstatebanka" +
	"szubyuzawabloombergbauernurembergliwicebluedatinglobalashovhachi" +
	"noheguris-a-candidatebmoattachmentsanokatowicebmsantabarbarabmwe" +
	"groweiboltatsunostrowiecasadelamonedavvesiidazaifudaigodoesntexi" +
	"stanbullensakerbnpparibaselburglobodoes-itveronaharimalvikatsush" +
	"ikabeerbolzanore-og-uvdalivornostrowwlkpmglogoweirbomloansantacr" +
	"uzsantafedexhibitioninomiyakonojoshkar-olayangroupaleobondurbana" +
	"mexeterbonnirasakis-a-catererbookingloppenzaogashimadachicagoboa" +
	"tsanukis-a-celticsfanishiazais-a-chefarsundurhamburgminakamichig" +
	"angwonishigotpantheonishiharabootsaotomeldalomzansimagicaseihich" +
	"isobetsuitairaboschaefflerdalorenskogmodenakatombetsumidatlantic" +
	"asertaishinomakikuchikuseikarugapartmentsapodhalewismillerbostik" +
	"atsuyamasfjordenishiizunazukis-a-conservativefsncfailotenkawabos" +
	"tonakijinsekikogentingmxboxfinityuzhno-sakhalinskaufenishikataka" +
	"zakis-a-cpadoval-daostavalleybotanicalgardenishikatsuragivestbyt" +
	"omaritimekeepingretakamoriokamchatkameokameyamashinatsukigatakan" +
	"abeatsapporobotanicgardenishikawazukanazawabotanyboutiquebecngri" +
	"mstadvrdnsaratovalleaostavernishimerabozentsujiiebradescorporati" +
	"onishinomiyashironobrandywinevalleybrasiljan-mayenishinoomotegot" +
	"sukisosakitagatakamatsukawabresciabrindisibenikebristolgalsacebr" +
	"itishcolumbialowiezagannakadomari-elasticbeanstalkautokeinobroad" +
	"castlebtimnetzgorzeleccollegersundwgripebroadwaybroke-itattoolsz" +
	"tynsettlersardegnamsskoganeis-a-cubicle-slavellinowtvalled-aosta" +
	"vropolicebrokerrypropertiesardiniabronnoysundyndns-homednsarlott" +
	"ebrothermesaverdefensejnybrumunddalottokigawabrunelblagdenesnaas" +
	"eralingenkainanaejrietisalatinabenogatagajobojis-a-democrataxihu" +
	"anishinoshimatta-varjjatgorybrusselsarpsborgriwataraidyndns-ip6b" +
	"ruxellesarufutsunomiyawakasaikaitakoelnishiokoppegardyndns-mailo" +
	"uvrepbodyndns-blogdnsasayamabryanskjervoyagebryneustarhubalatino" +
	"rdre-landiscountysvardolls3-us-west-1buskerudinewhampshirecipesa" +
	"ro-urbino-pesarourbinopesaromaniwakuratelekommunikationishitosas" +
	"himizunaminamiashigarabuzenishiwakis-a-designerbuzzgradyndns-off" +
	"ice-on-the-webcambridgestonewspaperbwfashionissandoybzhitomirkut" +
	"skleppalermomasvuotnakatsugawacolognewmexicoldwarmiamiastaplesch" +
	"ulezajskfhskhabarovskhakassiacolonialwilliamsburguitarschwarzgwa" +
	"ngjuifminamibosogndaluxembourgujolstercoloradoplateaudiocolumbus" +
	"heycommunitysfjordyroyrvikingulencomobaracomparemarkerryhotelsch" +
	"weizippodlasiellakasamatsudoosandiegokaseljordcompute-1computerh" +
	"istoryofscience-fictioncomsecuritysnesciencecentersciencehistory" +
	"condoshichinohedmarkhangelskypescaravantaaconferenceconstruction" +
	"consuladoharuhrconsultanthropologyconsultingvolluxurycontactjxn-" +
	"-11b4c3dcontemporaryarteducationalchikugojomedicaltanissettaiwan" +
	"airforceocontractorskenconventureshinodesashibetsuikimobetsuligu" +
	"riacookingchannelveruminamidaitomangotembaixadacoolkuszjcbnluzer" +
	"ncoopocznorthwesternmutualvivano-frankivskharkivalledaostakkofue" +
	"lcopenhagencyclopedicdn77-sslattumetlifeinsurancecorsicahcesuolo" +
	"calhistoryazannefrankfurtkmaxxn--1ck2e1balestrandabergamoarekemb" +
	"roideryokozemergencyberlevagangaviikanonjibestadiscoveryggeelvin" +
	"ckarlsoyomitanobninskarmoyonabaruconnectargets-itargibigawasmata" +
	"rtanddesignieznorddalavagiske164corvettemasekharkovallee-aostero" +
	"ycosenzamamibuildingunmarriottmpamperedchefastlycostumedio-campi" +
	"dano-mediocampidanomediocouncilcouponscientistor-elvdalcoursescj" +
	"ohnsoncq-acranbrookuwanalyticscrapper-sitecreditcardcreditunionc" +
	"remonashorokanaiecrewiiheyaizuwakamatsubushikusakadogawacricketr" +
	"zyncrimeacrotonewportlligatewaycrowncrscrappinguovdageaidnulmina" +
	"miechizencruisesettsurfauskedsmokorsetagayasells-for-lessevastop" +
	"olecuisinellajollamericanexpressexyzlgushikamifuranotairesevenas" +
	"sisicilyculturalcentertainmentoyokawacuneocupcakecxn--1ctwolomin" +
	"amatamayukis-a-geekhersoncymruovatoyonakagyokutoshimacyouthdfcba" +
	"nkhmelnitskiyamashikefilminamifuranofinalfinancefineartsewildlif" +
	"estylefinlandfinnoyfirebaseappanasonicheltenham-radio-operaunite" +
	"lemarkazimierz-dolnyfirenzefirestonextdirectoryfirmdalegolfedjej" +
	"uegoshikiminokamoenairguardfishingonohejis-a-greenfitjarqhachioj" +
	"iyahikobeauxartsandcraftsfranziskanerimamateramochizukirafitness" +
	"ettlementoyonofjalerflickragerotikaluganskhmelnytskyivalleeaoste" +
	"igenflightshangrilangevagrarboretumbriaflirumansionsharis-a-guru" +
	"lsandvikcoromantovalle-daostavangerfloguchikuzenfloraflorenceflo" +
	"ridafloristanohatakaharussiafloromskogflowersharparaglidingflsmi" +
	"dthruhereggiocalabriaflynnhubalsanagochihayaakasakawaharaumakeup" +
	"owiathletajimabariakemersongdalenviknakanojohanamakinoharasnesod" +
	"denmarkets3-ap-southeast-2fndfolldalfoodnetworkangerfor-better-t" +
	"handafor-ourfor-somedizinhistorischeshawaiijimarylandfor-theater" +
	"forexrothachirogatakanezawaforgotdnshellaspeziaforli-cesena-forl" +
	"icesenaforlikes-piedmontblancomeereshimokawaforsaleikangerforsan" +
	"dasuolodingenfortmissoulan-udell-ogliastrakhanawawilliamhillfort" +
	"worthadanotogawaforuminamiiselectoyookarasjohkaminoyamatsuris-a-" +
	"hard-workerfosneshimokitayamafotoyosatotalfoxn--1lqs71dfreiburgf" +
	"reightcmwinbalsfjordishakotankarpaczeladz-2freseniusdecorativear" +
	"tshimonitayanagivingfribourgfriuli-v-giuliafriuli-ve-giuliafriul" +
	"i-vegiuliafriuli-venezia-giuliafriuli-veneziagiuliafriuli-vgiuli" +
	"afriuliv-giuliafriulive-giuliafriulivegiuliafriulivenezia-giulia" +
	"friuliveneziagiuliafriulivgiuliafrlfroganshimonosekikawafrognfro" +
	"landfrom-akrehamnfrom-alfrom-arfrom-azwindmillfrom-capebretonami" +
	"asakuchinotsuchiurakawassamukawataricohdavvenjargamvikhvanylveni" +
	"cefrom-collectionfrom-ctoyotaris-a-hunterfrom-dchelyabinskydivin" +
	"grondarfrom-dellogliastraderfrom-flandershimosuwalkis-a-knightoy" +
	"otomiyazakis-a-landscaperugiafrom-gaulardalfrom-higashiagatsumag" +
	"oirminamiizukamitondabayashiogamagoriziafrom-iafrom-idfrom-ilfro" +
	"m-incheonfrom-kshimotsukefrom-kyknetoyotsukaidovre-eikerfrom-lan" +
	"bibaidarfrom-manxn--1qqw23afrom-mdfrom-meetoyourafrom-microsoftb" +
	"anklabudhabikinokawabarthadselfipirangafrom-mnfrom-modalenfrom-m" +
	"shimotsumafrom-mtnfrom-nchernigovernmentjeldsundyndns-remotegild" +
	"eskalmykiafrom-ndfrom-nexusgardenfrom-nhktoystre-slidrettozawafr" +
	"om-njcparisor-fronfrom-nminamimakis-a-lawyerfrom-nvaolbia-tempio" +
	"-olbiatempioolbialystokkemerovodkagoshimaintenancefrom-nyfrom-oh" +
	"kurafrom-oketogurafrom-orfrom-paderbornfrom-pratohmaoris-a-liber" +
	"alfrom-ris-a-libertarianfrom-schoenbrunnfrom-sdnipropetrovskmpsp" +
	"baltimore-og-romsdalimanowarudastronomykolaivanovosibirskiptvete" +
	"rinairebungoonomichinomiyakepnordkappgjemnes3-eu-central-1from-t" +
	"nfrom-txn--2m4a15efrom-utazuerichardlikescandyndns-at-homedepota" +
	"ruis-a-linux-useranishiaritabashikaoizumizakitaurayasudafrom-vad" +
	"sochildrensgardenfrom-vtozsdefrom-wafrom-wielunnerfrom-wvareserv" +
	"eftparliamentranbyfrom-wyfrosinonefrostalowa-wolawafroyahabadajo" +
	"zorahkkeravjuedischesapeakebayerndfstcgrouparmafujiiderafujikawa" +
	"guchikonefujiminohtawaramotoineppugliafujinomiyadafujiokayamarbu" +
	"rgfujisatoshonairlinebraskaunbieidsvollfujisawafujishiroishidaka" +
	"biratoridelmenhorstalbanshinichinanfujitsurugashimarinefujixerox" +
	"n--30rr7yfujiyoshidafukayabeardubaiduckdnsdojoburgfukuchiyamadaf" +
	"ukudominichernihivgucciprianiigataitoeiheijis-a-doctorayfukuis-a" +
	"-llamarylhursteinkjerusalembetsukuis-a-musicianfukumitsubishigak" +
	"irkeneshinjournalismailillehammerfest-mon-blogueurovisionfukuoka" +
	"zakirovogradoyfukuroishikarikaturindalfukusakiryuohaebaruminamim" +
	"inowafukuyamagatakahashimamakisarazure-mobileirfjordfunabashiriu" +
	"chinadafunagatakahatakaishimoichinosekigaharafunahashikamiamakus" +
	"atsumasendaisennangoodyearthagakhanamigawafundaciofuoiskujukuriy" +
	"amarcheaparocherkasyzrankoshigayaltaikis-a-nascarfanfuosskoczowi" +
	"ndowshinjukumanofurnitureggioemiliaromagnakasatsunairportland-4-" +
	"salernogiessengerdalaskanittedallasalleaseeklogesurancefurubiraq" +
	"uarelleasingleshinkamigotoyohashimotomobeneventochiokinoshimalse" +
	"lvendrellfurudonostiafurukawairtelecityeatshinshinotsurgeonshall" +
	"offamelhustkamisunagawafusodegaurafussaikishiwadafutabayamaguchi" +
	"nomigawafutboldlygoingnowhere-for-moregontrailroadfuttsurugimina" +
	"miogunicomcastresistancefvgfyis-a-nurseoullensvanguardfylkesbibl" +
	"ackfridayfyresdalhanyuzenhapmirhappoulvikokonoehareidsbergenhars" +
	"tadharvestcelebrationhasamarahasaminami-alpssells-for-unzenhashb" +
	"anghasudahasvikolobrzegyptianpachigasakidstvedestrandhatogayahoo" +
	"oshikamaishimofusartshinyoshitomiokaniepcehatoyamazakitahatakaok" +
	"amikitayamatotakadahatsukaichiharahattfjelldalhayashimamotobungo" +
	"takadatsunanjoetsuwanouchikujogaszkoladbrokesennumamurogawarszaw" +
	"ashingtondclkomaganehazuminobusells-itraniandriabarlettatraniand" +
	"riahboehringerikehembygdsforbundhemneshiojirishirifujiedahemseda" +
	"lherokussldheroyhgtvaroyhigashichichibunkyonanaoshimageandsounda" +
	"ndvisionhigashihiroshimanehigashiizumozakitakamiizumisanofiatran" +
	"oyhigashikagawahigashikagurasoedahigashikawakitaaikitakatakarazu" +
	"kamikoaniikappulawyhigashikurumeguroroskoleitungsenhigashimatsus" +
	"himarugame-hostinghigashimatsuyamakitaakitadaitoigawahigashimura" +
	"yamalatvuopmidoris-a-personaltrainerhigashinarusellsyourhomegood" +
	"shioyameloyalistockholmestrandhigashinehigashiomihachimanchester" +
	"higashiosakasayamamotorcycleshirahamatonbetsurgeryhigashishiraka" +
	"wamatakasagooglecodespotransportrapaniimimatakatoris-a-photograp" +
	"herokuappartis-a-playerhigashisumiyoshikawaminamiaikitakyushuaia" +
	"higashitsunowruzhgorodoyhigashiurausukitamidsundhigashiyamatokor" +
	"iyamanakakogawahigashiyodogawahigashiyoshinogaris-a-republicance" +
	"rresearchaeologicaliforniahiraizumisatohnoshoohirakatashinagawah" +
	"iranairtraffichernovtsykkylvenetogakushimotoganewjerseyhirarahir" +
	"atsukagawahirayaitakasakitamotosumitakaginankokubunjis-a-rocksta" +
	"rachowicehisayamanashiibaghdadultravelchannelhistorichouseshirak" +
	"oenighitachiomiyaginowaniihamatamakawajimaritimodellinghitachiot" +
	"agopartnershiranukanmakiwakunigamihamadahitoyoshimifunehitrading" +
	"hjartdalhjelmelandholeckobierzyceholidayhomeipartshiraois-a-soci" +
	"alistmeindianapolis-a-bloggerhomelinuxn--32vp30hagebostadhomesen" +
	"sembokukitanakagusukumoduminamisanrikubetsupplyhomeunixn--3bst00" +
	"minamitanehondahonefosshiraokannamiharuhoneywellhongorgehonjyoit" +
	"akashimarumorimachidahornindalhorseminehortendofinternetravelers" +
	"insurancehoteleshiratakahagis-a-soxfanhotmailhoyangerhoylandetro" +
	"itskomakiyosatokamachippubetsubetsugaruhumanitieshishikuis-a-stu" +
	"dentalhurdalhurumajis-a-teacherkassymantechnologyhyllestadhyogor" +
	"is-a-techietis-a-therapistoiahyugawarahyundaiwafunejgorajlchitac" +
	"hinakagawatchandclockazojlljmpartyjnjelenia-gorajoyokaichibahcav" +
	"uotnagaraholtalenjpmorganichitosetogitsuldalucaniajpnchloejprshi" +
	"zuokanoyakagejuniperjurkristiansandcatshoujis-an-entertainerkris" +
	"tiansundkrodsheradkrokstadelvaldaostarostwodzislawinnershowakrym" +
	"inamiuonumatsumaebashimodatekumatorinokumejimasudakumenanyokkaic" +
	"hirurgiens-dentisteshowtimemerckommunekunisakis-bykunitachiarail" +
	"waykunitomigusukumamotoyamassa-carrara-massacarraramassabusiness" +
	"ebykleclerchocolatelevisionissayokoshibahikariwanumataketomisato" +
	"kuyamatteledatabaseballooningrongausdaluccapetownissedalucerneku" +
	"nneppupasadenamsosnowiechofunatorientexpressatxjaworznokunstsamm" +
	"lungkunstunddesignkuokgroupassagenshriramsterdambulancekurepair-" +
	"traffic-controlleykurgankurobelgorodeokurogimilitarykuroisoftwar" +
	"endalenugkuromatsunais-certifiedekakegawakurotakikawasakis-found" +
	"ationkurskomonokushirogawakustanais-gonekusupersportrentino-stir" +
	"olkutchanelkutnokuzbassnillfjordkuzumakis-into-animeiwamaseratis" +
	"-an-accountantshisognekvafjordkvalsundkvamlidlugolekagaminord-au" +
	"rdalvdalipayufuchukotkafjordkvanangenkvinesdalkvinnheradkvitesei" +
	"dskogkvitsoykwpspjelkavikomorotsukamishihoronobeokaminokawanishi" +
	"aizubangekyotobetsuppliesienarashinokyowariasahikawamissilelmisu" +
	"gitokonamegatakayamatsunomitakeharamitourismolanciamitoyoakemiur" +
	"amiyazurewebsiteshikagamiishibukawamiyotamanomjondalenmlbarcelon" +
	"agasakijobservercellierneues3-us-west-2monmouthaibarakitagawamon" +
	"stermonticellolmontrealestatefarmequipmentrentino-sud-tirolmonza" +
	"-brianzaporizhzhekinannestadmonza-e-della-brianzaporizhzhiamonza" +
	"brianzapposlombardiamondsimbirskongsbergmonzaebrianzaramonzaedel" +
	"labrianzamoparachutingmordoviajessheiminamiyamashirokawanabellev" +
	"uelosangelesjaguarchitecturealtychyattorneyagawalbrzycharternopi" +
	"lawalesundmoriyamatsusakahoginozawaonsenmoriyoshiokamitsuemormon" +
	"eymoroyamatsushigemortgagemoscowiostrolekaneyamaxunjargamoseushi" +
	"storymosjoenmoskenesimple-urlmossirdalmosvikongsvingermoviemovis" +
	"targardmtpccwitdkoninjamisonmtranakayamatsuuramuenstermugithubus" +
	"ercontentrentino-sudtirolmuikamogawamukochikushinonsenergymulhou" +
	"servebbslingmultichoicemunakatanemuncieszynmuosattemupassenger-a" +
	"ssociationmurmanskonskowolancashireisenmurotorcraftrentino-sued-" +
	"tirolmusashimurayamatsuzakis-leetrdmusashinoharamuseetrentino-su" +
	"edtirolmuseumverenigingmutsuzawamutuellevangermypetslupskonsulat" +
	"robelaudiblebesbyglandmyphotoshibahccavuotnagareyamaizurubtsovsk" +
	"jakdnepropetrovskiervaapsteiermarkonyveloftrentino-altoadigemyti" +
	"s-a-bookkeeperminanophiladelphiaareadmyblogsitephilatelyphilipsy" +
	"phoenixn--3e0b707ephotographysiopiagetmyipaviancapitalonewhollan" +
	"dpictetrentinoa-adigepicturesnzpiemontepilotsokanrapinkopervikom" +
	"itamamurapioneerpippupiszpittsburghofermobilypiwatepizzapkoryola" +
	"siteplanetariumincommbankomvuxn--3ds443gplantationplantsokndalpl" +
	"atforminnesotaketakatsukis-into-carshitaramaplaystationplazaplch" +
	"onanbuildersaudaplombardyndns-at-workinggroupfizerplumbingotvbar" +
	"claycardsakuraibmdiskstationaustdalimitedunetflixilimoliserniauk" +
	"raanghkebinagisoccertificationaturalhistorymuseumcenterhcloudcon" +
	"trolledds3-external-1plusterpmnpodzonepohlpokerpokrovskosaigawap" +
	"olitiendapolkowicepoltavalle-aostathellexuslivinghistorypomorzes" +
	"zowithgoogleapisa-hockeynutrentinoaadigepordenonepornporsangerpo" +
	"rsangugeporsgrunnanpoznanpraxis-a-bruinsfansolarssonprdpreservat" +
	"ionpresidioprimelbourneprincipeprivneprochowiceproductionsologne" +
	"proferraraprogressivenneslaskerrylogisticsolundbeckosakaerodrome" +
	"gallupinbananarepublicarrierprojectrentinoalto-adigepromombetsup" +
	"portrentinoaltoadigepropertyprotectionprudentialpruszkowithyoutu" +
	"bentleyprzeworskogptzpvtrentinos-tirolpwchoseiroumuenchenisshing" +
	"uernseypzqldqponqslgbtrentinostirolqvchoshibuyachiyodastpetersbu" +
	"rgstudiostudyndns-freemasonryokamikawanehonbetsurutaharastuff-4-" +
	"salestuttgartrentinosued-tirolsurnadalsurreysusakis-slickomatsus" +
	"himashikiyosemitesusonosuzakanumazurysuzukanzakiwiensuzukis-uber" +
	"leetrentino-a-adigesvalbardudinkakamigaharasveiosvelvikosherbroo" +
	"kegawasvizzeraswedenswidnicarbonia-iglesias-carboniaiglesiascarb" +
	"oniaswiebodzindianmarketingswiftcoverisignswinoujscienceandhisto" +
	"ryswisshikis-very-badaddjamalborkdalsxn--3oq18vl8pn36atunesootur" +
	"ystykarasjoksnesopotrentinosud-tiroltuscanytushuissier-justicetu" +
	"valle-d-aostatoilvestnesor-varangervestre-slidreamhostersorfoldv" +
	"estre-totennishiawakuravestvagoyvevelstadvibo-valentiavibovalent" +
	"iavideovillaskoyabearalvahkihokumakogeniwaizumiotsukumiyamazonaw" +
	"sabaerobaticketsaritsynologyeongbukoshunantokashikizunokunimilan" +
	"ovinnicargodaddynathomebuiltrentottoris-very-evillagevinnytsiavi" +
	"psinaappharmaciensmolenskooris-an-actresshisuifuettertdasnetzvir" +
	"giniavirtualvirtuelvisakatakinouevistaprintuitrevisohughesolutio" +
	"nsomaviterboknowsitallvivoldavladikavkazanvladimirvladivostokaiz" +
	"ukarasuyamazoevlogvolgogradvolkenkunderseaportroandinosaureportr" +
	"entinosuedtirolvolkswagentsorreisahayakawakamiichikaiseis-savedu" +
	"catorahimeshimakanegasakinkobayashikshacknetnedalvologdanskostro" +
	"mahachijorpelandvolyngdalvoronezhytomyrvossevangenvotevotingvoto" +
	"ursortlandvrnworse-thangglidingwowiwatsukiyonowritesthisblogspot" +
	"rogstadwroclawloclawekosugewtchoyodobashichikashukujitawarawtfer" +
	"rarittogoldpointelligencewuozuwwworldwzmiuwajimaxn--4gbriminingx" +
	"n--4gq48lf9jeonnamerikawauexn--4it168dxn--4it797kotouraxn--4pvxs" +
	"oruminternationalfirearmsigdalxn--54b7fta0cchryslerxn--55qw42gxn" +
	"--55qx5dxn--5js045dxn--5rtp49chtrainingrossetouchijiwadeltajimic" +
	"rolightingroundhandlingroznyxn--5rtq34kouhokutamakis-an-artistjo" +
	"hnxn--5su34j936bgsgxn--5tzm5gxn--6btw5axn--6frz82gxn--6orx2rxn--" +
	"6qq986b3xlxn--7t0a264chungbukazunoxn--80adxhksouthcarolinazawaxn" +
	"--80ao21axn--80aqecdr1axn--80asehdbarclaysakyotanabellunordreisa" +
	"-geekarumaifarmsteadivtasvuodnakaiwamizawaurskog-holandroverhall" +
	"a-speziaetnagahamaroygardenebakkeshibechambagricaaarborteaches-y" +
	"ogasawaracingroks-theatree12xn--80aswgxn--80audnedalnxn--8ltr62k" +
	"ounosunndalxn--8pvr4uxn--8y0a063axn--90a3academydscloudappspoten" +
	"zachpomorskiendoftheinternetcimdbarefootballangenoamishirasatobi" +
	"shimalopolskanlandivttasvuotnakamagayachtsalangenaval-d-aosta-va" +
	"lleyonagoyaustevollavangenaturalsciencesnaturelles3-external-2xn" +
	"--90aishobaraomoriguchiharagusaarlandxn--90azhakatanotteroyxn--9" +
	"dbhblg6diethnologyxn--9dbq2axn--9et52uxn--9krt00axn--andy-iraxn-" +
	"-aroport-byanagawaxn--asky-iraxn--aurskog-hland-jnbargainstitute" +
	"lefonicagliaridagawallonieruchomoscienceandindustrynavigationavu" +
	"otnakhodkanagawaustinnaturbruksgymnaturhistorisches3-fips-us-gov" +
	"-west-1xn--avery-yuasakegawaxn--b-5gaxn--b4w605ferdxn--bck1b9a5d" +
	"re4chungnamdalseidfjordyndns-weberlincolniyodogawaxn--bdddj-mrab" +
	"dxn--bearalvhki-y4axn--berlevg-jxaxn--bhcavuotna-s4axn--bhccavuo" +
	"tna-k7axn--bidr-5nachikatsuuraxn--bievt-0qa2xn--bjarky-fyanaizux" +
	"n--bjddar-ptamboversaillesor-odalxn--blt-elaborxn--bmlo-grainger" +
	"xn--bod-2naroyxn--brnny-wuaccident-investigationjukudoyamacerata" +
	"buseat-band-campaniamallamadridvagsoyericssonlineat-urlxn--brnny" +
	"sund-m8accident-preventionxn--brum-voagatromsakakinokiaxn--btsfj" +
	"ord-9zaxn--c1avgxn--c2br7gxn--c3s14misakis-into-cartoonshizukuis" +
	"himogosenxn--cck2b3barreauctionayoroceanographicsalondonetskasao" +
	"kamiokamiminersaltdalindasiaustraliaisondriodejaneirochesterxn--" +
	"cg4bkis-very-goodhandsonxn--ciqpnxn--clchc0ea0b2g2a9gcdn77-secur" +
	"ecreationxn--comunicaes-v6a2oxn--correios-e-telecomunicaes-ghc29" +
	"axn--czr694barrel-of-knowledgeologyonaguniversityoriikashibataka" +
	"sugaiinetarnobrzegjovikashiharaustrheimatunduhrennesoyekaterinbu" +
	"rgjerdrumckinseyokosukareliancebinosegawagrinetbankz-1kappleanga" +
	"viikadenaamesjevuemielnoboribetsucks3-ap-northeast-1xn--czrs0tro" +
	"msojavald-aostarnbergxn--czru2dxn--czrw28barrell-of-knowledgeome" +
	"tre-experts-comptablesalvadordalibabaikaliszczytnordlandiyukuhas" +
	"himojiitatebayashijonawatextileksvikashiwarauthordalandroidgcame" +
	"rakershus-east-1xn--d1acj3bashkiriautomotivecodyn-o-saurlandes3-" +
	"sa-east-1xn--d1alfaromeoxn--d1atrusteexn--d5qv7z876churchaseljee" +
	"pilepsydneyxn--davvenjrga-y4axn--djrs72d6uyxn--djty4kouyamashiko" +
	"kuchuoxn--dnna-grajewolterskluwerxn--drbak-wuaxn--dyry-iraxn--ec" +
	"kvdtc9dxn--efvn9southwestfalenxn--efvy88hakodatevaksdalxn--ehqz5" +
	"6nxn--elqq16hakonexn--estv75gxn--eveni-0qa01gaxn--f6qx53axn--fct" +
	"429kouzushimasoyxn--fhbeiarnxn--finny-yuaxn--fiq228c5hsowaxn--fi" +
	"q64basilicataniautoscanadaejeonbukariyakumoldebizenakaniikawatan" +
	"aguragroks-thisamitsukeisenbahnativeamericanantiques3-ap-southea" +
	"st-1xn--fiqs8spreadbettingxn--fiqz9spydebergxn--fjord-lraxn--fjq" +
	"720axn--fl-ziaxn--flor-jraxn--flw351exn--fpcrj9c3dxn--frde-grand" +
	"rapidsrlxn--frna-woaraisaijosoyrovigorlicexn--frya-hraxn--fzc2c9" +
	"e2chuvashiaxn--fzys8d69uvgmailxn--g2xx48circlegallocuscountryest" +
	"ateofdelawaredumbrellahppiacenzakopaneraircraftraeumtgeradealsta" +
	"haugesundyndns-wikindlegnicampobassociatesavannahgaxn--gckr3f0fe" +
	"rreroticanonoichikawamisatodayxn--gecrj9circuscultureggio-calabr" +
	"iaxn--ggaviika-8ya47hakubankmshinshiroxn--gildeskl-g0axn--givuot" +
	"na-8yandexn--3pxu8kotohiradomainsureitrentino-s-tirollagricultur" +
	"ennebudapest-a-la-masionxn--gjvik-wuaxn--gk3at1exn--gls-elacaixa" +
	"xn--gmq050is-very-nicexn--gmqw5axn--h-2fairwindsrtrentinosudtiro" +
	"lxn--h1aeghakuis-a-painteractivegarsheis-a-patsfanxn--h2brj9cita" +
	"deliverybnikahokutogliattiresaves-the-whalessandria-trani-barlet" +
	"ta-andriatranibarlettaandriaxn--hbmer-xqaxn--hcesuolo-7ya35baske" +
	"tballfinanzgoraveroykenvironmentalconservationatuurwetenschappen" +
	"aumburgjerstadotsuruokamakurazakisofukushimarnardalaziobirakuned" +
	"re-eikereviewskrakowebhopagefrontappagespeedmobilizerobihirosaki" +
	"kamijimaeroportalabamagasakishimabarackmaze-burggfarmerseinewyor" +
	"kshireggio-emilia-romagnakanotoddenasushiobarabruzzoologicalvink" +
	"lein-addrammenuernbergdyniabogadocscbg12000xn--hery-iraxn--hgebo" +
	"stad-g3axn--hmmrfeasta-s4acoachampionshiphopenair-surveillancebe" +
	"tsukubabia-goracleaningatlantachikawakayamagadancechirealtorland" +
	"xn--hnefoss-q1axn--hobl-iraxn--holtlen-hxaxn--hpmir-xqaxn--hxt81" +
	"4exn--hyanger-q1axn--hylandet-54axn--i1b6b1a6a2exn--imr513nxn--i" +
	"ndery-fyaotsurgutsiracusaitokyotangovtrverranzanxn--io0a7is-very" +
	"-sweetrentino-aadigexn--j1aefetsundxn--j1amhakusandnessjoenxn--j" +
	"6w193gxn--jlq61u9w7batochigiftsalzburgladeloittenrightathomeftpa" +
	"ccessamegawavocatanzaroweddingjesdalillesandefjordigitalillyokot" +
	"ehimeji234xn--jlster-byaroslavlaanderenxn--jrpeland-54axn--jvr18" +
	"9misasaguris-into-gamessinashikitchenxn--k7yn95exn--karmy-yuaxn-" +
	"-kbrq7oxn--kcrx77d1x4axn--kfjord-iuaxn--klbu-woaxn--klt787dxn--k" +
	"ltp7dxn--kltx9axn--klty5xn--42c2d9axn--koluokta-7ya57haldenxn--k" +
	"prw13dxn--kpry57dxn--kpu716fgxn--1lqs03nxn--kput3is-with-theband" +
	"oomdnsaliascolipicenord-odalxn--krager-gyasakaiminatoyakokamisat" +
	"ohobby-sitexasdaburyatiaarpharmacysnoasaitamatsukuris-lostre-tot" +
	"eneis-an-actorxn--kranghke-b0axn--krdsherad-m8axn--krehamn-dxaxn" +
	"--krjohka-hwab49jetztrentino-alto-adigexn--ksnes-uuaxn--kvfjord-" +
	"nxaxn--kvitsy-fyasugisleofmandalxn--kvnangen-k0axn--l-1faithegua" +
	"rdianquanconagawakuyabukicks-assediciticateringebugattipschmidtr" +
	"e-gauldalovegaskimitsubatamicadaquesaskatchewanggouvicenzaxn--l1" +
	"accentureklamborghiniizaxn--laheadju-7yasuokaratexn--langevg-jxa" +
	"xn--lcvr32dxn--ldingen-q1axn--leagaviika-52batsfjordnpalacemrxn-" +
	"-lesund-huaxn--lgbbat1ad8jevnakerxn--lgrd-poacivilaviationrwhali" +
	"ngrpalmspringsakerxn--lhppi-xqaxn--linds-pramericanartrysilkoshi" +
	"mizumakiyosumyokohamamatsudaxn--lns-qlanxessrvdonskoseis-an-anar" +
	"chistoricalsocietyxn--loabt-0qaxn--lrdal-sraxn--lrenskog-54axn--" +
	"lt-liacivilisationxn--lten-granexn--lury-iraxn--mely-iraxn--merk" +
	"er-kuaxn--mgb2ddestoragexn--mgb9awbfidelityumenxn--mgba3a3ejtula" +
	"nsomnaritakurashikis-not-certifiedogawarabikomaezakirunoshiroomu" +
	"raxn--mgba3a4f16axn--mgba3a4franamizuholdingsmileirvikozagawaxn-" +
	"-mgba7c0bbn0axn--mgbaakc7dvfidonnakamuratakahamannortonsbergzpan" +
	"amaxn--mgbaam7a8halsaintlouis-a-anarchistoirehabmerxn--mgbab2bdx" +
	"n--mgbai9a5eva00bauhausposts-and-telecommunicationsnasadodgeorge" +
	"orgiavoues3-us-gov-west-1xn--mgbai9azgqp6jewelryxn--mgbayh7gpadu" +
	"axn--mgbb9fbpobanazawaxn--mgbbh1a71exn--mgbc0a9azcgxn--mgbca7dzd" +
	"ownloadxn--mgberp4a5d4a87gxn--mgberp4a5d4arxn--mgbi4ecexposedxn-" +
	"-mgbpl2fhvalerxn--mgbqly7c0a67fbcivilizationxn--mgbqly7cvafredri" +
	"kstadtvstordalxn--mgbt3dhdxn--mgbtf8flekkefjordxn--mgbtx2bbcarti" +
	"erxn--mgbx4cd0abbvieeexn--mix082fieldxn--mix891figuerestaurantoy" +
	"onezawaxn--mjndalen-64axn--mk0axindustriesteamfamberkeleyxn--mk1" +
	"bu44civilwarmanagementjmaxxxn--0trq7p7nnxn--mkru45issmarterthany" +
	"ouxn--mlatvuopmi-s4axn--mli-tlapyatigorskozakis-an-engineeringxn" +
	"--mlselv-iuaxn--moreke-juaxn--mori-qsakuhokkaidontexisteingeekpn" +
	"xn--mosjen-eyatominamiawajikiwchiryukyuragifuefukihaborokunoheal" +
	"thcareersassaris-a-financialadvisor-aurdalowiczest-le-patrondhei" +
	"mperiaxn--mot-tlaquilancasterxn--mre-og-romsdal-qqbbtarumizusawa" +
	"xamusementarantomsk-uralsk12xn--msy-ula0hammarfeastafricamagiche" +
	"rnivtsiciliaxn--mtta-vrjjat-k7afamilycompanyclaimsavonaplesaxoxn" +
	"--muost-0qaxn--mxtq1misawaxn--ngbc5azdxn--ngbe9e0axn--nit225kpps" +
	"piegelxn--nmesjevuemie-tcbajddarchaeologyxn--nnx388axn--nodessak" +
	"uragawaxn--nqv7fs00emaxn--nry-yla5gxn--ntso0iqx3axn--ntsq17gxn--" +
	"nttery-byaeservegame-serverdalxn--nvuotna-hwaxn--nyqy26axn--o1ac" +
	"hattanooganorilskodjeffersonxn--o3cw4hamurakamigoriginshintokush" +
	"imaxn--od0algxn--od0aq3bbvacationswatch-and-clockerxn--ogbpf8fle" +
	"sbergxn--oppegrd-ixaxn--ostery-fyatsukaratsuginamikatagamihobole" +
	"slawieclickchristiansburgruexn--osyro-wuaxn--p1acfdxn--p1aixn--p" +
	"bt977clinicatholicasinorfolkebiblefrakkestadyndns-picsasebofagex" +
	"n--pgbs0dhlxn--porsgu-sta26filateliaxn--pssu33lxn--pssy2uxn--q9j" +
	"yb4cliniquenoharaxn--qcka1pmcdonaldstorenburgxn--qqqt11misconfus" +
	"edxn--qxamurskinderoyxn--rady-iraxn--rdal-poaxn--rde-ularvikrasn" +
	"odarxn--rdy-0nabarixn--rennesy-v1axn--rhkkervju-01aflakstadaokag" +
	"akibichuoxn--rholt-mragowoodsidexn--rhqv96gxn--rht27zxn--rht3dxn" +
	"--rht61exn--risa-5narusawaxn--risr-iraxn--rland-uuaxn--rlingen-m" +
	"xaxn--rmskog-byatsushiroxn--rny31hangoutsystemscloudcontrolappar" +
	"shintomikasaharaxn--rovu88beppubolognagasukepostfoldnavyatkakuda" +
	"matsuepsonyoursidegreevje-og-hornnesamnangerxn--rros-granvindafj" +
	"ordxn--rskog-uuaxn--rst-0narutokorozawaxn--rsta-francaiseharaxn-" +
	"-ryken-vuaxn--ryrvik-byawaraxn--s-1fareastcoastaldefencexn--s9br" +
	"j9clintonoshoesbschokoladenxn--sandnessjen-ogbizhevskrasnoyarsko" +
	"mmunalforbundxn--sandy-yuaxn--seral-lraxn--ses554gxn--sgne-grata" +
	"ngenxn--skierv-utazaskvolloabathsbclothinguideventscholarshipsch" +
	"oolukowhoswhokksundyndns-workshoppdaluroyxn--skjervy-v1axn--skjk" +
	"-soaxn--sknit-yqaxn--sknland-fxaxn--slat-5narviikananporovnoxn--" +
	"slt-elabourxn--smla-hraxn--smna-gratis-a-bulls-fanxn--snase-nrax" +
	"n--sndre-land-0cbremangerxn--snes-poaxn--snsa-roaxn--sr-aurdal-l" +
	"8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varanger-ggbernrtatamotor" +
	"samsclubindalindesnesamsunglassassinationalheritagematsubarakawa" +
	"goexn--srfold-byawatahamaxn--srreisa-q1axn--srum-grazxn--stfold-" +
	"9xaxn--stjrdal-s1axn--stjrdalshalsen-sqbeskidynaliascoli-picenor" +
	"d-frontierxn--stre-toten-zcbstorfjordxn--t60b56axn--tckweatherch" +
	"annelxn--tiq49xqyjewishartgalleryxn--tjme-hraxn--tn0agrigentomol" +
	"ogyeonggiehtavuoatnagaivuotnagaokakyotambabydgoszczecinemailxn--" +
	"tnsberg-q1axn--tor131oxn--trany-yuaxn--trgstad-r1axn--trna-woaxn" +
	"--troms-zuaxn--tysvr-vraxn--uc0atversicherungxn--uc0ay4axn--uist" +
	"22hannanmokuizumodernxn--uisz3gxn--unjrga-rtaobaokinawashirosato" +
	"bamagazinemurorangemologicallyngenglandxn--unup4yxn--uuwu58axn--" +
	"vads-jraxn--vard-jraxn--vegrshei-c0axn--vermgensberater-ctbestbu" +
	"yshousesanfranciscotlandrangedalinkashiwazakiyokawaraxn--vermgen" +
	"sberatung-pwbetainaboxfordeatnuorockartuzyurihonjournalistjordal" +
	"shalsenflatangerxn--vestvgy-ixa6oxn--vg-yiabcgxn--vgan-qoaxn--vg" +
	"sy-qoa0jfkomforbambleborkaruizawaugustowadaegubs3-eu-west-1xn--v" +
	"gu402cloudfrontdoorxn--vhquvestfoldxn--vler-qoaxn--vre-eiker-k8a" +
	"xn--vrggt-xqadxn--vry-yla5gxn--vuq861bhartiffanynysafetydalinzai" +
	"iyamanobedzin-the-bandaioirasebastopologyusuharaxn--w4r85el8fhu5" +
	"dnraxn--w4rs40lxn--wcvs22dxn--wgbh1cntjomemorialutskddielddanuor" +
	"rikuzentakatajirissagaeroclubmedecincinnationwidealerimo-i-ranad" +
	"exchangeiseiyoichiropracticbcn-north-1xn--wgbl6axn--xhq521bielaw" +
	"almartatarstanfshostrodawaraxn--xkc2al3hye2axn--xkc2dl3a5ee0hann" +
	"ovarggatrani-andria-barletta-trani-andriaxn--y9a3aquariumishimat" +
	"sumotofukexn--yer-znarvikredstonexn--yfro4i67oxn--ygarden-p1axn-" +
	"-ygbi2ammxn--45brj9christmasakikugawatchesauheradyndns-serverban" +
	"iaxn--ystre-slidre-ujbiellaakesvuemieleccexn--zbx025dxn--zf0ao64" +
	"axn--zf0avxn--45q11chromediaxn--zfr164bieszczadygeyachimataipeig" +
	"ersundrivelandrobaknoluoktainaibetsubamericanfamilydsmynaspersch" +
	"lesischesquarezzoologyeongnamegawakembuchikumagayagawakkanaikawa" +
	"chinaganoharamcoalaheadjudaicabbottateshinanomachintaijinfinitin" +
	"foggiaxperiaxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x002ffc03, // n0x0000 c0x0000 (---------------)  + I aaa
	0x003495c4, // n0x0001 c0x0000 (---------------)  + I aarp
	0x002634c6, // n0x0002 c0x0000 (---------------)  + I abarth
	0x00361383, // n0x0003 c0x0000 (---------------)  + I abb
	0x003a4746, // n0x0004 c0x0000 (---------------)  + I abbott
	0x00361386, // n0x0005 c0x0000 (---------------)  + I abbvie
	0x00394a83, // n0x0006 c0x0000 (---------------)  + I abc
	0x0031c444, // n0x0007 c0x0000 (---------------)  + I able
	0x0033a687, // n0x0008 c0x0000 (---------------)  + I abogado
	0x00263108, // n0x0009 c0x0000 (---------------)  + I abudhabi
	0x01a03982, // n0x000a c0x0006 (n0x05fe-n0x0604)  + I ac
	0x00301a47, // n0x000b c0x0000 (---------------)  + I academy
	0x0034f009, // n0x000c c0x0000 (---------------)  + I accenture
	0x002b610a, // n0x000d c0x0000 (---------------)  + I accountant
	0x002b610b, // n0x000e c0x0000 (---------------)  + I accountants
	0x0022a743, // n0x000f c0x0000 (---------------)  + I aco
	0x00332686, // n0x0010 c0x0000 (---------------)  + I active
	0x00233385, // n0x0011 c0x0000 (---------------)  + I actor
	0x01e0c682, // n0x0012 c0x0007 (n0x0604-n0x0605)  + I ad
	0x00210cc4, // n0x0013 c0x0000 (---------------)  + I adac
	0x00263643, // n0x0014 c0x0000 (---------------)  + I ads
	0x0029b705, // n0x0015 c0x0000 (---------------)  + I adult
	0x02203142, // n0x0016 c0x0008 (n0x0605-n0x060d)  + I ae
	0x003321c3, // n0x0017 c0x0000 (---------------)  + I aeg
	0x026dbdc4, // n0x0018 c0x0009 (n0x060d-n0x0664)  + I aero
	0x002ff1c5, // n0x0019 c0x0000 (---------------)  + I aetna
	0x02a00342, // n0x001a c0x000a (n0x0664-n0x0669)  + I af
	0x0036a78e, // n0x001b c0x0000 (---------------)  + I afamilycompany
	0x0024a983, // n0x001c c0x0000 (---------------)  + I afl
	0x00369cc6, // n0x001d c0x0000 (---------------)  + I africa
	0x00369ccb, // n0x001e c0x0000 (---------------)  + I africamagic
	0x02e00c42, // n0x001f c0x000b (n0x0669-n0x066e)  + I ag
	0x0027b707, // n0x0020 c0x0000 (---------------)  + I agakhan
	0x002361c6, // n0x0021 c0x0000 (---------------)  + I agency
	0x03204c82, // n0x0022 c0x000c (n0x066e-n0x0672)  + I ai
	0x0020ccc3, // n0x0023 c0x0000 (---------------)  + I aig
	0x0020ccc4, // n0x0024 c0x0000 (---------------)  + I aigo
	0x002055c6, // n0x0025 c0x0000 (---------------)  + I airbus
	0x00233008, // n0x0026 c0x0000 (---------------)  + I airforce
	0x00280706, // n0x0027 c0x0000 (---------------)  + I airtel
	0x002cc044, // n0x0028 c0x0000 (---------------)  + I akdn
	0x036001c2, // n0x0029 c0x000d (n0x0672-n0x0679)  + I al
	0x0031f3c9, // n0x002a c0x0000 (---------------)  + I alfaromeo
	0x0031c787, // n0x002b c0x0000 (---------------)  + I alibaba
	0x002b7186, // n0x002c c0x0000 (---------------)  + I alipay
	0x00335089, // n0x002d c0x0000 (---------------)  + I allfinanz
	0x00209cc8, // n0x002e c0x0000 (---------------)  + I allstate
	0x00390684, // n0x002f c0x0000 (---------------)  + I ally
	0x0021ce06, // n0x0030 c0x0000 (---------------)  + I alsace
	0x00204a06, // n0x0031 c0x0000 (---------------)  + I alstom
	0x03a01682, // n0x0032 c0x000e (n0x0679-n0x067a)  + I am
	0x0024144f, // n0x0033 c0x0000 (---------------)  + I americanexpress
	0x003a294e, // n0x0034 c0x0000 (---------------)  + I americanfamily
	0x0020ffc4, // n0x0035 c0x0000 (---------------)  + I amex
	0x00362b05, // n0x0036 c0x0000 (---------------)  + I amfam
	0x0034e645, // n0x0037 c0x0000 (---------------)  + I amica
	0x002b19c9, // n0x0038 c0x0000 (---------------)  + I amsterdam
	0x0023d549, // n0x0039 c0x0000 (---------------)  + I analytics
	0x0031dd07, // n0x003a c0x0000 (---------------)  + I android
	0x0034d0c6, // n0x003b c0x0000 (---------------)  + I anquan
	0x002486c3, // n0x003c c0x0000 (---------------)  + I anz
	0x03e01bc2, // n0x003d c0x000f (n0x067a-n0x0680)  + I ao
	0x00266cc3, // n0x003e c0x0000 (---------------)  + I aol
	0x002147ca, // n0x003f c0x0000 (---------------)  + I apartments
	0x00219183, // n0x0040 c0x0000 (---------------)  + I app
	0x00319dc5, // n0x0041 c0x0000 (---------------)  + I apple
	0x0027ef82, // n0x0042 c0x0000 (---------------)  + I aq
	0x0027ef89, // n0x0043 c0x0000 (---------------)  + I aquarelle
	0x04202942, // n0x0044 c0x0010 (n0x0680-n0x0689)  + I ar
	0x003a4286, // n0x0045 c0x0000 (---------------)  + I aramco
	0x002c1405, // n0x0046 c0x0000 (---------------)  + I archi
	0x00344d44, // n0x0047 c0x0000 (---------------)  + I army
	0x04a4cb84, // n0x0048 c0x0012 (n0x068a-n0x0690)  + I arpa
	0x00232504, // n0x0049 c0x0000 (---------------)  + I arte
	0x04e02642, // n0x004a c0x0013 (n0x0690-n0x0691)  + I as
	0x00349304, // n0x004b c0x0000 (---------------)  + I asda
	0x00314604, // n0x004c c0x0000 (---------------)  + I asia
	0x0032c80a, // n0x004d c0x0000 (---------------)  + I associates
	0x05200102, // n0x004e c0x0014 (n0x0691-n0x0698)  + I at
	0x0024e0c7, // n0x004f c0x0000 (---------------)  + I athleta
	0x002c18c8, // n0x0050 c0x0000 (---------------)  + I attorney
	0x05a04202, // n0x0051 c0x0016 (n0x0699-n0x06ab)  + I au
	0x00313607, // n0x0052 c0x0000 (---------------)  + I auction
	0x0022ccc4, // n0x0053 c0x0000 (---------------)  + I audi
	0x002cb147, // n0x0054 c0x0000 (---------------)  + I audible
	0x0022ccc5, // n0x0055 c0x0000 (---------------)  + I audio
	0x0035b507, // n0x0056 c0x0000 (---------------)  + I auspost
	0x0031dac6, // n0x0057 c0x0000 (---------------)  + I author
	0x0021dc84, // n0x0058 c0x0000 (---------------)  + I auto
	0x003253c5, // n0x0059 c0x0000 (---------------)  + I autos
	0x002cea87, // n0x005a c0x0000 (---------------)  + I avianca
	0x06a00cc2, // n0x005b c0x001a (n0x06b9-n0x06ba)  + I aw
	0x002eaf83, // n0x005c c0x0000 (---------------)  + I aws
	0x00222ec2, // n0x005d c0x0000 (---------------)  + I ax
	0x00368fc3, // n0x005e c0x0000 (---------------)  + I axa
	0x06e04402, // n0x005f c0x001b (n0x06ba-n0x06c6)  + I az
	0x00279845, // n0x0060 c0x0000 (---------------)  + I azure
	0x07201b82, // n0x0061 c0x001c (n0x06c6-n0x06d1)  + I ba
	0x0038ca04, // n0x0062 c0x0000 (---------------)  + I baby
	0x00274805, // n0x0063 c0x0000 (---------------)  + I baidu
	0x0020ff07, // n0x0064 c0x0000 (---------------)  + I banamex
	0x002dc20e, // n0x0065 c0x0000 (---------------)  + I bananarepublic
	0x003101c4, // n0x0066 c0x0000 (---------------)  + I band
	0x00203284, // n0x0067 c0x0000 (---------------)  + I bank
	0x00202903, // n0x0068 c0x0000 (---------------)  + I bar
	0x002bbe09, // n0x0069 c0x0000 (---------------)  + I barcelona
	0x002d3f4b, // n0x006a c0x0000 (---------------)  + I barclaycard
	0x002fd888, // n0x006b c0x0000 (---------------)  + I barclays
	0x00302808, // n0x006c c0x0000 (---------------)  + I barefoot
	0x00307c88, // n0x006d c0x0000 (---------------)  + I bargains
	0x002af3c8, // n0x006e c0x0000 (---------------)  + I baseball
	0x00334eca, // n0x006f c0x0000 (---------------)  + I basketball
	0x0035b407, // n0x0070 c0x0000 (---------------)  + I bauhaus
	0x002706c6, // n0x0071 c0x0000 (---------------)  + I bayern
	0x076c7142, // n0x0072 c0x001d (n0x06d1-n0x06db)  + I bb
	0x00360e43, // n0x0073 c0x0000 (---------------)  + I bbc
	0x00368c83, // n0x0074 c0x0000 (---------------)  + I bbt
	0x003705c4, // n0x0075 c0x0000 (---------------)  + I bbva
	0x00394ac3, // n0x0076 c0x0000 (---------------)  + I bcg
	0x0039b6c3, // n0x0077 c0x0000 (---------------)  + I bcn
	0x0170bd82, // n0x0078 c0x0005 (---------------)* o I bd
	0x07a02e82, // n0x0079 c0x001e (n0x06db-n0x06dd)  + I be
	0x00219045, // n0x007a c0x0000 (---------------)  + I beats
	0x0020e0c4, // n0x007b c0x0000 (---------------)  + I beer
	0x002de007, // n0x007c c0x0000 (---------------)  + I bentley
	0x0030b7c6, // n0x007d c0x0000 (---------------)  + I berlin
	0x00238a84, // n0x007e c0x0000 (---------------)  + I best
	0x00391e87, // n0x007f c0x0000 (---------------)  + I bestbuy
	0x002130c3, // n0x0080 c0x0000 (---------------)  + I bet
	0x07f56882, // n0x0081 c0x001f (n0x06dd-n0x06de)  + I bf
	0x082fb3c2, // n0x0082 c0x0020 (n0x06de-n0x0703)  + I bg
	0x08706042, // n0x0083 c0x0021 (n0x0703-n0x0708)  + I bh
	0x00397946, // n0x0084 c0x0000 (---------------)  + I bharti
	0x08a00002, // n0x0085 c0x0022 (n0x0708-n0x070d)  + I bi
	0x00373745, // n0x0086 c0x0000 (---------------)  + I bible
	0x0030d2c3, // n0x0087 c0x0000 (---------------)  + I bid
	0x00201744, // n0x0088 c0x0000 (---------------)  + I bike
	0x002d3d84, // n0x0089 c0x0000 (---------------)  + I bing
	0x002d3d85, // n0x008a c0x0000 (---------------)  + I bingo
	0x00204e03, // n0x008b c0x0000 (---------------)  + I bio
	0x08f25b83, // n0x008c c0x0023 (n0x070d-n0x0715)  + I biz
	0x09207642, // n0x008d c0x0024 (n0x0715-n0x0719)  + I bj
	0x00283f85, // n0x008e c0x0000 (---------------)  + I black
	0x00283f8b, // n0x008f c0x0000 (---------------)  + I blackfriday
	0x00252606, // n0x0090 c0x0000 (---------------)  + I blanco
	0x00208b8b, // n0x0091 c0x0000 (---------------)  + I blockbuster
	0x00225384, // n0x0092 c0x0000 (---------------)  + I blog
	0x0020a289, // n0x0093 c0x0000 (---------------)  + I bloomberg
	0x0020a9c4, // n0x0094 c0x0000 (---------------)  + I blue
	0x0960b542, // n0x0095 c0x0025 (n0x0719-n0x071e)  + I bm
	0x0020bb83, // n0x0096 c0x0000 (---------------)  + I bms
	0x0020bf03, // n0x0097 c0x0000 (---------------)  + I bmw
	0x0160d3c2, // n0x0098 c0x0005 (---------------)* o I bn
	0x00234e43, // n0x0099 c0x0000 (---------------)  + I bnl
	0x0020d3ca, // n0x009a c0x0000 (---------------)  + I bnpparibas
	0x09a0c182, // n0x009b c0x0026 (n0x071e-n0x0727)  + I bo
	0x00210f45, // n0x009c c0x0000 (---------------)  + I boats
	0x0028b10a, // n0x009d c0x0000 (---------------)  + I boehringer
	0x00373e44, // n0x009e c0x0000 (---------------)  + I bofa
	0x0020ec83, // n0x009f c0x0000 (---------------)  + I bom
	0x0020fd84, // n0x00a0 c0x0000 (---------------)  + I bond
	0x00210743, // n0x00a1 c0x0000 (---------------)  + I boo
	0x00210744, // n0x00a2 c0x0000 (---------------)  + I book
	0x00210747, // n0x00a3 c0x0000 (---------------)  + I booking
	0x00212745, // n0x00a4 c0x0000 (---------------)  + I boots
	0x00213385, // n0x00a5 c0x0000 (---------------)  + I bosch
	0x00214e86, // n0x00a6 c0x0000 (---------------)  + I bostik
	0x00217743, // n0x00a7 c0x0000 (---------------)  + I bot
	0x00219c48, // n0x00a8 c0x0000 (---------------)  + I boutique
	0x09e1ac42, // n0x00a9 c0x0027 (n0x0727-n0x076d)  + I br
	0x0021ac48, // n0x00aa c0x0000 (---------------)  + I bradesco
	0x0022944b, // n0x00ab c0x0000 (---------------)  + I bridgestone
	0x0021ea08, // n0x00ac c0x0000 (---------------)  + I broadway
	0x00220246, // n0x00ad c0x0000 (---------------)  + I broker
	0x00221047, // n0x00ae c0x0000 (---------------)  + I brother
	0x00223708, // n0x00af c0x0000 (---------------)  + I brussels
	0x0a6a0ec2, // n0x00b0 c0x0029 (n0x076e-n0x0773)  + I bs
	0x0aa1e182, // n0x00b1 c0x002a (n0x0773-n0x0778)  + I bt
	0x00330108, // n0x00b2 c0x0000 (---------------)  + I budapest
	0x0034dc07, // n0x00b3 c0x0000 (---------------)  + I bugatti
	0x0023b305, // n0x00b4 c0x0000 (---------------)  + I build
	0x002d3108, // n0x00b5 c0x0000 (---------------)  + I builders
	0x002ade08, // n0x00b6 c0x0000 (---------------)  + I business
	0x002dfac3, // n0x00b7 c0x0000 (---------------)  + I buy
	0x00228bc4, // n0x00b8 c0x0000 (---------------)  + I buzz
	0x00361402, // n0x00b9 c0x0000 (---------------)  + I bv
	0x0ae298c2, // n0x00ba c0x002b (n0x0778-n0x077a)  + I bw
	0x0b20a0c2, // n0x00bb c0x002c (n0x077a-n0x077e)  + I by
	0x0ba29d02, // n0x00bc c0x002e (n0x077f-n0x0785)  + I bz
	0x00229d03, // n0x00bd c0x0000 (---------------)  + I bzh
	0x0be00302, // n0x00be c0x002f (n0x0785-n0x0796)  + I ca
	0x003a4703, // n0x00bf c0x0000 (---------------)  + I cab
	0x00200304, // n0x00c0 c0x0000 (---------------)  + I cafe
	0x002178c3, // n0x00c1 c0x0000 (---------------)  + I cal
	0x00390644, // n0x00c2 c0x0000 (---------------)  + I call
	0x00339e4b, // n0x00c3 c0x0000 (---------------)  + I calvinklein
	0x0031df06, // n0x00c4 c0x0000 (---------------)  + I camera
	0x0023bec4, // n0x00c5 c0x0000 (---------------)  + I camp
	0x00297ece, // n0x00c6 c0x0000 (---------------)  + I cancerresearch
	0x0032d1c5, // n0x00c7 c0x0000 (---------------)  + I canon
	0x002afa48, // n0x00c8 c0x0000 (---------------)  + I capetown
	0x002cebc7, // n0x00c9 c0x0000 (---------------)  + I capital
	0x002cebca, // n0x00ca c0x0000 (---------------)  + I capitalone
	0x00203ac3, // n0x00cb c0x0000 (---------------)  + I car
	0x00230807, // n0x00cc c0x0000 (---------------)  + I caravan
	0x002d4105, // n0x00cd c0x0000 (---------------)  + I cards
	0x00367084, // n0x00ce c0x0000 (---------------)  + I care
	0x00367086, // n0x00cf c0x0000 (---------------)  + I career
	0x00367087, // n0x00d0 c0x0000 (---------------)  + I careers
	0x002d2804, // n0x00d1 c0x0000 (---------------)  + I cars
	0x00360ec7, // n0x00d2 c0x0000 (---------------)  + I cartier
	0x0020c5c4, // n0x00d3 c0x0000 (---------------)  + I casa
	0x00212dc4, // n0x00d4 c0x0000 (---------------)  + I case
	0x00212dc6, // n0x00d5 c0x0000 (---------------)  + I caseih
	0x002c8704, // n0x00d6 c0x0000 (---------------)  + I cash
	0x00373446, // n0x00d7 c0x0000 (---------------)  + I casino
	0x00210583, // n0x00d8 c0x0000 (---------------)  + I cat
	0x0034d9c8, // n0x00d9 c0x0000 (---------------)  + I catering
	0x00373288, // n0x00da c0x0000 (---------------)  + I catholic
	0x00243f43, // n0x00db c0x0000 (---------------)  + I cba
	0x00234e03, // n0x00dc c0x0000 (---------------)  + I cbn
	0x003853c4, // n0x00dd c0x0000 (---------------)  + I cbre
	0x0038a683, // n0x00de c0x0000 (---------------)  + I cbs
	0x0c21e542, // n0x00df c0x0030 (n0x0796-n0x079a)  + I cc
	0x0c636502, // n0x00e0 c0x0031 (n0x079a-n0x079b)  + I cd
	0x002075c3, // n0x00e1 c0x0000 (---------------)  + I ceb
	0x00205146, // n0x00e2 c0x0000 (---------------)  + I center
	0x00233183, // n0x00e3 c0x0000 (---------------)  + I ceo
	0x002afe44, // n0x00e4 c0x0000 (---------------)  + I cern
	0x0ca15c02, // n0x00e5 c0x0032 (n0x079b-n0x079c)  + I cf
	0x00215c03, // n0x00e6 c0x0000 (---------------)  + I cfa
	0x00372c03, // n0x00e7 c0x0000 (---------------)  + I cfd
	0x00219482, // n0x00e8 c0x0000 (---------------)  + I cg
	0x0ce02302, // n0x00e9 c0x0033 (n0x079c-n0x079d)  + I ch
	0x002b5146, // n0x00ea c0x0000 (---------------)  + I chanel
	0x00234287, // n0x00eb c0x0000 (---------------)  + I channel
	0x0031fdc5, // n0x00ec c0x0000 (---------------)  + I chase
	0x00218784, // n0x00ed c0x0000 (---------------)  + I chat
	0x0027c105, // n0x00ee c0x0000 (---------------)  + I cheap
	0x003a4bc7, // n0x00ef c0x0000 (---------------)  + I chintai
	0x002a8d45, // n0x00f0 c0x0000 (---------------)  + I chloe
	0x0039f4c9, // n0x00f1 c0x0000 (---------------)  + I christmas
	0x003a14c6, // n0x00f2 c0x0000 (---------------)  + I chrome
	0x002f8ac8, // n0x00f3 c0x0000 (---------------)  + I chrysler
	0x0031fcc6, // n0x00f4 c0x0000 (---------------)  + I church
	0x0d2039c2, // n0x00f5 c0x0034 (n0x079d-n0x07ac)  + I ci
	0x00275548, // n0x00f6 c0x0000 (---------------)  + I cipriani
	0x0032aa06, // n0x00f7 c0x0000 (---------------)  + I circle
	0x00392385, // n0x00f8 c0x0000 (---------------)  + I cisco
	0x00332f07, // n0x00f9 c0x0000 (---------------)  + I citadel
	0x0034d8c4, // n0x00fa c0x0000 (---------------)  + I citi
	0x0034d8c5, // n0x00fb c0x0000 (---------------)  + I citic
	0x002808c4, // n0x00fc c0x0000 (---------------)  + I city
	0x002808c8, // n0x00fd c0x0000 (---------------)  + I cityeats
	0x0d604002, // n0x00fe c0x0035 (n0x07ac-n0x07ad)* o I ck
	0x0da1f902, // n0x00ff c0x0036 (n0x07ad-n0x07b2)  + I cl
	0x0036ab06, // n0x0100 c0x0000 (---------------)  + I claims
	0x0033c3c8, // n0x0101 c0x0000 (---------------)  + I cleaning
	0x00372185, // n0x0102 c0x0000 (---------------)  + I click
	0x00373146, // n0x0103 c0x0000 (---------------)  + I clinic
	0x003750c8, // n0x0104 c0x0000 (---------------)  + I clinique
	0x00381888, // n0x0105 c0x0000 (---------------)  + I clothing
	0x002d5e05, // n0x0106 c0x0000 (---------------)  + I cloud
	0x00387104, // n0x0107 c0x0000 (---------------)  + I club
	0x0039a647, // n0x0108 c0x0000 (---------------)  + I clubmed
	0x0de56182, // n0x0109 c0x0037 (n0x07b2-n0x07b6)  + I cm
	0x0e219ec2, // n0x010a c0x0038 (n0x07b6-n0x07e3)  + I cn
	0x0fa03dc2, // n0x010b c0x003e (n0x07e8-n0x07f5)  + I co
	0x0033b685, // n0x010c c0x0000 (---------------)  + I coach
	0x00294405, // n0x010d c0x0000 (---------------)  + I codes
	0x00203dc6, // n0x010e c0x0000 (---------------)  + I coffee
	0x0021e587, // n0x010f c0x0000 (---------------)  + I college
	0x0022a787, // n0x0110 c0x0000 (---------------)  + I cologne
	0x1022d0c3, // n0x0111 c0x0040 (n0x07f6-n0x08c6)  + I com
	0x002831c7, // n0x0112 c0x0000 (---------------)  + I comcast
	0x002d1448, // n0x0113 c0x0000 (---------------)  + I commbank
	0x0022d0c9, // n0x0114 c0x0000 (---------------)  + I community
	0x0036a947, // n0x0115 c0x0000 (---------------)  + I company
	0x0022da47, // n0x0116 c0x0000 (---------------)  + I compare
	0x0022edc8, // n0x0117 c0x0000 (---------------)  + I computer
	0x0022f5c6, // n0x0118 c0x0000 (---------------)  + I comsec
	0x00230006, // n0x0119 c0x0000 (---------------)  + I condos
	0x00230d0c, // n0x011a c0x0000 (---------------)  + I construction
	0x0023188a, // n0x011b c0x0000 (---------------)  + I consulting
	0x00231d47, // n0x011c c0x0000 (---------------)  + I contact
	0x0023324b, // n0x011d c0x0000 (---------------)  + I contractors
	0x002340c7, // n0x011e c0x0000 (---------------)  + I cooking
	0x002340ce, // n0x011f c0x0000 (---------------)  + I cookingchannel
	0x00234bc4, // n0x0120 c0x0000 (---------------)  + I cool
	0x00235044, // n0x0121 c0x0000 (---------------)  + I coop
	0x00236c47, // n0x0122 c0x0000 (---------------)  + I corsica
	0x0032ad87, // n0x0123 c0x0000 (---------------)  + I country
	0x0023c7c6, // n0x0124 c0x0000 (---------------)  + I coupon
	0x0023c7c7, // n0x0125 c0x0000 (---------------)  + I coupons
	0x0023cdc7, // n0x0126 c0x0000 (---------------)  + I courses
	0x1160ef82, // n0x0127 c0x0045 (n0x08e4-n0x08eb)  + I cr
	0x0023da86, // n0x0128 c0x0000 (---------------)  + I credit
	0x0023da8a, // n0x0129 c0x0000 (---------------)  + I creditcard
	0x0023dd0b, // n0x012a c0x0000 (---------------)  + I creditunion
	0x0023ee07, // n0x012b c0x0000 (---------------)  + I cricket
	0x0023f7c5, // n0x012c c0x0000 (---------------)  + I crown
	0x0023f903, // n0x012d c0x0000 (---------------)  + I crs
	0x00240247, // n0x012e c0x0000 (---------------)  + I cruises
	0x0023d703, // n0x012f c0x0000 (---------------)  + I csc
	0x11a1f802, // n0x0130 c0x0046 (n0x08eb-n0x08f1)  + I cu
	0x002410ca, // n0x0131 c0x0000 (---------------)  + I cuisinella
	0x11f50142, // n0x0132 c0x0047 (n0x08f1-n0x08f2)  + I cv
	0x122c52c2, // n0x0133 c0x0048 (n0x08f2-n0x08f6)  + I cw
	0x12642c42, // n0x0134 c0x0049 (n0x08f6-n0x08f8)  + I cx
	0x12a362c2, // n0x0135 c0x004a (n0x08f8-n0x0905)  o I cy
	0x00243645, // n0x0136 c0x0000 (---------------)  + I cymru
	0x00243d44, // n0x0137 c0x0000 (---------------)  + I cyou
	0x13235182, // n0x0138 c0x004c (n0x0906-n0x0907)  + I cz
	0x00349385, // n0x0139 c0x0000 (---------------)  + I dabur
	0x0029b6c3, // n0x013a c0x0000 (---------------)  + I dad
	0x0033cb45, // n0x013b c0x0000 (---------------)  + I dance
	0x0020b444, // n0x013c c0x0000 (---------------)  + I date
	0x0020aac6, // n0x013d c0x0000 (---------------)  + I dating
	0x00289106, // n0x013e c0x0000 (---------------)  + I datsun
	0x00284183, // n0x013f c0x0000 (---------------)  + I day
	0x0028a244, // n0x0140 c0x0000 (---------------)  + I dclk
	0x002d6183, // n0x0141 c0x0000 (---------------)  + I dds
	0x13600402, // n0x0142 c0x004d (n0x0907-n0x090f)  + I de
	0x0032be44, // n0x0143 c0x0000 (---------------)  + I deal
	0x0039abc6, // n0x0144 c0x0000 (---------------)  + I dealer
	0x0032be45, // n0x0145 c0x0000 (---------------)  + I deals
	0x0037c406, // n0x0146 c0x0000 (---------------)  + I degree
	0x00333008, // n0x0147 c0x0000 (---------------)  + I delivery
	0x00253704, // n0x0148 c0x0000 (---------------)  + I dell
	0x00341a08, // n0x0149 c0x0000 (---------------)  + I deloitte
	0x002f9d85, // n0x014a c0x0000 (---------------)  + I delta
	0x00222cc8, // n0x014b c0x0000 (---------------)  + I democrat
	0x002a5006, // n0x014c c0x0000 (---------------)  + I dental
	0x002ac2c7, // n0x014d c0x0000 (---------------)  + I dentist
	0x002289c4, // n0x014e c0x0000 (---------------)  + I desi
	0x002289c6, // n0x014f c0x0000 (---------------)  + I design
	0x00381b03, // n0x0150 c0x0000 (---------------)  + I dev
	0x00374203, // n0x0151 c0x0000 (---------------)  + I dhl
	0x002bf448, // n0x0152 c0x0000 (---------------)  + I diamonds
	0x003061c4, // n0x0153 c0x0000 (---------------)  + I diet
	0x00342c47, // n0x0154 c0x0000 (---------------)  + I digital
	0x00246986, // n0x0155 c0x0000 (---------------)  + I direct
	0x00246989, // n0x0156 c0x0000 (---------------)  + I directory
	0x00226208, // n0x0157 c0x0000 (---------------)  + I discount
	0x00238bc8, // n0x0158 c0x0000 (---------------)  + I discover
	0x002564c4, // n0x0159 c0x0000 (---------------)  + I dish
	0x0031cdc3, // n0x015a c0x0000 (---------------)  + I diy
	0x00246f02, // n0x015b c0x0000 (---------------)  + I dj
	0x13a677c2, // n0x015c c0x004e (n0x090f-n0x0910)  + I dk
	0x13e07882, // n0x015d c0x004f (n0x0910-n0x0915)  + I dm
	0x00350cc3, // n0x015e c0x0000 (---------------)  + I dnp
	0x1420cdc2, // n0x015f c0x0050 (n0x0915-n0x091f)  + I do
	0x0033a7c4, // n0x0160 c0x0000 (---------------)  + I docs
	0x0035bdc5, // n0x0161 c0x0000 (---------------)  + I dodge
	0x0023ec83, // n0x0162 c0x0000 (---------------)  + I dog
	0x002311c4, // n0x0163 c0x0000 (---------------)  + I doha
	0x0032f687, // n0x0164 c0x0000 (---------------)  + I domains
	0x0022e686, // n0x0165 c0x0000 (---------------)  + I doosan
	0x00336343, // n0x0166 c0x0000 (---------------)  + I dot
	0x0035dfc8, // n0x0167 c0x0000 (---------------)  + I download
	0x003a2145, // n0x0168 c0x0000 (---------------)  + I drive
	0x00286a04, // n0x0169 c0x0000 (---------------)  + I dstv
	0x00360103, // n0x016a c0x0000 (---------------)  + I dtv
	0x00274785, // n0x016b c0x0000 (---------------)  + I dubai
	0x002748c4, // n0x016c c0x0000 (---------------)  + I duck
	0x002037c6, // n0x016d c0x0000 (---------------)  + I dunlop
	0x00206284, // n0x016e c0x0000 (---------------)  + I duns
	0x00208ec6, // n0x016f c0x0000 (---------------)  + I dupont
	0x0020fe46, // n0x0170 c0x0000 (---------------)  + I durban
	0x00310784, // n0x0171 c0x0000 (---------------)  + I dvag
	0x0021e843, // n0x0172 c0x0000 (---------------)  + I dwg
	0x14607182, // n0x0173 c0x0051 (n0x091f-n0x0927)  + I dz
	0x0027b5c5, // n0x0174 c0x0000 (---------------)  + I earth
	0x00219083, // n0x0175 c0x0000 (---------------)  + I eat
	0x14a03d82, // n0x0176 c0x0052 (n0x0927-n0x0933)  + I ec
	0x002b3785, // n0x0177 c0x0000 (---------------)  + I edeka
	0x002325c3, // n0x0178 c0x0000 (---------------)  + I edu
	0x002325c9, // n0x0179 c0x0000 (---------------)  + I education
	0x14e03502, // n0x017a c0x0053 (n0x0933-n0x093d)  + I ee
	0x1560b0c2, // n0x017b c0x0055 (n0x093e-n0x0947)  + I eg
	0x0038cdc5, // n0x017c c0x0000 (---------------)  + I email
	0x002ac686, // n0x017d c0x0000 (---------------)  + I emerck
	0x0024e507, // n0x017e c0x0000 (---------------)  + I emerson
	0x002c6d06, // n0x017f c0x0000 (---------------)  + I energy
	0x00364cc8, // n0x0180 c0x0000 (---------------)  + I engineer
	0x00364ccb, // n0x0181 c0x0000 (---------------)  + I engineering
	0x0020518b, // n0x0182 c0x0000 (---------------)  + I enterprises
	0x0037bac5, // n0x0183 c0x0000 (---------------)  + I epost
	0x0037c145, // n0x0184 c0x0000 (---------------)  + I epson
	0x002bd849, // n0x0185 c0x0000 (---------------)  + I equipment
	0x01600442, // n0x0186 c0x0005 (---------------)* o I er
	0x00310948, // n0x0187 c0x0000 (---------------)  + I ericsson
	0x00208dc4, // n0x0188 c0x0000 (---------------)  + I erni
	0x15e013c2, // n0x0189 c0x0057 (n0x0948-n0x094d)  + I es
	0x003a31c3, // n0x018a c0x0000 (---------------)  + I esq
	0x002bd5c6, // n0x018b c0x0000 (---------------)  + I estate
	0x0027ebc8, // n0x018c c0x0000 (---------------)  + I esurance
	0x16608802, // n0x018d c0x0059 (n0x094e-n0x0956)  + I et
	0x00222508, // n0x018e c0x0000 (---------------)  + I etisalat
	0x00225c02, // n0x018f c0x0000 (---------------)  + I eu
	0x00277bca, // n0x0190 c0x0000 (---------------)  + I eurovision
	0x00225c03, // n0x0191 c0x0000 (---------------)  + I eus
	0x00381b46, // n0x0192 c0x0000 (---------------)  + I events
	0x00203188, // n0x0193 c0x0000 (---------------)  + I everbank
	0x0039b008, // n0x0194 c0x0000 (---------------)  + I exchange
	0x0031c106, // n0x0195 c0x0000 (---------------)  + I expert
	0x0035ed87, // n0x0196 c0x0000 (---------------)  + I exposed
	0x00241647, // n0x0197 c0x0000 (---------------)  + I express
	0x0020458a, // n0x0198 c0x0000 (---------------)  + I extraspace
	0x00373ec4, // n0x0199 c0x0000 (---------------)  + I fage
	0x00215c44, // n0x019a c0x0000 (---------------)  + I fail
	0x003319c9, // n0x019b c0x0000 (---------------)  + I fairwinds
	0x0034cdc5, // n0x019c c0x0000 (---------------)  + I faith
	0x0036a7c6, // n0x019d c0x0000 (---------------)  + I family
	0x00211483, // n0x019e c0x0000 (---------------)  + I fan
	0x002d9a04, // n0x019f c0x0000 (---------------)  + I fans
	0x002bd744, // n0x01a0 c0x0000 (---------------)  + I farm
	0x00338c47, // n0x01a1 c0x0000 (---------------)  + I farmers
	0x00229947, // n0x01a2 c0x0000 (---------------)  + I fashion
	0x0023ba84, // n0x01a3 c0x0000 (---------------)  + I fast
	0x0020f1c5, // n0x01a4 c0x0000 (---------------)  + I fedex
	0x00203e88, // n0x01a5 c0x0000 (---------------)  + I feedback
	0x002f5f47, // n0x01a6 c0x0000 (---------------)  + I ferrari
	0x0032cf87, // n0x01a7 c0x0000 (---------------)  + I ferrero
	0x16a03a42, // n0x01a8 c0x005a (n0x0956-n0x0959)  + I fi
	0x0028de44, // n0x01a9 c0x0000 (---------------)  + I fiat
	0x003568c8, // n0x01aa c0x0000 (---------------)  + I fidelity
	0x003596c4, // n0x01ab c0x0000 (---------------)  + I fido
	0x00244544, // n0x01ac c0x0000 (---------------)  + I film
	0x00244905, // n0x01ad c0x0000 (---------------)  + I final
	0x00244a47, // n0x01ae c0x0000 (---------------)  + I finance
	0x00208549, // n0x01af c0x0000 (---------------)  + I financial
	0x002454c4, // n0x01b0 c0x0000 (---------------)  + I fire
	0x002466c9, // n0x01b1 c0x0000 (---------------)  + I firestone
	0x00246bc8, // n0x01b2 c0x0000 (---------------)  + I firmdale
	0x002476c4, // n0x01b3 c0x0000 (---------------)  + I fish
	0x002476c7, // n0x01b4 c0x0000 (---------------)  + I fishing
	0x00247c83, // n0x01b5 c0x0000 (---------------)  + I fit
	0x00248e47, // n0x01b6 c0x0000 (---------------)  + I fitness
	0x01615242, // n0x01b7 c0x0005 (---------------)* o I fj
	0x01795202, // n0x01b8 c0x0005 (---------------)* o I fk
	0x00249506, // n0x01b9 c0x0000 (---------------)  + I flickr
	0x0024a107, // n0x01ba c0x0000 (---------------)  + I flights
	0x0024a9c4, // n0x01bb c0x0000 (---------------)  + I flir
	0x0024c107, // n0x01bc c0x0000 (---------------)  + I florist
	0x0024c987, // n0x01bd c0x0000 (---------------)  + I flowers
	0x0024cec8, // n0x01be c0x0000 (---------------)  + I flsmidth
	0x0024d543, // n0x01bf c0x0000 (---------------)  + I fly
	0x0022c142, // n0x01c0 c0x0000 (---------------)  + I fm
	0x002330c2, // n0x01c1 c0x0000 (---------------)  + I fo
	0x0024f903, // n0x01c2 c0x0000 (---------------)  + I foo
	0x0024f90b, // n0x01c3 c0x0000 (---------------)  + I foodnetwork
	0x00302908, // n0x01c4 c0x0000 (---------------)  + I football
	0x00393584, // n0x01c5 c0x0000 (---------------)  + I ford
	0x00251005, // n0x01c6 c0x0000 (---------------)  + I forex
	0x00252b07, // n0x01c7 c0x0000 (---------------)  + I forsale
	0x00254405, // n0x01c8 c0x0000 (---------------)  + I forum
	0x002b3eca, // n0x01c9 c0x0000 (---------------)  + I foundation
	0x00255a83, // n0x01ca c0x0000 (---------------)  + I fox
	0x16e35842, // n0x01cb c0x005b (n0x0959-n0x0971)  + I fr
	0x00256ac9, // n0x01cc c0x0000 (---------------)  + I fresenius
	0x0025a803, // n0x01cd c0x0000 (---------------)  + I frl
	0x0025a8c7, // n0x01ce c0x0000 (---------------)  + I frogans
	0x00396289, // n0x01cf c0x0000 (---------------)  + I frontdoor
	0x0038a088, // n0x01d0 c0x0000 (---------------)  + I frontier
	0x002c8c43, // n0x01d1 c0x0000 (---------------)  + I ftr
	0x002738c7, // n0x01d2 c0x0000 (---------------)  + I fujitsu
	0x00273dc9, // n0x01d3 c0x0000 (---------------)  + I fujixerox
	0x0027ba84, // n0x01d4 c0x0000 (---------------)  + I fund
	0x0027d409, // n0x01d5 c0x0000 (---------------)  + I furniture
	0x00282206, // n0x01d6 c0x0000 (---------------)  + I futbol
	0x002836c3, // n0x01d7 c0x0000 (---------------)  + I fyi
	0x00200c82, // n0x01d8 c0x0000 (---------------)  + I ga
	0x0021cdc3, // n0x01d9 c0x0000 (---------------)  + I gal
	0x0038b687, // n0x01da c0x0000 (---------------)  + I gallery
	0x0032ab85, // n0x01db c0x0000 (---------------)  + I gallo
	0x002dc006, // n0x01dc c0x0000 (---------------)  + I gallup
	0x00290184, // n0x01dd c0x0000 (---------------)  + I game
	0x00344485, // n0x01de c0x0000 (---------------)  + I games
	0x00214783, // n0x01df c0x0000 (---------------)  + I gap
	0x00217986, // n0x01e0 c0x0000 (---------------)  + I garden
	0x0020a482, // n0x01e1 c0x0000 (---------------)  + I gb
	0x0037fb04, // n0x01e2 c0x0000 (---------------)  + I gbiz
	0x00221d82, // n0x01e3 c0x0000 (---------------)  + I gd
	0x00225443, // n0x01e4 c0x0000 (---------------)  + I gdn
	0x172018c2, // n0x01e5 c0x005c (n0x0971-n0x0978)  + I ge
	0x0023fd03, // n0x01e6 c0x0000 (---------------)  + I gea
	0x002163c4, // n0x01e7 c0x0000 (---------------)  + I gent
	0x002163c7, // n0x01e8 c0x0000 (---------------)  + I genting
	0x0035be86, // n0x01e9 c0x0000 (---------------)  + I george
	0x0024c942, // n0x01ea c0x0000 (---------------)  + I gf
	0x17638e02, // n0x01eb c0x005d (n0x0978-n0x097b)  + I gg
	0x00238e04, // n0x01ec c0x0000 (---------------)  + I ggee
	0x17a4a1c2, // n0x01ed c0x005e (n0x097b-n0x0980)  + I gh
	0x17e12d42, // n0x01ee c0x005f (n0x0980-n0x0986)  + I gi
	0x00341684, // n0x01ef c0x0000 (---------------)  + I gift
	0x00341685, // n0x01f0 c0x0000 (---------------)  + I gifts
	0x00217dc5, // n0x01f1 c0x0000 (---------------)  + I gives
	0x00257386, // n0x01f2 c0x0000 (---------------)  + I giving
	0x1820a802, // n0x01f3 c0x0060 (n0x0986-n0x098b)  + I gl
	0x00341945, // n0x01f4 c0x0000 (---------------)  + I glade
	0x00387685, // n0x01f5 c0x0000 (---------------)  + I glass
	0x0027f2c3, // n0x01f6 c0x0000 (---------------)  + I gle
	0x0020ac06, // n0x01f7 c0x0000 (---------------)  + I global
	0x0020d785, // n0x01f8 c0x0000 (---------------)  + I globo
	0x00211cc2, // n0x01f9 c0x0000 (---------------)  + I gm
	0x0032a645, // n0x01fa c0x0000 (---------------)  + I gmail
	0x00213903, // n0x01fb c0x0000 (---------------)  + I gmo
	0x00216543, // n0x01fc c0x0000 (---------------)  + I gmx
	0x186082c2, // n0x01fd c0x0061 (n0x098b-n0x0991)  + I gn
	0x002ec247, // n0x01fe c0x0000 (---------------)  + I godaddy
	0x002f61c4, // n0x01ff c0x0000 (---------------)  + I gold
	0x002f61c9, // n0x0200 c0x0000 (---------------)  + I goldpoint
	0x00246dc4, // n0x0201 c0x0000 (---------------)  + I golf
	0x0026b283, // n0x0202 c0x0000 (---------------)  + I goo
	0x00315349, // n0x0203 c0x0000 (---------------)  + I goodhands
	0x0027b488, // n0x0204 c0x0000 (---------------)  + I goodyear
	0x00294284, // n0x0205 c0x0000 (---------------)  + I goog
	0x00294286, // n0x0206 c0x0000 (---------------)  + I google
	0x0029d043, // n0x0207 c0x0000 (---------------)  + I gop
	0x00212283, // n0x0208 c0x0000 (---------------)  + I got
	0x002d3e44, // n0x0209 c0x0000 (---------------)  + I gotv
	0x00264783, // n0x020a c0x0000 (---------------)  + I gov
	0x18ad19c2, // n0x020b c0x0062 (n0x0991-n0x0997)  + I gp
	0x002f7102, // n0x020c c0x0000 (---------------)  + I gq
	0x18e008c2, // n0x020d c0x0063 (n0x0997-n0x099d)  + I gr
	0x0030ee08, // n0x020e c0x0000 (---------------)  + I grainger
	0x00313a48, // n0x020f c0x0000 (---------------)  + I graphics
	0x00384806, // n0x0210 c0x0000 (---------------)  + I gratis
	0x00247b45, // n0x0211 c0x0000 (---------------)  + I green
	0x0021e8c5, // n0x0212 c0x0000 (---------------)  + I gripe
	0x0020fb45, // n0x0213 c0x0000 (---------------)  + I group
	0x0028fbc2, // n0x0214 c0x0000 (---------------)  + I gs
	0x1928a142, // n0x0215 c0x0064 (n0x099d-n0x09a4)  + I gt
	0x0160b102, // n0x0216 c0x0005 (---------------)* o I gu
	0x0034cf48, // n0x0217 c0x0000 (---------------)  + I guardian
	0x00275485, // n0x0218 c0x0000 (---------------)  + I gucci
	0x002d9104, // n0x0219 c0x0000 (---------------)  + I guge
	0x00381a45, // n0x021a c0x0000 (---------------)  + I guide
	0x0022bc07, // n0x021b c0x0000 (---------------)  + I guitars
	0x0024af04, // n0x021c c0x0000 (---------------)  + I guru
	0x00212082, // n0x021d c0x0000 (---------------)  + I gw
	0x19601082, // n0x021e c0x0065 (n0x09a4-n0x09a7)  + I gy
	0x00211b47, // n0x021f c0x0000 (---------------)  + I hamburg
	0x0037a847, // n0x0220 c0x0000 (---------------)  + I hangout
	0x0035b4c4, // n0x0221 c0x0000 (---------------)  + I haus
	0x0028b0c3, // n0x0222 c0x0000 (---------------)  + I hbo
	0x00243e84, // n0x0223 c0x0000 (---------------)  + I hdfc
	0x00243e88, // n0x0224 c0x0000 (---------------)  + I hdfcbank
	0x00366f06, // n0x0225 c0x0000 (---------------)  + I health
	0x00366f0a, // n0x0226 c0x0000 (---------------)  + I healthcare
	0x00208404, // n0x0227 c0x0000 (---------------)  + I help
	0x00209748, // n0x0228 c0x0000 (---------------)  + I helsinki
	0x0024d144, // n0x0229 c0x0000 (---------------)  + I here
	0x00221146, // n0x022a c0x0000 (---------------)  + I hermes
	0x0028c404, // n0x022b c0x0000 (---------------)  + I hgtv
	0x0033b986, // n0x022c c0x0000 (---------------)  + I hiphop
	0x00326309, // n0x022d c0x0000 (---------------)  + I hisamitsu
	0x0029c147, // n0x022e c0x0000 (---------------)  + I hitachi
	0x002753c3, // n0x022f c0x0000 (---------------)  + I hiv
	0x19a0f882, // n0x0230 c0x0066 (n0x09a7-n0x09bf)  + I hk
	0x002659c3, // n0x0231 c0x0000 (---------------)  + I hkt
	0x0020b742, // n0x0232 c0x0000 (---------------)  + I hm
	0x19e168c2, // n0x0233 c0x0067 (n0x09bf-n0x09c5)  + I hn
	0x002d8486, // n0x0234 c0x0000 (---------------)  + I hockey
	0x00358948, // n0x0235 c0x0000 (---------------)  + I holdings
	0x0029e847, // n0x0236 c0x0000 (---------------)  + I holiday
	0x0026cd89, // n0x0237 c0x0000 (---------------)  + I homedepot
	0x00291e09, // n0x0238 c0x0000 (---------------)  + I homegoods
	0x0029fe45, // n0x0239 c0x0000 (---------------)  + I homes
	0x0029fe49, // n0x023a c0x0000 (---------------)  + I homesense
	0x002a1285, // n0x023b c0x0000 (---------------)  + I honda
	0x002a19c9, // n0x023c c0x0000 (---------------)  + I honeywell
	0x002a2785, // n0x023d c0x0000 (---------------)  + I horse
	0x002902c4, // n0x023e c0x0000 (---------------)  + I host
	0x002902c7, // n0x023f c0x0000 (---------------)  + I hosting
	0x0022de03, // n0x0240 c0x0000 (---------------)  + I hot
	0x002a3247, // n0x0241 c0x0000 (---------------)  + I hoteles
	0x002a3987, // n0x0242 c0x0000 (---------------)  + I hotmail
	0x0029bd45, // n0x0243 c0x0000 (---------------)  + I house
	0x0029b0c3, // n0x0244 c0x0000 (---------------)  + I how
	0x1a231342, // n0x0245 c0x0068 (n0x09c5-n0x09ca)  + I hr
	0x003817c4, // n0x0246 c0x0000 (---------------)  + I hsbc
	0x1a64a202, // n0x0247 c0x0069 (n0x09ca-n0x09db)  + I ht
	0x00256103, // n0x0248 c0x0000 (---------------)  + I htc
	0x1aa22f82, // n0x0249 c0x006a (n0x09db-n0x09fb)  + I hu
	0x002eed06, // n0x024a c0x0000 (---------------)  + I hughes
	0x002c1845, // n0x024b c0x0000 (---------------)  + I hyatt
	0x002a6987, // n0x024c c0x0000 (---------------)  + I hyundai
	0x002d4383, // n0x024d c0x0000 (---------------)  + I ibm
	0x0039b644, // n0x024e c0x0000 (---------------)  + I icbc
	0x00201343, // n0x024f c0x0000 (---------------)  + I ice
	0x0032fe43, // n0x0250 c0x0000 (---------------)  + I icu
	0x1ae03782, // n0x0251 c0x006b (n0x09fb-n0x0a06)  + I id
	0x1b600042, // n0x0252 c0x006d (n0x0a07-n0x0a09)  + I ie
	0x00361484, // n0x0253 c0x0000 (---------------)  + I ieee
	0x0022c103, // n0x0254 c0x0000 (---------------)  + I ifm
	0x00318105, // n0x0255 c0x0000 (---------------)  + I iinet
	0x00238885, // n0x0256 c0x0000 (---------------)  + I ikano
	0x1ba01b02, // n0x0257 c0x006e (n0x0a09-n0x0a11)  + I il
	0x1c207c02, // n0x0258 c0x0070 (n0x0a12-n0x0a19)  + I im
	0x00248946, // n0x0259 c0x0000 (---------------)  + I imamat
	0x00302744, // n0x025a c0x0000 (---------------)  + I imdb
	0x00207c04, // n0x025b c0x0000 (---------------)  + I immo
	0x00207c0a, // n0x025c c0x0000 (---------------)  + I immobilien
	0x1ca02082, // n0x025d c0x0072 (n0x0a1b-n0x0a28)  + I in
	0x0036280a, // n0x025e c0x0000 (---------------)  + I industries
	0x003a4dc8, // n0x025f c0x0000 (---------------)  + I infiniti
	0x1cfa4f84, // n0x0260 c0x0073 (n0x0a28-n0x0a32)  + I info
	0x0020ab83, // n0x0261 c0x0000 (---------------)  + I ing
	0x00209843, // n0x0262 c0x0000 (---------------)  + I ink
	0x00307dc9, // n0x0263 c0x0000 (---------------)  + I institute
	0x00236a09, // n0x0264 c0x0000 (---------------)  + I insurance
	0x0032f786, // n0x0265 c0x0000 (---------------)  + I insure
	0x1d267a43, // n0x0266 c0x0074 (n0x0a32-n0x0a33)  + I int
	0x002f6345, // n0x0267 c0x0000 (---------------)  + I intel
	0x002f810d, // n0x0268 c0x0000 (---------------)  + I international
	0x002eea06, // n0x0269 c0x0000 (---------------)  + I intuit
	0x0020938b, // n0x026a c0x0000 (---------------)  + I investments
	0x1d600542, // n0x026b c0x0075 (n0x0a33-n0x0a39)  + I io
	0x002637c8, // n0x026c c0x0000 (---------------)  + I ipiranga
	0x1da00a02, // n0x026d c0x0076 (n0x0a39-n0x0a3f)  + I iq
	0x1de04fc2, // n0x026e c0x0077 (n0x0a3f-n0x0a48)  + I ir
	0x0028ba85, // n0x026f c0x0000 (---------------)  + I irish
	0x1e2011c2, // n0x0270 c0x0078 (n0x0a48-n0x0a50)  + I is
	0x00254687, // n0x0271 c0x0000 (---------------)  + I iselect
	0x00277447, // n0x0272 c0x0000 (---------------)  + I ismaili
	0x0020cfc3, // n0x0273 c0x0000 (---------------)  + I ist
	0x0020cfc8, // n0x0274 c0x0000 (---------------)  + I istanbul
	0x1e602742, // n0x0275 c0x0079 (n0x0a50-n0x0bc1)  + I it
	0x0026db04, // n0x0276 c0x0000 (---------------)  + I itau
	0x0020da03, // n0x0277 c0x0000 (---------------)  + I itv
	0x0031ea45, // n0x0278 c0x0000 (---------------)  + I iveco
	0x00366703, // n0x0279 c0x0000 (---------------)  + I iwc
	0x002c1306, // n0x027a c0x0000 (---------------)  + I jaguar
	0x0031b0c4, // n0x027b c0x0000 (---------------)  + I java
	0x00234dc3, // n0x027c c0x0000 (---------------)  + I jcb
	0x00266103, // n0x027d c0x0000 (---------------)  + I jcp
	0x1ea07a82, // n0x027e c0x007a (n0x0bc1-n0x0bc4)  + I je
	0x0031ff44, // n0x027f c0x0000 (---------------)  + I jeep
	0x0034b405, // n0x0280 c0x0000 (---------------)  + I jetzt
	0x0035ca47, // n0x0281 c0x0000 (---------------)  + I jewelry
	0x00271d03, // n0x0282 c0x0000 (---------------)  + I jio
	0x002a6e03, // n0x0283 c0x0000 (---------------)  + I jlc
	0x002a7603, // n0x0284 c0x0000 (---------------)  + I jll
	0x016a76c2, // n0x0285 c0x0005 (---------------)* o I jm
	0x002a76c3, // n0x0286 c0x0000 (---------------)  + I jmp
	0x002a7883, // n0x0287 c0x0000 (---------------)  + I jnj
	0x1ee014c2, // n0x0288 c0x007b (n0x0bc4-n0x0bcc)  + I jo
	0x002bc1c4, // n0x0289 c0x0000 (---------------)  + I jobs
	0x00274b06, // n0x028a c0x0000 (---------------)  + I joburg
	0x002014c3, // n0x028b c0x0000 (---------------)  + I jot
	0x002a7c03, // n0x028c c0x0000 (---------------)  + I joy
	0x1f2a8442, // n0x028d c0x007c (n0x0bcc-n0x0c3b)  + I jp
	0x002a8448, // n0x028e c0x0000 (---------------)  + I jpmorgan
	0x002a8e84, // n0x028f c0x0000 (---------------)  + I jprs
	0x00246fc6, // n0x0290 c0x0000 (---------------)  + I juegos
	0x002a9347, // n0x0291 c0x0000 (---------------)  + I juniper
	0x00216c06, // n0x0292 c0x0000 (---------------)  + I kaufen
	0x00399cc4, // n0x0293 c0x0000 (---------------)  + I kddi
	0x2ce017c2, // n0x0294 c0x00b3 (n0x12cf-n0x12d0)* o I ke
	0x0022dccb, // n0x0295 c0x0000 (---------------)  + I kerryhotels
	0x002db70e, // n0x0296 c0x0000 (---------------)  + I kerrylogistics
	0x0022030f, // n0x0297 c0x0000 (---------------)  + I kerryproperties
	0x0022b1c3, // n0x0298 c0x0000 (---------------)  + I kfh
	0x2d6b1542, // n0x0299 c0x00b5 (n0x12d1-n0x12d7)  + I kg
	0x01616a42, // n0x029a c0x0005 (---------------)* o I kh
	0x2da01cc2, // n0x029b c0x00b6 (n0x12d7-n0x12de)  + I ki
	0x002651c3, // n0x029c c0x0000 (---------------)  + I kia
	0x00233cc3, // n0x029d c0x0000 (---------------)  + I kim
	0x00376346, // n0x029e c0x0000 (---------------)  + I kinder
	0x0032c446, // n0x029f c0x0000 (---------------)  + I kindle
	0x00344787, // n0x02a0 c0x0000 (---------------)  + I kitchen
	0x002e2b84, // n0x02a1 c0x0000 (---------------)  + I kiwi
	0x2de37642, // n0x02a2 c0x00b7 (n0x12de-n0x12ef)  + I km
	0x2e24e8c2, // n0x02a3 c0x00b8 (n0x12ef-n0x12f3)  + I kn
	0x00224885, // n0x02a4 c0x0000 (---------------)  + I koeln
	0x002e1e07, // n0x02a5 c0x0000 (---------------)  + I komatsu
	0x002e3d86, // n0x02a6 c0x0000 (---------------)  + I kosher
	0x2e60e982, // n0x02a7 c0x00b9 (n0x12f3-n0x12f9)  + I kp
	0x0020e984, // n0x02a8 c0x0000 (---------------)  + I kpmg
	0x00365f43, // n0x02a9 c0x0000 (---------------)  + I kpn
	0x2ea07b42, // n0x02aa c0x00ba (n0x12f9-n0x1317)  + I kr
	0x0034a883, // n0x02ab c0x0000 (---------------)  + I krd
	0x0039e604, // n0x02ac c0x0000 (---------------)  + I kred
	0x002b1489, // n0x02ad c0x0000 (---------------)  + I kuokgroup
	0x016b8302, // n0x02ae c0x0005 (---------------)* o I kw
	0x2ee306c2, // n0x02af c0x00bb (n0x1317-n0x131c)  + I ky
	0x00261786, // n0x02b0 c0x0000 (---------------)  + I kyknet
	0x002b9245, // n0x02b1 c0x0000 (---------------)  + I kyoto
	0x2f319c82, // n0x02b2 c0x00bc (n0x131c-n0x1322)  + I kz
	0x2f603102, // n0x02b3 c0x00bd (n0x1322-n0x132b)  + I la
	0x00330e47, // n0x02b4 c0x0000 (---------------)  + I lacaixa
	0x00289909, // n0x02b5 c0x0000 (---------------)  + I ladbrokes
	0x0034f28b, // n0x02b6 c0x0000 (---------------)  + I lamborghini
	0x00241405, // n0x02b7 c0x0000 (---------------)  + I lamer
	0x00368509, // n0x02b8 c0x0000 (---------------)  + I lancaster
	0x002bab46, // n0x02b9 c0x0000 (---------------)  + I lancia
	0x00252647, // n0x02ba c0x0000 (---------------)  + I lancome
	0x00205d84, // n0x02bb c0x0000 (---------------)  + I land
	0x002fecc9, // n0x02bc c0x0000 (---------------)  + I landrover
	0x00353947, // n0x02bd c0x0000 (---------------)  + I lanxess
	0x0027e807, // n0x02be c0x0000 (---------------)  + I lasalle
	0x00222643, // n0x02bf c0x0000 (---------------)  + I lat
	0x00225e86, // n0x02c0 c0x0000 (---------------)  + I latino
	0x002caf47, // n0x02c1 c0x0000 (---------------)  + I latrobe
	0x00266983, // n0x02c2 c0x0000 (---------------)  + I law
	0x00266986, // n0x02c3 c0x0000 (---------------)  + I lawyer
	0x2fa01b42, // n0x02c4 c0x00be (n0x132b-n0x1330)  + I lb
	0x2fe32842, // n0x02c5 c0x00bf (n0x1330-n0x1336)  + I lc
	0x00264a83, // n0x02c6 c0x0000 (---------------)  + I lds
	0x0027e945, // n0x02c7 c0x0000 (---------------)  + I lease
	0x002ae107, // n0x02c8 c0x0000 (---------------)  + I leclerc
	0x00373806, // n0x02c9 c0x0000 (---------------)  + I lefrak
	0x0032ab05, // n0x02ca c0x0000 (---------------)  + I legal
	0x00246d44, // n0x02cb c0x0000 (---------------)  + I lego
	0x002d7985, // n0x02cc c0x0000 (---------------)  + I lexus
	0x002df484, // n0x02cd c0x0000 (---------------)  + I lgbt
	0x30207d82, // n0x02ce c0x00c0 (n0x1336-n0x1337)  + I li
	0x00314847, // n0x02cf c0x0000 (---------------)  + I liaison
	0x002b6a84, // n0x02d0 c0x0000 (---------------)  + I lidl
	0x00236904, // n0x02d1 c0x0000 (---------------)  + I life
	0x0023690d, // n0x02d2 c0x0000 (---------------)  + I lifeinsurance
	0x00244f49, // n0x02d3 c0x0000 (---------------)  + I lifestyle
	0x002fa088, // n0x02d4 c0x0000 (---------------)  + I lighting
	0x00252284, // n0x02d5 c0x0000 (---------------)  + I like
	0x00342dc5, // n0x02d6 c0x0000 (---------------)  + I lilly
	0x002d4887, // n0x02d7 c0x0000 (---------------)  + I limited
	0x002d4c84, // n0x02d8 c0x0000 (---------------)  + I limo
	0x0030b887, // n0x02d9 c0x0000 (---------------)  + I lincoln
	0x00387305, // n0x02da c0x0000 (---------------)  + I linde
	0x003927c4, // n0x02db c0x0000 (---------------)  + I link
	0x002cdec5, // n0x02dc c0x0000 (---------------)  + I lipsy
	0x002594c4, // n0x02dd c0x0000 (---------------)  + I live
	0x002d7ac6, // n0x02de c0x0000 (---------------)  + I living
	0x002d4b85, // n0x02df c0x0000 (---------------)  + I lixil
	0x3060e942, // n0x02e0 c0x00c1 (n0x1337-n0x1346)  + I lk
	0x0020ed44, // n0x02e1 c0x0000 (---------------)  + I loan
	0x0020ed45, // n0x02e2 c0x0000 (---------------)  + I loans
	0x00370b46, // n0x02e3 c0x0000 (---------------)  + I locker
	0x0032ac45, // n0x02e4 c0x0000 (---------------)  + I locus
	0x002cc9c4, // n0x02e5 c0x0000 (---------------)  + I loft
	0x002bd303, // n0x02e6 c0x0000 (---------------)  + I lol
	0x00313c86, // n0x02e7 c0x0000 (---------------)  + I london
	0x00220f05, // n0x02e8 c0x0000 (---------------)  + I lotte
	0x00221885, // n0x02e9 c0x0000 (---------------)  + I lotto
	0x0034e204, // n0x02ea c0x0000 (---------------)  + I love
	0x00208483, // n0x02eb c0x0000 (---------------)  + I lpl
	0x0020848c, // n0x02ec c0x0000 (---------------)  + I lplfinancial
	0x30a82b42, // n0x02ed c0x00c2 (n0x1346-n0x134b)  + I lr
	0x30e04a42, // n0x02ee c0x00c3 (n0x134b-n0x134d)  + I ls
	0x31200d82, // n0x02ef c0x00c4 (n0x134d-n0x134f)  + I lt
	0x00314403, // n0x02f0 c0x0000 (---------------)  + I ltd
	0x00314404, // n0x02f1 c0x0000 (---------------)  + I ltda
	0x31602ac2, // n0x02f2 c0x00c5 (n0x134f-n0x1350)  + I lu
	0x002dbac8, // n0x02f3 c0x0000 (---------------)  + I lundbeck
	0x002dc0c5, // n0x02f4 c0x0000 (---------------)  + I lupin
	0x0022c504, // n0x02f5 c0x0000 (---------------)  + I luxe
	0x00231bc6, // n0x02f6 c0x0000 (---------------)  + I luxury
	0x31a0dd82, // n0x02f7 c0x00c6 (n0x1350-n0x1359)  + I lv
	0x31e3bb82, // n0x02f8 c0x00c7 (n0x1359-n0x1362)  + I ly
	0x32200182, // n0x02f9 c0x00c8 (n0x1362-n0x1368)  + I ma
	0x00349785, // n0x02fa c0x0000 (---------------)  + I macys
	0x00310646, // n0x02fb c0x0000 (---------------)  + I madrid
	0x002fe204, // n0x02fc c0x0000 (---------------)  + I maif
	0x00205b06, // n0x02fd c0x0000 (---------------)  + I maison
	0x0024de86, // n0x02fe c0x0000 (---------------)  + I makeup
	0x002021c3, // n0x02ff c0x0000 (---------------)  + I man
	0x0036330a, // n0x0300 c0x0000 (---------------)  + I management
	0x00234805, // n0x0301 c0x0000 (---------------)  + I mango
	0x0024f0c6, // n0x0302 c0x0000 (---------------)  + I market
	0x002e5489, // n0x0303 c0x0000 (---------------)  + I marketing
	0x0024f0c7, // n0x0304 c0x0000 (---------------)  + I markets
	0x0023b588, // n0x0305 c0x0000 (---------------)  + I marriott
	0x00209b89, // n0x0306 c0x0000 (---------------)  + I marshalls
	0x002b5dc8, // n0x0307 c0x0000 (---------------)  + I maserati
	0x002af106, // n0x0308 c0x0000 (---------------)  + I mattel
	0x002349c3, // n0x0309 c0x0000 (---------------)  + I mba
	0x32618742, // n0x030a c0x00c9 (n0x1368-n0x136a)  + I mc
	0x003756c3, // n0x030b c0x0000 (---------------)  + I mcd
	0x003756c9, // n0x030c c0x0000 (---------------)  + I mcdonalds
	0x00319208, // n0x030d c0x0000 (---------------)  + I mckinsey
	0x32a46c82, // n0x030e c0x00ca (n0x136a-n0x136b)  + I md
	0x32e09502, // n0x030f c0x00cb (n0x136b-n0x1378)  + I me
	0x00220d43, // n0x0310 c0x0000 (---------------)  + I med
	0x003a15c5, // n0x0311 c0x0000 (---------------)  + I media
	0x002629c4, // n0x0312 c0x0000 (---------------)  + I meet
	0x002da389, // n0x0313 c0x0000 (---------------)  + I melbourne
	0x002ac644, // n0x0314 c0x0000 (---------------)  + I meme
	0x00399a08, // n0x0315 c0x0000 (---------------)  + I memorial
	0x00209503, // n0x0316 c0x0000 (---------------)  + I men
	0x0033a2c4, // n0x0317 c0x0000 (---------------)  + I menu
	0x00218903, // n0x0318 c0x0000 (---------------)  + I meo
	0x00236847, // n0x0319 c0x0000 (---------------)  + I metlife
	0x3320ea02, // n0x031a c0x00cc (n0x1378-n0x1381)  + I mg
	0x00253dc2, // n0x031b c0x0000 (---------------)  + I mh
	0x0022ac45, // n0x031c c0x0000 (---------------)  + I miami
	0x00262d89, // n0x031d c0x0000 (---------------)  + I microsoft
	0x00214d03, // n0x031e c0x0000 (---------------)  + I mil
	0x00275144, // n0x031f c0x0000 (---------------)  + I mini
	0x002f80c4, // n0x0320 c0x0000 (---------------)  + I mint
	0x00239243, // n0x0321 c0x0000 (---------------)  + I mit
	0x00276cca, // n0x0322 c0x0000 (---------------)  + I mitsubishi
	0x337626c2, // n0x0323 c0x00cd (n0x1381-n0x1389)  + I mk
	0x33a0ed02, // n0x0324 c0x00ce (n0x1389-n0x1390)  + I ml
	0x002bbd83, // n0x0325 c0x0000 (---------------)  + I mlb
	0x00365083, // n0x0326 c0x0000 (---------------)  + I mls
	0x01607c42, // n0x0327 c0x0005 (---------------)* o I mm
	0x00369a83, // n0x0328 c0x0000 (---------------)  + I mma
	0x33e1e242, // n0x0329 c0x00cf (n0x1390-n0x1394)  + I mn
	0x0021e244, // n0x032a c0x0000 (---------------)  + I mnet
	0x34207c82, // n0x032b c0x00d0 (n0x1394-n0x1399)  + I mo
	0x34607c84, // n0x032c c0x00d1 (n0x1399-n0x139a)  + I mobi
	0x002d09c6, // n0x032d c0x0000 (---------------)  + I mobily
	0x00263cc4, // n0x032e c0x0000 (---------------)  + I moda
	0x002473c3, // n0x032f c0x0000 (---------------)  + I moe
	0x0027a6c3, // n0x0330 c0x0000 (---------------)  + I moi
	0x0022a283, // n0x0331 c0x0000 (---------------)  + I mom
	0x0023e086, // n0x0332 c0x0000 (---------------)  + I monash
	0x002c2f45, // n0x0333 c0x0000 (---------------)  + I money
	0x002bcf47, // n0x0334 c0x0000 (---------------)  + I monster
	0x00252509, // n0x0335 c0x0000 (---------------)  + I montblanc
	0x002c0245, // n0x0336 c0x0000 (---------------)  + I mopar
	0x002c2e86, // n0x0337 c0x0000 (---------------)  + I mormon
	0x002c3488, // n0x0338 c0x0000 (---------------)  + I mortgage
	0x002c3686, // n0x0339 c0x0000 (---------------)  + I moscow
	0x00271604, // n0x033a c0x0000 (---------------)  + I moto
	0x0029348b, // n0x033b c0x0000 (---------------)  + I motorcycles
	0x002c4d83, // n0x033c c0x0000 (---------------)  + I mov
	0x002c4d85, // n0x033d c0x0000 (---------------)  + I movie
	0x002c4ec8, // n0x033e c0x0000 (---------------)  + I movistar
	0x00226cc2, // n0x033f c0x0000 (---------------)  + I mp
	0x00331142, // n0x0340 c0x0000 (---------------)  + I mq
	0x34a436c2, // n0x0341 c0x00d2 (n0x139a-n0x139c)  + I mr
	0x34e0bbc2, // n0x0342 c0x00d3 (n0x139c-n0x13a1)  + I ms
	0x0026a3c3, // n0x0343 c0x0000 (---------------)  + I msd
	0x352643c2, // n0x0344 c0x00d4 (n0x13a1-n0x13a5)  + I mt
	0x002643c3, // n0x0345 c0x0000 (---------------)  + I mtn
	0x002c51c4, // n0x0346 c0x0000 (---------------)  + I mtpc
	0x002c5703, // n0x0347 c0x0000 (---------------)  + I mtr
	0x35a078c2, // n0x0348 c0x00d6 (n0x13a6-n0x13ad)  + I mu
	0x002c730b, // n0x0349 c0x0000 (---------------)  + I multichoice
	0x35eca1c6, // n0x034a c0x00d7 (n0x13ad-n0x15d1)  + I museum
	0x00235506, // n0x034b c0x0000 (---------------)  + I mutual
	0x002ca808, // n0x034c c0x0000 (---------------)  + I mutuelle
	0x3625cc82, // n0x034d c0x00d8 (n0x15d1-n0x15df)  + I mv
	0x3660bf42, // n0x034e c0x00d9 (n0x15df-n0x15ea)  + I mw
	0x36a16582, // n0x034f c0x00da (n0x15ea-n0x15f0)  + I mx
	0x36e65142, // n0x0350 c0x00db (n0x15f0-n0x15f8)  + I my
	0x37212b42, // n0x0351 c0x00dc (n0x15f8-n0x15f9)* o I mz
	0x00212b4b, // n0x0352 c0x0000 (---------------)  + I mzansimagic
	0x37601f42, // n0x0353 c0x00dd (n0x15f9-n0x160a)  + I na
	0x00218fc3, // n0x0354 c0x0000 (---------------)  + I nab
	0x0039af45, // n0x0355 c0x0000 (---------------)  + I nadex
	0x00304146, // n0x0356 c0x0000 (---------------)  + I nagoya
	0x37a0ff84, // n0x0357 c0x00de (n0x160a-n0x160c)  + I name
	0x003a2dc7, // n0x0358 c0x0000 (---------------)  + I naspers
	0x0039a9ca, // n0x0359 c0x0000 (---------------)  + I nationwide
	0x002d5746, // n0x035a c0x0000 (---------------)  + I natura
	0x0037bd04, // n0x035b c0x0000 (---------------)  + I navy
	0x00256283, // n0x035c c0x0000 (---------------)  + I nba
	0x38608642, // n0x035d c0x00e1 (n0x160e-n0x160f)  + I nc
	0x00201e02, // n0x035e c0x0000 (---------------)  + I ne
	0x00239903, // n0x035f c0x0000 (---------------)  + I nec
	0x38a1e283, // n0x0360 c0x00e2 (n0x160f-n0x1643)  + I net
	0x00319b07, // n0x0361 c0x0000 (---------------)  + I netbank
	0x002d4a87, // n0x0362 c0x0000 (---------------)  + I netflix
	0x0024fa07, // n0x0363 c0x0000 (---------------)  + I network
	0x00225bc7, // n0x0364 c0x0000 (---------------)  + I neustar
	0x00226b83, // n0x0365 c0x0000 (---------------)  + I new
	0x002cedca, // n0x0366 c0x0000 (---------------)  + I newholland
	0x00229684, // n0x0367 c0x0000 (---------------)  + I news
	0x00246884, // n0x0368 c0x0000 (---------------)  + I next
	0x0024688a, // n0x0369 c0x0000 (---------------)  + I nextdirect
	0x00265585, // n0x036a c0x0000 (---------------)  + I nexus
	0x39e30b02, // n0x036b c0x00e7 (n0x164b-n0x1655)  + I nf
	0x0024a0c3, // n0x036c c0x0000 (---------------)  + I nfl
	0x3a2006c2, // n0x036d c0x00e8 (n0x1655-n0x165e)  + I ng
	0x002006c3, // n0x036e c0x0000 (---------------)  + I ngo
	0x00265983, // n0x036f c0x0000 (---------------)  + I nhk
	0x3aa01fc2, // n0x0370 c0x00ea (n0x165f-n0x166d)  o I ni
	0x00283144, // n0x0371 c0x0000 (---------------)  + I nico
	0x0021cb04, // n0x0372 c0x0000 (---------------)  + I nike
	0x00207e45, // n0x0373 c0x0000 (---------------)  + I nikon
	0x002c5485, // n0x0374 c0x0000 (---------------)  + I ninja
	0x00229ac6, // n0x0375 c0x0000 (---------------)  + I nissan
	0x002ae686, // n0x0376 c0x0000 (---------------)  + I nissay
	0x3ae03842, // n0x0377 c0x00eb (n0x166d-n0x1670)  + I nl
	0x3b200842, // n0x0378 c0x00ec (n0x1670-n0x1946)  + I no
	0x00311c85, // n0x0379 c0x0000 (---------------)  + I nokia
	0x00235212, // n0x037a c0x0000 (---------------)  + I northwesternmutual
	0x00359c46, // n0x037b c0x0000 (---------------)  + I norton
	0x0021fc03, // n0x037c c0x0000 (---------------)  + I now
	0x00296286, // n0x037d c0x0000 (---------------)  + I nowruz
	0x0021fc05, // n0x037e c0x0000 (---------------)  + I nowtv
	0x0160d402, // n0x037f c0x0005 (---------------)* o I np
	0x436a0842, // n0x0380 c0x010d (n0x196e-n0x1975)  + I nr
	0x002cfc03, // n0x0381 c0x0000 (---------------)  + I nra
	0x00351e43, // n0x0382 c0x0000 (---------------)  + I nrw
	0x0036e003, // n0x0383 c0x0000 (---------------)  + I ntt
	0x43a020c2, // n0x0384 c0x010e (n0x1975-n0x1978)  + I nu
	0x0036aa83, // n0x0385 c0x0000 (---------------)  + I nyc
	0x43e10a42, // n0x0386 c0x010f (n0x1978-n0x1988)  + I nz
	0x00207cc3, // n0x0387 c0x0000 (---------------)  + I obi
	0x002bc208, // n0x0388 c0x0000 (---------------)  + I observer
	0x00203e03, // n0x0389 c0x0000 (---------------)  + I off
	0x00228f46, // n0x038a c0x0000 (---------------)  + I office
	0x0038fc07, // n0x038b c0x0000 (---------------)  + I okinawa
	0x0020f9c6, // n0x038c c0x0000 (---------------)  + I olayan
	0x0020f9cb, // n0x038d c0x0000 (---------------)  + I olayangroup
	0x0037bc47, // n0x038e c0x0000 (---------------)  + I oldnavy
	0x003815c4, // n0x038f c0x0000 (---------------)  + I ollo
	0x44604b02, // n0x0390 c0x0111 (n0x1989-n0x1992)  + I om
	0x002dbf45, // n0x0391 c0x0000 (---------------)  + I omega
	0x0020c803, // n0x0392 c0x0000 (---------------)  + I one
	0x0024e643, // n0x0393 c0x0000 (---------------)  + I ong
	0x00310ac3, // n0x0394 c0x0000 (---------------)  + I onl
	0x00310ac6, // n0x0395 c0x0000 (---------------)  + I online
	0x0037c20a, // n0x0396 c0x0000 (---------------)  + I onyourside
	0x00286f83, // n0x0397 c0x0000 (---------------)  + I ooo
	0x00236084, // n0x0398 c0x0000 (---------------)  + I open
	0x0033c306, // n0x0399 c0x0000 (---------------)  + I oracle
	0x00390346, // n0x039a c0x0000 (---------------)  + I orange
	0x44a23a43, // n0x039b c0x0112 (n0x1992-n0x19cf)  + I org
	0x002a8507, // n0x039c c0x0000 (---------------)  + I organic
	0x002b07cd, // n0x039d c0x0000 (---------------)  + I orientexpress
	0x0036fc07, // n0x039e c0x0000 (---------------)  + I origins
	0x002931c5, // n0x039f c0x0000 (---------------)  + I osaka
	0x00261986, // n0x03a0 c0x0000 (---------------)  + I otsuka
	0x00220f43, // n0x03a1 c0x0000 (---------------)  + I ott
	0x0020ae43, // n0x03a2 c0x0000 (---------------)  + I ovh
	0x46203942, // n0x03a3 c0x0118 (n0x1a0c-n0x1a17)  + I pa
	0x00337604, // n0x03a4 c0x0000 (---------------)  + I page
	0x0023b7cc, // n0x03a5 c0x0000 (---------------)  + I pamperedchef
	0x00245749, // n0x03a6 c0x0000 (---------------)  + I panasonic
	0x0032b887, // n0x03a7 c0x0000 (---------------)  + I panerai
	0x00266185, // n0x03a8 c0x0000 (---------------)  + I paris
	0x0037af44, // n0x03a9 c0x0000 (---------------)  + I pars
	0x0029d0c8, // n0x03aa c0x0000 (---------------)  + I partners
	0x0029eb45, // n0x03ab c0x0000 (---------------)  + I parts
	0x002a7745, // n0x03ac c0x0000 (---------------)  + I party
	0x002b1689, // n0x03ad c0x0000 (---------------)  + I passagens
	0x002b7243, // n0x03ae c0x0000 (---------------)  + I pay
	0x002b7244, // n0x03af c0x0000 (---------------)  + I payu
	0x002c5244, // n0x03b0 c0x0000 (---------------)  + I pccw
	0x466087c2, // n0x03b1 c0x0119 (n0x1a17-n0x1a1f)  + I pe
	0x002087c3, // n0x03b2 c0x0000 (---------------)  + I pet
	0x46ad3b02, // n0x03b3 c0x011a (n0x1a1f-n0x1a22)  + I pf
	0x002d3b06, // n0x03b4 c0x0000 (---------------)  + I pfizer
	0x0166b902, // n0x03b5 c0x0005 (---------------)* o I pg
	0x46e00982, // n0x03b6 c0x011b (n0x1a22-n0x1a2a)  + I ph
	0x00349688, // n0x03b7 c0x0000 (---------------)  + I pharmacy
	0x002cde07, // n0x03b8 c0x0000 (---------------)  + I philips
	0x00294dc5, // n0x03b9 c0x0000 (---------------)  + I photo
	0x002ce48b, // n0x03ba c0x0000 (---------------)  + I photography
	0x002cb606, // n0x03bb c0x0000 (---------------)  + I photos
	0x002ce686, // n0x03bc c0x0000 (---------------)  + I physio
	0x002ce806, // n0x03bd c0x0000 (---------------)  + I piaget
	0x00373c84, // n0x03be c0x0000 (---------------)  + I pics
	0x002cf046, // n0x03bf c0x0000 (---------------)  + I pictet
	0x002cf548, // n0x03c0 c0x0000 (---------------)  + I pictures
	0x0023bf83, // n0x03c1 c0x0000 (---------------)  + I pid
	0x00218303, // n0x03c2 c0x0000 (---------------)  + I pin
	0x00218304, // n0x03c3 c0x0000 (---------------)  + I ping
	0x002cfcc4, // n0x03c4 c0x0000 (---------------)  + I pink
	0x002d0247, // n0x03c5 c0x0000 (---------------)  + I pioneer
	0x002d0cc5, // n0x03c6 c0x0000 (---------------)  + I pizza
	0x472d0e02, // n0x03c7 c0x011c (n0x1a2a-n0x1a38)  + I pk
	0x47607502, // n0x03c8 c0x011d (n0x1a38-n0x1add)  + I pl
	0x00207505, // n0x03c9 c0x0000 (---------------)  + I place
	0x00295444, // n0x03ca c0x0000 (---------------)  + I play
	0x002d2b0b, // n0x03cb c0x0000 (---------------)  + I playstation
	0x002d3c88, // n0x03cc c0x0000 (---------------)  + I plumbing
	0x002d6544, // n0x03cd c0x0000 (---------------)  + I plus
	0x0020e9c2, // n0x03ce c0x0000 (---------------)  + I pm
	0x47e6b702, // n0x03cf c0x011f (n0x1b0c-n0x1b11)  + I pn
	0x002a8cc3, // n0x03d0 c0x0000 (---------------)  + I pnc
	0x002d6984, // n0x03d1 c0x0000 (---------------)  + I pohl
	0x002d6a85, // n0x03d2 c0x0000 (---------------)  + I poker
	0x002d6fc7, // n0x03d3 c0x0000 (---------------)  + I politie
	0x002d8c44, // n0x03d4 c0x0000 (---------------)  + I porn
	0x0035b5c4, // n0x03d5 c0x0000 (---------------)  + I post
	0x482052c2, // n0x03d6 c0x0120 (n0x1b11-n0x1b1e)  + I pr
	0x00352a49, // n0x03d7 c0x0000 (---------------)  + I pramerica
	0x002d9645, // n0x03d8 c0x0000 (---------------)  + I praxi
	0x002416c5, // n0x03d9 c0x0000 (---------------)  + I press
	0x002da2c5, // n0x03da c0x0000 (---------------)  + I prime
	0x48620443, // n0x03db c0x0121 (n0x1b1e-n0x1b25)  + I pro
	0x002dabc4, // n0x03dc c0x0000 (---------------)  + I prod
	0x002dabcb, // n0x03dd c0x0000 (---------------)  + I productions
	0x002db004, // n0x03de c0x0000 (---------------)  + I prof
	0x002db28b, // n0x03df c0x0000 (---------------)  + I progressive
	0x002dcd05, // n0x03e0 c0x0000 (---------------)  + I promo
	0x0022044a, // n0x03e1 c0x0000 (---------------)  + I properties
	0x002dd508, // n0x03e2 c0x0000 (---------------)  + I property
	0x002dd70a, // n0x03e3 c0x0000 (---------------)  + I protection
	0x002dd983, // n0x03e4 c0x0000 (---------------)  + I pru
	0x002dd98a, // n0x03e5 c0x0000 (---------------)  + I prudential
	0x48a23982, // n0x03e6 c0x0122 (n0x1b25-n0x1b2c)  + I ps
	0x48e6ae82, // n0x03e7 c0x0123 (n0x1b2c-n0x1b35)  + I pt
	0x00297d83, // n0x03e8 c0x0000 (---------------)  + I pub
	0x492de982, // n0x03e9 c0x0124 (n0x1b35-n0x1b3b)  + I pw
	0x002de983, // n0x03ea c0x0000 (---------------)  + I pwc
	0x49727902, // n0x03eb c0x0125 (n0x1b3b-n0x1b42)  + I py
	0x49b0da42, // n0x03ec c0x0126 (n0x1b42-n0x1b4b)  + I qa
	0x002df304, // n0x03ed c0x0000 (---------------)  + I qpon
	0x00219d86, // n0x03ee c0x0000 (---------------)  + I quebec
	0x00205845, // n0x03ef c0x0000 (---------------)  + I quest
	0x002df8c3, // n0x03f0 c0x0000 (---------------)  + I qvc
	0x003001c6, // n0x03f1 c0x0000 (---------------)  + I racing
	0x00223c84, // n0x03f2 c0x0000 (---------------)  + I raid
	0x49e04902, // n0x03f3 c0x0127 (n0x1b4b-n0x1b4f)  + I re
	0x002cd844, // n0x03f4 c0x0000 (---------------)  + I read
	0x002bd4ca, // n0x03f5 c0x0000 (---------------)  + I realestate
	0x0033cd47, // n0x03f6 c0x0000 (---------------)  + I realtor
	0x002c1686, // n0x03f7 c0x0000 (---------------)  + I realty
	0x00226e07, // n0x03f8 c0x0000 (---------------)  + I recipes
	0x0023b903, // n0x03f9 c0x0000 (---------------)  + I red
	0x0039e648, // n0x03fa c0x0000 (---------------)  + I redstone
	0x0032b2cb, // n0x03fb c0x0000 (---------------)  + I redumbrella
	0x0035aac5, // n0x03fc c0x0000 (---------------)  + I rehab
	0x002c8845, // n0x03fd c0x0000 (---------------)  + I reise
	0x002c8846, // n0x03fe c0x0000 (---------------)  + I reisen
	0x0032f884, // n0x03ff c0x0000 (---------------)  + I reit
	0x003195c8, // n0x0400 c0x0000 (---------------)  + I reliance
	0x00204903, // n0x0401 c0x0000 (---------------)  + I ren
	0x00204904, // n0x0402 c0x0000 (---------------)  + I rent
	0x00204907, // n0x0403 c0x0000 (---------------)  + I rentals
	0x002b1e46, // n0x0404 c0x0000 (---------------)  + I repair
	0x002f0e46, // n0x0405 c0x0000 (---------------)  + I report
	0x00297d0a, // n0x0406 c0x0000 (---------------)  + I republican
	0x00246744, // n0x0407 c0x0000 (---------------)  + I rest
	0x00361d0a, // n0x0408 c0x0000 (---------------)  + I restaurant
	0x003371c6, // n0x0409 c0x0000 (---------------)  + I review
	0x003371c7, // n0x040a c0x0000 (---------------)  + I reviews
	0x00251087, // n0x040b c0x0000 (---------------)  + I rexroth
	0x0026c744, // n0x040c c0x0000 (---------------)  + I rich
	0x0026c749, // n0x040d c0x0000 (---------------)  + I richardli
	0x0025c885, // n0x040e c0x0000 (---------------)  + I ricoh
	0x00341c4b, // n0x040f c0x0000 (---------------)  + I rightathome
	0x0024a3c3, // n0x0410 c0x0000 (---------------)  + I ril
	0x00209083, // n0x0411 c0x0000 (---------------)  + I rio
	0x0021e903, // n0x0412 c0x0000 (---------------)  + I rip
	0x4a200f82, // n0x0413 c0x0128 (n0x1b4f-n0x1b5b)  + I ro
	0x0027c286, // n0x0414 c0x0000 (---------------)  + I rocher
	0x0029ae45, // n0x0415 c0x0000 (---------------)  + I rocks
	0x002b2845, // n0x0416 c0x0000 (---------------)  + I rodeo
	0x00206d86, // n0x0417 c0x0000 (---------------)  + I rogers
	0x00357ec4, // n0x0418 c0x0000 (---------------)  + I room
	0x4a606e82, // n0x0419 c0x0129 (n0x1b5b-n0x1b62)  + I rs
	0x00206e84, // n0x041a c0x0000 (---------------)  + I rsvp
	0x4aa0efc2, // n0x041b c0x012a (n0x1b62-n0x1be5)  + I ru
	0x002312c4, // n0x041c c0x0000 (---------------)  + I ruhr
	0x00221b83, // n0x041d c0x0000 (---------------)  + I run
	0x4af1b942, // n0x041e c0x012b (n0x1be5-n0x1bee)  + I rw
	0x00335c83, // n0x041f c0x0000 (---------------)  + I rwe
	0x00366846, // n0x0420 c0x0000 (---------------)  + I ryukyu
	0x4b200642, // n0x0421 c0x012c (n0x1bee-n0x1bf6)  + I sa
	0x00305748, // n0x0422 c0x0000 (---------------)  + I saarland
	0x00397c84, // n0x0423 c0x0000 (---------------)  + I safe
	0x00397c86, // n0x0424 c0x0000 (---------------)  + I safety
	0x002d4206, // n0x0425 c0x0000 (---------------)  + I sakura
	0x00252bc4, // n0x0426 c0x0000 (---------------)  + I sale
	0x00313c05, // n0x0427 c0x0000 (---------------)  + I salon
	0x00387008, // n0x0428 c0x0000 (---------------)  + I samsclub
	0x00387507, // n0x0429 c0x0000 (---------------)  + I samsung
	0x0024b047, // n0x042a c0x0000 (---------------)  + I sandvik
	0x0024b04f, // n0x042b c0x0000 (---------------)  + I sandvikcoromant
	0x0028dd46, // n0x042c c0x0000 (---------------)  + I sanofi
	0x00214a03, // n0x042d c0x0000 (---------------)  + I sap
	0x00214a04, // n0x042e c0x0000 (---------------)  + I sapo
	0x00220e44, // n0x042f c0x0000 (---------------)  + I sarl
	0x00225503, // n0x0430 c0x0000 (---------------)  + I sas
	0x00221284, // n0x0431 c0x0000 (---------------)  + I save
	0x0036ae84, // n0x0432 c0x0000 (---------------)  + I saxo
	0x4b6239c2, // n0x0433 c0x012d (n0x1bf6-n0x1bfb)  + I sb
	0x00283ec3, // n0x0434 c0x0000 (---------------)  + I sbi
	0x0037f383, // n0x0435 c0x0000 (---------------)  + I sbs
	0x4ba13402, // n0x0436 c0x012e (n0x1bfb-n0x1c00)  + I sc
	0x002307c3, // n0x0437 c0x0000 (---------------)  + I sca
	0x0033a883, // n0x0438 c0x0000 (---------------)  + I scb
	0x0021340a, // n0x0439 c0x0000 (---------------)  + I schaeffler
	0x0034de07, // n0x043a c0x0000 (---------------)  + I schmidt
	0x00381c8c, // n0x043b c0x0000 (---------------)  + I scholarships
	0x00381f46, // n0x043c c0x0000 (---------------)  + I school
	0x0022af46, // n0x043d c0x0000 (---------------)  + I schule
	0x0022bd87, // n0x043e c0x0000 (---------------)  + I schwarz
	0x0022f207, // n0x043f c0x0000 (---------------)  + I science
	0x0023cf49, // n0x0440 c0x0000 (---------------)  + I scjohnson
	0x0021ad84, // n0x0441 c0x0000 (---------------)  + I scor
	0x00392404, // n0x0442 c0x0000 (---------------)  + I scot
	0x4be56cc2, // n0x0443 c0x012f (n0x1c00-n0x1c08)  + I sd
	0x4c201242, // n0x0444 c0x0130 (n0x1c08-n0x1c31)  + I se
	0x00310084, // n0x0445 c0x0000 (---------------)  + I seat
	0x00315ec6, // n0x0446 c0x0000 (---------------)  + I secure
	0x0022f688, // n0x0447 c0x0000 (---------------)  + I security
	0x0027ea04, // n0x0448 c0x0000 (---------------)  + I seek
	0x002546c6, // n0x0449 c0x0000 (---------------)  + I select
	0x002c6cc5, // n0x044a c0x0000 (---------------)  + I sener
	0x00201248, // n0x044b c0x0000 (---------------)  + I services
	0x00205383, // n0x044c c0x0000 (---------------)  + I ses
	0x00241e45, // n0x044d c0x0000 (---------------)  + I seven
	0x00244dc3, // n0x044e c0x0000 (---------------)  + I sew
	0x002417c3, // n0x044f c0x0000 (---------------)  + I sex
	0x002417c4, // n0x0450 c0x0000 (---------------)  + I sexy
	0x00248603, // n0x0451 c0x0000 (---------------)  + I sfr
	0x4c665682, // n0x0452 c0x0131 (n0x1c31-n0x1c38)  + I sg
	0x4ca02802, // n0x0453 c0x0132 (n0x1c38-n0x1c3f)  + I sh
	0x0024a289, // n0x0454 c0x0000 (---------------)  + I shangrila
	0x0024cb05, // n0x0455 c0x0000 (---------------)  + I sharp
	0x00250904, // n0x0456 c0x0000 (---------------)  + I shaw
	0x002518c5, // n0x0457 c0x0000 (---------------)  + I shell
	0x00211584, // n0x0458 c0x0000 (---------------)  + I shia
	0x002f2807, // n0x0459 c0x0000 (---------------)  + I shiksha
	0x0037f285, // n0x045a c0x0000 (---------------)  + I shoes
	0x002a9986, // n0x045b c0x0000 (---------------)  + I shouji
	0x002aadc4, // n0x045c c0x0000 (---------------)  + I show
	0x002ac4c8, // n0x045d c0x0000 (---------------)  + I showtime
	0x002b1887, // n0x045e c0x0000 (---------------)  + I shriram
	0x4ce09802, // n0x045f c0x0133 (n0x1c3f-n0x1c40)  + I si
	0x00352e04, // n0x0460 c0x0000 (---------------)  + I silk
	0x002ed044, // n0x0461 c0x0000 (---------------)  + I sina
	0x0027f207, // n0x0462 c0x0000 (---------------)  + I singles
	0x0023d984, // n0x0463 c0x0000 (---------------)  + I site
	0x00254a42, // n0x0464 c0x0000 (---------------)  + I sj
	0x4d208882, // n0x0465 c0x0134 (n0x1c40-n0x1c41)  + I sk
	0x00244243, // n0x0466 c0x0000 (---------------)  + I ski
	0x00376304, // n0x0467 c0x0000 (---------------)  + I skin
	0x00230683, // n0x0468 c0x0000 (---------------)  + I sky
	0x00230685, // n0x0469 c0x0000 (---------------)  + I skype
	0x4d61fa02, // n0x046a c0x0135 (n0x1c41-n0x1c46)  + I sl
	0x002c71c5, // n0x046b c0x0000 (---------------)  + I sling
	0x00214cc2, // n0x046c c0x0000 (---------------)  + I sm
	0x00363d05, // n0x046d c0x0000 (---------------)  + I smart
	0x00358b05, // n0x046e c0x0000 (---------------)  + I smile
	0x4da0ce82, // n0x046f c0x0136 (n0x1c46-n0x1c4e)  + I sn
	0x00215b84, // n0x0470 c0x0000 (---------------)  + I sncf
	0x4de05bc2, // n0x0471 c0x0137 (n0x1c4e-n0x1c51)  + I so
	0x002d5386, // n0x0472 c0x0000 (---------------)  + I soccer
	0x0029ef06, // n0x0473 c0x0000 (---------------)  + I social
	0x00262ec8, // n0x0474 c0x0000 (---------------)  + I softbank
	0x002b2e48, // n0x0475 c0x0000 (---------------)  + I software
	0x002eec84, // n0x0476 c0x0000 (---------------)  + I sohu
	0x002d9ac5, // n0x0477 c0x0000 (---------------)  + I solar
	0x002eee49, // n0x0478 c0x0000 (---------------)  + I solutions
	0x0024e604, // n0x0479 c0x0000 (---------------)  + I song
	0x0037c1c4, // n0x047a c0x0000 (---------------)  + I sony
	0x00239143, // n0x047b c0x0000 (---------------)  + I soy
	0x002046c5, // n0x047c c0x0000 (---------------)  + I space
	0x0036bfc7, // n0x047d c0x0000 (---------------)  + I spiegel
	0x00294504, // n0x047e c0x0000 (---------------)  + I spot
	0x0032734d, // n0x047f c0x0000 (---------------)  + I spreadbetting
	0x00329142, // n0x0480 c0x0000 (---------------)  + I sr
	0x00329143, // n0x0481 c0x0000 (---------------)  + I srl
	0x00331bc3, // n0x0482 c0x0000 (---------------)  + I srt
	0x4e201942, // n0x0483 c0x0138 (n0x1c51-n0x1c5d)  + I st
	0x00377dc5, // n0x0484 c0x0000 (---------------)  + I stada
	0x0022adc7, // n0x0485 c0x0000 (---------------)  + I staples
	0x00225c84, // n0x0486 c0x0000 (---------------)  + I star
	0x00225c87, // n0x0487 c0x0000 (---------------)  + I starhub
	0x00209d89, // n0x0488 c0x0000 (---------------)  + I statebank
	0x002bd609, // n0x0489 c0x0000 (---------------)  + I statefarm
	0x002e8287, // n0x048a c0x0000 (---------------)  + I statoil
	0x002708c3, // n0x048b c0x0000 (---------------)  + I stc
	0x002708c8, // n0x048c c0x0000 (---------------)  + I stcgroup
	0x00292389, // n0x048d c0x0000 (---------------)  + I stockholm
	0x00356447, // n0x048e c0x0000 (---------------)  + I storage
	0x003758c5, // n0x048f c0x0000 (---------------)  + I store
	0x002e0086, // n0x0490 c0x0000 (---------------)  + I studio
	0x002e0205, // n0x0491 c0x0000 (---------------)  + I study
	0x00245045, // n0x0492 c0x0000 (---------------)  + I style
	0x4e601142, // n0x0493 c0x0139 (n0x1c5d-n0x1c7d)  + I su
	0x0031a7c5, // n0x0494 c0x0000 (---------------)  + I sucks
	0x002b4a8a, // n0x0495 c0x0000 (---------------)  + I supersport
	0x002b9448, // n0x0496 c0x0000 (---------------)  + I supplies
	0x002a0a46, // n0x0497 c0x0000 (---------------)  + I supply
	0x002dcf47, // n0x0498 c0x0000 (---------------)  + I support
	0x002404c4, // n0x0499 c0x0000 (---------------)  + I surf
	0x00293ac7, // n0x049a c0x0000 (---------------)  + I surgery
	0x002e2d06, // n0x049b c0x0000 (---------------)  + I suzuki
	0x4ea06ec2, // n0x049c c0x013a (n0x1c7d-n0x1c82)  + I sv
	0x00370846, // n0x049d c0x0000 (---------------)  + I swatch
	0x002e56ca, // n0x049e c0x0000 (---------------)  + I swiftcover
	0x002e6085, // n0x049f c0x0000 (---------------)  + I swiss
	0x4eee6902, // n0x04a0 c0x013b (n0x1c82-n0x1c83)  + I sx
	0x4f27c482, // n0x04a1 c0x013c (n0x1c83-n0x1c89)  + I sy
	0x00320146, // n0x04a2 c0x0000 (---------------)  + I sydney
	0x002a5888, // n0x04a3 c0x0000 (---------------)  + I symantec
	0x0037aa07, // n0x04a4 c0x0000 (---------------)  + I systems
	0x4f604502, // n0x04a5 c0x013d (n0x1c89-n0x1c8c)  + I sz
	0x0020bcc3, // n0x04a6 c0x0000 (---------------)  + I tab
	0x003a1e46, // n0x04a7 c0x0000 (---------------)  + I taipei
	0x0021db84, // n0x04a8 c0x0000 (---------------)  + I talk
	0x0038fac6, // n0x04a9 c0x0000 (---------------)  + I taobao
	0x002399c6, // n0x04aa c0x0000 (---------------)  + I target
	0x00386dca, // n0x04ab c0x0000 (---------------)  + I tatamotors
	0x0039c145, // n0x04ac c0x0000 (---------------)  + I tatar
	0x0021edc6, // n0x04ad c0x0000 (---------------)  + I tattoo
	0x00222e83, // n0x04ae c0x0000 (---------------)  + I tax
	0x00222e84, // n0x04af c0x0000 (---------------)  + I taxi
	0x00205102, // n0x04b0 c0x0000 (---------------)  + I tc
	0x003026c3, // n0x04b1 c0x0000 (---------------)  + I tci
	0x4fa03d02, // n0x04b2 c0x013e (n0x1c8c-n0x1c8d)  + I td
	0x002c5383, // n0x04b3 c0x0000 (---------------)  + I tdk
	0x00362a84, // n0x04b4 c0x0000 (---------------)  + I team
	0x002a59c4, // n0x04b5 c0x0000 (---------------)  + I tech
	0x002a59ca, // n0x04b6 c0x0000 (---------------)  + I technology
	0x00227983, // n0x04b7 c0x0000 (---------------)  + I tel
	0x002807c8, // n0x04b8 c0x0000 (---------------)  + I telecity
	0x00307f8a, // n0x04b9 c0x0000 (---------------)  + I telefonica
	0x0023a987, // n0x04ba c0x0000 (---------------)  + I temasek
	0x002e9206, // n0x04bb c0x0000 (---------------)  + I tennis
	0x00322b84, // n0x04bc c0x0000 (---------------)  + I teva
	0x00288942, // n0x04bd c0x0000 (---------------)  + I tf
	0x002235c2, // n0x04be c0x0000 (---------------)  + I tg
	0x4fe07482, // n0x04bf c0x013f (n0x1c8d-n0x1c94)  + I th
	0x00243e43, // n0x04c0 c0x0000 (---------------)  + I thd
	0x00250e47, // n0x04c1 c0x0000 (---------------)  + I theater
	0x00300487, // n0x04c2 c0x0000 (---------------)  + I theatre
	0x0034ce8b, // n0x04c3 c0x0000 (---------------)  + I theguardian
	0x00349544, // n0x04c4 c0x0000 (---------------)  + I tiaa
	0x002eb247, // n0x04c5 c0x0000 (---------------)  + I tickets
	0x002d70c6, // n0x04c6 c0x0000 (---------------)  + I tienda
	0x00397a47, // n0x04c7 c0x0000 (---------------)  + I tiffany
	0x0034dd44, // n0x04c8 c0x0000 (---------------)  + I tips
	0x00333605, // n0x04c9 c0x0000 (---------------)  + I tires
	0x002b4f45, // n0x04ca c0x0000 (---------------)  + I tirol
	0x50231ec2, // n0x04cb c0x0140 (n0x1c94-n0x1ca3)  + I tj
	0x00363546, // n0x04cc c0x0000 (---------------)  + I tjmaxx
	0x00231ec3, // n0x04cd c0x0000 (---------------)  + I tjx
	0x00218842, // n0x04ce c0x0000 (---------------)  + I tk
	0x00237606, // n0x04cf c0x0000 (---------------)  + I tkmaxx
	0x50613e42, // n0x04d0 c0x0141 (n0x1ca3-n0x1ca4)  + I tl
	0x50a00142, // n0x04d1 c0x0142 (n0x1ca4-n0x1cac)  + I tm
	0x00200145, // n0x04d2 c0x0000 (---------------)  + I tmall
	0x50e2a482, // n0x04d3 c0x0143 (n0x1cac-n0x1cc0)  + I tn
	0x51203b82, // n0x04d4 c0x0144 (n0x1cc0-n0x1cc6)  + I to
	0x0032d645, // n0x04d5 c0x0000 (---------------)  + I today
	0x0033f685, // n0x04d6 c0x0000 (---------------)  + I tokyo
	0x0021ee85, // n0x04d7 c0x0000 (---------------)  + I tools
	0x00240f43, // n0x04d8 c0x0000 (---------------)  + I top
	0x00275cc5, // n0x04d9 c0x0000 (---------------)  + I toray
	0x002cb6c7, // n0x04da c0x0000 (---------------)  + I toshiba
	0x00255945, // n0x04db c0x0000 (---------------)  + I total
	0x002f3f85, // n0x04dc c0x0000 (---------------)  + I tours
	0x002afb44, // n0x04dd c0x0000 (---------------)  + I town
	0x0025d5c6, // n0x04de c0x0000 (---------------)  + I toyota
	0x00265a44, // n0x04df c0x0000 (---------------)  + I toys
	0x00212302, // n0x04e0 c0x0000 (---------------)  + I tp
	0x51602b82, // n0x04e1 c0x0145 (n0x1cc6-n0x1cdb)  + I tr
	0x0025e585, // n0x04e2 c0x0000 (---------------)  + I trade
	0x0029de47, // n0x04e3 c0x0000 (---------------)  + I trading
	0x002f97c8, // n0x04e4 c0x0000 (---------------)  + I training
	0x0029b806, // n0x04e5 c0x0000 (---------------)  + I travel
	0x0029b80d, // n0x04e6 c0x0000 (---------------)  + I travelchannel
	0x002a2dc9, // n0x04e7 c0x0000 (---------------)  + I travelers
	0x002a2dd2, // n0x04e8 c0x0000 (---------------)  + I travelersinsurance
	0x0031f7c5, // n0x04e9 c0x0000 (---------------)  + I trust
	0x0033f943, // n0x04ea c0x0000 (---------------)  + I trv
	0x5220b642, // n0x04eb c0x0148 (n0x1cdd-n0x1cee)  + I tt
	0x002ddf84, // n0x04ec c0x0000 (---------------)  + I tube
	0x002eea83, // n0x04ed c0x0000 (---------------)  + I tui
	0x002e6d85, // n0x04ee c0x0000 (---------------)  + I tunes
	0x002e7ac5, // n0x04ef c0x0000 (---------------)  + I tushu
	0x5260da42, // n0x04f0 c0x0149 (n0x1cee-n0x1cf2)  + I tv
	0x00360143, // n0x04f1 c0x0000 (---------------)  + I tvs
	0x52a42e02, // n0x04f2 c0x014a (n0x1cf2-n0x1d00)  + I tw
	0x52e1e302, // n0x04f3 c0x014b (n0x1d00-n0x1d0c)  + I tz
	0x53222fc2, // n0x04f4 c0x014c (n0x1d0c-n0x1d5b)  + I ua
	0x0032e5c5, // n0x04f5 c0x0000 (---------------)  + I ubank
	0x00395b43, // n0x04f6 c0x0000 (---------------)  + I ubs
	0x00239808, // n0x04f7 c0x0000 (---------------)  + I uconnect
	0x536025c2, // n0x04f8 c0x014d (n0x1d5b-n0x1d64)  + I ug
	0x53a00bc2, // n0x04f9 c0x014e (n0x1d64-n0x1d6f)  + I uk
	0x00283106, // n0x04fa c0x0000 (---------------)  + I unicom
	0x003179ca, // n0x04fb c0x0000 (---------------)  + I university
	0x0020c343, // n0x04fc c0x0000 (---------------)  + I uno
	0x00236f03, // n0x04fd c0x0000 (---------------)  + I uol
	0x002cad43, // n0x04fe c0x0000 (---------------)  + I ups
	0x54601102, // n0x04ff c0x0151 (n0x1d71-n0x1db0)  + I us
	0x62a02102, // n0x0500 c0x018a (n0x1e53-n0x1e59)  + I uy
	0x6320a142, // n0x0501 c0x018c (n0x1e5a-n0x1e5e)  + I uz
	0x002000c2, // n0x0502 c0x0000 (---------------)  + I va
	0x00370649, // n0x0503 c0x0000 (---------------)  + I vacations
	0x002b7744, // n0x0504 c0x0000 (---------------)  + I vana
	0x00283b88, // n0x0505 c0x0000 (---------------)  + I vanguard
	0x636df902, // n0x0506 c0x018d (n0x1e5e-n0x1e64)  + I vc
	0x63a01d82, // n0x0507 c0x018e (n0x1e64-n0x1e75)  + I ve
	0x0034e285, // n0x0508 c0x0000 (---------------)  + I vegas
	0x00233688, // n0x0509 c0x0000 (---------------)  + I ventures
	0x002e5888, // n0x050a c0x0000 (---------------)  + I verisign
	0x0038e84c, // n0x050b c0x0000 (---------------)  + I versicherung
	0x0023a8c3, // n0x050c c0x0000 (---------------)  + I vet
	0x00258e82, // n0x050d c0x0000 (---------------)  + I vg
	0x63e01302, // n0x050e c0x018f (n0x1e75-n0x1e7a)  + I vi
	0x002c06c6, // n0x050f c0x0000 (---------------)  + I viajes
	0x002ea085, // n0x0510 c0x0000 (---------------)  + I video
	0x00308d43, // n0x0511 c0x0000 (---------------)  + I vig
	0x0022d5c6, // n0x0512 c0x0000 (---------------)  + I viking
	0x002ea1c6, // n0x0513 c0x0000 (---------------)  + I villas
	0x00238f43, // n0x0514 c0x0000 (---------------)  + I vin
	0x002ecf83, // n0x0515 c0x0000 (---------------)  + I vip
	0x002edf46, // n0x0516 c0x0000 (---------------)  + I virgin
	0x002ee4c4, // n0x0517 c0x0000 (---------------)  + I visa
	0x00277cc6, // n0x0518 c0x0000 (---------------)  + I vision
	0x002c4f45, // n0x0519 c0x0000 (---------------)  + I vista
	0x002ee84a, // n0x051a c0x0000 (---------------)  + I vistaprint
	0x00235684, // n0x051b c0x0000 (---------------)  + I viva
	0x002ef584, // n0x051c c0x0000 (---------------)  + I vivo
	0x0034374a, // n0x051d c0x0000 (---------------)  + I vlaanderen
	0x64202fc2, // n0x051e c0x0190 (n0x1e7a-n0x1e87)  + I vn
	0x00267745, // n0x051f c0x0000 (---------------)  + I vodka
	0x002f13ca, // n0x0520 c0x0000 (---------------)  + I volkswagen
	0x002f3c84, // n0x0521 c0x0000 (---------------)  + I vote
	0x002f3d86, // n0x0522 c0x0000 (---------------)  + I voting
	0x002f3f04, // n0x0523 c0x0000 (---------------)  + I voto
	0x00225986, // n0x0524 c0x0000 (---------------)  + I voyage
	0x6462a3c2, // n0x0525 c0x0191 (n0x1e87-n0x1e8b)  + I vu
	0x002c0fc6, // n0x0526 c0x0000 (---------------)  + I vuelos
	0x002c2085, // n0x0527 c0x0000 (---------------)  + I wales
	0x0039bfc7, // n0x0528 c0x0000 (---------------)  + I walmart
	0x00200d06, // n0x0529 c0x0000 (---------------)  + I walter
	0x0022bf84, // n0x052a c0x0000 (---------------)  + I wang
	0x0034eb07, // n0x052b c0x0000 (---------------)  + I wanggou
	0x00363246, // n0x052c c0x0000 (---------------)  + I warman
	0x002a7205, // n0x052d c0x0000 (---------------)  + I watch
	0x0039f8c7, // n0x052e c0x0000 (---------------)  + I watches
	0x0038adc7, // n0x052f c0x0000 (---------------)  + I weather
	0x0038adce, // n0x0530 c0x0000 (---------------)  + I weatherchannel
	0x002292c6, // n0x0531 c0x0000 (---------------)  + I webcam
	0x0030b745, // n0x0532 c0x0000 (---------------)  + I weber
	0x002bb247, // n0x0533 c0x0000 (---------------)  + I website
	0x002e43c3, // n0x0534 c0x0000 (---------------)  + I wed
	0x003425c7, // n0x0535 c0x0000 (---------------)  + I wedding
	0x0020c0c5, // n0x0536 c0x0000 (---------------)  + I weibo
	0x0020eb84, // n0x0537 c0x0000 (---------------)  + I weir
	0x00229902, // n0x0538 c0x0000 (---------------)  + I wf
	0x00382187, // n0x0539 c0x0000 (---------------)  + I whoswho
	0x002e2c04, // n0x053a c0x0000 (---------------)  + I wien
	0x0032c3c4, // n0x053b c0x0000 (---------------)  + I wiki
	0x00253c4b, // n0x053c c0x0000 (---------------)  + I williamhill
	0x0021b643, // n0x053d c0x0000 (---------------)  + I win
	0x0027cf87, // n0x053e c0x0000 (---------------)  + I windows
	0x0021b644, // n0x053f c0x0000 (---------------)  + I wine
	0x002aac47, // n0x0540 c0x0000 (---------------)  + I winners
	0x0022a943, // n0x0541 c0x0000 (---------------)  + I wme
	0x0032150d, // n0x0542 c0x0000 (---------------)  + I wolterskluwer
	0x00378608, // n0x0543 c0x0000 (---------------)  + I woodside
	0x0024fac4, // n0x0544 c0x0000 (---------------)  + I work
	0x00382645, // n0x0545 c0x0000 (---------------)  + I works
	0x002f6805, // n0x0546 c0x0000 (---------------)  + I world
	0x002f47c3, // n0x0547 c0x0000 (---------------)  + I wow
	0x64a044c2, // n0x0548 c0x0192 (n0x1e8b-n0x1e92)  + I ws
	0x002f56c3, // n0x0549 c0x0000 (---------------)  + I wtc
	0x002f5ec3, // n0x054a c0x0000 (---------------)  + I wtf
	0x002165c4, // n0x054b c0x0000 (---------------)  + I xbox
	0x00273ec5, // n0x054c c0x0000 (---------------)  + I xerox
	0x00216687, // n0x054d c0x0000 (---------------)  + I xfinity
	0x00222f06, // n0x054e c0x0000 (---------------)  + I xihuan
	0x003627c3, // n0x054f c0x0000 (---------------)  + I xin
	0x00231f4b, // n0x0550 c0x0000 (---------------)  + I xn--11b4c3d
	0x0023774b, // n0x0551 c0x0000 (---------------)  + I xn--1ck2e1b
	0x0026240b, // n0x0552 c0x0000 (---------------)  + I xn--1qqw23a
	0x00273fca, // n0x0553 c0x0000 (---------------)  + I xn--30rr7y
	0x002a0d8b, // n0x0554 c0x0000 (---------------)  + I xn--3bst00m
	0x002d174b, // n0x0555 c0x0000 (---------------)  + I xn--3ds443g
	0x002ce18c, // n0x0556 c0x0000 (---------------)  + I xn--3e0b707e
	0x002e6951, // n0x0557 c0x0000 (---------------)  + I xn--3oq18vl8pn36a
	0x0032f24a, // n0x0558 c0x0000 (---------------)  + I xn--3pxu8k
	0x0034660b, // n0x0559 c0x0000 (---------------)  + I xn--42c2d9a
	0x0039f24b, // n0x055a c0x0000 (---------------)  + I xn--45brj9c
	0x003a128a, // n0x055b c0x0000 (---------------)  + I xn--45q11c
	0x002f6c0a, // n0x055c c0x0000 (---------------)  + I xn--4gbrim
	0x002f6fcd, // n0x055d c0x0000 (---------------)  + I xn--4gq48lf9j
	0x002f878e, // n0x055e c0x0000 (---------------)  + I xn--54b7fta0cc
	0x002f8ccb, // n0x055f c0x0000 (---------------)  + I xn--55qw42g
	0x002f8f8a, // n0x0560 c0x0000 (---------------)  + I xn--55qx5d
	0x002fb091, // n0x0561 c0x0000 (---------------)  + I xn--5su34j936bgsg
	0x002fb4ca, // n0x0562 c0x0000 (---------------)  + I xn--5tzm5g
	0x002fb9cb, // n0x0563 c0x0000 (---------------)  + I xn--6frz82g
	0x002fbf0e, // n0x0564 c0x0000 (---------------)  + I xn--6qq986b3xl
	0x002fc88c, // n0x0565 c0x0000 (---------------)  + I xn--80adxhks
	0x002fcf8b, // n0x0566 c0x0000 (---------------)  + I xn--80ao21a
	0x002fd24e, // n0x0567 c0x0000 (---------------)  + I xn--80aqecdr1a
	0x002fd5cc, // n0x0568 c0x0000 (---------------)  + I xn--80asehdb
	0x0030070a, // n0x0569 c0x0000 (---------------)  + I xn--80aswg
	0x0030154c, // n0x056a c0x0000 (---------------)  + I xn--8y0a063a
	0x64f0184a, // n0x056b c0x0193 (n0x1e92-n0x1e98)  + I xn--90a3ac
	0x00304f89, // n0x056c c0x0000 (---------------)  + I xn--90ais
	0x0030648a, // n0x056d c0x0000 (---------------)  + I xn--9dbq2a
	0x0030670a, // n0x056e c0x0000 (---------------)  + I xn--9et52u
	0x0030698b, // n0x056f c0x0000 (---------------)  + I xn--9krt00a
	0x0030a94e, // n0x0570 c0x0000 (---------------)  + I xn--b4w605ferd
	0x0030acd1, // n0x0571 c0x0000 (---------------)  + I xn--bck1b9a5dre4c
	0x003121c9, // n0x0572 c0x0000 (---------------)  + I xn--c1avg
	0x0031240a, // n0x0573 c0x0000 (---------------)  + I xn--c2br7g
	0x0031324b, // n0x0574 c0x0000 (---------------)  + I xn--cck2b3b
	0x00314f0a, // n0x0575 c0x0000 (---------------)  + I xn--cg4bki
	0x00315856, // n0x0576 c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x0031704b, // n0x0577 c0x0000 (---------------)  + I xn--czr694b
	0x0031ad0a, // n0x0578 c0x0000 (---------------)  + I xn--czrs0t
	0x0031b54a, // n0x0579 c0x0000 (---------------)  + I xn--czru2d
	0x0031e40b, // n0x057a c0x0000 (---------------)  + I xn--d1acj3b
	0x0031f249, // n0x057b c0x0000 (---------------)  + I xn--d1alf
	0x00321e8d, // n0x057c c0x0000 (---------------)  + I xn--eckvdtc9d
	0x0032278b, // n0x057d c0x0000 (---------------)  + I xn--efvy88h
	0x0032348b, // n0x057e c0x0000 (---------------)  + I xn--estv75g
	0x00323e4b, // n0x057f c0x0000 (---------------)  + I xn--fct429k
	0x00324409, // n0x0580 c0x0000 (---------------)  + I xn--fhbei
	0x00324a4e, // n0x0581 c0x0000 (---------------)  + I xn--fiq228c5hs
	0x00324e8a, // n0x0582 c0x0000 (---------------)  + I xn--fiq64b
	0x0032710a, // n0x0583 c0x0000 (---------------)  + I xn--fiqs8s
	0x0032768a, // n0x0584 c0x0000 (---------------)  + I xn--fiqz9s
	0x00327e4b, // n0x0585 c0x0000 (---------------)  + I xn--fjq720a
	0x0032868b, // n0x0586 c0x0000 (---------------)  + I xn--flw351e
	0x0032894d, // n0x0587 c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x00329d8d, // n0x0588 c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x0032a2d0, // n0x0589 c0x0000 (---------------)  + I xn--fzys8d69uvgm
	0x0032a78b, // n0x058a c0x0000 (---------------)  + I xn--g2xx48c
	0x0032cccc, // n0x058b c0x0000 (---------------)  + I xn--gckr3f0f
	0x0032d78b, // n0x058c c0x0000 (---------------)  + I xn--gecrj9c
	0x0033094b, // n0x058d c0x0000 (---------------)  + I xn--gk3at1e
	0x00332c8b, // n0x058e c0x0000 (---------------)  + I xn--h2brj9c
	0x0033ddcb, // n0x058f c0x0000 (---------------)  + I xn--hxt814e
	0x0033e84f, // n0x0590 c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0033ec0b, // n0x0591 c0x0000 (---------------)  + I xn--imr513n
	0x0033fc0a, // n0x0592 c0x0000 (---------------)  + I xn--io0a7i
	0x00340509, // n0x0593 c0x0000 (---------------)  + I xn--j1aef
	0x003408c9, // n0x0594 c0x0000 (---------------)  + I xn--j1amh
	0x00340ecb, // n0x0595 c0x0000 (---------------)  + I xn--j6w193g
	0x0034118e, // n0x0596 c0x0000 (---------------)  + I xn--jlq61u9w7b
	0x00343dcb, // n0x0597 c0x0000 (---------------)  + I xn--jvr189m
	0x003451cf, // n0x0598 c0x0000 (---------------)  + I xn--kcrx77d1x4a
	0x00346ecb, // n0x0599 c0x0000 (---------------)  + I xn--kprw13d
	0x0034718b, // n0x059a c0x0000 (---------------)  + I xn--kpry57d
	0x0034744b, // n0x059b c0x0000 (---------------)  + I xn--kpu716f
	0x00347a0a, // n0x059c c0x0000 (---------------)  + I xn--kput3i
	0x0034ee89, // n0x059d c0x0000 (---------------)  + I xn--l1acc
	0x003512cf, // n0x059e c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0035618c, // n0x059f c0x0000 (---------------)  + I xn--mgb2ddes
	0x0035660c, // n0x05a0 c0x0000 (---------------)  + I xn--mgb9awbf
	0x00356bce, // n0x05a1 c0x0000 (---------------)  + I xn--mgba3a3ejt
	0x0035808f, // n0x05a2 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035844e, // n0x05a3 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x00358f50, // n0x05a4 c0x0000 (---------------)  + I xn--mgba7c0bbn0a
	0x0035934f, // n0x05a5 c0x0000 (---------------)  + I xn--mgbaakc7dvf
	0x0035a0ce, // n0x05a6 c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0035accc, // n0x05a7 c0x0000 (---------------)  + I xn--mgbab2bd
	0x0035afd2, // n0x05a8 c0x0000 (---------------)  + I xn--mgbai9a5eva00b
	0x0035c651, // n0x05a9 c0x0000 (---------------)  + I xn--mgbai9azgqp6j
	0x0035cc0e, // n0x05aa c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0035d04e, // n0x05ab c0x0000 (---------------)  + I xn--mgbb9fbpob
	0x0035d58e, // n0x05ac c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0035d90f, // n0x05ad c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x0035dcce, // n0x05ae c0x0000 (---------------)  + I xn--mgbca7dzdo
	0x0035e1d3, // n0x05af c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x0035e691, // n0x05b0 c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x0035eace, // n0x05b1 c0x0000 (---------------)  + I xn--mgbi4ecexp
	0x0035ef4c, // n0x05b2 c0x0000 (---------------)  + I xn--mgbpl2fh
	0x0035f393, // n0x05b3 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x0035fb10, // n0x05b4 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x0036038c, // n0x05b5 c0x0000 (---------------)  + I xn--mgbt3dhd
	0x0036068c, // n0x05b6 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x00360bcb, // n0x05b7 c0x0000 (---------------)  + I xn--mgbtx2b
	0x0036108e, // n0x05b8 c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x0036158b, // n0x05b9 c0x0000 (---------------)  + I xn--mix082f
	0x0036194b, // n0x05ba c0x0000 (---------------)  + I xn--mix891f
	0x00362e4c, // n0x05bb c0x0000 (---------------)  + I xn--mk1bu44c
	0x0036b2ca, // n0x05bc c0x0000 (---------------)  + I xn--mxtq1m
	0x0036b68c, // n0x05bd c0x0000 (---------------)  + I xn--ngbc5azd
	0x0036b98c, // n0x05be c0x0000 (---------------)  + I xn--ngbe9e0a
	0x0036ca4b, // n0x05bf c0x0000 (---------------)  + I xn--nnx388a
	0x0036cd08, // n0x05c0 c0x0000 (---------------)  + I xn--node
	0x0036d1c9, // n0x05c1 c0x0000 (---------------)  + I xn--nqv7f
	0x0036d1cf, // n0x05c2 c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x0036eb4b, // n0x05c3 c0x0000 (---------------)  + I xn--nyqy26a
	0x0036f70a, // n0x05c4 c0x0000 (---------------)  + I xn--o3cw4h
	0x00370ccc, // n0x05c5 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x00372a49, // n0x05c6 c0x0000 (---------------)  + I xn--p1acf
	0x00372cc8, // n0x05c7 c0x0000 (---------------)  + I xn--p1ai
	0x00372ecb, // n0x05c8 c0x0000 (---------------)  + I xn--pbt977c
	0x00373fcb, // n0x05c9 c0x0000 (---------------)  + I xn--pgbs0dh
	0x00374bca, // n0x05ca c0x0000 (---------------)  + I xn--pssy2u
	0x00374e4b, // n0x05cb c0x0000 (---------------)  + I xn--q9jyb4c
	0x0037544c, // n0x05cc c0x0000 (---------------)  + I xn--qcka1pmc
	0x00376088, // n0x05cd c0x0000 (---------------)  + I xn--qxam
	0x0037880b, // n0x05ce c0x0000 (---------------)  + I xn--rhqv96g
	0x0037b40b, // n0x05cf c0x0000 (---------------)  + I xn--rovu88b
	0x0037ee0b, // n0x05d0 c0x0000 (---------------)  + I xn--s9brj9c
	0x003809cb, // n0x05d1 c0x0000 (---------------)  + I xn--ses554g
	0x0038a94b, // n0x05d2 c0x0000 (---------------)  + I xn--t60b56a
	0x0038ac09, // n0x05d3 c0x0000 (---------------)  + I xn--tckwe
	0x0038b14d, // n0x05d4 c0x0000 (---------------)  + I xn--tiq49xqyj
	0x003909ca, // n0x05d5 c0x0000 (---------------)  + I xn--unup4y
	0x00391917, // n0x05d6 c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x00392d58, // n0x05d7 c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x003964c9, // n0x05d8 c0x0000 (---------------)  + I xn--vhquv
	0x003976cb, // n0x05d9 c0x0000 (---------------)  + I xn--vuq861b
	0x00398c14, // n0x05da c0x0000 (---------------)  + I xn--w4r85el8fhu5dnra
	0x0039910b, // n0x05db c0x0000 (---------------)  + I xn--w4rs40l
	0x0039968a, // n0x05dc c0x0000 (---------------)  + I xn--wgbh1c
	0x0039b98a, // n0x05dd c0x0000 (---------------)  + I xn--wgbl6a
	0x0039bc0b, // n0x05de c0x0000 (---------------)  + I xn--xhq521b
	0x0039c710, // n0x05df c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x0039cb11, // n0x05e0 c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x0039da4a, // n0x05e1 c0x0000 (---------------)  + I xn--y9a3aq
	0x0039e84d, // n0x05e2 c0x0000 (---------------)  + I xn--yfro4i67o
	0x0039ef4d, // n0x05e3 c0x0000 (---------------)  + I xn--ygbi2ammx
	0x003a170b, // n0x05e4 c0x0000 (---------------)  + I xn--zfr164b
	0x003a5186, // n0x05e5 c0x0000 (---------------)  + I xperia
	0x00363643, // n0x05e6 c0x0000 (---------------)  + I xxx
	0x00241843, // n0x05e7 c0x0000 (---------------)  + I xyz
	0x00303906, // n0x05e8 c0x0000 (---------------)  + I yachts
	0x00286ec5, // n0x05e9 c0x0000 (---------------)  + I yahoo
	0x002c3b07, // n0x05ea c0x0000 (---------------)  + I yamaxun
	0x0032f106, // n0x05eb c0x0000 (---------------)  + I yandex
	0x0161bbc2, // n0x05ec c0x0005 (---------------)* o I ye
	0x002f5809, // n0x05ed c0x0000 (---------------)  + I yodobashi
	0x002fffc4, // n0x05ee c0x0000 (---------------)  + I yoga
	0x00353348, // n0x05ef c0x0000 (---------------)  + I yokohama
	0x00243d83, // n0x05f0 c0x0000 (---------------)  + I you
	0x002ddec7, // n0x05f1 c0x0000 (---------------)  + I youtube
	0x00217f82, // n0x05f2 c0x0000 (---------------)  + I yt
	0x002a69c3, // n0x05f3 c0x0000 (---------------)  + I yun
	0x6520a182, // n0x05f4 c0x0194 (n0x1e98-n0x1ea9)  o I za
	0x002bf146, // n0x05f5 c0x0000 (---------------)  + I zappos
	0x002bfcc4, // n0x05f6 c0x0000 (---------------)  + I zara
	0x00337c84, // n0x05f7 c0x0000 (---------------)  + I zero
	0x0022e0c3, // n0x05f8 c0x0000 (---------------)  + I zip
	0x0022e0c5, // n0x05f9 c0x0000 (---------------)  + I zippo
	0x016f6982, // n0x05fa c0x0005 (---------------)* o I zm
	0x002d6884, // n0x05fb c0x0000 (---------------)  + I zone
	0x0026c687, // n0x05fc c0x0000 (---------------)  + I zuerich
	0x0165b942, // n0x05fd c0x0005 (---------------)* o I zw
	0x0022d0c3, // n0x05fe c0x0000 (---------------)  + I com
	0x002325c3, // n0x05ff c0x0000 (---------------)  + I edu
	0x00264783, // n0x0600 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0601 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0602 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0603 c0x0000 (---------------)  + I org
	0x0020f543, // n0x0604 c0x0000 (---------------)  + I nom
	0x00203982, // n0x0605 c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x0606 c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x0607 c0x0000 (---------------)  + I co
	0x00264783, // n0x0608 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0609 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x060a c0x0000 (---------------)  + I net
	0x00223a43, // n0x060b c0x0000 (---------------)  + I org
	0x00213403, // n0x060c c0x0000 (---------------)  + I sch
	0x0030f696, // n0x060d c0x0000 (---------------)  + I accident-investigation
	0x003111d3, // n0x060e c0x0000 (---------------)  + I accident-prevention
	0x002eb0c9, // n0x060f c0x0000 (---------------)  + I aerobatic
	0x0039a548, // n0x0610 c0x0000 (---------------)  + I aeroclub
	0x002dbdc9, // n0x0611 c0x0000 (---------------)  + I aerodrome
	0x002f1546, // n0x0612 c0x0000 (---------------)  + I agents
	0x0033bb90, // n0x0613 c0x0000 (---------------)  + I air-surveillance
	0x002b1f13, // n0x0614 c0x0000 (---------------)  + I air-traffic-control
	0x0032b9c8, // n0x0615 c0x0000 (---------------)  + I aircraft
	0x00272387, // n0x0616 c0x0000 (---------------)  + I airline
	0x0027dc87, // n0x0617 c0x0000 (---------------)  + I airport
	0x0029910a, // n0x0618 c0x0000 (---------------)  + I airtraffic
	0x002b1b89, // n0x0619 c0x0000 (---------------)  + I ambulance
	0x00369049, // n0x061a c0x0000 (---------------)  + I amusement
	0x002c7fcb, // n0x061b c0x0000 (---------------)  + I association
	0x0031dac6, // n0x061c c0x0000 (---------------)  + I author
	0x002af4ca, // n0x061d c0x0000 (---------------)  + I ballooning
	0x00220246, // n0x061e c0x0000 (---------------)  + I broker
	0x002ffbc3, // n0x061f c0x0000 (---------------)  + I caa
	0x002ec185, // n0x0620 c0x0000 (---------------)  + I cargo
	0x0034d9c8, // n0x0621 c0x0000 (---------------)  + I catering
	0x002d544d, // n0x0622 c0x0000 (---------------)  + I certification
	0x0033b74c, // n0x0623 c0x0000 (---------------)  + I championship
	0x002c1d47, // n0x0624 c0x0000 (---------------)  + I charter
	0x00351b4d, // n0x0625 c0x0000 (---------------)  + I civilaviation
	0x00387104, // n0x0626 c0x0000 (---------------)  + I club
	0x00230a8a, // n0x0627 c0x0000 (---------------)  + I conference
	0x002313ca, // n0x0628 c0x0000 (---------------)  + I consultant
	0x0023188a, // n0x0629 c0x0000 (---------------)  + I consulting
	0x002b2207, // n0x062a c0x0000 (---------------)  + I control
	0x0023c607, // n0x062b c0x0000 (---------------)  + I council
	0x0023e444, // n0x062c c0x0000 (---------------)  + I crew
	0x002289c6, // n0x062d c0x0000 (---------------)  + I design
	0x0031de84, // n0x062e c0x0000 (---------------)  + I dgca
	0x002f1f48, // n0x062f c0x0000 (---------------)  + I educator
	0x002382c9, // n0x0630 c0x0000 (---------------)  + I emergency
	0x00364cc6, // n0x0631 c0x0000 (---------------)  + I engine
	0x00364cc8, // n0x0632 c0x0000 (---------------)  + I engineer
	0x0024244d, // n0x0633 c0x0000 (---------------)  + I entertainment
	0x002bd849, // n0x0634 c0x0000 (---------------)  + I equipment
	0x0039b008, // n0x0635 c0x0000 (---------------)  + I exchange
	0x00241647, // n0x0636 c0x0000 (---------------)  + I express
	0x0020038a, // n0x0637 c0x0000 (---------------)  + I federation
	0x0024a106, // n0x0638 c0x0000 (---------------)  + I flight
	0x00255fc7, // n0x0639 c0x0000 (---------------)  + I freight
	0x00235f44, // n0x063a c0x0000 (---------------)  + I fuel
	0x0024cd07, // n0x063b c0x0000 (---------------)  + I gliding
	0x0026478a, // n0x063c c0x0000 (---------------)  + I government
	0x002fa24e, // n0x063d c0x0000 (---------------)  + I groundhandling
	0x0020fb45, // n0x063e c0x0000 (---------------)  + I group
	0x002f450b, // n0x063f c0x0000 (---------------)  + I hanggliding
	0x002ec4c9, // n0x0640 c0x0000 (---------------)  + I homebuilt
	0x00236a09, // n0x0641 c0x0000 (---------------)  + I insurance
	0x00277287, // n0x0642 c0x0000 (---------------)  + I journal
	0x00393c0a, // n0x0643 c0x0000 (---------------)  + I journalist
	0x0027f147, // n0x0644 c0x0000 (---------------)  + I leasing
	0x002db849, // n0x0645 c0x0000 (---------------)  + I logistics
	0x00390088, // n0x0646 c0x0000 (---------------)  + I magazine
	0x002679cb, // n0x0647 c0x0000 (---------------)  + I maintenance
	0x003a15c5, // n0x0648 c0x0000 (---------------)  + I media
	0x002f9f4a, // n0x0649 c0x0000 (---------------)  + I microlight
	0x0029cb89, // n0x064a c0x0000 (---------------)  + I modelling
	0x00308cca, // n0x064b c0x0000 (---------------)  + I navigation
	0x002c02cb, // n0x064c c0x0000 (---------------)  + I parachuting
	0x0024cc0b, // n0x064d c0x0000 (---------------)  + I paragliding
	0x002c7d55, // n0x064e c0x0000 (---------------)  + I passenger-association
	0x002cf9c5, // n0x064f c0x0000 (---------------)  + I pilot
	0x002416c5, // n0x0650 c0x0000 (---------------)  + I press
	0x002dabca, // n0x0651 c0x0000 (---------------)  + I production
	0x00315fca, // n0x0652 c0x0000 (---------------)  + I recreation
	0x00225087, // n0x0653 c0x0000 (---------------)  + I repbody
	0x0021c703, // n0x0654 c0x0000 (---------------)  + I res
	0x00298048, // n0x0655 c0x0000 (---------------)  + I research
	0x002c8a4a, // n0x0656 c0x0000 (---------------)  + I rotorcraft
	0x00397c86, // n0x0657 c0x0000 (---------------)  + I safety
	0x0023c949, // n0x0658 c0x0000 (---------------)  + I scientist
	0x00201248, // n0x0659 c0x0000 (---------------)  + I services
	0x002aadc4, // n0x065a c0x0000 (---------------)  + I show
	0x0025de09, // n0x065b c0x0000 (---------------)  + I skydiving
	0x002b2e48, // n0x065c c0x0000 (---------------)  + I software
	0x002a4f47, // n0x065d c0x0000 (---------------)  + I student
	0x0025e586, // n0x065e c0x0000 (---------------)  + I trader
	0x0029de47, // n0x065f c0x0000 (---------------)  + I trading
	0x00291747, // n0x0660 c0x0000 (---------------)  + I trainer
	0x0023de85, // n0x0661 c0x0000 (---------------)  + I union
	0x002d384c, // n0x0662 c0x0000 (---------------)  + I workinggroup
	0x00382645, // n0x0663 c0x0000 (---------------)  + I works
	0x0022d0c3, // n0x0664 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0665 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0666 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0667 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0668 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x0669 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x066a c0x0000 (---------------)  + I com
	0x0021e283, // n0x066b c0x0000 (---------------)  + I net
	0x0020f543, // n0x066c c0x0000 (---------------)  + I nom
	0x00223a43, // n0x066d c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x066e c0x0000 (---------------)  + I com
	0x0021e283, // n0x066f c0x0000 (---------------)  + I net
	0x00203e03, // n0x0670 c0x0000 (---------------)  + I off
	0x00223a43, // n0x0671 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x0672 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x0673 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0674 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0675 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0676 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0677 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0678 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x0679 c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x067a c0x0000 (---------------)  + I co
	0x002003c2, // n0x067b c0x0000 (---------------)  + I ed
	0x00231ac2, // n0x067c c0x0000 (---------------)  + I gv
	0x00202742, // n0x067d c0x0000 (---------------)  + I it
	0x00200882, // n0x067e c0x0000 (---------------)  + I og
	0x00225102, // n0x067f c0x0000 (---------------)  + I pb
	0x0462d0c3, // n0x0680 c0x0011 (n0x0689-n0x068a)  + I com
	0x002325c3, // n0x0681 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x0682 c0x0000 (---------------)  + I gob
	0x00264783, // n0x0683 c0x0000 (---------------)  + I gov
	0x00267a43, // n0x0684 c0x0000 (---------------)  + I int
	0x00214d03, // n0x0685 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0686 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0687 c0x0000 (---------------)  + I org
	0x00233743, // n0x0688 c0x0000 (---------------)  + I tur
	0x000f4e08, // n0x0689 c0x0000 (---------------)  +   blogspot
	0x0023a704, // n0x068a c0x0000 (---------------)  + I e164
	0x0033a087, // n0x068b c0x0000 (---------------)  + I in-addr
	0x00223f03, // n0x068c c0x0000 (---------------)  + I ip6
	0x0028ba84, // n0x068d c0x0000 (---------------)  + I iris
	0x0020b143, // n0x068e c0x0000 (---------------)  + I uri
	0x00277303, // n0x068f c0x0000 (---------------)  + I urn
	0x00264783, // n0x0690 c0x0000 (---------------)  + I gov
	0x00203982, // n0x0691 c0x0000 (---------------)  + I ac
	0x00125b83, // n0x0692 c0x0000 (---------------)  +   biz
	0x05603dc2, // n0x0693 c0x0015 (n0x0698-n0x0699)  + I co
	0x00231ac2, // n0x0694 c0x0000 (---------------)  + I gv
	0x001a4f84, // n0x0695 c0x0000 (---------------)  +   info
	0x00200282, // n0x0696 c0x0000 (---------------)  + I or
	0x000da7c4, // n0x0697 c0x0000 (---------------)  +   priv
	0x000f4e08, // n0x0698 c0x0000 (---------------)  +   blogspot
	0x00231e43, // n0x0699 c0x0000 (---------------)  + I act
	0x0024ee43, // n0x069a c0x0000 (---------------)  + I asn
	0x05e2d0c3, // n0x069b c0x0017 (n0x06ab-n0x06ac)  + I com
	0x00230a84, // n0x069c c0x0000 (---------------)  + I conf
	0x062325c3, // n0x069d c0x0018 (n0x06ac-n0x06b4)  + I edu
	0x06664783, // n0x069e c0x0019 (n0x06b4-n0x06b9)  + I gov
	0x00203782, // n0x069f c0x0000 (---------------)  + I id
	0x003a4f84, // n0x06a0 c0x0000 (---------------)  + I info
	0x0021e283, // n0x06a1 c0x0000 (---------------)  + I net
	0x002e44c3, // n0x06a2 c0x0000 (---------------)  + I nsw
	0x00204982, // n0x06a3 c0x0000 (---------------)  + I nt
	0x00223a43, // n0x06a4 c0x0000 (---------------)  + I org
	0x0021a982, // n0x06a5 c0x0000 (---------------)  + I oz
	0x002df243, // n0x06a6 c0x0000 (---------------)  + I qld
	0x00200642, // n0x06a7 c0x0000 (---------------)  + I sa
	0x00202783, // n0x06a8 c0x0000 (---------------)  + I tas
	0x00201303, // n0x06a9 c0x0000 (---------------)  + I vic
	0x00200d02, // n0x06aa c0x0000 (---------------)  + I wa
	0x000f4e08, // n0x06ab c0x0000 (---------------)  +   blogspot
	0x00231e43, // n0x06ac c0x0000 (---------------)  + I act
	0x002e44c3, // n0x06ad c0x0000 (---------------)  + I nsw
	0x00204982, // n0x06ae c0x0000 (---------------)  + I nt
	0x002df243, // n0x06af c0x0000 (---------------)  + I qld
	0x00200642, // n0x06b0 c0x0000 (---------------)  + I sa
	0x00202783, // n0x06b1 c0x0000 (---------------)  + I tas
	0x00201303, // n0x06b2 c0x0000 (---------------)  + I vic
	0x00200d02, // n0x06b3 c0x0000 (---------------)  + I wa
	0x002df243, // n0x06b4 c0x0000 (---------------)  + I qld
	0x00200642, // n0x06b5 c0x0000 (---------------)  + I sa
	0x00202783, // n0x06b6 c0x0000 (---------------)  + I tas
	0x00201303, // n0x06b7 c0x0000 (---------------)  + I vic
	0x00200d02, // n0x06b8 c0x0000 (---------------)  + I wa
	0x0022d0c3, // n0x06b9 c0x0000 (---------------)  + I com
	0x00325b83, // n0x06ba c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x06bb c0x0000 (---------------)  + I com
	0x002325c3, // n0x06bc c0x0000 (---------------)  + I edu
	0x00264783, // n0x06bd c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x06be c0x0000 (---------------)  + I info
	0x00267a43, // n0x06bf c0x0000 (---------------)  + I int
	0x00214d03, // n0x06c0 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x06c1 c0x0000 (---------------)  + I name
	0x0021e283, // n0x06c2 c0x0000 (---------------)  + I net
	0x00223a43, // n0x06c3 c0x0000 (---------------)  + I org
	0x00203902, // n0x06c4 c0x0000 (---------------)  + I pp
	0x00220443, // n0x06c5 c0x0000 (---------------)  + I pro
	0x000f4e08, // n0x06c6 c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x06c7 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x06c8 c0x0000 (---------------)  + I com
	0x002325c3, // n0x06c9 c0x0000 (---------------)  + I edu
	0x00264783, // n0x06ca c0x0000 (---------------)  + I gov
	0x00214d03, // n0x06cb c0x0000 (---------------)  + I mil
	0x0021e283, // n0x06cc c0x0000 (---------------)  + I net
	0x00223a43, // n0x06cd c0x0000 (---------------)  + I org
	0x00206e82, // n0x06ce c0x0000 (---------------)  + I rs
	0x002726c4, // n0x06cf c0x0000 (---------------)  + I unbi
	0x002062c4, // n0x06d0 c0x0000 (---------------)  + I unsa
	0x00325b83, // n0x06d1 c0x0000 (---------------)  + I biz
	0x00203dc2, // n0x06d2 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x06d3 c0x0000 (---------------)  + I com
	0x002325c3, // n0x06d4 c0x0000 (---------------)  + I edu
	0x00264783, // n0x06d5 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x06d6 c0x0000 (---------------)  + I info
	0x0021e283, // n0x06d7 c0x0000 (---------------)  + I net
	0x00223a43, // n0x06d8 c0x0000 (---------------)  + I org
	0x003758c5, // n0x06d9 c0x0000 (---------------)  + I store
	0x0020da42, // n0x06da c0x0000 (---------------)  + I tv
	0x00203982, // n0x06db c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x06dc c0x0000 (---------------)  +   blogspot
	0x00264783, // n0x06dd c0x0000 (---------------)  + I gov
	0x00274101, // n0x06de c0x0000 (---------------)  + I 0
	0x00226901, // n0x06df c0x0000 (---------------)  + I 1
	0x00237901, // n0x06e0 c0x0000 (---------------)  + I 2
	0x00226681, // n0x06e1 c0x0000 (---------------)  + I 3
	0x00232101, // n0x06e2 c0x0000 (---------------)  + I 4
	0x0026c401, // n0x06e3 c0x0000 (---------------)  + I 5
	0x00223f81, // n0x06e4 c0x0000 (---------------)  + I 6
	0x002365c1, // n0x06e5 c0x0000 (---------------)  + I 7
	0x002e6b41, // n0x06e6 c0x0000 (---------------)  + I 8
	0x002f7281, // n0x06e7 c0x0000 (---------------)  + I 9
	0x00200101, // n0x06e8 c0x0000 (---------------)  + I a
	0x00200001, // n0x06e9 c0x0000 (---------------)  + I b
	0x000f4e08, // n0x06ea c0x0000 (---------------)  +   blogspot
	0x00200301, // n0x06eb c0x0000 (---------------)  + I c
	0x00200401, // n0x06ec c0x0000 (---------------)  + I d
	0x00200081, // n0x06ed c0x0000 (---------------)  + I e
	0x00200381, // n0x06ee c0x0000 (---------------)  + I f
	0x00200701, // n0x06ef c0x0000 (---------------)  + I g
	0x00200601, // n0x06f0 c0x0000 (---------------)  + I h
	0x00200041, // n0x06f1 c0x0000 (---------------)  + I i
	0x002014c1, // n0x06f2 c0x0000 (---------------)  + I j
	0x00200c01, // n0x06f3 c0x0000 (---------------)  + I k
	0x00200201, // n0x06f4 c0x0000 (---------------)  + I l
	0x00200181, // n0x06f5 c0x0000 (---------------)  + I m
	0x002005c1, // n0x06f6 c0x0000 (---------------)  + I n
	0x00200281, // n0x06f7 c0x0000 (---------------)  + I o
	0x00200981, // n0x06f8 c0x0000 (---------------)  + I p
	0x00200a41, // n0x06f9 c0x0000 (---------------)  + I q
	0x002002c1, // n0x06fa c0x0000 (---------------)  + I r
	0x00200641, // n0x06fb c0x0000 (---------------)  + I s
	0x00200141, // n0x06fc c0x0000 (---------------)  + I t
	0x00200a81, // n0x06fd c0x0000 (---------------)  + I u
	0x002000c1, // n0x06fe c0x0000 (---------------)  + I v
	0x00200d01, // n0x06ff c0x0000 (---------------)  + I w
	0x002045c1, // n0x0700 c0x0000 (---------------)  + I x
	0x002010c1, // n0x0701 c0x0000 (---------------)  + I y
	0x00204441, // n0x0702 c0x0000 (---------------)  + I z
	0x0022d0c3, // n0x0703 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0704 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0705 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0706 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0707 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x0708 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x0709 c0x0000 (---------------)  + I com
	0x002325c3, // n0x070a c0x0000 (---------------)  + I edu
	0x00200282, // n0x070b c0x0000 (---------------)  + I or
	0x00223a43, // n0x070c c0x0000 (---------------)  + I org
	0x00101c07, // n0x070d c0x0000 (---------------)  +   dscloud
	0x00020b06, // n0x070e c0x0000 (---------------)  +   dyndns
	0x0004fd0a, // n0x070f c0x0000 (---------------)  +   for-better
	0x00082788, // n0x0710 c0x0000 (---------------)  +   for-more
	0x00050308, // n0x0711 c0x0000 (---------------)  +   for-some
	0x00050d47, // n0x0712 c0x0000 (---------------)  +   for-the
	0x000636c6, // n0x0713 c0x0000 (---------------)  +   selfip
	0x001374c6, // n0x0714 c0x0000 (---------------)  +   webhop
	0x002c7fc4, // n0x0715 c0x0000 (---------------)  + I asso
	0x003134c7, // n0x0716 c0x0000 (---------------)  + I barreau
	0x000f4e08, // n0x0717 c0x0000 (---------------)  +   blogspot
	0x0034ec04, // n0x0718 c0x0000 (---------------)  + I gouv
	0x0022d0c3, // n0x0719 c0x0000 (---------------)  + I com
	0x002325c3, // n0x071a c0x0000 (---------------)  + I edu
	0x00264783, // n0x071b c0x0000 (---------------)  + I gov
	0x0021e283, // n0x071c c0x0000 (---------------)  + I net
	0x00223a43, // n0x071d c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x071e c0x0000 (---------------)  + I com
	0x002325c3, // n0x071f c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x0720 c0x0000 (---------------)  + I gob
	0x00264783, // n0x0721 c0x0000 (---------------)  + I gov
	0x00267a43, // n0x0722 c0x0000 (---------------)  + I int
	0x00214d03, // n0x0723 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0724 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0725 c0x0000 (---------------)  + I org
	0x0020da42, // n0x0726 c0x0000 (---------------)  + I tv
	0x002be683, // n0x0727 c0x0000 (---------------)  + I adm
	0x0021a0c3, // n0x0728 c0x0000 (---------------)  + I adv
	0x0024a5c3, // n0x0729 c0x0000 (---------------)  + I agr
	0x00201682, // n0x072a c0x0000 (---------------)  + I am
	0x00247d83, // n0x072b c0x0000 (---------------)  + I arq
	0x00203b03, // n0x072c c0x0000 (---------------)  + I art
	0x00206cc3, // n0x072d c0x0000 (---------------)  + I ato
	0x00200001, // n0x072e c0x0000 (---------------)  + I b
	0x00204e03, // n0x072f c0x0000 (---------------)  + I bio
	0x00225384, // n0x0730 c0x0000 (---------------)  + I blog
	0x002d43c3, // n0x0731 c0x0000 (---------------)  + I bmd
	0x00302703, // n0x0732 c0x0000 (---------------)  + I cim
	0x00219ec3, // n0x0733 c0x0000 (---------------)  + I cng
	0x003998c3, // n0x0734 c0x0000 (---------------)  + I cnt
	0x0a22d0c3, // n0x0735 c0x0028 (n0x076d-n0x076e)  + I com
	0x00235044, // n0x0736 c0x0000 (---------------)  + I coop
	0x00219e83, // n0x0737 c0x0000 (---------------)  + I ecn
	0x00203d83, // n0x0738 c0x0000 (---------------)  + I eco
	0x002325c3, // n0x0739 c0x0000 (---------------)  + I edu
	0x00232303, // n0x073a c0x0000 (---------------)  + I emp
	0x00203603, // n0x073b c0x0000 (---------------)  + I eng
	0x002944c3, // n0x073c c0x0000 (---------------)  + I esp
	0x00302683, // n0x073d c0x0000 (---------------)  + I etc
	0x00222503, // n0x073e c0x0000 (---------------)  + I eti
	0x00211903, // n0x073f c0x0000 (---------------)  + I far
	0x0024b8c4, // n0x0740 c0x0000 (---------------)  + I flog
	0x0022c142, // n0x0741 c0x0000 (---------------)  + I fm
	0x0024f683, // n0x0742 c0x0000 (---------------)  + I fnd
	0x00255743, // n0x0743 c0x0000 (---------------)  + I fot
	0x00270883, // n0x0744 c0x0000 (---------------)  + I fst
	0x0033a943, // n0x0745 c0x0000 (---------------)  + I g12
	0x00338bc3, // n0x0746 c0x0000 (---------------)  + I ggf
	0x00264783, // n0x0747 c0x0000 (---------------)  + I gov
	0x002bf643, // n0x0748 c0x0000 (---------------)  + I imb
	0x0021c903, // n0x0749 c0x0000 (---------------)  + I ind
	0x003a4dc3, // n0x074a c0x0000 (---------------)  + I inf
	0x00215283, // n0x074b c0x0000 (---------------)  + I jor
	0x002e7dc3, // n0x074c c0x0000 (---------------)  + I jus
	0x0021e643, // n0x074d c0x0000 (---------------)  + I leg
	0x002b9e43, // n0x074e c0x0000 (---------------)  + I lel
	0x0021c483, // n0x074f c0x0000 (---------------)  + I mat
	0x00220d43, // n0x0750 c0x0000 (---------------)  + I med
	0x00214d03, // n0x0751 c0x0000 (---------------)  + I mil
	0x00226cc2, // n0x0752 c0x0000 (---------------)  + I mp
	0x002769c3, // n0x0753 c0x0000 (---------------)  + I mus
	0x0021e283, // n0x0754 c0x0000 (---------------)  + I net
	0x0160f543, // n0x0755 c0x0005 (---------------)* o I nom
	0x00241c83, // n0x0756 c0x0000 (---------------)  + I not
	0x002332c3, // n0x0757 c0x0000 (---------------)  + I ntr
	0x0020cd83, // n0x0758 c0x0000 (---------------)  + I odo
	0x00223a43, // n0x0759 c0x0000 (---------------)  + I org
	0x0026b8c3, // n0x075a c0x0000 (---------------)  + I ppg
	0x00220443, // n0x075b c0x0000 (---------------)  + I pro
	0x0034ddc3, // n0x075c c0x0000 (---------------)  + I psc
	0x002ed003, // n0x075d c0x0000 (---------------)  + I psi
	0x002df403, // n0x075e c0x0000 (---------------)  + I qsl
	0x00245c05, // n0x075f c0x0000 (---------------)  + I radio
	0x00226e03, // n0x0760 c0x0000 (---------------)  + I rec
	0x002df443, // n0x0761 c0x0000 (---------------)  + I slg
	0x00353ac3, // n0x0762 c0x0000 (---------------)  + I srv
	0x00222e84, // n0x0763 c0x0000 (---------------)  + I taxi
	0x0032b043, // n0x0764 c0x0000 (---------------)  + I teo
	0x0023b743, // n0x0765 c0x0000 (---------------)  + I tmp
	0x002c9803, // n0x0766 c0x0000 (---------------)  + I trd
	0x00233743, // n0x0767 c0x0000 (---------------)  + I tur
	0x0020da42, // n0x0768 c0x0000 (---------------)  + I tv
	0x0023a8c3, // n0x0769 c0x0000 (---------------)  + I vet
	0x002f0384, // n0x076a c0x0000 (---------------)  + I vlog
	0x0032c3c4, // n0x076b c0x0000 (---------------)  + I wiki
	0x002418c3, // n0x076c c0x0000 (---------------)  + I zlg
	0x000f4e08, // n0x076d c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x076e c0x0000 (---------------)  + I com
	0x002325c3, // n0x076f c0x0000 (---------------)  + I edu
	0x00264783, // n0x0770 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0771 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0772 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x0773 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0774 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0775 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0776 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0777 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x0778 c0x0000 (---------------)  + I co
	0x00223a43, // n0x0779 c0x0000 (---------------)  + I org
	0x0b62d0c3, // n0x077a c0x002d (n0x077e-n0x077f)  + I com
	0x00264783, // n0x077b c0x0000 (---------------)  + I gov
	0x00214d03, // n0x077c c0x0000 (---------------)  + I mil
	0x00203e02, // n0x077d c0x0000 (---------------)  + I of
	0x000f4e08, // n0x077e c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x077f c0x0000 (---------------)  + I com
	0x002325c3, // n0x0780 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0781 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0782 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0783 c0x0000 (---------------)  + I org
	0x0000a182, // n0x0784 c0x0000 (---------------)  +   za
	0x00201702, // n0x0785 c0x0000 (---------------)  + I ab
	0x00229342, // n0x0786 c0x0000 (---------------)  + I bc
	0x000f4e08, // n0x0787 c0x0000 (---------------)  +   blogspot
	0x00003dc2, // n0x0788 c0x0000 (---------------)  +   co
	0x00234242, // n0x0789 c0x0000 (---------------)  + I gc
	0x0020a382, // n0x078a c0x0000 (---------------)  + I mb
	0x0020d0c2, // n0x078b c0x0000 (---------------)  + I nb
	0x00230b02, // n0x078c c0x0000 (---------------)  + I nf
	0x00203842, // n0x078d c0x0000 (---------------)  + I nl
	0x00206302, // n0x078e c0x0000 (---------------)  + I ns
	0x00204982, // n0x078f c0x0000 (---------------)  + I nt
	0x002020c2, // n0x0790 c0x0000 (---------------)  + I nu
	0x00200582, // n0x0791 c0x0000 (---------------)  + I on
	0x002087c2, // n0x0792 c0x0000 (---------------)  + I pe
	0x00375542, // n0x0793 c0x0000 (---------------)  + I qc
	0x00208882, // n0x0794 c0x0000 (---------------)  + I sk
	0x002617c2, // n0x0795 c0x0000 (---------------)  + I yk
	0x00141f09, // n0x0796 c0x0000 (---------------)  +   ftpaccess
	0x0016e40b, // n0x0797 c0x0000 (---------------)  +   game-server
	0x000cb588, // n0x0798 c0x0000 (---------------)  +   myphotos
	0x0003f989, // n0x0799 c0x0000 (---------------)  +   scrapping
	0x00264783, // n0x079a c0x0000 (---------------)  + I gov
	0x000f4e08, // n0x079b c0x0000 (---------------)  +   blogspot
	0x000f4e08, // n0x079c c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x079d c0x0000 (---------------)  + I ac
	0x002c7fc4, // n0x079e c0x0000 (---------------)  + I asso
	0x00203dc2, // n0x079f c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x07a0 c0x0000 (---------------)  + I com
	0x002003c2, // n0x07a1 c0x0000 (---------------)  + I ed
	0x002325c3, // n0x07a2 c0x0000 (---------------)  + I edu
	0x00200702, // n0x07a3 c0x0000 (---------------)  + I go
	0x0034ec04, // n0x07a4 c0x0000 (---------------)  + I gouv
	0x00267a43, // n0x07a5 c0x0000 (---------------)  + I int
	0x00246c82, // n0x07a6 c0x0000 (---------------)  + I md
	0x0021e283, // n0x07a7 c0x0000 (---------------)  + I net
	0x00200282, // n0x07a8 c0x0000 (---------------)  + I or
	0x00223a43, // n0x07a9 c0x0000 (---------------)  + I org
	0x002416c6, // n0x07aa c0x0000 (---------------)  + I presse
	0x00306f4f, // n0x07ab c0x0000 (---------------)  + I xn--aroport-bya
	0x006f6783, // n0x07ac c0x0001 (---------------)  ! I www
	0x000f4e08, // n0x07ad c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x07ae c0x0000 (---------------)  + I co
	0x00210ec3, // n0x07af c0x0000 (---------------)  + I gob
	0x00264783, // n0x07b0 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x07b1 c0x0000 (---------------)  + I mil
	0x00203dc2, // n0x07b2 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x07b3 c0x0000 (---------------)  + I com
	0x00264783, // n0x07b4 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x07b5 c0x0000 (---------------)  + I net
	0x00203982, // n0x07b6 c0x0000 (---------------)  + I ac
	0x00209982, // n0x07b7 c0x0000 (---------------)  + I ah
	0x0e6eae09, // n0x07b8 c0x0039 (n0x07e3-n0x07e4)  o I amazonaws
	0x00207642, // n0x07b9 c0x0000 (---------------)  + I bj
	0x0ee2d0c3, // n0x07ba c0x003b (n0x07e5-n0x07e6)  + I com
	0x0023d182, // n0x07bb c0x0000 (---------------)  + I cq
	0x002325c3, // n0x07bc c0x0000 (---------------)  + I edu
	0x00215242, // n0x07bd c0x0000 (---------------)  + I fj
	0x00221d82, // n0x07be c0x0000 (---------------)  + I gd
	0x00264783, // n0x07bf c0x0000 (---------------)  + I gov
	0x0028fbc2, // n0x07c0 c0x0000 (---------------)  + I gs
	0x002f6f82, // n0x07c1 c0x0000 (---------------)  + I gx
	0x00359ec2, // n0x07c2 c0x0000 (---------------)  + I gz
	0x00202f42, // n0x07c3 c0x0000 (---------------)  + I ha
	0x00285f82, // n0x07c4 c0x0000 (---------------)  + I hb
	0x00208402, // n0x07c5 c0x0000 (---------------)  + I he
	0x002009c2, // n0x07c6 c0x0000 (---------------)  + I hi
	0x0020f882, // n0x07c7 c0x0000 (---------------)  + I hk
	0x0024e142, // n0x07c8 c0x0000 (---------------)  + I hl
	0x002168c2, // n0x07c9 c0x0000 (---------------)  + I hn
	0x002a6e02, // n0x07ca c0x0000 (---------------)  + I jl
	0x0022b142, // n0x07cb c0x0000 (---------------)  + I js
	0x00231f02, // n0x07cc c0x0000 (---------------)  + I jx
	0x00224942, // n0x07cd c0x0000 (---------------)  + I ln
	0x00214d03, // n0x07ce c0x0000 (---------------)  + I mil
	0x00207c82, // n0x07cf c0x0000 (---------------)  + I mo
	0x0021e283, // n0x07d0 c0x0000 (---------------)  + I net
	0x002354c2, // n0x07d1 c0x0000 (---------------)  + I nm
	0x002623c2, // n0x07d2 c0x0000 (---------------)  + I nx
	0x00223a43, // n0x07d3 c0x0000 (---------------)  + I org
	0x00247e02, // n0x07d4 c0x0000 (---------------)  + I qh
	0x00213402, // n0x07d5 c0x0000 (---------------)  + I sc
	0x00256cc2, // n0x07d6 c0x0000 (---------------)  + I sd
	0x00202802, // n0x07d7 c0x0000 (---------------)  + I sh
	0x0020ce82, // n0x07d8 c0x0000 (---------------)  + I sn
	0x002e6902, // n0x07d9 c0x0000 (---------------)  + I sx
	0x00231ec2, // n0x07da c0x0000 (---------------)  + I tj
	0x00242e02, // n0x07db c0x0000 (---------------)  + I tw
	0x002b0b82, // n0x07dc c0x0000 (---------------)  + I xj
	0x002f8f8a, // n0x07dd c0x0000 (---------------)  + I xn--55qx5d
	0x0033fc0a, // n0x07de c0x0000 (---------------)  + I xn--io0a7i
	0x003700ca, // n0x07df c0x0000 (---------------)  + I xn--od0alg
	0x003a5302, // n0x07e0 c0x0000 (---------------)  + I xz
	0x0021f042, // n0x07e1 c0x0000 (---------------)  + I yn
	0x00234d82, // n0x07e2 c0x0000 (---------------)  + I zj
	0x0e82eb87, // n0x07e3 c0x003a (n0x07e4-n0x07e5)  +   compute
	0x0019b70a, // n0x07e4 c0x0000 (---------------)  +   cn-north-1
	0x0f2eae09, // n0x07e5 c0x003c (n0x07e6-n0x07e7)  o I amazonaws
	0x0f79b70a, // n0x07e6 c0x003d (n0x07e7-n0x07e8)  o I cn-north-1
	0x00026642, // n0x07e7 c0x0000 (---------------)  +   s3
	0x00244d04, // n0x07e8 c0x0000 (---------------)  + I arts
	0x0fe2d0c3, // n0x07e9 c0x003f (n0x07f5-n0x07f6)  + I com
	0x002325c3, // n0x07ea c0x0000 (---------------)  + I edu
	0x00246bc4, // n0x07eb c0x0000 (---------------)  + I firm
	0x00264783, // n0x07ec c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x07ed c0x0000 (---------------)  + I info
	0x00267a43, // n0x07ee c0x0000 (---------------)  + I int
	0x00214d03, // n0x07ef c0x0000 (---------------)  + I mil
	0x0021e283, // n0x07f0 c0x0000 (---------------)  + I net
	0x0020f543, // n0x07f1 c0x0000 (---------------)  + I nom
	0x00223a43, // n0x07f2 c0x0000 (---------------)  + I org
	0x00226e03, // n0x07f3 c0x0000 (---------------)  + I rec
	0x002292c3, // n0x07f4 c0x0000 (---------------)  + I web
	0x000f4e08, // n0x07f5 c0x0000 (---------------)  +   blogspot
	0x00119d45, // n0x07f6 c0x0000 (---------------)  +   1kapp
	0x001014c2, // n0x07f7 c0x0000 (---------------)  +   4u
	0x00169cc6, // n0x07f8 c0x0000 (---------------)  +   africa
	0x106eae09, // n0x07f9 c0x0041 (n0x08c6-n0x08d8)  o I amazonaws
	0x00101dc7, // n0x07fa c0x0000 (---------------)  +   appspot
	0x00002942, // n0x07fb c0x0000 (---------------)  +   ar
	0x0019330a, // n0x07fc c0x0000 (---------------)  +   betainabox
	0x00025387, // n0x07fd c0x0000 (---------------)  +   blogdns
	0x000f4e08, // n0x07fe c0x0000 (---------------)  +   blogspot
	0x0001ac42, // n0x07ff c0x0000 (---------------)  +   br
	0x0013cc07, // n0x0800 c0x0000 (---------------)  +   cechire
	0x0017abcf, // n0x0801 c0x0000 (---------------)  +   cloudcontrolapp
	0x000d5e0f, // n0x0802 c0x0000 (---------------)  +   cloudcontrolled
	0x00019ec2, // n0x0803 c0x0000 (---------------)  +   cn
	0x00003dc2, // n0x0804 c0x0000 (---------------)  +   co
	0x00094408, // n0x0805 c0x0000 (---------------)  +   codespot
	0x00000402, // n0x0806 c0x0000 (---------------)  +   de
	0x001480c8, // n0x0807 c0x0000 (---------------)  +   dnsalias
	0x000749c7, // n0x0808 c0x0000 (---------------)  +   dnsdojo
	0x0000cdcb, // n0x0809 c0x0000 (---------------)  +   doesntexist
	0x00165b89, // n0x080a c0x0000 (---------------)  +   dontexist
	0x00147fc7, // n0x080b c0x0000 (---------------)  +   doomdns
	0x000e8b4c, // n0x080c c0x0000 (---------------)  +   dreamhosters
	0x001a2cc7, // n0x080d c0x0000 (---------------)  +   dsmynas
	0x0011eb8a, // n0x080e c0x0000 (---------------)  +   dyn-o-saur
	0x00189b08, // n0x080f c0x0000 (---------------)  +   dynalias
	0x0006cb0e, // n0x0810 c0x0000 (---------------)  +   dyndns-at-home
	0x000d35ce, // n0x0811 c0x0000 (---------------)  +   dyndns-at-work
	0x000251cb, // n0x0812 c0x0000 (---------------)  +   dyndns-blog
	0x000e02cb, // n0x0813 c0x0000 (---------------)  +   dyndns-free
	0x00020b0b, // n0x0814 c0x0000 (---------------)  +   dyndns-home
	0x00023d49, // n0x0815 c0x0000 (---------------)  +   dyndns-ip
	0x00024d0b, // n0x0816 c0x0000 (---------------)  +   dyndns-mail
	0x00028d8d, // n0x0817 c0x0000 (---------------)  +   dyndns-office
	0x00173acb, // n0x0818 c0x0000 (---------------)  +   dyndns-pics
	0x00064bcd, // n0x0819 c0x0000 (---------------)  +   dyndns-remote
	0x0019fc0d, // n0x081a c0x0000 (---------------)  +   dyndns-server
	0x0010b58a, // n0x081b c0x0000 (---------------)  +   dyndns-web
	0x0012c20b, // n0x081c c0x0000 (---------------)  +   dyndns-wiki
	0x0018248b, // n0x081d c0x0000 (---------------)  +   dyndns-work
	0x0001d890, // n0x081e c0x0000 (---------------)  +   elasticbeanstalk
	0x000058cf, // n0x081f c0x0000 (---------------)  +   est-a-la-maison
	0x0013024f, // n0x0820 c0x0000 (---------------)  +   est-a-la-masion
	0x00167bcd, // n0x0821 c0x0000 (---------------)  +   est-le-patron
	0x00077890, // n0x0822 c0x0000 (---------------)  +   est-mon-blogueur
	0x00025c02, // n0x0823 c0x0000 (---------------)  +   eu
	0x001a2b48, // n0x0824 c0x0000 (---------------)  +   familyds
	0x000454cb, // n0x0825 c0x0000 (---------------)  +   firebaseapp
	0x0004d548, // n0x0826 c0x0000 (---------------)  +   flynnhub
	0x0005b107, // n0x0827 c0x0000 (---------------)  +   from-ak
	0x0005b447, // n0x0828 c0x0000 (---------------)  +   from-al
	0x0005b607, // n0x0829 c0x0000 (---------------)  +   from-ar
	0x0005bb87, // n0x082a c0x0000 (---------------)  +   from-ca
	0x0005d447, // n0x082b c0x0000 (---------------)  +   from-ct
	0x0005da47, // n0x082c c0x0000 (---------------)  +   from-dc
	0x0005e1c7, // n0x082d c0x0000 (---------------)  +   from-de
	0x0005e707, // n0x082e c0x0000 (---------------)  +   from-fl
	0x0005f747, // n0x082f c0x0000 (---------------)  +   from-ga
	0x0005fac7, // n0x0830 c0x0000 (---------------)  +   from-hi
	0x00060a07, // n0x0831 c0x0000 (---------------)  +   from-ia
	0x00060bc7, // n0x0832 c0x0000 (---------------)  +   from-id
	0x00060d87, // n0x0833 c0x0000 (---------------)  +   from-il
	0x00060f47, // n0x0834 c0x0000 (---------------)  +   from-in
	0x00061247, // n0x0835 c0x0000 (---------------)  +   from-ks
	0x00061647, // n0x0836 c0x0000 (---------------)  +   from-ky
	0x00062207, // n0x0837 c0x0000 (---------------)  +   from-ma
	0x000626c7, // n0x0838 c0x0000 (---------------)  +   from-md
	0x00062c47, // n0x0839 c0x0000 (---------------)  +   from-mi
	0x000639c7, // n0x083a c0x0000 (---------------)  +   from-mn
	0x00063b87, // n0x083b c0x0000 (---------------)  +   from-mo
	0x00063e87, // n0x083c c0x0000 (---------------)  +   from-ms
	0x00064287, // n0x083d c0x0000 (---------------)  +   from-mt
	0x00064487, // n0x083e c0x0000 (---------------)  +   from-nc
	0x00065287, // n0x083f c0x0000 (---------------)  +   from-nd
	0x00065447, // n0x0840 c0x0000 (---------------)  +   from-ne
	0x00065847, // n0x0841 c0x0000 (---------------)  +   from-nh
	0x00065f87, // n0x0842 c0x0000 (---------------)  +   from-nj
	0x00066487, // n0x0843 c0x0000 (---------------)  +   from-nm
	0x00066b07, // n0x0844 c0x0000 (---------------)  +   from-nv
	0x00067e47, // n0x0845 c0x0000 (---------------)  +   from-oh
	0x00068107, // n0x0846 c0x0000 (---------------)  +   from-ok
	0x00068487, // n0x0847 c0x0000 (---------------)  +   from-or
	0x00068647, // n0x0848 c0x0000 (---------------)  +   from-pa
	0x000689c7, // n0x0849 c0x0000 (---------------)  +   from-pr
	0x00069087, // n0x084a c0x0000 (---------------)  +   from-ri
	0x00069607, // n0x084b c0x0000 (---------------)  +   from-sc
	0x00069a07, // n0x084c c0x0000 (---------------)  +   from-sd
	0x0006be87, // n0x084d c0x0000 (---------------)  +   from-tn
	0x0006c047, // n0x084e c0x0000 (---------------)  +   from-tx
	0x0006c487, // n0x084f c0x0000 (---------------)  +   from-ut
	0x0006de07, // n0x0850 c0x0000 (---------------)  +   from-va
	0x0006e447, // n0x0851 c0x0000 (---------------)  +   from-vt
	0x0006e747, // n0x0852 c0x0000 (---------------)  +   from-wa
	0x0006e907, // n0x0853 c0x0000 (---------------)  +   from-wi
	0x0006ec87, // n0x0854 c0x0000 (---------------)  +   from-wv
	0x0006f487, // n0x0855 c0x0000 (---------------)  +   from-wy
	0x0000a482, // n0x0856 c0x0000 (---------------)  +   gb
	0x000ce8c7, // n0x0857 c0x0000 (---------------)  +   getmyip
	0x000c5e11, // n0x0858 c0x0000 (---------------)  +   githubusercontent
	0x000d818a, // n0x0859 c0x0000 (---------------)  +   googleapis
	0x0009428a, // n0x085a c0x0000 (---------------)  +   googlecode
	0x00051786, // n0x085b c0x0000 (---------------)  +   gotdns
	0x0001228b, // n0x085c c0x0000 (---------------)  +   gotpantheon
	0x000008c2, // n0x085d c0x0000 (---------------)  +   gr
	0x00095009, // n0x085e c0x0000 (---------------)  +   herokuapp
	0x0008c049, // n0x085f c0x0000 (---------------)  +   herokussl
	0x0000f882, // n0x0860 c0x0000 (---------------)  +   hk
	0x0014904a, // n0x0861 c0x0000 (---------------)  +   hobby-site
	0x0009f749, // n0x0862 c0x0000 (---------------)  +   homelinux
	0x000a0bc8, // n0x0863 c0x0000 (---------------)  +   homeunix
	0x00022f82, // n0x0864 c0x0000 (---------------)  +   hu
	0x00110489, // n0x0865 c0x0000 (---------------)  +   iamallama
	0x0015a6ce, // n0x0866 c0x0000 (---------------)  +   is-a-anarchist
	0x0009f44c, // n0x0867 c0x0000 (---------------)  +   is-a-blogger
	0x000ccfcf, // n0x0868 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0018490e, // n0x0869 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0001044c, // n0x086a c0x0000 (---------------)  +   is-a-caterer
	0x00011709, // n0x086b c0x0000 (---------------)  +   is-a-chef
	0x00015711, // n0x086c c0x0000 (---------------)  +   is-a-conservative
	0x000170c8, // n0x086d c0x0000 (---------------)  +   is-a-cpa
	0x0001f6d2, // n0x086e c0x0000 (---------------)  +   is-a-cubicle-slave
	0x00022b8d, // n0x086f c0x0000 (---------------)  +   is-a-democrat
	0x0002888d, // n0x0870 c0x0000 (---------------)  +   is-a-designer
	0x00075acb, // n0x0871 c0x0000 (---------------)  +   is-a-doctor
	0x00167395, // n0x0872 c0x0000 (---------------)  +   is-a-financialadvisor
	0x00043289, // n0x0873 c0x0000 (---------------)  +   is-a-geek
	0x00047a0a, // n0x0874 c0x0000 (---------------)  +   is-a-green
	0x0004adc9, // n0x0875 c0x0000 (---------------)  +   is-a-guru
	0x00054ed0, // n0x0876 c0x0000 (---------------)  +   is-a-hard-worker
	0x0005d78b, // n0x0877 c0x0000 (---------------)  +   is-a-hunter
	0x0005f28f, // n0x0878 c0x0000 (---------------)  +   is-a-landscaper
	0x0006684b, // n0x0879 c0x0000 (---------------)  +   is-a-lawyer
	0x00068d8c, // n0x087a c0x0000 (---------------)  +   is-a-liberal
	0x00069210, // n0x087b c0x0000 (---------------)  +   is-a-libertarian
	0x00075f0a, // n0x087c c0x0000 (---------------)  +   is-a-llama
	0x0007688d, // n0x087d c0x0000 (---------------)  +   is-a-musician
	0x0007c98e, // n0x087e c0x0000 (---------------)  +   is-a-nascarfan
	0x0008374a, // n0x087f c0x0000 (---------------)  +   is-a-nurse
	0x0013238c, // n0x0880 c0x0000 (---------------)  +   is-a-painter
	0x00091414, // n0x0881 c0x0000 (---------------)  +   is-a-personaltrainer
	0x00094c91, // n0x0882 c0x0000 (---------------)  +   is-a-photographer
	0x0009530b, // n0x0883 c0x0000 (---------------)  +   is-a-player
	0x00097bcf, // n0x0884 c0x0000 (---------------)  +   is-a-republican
	0x0009ad0d, // n0x0885 c0x0000 (---------------)  +   is-a-rockstar
	0x0009edce, // n0x0886 c0x0000 (---------------)  +   is-a-socialist
	0x000a4e0c, // n0x0887 c0x0000 (---------------)  +   is-a-student
	0x000a54cc, // n0x0888 c0x0000 (---------------)  +   is-a-teacher
	0x000a600b, // n0x0889 c0x0000 (---------------)  +   is-a-techie
	0x000a630e, // n0x088a c0x0000 (---------------)  +   is-a-therapist
	0x000b5f90, // n0x088b c0x0000 (---------------)  +   is-an-accountant
	0x0014a0cb, // n0x088c c0x0000 (---------------)  +   is-an-actor
	0x000ed70d, // n0x088d c0x0000 (---------------)  +   is-an-actress
	0x00153d8f, // n0x088e c0x0000 (---------------)  +   is-an-anarchist
	0x000fac8c, // n0x088f c0x0000 (---------------)  +   is-an-artist
	0x00164b4e, // n0x0890 c0x0000 (---------------)  +   is-an-engineer
	0x000a9ad1, // n0x0891 c0x0000 (---------------)  +   is-an-entertainer
	0x000b350c, // n0x0892 c0x0000 (---------------)  +   is-certified
	0x000b4847, // n0x0893 c0x0000 (---------------)  +   is-gone
	0x000b59cd, // n0x0894 c0x0000 (---------------)  +   is-into-anime
	0x000d260c, // n0x0895 c0x0000 (---------------)  +   is-into-cars
	0x00112a10, // n0x0896 c0x0000 (---------------)  +   is-into-cartoons
	0x0014428d, // n0x0897 c0x0000 (---------------)  +   is-into-games
	0x000c9687, // n0x0898 c0x0000 (---------------)  +   is-leet
	0x00157490, // n0x0899 c0x0000 (---------------)  +   is-not-certified
	0x000e1c48, // n0x089a c0x0000 (---------------)  +   is-slick
	0x000e2e4b, // n0x089b c0x0000 (---------------)  +   is-uberleet
	0x00147c4f, // n0x089c c0x0000 (---------------)  +   is-with-theband
	0x000fdf48, // n0x089d c0x0000 (---------------)  +   isa-geek
	0x000d838d, // n0x089e c0x0000 (---------------)  +   isa-hockeynut
	0x00163c90, // n0x089f c0x0000 (---------------)  +   issmarterthanyou
	0x000a8c83, // n0x08a0 c0x0000 (---------------)  +   jpn
	0x00007b42, // n0x08a1 c0x0000 (---------------)  +   kr
	0x00052289, // n0x08a2 c0x0000 (---------------)  +   likes-pie
	0x0006c90a, // n0x08a3 c0x0000 (---------------)  +   likescandy
	0x00010003, // n0x08a4 c0x0000 (---------------)  +   mex
	0x00110bc8, // n0x08a5 c0x0000 (---------------)  +   neat-url
	0x0019c347, // n0x08a6 c0x0000 (---------------)  +   nfshost
	0x00000842, // n0x08a7 c0x0000 (---------------)  +   no
	0x00045d8a, // n0x08a8 c0x0000 (---------------)  +   operaunite
	0x0017a94f, // n0x08a9 c0x0000 (---------------)  +   outsystemscloud
	0x0013760c, // n0x08aa c0x0000 (---------------)  +   pagefrontapp
	0x001378d2, // n0x08ab c0x0000 (---------------)  +   pagespeedmobilizer
	0x0010da43, // n0x08ac c0x0000 (---------------)  +   qa2
	0x00175542, // n0x08ad c0x0000 (---------------)  +   qc
	0x001388c8, // n0x08ae c0x0000 (---------------)  +   rackmaze
	0x000d5d87, // n0x08af c0x0000 (---------------)  +   rhcloud
	0x00000f82, // n0x08b0 c0x0000 (---------------)  +   ro
	0x0000efc2, // n0x08b1 c0x0000 (---------------)  +   ru
	0x00000642, // n0x08b2 c0x0000 (---------------)  +   sa
	0x00133710, // n0x08b3 c0x0000 (---------------)  +   saves-the-whales
	0x00001242, // n0x08b4 c0x0000 (---------------)  +   se
	0x000636c6, // n0x08b5 c0x0000 (---------------)  +   selfip
	0x00040ace, // n0x08b6 c0x0000 (---------------)  +   sells-for-less
	0x00085b0b, // n0x08b7 c0x0000 (---------------)  +   sells-for-u
	0x000c7008, // n0x08b8 c0x0000 (---------------)  +   servebbs
	0x000c44ca, // n0x08b9 c0x0000 (---------------)  +   simple-url
	0x000ed047, // n0x08ba c0x0000 (---------------)  +   sinaapp
	0x000046cd, // n0x08bb c0x0000 (---------------)  +   space-to-rent
	0x000ffdcc, // n0x08bc c0x0000 (---------------)  +   teaches-yoga
	0x00000bc2, // n0x08bd c0x0000 (---------------)  +   uk
	0x00001102, // n0x08be c0x0000 (---------------)  +   us
	0x00002102, // n0x08bf c0x0000 (---------------)  +   uy
	0x000ecf8a, // n0x08c0 c0x0000 (---------------)  +   vipsinaapp
	0x000d808a, // n0x08c1 c0x0000 (---------------)  +   withgoogle
	0x000dddcb, // n0x08c2 c0x0000 (---------------)  +   withyoutube
	0x000f4b8e, // n0x08c3 c0x0000 (---------------)  +   writesthisblog
	0x000d0f08, // n0x08c4 c0x0000 (---------------)  +   yolasite
	0x0000a182, // n0x08c5 c0x0000 (---------------)  +   za
	0x1082eb87, // n0x08c6 c0x0042 (n0x08d8-n0x08e1)  +   compute
	0x10c2eb89, // n0x08c7 c0x0043 (n0x08e1-n0x08e3)  +   compute-1
	0x0000d643, // n0x08c8 c0x0000 (---------------)  +   elb
	0x1126bb8c, // n0x08c9 c0x0044 (n0x08e3-n0x08e4)  o I eu-central-1
	0x00026642, // n0x08ca c0x0000 (---------------)  +   s3
	0x0011a8d1, // n0x08cb c0x0000 (---------------)  +   s3-ap-northeast-1
	0x00126cd1, // n0x08cc c0x0000 (---------------)  +   s3-ap-southeast-1
	0x0004f251, // n0x08cd c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0006bacf, // n0x08ce c0x0000 (---------------)  +   s3-eu-central-1
	0x00195bcc, // n0x08cf c0x0000 (---------------)  +   s3-eu-west-1
	0x000d620d, // n0x08d0 c0x0000 (---------------)  +   s3-external-1
	0x00104c4d, // n0x08d1 c0x0000 (---------------)  +   s3-external-2
	0x00109c95, // n0x08d2 c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0011ef4c, // n0x08d3 c0x0000 (---------------)  +   s3-sa-east-1
	0x0015c250, // n0x08d4 c0x0000 (---------------)  +   s3-us-gov-west-1
	0x0002664c, // n0x08d5 c0x0000 (---------------)  +   s3-us-west-1
	0x000bc6cc, // n0x08d6 c0x0000 (---------------)  +   s3-us-west-2
	0x0011e1c9, // n0x08d7 c0x0000 (---------------)  +   us-east-1
	0x0011a98e, // n0x08d8 c0x0000 (---------------)  +   ap-northeast-1
	0x00126d8e, // n0x08d9 c0x0000 (---------------)  +   ap-southeast-1
	0x0004f30e, // n0x08da c0x0000 (---------------)  +   ap-southeast-2
	0x0006bb8c, // n0x08db c0x0000 (---------------)  +   eu-central-1
	0x00195c89, // n0x08dc c0x0000 (---------------)  +   eu-west-1
	0x0011f009, // n0x08dd c0x0000 (---------------)  +   sa-east-1
	0x00109e8d, // n0x08de c0x0000 (---------------)  +   us-gov-west-1
	0x00026709, // n0x08df c0x0000 (---------------)  +   us-west-1
	0x000bc789, // n0x08e0 c0x0000 (---------------)  +   us-west-2
	0x00119cc3, // n0x08e1 c0x0000 (---------------)  +   z-1
	0x00056a03, // n0x08e2 c0x0000 (---------------)  +   z-2
	0x00026642, // n0x08e3 c0x0000 (---------------)  +   s3
	0x00203982, // n0x08e4 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x08e5 c0x0000 (---------------)  + I co
	0x002003c2, // n0x08e6 c0x0000 (---------------)  + I ed
	0x00203a42, // n0x08e7 c0x0000 (---------------)  + I fi
	0x00200702, // n0x08e8 c0x0000 (---------------)  + I go
	0x00200282, // n0x08e9 c0x0000 (---------------)  + I or
	0x00200642, // n0x08ea c0x0000 (---------------)  + I sa
	0x0022d0c3, // n0x08eb c0x0000 (---------------)  + I com
	0x002325c3, // n0x08ec c0x0000 (---------------)  + I edu
	0x00264783, // n0x08ed c0x0000 (---------------)  + I gov
	0x003a4dc3, // n0x08ee c0x0000 (---------------)  + I inf
	0x0021e283, // n0x08ef c0x0000 (---------------)  + I net
	0x00223a43, // n0x08f0 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x08f1 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x08f2 c0x0000 (---------------)  + I com
	0x002325c3, // n0x08f3 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08f4 c0x0000 (---------------)  + I net
	0x00223a43, // n0x08f5 c0x0000 (---------------)  + I org
	0x0004e0c3, // n0x08f6 c0x0000 (---------------)  +   ath
	0x00264783, // n0x08f7 c0x0000 (---------------)  + I gov
	0x00203982, // n0x08f8 c0x0000 (---------------)  + I ac
	0x00325b83, // n0x08f9 c0x0000 (---------------)  + I biz
	0x12e2d0c3, // n0x08fa c0x004b (n0x0905-n0x0906)  + I com
	0x0027ea87, // n0x08fb c0x0000 (---------------)  + I ekloges
	0x00264783, // n0x08fc c0x0000 (---------------)  + I gov
	0x00314403, // n0x08fd c0x0000 (---------------)  + I ltd
	0x0020ff84, // n0x08fe c0x0000 (---------------)  + I name
	0x0021e283, // n0x08ff c0x0000 (---------------)  + I net
	0x00223a43, // n0x0900 c0x0000 (---------------)  + I org
	0x0026f0ca, // n0x0901 c0x0000 (---------------)  + I parliament
	0x002416c5, // n0x0902 c0x0000 (---------------)  + I press
	0x00220443, // n0x0903 c0x0000 (---------------)  + I pro
	0x00200142, // n0x0904 c0x0000 (---------------)  + I tm
	0x000f4e08, // n0x0905 c0x0000 (---------------)  +   blogspot
	0x000f4e08, // n0x0906 c0x0000 (---------------)  +   blogspot
	0x000f4e08, // n0x0907 c0x0000 (---------------)  +   blogspot
	0x0002d0c3, // n0x0908 c0x0000 (---------------)  +   com
	0x000edb8f, // n0x0909 c0x0000 (---------------)  +   fuettertdasnetz
	0x00165d0a, // n0x090a c0x0000 (---------------)  +   isteingeek
	0x0009f087, // n0x090b c0x0000 (---------------)  +   istmein
	0x0001e10a, // n0x090c c0x0000 (---------------)  +   lebtimnetz
	0x0008fa4a, // n0x090d c0x0000 (---------------)  +   leitungsen
	0x0012bb8d, // n0x090e c0x0000 (---------------)  +   traeumtgerade
	0x000f4e08, // n0x090f c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x0910 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0911 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0912 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0913 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0914 c0x0000 (---------------)  + I org
	0x00203b03, // n0x0915 c0x0000 (---------------)  + I art
	0x0022d0c3, // n0x0916 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0917 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x0918 c0x0000 (---------------)  + I gob
	0x00264783, // n0x0919 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x091a c0x0000 (---------------)  + I mil
	0x0021e283, // n0x091b c0x0000 (---------------)  + I net
	0x00223a43, // n0x091c c0x0000 (---------------)  + I org
	0x0028c203, // n0x091d c0x0000 (---------------)  + I sld
	0x002292c3, // n0x091e c0x0000 (---------------)  + I web
	0x00203b03, // n0x091f c0x0000 (---------------)  + I art
	0x002c7fc4, // n0x0920 c0x0000 (---------------)  + I asso
	0x0022d0c3, // n0x0921 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0922 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0923 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x0924 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0925 c0x0000 (---------------)  + I org
	0x002200c3, // n0x0926 c0x0000 (---------------)  + I pol
	0x0022d0c3, // n0x0927 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0928 c0x0000 (---------------)  + I edu
	0x00208543, // n0x0929 c0x0000 (---------------)  + I fin
	0x00210ec3, // n0x092a c0x0000 (---------------)  + I gob
	0x00264783, // n0x092b c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x092c c0x0000 (---------------)  + I info
	0x00369643, // n0x092d c0x0000 (---------------)  + I k12
	0x00220d43, // n0x092e c0x0000 (---------------)  + I med
	0x00214d03, // n0x092f c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0930 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0931 c0x0000 (---------------)  + I org
	0x00220443, // n0x0932 c0x0000 (---------------)  + I pro
	0x003a1e83, // n0x0933 c0x0000 (---------------)  + I aip
	0x1522d0c3, // n0x0934 c0x0054 (n0x093d-n0x093e)  + I com
	0x002325c3, // n0x0935 c0x0000 (---------------)  + I edu
	0x002b3703, // n0x0936 c0x0000 (---------------)  + I fie
	0x00264783, // n0x0937 c0x0000 (---------------)  + I gov
	0x00268ec3, // n0x0938 c0x0000 (---------------)  + I lib
	0x00220d43, // n0x0939 c0x0000 (---------------)  + I med
	0x00223a43, // n0x093a c0x0000 (---------------)  + I org
	0x002052c3, // n0x093b c0x0000 (---------------)  + I pri
	0x00317c84, // n0x093c c0x0000 (---------------)  + I riik
	0x000f4e08, // n0x093d c0x0000 (---------------)  +   blogspot
	0x15a2d0c3, // n0x093e c0x0056 (n0x0947-n0x0948)  + I com
	0x002325c3, // n0x093f c0x0000 (---------------)  + I edu
	0x002a0c83, // n0x0940 c0x0000 (---------------)  + I eun
	0x00264783, // n0x0941 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0942 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x0943 c0x0000 (---------------)  + I name
	0x0021e283, // n0x0944 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0945 c0x0000 (---------------)  + I org
	0x0021c783, // n0x0946 c0x0000 (---------------)  + I sci
	0x000f4e08, // n0x0947 c0x0000 (---------------)  +   blogspot
	0x1622d0c3, // n0x0948 c0x0058 (n0x094d-n0x094e)  + I com
	0x002325c3, // n0x0949 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x094a c0x0000 (---------------)  + I gob
	0x0020f543, // n0x094b c0x0000 (---------------)  + I nom
	0x00223a43, // n0x094c c0x0000 (---------------)  + I org
	0x000f4e08, // n0x094d c0x0000 (---------------)  +   blogspot
	0x00325b83, // n0x094e c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x094f c0x0000 (---------------)  + I com
	0x002325c3, // n0x0950 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0951 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x0952 c0x0000 (---------------)  + I info
	0x0020ff84, // n0x0953 c0x0000 (---------------)  + I name
	0x0021e283, // n0x0954 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0955 c0x0000 (---------------)  + I org
	0x0031dc85, // n0x0956 c0x0000 (---------------)  + I aland
	0x000f4e08, // n0x0957 c0x0000 (---------------)  +   blogspot
	0x00002003, // n0x0958 c0x0000 (---------------)  +   iki
	0x003381c8, // n0x0959 c0x0000 (---------------)  + I aeroport
	0x0034d747, // n0x095a c0x0000 (---------------)  + I assedic
	0x002c7fc4, // n0x095b c0x0000 (---------------)  + I asso
	0x003422c6, // n0x095c c0x0000 (---------------)  + I avocat
	0x0035c106, // n0x095d c0x0000 (---------------)  + I avoues
	0x000f4e08, // n0x095e c0x0000 (---------------)  +   blogspot
	0x00275503, // n0x095f c0x0000 (---------------)  + I cci
	0x002ff989, // n0x0960 c0x0000 (---------------)  + I chambagri
	0x002abfd5, // n0x0961 c0x0000 (---------------)  + I chirurgiens-dentistes
	0x0022d0c3, // n0x0962 c0x0000 (---------------)  + I com
	0x0031c112, // n0x0963 c0x0000 (---------------)  + I experts-comptables
	0x0031becf, // n0x0964 c0x0000 (---------------)  + I geometre-expert
	0x0034ec04, // n0x0965 c0x0000 (---------------)  + I gouv
	0x002183c5, // n0x0966 c0x0000 (---------------)  + I greta
	0x002e7b90, // n0x0967 c0x0000 (---------------)  + I huissier-justice
	0x0039a747, // n0x0968 c0x0000 (---------------)  + I medecin
	0x0020f543, // n0x0969 c0x0000 (---------------)  + I nom
	0x00241c88, // n0x096a c0x0000 (---------------)  + I notaires
	0x002ed1ca, // n0x096b c0x0000 (---------------)  + I pharmacien
	0x0023f444, // n0x096c c0x0000 (---------------)  + I port
	0x002d9d03, // n0x096d c0x0000 (---------------)  + I prd
	0x002416c6, // n0x096e c0x0000 (---------------)  + I presse
	0x00200142, // n0x096f c0x0000 (---------------)  + I tm
	0x0026af0b, // n0x0970 c0x0000 (---------------)  + I veterinaire
	0x0022d0c3, // n0x0971 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0972 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0973 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0974 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0975 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0976 c0x0000 (---------------)  + I org
	0x002de543, // n0x0977 c0x0000 (---------------)  + I pvt
	0x00203dc2, // n0x0978 c0x0000 (---------------)  + I co
	0x0021e283, // n0x0979 c0x0000 (---------------)  + I net
	0x00223a43, // n0x097a c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x097b c0x0000 (---------------)  + I com
	0x002325c3, // n0x097c c0x0000 (---------------)  + I edu
	0x00264783, // n0x097d c0x0000 (---------------)  + I gov
	0x00214d03, // n0x097e c0x0000 (---------------)  + I mil
	0x00223a43, // n0x097f c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x0980 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0981 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0982 c0x0000 (---------------)  + I gov
	0x00314403, // n0x0983 c0x0000 (---------------)  + I ltd
	0x00213943, // n0x0984 c0x0000 (---------------)  + I mod
	0x00223a43, // n0x0985 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x0986 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x0987 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0988 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x0989 c0x0000 (---------------)  + I net
	0x00223a43, // n0x098a c0x0000 (---------------)  + I org
	0x00203982, // n0x098b c0x0000 (---------------)  + I ac
	0x0022d0c3, // n0x098c c0x0000 (---------------)  + I com
	0x002325c3, // n0x098d c0x0000 (---------------)  + I edu
	0x00264783, // n0x098e c0x0000 (---------------)  + I gov
	0x0021e283, // n0x098f c0x0000 (---------------)  + I net
	0x00223a43, // n0x0990 c0x0000 (---------------)  + I org
	0x002c7fc4, // n0x0991 c0x0000 (---------------)  + I asso
	0x0022d0c3, // n0x0992 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0993 c0x0000 (---------------)  + I edu
	0x00207c84, // n0x0994 c0x0000 (---------------)  + I mobi
	0x0021e283, // n0x0995 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0996 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x0997 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x0998 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0999 c0x0000 (---------------)  + I edu
	0x00264783, // n0x099a c0x0000 (---------------)  + I gov
	0x0021e283, // n0x099b c0x0000 (---------------)  + I net
	0x00223a43, // n0x099c c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x099d c0x0000 (---------------)  + I com
	0x002325c3, // n0x099e c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x099f c0x0000 (---------------)  + I gob
	0x0021c903, // n0x09a0 c0x0000 (---------------)  + I ind
	0x00214d03, // n0x09a1 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x09a2 c0x0000 (---------------)  + I net
	0x00223a43, // n0x09a3 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x09a4 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x09a5 c0x0000 (---------------)  + I com
	0x0021e283, // n0x09a6 c0x0000 (---------------)  + I net
	0x000f4e08, // n0x09a7 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x09a8 c0x0000 (---------------)  + I com
	0x002325c3, // n0x09a9 c0x0000 (---------------)  + I edu
	0x00264783, // n0x09aa c0x0000 (---------------)  + I gov
	0x00310743, // n0x09ab c0x0000 (---------------)  + I idv
	0x00038f83, // n0x09ac c0x0000 (---------------)  +   inc
	0x00114403, // n0x09ad c0x0000 (---------------)  +   ltd
	0x0021e283, // n0x09ae c0x0000 (---------------)  + I net
	0x00223a43, // n0x09af c0x0000 (---------------)  + I org
	0x002f8f8a, // n0x09b0 c0x0000 (---------------)  + I xn--55qx5d
	0x00315609, // n0x09b1 c0x0000 (---------------)  + I xn--ciqpn
	0x0033100b, // n0x09b2 c0x0000 (---------------)  + I xn--gmq050i
	0x0033158a, // n0x09b3 c0x0000 (---------------)  + I xn--gmqw5a
	0x0033fc0a, // n0x09b4 c0x0000 (---------------)  + I xn--io0a7i
	0x0035000b, // n0x09b5 c0x0000 (---------------)  + I xn--lcvr32d
	0x003625ca, // n0x09b6 c0x0000 (---------------)  + I xn--mk0axi
	0x0036b2ca, // n0x09b7 c0x0000 (---------------)  + I xn--mxtq1m
	0x003700ca, // n0x09b8 c0x0000 (---------------)  + I xn--od0alg
	0x0037034b, // n0x09b9 c0x0000 (---------------)  + I xn--od0aq3b
	0x0038bb49, // n0x09ba c0x0000 (---------------)  + I xn--tn0ag
	0x0038e60a, // n0x09bb c0x0000 (---------------)  + I xn--uc0atv
	0x0038eb4b, // n0x09bc c0x0000 (---------------)  + I xn--uc0ay4a
	0x003993cb, // n0x09bd c0x0000 (---------------)  + I xn--wcvs22d
	0x003a104a, // n0x09be c0x0000 (---------------)  + I xn--zf0avx
	0x0022d0c3, // n0x09bf c0x0000 (---------------)  + I com
	0x002325c3, // n0x09c0 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x09c1 c0x0000 (---------------)  + I gob
	0x00214d03, // n0x09c2 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x09c3 c0x0000 (---------------)  + I net
	0x00223a43, // n0x09c4 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x09c5 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x09c6 c0x0000 (---------------)  + I com
	0x0025b104, // n0x09c7 c0x0000 (---------------)  + I from
	0x00215502, // n0x09c8 c0x0000 (---------------)  + I iz
	0x0020ff84, // n0x09c9 c0x0000 (---------------)  + I name
	0x0029b705, // n0x09ca c0x0000 (---------------)  + I adult
	0x00203b03, // n0x09cb c0x0000 (---------------)  + I art
	0x002c7fc4, // n0x09cc c0x0000 (---------------)  + I asso
	0x0022d0c3, // n0x09cd c0x0000 (---------------)  + I com
	0x00235044, // n0x09ce c0x0000 (---------------)  + I coop
	0x002325c3, // n0x09cf c0x0000 (---------------)  + I edu
	0x00246bc4, // n0x09d0 c0x0000 (---------------)  + I firm
	0x0034ec04, // n0x09d1 c0x0000 (---------------)  + I gouv
	0x003a4f84, // n0x09d2 c0x0000 (---------------)  + I info
	0x00220d43, // n0x09d3 c0x0000 (---------------)  + I med
	0x0021e283, // n0x09d4 c0x0000 (---------------)  + I net
	0x00223a43, // n0x09d5 c0x0000 (---------------)  + I org
	0x00291545, // n0x09d6 c0x0000 (---------------)  + I perso
	0x002200c3, // n0x09d7 c0x0000 (---------------)  + I pol
	0x00220443, // n0x09d8 c0x0000 (---------------)  + I pro
	0x0027f083, // n0x09d9 c0x0000 (---------------)  + I rel
	0x00382744, // n0x09da c0x0000 (---------------)  + I shop
	0x0033a9c4, // n0x09db c0x0000 (---------------)  + I 2000
	0x0024a5c5, // n0x09dc c0x0000 (---------------)  + I agrar
	0x000f4e08, // n0x09dd c0x0000 (---------------)  +   blogspot
	0x0020c184, // n0x09de c0x0000 (---------------)  + I bolt
	0x00373446, // n0x09df c0x0000 (---------------)  + I casino
	0x002808c4, // n0x09e0 c0x0000 (---------------)  + I city
	0x00203dc2, // n0x09e1 c0x0000 (---------------)  + I co
	0x0032d087, // n0x09e2 c0x0000 (---------------)  + I erotica
	0x00249707, // n0x09e3 c0x0000 (---------------)  + I erotika
	0x00244544, // n0x09e4 c0x0000 (---------------)  + I film
	0x00254405, // n0x09e5 c0x0000 (---------------)  + I forum
	0x00344485, // n0x09e6 c0x0000 (---------------)  + I games
	0x0022de05, // n0x09e7 c0x0000 (---------------)  + I hotel
	0x003a4f84, // n0x09e8 c0x0000 (---------------)  + I info
	0x0033c508, // n0x09e9 c0x0000 (---------------)  + I ingatlan
	0x00289706, // n0x09ea c0x0000 (---------------)  + I jogasz
	0x002cc848, // n0x09eb c0x0000 (---------------)  + I konyvelo
	0x0022e3c5, // n0x09ec c0x0000 (---------------)  + I lakas
	0x003a15c5, // n0x09ed c0x0000 (---------------)  + I media
	0x00229684, // n0x09ee c0x0000 (---------------)  + I news
	0x00223a43, // n0x09ef c0x0000 (---------------)  + I org
	0x002da7c4, // n0x09f0 c0x0000 (---------------)  + I priv
	0x0034f1c6, // n0x09f1 c0x0000 (---------------)  + I reklam
	0x002417c3, // n0x09f2 c0x0000 (---------------)  + I sex
	0x00382744, // n0x09f3 c0x0000 (---------------)  + I shop
	0x002946c5, // n0x09f4 c0x0000 (---------------)  + I sport
	0x00233e84, // n0x09f5 c0x0000 (---------------)  + I suli
	0x00204504, // n0x09f6 c0x0000 (---------------)  + I szex
	0x00200142, // n0x09f7 c0x0000 (---------------)  + I tm
	0x0026e5c6, // n0x09f8 c0x0000 (---------------)  + I tozsde
	0x003813c6, // n0x09f9 c0x0000 (---------------)  + I utazas
	0x002ea085, // n0x09fa c0x0000 (---------------)  + I video
	0x00203982, // n0x09fb c0x0000 (---------------)  + I ac
	0x00325b83, // n0x09fc c0x0000 (---------------)  + I biz
	0x1b203dc2, // n0x09fd c0x006c (n0x0a06-n0x0a07)  + I co
	0x00233984, // n0x09fe c0x0000 (---------------)  + I desa
	0x00200702, // n0x09ff c0x0000 (---------------)  + I go
	0x00214d03, // n0x0a00 c0x0000 (---------------)  + I mil
	0x00265142, // n0x0a01 c0x0000 (---------------)  + I my
	0x0021e283, // n0x0a02 c0x0000 (---------------)  + I net
	0x00200282, // n0x0a03 c0x0000 (---------------)  + I or
	0x00213403, // n0x0a04 c0x0000 (---------------)  + I sch
	0x002292c3, // n0x0a05 c0x0000 (---------------)  + I web
	0x000f4e08, // n0x0a06 c0x0000 (---------------)  +   blogspot
	0x000f4e08, // n0x0a07 c0x0000 (---------------)  +   blogspot
	0x00264783, // n0x0a08 c0x0000 (---------------)  + I gov
	0x00203982, // n0x0a09 c0x0000 (---------------)  + I ac
	0x1be03dc2, // n0x0a0a c0x006f (n0x0a11-n0x0a12)  + I co
	0x00264783, // n0x0a0b c0x0000 (---------------)  + I gov
	0x00260d03, // n0x0a0c c0x0000 (---------------)  + I idf
	0x00369643, // n0x0a0d c0x0000 (---------------)  + I k12
	0x00227b44, // n0x0a0e c0x0000 (---------------)  + I muni
	0x0021e283, // n0x0a0f c0x0000 (---------------)  + I net
	0x00223a43, // n0x0a10 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x0a11 c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x0a12 c0x0000 (---------------)  + I ac
	0x1c603dc2, // n0x0a13 c0x0071 (n0x0a19-n0x0a1b)  + I co
	0x0022d0c3, // n0x0a14 c0x0000 (---------------)  + I com
	0x0021e283, // n0x0a15 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0a16 c0x0000 (---------------)  + I org
	0x0020b642, // n0x0a17 c0x0000 (---------------)  + I tt
	0x0020da42, // n0x0a18 c0x0000 (---------------)  + I tv
	0x00314403, // n0x0a19 c0x0000 (---------------)  + I ltd
	0x002d2f03, // n0x0a1a c0x0000 (---------------)  + I plc
	0x00203982, // n0x0a1b c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x0a1c c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x0a1d c0x0000 (---------------)  + I co
	0x002325c3, // n0x0a1e c0x0000 (---------------)  + I edu
	0x00246bc4, // n0x0a1f c0x0000 (---------------)  + I firm
	0x00206943, // n0x0a20 c0x0000 (---------------)  + I gen
	0x00264783, // n0x0a21 c0x0000 (---------------)  + I gov
	0x0021c903, // n0x0a22 c0x0000 (---------------)  + I ind
	0x00214d03, // n0x0a23 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0a24 c0x0000 (---------------)  + I net
	0x00217843, // n0x0a25 c0x0000 (---------------)  + I nic
	0x00223a43, // n0x0a26 c0x0000 (---------------)  + I org
	0x0021c703, // n0x0a27 c0x0000 (---------------)  + I res
	0x001172d3, // n0x0a28 c0x0000 (---------------)  +   barrel-of-knowledge
	0x0011ba54, // n0x0a29 c0x0000 (---------------)  +   barrell-of-knowledge
	0x00020b06, // n0x0a2a c0x0000 (---------------)  +   dyndns
	0x00050147, // n0x0a2b c0x0000 (---------------)  +   for-our
	0x00100309, // n0x0a2c c0x0000 (---------------)  +   groks-the
	0x0012614a, // n0x0a2d c0x0000 (---------------)  +   groks-this
	0x0008264d, // n0x0a2e c0x0000 (---------------)  +   here-for-more
	0x000ef30a, // n0x0a2f c0x0000 (---------------)  +   knowsitall
	0x000636c6, // n0x0a30 c0x0000 (---------------)  +   selfip
	0x001374c6, // n0x0a31 c0x0000 (---------------)  +   webhop
	0x00225c02, // n0x0a32 c0x0000 (---------------)  + I eu
	0x0022d0c3, // n0x0a33 c0x0000 (---------------)  + I com
	0x000c5e06, // n0x0a34 c0x0000 (---------------)  +   github
	0x001002c5, // n0x0a35 c0x0000 (---------------)  +   ngrok
	0x00008e43, // n0x0a36 c0x0000 (---------------)  +   nid
	0x00012348, // n0x0a37 c0x0000 (---------------)  +   pantheon
	0x000a97c8, // n0x0a38 c0x0000 (---------------)  +   sandcats
	0x0022d0c3, // n0x0a39 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0a3a c0x0000 (---------------)  + I edu
	0x00264783, // n0x0a3b c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0a3c c0x0000 (---------------)  + I mil
	0x0021e283, // n0x0a3d c0x0000 (---------------)  + I net
	0x00223a43, // n0x0a3e c0x0000 (---------------)  + I org
	0x00203982, // n0x0a3f c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x0a40 c0x0000 (---------------)  + I co
	0x00264783, // n0x0a41 c0x0000 (---------------)  + I gov
	0x00203782, // n0x0a42 c0x0000 (---------------)  + I id
	0x0021e283, // n0x0a43 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0a44 c0x0000 (---------------)  + I org
	0x00213403, // n0x0a45 c0x0000 (---------------)  + I sch
	0x0035808f, // n0x0a46 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035844e, // n0x0a47 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x000f4e08, // n0x0a48 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x0a49 c0x0000 (---------------)  + I com
	0x00042a87, // n0x0a4a c0x0000 (---------------)  +   cupcake
	0x002325c3, // n0x0a4b c0x0000 (---------------)  + I edu
	0x00264783, // n0x0a4c c0x0000 (---------------)  + I gov
	0x00267a43, // n0x0a4d c0x0000 (---------------)  + I int
	0x0021e283, // n0x0a4e c0x0000 (---------------)  + I net
	0x00223a43, // n0x0a4f c0x0000 (---------------)  + I org
	0x0021c683, // n0x0a50 c0x0000 (---------------)  + I abr
	0x00339b47, // n0x0a51 c0x0000 (---------------)  + I abruzzo
	0x00200c42, // n0x0a52 c0x0000 (---------------)  + I ag
	0x0038bd09, // n0x0a53 c0x0000 (---------------)  + I agrigento
	0x002001c2, // n0x0a54 c0x0000 (---------------)  + I al
	0x00333a0b, // n0x0a55 c0x0000 (---------------)  + I alessandria
	0x002dca8a, // n0x0a56 c0x0000 (---------------)  + I alto-adige
	0x002cccc9, // n0x0a57 c0x0000 (---------------)  + I altoadige
	0x00200682, // n0x0a58 c0x0000 (---------------)  + I an
	0x0034d1c6, // n0x0a59 c0x0000 (---------------)  + I ancona
	0x0039d355, // n0x0a5a c0x0000 (---------------)  + I andria-barletta-trani
	0x00333b55, // n0x0a5b c0x0000 (---------------)  + I andria-trani-barletta
	0x0028aa93, // n0x0a5c c0x0000 (---------------)  + I andriabarlettatrani
	0x003340d3, // n0x0a5d c0x0000 (---------------)  + I andriatranibarletta
	0x00201bc2, // n0x0a5e c0x0000 (---------------)  + I ao
	0x00217485, // n0x0a5f c0x0000 (---------------)  + I aosta
	0x00303e0c, // n0x0a60 c0x0000 (---------------)  + I aosta-valley
	0x0021748b, // n0x0a61 c0x0000 (---------------)  + I aostavalley
	0x0023ae45, // n0x0a62 c0x0000 (---------------)  + I aoste
	0x00200942, // n0x0a63 c0x0000 (---------------)  + I ap
	0x0027ef82, // n0x0a64 c0x0000 (---------------)  + I aq
	0x00368406, // n0x0a65 c0x0000 (---------------)  + I aquila
	0x00202942, // n0x0a66 c0x0000 (---------------)  + I ar
	0x003a32c6, // n0x0a67 c0x0000 (---------------)  + I arezzo
	0x00389c8d, // n0x0a68 c0x0000 (---------------)  + I ascoli-piceno
	0x0034824c, // n0x0a69 c0x0000 (---------------)  + I ascolipiceno
	0x0021d904, // n0x0a6a c0x0000 (---------------)  + I asti
	0x00200102, // n0x0a6b c0x0000 (---------------)  + I at
	0x00202f82, // n0x0a6c c0x0000 (---------------)  + I av
	0x0021fa88, // n0x0a6d c0x0000 (---------------)  + I avellino
	0x00201b82, // n0x0a6e c0x0000 (---------------)  + I ba
	0x0024d706, // n0x0a6f c0x0000 (---------------)  + I balsan
	0x0024e384, // n0x0a70 c0x0000 (---------------)  + I bari
	0x0039d515, // n0x0a71 c0x0000 (---------------)  + I barletta-trani-andria
	0x0028ac13, // n0x0a72 c0x0000 (---------------)  + I barlettatraniandria
	0x0020d583, // n0x0a73 c0x0000 (---------------)  + I bas
	0x003250ca, // n0x0a74 c0x0000 (---------------)  + I basilicata
	0x002fdc87, // n0x0a75 c0x0000 (---------------)  + I belluno
	0x0027f9c9, // n0x0a76 c0x0000 (---------------)  + I benevento
	0x00237c87, // n0x0a77 c0x0000 (---------------)  + I bergamo
	0x002fb3c2, // n0x0a78 c0x0000 (---------------)  + I bg
	0x00200002, // n0x0a79 c0x0000 (---------------)  + I bi
	0x003a0546, // n0x0a7a c0x0000 (---------------)  + I biella
	0x00208b82, // n0x0a7b c0x0000 (---------------)  + I bl
	0x000f4e08, // n0x0a7c c0x0000 (---------------)  +   blogspot
	0x0020d3c2, // n0x0a7d c0x0000 (---------------)  + I bn
	0x0020c182, // n0x0a7e c0x0000 (---------------)  + I bo
	0x0037b7c7, // n0x0a7f c0x0000 (---------------)  + I bologna
	0x0020e1c7, // n0x0a80 c0x0000 (---------------)  + I bolzano
	0x0021a945, // n0x0a81 c0x0000 (---------------)  + I bozen
	0x0021ac42, // n0x0a82 c0x0000 (---------------)  + I br
	0x0021c6c7, // n0x0a83 c0x0000 (---------------)  + I brescia
	0x0021c888, // n0x0a84 c0x0000 (---------------)  + I brindisi
	0x002a0ec2, // n0x0a85 c0x0000 (---------------)  + I bs
	0x0021e182, // n0x0a86 c0x0000 (---------------)  + I bt
	0x00229d02, // n0x0a87 c0x0000 (---------------)  + I bz
	0x00200302, // n0x0a88 c0x0000 (---------------)  + I ca
	0x00308188, // n0x0a89 c0x0000 (---------------)  + I cagliari
	0x002178c3, // n0x0a8a c0x0000 (---------------)  + I cal
	0x0024d348, // n0x0a8b c0x0000 (---------------)  + I calabria
	0x00232bcd, // n0x0a8c c0x0000 (---------------)  + I caltanissetta
	0x00229383, // n0x0a8d c0x0000 (---------------)  + I cam
	0x00310308, // n0x0a8e c0x0000 (---------------)  + I campania
	0x0023becf, // n0x0a8f c0x0000 (---------------)  + I campidano-medio
	0x0023c28e, // n0x0a90 c0x0000 (---------------)  + I campidanomedio
	0x0032c68a, // n0x0a91 c0x0000 (---------------)  + I campobasso
	0x002e4691, // n0x0a92 c0x0000 (---------------)  + I carbonia-iglesias
	0x002e4b10, // n0x0a93 c0x0000 (---------------)  + I carboniaiglesias
	0x002ad7cd, // n0x0a94 c0x0000 (---------------)  + I carrara-massa
	0x002adb0c, // n0x0a95 c0x0000 (---------------)  + I carraramassa
	0x00213fc7, // n0x0a96 c0x0000 (---------------)  + I caserta
	0x00325247, // n0x0a97 c0x0000 (---------------)  + I catania
	0x00342389, // n0x0a98 c0x0000 (---------------)  + I catanzaro
	0x0021da02, // n0x0a99 c0x0000 (---------------)  + I cb
	0x00200782, // n0x0a9a c0x0000 (---------------)  + I ce
	0x00251d4c, // n0x0a9b c0x0000 (---------------)  + I cesena-forli
	0x0025204b, // n0x0a9c c0x0000 (---------------)  + I cesenaforli
	0x00202302, // n0x0a9d c0x0000 (---------------)  + I ch
	0x002a61c6, // n0x0a9e c0x0000 (---------------)  + I chieti
	0x002039c2, // n0x0a9f c0x0000 (---------------)  + I ci
	0x0021f902, // n0x0aa0 c0x0000 (---------------)  + I cl
	0x00219ec2, // n0x0aa1 c0x0000 (---------------)  + I cn
	0x00203dc2, // n0x0aa2 c0x0000 (---------------)  + I co
	0x0022d844, // n0x0aa3 c0x0000 (---------------)  + I como
	0x0023b047, // n0x0aa4 c0x0000 (---------------)  + I cosenza
	0x0020ef82, // n0x0aa5 c0x0000 (---------------)  + I cr
	0x0023dfc7, // n0x0aa6 c0x0000 (---------------)  + I cremona
	0x0023f247, // n0x0aa7 c0x0000 (---------------)  + I crotone
	0x00211402, // n0x0aa8 c0x0000 (---------------)  + I cs
	0x0022f482, // n0x0aa9 c0x0000 (---------------)  + I ct
	0x00242945, // n0x0aaa c0x0000 (---------------)  + I cuneo
	0x00235182, // n0x0aab c0x0000 (---------------)  + I cz
	0x0025370e, // n0x0aac c0x0000 (---------------)  + I dell-ogliastra
	0x0025e30d, // n0x0aad c0x0000 (---------------)  + I dellogliastra
	0x002325c3, // n0x0aae c0x0000 (---------------)  + I edu
	0x003392ce, // n0x0aaf c0x0000 (---------------)  + I emilia-romagna
	0x0027d74d, // n0x0ab0 c0x0000 (---------------)  + I emiliaromagna
	0x00350e83, // n0x0ab1 c0x0000 (---------------)  + I emr
	0x00201dc2, // n0x0ab2 c0x0000 (---------------)  + I en
	0x00206b84, // n0x0ab3 c0x0000 (---------------)  + I enna
	0x00243f02, // n0x0ab4 c0x0000 (---------------)  + I fc
	0x00200382, // n0x0ab5 c0x0000 (---------------)  + I fe
	0x002d0905, // n0x0ab6 c0x0000 (---------------)  + I fermo
	0x002db0c7, // n0x0ab7 c0x0000 (---------------)  + I ferrara
	0x003476c2, // n0x0ab8 c0x0000 (---------------)  + I fg
	0x00203a42, // n0x0ab9 c0x0000 (---------------)  + I fi
	0x00246507, // n0x0aba c0x0000 (---------------)  + I firenze
	0x0024bd48, // n0x0abb c0x0000 (---------------)  + I florence
	0x0022c142, // n0x0abc c0x0000 (---------------)  + I fm
	0x003a5006, // n0x0abd c0x0000 (---------------)  + I foggia
	0x00251bcc, // n0x0abe c0x0000 (---------------)  + I forli-cesena
	0x00251f0b, // n0x0abf c0x0000 (---------------)  + I forlicesena
	0x00235842, // n0x0ac0 c0x0000 (---------------)  + I fr
	0x0025770f, // n0x0ac1 c0x0000 (---------------)  + I friuli-v-giulia
	0x00257ad0, // n0x0ac2 c0x0000 (---------------)  + I friuli-ve-giulia
	0x00257ecf, // n0x0ac3 c0x0000 (---------------)  + I friuli-vegiulia
	0x00258295, // n0x0ac4 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x002587d4, // n0x0ac5 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x00258cce, // n0x0ac6 c0x0000 (---------------)  + I friuli-vgiulia
	0x0025904e, // n0x0ac7 c0x0000 (---------------)  + I friuliv-giulia
	0x002593cf, // n0x0ac8 c0x0000 (---------------)  + I friulive-giulia
	0x0025978e, // n0x0ac9 c0x0000 (---------------)  + I friulivegiulia
	0x00259b14, // n0x0aca c0x0000 (---------------)  + I friulivenezia-giulia
	0x0025a013, // n0x0acb c0x0000 (---------------)  + I friuliveneziagiulia
	0x0025a4cd, // n0x0acc c0x0000 (---------------)  + I friulivgiulia
	0x0026f649, // n0x0acd c0x0000 (---------------)  + I frosinone
	0x00283603, // n0x0ace c0x0000 (---------------)  + I fvg
	0x002018c2, // n0x0acf c0x0000 (---------------)  + I ge
	0x00302b85, // n0x0ad0 c0x0000 (---------------)  + I genoa
	0x00206946, // n0x0ad1 c0x0000 (---------------)  + I genova
	0x00200702, // n0x0ad2 c0x0000 (---------------)  + I go
	0x00260847, // n0x0ad3 c0x0000 (---------------)  + I gorizia
	0x00264783, // n0x0ad4 c0x0000 (---------------)  + I gov
	0x002008c2, // n0x0ad5 c0x0000 (---------------)  + I gr
	0x002f9988, // n0x0ad6 c0x0000 (---------------)  + I grosseto
	0x002e48d1, // n0x0ad7 c0x0000 (---------------)  + I iglesias-carbonia
	0x002e4d10, // n0x0ad8 c0x0000 (---------------)  + I iglesiascarbonia
	0x00207c02, // n0x0ad9 c0x0000 (---------------)  + I im
	0x00367fc7, // n0x0ada c0x0000 (---------------)  + I imperia
	0x002011c2, // n0x0adb c0x0000 (---------------)  + I is
	0x002d4dc7, // n0x0adc c0x0000 (---------------)  + I isernia
	0x00207b42, // n0x0add c0x0000 (---------------)  + I kr
	0x002fefc9, // n0x0ade c0x0000 (---------------)  + I la-spezia
	0x003683c7, // n0x0adf c0x0000 (---------------)  + I laquila
	0x002519c8, // n0x0ae0 c0x0000 (---------------)  + I laspezia
	0x00222646, // n0x0ae1 c0x0000 (---------------)  + I latina
	0x002d2e03, // n0x0ae2 c0x0000 (---------------)  + I laz
	0x00336c85, // n0x0ae3 c0x0000 (---------------)  + I lazio
	0x00232842, // n0x0ae4 c0x0000 (---------------)  + I lc
	0x0020d1c2, // n0x0ae5 c0x0000 (---------------)  + I le
	0x003a0945, // n0x0ae6 c0x0000 (---------------)  + I lecce
	0x0021e4c5, // n0x0ae7 c0x0000 (---------------)  + I lecco
	0x00207d82, // n0x0ae8 c0x0000 (---------------)  + I li
	0x00233f03, // n0x0ae9 c0x0000 (---------------)  + I lig
	0x00233f07, // n0x0aea c0x0000 (---------------)  + I liguria
	0x0020e607, // n0x0aeb c0x0000 (---------------)  + I livorno
	0x00200242, // n0x0aec c0x0000 (---------------)  + I lo
	0x00253144, // n0x0aed c0x0000 (---------------)  + I lodi
	0x00212ac3, // n0x0aee c0x0000 (---------------)  + I lom
	0x002bf2c9, // n0x0aef c0x0000 (---------------)  + I lombardia
	0x002d3448, // n0x0af0 c0x0000 (---------------)  + I lombardy
	0x00200d82, // n0x0af1 c0x0000 (---------------)  + I lt
	0x00202ac2, // n0x0af2 c0x0000 (---------------)  + I lu
	0x002a8ac7, // n0x0af3 c0x0000 (---------------)  + I lucania
	0x002af985, // n0x0af4 c0x0000 (---------------)  + I lucca
	0x0030fe08, // n0x0af5 c0x0000 (---------------)  + I macerata
	0x0024b307, // n0x0af6 c0x0000 (---------------)  + I mantova
	0x00209b83, // n0x0af7 c0x0000 (---------------)  + I mar
	0x0027c046, // n0x0af8 c0x0000 (---------------)  + I marche
	0x002ad64d, // n0x0af9 c0x0000 (---------------)  + I massa-carrara
	0x002ad9cc, // n0x0afa c0x0000 (---------------)  + I massacarrara
	0x00248a06, // n0x0afb c0x0000 (---------------)  + I matera
	0x0020a382, // n0x0afc c0x0000 (---------------)  + I mb
	0x00218742, // n0x0afd c0x0000 (---------------)  + I mc
	0x00209502, // n0x0afe c0x0000 (---------------)  + I me
	0x0023bd4f, // n0x0aff c0x0000 (---------------)  + I medio-campidano
	0x0023c14e, // n0x0b00 c0x0000 (---------------)  + I mediocampidano
	0x00344507, // n0x0b01 c0x0000 (---------------)  + I messina
	0x00204142, // n0x0b02 c0x0000 (---------------)  + I mi
	0x002ebec5, // n0x0b03 c0x0000 (---------------)  + I milan
	0x002ebec6, // n0x0b04 c0x0000 (---------------)  + I milano
	0x0021e242, // n0x0b05 c0x0000 (---------------)  + I mn
	0x00207c82, // n0x0b06 c0x0000 (---------------)  + I mo
	0x00213946, // n0x0b07 c0x0000 (---------------)  + I modena
	0x002baac3, // n0x0b08 c0x0000 (---------------)  + I mol
	0x002d4d06, // n0x0b09 c0x0000 (---------------)  + I molise
	0x002bdec5, // n0x0b0a c0x0000 (---------------)  + I monza
	0x002bdecd, // n0x0b0b c0x0000 (---------------)  + I monza-brianza
	0x002be715, // n0x0b0c c0x0000 (---------------)  + I monza-e-della-brianza
	0x002beecc, // n0x0b0d c0x0000 (---------------)  + I monzabrianza
	0x002bfa0d, // n0x0b0e c0x0000 (---------------)  + I monzaebrianza
	0x002bfdd2, // n0x0b0f c0x0000 (---------------)  + I monzaedellabrianza
	0x0020bbc2, // n0x0b10 c0x0000 (---------------)  + I ms
	0x002643c2, // n0x0b11 c0x0000 (---------------)  + I mt
	0x00201f42, // n0x0b12 c0x0000 (---------------)  + I na
	0x0036ad46, // n0x0b13 c0x0000 (---------------)  + I naples
	0x0029f306, // n0x0b14 c0x0000 (---------------)  + I napoli
	0x00200842, // n0x0b15 c0x0000 (---------------)  + I no
	0x002069c6, // n0x0b16 c0x0000 (---------------)  + I novara
	0x002020c2, // n0x0b17 c0x0000 (---------------)  + I nu
	0x00393745, // n0x0b18 c0x0000 (---------------)  + I nuoro
	0x00200882, // n0x0b19 c0x0000 (---------------)  + I og
	0x00253849, // n0x0b1a c0x0000 (---------------)  + I ogliastra
	0x00266d0c, // n0x0b1b c0x0000 (---------------)  + I olbia-tempio
	0x0026704b, // n0x0b1c c0x0000 (---------------)  + I olbiatempio
	0x00200282, // n0x0b1d c0x0000 (---------------)  + I or
	0x0024c188, // n0x0b1e c0x0000 (---------------)  + I oristano
	0x00201502, // n0x0b1f c0x0000 (---------------)  + I ot
	0x00203942, // n0x0b20 c0x0000 (---------------)  + I pa
	0x00217246, // n0x0b21 c0x0000 (---------------)  + I padova
	0x0035cf05, // n0x0b22 c0x0000 (---------------)  + I padua
	0x0022a147, // n0x0b23 c0x0000 (---------------)  + I palermo
	0x00270a85, // n0x0b24 c0x0000 (---------------)  + I parma
	0x002cea45, // n0x0b25 c0x0000 (---------------)  + I pavia
	0x00242b02, // n0x0b26 c0x0000 (---------------)  + I pc
	0x00382842, // n0x0b27 c0x0000 (---------------)  + I pd
	0x002087c2, // n0x0b28 c0x0000 (---------------)  + I pe
	0x0025f587, // n0x0b29 c0x0000 (---------------)  + I perugia
	0x00226f0d, // n0x0b2a c0x0000 (---------------)  + I pesaro-urbino
	0x0022728c, // n0x0b2b c0x0000 (---------------)  + I pesarourbino
	0x00230747, // n0x0b2c c0x0000 (---------------)  + I pescara
	0x0026b902, // n0x0b2d c0x0000 (---------------)  + I pg
	0x00218302, // n0x0b2e c0x0000 (---------------)  + I pi
	0x0032b608, // n0x0b2f c0x0000 (---------------)  + I piacenza
	0x00252408, // n0x0b30 c0x0000 (---------------)  + I piedmont
	0x002cf7c8, // n0x0b31 c0x0000 (---------------)  + I piemonte
	0x002d8344, // n0x0b32 c0x0000 (---------------)  + I pisa
	0x002a6587, // n0x0b33 c0x0000 (---------------)  + I pistoia
	0x002d6703, // n0x0b34 c0x0000 (---------------)  + I pmn
	0x0026b702, // n0x0b35 c0x0000 (---------------)  + I pn
	0x00208f42, // n0x0b36 c0x0000 (---------------)  + I po
	0x002d8a09, // n0x0b37 c0x0000 (---------------)  + I pordenone
	0x00301ec7, // n0x0b38 c0x0000 (---------------)  + I potenza
	0x002052c2, // n0x0b39 c0x0000 (---------------)  + I pr
	0x00268b05, // n0x0b3a c0x0000 (---------------)  + I prato
	0x0026ae82, // n0x0b3b c0x0000 (---------------)  + I pt
	0x0022ec42, // n0x0b3c c0x0000 (---------------)  + I pu
	0x00271803, // n0x0b3d c0x0000 (---------------)  + I pug
	0x00271806, // n0x0b3e c0x0000 (---------------)  + I puglia
	0x002de542, // n0x0b3f c0x0000 (---------------)  + I pv
	0x002df1c2, // n0x0b40 c0x0000 (---------------)  + I pz
	0x00200482, // n0x0b41 c0x0000 (---------------)  + I ra
	0x00305646, // n0x0b42 c0x0000 (---------------)  + I ragusa
	0x00206ac7, // n0x0b43 c0x0000 (---------------)  + I ravenna
	0x002002c2, // n0x0b44 c0x0000 (---------------)  + I rc
	0x00204902, // n0x0b45 c0x0000 (---------------)  + I re
	0x0032dccf, // n0x0b46 c0x0000 (---------------)  + I reggio-calabria
	0x0033910d, // n0x0b47 c0x0000 (---------------)  + I reggio-emilia
	0x0024d1ce, // n0x0b48 c0x0000 (---------------)  + I reggiocalabria
	0x0027d5cc, // n0x0b49 c0x0000 (---------------)  + I reggioemilia
	0x0020a442, // n0x0b4a c0x0000 (---------------)  + I rg
	0x00205302, // n0x0b4b c0x0000 (---------------)  + I ri
	0x00222485, // n0x0b4c c0x0000 (---------------)  + I rieti
	0x002f6dc6, // n0x0b4d c0x0000 (---------------)  + I rimini
	0x002211c2, // n0x0b4e c0x0000 (---------------)  + I rm
	0x00208e02, // n0x0b4f c0x0000 (---------------)  + I rn
	0x00200f82, // n0x0b50 c0x0000 (---------------)  + I ro
	0x00227684, // n0x0b51 c0x0000 (---------------)  + I roma
	0x002dbf04, // n0x0b52 c0x0000 (---------------)  + I rome
	0x003297c6, // n0x0b53 c0x0000 (---------------)  + I rovigo
	0x00200642, // n0x0b54 c0x0000 (---------------)  + I sa
	0x0027e007, // n0x0b55 c0x0000 (---------------)  + I salerno
	0x0021a243, // n0x0b56 c0x0000 (---------------)  + I sar
	0x0021f288, // n0x0b57 c0x0000 (---------------)  + I sardegna
	0x00220688, // n0x0b58 c0x0000 (---------------)  + I sardinia
	0x00367207, // n0x0b59 c0x0000 (---------------)  + I sassari
	0x0036ac46, // n0x0b5a c0x0000 (---------------)  + I savona
	0x00209802, // n0x0b5b c0x0000 (---------------)  + I si
	0x00236d03, // n0x0b5c c0x0000 (---------------)  + I sic
	0x0036a147, // n0x0b5d c0x0000 (---------------)  + I sicilia
	0x00242086, // n0x0b5e c0x0000 (---------------)  + I sicily
	0x002b9605, // n0x0b5f c0x0000 (---------------)  + I siena
	0x0033f448, // n0x0b60 c0x0000 (---------------)  + I siracusa
	0x00205bc2, // n0x0b61 c0x0000 (---------------)  + I so
	0x00314947, // n0x0b62 c0x0000 (---------------)  + I sondrio
	0x002046c2, // n0x0b63 c0x0000 (---------------)  + I sp
	0x00329142, // n0x0b64 c0x0000 (---------------)  + I sr
	0x00201202, // n0x0b65 c0x0000 (---------------)  + I ss
	0x002c9f89, // n0x0b66 c0x0000 (---------------)  + I suedtirol
	0x00206ec2, // n0x0b67 c0x0000 (---------------)  + I sv
	0x00201542, // n0x0b68 c0x0000 (---------------)  + I ta
	0x002309c3, // n0x0b69 c0x0000 (---------------)  + I taa
	0x00369247, // n0x0b6a c0x0000 (---------------)  + I taranto
	0x00200dc2, // n0x0b6b c0x0000 (---------------)  + I te
	0x00266e8c, // n0x0b6c c0x0000 (---------------)  + I tempio-olbia
	0x0026718b, // n0x0b6d c0x0000 (---------------)  + I tempioolbia
	0x00248a86, // n0x0b6e c0x0000 (---------------)  + I teramo
	0x00208d85, // n0x0b6f c0x0000 (---------------)  + I terni
	0x0022a482, // n0x0b70 c0x0000 (---------------)  + I tn
	0x00203b82, // n0x0b71 c0x0000 (---------------)  + I to
	0x002ab806, // n0x0b72 c0x0000 (---------------)  + I torino
	0x00227ec3, // n0x0b73 c0x0000 (---------------)  + I tos
	0x00325447, // n0x0b74 c0x0000 (---------------)  + I toscana
	0x00212302, // n0x0b75 c0x0000 (---------------)  + I tp
	0x00202b82, // n0x0b76 c0x0000 (---------------)  + I tr
	0x0039d1d5, // n0x0b77 c0x0000 (---------------)  + I trani-andria-barletta
	0x00333d15, // n0x0b78 c0x0000 (---------------)  + I trani-barletta-andria
	0x0028a953, // n0x0b79 c0x0000 (---------------)  + I traniandriabarletta
	0x00334253, // n0x0b7a c0x0000 (---------------)  + I tranibarlettaandria
	0x002947c7, // n0x0b7b c0x0000 (---------------)  + I trapani
	0x002b4cc8, // n0x0b7c c0x0000 (---------------)  + I trentino
	0x002e30d0, // n0x0b7d c0x0000 (---------------)  + I trentino-a-adige
	0x0034014f, // n0x0b7e c0x0000 (---------------)  + I trentino-aadige
	0x0034b513, // n0x0b7f c0x0000 (---------------)  + I trentino-alto-adige
	0x002cca92, // n0x0b80 c0x0000 (---------------)  + I trentino-altoadige
	0x0032f950, // n0x0b81 c0x0000 (---------------)  + I trentino-s-tirol
	0x002b4ccf, // n0x0b82 c0x0000 (---------------)  + I trentino-stirol
	0x002bda52, // n0x0b83 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002c6211, // n0x0b84 c0x0000 (---------------)  + I trentino-sudtirol
	0x002c8c93, // n0x0b85 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002c9d52, // n0x0b86 c0x0000 (---------------)  + I trentino-suedtirol
	0x002cf18f, // n0x0b87 c0x0000 (---------------)  + I trentinoa-adige
	0x002d868e, // n0x0b88 c0x0000 (---------------)  + I trentinoaadige
	0x002dc892, // n0x0b89 c0x0000 (---------------)  + I trentinoalto-adige
	0x002dd0d1, // n0x0b8a c0x0000 (---------------)  + I trentinoaltoadige
	0x002de5cf, // n0x0b8b c0x0000 (---------------)  + I trentinos-tirol
	0x002df54e, // n0x0b8c c0x0000 (---------------)  + I trentinostirol
	0x002e74d1, // n0x0b8d c0x0000 (---------------)  + I trentinosud-tirol
	0x00331c50, // n0x0b8e c0x0000 (---------------)  + I trentinosudtirol
	0x002e1312, // n0x0b8f c0x0000 (---------------)  + I trentinosued-tirol
	0x002f0f91, // n0x0b90 c0x0000 (---------------)  + I trentinosuedtirol
	0x002ec6c6, // n0x0b91 c0x0000 (---------------)  + I trento
	0x002eeb47, // n0x0b92 c0x0000 (---------------)  + I treviso
	0x00362947, // n0x0b93 c0x0000 (---------------)  + I trieste
	0x00208842, // n0x0b94 c0x0000 (---------------)  + I ts
	0x00278785, // n0x0b95 c0x0000 (---------------)  + I turin
	0x002e7907, // n0x0b96 c0x0000 (---------------)  + I tuscany
	0x0020da42, // n0x0b97 c0x0000 (---------------)  + I tv
	0x00205f02, // n0x0b98 c0x0000 (---------------)  + I ud
	0x00226ac5, // n0x0b99 c0x0000 (---------------)  + I udine
	0x0021d203, // n0x0b9a c0x0000 (---------------)  + I umb
	0x0024a846, // n0x0b9b c0x0000 (---------------)  + I umbria
	0x002270cd, // n0x0b9c c0x0000 (---------------)  + I urbino-pesaro
	0x0022740c, // n0x0b9d c0x0000 (---------------)  + I urbinopesaro
	0x002000c2, // n0x0b9e c0x0000 (---------------)  + I va
	0x00303c8b, // n0x0b9f c0x0000 (---------------)  + I val-d-aosta
	0x0021734a, // n0x0ba0 c0x0000 (---------------)  + I val-daosta
	0x0031b14a, // n0x0ba1 c0x0000 (---------------)  + I vald-aosta
	0x002aa709, // n0x0ba2 c0x0000 (---------------)  + I valdaosta
	0x002d75cb, // n0x0ba3 c0x0000 (---------------)  + I valle-aosta
	0x002e800d, // n0x0ba4 c0x0000 (---------------)  + I valle-d-aosta
	0x0024b44c, // n0x0ba5 c0x0000 (---------------)  + I valle-daosta
	0x0021a3ca, // n0x0ba6 c0x0000 (---------------)  + I valleaosta
	0x0021fd0c, // n0x0ba7 c0x0000 (---------------)  + I valled-aosta
	0x00235bcb, // n0x0ba8 c0x0000 (---------------)  + I valledaosta
	0x0023ac8c, // n0x0ba9 c0x0000 (---------------)  + I vallee-aoste
	0x00249d4b, // n0x0baa c0x0000 (---------------)  + I valleeaoste
	0x00266c83, // n0x0bab c0x0000 (---------------)  + I vao
	0x0026ee06, // n0x0bac c0x0000 (---------------)  + I varese
	0x002d3f02, // n0x0bad c0x0000 (---------------)  + I vb
	0x002df902, // n0x0bae c0x0000 (---------------)  + I vc
	0x0020e543, // n0x0baf c0x0000 (---------------)  + I vda
	0x00201d82, // n0x0bb0 c0x0000 (---------------)  + I ve
	0x00201d83, // n0x0bb1 c0x0000 (---------------)  + I ven
	0x002996c6, // n0x0bb2 c0x0000 (---------------)  + I veneto
	0x00258447, // n0x0bb3 c0x0000 (---------------)  + I venezia
	0x0025cf06, // n0x0bb4 c0x0000 (---------------)  + I venice
	0x0039fe88, // n0x0bb5 c0x0000 (---------------)  + I verbania
	0x002bc348, // n0x0bb6 c0x0000 (---------------)  + I vercelli
	0x0020da86, // n0x0bb7 c0x0000 (---------------)  + I verona
	0x00201302, // n0x0bb8 c0x0000 (---------------)  + I vi
	0x002e9a4d, // n0x0bb9 c0x0000 (---------------)  + I vibo-valentia
	0x002e9d8c, // n0x0bba c0x0000 (---------------)  + I vibovalentia
	0x0034ecc7, // n0x0bbb c0x0000 (---------------)  + I vicenza
	0x002ef147, // n0x0bbc c0x0000 (---------------)  + I viterbo
	0x0021a142, // n0x0bbd c0x0000 (---------------)  + I vr
	0x0022b482, // n0x0bbe c0x0000 (---------------)  + I vs
	0x0026e582, // n0x0bbf c0x0000 (---------------)  + I vt
	0x0020c942, // n0x0bc0 c0x0000 (---------------)  + I vv
	0x00203dc2, // n0x0bc1 c0x0000 (---------------)  + I co
	0x0021e283, // n0x0bc2 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0bc3 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x0bc4 c0x0000 (---------------)  + I com
	0x002325c3, // n0x0bc5 c0x0000 (---------------)  + I edu
	0x00264783, // n0x0bc6 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x0bc7 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x0bc8 c0x0000 (---------------)  + I name
	0x0021e283, // n0x0bc9 c0x0000 (---------------)  + I net
	0x00223a43, // n0x0bca c0x0000 (---------------)  + I org
	0x00213403, // n0x0bcb c0x0000 (---------------)  + I sch
	0x00203982, // n0x0bcc c0x0000 (---------------)  + I ac
	0x0020c682, // n0x0bcd c0x0000 (---------------)  + I ad
	0x1f688645, // n0x0bce c0x007d (n0x0c3b-n0x0c6f)  + I aichi
	0x1fa026c5, // n0x0bcf c0x007e (n0x0c6f-n0x0c8b)  + I akita
	0x1ff05306, // n0x0bd0 c0x007f (n0x0c8b-n0x0ca1)  + I aomori
	0x000f4e08, // n0x0bd1 c0x0000 (---------------)  +   blogspot
	0x202a7dc5, // n0x0bd2 c0x0080 (n0x0ca1-n0x0cdb)  + I chiba
	0x00203dc2, // n0x0bd3 c0x0000 (---------------)  + I co
	0x002003c2, // n0x0bd4 c0x0000 (---------------)  + I ed
	0x20743005, // n0x0bd5 c0x0081 (n0x0cdb-n0x0cf1)  + I ehime
	0x20a75e05, // n0x0bd6 c0x0082 (n0x0cf1-n0x0d00)  + I fukui
	0x20e77e47, // n0x0bd7 c0x0083 (n0x0d00-n0x0d3f)  + I fukuoka
	0x213368c9, // n0x0bd8 c0x0084 (n0x0d3f-n0x0d72)  + I fukushima
	0x21766a44, // n0x0bd9 c0x0085 (n0x0d72-n0x0d98)  + I gifu
	0x00200702, // n0x0bda c0x0000 (---------------)  + I go
	0x002008c2, // n0x0bdb c0x0000 (---------------)  + I gr
	0x21a3b4c5, // n0x0bdc c0x0086 (n0x0d98-n0x0dbc)  + I gunma
	0x21e099c9, // n0x0bdd c0x0087 (n0x0dbc-n0x0dd5)  + I hiroshima
	0x22365a08, // n0x0bde c0x0088 (n0x0dd5-n0x0e63)  + I hokkaido
	0x226a5e85, // n0x0bdf c0x0089 (n0x0e63-n0x0e91)  + I hyogo
	0x22abcc07, // n0x0be0 c0x008a (n0x0e91-n0x0ec4)  + I ibaraki
	0x22e19648, // n0x0be1 c0x008b (n0x0ec4-n0x0ed7)  + I ishikawa
	0x232d0b85, // n0x0be2 c0x008c (n0x0ed7-n0x0ef9)  + I iwate
	0x23600c06, // n0x0be3 c0x008d (n0x0ef9-n0x0f08)  + I kagawa
	0x23a67809, // n0x0be4 c0x008e (n0x0f08-n0x0f1c)  + I kagoshima
	0x23f09208, // n0x0be5 c0x008f (n0x0f1c-n0x0f3a)  + I kanagawa
	0x242b3c48, // n0x0be6 c0x0090 (n0x0f3a-n0x0f3b)* o I kawasaki
	0x24695cca, // n0x0be7 c0x0091 (n0x0f3b-n0x0f3c)* o I kitakyushu
	0x24a48144, // n0x0be8 c0x0092 (n0x0f3c-n0x0f3d)* o I kobe
	0x24ec6985, // n0x0be9 c0x0093 (n0x0f3d-n0x0f5c)  + I kochi
	0x252ad3c8, // n0x0bea c0x0094 (n0x0f5c-n0x0f76)  + I kumamoto
	0x256b9245, // n0x0beb c0x0095 (n0x0f76-n0x0f95)  + I kyoto
	0x00217942, // n0x0bec c0x0000 (---------------)  + I lg
	0x25a40003, // n0x0bed c0x0096 (n0x0f95-n0x0fb3)  + I mie
	0x25e9c346, // n0x0bee c0x0097 (n0x0fb3-n0x0fd4)  + I miyagi
	0x2625f0c8, // n0x0bef c0x0098 (n0x0fd4-n0x0fef)  + I miyazaki
	0x267a40c6, // n0x0bf0 c0x0099 (n0x0fef-n0x103a)  + I nagano
	0x26abbfc8, // n0x0bf1 c0x009a (n0x103a-n0x1050)  + I nagasaki
	0x26f04146, // n0x0bf2 c0x009b (n0x1050-n0x1051)* o I nagoya
	0x272b96c4, // n0x0bf3 c0x009c (n0x1051-n0x1077)  + I nara
	0x00201e02, // n0x0bf4 c0x0000 (---------------)  + I ne
	0x276756c7, // n0x0bf5 c0x009d (n0x1077-n0x1099)  + I niigata
	0x27aa1f44, // n0x0bf6 c0x009e (n0x1099-n0x10ac)  + I oita
	0x27e71d87, // n0x0bf7 c0x009f (n0x10ac-n0x10c6)  + I okayama
	0x2838fc07, // n0x0bf8 c0x00a0 (n0x10c6-n0x10f0)  + I okinawa
	0x00200282, // n0x0bf9 c0x0000 (---------------)  + I or
	0x286931c5, // n0x0bfa c0x00a1 (n0x10f0-n0x1122)  + I osaka
	0x28a06344, // n0x0bfb c0x00a2 (n0x1122-n0x113c)  + I saga
	0x28f49987, // n0x0bfc c0x00a3 (n0x113c-n0x1181)  + I saitama
	0x29219147, // n0x0bfd c0x00a4 (n0x1181-n0x1182)* o I sapporo
	0x2967b186, // n0x0bfe c0x00a5 (n0x1182-n0x1183)* o I sendai
	0x29a283c5, // n0x0bff c0x00a6 (n0x1183-n0x119a)  + I shiga
	0x29e8d4c7, // n0x0c00 c0x00a7 (n0x119a-n0x11b1)  + I shimane
	0x2a2a8f48, // n0x0c01 c0x00a8 (n0x11b1-n0x11d5)  + I shizuoka
	0x2a741547, // n0x0c02 c0x00a9 (n0x11d5-n0x11f4)  + I tochigi
	0x2ab6fe89, // n0x0c03 c0x00aa (n0x11f4-n0x1205)  + I tokushima
	0x2af3f685, // n0x0c04 c0x00ab (n0x1205-n0x123e)  + I tokyo
	0x2b2ec7c7, // n0x0c05 c0x00ac (n0x123e-n0x124b)  + I tottori
	0x2b687b06, // n0x0c06 c0x00ad (n0x124b-n0x1263)  + I toyama
	0x2bb3c8c8, // n0x0c07 c0x00ae (n0x1263-n0x1280)  + I wakayama
	0x003636cd, // n0x0c08 c0x0000 (---------------)  + I xn--0trq7p7nn
	0x00242c89, // n0x0c09 c0x0000 (---------------)  + I xn--1ctwo
	0x0034774b, // n0x0c0a c0x0000 (---------------)  + I xn--1lqs03n
	0x00255b0b, // n0x0c0b c0x0000 (---------------)  + I xn--1lqs71d
	0x0026c1cb, // n0x0c0c c0x0000 (---------------)  + I xn--2m4a15e
	0x0029f94b, // n0x0c0d c0x0000 (---------------)  + I xn--32vp30h
	0x002f76cb, // n0x0c0e c0x0000 (---------------)  + I xn--4it168d
	0x002f798b, // n0x0c0f c0x0000 (---------------)  + I xn--4it797k
	0x002f7dc9, // n0x0c10 c0x0000 (---------------)  + I xn--4pvxs
	0x002f920b, // n0x0c11 c0x0000 (---------------)  + I xn--5js045d
	0x002f94cb, // n0x0c12 c0x0000 (---------------)  + I xn--5rtp49c
	0x002fa70b, // n0x0c13 c0x0000 (---------------)  + I xn--5rtq34k
	0x002fb74a, // n0x0c14 c0x0000 (---------------)  + I xn--6btw5a
	0x002fbc8a, // n0x0c15 c0x0000 (---------------)  + I xn--6orx2r
	0x002fc28c, // n0x0c16 c0x0000 (---------------)  + I xn--7t0a264c
	0x00300d4b, // n0x0c17 c0x0000 (---------------)  + I xn--8ltr62k
	0x003012ca, // n0x0c18 c0x0000 (---------------)  + I xn--8pvr4u
	0x0031268a, // n0x0c19 c0x0000 (---------------)  + I xn--c3s14m
	0x0031f98e, // n0x0c1a c0x0000 (---------------)  + I xn--d5qv7z876c
	0x0032074e, // n0x0c1b c0x0000 (---------------)  + I xn--djrs72d6uy
	0x00320aca, // n0x0c1c c0x0000 (---------------)  + I xn--djty4k
	0x003221ca, // n0x0c1d c0x0000 (---------------)  + I xn--efvn9s
	0x00322dcb, // n0x0c1e c0x0000 (---------------)  + I xn--ehqz56n
	0x0032308b, // n0x0c1f c0x0000 (---------------)  + I xn--elqq16h
	0x00323b8b, // n0x0c20 c0x0000 (---------------)  + I xn--f6qx53a
	0x0034494b, // n0x0c21 c0x0000 (---------------)  + I xn--k7yn95e
	0x00344f4a, // n0x0c22 c0x0000 (---------------)  + I xn--kbrq7o
	0x00345c0b, // n0x0c23 c0x0000 (---------------)  + I xn--klt787d
	0x00345eca, // n0x0c24 c0x0000 (---------------)  + I xn--kltp7d
	0x0034614a, // n0x0c25 c0x0000 (---------------)  + I xn--kltx9a
	0x003463ca, // n0x0c26 c0x0000 (---------------)  + I xn--klty5x
	0x00363a0b, // n0x0c27 c0x0000 (---------------)  + I xn--mkru45i
	0x0036bc8b, // n0x0c28 c0x0000 (---------------)  + I xn--nit225k
	0x0036d8ce, // n0x0c29 c0x0000 (---------------)  + I xn--ntso0iqx3a
	0x0036dc4b, // n0x0c2a c0x0000 (---------------)  + I xn--ntsq17g
	0x0037490b, // n0x0c2b c0x0000 (---------------)  + I xn--pssu33l
	0x00375b4b, // n0x0c2c c0x0000 (---------------)  + I xn--qqqt11m
	0x00378aca, // n0x0c2d c0x0000 (---------------)  + I xn--rht27z
	0x00378d49, // n0x0c2e c0x0000 (---------------)  + I xn--rht3d
	0x00378f8a, // n0x0c2f c0x0000 (---------------)  + I xn--rht61e
	0x0037a60a, // n0x0c30 c0x0000 (---------------)  + I xn--rny31h
	0x0038d2cb, // n0x0c31 c0x0000 (---------------)  + I xn--tor131o
	0x0038ee0b, // n0x0c32 c0x0000 (---------------)  + I xn--uist22h
	0x0038f54a, // n0x0c33 c0x0000 (---------------)  + I xn--uisz3g
	0x00390c4b, // n0x0c34 c0x0000 (---------------)  + I xn--uuwu58a
	0x00395ecb, // n0x0c35 c0x0000 (---------------)  + I xn--vgu402c
	0x003a0a8b, // n0x0c36 c0x0000 (---------------)  + I xn--zbx025d
	0x2be79248, // n0x0c37 c0x00af (n0x1280-n0x12a2)  + I yamagata
	0x2c281dc9, // n0x0c38 c0x00b0 (n0x12a2-n0x12b2)  + I yamaguchi
	0x2c69b349, // n0x0c39 c0x00b1 (n0x12b2-n0x12ce)  + I yamanashi
	0x2cb53348, // n0x0c3a c0x00b2 (n0x12ce-n0x12cf)* o I yokohama
	0x00329545, // n0x0c3b c0x0000 (---------------)  + I aisai
	0x00201683, // n0x0c3c c0x0000 (---------------)  + I ama
	0x00201444, // n0x0c3d c0x0000 (---------------)  + I anjo
	0x0037b9c5, // n0x0c3e c0x0000 (---------------)  + I asuke
	0x00366786, // n0x0c3f c0x0000 (---------------)  + I chiryu
	0x002a6e85, // n0x0c40 c0x0000 (---------------)  + I chita
	0x002815c4, // n0x0c41 c0x0000 (---------------)  + I fuso
	0x00260748, // n0x0c42 c0x0000 (---------------)  + I gamagori
	0x00250005, // n0x0c43 c0x0000 (---------------)  + I handa
	0x0028a504, // n0x0c44 c0x0000 (---------------)  + I hazu
	0x002be3c7, // n0x0c45 c0x0000 (---------------)  + I hekinan
	0x0029660a, // n0x0c46 c0x0000 (---------------)  + I higashiura
	0x0026b40a, // n0x0c47 c0x0000 (---------------)  + I ichinomiya
	0x002fcdc7, // n0x0c48 c0x0000 (---------------)  + I inazawa
	0x00202087, // n0x0c49 c0x0000 (---------------)  + I inuyama
	0x002e6107, // n0x0c4a c0x0000 (---------------)  + I isshiki
	0x002277c7, // n0x0c4b c0x0000 (---------------)  + I iwakura
	0x00287885, // n0x0c4c c0x0000 (---------------)  + I kanie
	0x00325846, // n0x0c4d c0x0000 (---------------)  + I kariya
	0x00317f87, // n0x0c4e c0x0000 (---------------)  + I kasugai
	0x00248d44, // n0x0c4f c0x0000 (---------------)  + I kira
	0x00353186, // n0x0c50 c0x0000 (---------------)  + I kiyosu
	0x002a40c6, // n0x0c51 c0x0000 (---------------)  + I komaki
	0x00207ec5, // n0x0c52 c0x0000 (---------------)  + I konan
	0x00256604, // n0x0c53 c0x0000 (---------------)  + I kota
	0x0029d806, // n0x0c54 c0x0000 (---------------)  + I mihama
	0x00295807, // n0x0c55 c0x0000 (---------------)  + I miyoshi
	0x00224986, // n0x0c56 c0x0000 (---------------)  + I nishio
	0x002dee07, // n0x0c57 c0x0000 (---------------)  + I nisshin
	0x00274b43, // n0x0c58 c0x0000 (---------------)  + I obu
	0x0024b946, // n0x0c59 c0x0000 (---------------)  + I oguchi
	0x00231205, // n0x0c5a c0x0000 (---------------)  + I oharu
	0x00277f47, // n0x0c5b c0x0000 (---------------)  + I okazaki
	0x002b998a, // n0x0c5c c0x0000 (---------------)  + I owariasahi
	0x002a87c4, // n0x0c5d c0x0000 (---------------)  + I seto
	0x00217b48, // n0x0c5e c0x0000 (---------------)  + I shikatsu
	0x0032e749, // n0x0c5f c0x0000 (---------------)  + I shinshiro
	0x002d28c7, // n0x0c60 c0x0000 (---------------)  + I shitara
	0x002e0c86, // n0x0c61 c0x0000 (---------------)  + I tahara
	0x00359a08, // n0x0c62 c0x0000 (---------------)  + I takahama
	0x00302f09, // n0x0c63 c0x0000 (---------------)  + I tobishima
	0x002758c4, // n0x0c64 c0x0000 (---------------)  + I toei
	0x002f6144, // n0x0c65 c0x0000 (---------------)  + I togo
	0x002efe85, // n0x0c66 c0x0000 (---------------)  + I tokai
	0x002ba088, // n0x0c67 c0x0000 (---------------)  + I tokoname
	0x002bad47, // n0x0c68 c0x0000 (---------------)  + I toyoake
	0x0027f609, // n0x0c69 c0x0000 (---------------)  + I toyohashi
	0x00242748, // n0x0c6a c0x0000 (---------------)  + I toyokawa
	0x00361f46, // n0x0c6b c0x0000 (---------------)  + I toyone
	0x0025d5c6, // n0x0c6c c0x0000 (---------------)  + I toyota
	0x0028ff08, // n0x0c6d c0x0000 (---------------)  + I tsushima
	0x00366306, // n0x0c6e c0x0000 (---------------)  + I yatomi
	0x002026c5, // n0x0c6f c0x0000 (---------------)  + I akita
	0x0027b246, // n0x0c70 c0x0000 (---------------)  + I daisen
	0x00272088, // n0x0c71 c0x0000 (---------------)  + I fujisato
	0x002329c6, // n0x0c72 c0x0000 (---------------)  + I gojome
	0x0025120b, // n0x0c73 c0x0000 (---------------)  + I hachirogata
	0x002847c6, // n0x0c74 c0x0000 (---------------)  + I happou
	0x0029190d, // n0x0c75 c0x0000 (---------------)  + I higashinaruse
	0x00393b45, // n0x0c76 c0x0000 (---------------)  + I honjo
	0x002a1e06, // n0x0c77 c0x0000 (---------------)  + I honjyo
	0x00219705, // n0x0c78 c0x0000 (---------------)  + I ikawa
	0x0028f009, // n0x0c79 c0x0000 (---------------)  + I kamikoani
	0x00314007, // n0x0c7a c0x0000 (---------------)  + I kamioka
	0x00371c88, // n0x0c7b c0x0000 (---------------)  + I katagami
	0x002fc706, // n0x0c7c c0x0000 (---------------)  + I kazuno
	0x00290889, // n0x0c7d c0x0000 (---------------)  + I kitaakita
	0x002dbc86, // n0x0c7e c0x0000 (---------------)  + I kosaka
	0x002b9905, // n0x0c7f c0x0000 (---------------)  + I kyowa
	0x00298846, // n0x0c80 c0x0000 (---------------)  + I misato
	0x002a1106, // n0x0c81 c0x0000 (---------------)  + I mitane
	0x002c2a09, // n0x0c82 c0x0000 (---------------)  + I moriyoshi
	0x00333246, // n0x0c83 c0x0000 (---------------)  + I nikaho
	0x00357d87, // n0x0c84 c0x0000 (---------------)  + I noshiro
	0x002ab5c5, // n0x0c85 c0x0000 (---------------)  + I odate
	0x00201c03, // n0x0c86 c0x0000 (---------------)  + I oga
	0x00222885, // n0x0c87 c0x0000 (---------------)  + I ogata
	0x002a0007, // n0x0c88 c0x0000 (---------------)  + I semboku
	0x00342ec6, // n0x0c89 c0x0000 (---------------)  + I yokote
	0x00393a49, // n0x0c8a c0x0000 (---------------)  + I yurihonjo
	0x00305306, // n0x0c8b c0x0000 (---------------)  + I aomori
	0x00247846, // n0x0c8c c0x0000 (---------------)  + I gonohe
	0x0020aec9, // n0x0c8d c0x0000 (---------------)  + I hachinohe
	0x0027ac49, // n0x0c8e c0x0000 (---------------)  + I hashikami
	0x00298fc7, // n0x0c8f c0x0000 (---------------)  + I hiranai
	0x00337e08, // n0x0c90 c0x0000 (---------------)  + I hirosaki
	0x002571c9, // n0x0c91 c0x0000 (---------------)  + I itayanagi
	0x00278408, // n0x0c92 c0x0000 (---------------)  + I kuroishi
	0x0036b506, // n0x0c93 c0x0000 (---------------)  + I misawa
	0x002ca5c5, // n0x0c94 c0x0000 (---------------)  + I mutsu
	0x0021d5ca, // n0x0c95 c0x0000 (---------------)  + I nakadomari
	0x002478c6, // n0x0c96 c0x0000 (---------------)  + I noheji
	0x00398606, // n0x0c97 c0x0000 (---------------)  + I oirase
	0x0029c505, // n0x0c98 c0x0000 (---------------)  + I owani
	0x00366d88, // n0x0c99 c0x0000 (---------------)  + I rokunohe
	0x00209607, // n0x0c9a c0x0000 (---------------)  + I sannohe
	0x0023014a, // n0x0c9b c0x0000 (---------------)  + I shichinohe
	0x00247746, // n0x0c9c c0x0000 (---------------)  + I shingo
	0x00235e05, // n0x0c9d c0x0000 (---------------)  + I takko
	0x00395946, // n0x0c9e c0x0000 (---------------)  + I towada
	0x002a4807, // n0x0c9f c0x0000 (---------------)  + I tsugaru
	0x002e0b47, // n0x0ca0 c0x0000 (---------------)  + I tsuruta
	0x00357a05, // n0x0ca1 c0x0000 (---------------)  + I abiko
	0x002b9ac5, // n0x0ca2 c0x0000 (---------------)  + I asahi
	0x002d2f86, // n0x0ca3 c0x0000 (---------------)  + I chonan
	0x002dea06, // n0x0ca4 c0x0000 (---------------)  + I chosei
	0x002df946, // n0x0ca5 c0x0000 (---------------)  + I choshi
	0x00321084, // n0x0ca6 c0x0000 (---------------)  + I chuo
	0x00279d09, // n0x0ca7 c0x0000 (---------------)  + I funabashi
	0x00282c86, // n0x0ca8 c0x0000 (---------------)  + I futtsu
	0x0027b80a, // n0x0ca9 c0x0000 (---------------)  + I hanamigawa
	0x00288688, // n0x0caa c0x0000 (---------------)  + I ichihara
	0x0032d348, // n0x0cab c0x0000 (---------------)  + I ichikawa
	0x0026b40a, // n0x0cac c0x0000 (---------------)  + I ichinomiya
	0x00397ec5, // n0x0cad c0x0000 (---------------)  + I inzai
	0x00295745, // n0x0cae c0x0000 (---------------)  + I isumi
	0x00303788, // n0x0caf c0x0000 (---------------)  + I kamagaya
	0x002c6708, // n0x0cb0 c0x0000 (---------------)  + I kamogawa
	0x0031d8c7, // n0x0cb1 c0x0000 (---------------)  + I kashiwa
	0x00294b46, // n0x0cb2 c0x0000 (---------------)  + I katori
	0x0030d588, // n0x0cb3 c0x0000 (---------------)  + I katsuura
	0x0034e3c7, // n0x0cb4 c0x0000 (---------------)  + I kimitsu
	0x00279708, // n0x0cb5 c0x0000 (---------------)  + I kisarazu
	0x00364a06, // n0x0cb6 c0x0000 (---------------)  + I kozaki
	0x0027bdc8, // n0x0cb7 c0x0000 (---------------)  + I kujukuri
	0x0028ca06, // n0x0cb8 c0x0000 (---------------)  + I kyonan
	0x0022e547, // n0x0cb9 c0x0000 (---------------)  + I matsudo
	0x002912c6, // n0x0cba c0x0000 (---------------)  + I midori
	0x0029d806, // n0x0cbb c0x0000 (---------------)  + I mihama
	0x0022c18a, // n0x0cbc c0x0000 (---------------)  + I minamiboso
	0x0022d8c6, // n0x0cbd c0x0000 (---------------)  + I mobara
	0x002ca5c9, // n0x0cbe c0x0000 (---------------)  + I mutsuzawa
	0x002a80c6, // n0x0cbf c0x0000 (---------------)  + I nagara
	0x002cba8a, // n0x0cc0 c0x0000 (---------------)  + I nagareyama
	0x002b96c9, // n0x0cc1 c0x0000 (---------------)  + I narashino
	0x00357106, // n0x0cc2 c0x0000 (---------------)  + I narita
	0x00376fc4, // n0x0cc3 c0x0000 (---------------)  + I noda
	0x00302c4d, // n0x0cc4 c0x0000 (---------------)  + I oamishirasato
	0x00282047, // n0x0cc5 c0x0000 (---------------)  + I omigawa
	0x0030fb86, // n0x0cc6 c0x0000 (---------------)  + I onjuku
	0x002b3b05, // n0x0cc7 c0x0000 (---------------)  + I otaki
	0x002dbd05, // n0x0cc8 c0x0000 (---------------)  + I sakae
	0x002d4206, // n0x0cc9 c0x0000 (---------------)  + I sakura
	0x00287249, // n0x0cca c0x0000 (---------------)  + I shimofusa
	0x0029be87, // n0x0ccb c0x0000 (---------------)  + I shirako
	0x00272cc6, // n0x0ccc c0x0000 (---------------)  + I shiroi
	0x002eda06, // n0x0ccd c0x0000 (---------------)  + I shisui
	0x00281649, // n0x0cce c0x0000 (---------------)  + I sodegaura
	0x0021c104, // n0x0ccf c0x0000 (---------------)  + I sosa
	0x00224804, // n0x0cd0 c0x0000 (---------------)  + I tako
	0x00201548, // n0x0cd1 c0x0000 (---------------)  + I tateyama
	0x00299a86, // n0x0cd2 c0x0000 (---------------)  + I togane
	0x00298948, // n0x0cd3 c0x0000 (---------------)  + I tohnosho
	0x002aee08, // n0x0cd4 c0x0000 (---------------)  + I tomisato
	0x0026dbc7, // n0x0cd5 c0x0000 (---------------)  + I urayasu
	0x003a1c89, // n0x0cd6 c0x0000 (---------------)  + I yachimata
	0x002dfb47, // n0x0cd7 c0x0000 (---------------)  + I yachiyo
	0x002a7c8a, // n0x0cd8 c0x0000 (---------------)  + I yokaichiba
	0x002ae7cf, // n0x0cd9 c0x0000 (---------------)  + I yokoshibahikari
	0x0026194a, // n0x0cda c0x0000 (---------------)  + I yotsukaido
	0x00222285, // n0x0cdb c0x0000 (---------------)  + I ainan
	0x002722c5, // n0x0cdc c0x0000 (---------------)  + I honai
	0x00216e45, // n0x0cdd c0x0000 (---------------)  + I ikata
	0x0024e2c7, // n0x0cde c0x0000 (---------------)  + I imabari
	0x00274303, // n0x0cdf c0x0000 (---------------)  + I iyo
	0x00338008, // n0x0ce0 c0x0000 (---------------)  + I kamijima
	0x002ea686, // n0x0ce1 c0x0000 (---------------)  + I kihoku
	0x002ea789, // n0x0ce2 c0x0000 (---------------)  + I kumakogen
	0x0039f646, // n0x0ce3 c0x0000 (---------------)  + I masaki
	0x002ba487, // n0x0ce4 c0x0000 (---------------)  + I matsuno
	0x00290649, // n0x0ce5 c0x0000 (---------------)  + I matsuyama
	0x00371b88, // n0x0ce6 c0x0000 (---------------)  + I namikata
	0x0029c5c7, // n0x0ce7 c0x0000 (---------------)  + I niihama
	0x002f66c3, // n0x0ce8 c0x0000 (---------------)  + I ozu
	0x003295c5, // n0x0ce9 c0x0000 (---------------)  + I saijo
	0x0039b245, // n0x0cea c0x0000 (---------------)  + I seiyo
	0x00320ecb, // n0x0ceb c0x0000 (---------------)  + I shikokuchuo
	0x002b9304, // n0x0cec c0x0000 (---------------)  + I tobe
	0x00203b84, // n0x0ced c0x0000 (---------------)  + I toon
	0x00271046, // n0x0cee c0x0000 (---------------)  + I uchiko
	0x002f6a47, // n0x0cef c0x0000 (---------------)  + I uwajima
	0x003883ca, // n0x0cf0 c0x0000 (---------------)  + I yawatahama
	0x00240087, // n0x0cf1 c0x0000 (---------------)  + I echizen
	0x00275947, // n0x0cf2 c0x0000 (---------------)  + I eiheiji
	0x00275e05, // n0x0cf3 c0x0000 (---------------)  + I fukui
	0x00201785, // n0x0cf4 c0x0000 (---------------)  + I ikeda
	0x00214fc9, // n0x0cf5 c0x0000 (---------------)  + I katsuyama
	0x0029d806, // n0x0cf6 c0x0000 (---------------)  + I mihama
	0x0023ff0d, // n0x0cf7 c0x0000 (---------------)  + I minamiechizen
	0x0038ffc5, // n0x0cf8 c0x0000 (---------------)  + I obama
	0x00298b43, // n0x0cf9 c0x0000 (---------------)  + I ohi
	0x0020f703, // n0x0cfa c0x0000 (---------------)  + I ono
	0x002eb005, // n0x0cfb c0x0000 (---------------)  + I sabae
	0x00348a85, // n0x0cfc c0x0000 (---------------)  + I sakai
	0x00359a08, // n0x0cfd c0x0000 (---------------)  + I takahama
	0x002739c7, // n0x0cfe c0x0000 (---------------)  + I tsuruga
	0x00224586, // n0x0cff c0x0000 (---------------)  + I wakasa
	0x00296cc6, // n0x0d00 c0x0000 (---------------)  + I ashiya
	0x00228585, // n0x0d01 c0x0000 (---------------)  + I buzen
	0x00232887, // n0x0d02 c0x0000 (---------------)  + I chikugo
	0x00202307, // n0x0d03 c0x0000 (---------------)  + I chikuho
	0x002895c7, // n0x0d04 c0x0000 (---------------)  + I chikujo
	0x002c6a0a, // n0x0d05 c0x0000 (---------------)  + I chikushino
	0x0024ba08, // n0x0d06 c0x0000 (---------------)  + I chikuzen
	0x00321084, // n0x0d07 c0x0000 (---------------)  + I chuo
	0x0020cac7, // n0x0d08 c0x0000 (---------------)  + I dazaifu
	0x00274c87, // n0x0d09 c0x0000 (---------------)  + I fukuchi
	0x00305b46, // n0x0d0a c0x0000 (---------------)  + I hakata
	0x0025fc07, // n0x0d0b c0x0000 (---------------)  + I higashi
	0x002c0c08, // n0x0d0c c0x0000 (---------------)  + I hirokawa
	0x0029b248, // n0x0d0d c0x0000 (---------------)  + I hisayama
	0x00260206, // n0x0d0e c0x0000 (---------------)  + I iizuka
	0x00218c48, // n0x0d0f c0x0000 (---------------)  + I inatsuki
	0x002c25c4, // n0x0d10 c0x0000 (---------------)  + I kaho
	0x00317f86, // n0x0d11 c0x0000 (---------------)  + I kasuga
	0x002088c6, // n0x0d12 c0x0000 (---------------)  + I kasuya
	0x00392bc6, // n0x0d13 c0x0000 (---------------)  + I kawara
	0x00326546, // n0x0d14 c0x0000 (---------------)  + I keisen
	0x0021f544, // n0x0d15 c0x0000 (---------------)  + I koga
	0x00227886, // n0x0d16 c0x0000 (---------------)  + I kurate
	0x002b2986, // n0x0d17 c0x0000 (---------------)  + I kurogi
	0x0028f686, // n0x0d18 c0x0000 (---------------)  + I kurume
	0x00228206, // n0x0d19 c0x0000 (---------------)  + I minami
	0x0020f5c6, // n0x0d1a c0x0000 (---------------)  + I miyako
	0x002c0a46, // n0x0d1b c0x0000 (---------------)  + I miyama
	0x00224488, // n0x0d1c c0x0000 (---------------)  + I miyawaka
	0x00353008, // n0x0d1d c0x0000 (---------------)  + I mizumaki
	0x002c75c8, // n0x0d1e c0x0000 (---------------)  + I munakata
	0x002a7088, // n0x0d1f c0x0000 (---------------)  + I nakagawa
	0x00303706, // n0x0d20 c0x0000 (---------------)  + I nakama
	0x00211505, // n0x0d21 c0x0000 (---------------)  + I nishi
	0x00222846, // n0x0d22 c0x0000 (---------------)  + I nogata
	0x002a5f05, // n0x0d23 c0x0000 (---------------)  + I ogori
	0x00377f07, // n0x0d24 c0x0000 (---------------)  + I okagaki
	0x00242805, // n0x0d25 c0x0000 (---------------)  + I okawa
	0x002107c3, // n0x0d26 c0x0000 (---------------)  + I oki
	0x00209105, // n0x0d27 c0x0000 (---------------)  + I omuta
	0x002af784, // n0x0d28 c0x0000 (---------------)  + I onga
	0x0020f705, // n0x0d29 c0x0000 (---------------)  + I onojo
	0x002128c3, // n0x0d2a c0x0000 (---------------)  + I oto
	0x002d6e07, // n0x0d2b c0x0000 (---------------)  + I saigawa
	0x003440c8, // n0x0d2c c0x0000 (---------------)  + I sasaguri
	0x002deec6, // n0x0d2d c0x0000 (---------------)  + I shingu
	0x0028750d, // n0x0d2e c0x0000 (---------------)  + I shinyoshitomi
	0x00272286, // n0x0d2f c0x0000 (---------------)  + I shonai
	0x0028e705, // n0x0d30 c0x0000 (---------------)  + I soeda
	0x002c2dc3, // n0x0d31 c0x0000 (---------------)  + I sue
	0x002acd89, // n0x0d32 c0x0000 (---------------)  + I tachiarai
	0x002bcdc6, // n0x0d33 c0x0000 (---------------)  + I tagawa
	0x0028ed06, // n0x0d34 c0x0000 (---------------)  + I takata
	0x00348fc4, // n0x0d35 c0x0000 (---------------)  + I toho
	0x002618c7, // n0x0d36 c0x0000 (---------------)  + I toyotsu
	0x00233bc6, // n0x0d37 c0x0000 (---------------)  + I tsuiki
	0x00366bc5, // n0x0d38 c0x0000 (---------------)  + I ukiha
	0x00204103, // n0x0d39 c0x0000 (---------------)  + I umi
	0x00201104, // n0x0d3a c0x0000 (---------------)  + I usui
	0x00274e46, // n0x0d3b c0x0000 (---------------)  + I yamada
	0x00292104, // n0x0d3c c0x0000 (---------------)  + I yame
	0x00307288, // n0x0d3d c0x0000 (---------------)  + I yanagawa
	0x0031ce49, // n0x0d3e c0x0000 (---------------)  + I yukuhashi
	0x002b9009, // n0x0d3f c0x0000 (---------------)  + I aizubange
	0x0029874a, // n0x0d40 c0x0000 (---------------)  + I aizumisato
	0x0023e68d, // n0x0d41 c0x0000 (---------------)  + I aizuwakamatsu
	0x0024db87, // n0x0d42 c0x0000 (---------------)  + I asakawa
	0x00398486, // n0x0d43 c0x0000 (---------------)  + I bandai
	0x0020b444, // n0x0d44 c0x0000 (---------------)  + I date
	0x003368c9, // n0x0d45 c0x0000 (---------------)  + I fukushima
	0x00280248, // n0x0d46 c0x0000 (---------------)  + I furudono
	0x00281c46, // n0x0d47 c0x0000 (---------------)  + I futaba
	0x00253ac6, // n0x0d48 c0x0000 (---------------)  + I hanawa
	0x0025fc07, // n0x0d49 c0x0000 (---------------)  + I higashi
	0x002a3406, // n0x0d4a c0x0000 (---------------)  + I hirata
	0x0021b346, // n0x0d4b c0x0000 (---------------)  + I hirono
	0x0031d146, // n0x0d4c c0x0000 (---------------)  + I iitate
	0x0038fc8a, // n0x0d4d c0x0000 (---------------)  + I inawashiro
	0x00219648, // n0x0d4e c0x0000 (---------------)  + I ishikawa
	0x00228785, // n0x0d4f c0x0000 (---------------)  + I iwaki
	0x0026d909, // n0x0d50 c0x0000 (---------------)  + I izumizaki
	0x002bb4ca, // n0x0d51 c0x0000 (---------------)  + I kagamiishi
	0x002c3a08, // n0x0d52 c0x0000 (---------------)  + I kaneyama
	0x00293f88, // n0x0d53 c0x0000 (---------------)  + I kawamata
	0x0028ec88, // n0x0d54 c0x0000 (---------------)  + I kitakata
	0x0020270c, // n0x0d55 c0x0000 (---------------)  + I kitashiobara
	0x002ed605, // n0x0d56 c0x0000 (---------------)  + I koori
	0x00296f48, // n0x0d57 c0x0000 (---------------)  + I koriyama
	0x002ebdc6, // n0x0d58 c0x0000 (---------------)  + I kunimi
	0x002a1846, // n0x0d59 c0x0000 (---------------)  + I miharu
	0x0039de07, // n0x0d5a c0x0000 (---------------)  + I mishima
	0x0023ff85, // n0x0d5b c0x0000 (---------------)  + I namie
	0x0027b3c5, // n0x0d5c c0x0000 (---------------)  + I nango
	0x002b8ec9, // n0x0d5d c0x0000 (---------------)  + I nishiaizu
	0x00212147, // n0x0d5e c0x0000 (---------------)  + I nishigo
	0x002ea745, // n0x0d5f c0x0000 (---------------)  + I okuma
	0x0021be07, // n0x0d60 c0x0000 (---------------)  + I omotego
	0x0020f703, // n0x0d61 c0x0000 (---------------)  + I ono
	0x002bb985, // n0x0d62 c0x0000 (---------------)  + I otama
	0x00342108, // n0x0d63 c0x0000 (---------------)  + I samegawa
	0x00312fc7, // n0x0d64 c0x0000 (---------------)  + I shimogo
	0x00293e49, // n0x0d65 c0x0000 (---------------)  + I shirakawa
	0x002aadc5, // n0x0d66 c0x0000 (---------------)  + I showa
	0x002ef044, // n0x0d67 c0x0000 (---------------)  + I soma
	0x0029a088, // n0x0d68 c0x0000 (---------------)  + I sukagawa
	0x00214107, // n0x0d69 c0x0000 (---------------)  + I taishin
	0x0029c788, // n0x0d6a c0x0000 (---------------)  + I tamakawa
	0x00325f48, // n0x0d6b c0x0000 (---------------)  + I tanagura
	0x00349fc5, // n0x0d6c c0x0000 (---------------)  + I tenei
	0x0034d4c6, // n0x0d6d c0x0000 (---------------)  + I yabuki
	0x002881c6, // n0x0d6e c0x0000 (---------------)  + I yamato
	0x00254cc9, // n0x0d6f c0x0000 (---------------)  + I yamatsuri
	0x0030de07, // n0x0d70 c0x0000 (---------------)  + I yanaizu
	0x002a6786, // n0x0d71 c0x0000 (---------------)  + I yugawa
	0x002866c7, // n0x0d72 c0x0000 (---------------)  + I anpachi
	0x00213a03, // n0x0d73 c0x0000 (---------------)  + I ena
	0x00366a44, // n0x0d74 c0x0000 (---------------)  + I gifu
	0x0029a9c5, // n0x0d75 c0x0000 (---------------)  + I ginan
	0x0020cd44, // n0x0d76 c0x0000 (---------------)  + I godo
	0x0022c744, // n0x0d77 c0x0000 (---------------)  + I gujo
	0x002794c7, // n0x0d78 c0x0000 (---------------)  + I hashima
	0x00212f07, // n0x0d79 c0x0000 (---------------)  + I hichiso
	0x00272e84, // n0x0d7a c0x0000 (---------------)  + I hida
	0x00293c90, // n0x0d7b c0x0000 (---------------)  + I higashishirakawa
	0x00239d07, // n0x0d7c c0x0000 (---------------)  + I ibigawa
	0x00201785, // n0x0d7d c0x0000 (---------------)  + I ikeda
	0x002e37cc, // n0x0d7e c0x0000 (---------------)  + I kakamigahara
	0x0027e584, // n0x0d7f c0x0000 (---------------)  + I kani
	0x0037b208, // n0x0d80 c0x0000 (---------------)  + I kasahara
	0x0022e449, // n0x0d81 c0x0000 (---------------)  + I kasamatsu
	0x002f7546, // n0x0d82 c0x0000 (---------------)  + I kawaue
	0x0021c208, // n0x0d83 c0x0000 (---------------)  + I kitagata
	0x00247244, // n0x0d84 c0x0000 (---------------)  + I mino
	0x00247248, // n0x0d85 c0x0000 (---------------)  + I minokamo
	0x002ba646, // n0x0d86 c0x0000 (---------------)  + I mitake
	0x00228088, // n0x0d87 c0x0000 (---------------)  + I mizunami
	0x0029a6c6, // n0x0d88 c0x0000 (---------------)  + I motosu
	0x0022a4cb, // n0x0d89 c0x0000 (---------------)  + I nakatsugawa
	0x00201c05, // n0x0d8a c0x0000 (---------------)  + I ogaki
	0x002c2548, // n0x0d8b c0x0000 (---------------)  + I sakahogi
	0x00216244, // n0x0d8c c0x0000 (---------------)  + I seki
	0x0027a8ca, // n0x0d8d c0x0000 (---------------)  + I sekigahara
	0x00293e49, // n0x0d8e c0x0000 (---------------)  + I shirakawa
	0x002f9e46, // n0x0d8f c0x0000 (---------------)  + I tajimi
	0x002ba308, // n0x0d90 c0x0000 (---------------)  + I takayama
	0x0026cf85, // n0x0d91 c0x0000 (---------------)  + I tarui
	0x00221944, // n0x0d92 c0x0000 (---------------)  + I toki
	0x0037b106, // n0x0d93 c0x0000 (---------------)  + I tomika
	0x00289488, // n0x0d94 c0x0000 (---------------)  + I wanouchi
	0x00279248, // n0x0d95 c0x0000 (---------------)  + I yamagata
	0x0033f1c6, // n0x0d96 c0x0000 (---------------)  + I yaotsu
	0x00313804, // n0x0d97 c0x0000 (---------------)  + I yoro
	0x0021d546, // n0x0d98 c0x0000 (---------------)  + I annaka
	0x002dfbc7, // n0x0d99 c0x0000 (---------------)  + I chiyoda
	0x00271c87, // n0x0d9a c0x0000 (---------------)  + I fujioka
	0x0025fc0f, // n0x0d9b c0x0000 (---------------)  + I higashiagatsuma
	0x00205347, // n0x0d9c c0x0000 (---------------)  + I isesaki
	0x003571c7, // n0x0d9d c0x0000 (---------------)  + I itakura
	0x002a1705, // n0x0d9e c0x0000 (---------------)  + I kanna
	0x002cfb85, // n0x0d9f c0x0000 (---------------)  + I kanra
	0x00298c89, // n0x0da0 c0x0000 (---------------)  + I katashina
	0x00263406, // n0x0da1 c0x0000 (---------------)  + I kawaba
	0x00278b05, // n0x0da2 c0x0000 (---------------)  + I kiryu
	0x0027af47, // n0x0da3 c0x0000 (---------------)  + I kusatsu
	0x002ab388, // n0x0da4 c0x0000 (---------------)  + I maebashi
	0x002b5c85, // n0x0da5 c0x0000 (---------------)  + I meiwa
	0x002912c6, // n0x0da6 c0x0000 (---------------)  + I midori
	0x00211d08, // n0x0da7 c0x0000 (---------------)  + I minakami
	0x003a40ca, // n0x0da8 c0x0000 (---------------)  + I naganohara
	0x0024e908, // n0x0da9 c0x0000 (---------------)  + I nakanojo
	0x0038f147, // n0x0daa c0x0000 (---------------)  + I nanmoku
	0x002aec06, // n0x0dab c0x0000 (---------------)  + I numata
	0x0026d8c6, // n0x0dac c0x0000 (---------------)  + I oizumi
	0x0021aec3, // n0x0dad c0x0000 (---------------)  + I ora
	0x00201503, // n0x0dae c0x0000 (---------------)  + I ota
	0x002bb689, // n0x0daf c0x0000 (---------------)  + I shibukawa
	0x00257049, // n0x0db0 c0x0000 (---------------)  + I shimonita
	0x0036fd86, // n0x0db1 c0x0000 (---------------)  + I shinto
	0x002aadc5, // n0x0db2 c0x0000 (---------------)  + I showa
	0x0029a448, // n0x0db3 c0x0000 (---------------)  + I takasaki
	0x002ba308, // n0x0db4 c0x0000 (---------------)  + I takayama
	0x002d0048, // n0x0db5 c0x0000 (---------------)  + I tamamura
	0x0031d1cb, // n0x0db6 c0x0000 (---------------)  + I tatebayashi
	0x00287747, // n0x0db7 c0x0000 (---------------)  + I tomioka
	0x002f4949, // n0x0db8 c0x0000 (---------------)  + I tsukiyono
	0x0025fe88, // n0x0db9 c0x0000 (---------------)  + I tsumagoi
	0x00375244, // n0x0dba c0x0000 (---------------)  + I ueno
	0x002c2b08, // n0x0dbb c0x0000 (---------------)  + I yoshioka
	0x00285789, // n0x0dbc c0x0000 (---------------)  + I asaminami
	0x002a6a85, // n0x0dbd c0x0000 (---------------)  + I daiwa
	0x0024e1c7, // n0x0dbe c0x0000 (---------------)  + I etajima
	0x002b7345, // n0x0dbf c0x0000 (---------------)  + I fuchu
	0x00279148, // n0x0dc0 c0x0000 (---------------)  + I fukuyama
	0x002884cb, // n0x0dc1 c0x0000 (---------------)  + I hatsukaichi
	0x0028d210, // n0x0dc2 c0x0000 (---------------)  + I higashihiroshima
	0x002a1c05, // n0x0dc3 c0x0000 (---------------)  + I hongo
	0x0021618c, // n0x0dc4 c0x0000 (---------------)  + I jinsekikogen
	0x00224745, // n0x0dc5 c0x0000 (---------------)  + I kaita
	0x00275e83, // n0x0dc6 c0x0000 (---------------)  + I kui
	0x0027d286, // n0x0dc7 c0x0000 (---------------)  + I kumano
	0x002b1dc4, // n0x0dc8 c0x0000 (---------------)  + I kure
	0x00206446, // n0x0dc9 c0x0000 (---------------)  + I mihara
	0x00295807, // n0x0dca c0x0000 (---------------)  + I miyoshi
	0x00211d84, // n0x0dcb c0x0000 (---------------)  + I naka
	0x0026b308, // n0x0dcc c0x0000 (---------------)  + I onomichi
	0x00337ecd, // n0x0dcd c0x0000 (---------------)  + I osakikamijima
	0x002d22c5, // n0x0dce c0x0000 (---------------)  + I otake
	0x0023eb84, // n0x0dcf c0x0000 (---------------)  + I saka
	0x00221fc4, // n0x0dd0 c0x0000 (---------------)  + I sera
	0x0026d389, // n0x0dd1 c0x0000 (---------------)  + I seranishi
	0x00273608, // n0x0dd2 c0x0000 (---------------)  + I shinichi
	0x00305187, // n0x0dd3 c0x0000 (---------------)  + I shobara
	0x002ba6c8, // n0x0dd4 c0x0000 (---------------)  + I takehara
	0x00279dc8, // n0x0dd5 c0x0000 (---------------)  + I abashiri
	0x00272fc5, // n0x0dd6 c0x0000 (---------------)  + I abira
	0x003a2747, // n0x0dd7 c0x0000 (---------------)  + I aibetsu
	0x00272f47, // n0x0dd8 c0x0000 (---------------)  + I akabira
	0x002ff747, // n0x0dd9 c0x0000 (---------------)  + I akkeshi
	0x002b9ac9, // n0x0dda c0x0000 (---------------)  + I asahikawa
	0x00233a49, // n0x0ddb c0x0000 (---------------)  + I ashibetsu
	0x0023e146, // n0x0ddc c0x0000 (---------------)  + I ashoro
	0x002add06, // n0x0ddd c0x0000 (---------------)  + I assabu
	0x0025fe46, // n0x0dde c0x0000 (---------------)  + I atsuma
	0x00262005, // n0x0ddf c0x0000 (---------------)  + I bibai
	0x00272744, // n0x0de0 c0x0000 (---------------)  + I biei
	0x00200b06, // n0x0de1 c0x0000 (---------------)  + I bifuka
	0x00200e86, // n0x0de2 c0x0000 (---------------)  + I bihoro
	0x00273008, // n0x0de3 c0x0000 (---------------)  + I biratori
	0x002a44cb, // n0x0de4 c0x0000 (---------------)  + I chippubetsu
	0x002a8687, // n0x0de5 c0x0000 (---------------)  + I chitose
	0x0020b444, // n0x0de6 c0x0000 (---------------)  + I date
	0x0033bf46, // n0x0de7 c0x0000 (---------------)  + I ebetsu
	0x00276647, // n0x0de8 c0x0000 (---------------)  + I embetsu
	0x002ea945, // n0x0de9 c0x0000 (---------------)  + I eniwa
	0x0039acc5, // n0x0dea c0x0000 (---------------)  + I erimo
	0x002013c4, // n0x0deb c0x0000 (---------------)  + I esan
	0x002339c6, // n0x0dec c0x0000 (---------------)  + I esashi
	0x00200b88, // n0x0ded c0x0000 (---------------)  + I fukagawa
	0x003368c9, // n0x0dee c0x0000 (---------------)  + I fukushima
	0x00241b86, // n0x0def c0x0000 (---------------)  + I furano
	0x0027edc8, // n0x0df0 c0x0000 (---------------)  + I furubira
	0x00366c86, // n0x0df1 c0x0000 (---------------)  + I haboro
	0x00322a08, // n0x0df2 c0x0000 (---------------)  + I hakodate
	0x0029384c, // n0x0df3 c0x0000 (---------------)  + I hamatonbetsu
	0x00272e86, // n0x0df4 c0x0000 (---------------)  + I hidaka
	0x0028e3cd, // n0x0df5 c0x0000 (---------------)  + I higashikagura
	0x0028e84b, // n0x0df6 c0x0000 (---------------)  + I higashikawa
	0x00357e45, // n0x0df7 c0x0000 (---------------)  + I hiroo
	0x00202447, // n0x0df8 c0x0000 (---------------)  + I hokuryu
	0x00333346, // n0x0df9 c0x0000 (---------------)  + I hokuto
	0x002e0a08, // n0x0dfa c0x0000 (---------------)  + I honbetsu
	0x0023e1c9, // n0x0dfb c0x0000 (---------------)  + I horokanai
	0x002b8a08, // n0x0dfc c0x0000 (---------------)  + I horonobe
	0x00201785, // n0x0dfd c0x0000 (---------------)  + I ikeda
	0x002f2307, // n0x0dfe c0x0000 (---------------)  + I imakane
	0x00278508, // n0x0dff c0x0000 (---------------)  + I ishikari
	0x002fe849, // n0x0e00 c0x0000 (---------------)  + I iwamizawa
	0x00232f06, // n0x0e01 c0x0000 (---------------)  + I iwanai
	0x00241a8a, // n0x0e02 c0x0000 (---------------)  + I kamifurano
	0x002e0788, // n0x0e03 c0x0000 (---------------)  + I kamikawa
	0x002b884b, // n0x0e04 c0x0000 (---------------)  + I kamishihoro
	0x002812cc, // n0x0e05 c0x0000 (---------------)  + I kamisunagawa
	0x00247348, // n0x0e06 c0x0000 (---------------)  + I kamoenai
	0x00274586, // n0x0e07 c0x0000 (---------------)  + I kayabe
	0x003a3888, // n0x0e08 c0x0000 (---------------)  + I kembuchi
	0x00205487, // n0x0e09 c0x0000 (---------------)  + I kikonai
	0x00233cc9, // n0x0e0a c0x0000 (---------------)  + I kimobetsu
	0x002098cd, // n0x0e0b c0x0000 (---------------)  + I kitahiroshima
	0x00296946, // n0x0e0c c0x0000 (---------------)  + I kitami
	0x002a41c8, // n0x0e0d c0x0000 (---------------)  + I kiyosato
	0x00352ec9, // n0x0e0e c0x0000 (---------------)  + I koshimizu
	0x002aff88, // n0x0e0f c0x0000 (---------------)  + I kunneppu
	0x0027bec8, // n0x0e10 c0x0000 (---------------)  + I kuriyama
	0x002b324c, // n0x0e11 c0x0000 (---------------)  + I kuromatsunai
	0x002b43c7, // n0x0e12 c0x0000 (---------------)  + I kushiro
	0x002b5087, // n0x0e13 c0x0000 (---------------)  + I kutchan
	0x002b9905, // n0x0e14 c0x0000 (---------------)  + I kyowa
	0x00244387, // n0x0e15 c0x0000 (---------------)  + I mashike
	0x002ab248, // n0x0e16 c0x0000 (---------------)  + I matsumae
	0x0037b186, // n0x0e17 c0x0000 (---------------)  + I mikasa
	0x0024460c, // n0x0e18 c0x0000 (---------------)  + I minamifurano
	0x002dcdc8, // n0x0e19 c0x0000 (---------------)  + I mombetsu
	0x002c3e08, // n0x0e1a c0x0000 (---------------)  + I moseushi
	0x0025c686, // n0x0e1b c0x0000 (---------------)  + I mukawa
	0x00390287, // n0x0e1c c0x0000 (---------------)  + I muroran
	0x0023e344, // n0x0e1d c0x0000 (---------------)  + I naie
	0x002a7088, // n0x0e1e c0x0000 (---------------)  + I nakagawa
	0x0027da0c, // n0x0e1f c0x0000 (---------------)  + I nakasatsunai
	0x00213a4c, // n0x0e20 c0x0000 (---------------)  + I nakatombetsu
	0x00222305, // n0x0e21 c0x0000 (---------------)  + I nanae
	0x00383c87, // n0x0e22 c0x0000 (---------------)  + I nanporo
	0x00313786, // n0x0e23 c0x0000 (---------------)  + I nayoro
	0x00390206, // n0x0e24 c0x0000 (---------------)  + I nemuro
	0x0028f1c8, // n0x0e25 c0x0000 (---------------)  + I niikappu
	0x00201fc4, // n0x0e26 c0x0000 (---------------)  + I niki
	0x0022498b, // n0x0e27 c0x0000 (---------------)  + I nishiokoppe
	0x0031a58b, // n0x0e28 c0x0000 (---------------)  + I noboribetsu
	0x002aec06, // n0x0e29 c0x0000 (---------------)  + I numata
	0x00337d47, // n0x0e2a c0x0000 (---------------)  + I obihiro
	0x00336d85, // n0x0e2b c0x0000 (---------------)  + I obira
	0x00268245, // n0x0e2c c0x0000 (---------------)  + I oketo
	0x00224ac6, // n0x0e2d c0x0000 (---------------)  + I okoppe
	0x0026cf45, // n0x0e2e c0x0000 (---------------)  + I otaru
	0x002b92c5, // n0x0e2f c0x0000 (---------------)  + I otobe
	0x0039e0c7, // n0x0e30 c0x0000 (---------------)  + I otofuke
	0x00271649, // n0x0e31 c0x0000 (---------------)  + I otoineppu
	0x002debc4, // n0x0e32 c0x0000 (---------------)  + I oumu
	0x0026ffc5, // n0x0e33 c0x0000 (---------------)  + I ozora
	0x002d0405, // n0x0e34 c0x0000 (---------------)  + I pippu
	0x0027c548, // n0x0e35 c0x0000 (---------------)  + I rankoshi
	0x0026b145, // n0x0e36 c0x0000 (---------------)  + I rebun
	0x002a0889, // n0x0e37 c0x0000 (---------------)  + I rikubetsu
	0x0028bac7, // n0x0e38 c0x0000 (---------------)  + I rishiri
	0x0028bacb, // n0x0e39 c0x0000 (---------------)  + I rishirifuji
	0x00227606, // n0x0e3a c0x0000 (---------------)  + I saroma
	0x002241c9, // n0x0e3b c0x0000 (---------------)  + I sarufutsu
	0x00256548, // n0x0e3c c0x0000 (---------------)  + I shakotan
	0x0024acc5, // n0x0e3d c0x0000 (---------------)  + I shari
	0x002ff848, // n0x0e3e c0x0000 (---------------)  + I shibecha
	0x00233a88, // n0x0e3f c0x0000 (---------------)  + I shibetsu
	0x0020df87, // n0x0e40 c0x0000 (---------------)  + I shikabe
	0x0026d787, // n0x0e41 c0x0000 (---------------)  + I shikaoi
	0x00279549, // n0x0e42 c0x0000 (---------------)  + I shimamaki
	0x00227fc7, // n0x0e43 c0x0000 (---------------)  + I shimizu
	0x002528c9, // n0x0e44 c0x0000 (---------------)  + I shimokawa
	0x00280a8c, // n0x0e45 c0x0000 (---------------)  + I shinshinotsu
	0x0036fd88, // n0x0e46 c0x0000 (---------------)  + I shintoku
	0x0029d289, // n0x0e47 c0x0000 (---------------)  + I shiranuka
	0x0029ec47, // n0x0e48 c0x0000 (---------------)  + I shiraoi
	0x00279e89, // n0x0e49 c0x0000 (---------------)  + I shiriuchi
	0x00213047, // n0x0e4a c0x0000 (---------------)  + I sobetsu
	0x002813c8, // n0x0e4b c0x0000 (---------------)  + I sunagawa
	0x0027c885, // n0x0e4c c0x0000 (---------------)  + I taiki
	0x00317f06, // n0x0e4d c0x0000 (---------------)  + I takasu
	0x002b3b48, // n0x0e4e c0x0000 (---------------)  + I takikawa
	0x002ee648, // n0x0e4f c0x0000 (---------------)  + I takinoue
	0x002bb389, // n0x0e50 c0x0000 (---------------)  + I teshikaga
	0x002b9307, // n0x0e51 c0x0000 (---------------)  + I tobetsu
	0x00268bc5, // n0x0e52 c0x0000 (---------------)  + I tohma
	0x00204ac9, // n0x0e53 c0x0000 (---------------)  + I tomakomai
	0x00217fc6, // n0x0e54 c0x0000 (---------------)  + I tomari
	0x00287b04, // n0x0e55 c0x0000 (---------------)  + I toya
	0x00348cc6, // n0x0e56 c0x0000 (---------------)  + I toyako
	0x0025ef48, // n0x0e57 c0x0000 (---------------)  + I toyotomi
	0x00262a87, // n0x0e58 c0x0000 (---------------)  + I toyoura
	0x002a46c8, // n0x0e59 c0x0000 (---------------)  + I tsubetsu
	0x00218d09, // n0x0e5a c0x0000 (---------------)  + I tsukigata
	0x0025c407, // n0x0e5b c0x0000 (---------------)  + I urakawa
	0x002967c6, // n0x0e5c c0x0000 (---------------)  + I urausu
	0x00202504, // n0x0e5d c0x0000 (---------------)  + I uryu
	0x00209189, // n0x0e5e c0x0000 (---------------)  + I utashinai
	0x003a3d08, // n0x0e5f c0x0000 (---------------)  + I wakkanai
	0x0025c547, // n0x0e60 c0x0000 (---------------)  + I wassamu
	0x00325946, // n0x0e61 c0x0000 (---------------)  + I yakumo
	0x0039b306, // n0x0e62 c0x0000 (---------------)  + I yoichi
	0x00398584, // n0x0e63 c0x0000 (---------------)  + I aioi
	0x002a2006, // n0x0e64 c0x0000 (---------------)  + I akashi
	0x00204b83, // n0x0e65 c0x0000 (---------------)  + I ako
	0x003384c9, // n0x0e66 c0x0000 (---------------)  + I amagasaki
	0x00201bc6, // n0x0e67 c0x0000 (---------------)  + I aogaki
	0x002941c5, // n0x0e68 c0x0000 (---------------)  + I asago
	0x00296cc6, // n0x0e69 c0x0000 (---------------)  + I ashiya
	0x0029c8c5, // n0x0e6a c0x0000 (---------------)  + I awaji
	0x00278988, // n0x0e6b c0x0000 (---------------)  + I fukusaki
	0x00247087, // n0x0e6c c0x0000 (---------------)  + I goshiki
	0x0020dc06, // n0x0e6d c0x0000 (---------------)  + I harima
	0x00343046, // n0x0e6e c0x0000 (---------------)  + I himeji
	0x0032d348, // n0x0e6f c0x0000 (---------------)  + I ichikawa
	0x00298e07, // n0x0e70 c0x0000 (---------------)  + I inagawa
	0x00296985, // n0x0e71 c0x0000 (---------------)  + I itami
	0x002971c8, // n0x0e72 c0x0000 (---------------)  + I kakogawa
	0x0036fac8, // n0x0e73 c0x0000 (---------------)  + I kamigori
	0x002e0788, // n0x0e74 c0x0000 (---------------)  + I kamikawa
	0x00224605, // n0x0e75 c0x0000 (---------------)  + I kasai
	0x00317f86, // n0x0e76 c0x0000 (---------------)  + I kasuga
	0x002b8dc9, // n0x0e77 c0x0000 (---------------)  + I kawanishi
	0x00288044, // n0x0e78 c0x0000 (---------------)  + I miki
	0x0036640b, // n0x0e79 c0x0000 (---------------)  + I minamiawaji
	0x0021b04b, // n0x0e7a c0x0000 (---------------)  + I nishinomiya
	0x00228689, // n0x0e7b c0x0000 (---------------)  + I nishiwaki
	0x0020f703, // n0x0e7c c0x0000 (---------------)  + I ono
	0x00252f45, // n0x0e7d c0x0000 (---------------)  + I sanda
	0x00201e86, // n0x0e7e c0x0000 (---------------)  + I sannan
	0x00225508, // n0x0e7f c0x0000 (---------------)  + I sasayama
	0x002ae744, // n0x0e80 c0x0000 (---------------)  + I sayo
	0x002deec6, // n0x0e81 c0x0000 (---------------)  + I shingu
	0x002c6b49, // n0x0e82 c0x0000 (---------------)  + I shinonsen
	0x002b6385, // n0x0e83 c0x0000 (---------------)  + I shiso
	0x0039e006, // n0x0e84 c0x0000 (---------------)  + I sumoto
	0x00214106, // n0x0e85 c0x0000 (---------------)  + I taishi
	0x00216f04, // n0x0e86 c0x0000 (---------------)  + I taka
	0x0028ee0a, // n0x0e87 c0x0000 (---------------)  + I takarazuka
	0x00294108, // n0x0e88 c0x0000 (---------------)  + I takasago
	0x002ee646, // n0x0e89 c0x0000 (---------------)  + I takino
	0x0038c945, // n0x0e8a c0x0000 (---------------)  + I tamba
	0x0020c247, // n0x0e8b c0x0000 (---------------)  + I tatsuno
	0x00254807, // n0x0e8c c0x0000 (---------------)  + I toyooka
	0x0034d4c4, // n0x0e8d c0x0000 (---------------)  + I yabu
	0x0021b287, // n0x0e8e c0x0000 (---------------)  + I yashiro
	0x002427c4, // n0x0e8f c0x0000 (---------------)  + I yoka
	0x002427c6, // n0x0e90 c0x0000 (---------------)  + I yokawa
	0x00206403, // n0x0e91 c0x0000 (---------------)  + I ami
	0x002b9ac5, // n0x0e92 c0x0000 (---------------)  + I asahi
	0x00347f05, // n0x0e93 c0x0000 (---------------)  + I bando
	0x00214488, // n0x0e94 c0x0000 (---------------)  + I chikusei
	0x0020cc85, // n0x0e95 c0x0000 (---------------)  + I daigo
	0x00272bc9, // n0x0e96 c0x0000 (---------------)  + I fujishiro
	0x0029c147, // n0x0e97 c0x0000 (---------------)  + I hitachi
	0x002a6ecb, // n0x0e98 c0x0000 (---------------)  + I hitachinaka
	0x0029c14c, // n0x0e99 c0x0000 (---------------)  + I hitachiomiya
	0x0029cdca, // n0x0e9a c0x0000 (---------------)  + I hitachiota
	0x002bcc07, // n0x0e9b c0x0000 (---------------)  + I ibaraki
	0x00208583, // n0x0e9c c0x0000 (---------------)  + I ina
	0x00344608, // n0x0e9d c0x0000 (---------------)  + I inashiki
	0x002247c5, // n0x0e9e c0x0000 (---------------)  + I itako
	0x002b5d05, // n0x0e9f c0x0000 (---------------)  + I iwama
	0x00329684, // n0x0ea0 c0x0000 (---------------)  + I joso
	0x002812c6, // n0x0ea1 c0x0000 (---------------)  + I kamisu
	0x0022e446, // n0x0ea2 c0x0000 (---------------)  + I kasama
	0x002a2047, // n0x0ea3 c0x0000 (---------------)  + I kashima
	0x0020404b, // n0x0ea4 c0x0000 (---------------)  + I kasumigaura
	0x0021f544, // n0x0ea5 c0x0000 (---------------)  + I koga
	0x00371e04, // n0x0ea6 c0x0000 (---------------)  + I miho
	0x00260384, // n0x0ea7 c0x0000 (---------------)  + I mito
	0x002c2286, // n0x0ea8 c0x0000 (---------------)  + I moriya
	0x00211d84, // n0x0ea9 c0x0000 (---------------)  + I naka
	0x002ba188, // n0x0eaa c0x0000 (---------------)  + I namegata
	0x00329485, // n0x0eab c0x0000 (---------------)  + I oarai
	0x0023ecc5, // n0x0eac c0x0000 (---------------)  + I ogawa
	0x002cff87, // n0x0ead c0x0000 (---------------)  + I omitama
	0x00202549, // n0x0eae c0x0000 (---------------)  + I ryugasaki
	0x00348a85, // n0x0eaf c0x0000 (---------------)  + I sakai
	0x0036cf4a, // n0x0eb0 c0x0000 (---------------)  + I sakuragawa
	0x002ab4c9, // n0x0eb1 c0x0000 (---------------)  + I shimodate
	0x0026400a, // n0x0eb2 c0x0000 (---------------)  + I shimotsuma
	0x0038fdc9, // n0x0eb3 c0x0000 (---------------)  + I shirosato
	0x00324d84, // n0x0eb4 c0x0000 (---------------)  + I sowa
	0x002edac5, // n0x0eb5 c0x0000 (---------------)  + I suifu
	0x002a3508, // n0x0eb6 c0x0000 (---------------)  + I takahagi
	0x00349a4b, // n0x0eb7 c0x0000 (---------------)  + I tamatsukuri
	0x002efe85, // n0x0eb8 c0x0000 (---------------)  + I tokai
	0x0027f8c6, // n0x0eb9 c0x0000 (---------------)  + I tomobe
	0x00229604, // n0x0eba c0x0000 (---------------)  + I tone
	0x00273106, // n0x0ebb c0x0000 (---------------)  + I toride
	0x0025c289, // n0x0ebc c0x0000 (---------------)  + I tsuchiura
	0x0033c007, // n0x0ebd c0x0000 (---------------)  + I tsukuba
	0x003054c8, // n0x0ebe c0x0000 (---------------)  + I uchihara
	0x0023ea06, // n0x0ebf c0x0000 (---------------)  + I ushiku
	0x002dfb47, // n0x0ec0 c0x0000 (---------------)  + I yachiyo
	0x00279248, // n0x0ec1 c0x0000 (---------------)  + I yamagata
	0x0037e586, // n0x0ec2 c0x0000 (---------------)  + I yawara
	0x002431c4, // n0x0ec3 c0x0000 (---------------)  + I yuki
	0x00358787, // n0x0ec4 c0x0000 (---------------)  + I anamizu
	0x00332285, // n0x0ec5 c0x0000 (---------------)  + I hakui
	0x00340ac7, // n0x0ec6 c0x0000 (---------------)  + I hakusan
	0x00200c04, // n0x0ec7 c0x0000 (---------------)  + I kaga
	0x003332c6, // n0x0ec8 c0x0000 (---------------)  + I kahoku
	0x002198c8, // n0x0ec9 c0x0000 (---------------)  + I kanazawa
	0x0028ea08, // n0x0eca c0x0000 (---------------)  + I kawakita
	0x002e1e07, // n0x0ecb c0x0000 (---------------)  + I komatsu
	0x003395c8, // n0x0ecc c0x0000 (---------------)  + I nakanoto
	0x0028cac5, // n0x0ecd c0x0000 (---------------)  + I nanao
	0x0020f544, // n0x0ece c0x0000 (---------------)  + I nomi
	0x0032d248, // n0x0ecf c0x0000 (---------------)  + I nonoichi
	0x00254204, // n0x0ed0 c0x0000 (---------------)  + I noto
	0x0020df85, // n0x0ed1 c0x0000 (---------------)  + I shika
	0x002e2944, // n0x0ed2 c0x0000 (---------------)  + I suzu
	0x0034e4c7, // n0x0ed3 c0x0000 (---------------)  + I tsubata
	0x00282d47, // n0x0ed4 c0x0000 (---------------)  + I tsurugi
	0x00279fc8, // n0x0ed5 c0x0000 (---------------)  + I uchinada
	0x0029c906, // n0x0ed6 c0x0000 (---------------)  + I wajima
	0x0020cc05, // n0x0ed7 c0x0000 (---------------)  + I fudai
	0x002729c8, // n0x0ed8 c0x0000 (---------------)  + I fujisawa
	0x0024eb08, // n0x0ed9 c0x0000 (---------------)  + I hanamaki
	0x00298689, // n0x0eda c0x0000 (---------------)  + I hiraizumi
	0x0021b346, // n0x0edb c0x0000 (---------------)  + I hirono
	0x002301c8, // n0x0edc c0x0000 (---------------)  + I ichinohe
	0x0027a74a, // n0x0edd c0x0000 (---------------)  + I ichinoseki
	0x002ea9c8, // n0x0ede c0x0000 (---------------)  + I iwaizumi
	0x002d0b85, // n0x0edf c0x0000 (---------------)  + I iwate
	0x00222a46, // n0x0ee0 c0x0000 (---------------)  + I joboji
	0x00287108, // n0x0ee1 c0x0000 (---------------)  + I kamaishi
	0x002f23ca, // n0x0ee2 c0x0000 (---------------)  + I kanegasaki
	0x002fe107, // n0x0ee3 c0x0000 (---------------)  + I karumai
	0x00280645, // n0x0ee4 c0x0000 (---------------)  + I kawai
	0x0028da08, // n0x0ee5 c0x0000 (---------------)  + I kitakami
	0x002f5c44, // n0x0ee6 c0x0000 (---------------)  + I kuji
	0x00366e06, // n0x0ee7 c0x0000 (---------------)  + I kunohe
	0x002b5808, // n0x0ee8 c0x0000 (---------------)  + I kuzumaki
	0x0020f5c6, // n0x0ee9 c0x0000 (---------------)  + I miyako
	0x00368e08, // n0x0eea c0x0000 (---------------)  + I mizusawa
	0x00218587, // n0x0eeb c0x0000 (---------------)  + I morioka
	0x00208306, // n0x0eec c0x0000 (---------------)  + I ninohe
	0x00376fc4, // n0x0eed c0x0000 (---------------)  + I noda
	0x002b0647, // n0x0eee c0x0000 (---------------)  + I ofunato
	0x002eb8c4, // n0x0eef c0x0000 (---------------)  + I oshu
	0x0025c247, // n0x0ef0 c0x0000 (---------------)  + I otsuchi
	0x0039a00d, // n0x0ef1 c0x0000 (---------------)  + I rikuzentakata
	0x00228705, // n0x0ef2 c0x0000 (---------------)  + I shiwa
	0x00312dcb, // n0x0ef3 c0x0000 (---------------)  + I shizukuishi
	0x0029a7c6, // n0x0ef4 c0x0000 (---------------)  + I sumita
	0x0024c288, // n0x0ef5 c0x0000 (---------------)  + I tanohata
	0x0037f184, // n0x0ef6 c0x0000 (---------------)  + I tono
	0x0026fd86, // n0x0ef7 c0x0000 (---------------)  + I yahaba
	0x00274e46, // n0x0ef8 c0x0000 (---------------)  + I yamada
	0x003a3bc7, // n0x0ef9 c0x0000 (---------------)  + I ayagawa
	0x0028e08d, // n0x0efa c0x0000 (---------------)  + I higashikagawa
	0x002388c7, // n0x0efb c0x0000 (---------------)  + I kanonji
	0x0032f488, // n0x0efc c0x0000 (---------------)  + I kotohira
	0x00359b85, // n0x0efd c0x0000 (---------------)  + I manno
	0x00290088, // n0x0efe c0x0000 (---------------)  + I marugame
	0x002bacc6, // n0x0eff c0x0000 (---------------)  + I mitoyo
	0x0028cb48, // n0x0f00 c0x0000 (---------------)  + I naoshima
	0x00211046, // n0x0f01 c0x0000 (---------------)  + I sanuki
	0x003362c7, // n0x0f02 c0x0000 (---------------)  + I tadotsu
	0x0021c389, // n0x0f03 c0x0000 (---------------)  + I takamatsu
	0x0037f187, // n0x0f04 c0x0000 (---------------)  + I tonosho
	0x00281f08, // n0x0f05 c0x0000 (---------------)  + I uchinomi
	0x0026c5c5, // n0x0f06 c0x0000 (---------------)  + I utazu
	0x0021a9c8, // n0x0f07 c0x0000 (---------------)  + I zentsuji
	0x00336e85, // n0x0f08 c0x0000 (---------------)  + I akune
	0x0023b1c5, // n0x0f09 c0x0000 (---------------)  + I amami
	0x0027fc45, // n0x0f0a c0x0000 (---------------)  + I hioki
	0x00222583, // n0x0f0b c0x0000 (---------------)  + I isa
	0x0027b2c4, // n0x0f0c c0x0000 (---------------)  + I isen
	0x0026d905, // n0x0f0d c0x0000 (---------------)  + I izumi
	0x00267809, // n0x0f0e c0x0000 (---------------)  + I kagoshima
	0x002a90c6, // n0x0f0f c0x0000 (---------------)  + I kanoya
	0x002c0d08, // n0x0f10 c0x0000 (---------------)  + I kawanabe
	0x002f25c5, // n0x0f11 c0x0000 (---------------)  + I kinko
	0x00320d07, // n0x0f12 c0x0000 (---------------)  + I kouyama
	0x003365ca, // n0x0f13 c0x0000 (---------------)  + I makurazaki
	0x0039df49, // n0x0f14 c0x0000 (---------------)  + I matsumoto
	0x002a100a, // n0x0f15 c0x0000 (---------------)  + I minamitane
	0x002c7648, // n0x0f16 c0x0000 (---------------)  + I nakatane
	0x0021bc4c, // n0x0f17 c0x0000 (---------------)  + I nishinoomote
	0x0027afcd, // n0x0f18 c0x0000 (---------------)  + I satsumasendai
	0x002e6e83, // n0x0f19 c0x0000 (---------------)  + I soo
	0x00368d08, // n0x0f1a c0x0000 (---------------)  + I tarumizu
	0x002010c5, // n0x0f1b c0x0000 (---------------)  + I yusui
	0x003a3e86, // n0x0f1c c0x0000 (---------------)  + I aikawa
	0x00371a06, // n0x0f1d c0x0000 (---------------)  + I atsugi
	0x00240a05, // n0x0f1e c0x0000 (---------------)  + I ayase
	0x002867c9, // n0x0f1f c0x0000 (---------------)  + I chigasaki
	0x002d51c5, // n0x0f20 c0x0000 (---------------)  + I ebina
	0x002729c8, // n0x0f21 c0x0000 (---------------)  + I fujisawa
	0x00254106, // n0x0f22 c0x0000 (---------------)  + I hadano
	0x00323306, // n0x0f23 c0x0000 (---------------)  + I hakone
	0x00299f49, // n0x0f24 c0x0000 (---------------)  + I hiratsuka
	0x0037dd87, // n0x0f25 c0x0000 (---------------)  + I isehara
	0x002f1c86, // n0x0f26 c0x0000 (---------------)  + I kaisei
	0x00336548, // n0x0f27 c0x0000 (---------------)  + I kamakura
	0x00392ac8, // n0x0f28 c0x0000 (---------------)  + I kiyokawa
	0x00353547, // n0x0f29 c0x0000 (---------------)  + I matsuda
	0x0022820e, // n0x0f2a c0x0000 (---------------)  + I minamiashigara
	0x002baf05, // n0x0f2b c0x0000 (---------------)  + I miura
	0x002fe745, // n0x0f2c c0x0000 (---------------)  + I nakai
	0x0020f4c8, // n0x0f2d c0x0000 (---------------)  + I ninomiya
	0x0039c547, // n0x0f2e c0x0000 (---------------)  + I odawara
	0x00238042, // n0x0f2f c0x0000 (---------------)  + I oi
	0x002b2dc4, // n0x0f30 c0x0000 (---------------)  + I oiso
	0x0020634a, // n0x0f31 c0x0000 (---------------)  + I sagamihara
	0x0025c608, // n0x0f32 c0x0000 (---------------)  + I samukawa
	0x00276746, // n0x0f33 c0x0000 (---------------)  + I tsukui
	0x00290788, // n0x0f34 c0x0000 (---------------)  + I yamakita
	0x002881c6, // n0x0f35 c0x0000 (---------------)  + I yamato
	0x003193c8, // n0x0f36 c0x0000 (---------------)  + I yokosuka
	0x002a6788, // n0x0f37 c0x0000 (---------------)  + I yugawara
	0x0023b184, // n0x0f38 c0x0000 (---------------)  + I zama
	0x00324185, // n0x0f39 c0x0000 (---------------)  + I zushi
	0x006808c4, // n0x0f3a c0x0001 (---------------)  ! I city
	0x006808c4, // n0x0f3b c0x0001 (---------------)  ! I city
	0x006808c4, // n0x0f3c c0x0001 (---------------)  ! I city
	0x00201c83, // n0x0f3d c0x0000 (---------------)  + I aki
	0x0039b186, // n0x0f3e c0x0000 (---------------)  + I geisei
	0x00272e86, // n0x0f3f c0x0000 (---------------)  + I hidaka
	0x0029600c, // n0x0f40 c0x0000 (---------------)  + I higashitsuno
	0x00208343, // n0x0f41 c0x0000 (---------------)  + I ino
	0x002b6cc6, // n0x0f42 c0x0000 (---------------)  + I kagami
	0x00211e04, // n0x0f43 c0x0000 (---------------)  + I kami
	0x002bcd48, // n0x0f44 c0x0000 (---------------)  + I kitagawa
	0x002c6985, // n0x0f45 c0x0000 (---------------)  + I kochi
	0x00206446, // n0x0f46 c0x0000 (---------------)  + I mihara
	0x002ad4c8, // n0x0f47 c0x0000 (---------------)  + I motoyama
	0x002c89c6, // n0x0f48 c0x0000 (---------------)  + I muroto
	0x0020db86, // n0x0f49 c0x0000 (---------------)  + I nahari
	0x00359808, // n0x0f4a c0x0000 (---------------)  + I nakamura
	0x0029aa47, // n0x0f4b c0x0000 (---------------)  + I nankoku
	0x00227d89, // n0x0f4c c0x0000 (---------------)  + I nishitosa
	0x0030ba0a, // n0x0f4d c0x0000 (---------------)  + I niyodogawa
	0x00248bc4, // n0x0f4e c0x0000 (---------------)  + I ochi
	0x00242805, // n0x0f4f c0x0000 (---------------)  + I okawa
	0x00255785, // n0x0f50 c0x0000 (---------------)  + I otoyo
	0x0021bf86, // n0x0f51 c0x0000 (---------------)  + I otsuki
	0x0024dbc6, // n0x0f52 c0x0000 (---------------)  + I sakawa
	0x002a0446, // n0x0f53 c0x0000 (---------------)  + I sukumo
	0x002e1b06, // n0x0f54 c0x0000 (---------------)  + I susaki
	0x00227ec4, // n0x0f55 c0x0000 (---------------)  + I tosa
	0x00227ecb, // n0x0f56 c0x0000 (---------------)  + I tosashimizu
	0x00242744, // n0x0f57 c0x0000 (---------------)  + I toyo
	0x0020c2c5, // n0x0f58 c0x0000 (---------------)  + I tsuno
	0x002a53c5, // n0x0f59 c0x0000 (---------------)  + I umaji
	0x0026dc86, // n0x0f5a c0x0000 (---------------)  + I yasuda
	0x00398a08, // n0x0f5b c0x0000 (---------------)  + I yusuhara
	0x0027ae87, // n0x0f5c c0x0000 (---------------)  + I amakusa
	0x00305284, // n0x0f5d c0x0000 (---------------)  + I arao
	0x00245803, // n0x0f5e c0x0000 (---------------)  + I aso
	0x002f5745, // n0x0f5f c0x0000 (---------------)  + I choyo
	0x00243a47, // n0x0f60 c0x0000 (---------------)  + I gyokuto
	0x0029da09, // n0x0f61 c0x0000 (---------------)  + I hitoyoshi
	0x0027ad8b, // n0x0f62 c0x0000 (---------------)  + I kamiamakusa
	0x002a2047, // n0x0f63 c0x0000 (---------------)  + I kashima
	0x00214387, // n0x0f64 c0x0000 (---------------)  + I kikuchi
	0x002d6d84, // n0x0f65 c0x0000 (---------------)  + I kosa
	0x002ad3c8, // n0x0f66 c0x0000 (---------------)  + I kumamoto
	0x002e2087, // n0x0f67 c0x0000 (---------------)  + I mashiki
	0x0029dc46, // n0x0f68 c0x0000 (---------------)  + I mifune
	0x00242f48, // n0x0f69 c0x0000 (---------------)  + I minamata
	0x00282f0b, // n0x0f6a c0x0000 (---------------)  + I minamioguni
	0x0037b906, // n0x0f6b c0x0000 (---------------)  + I nagasu
	0x00212509, // n0x0f6c c0x0000 (---------------)  + I nishihara
	0x00283085, // n0x0f6d c0x0000 (---------------)  + I oguni
	0x002f66c3, // n0x0f6e c0x0000 (---------------)  + I ozu
	0x0039e006, // n0x0f6f c0x0000 (---------------)  + I sumoto
	0x00218488, // n0x0f70 c0x0000 (---------------)  + I takamori
	0x00211103, // n0x0f71 c0x0000 (---------------)  + I uki
	0x0021dcc3, // n0x0f72 c0x0000 (---------------)  + I uto
	0x00279246, // n0x0f73 c0x0000 (---------------)  + I yamaga
	0x002881c6, // n0x0f74 c0x0000 (---------------)  + I yamato
	0x0037a38a, // n0x0f75 c0x0000 (---------------)  + I yatsushiro
	0x002745c5, // n0x0f76 c0x0000 (---------------)  + I ayabe
	0x00274c8b, // n0x0f77 c0x0000 (---------------)  + I fukuchiyama
	0x00296c0b, // n0x0f78 c0x0000 (---------------)  + I higashiyama
	0x00238083, // n0x0f79 c0x0000 (---------------)  + I ide
	0x0021b683, // n0x0f7a c0x0000 (---------------)  + I ine
	0x002a7c04, // n0x0f7b c0x0000 (---------------)  + I joyo
	0x00218887, // n0x0f7c c0x0000 (---------------)  + I kameoka
	0x00218504, // n0x0f7d c0x0000 (---------------)  + I kamo
	0x00202704, // n0x0f7e c0x0000 (---------------)  + I kita
	0x002ebc44, // n0x0f7f c0x0000 (---------------)  + I kizu
	0x002eacc8, // n0x0f80 c0x0000 (---------------)  + I kumiyama
	0x0038c888, // n0x0f81 c0x0000 (---------------)  + I kyotamba
	0x002fdac9, // n0x0f82 c0x0000 (---------------)  + I kyotanabe
	0x0033f708, // n0x0f83 c0x0000 (---------------)  + I kyotango
	0x002cbc87, // n0x0f84 c0x0000 (---------------)  + I maizuru
	0x00228206, // n0x0f85 c0x0000 (---------------)  + I minami
	0x002c094f, // n0x0f86 c0x0000 (---------------)  + I minamiyamashiro
	0x002bb046, // n0x0f87 c0x0000 (---------------)  + I miyazu
	0x002c6904, // n0x0f88 c0x0000 (---------------)  + I muko
	0x0038c6ca, // n0x0f89 c0x0000 (---------------)  + I nagaokakyo
	0x00243947, // n0x0f8a c0x0000 (---------------)  + I nakagyo
	0x00207f46, // n0x0f8b c0x0000 (---------------)  + I nantan
	0x00287b49, // n0x0f8c c0x0000 (---------------)  + I oyamazaki
	0x002fda45, // n0x0f8d c0x0000 (---------------)  + I sakyo
	0x002145c5, // n0x0f8e c0x0000 (---------------)  + I seika
	0x002fdb86, // n0x0f8f c0x0000 (---------------)  + I tanabe
	0x0021ab03, // n0x0f90 c0x0000 (---------------)  + I uji
	0x002f5c89, // n0x0f91 c0x0000 (---------------)  + I ujitawara
	0x002197c6, // n0x0f92 c0x0000 (---------------)  + I wazuka
	0x00218ac9, // n0x0f93 c0x0000 (---------------)  + I yamashina
	0x003883c6, // n0x0f94 c0x0000 (---------------)  + I yawata
	0x002b9ac5, // n0x0f95 c0x0000 (---------------)  + I asahi
	0x00222705, // n0x0f96 c0x0000 (---------------)  + I inabe
	0x00205343, // n0x0f97 c0x0000 (---------------)  + I ise
	0x002189c8, // n0x0f98 c0x0000 (---------------)  + I kameyama
	0x00387f07, // n0x0f99 c0x0000 (---------------)  + I kawagoe
	0x002ea684, // n0x0f9a c0x0000 (---------------)  + I kiho
	0x0021c088, // n0x0f9b c0x0000 (---------------)  + I kisosaki
	0x0029d584, // n0x0f9c c0x0000 (---------------)  + I kiwa
	0x002b4246, // n0x0f9d c0x0000 (---------------)  + I komono
	0x0027d286, // n0x0f9e c0x0000 (---------------)  + I kumano
	0x0023d486, // n0x0f9f c0x0000 (---------------)  + I kuwana
	0x002c2409, // n0x0fa0 c0x0000 (---------------)  + I matsusaka
	0x002b5c85, // n0x0fa1 c0x0000 (---------------)  + I meiwa
	0x0029d806, // n0x0fa2 c0x0000 (---------------)  + I mihama
	0x00254509, // n0x0fa3 c0x0000 (---------------)  + I minamiise
	0x002b9f06, // n0x0fa4 c0x0000 (---------------)  + I misugi
	0x002c0a46, // n0x0fa5 c0x0000 (---------------)  + I miyama
	0x00377346, // n0x0fa6 c0x0000 (---------------)  + I nabari
	0x00209ac5, // n0x0fa7 c0x0000 (---------------)  + I shima
	0x002e2946, // n0x0fa8 c0x0000 (---------------)  + I suzuka
	0x003362c4, // n0x0fa9 c0x0000 (---------------)  + I tado
	0x0027c885, // n0x0faa c0x0000 (---------------)  + I taiki
	0x002b3b44, // n0x0fab c0x0000 (---------------)  + I taki
	0x002fab46, // n0x0fac c0x0000 (---------------)  + I tamaki
	0x0038ff84, // n0x0fad c0x0000 (---------------)  + I toba
	0x0020c2c3, // n0x0fae c0x0000 (---------------)  + I tsu
	0x00280305, // n0x0faf c0x0000 (---------------)  + I udono
	0x00233788, // n0x0fb0 c0x0000 (---------------)  + I ureshino
	0x00223b87, // n0x0fb1 c0x0000 (---------------)  + I watarai
	0x002abe49, // n0x0fb2 c0x0000 (---------------)  + I yokkaichi
	0x00280548, // n0x0fb3 c0x0000 (---------------)  + I furukawa
	0x0028fcd1, // n0x0fb4 c0x0000 (---------------)  + I higashimatsushima
	0x0021418a, // n0x0fb5 c0x0000 (---------------)  + I ishinomaki
	0x002aeb47, // n0x0fb6 c0x0000 (---------------)  + I iwanuma
	0x0037be86, // n0x0fb7 c0x0000 (---------------)  + I kakuda
	0x00211e04, // n0x0fb8 c0x0000 (---------------)  + I kami
	0x002b3c48, // n0x0fb9 c0x0000 (---------------)  + I kawasaki
	0x00289a89, // n0x0fba c0x0000 (---------------)  + I kesennuma
	0x002a2188, // n0x0fbb c0x0000 (---------------)  + I marumori
	0x0028fe8a, // n0x0fbc c0x0000 (---------------)  + I matsushima
	0x002a064d, // n0x0fbd c0x0000 (---------------)  + I minamisanriku
	0x00298846, // n0x0fbe c0x0000 (---------------)  + I misato
	0x00359906, // n0x0fbf c0x0000 (---------------)  + I murata
	0x002b0706, // n0x0fc0 c0x0000 (---------------)  + I natori
	0x00357887, // n0x0fc1 c0x0000 (---------------)  + I ogawara
	0x00298b45, // n0x0fc2 c0x0000 (---------------)  + I ohira
	0x0034d287, // n0x0fc3 c0x0000 (---------------)  + I onagawa
	0x0021c145, // n0x0fc4 c0x0000 (---------------)  + I osaki
	0x0028bc04, // n0x0fc5 c0x0000 (---------------)  + I rifu
	0x002a2846, // n0x0fc6 c0x0000 (---------------)  + I semine
	0x00317dc7, // n0x0fc7 c0x0000 (---------------)  + I shibata
	0x002f598d, // n0x0fc8 c0x0000 (---------------)  + I shichikashuku
	0x00287047, // n0x0fc9 c0x0000 (---------------)  + I shikama
	0x00260648, // n0x0fca c0x0000 (---------------)  + I shiogama
	0x00272cc9, // n0x0fcb c0x0000 (---------------)  + I shiroishi
	0x00222946, // n0x0fcc c0x0000 (---------------)  + I tagajo
	0x00232e85, // n0x0fcd c0x0000 (---------------)  + I taiwa
	0x00212904, // n0x0fce c0x0000 (---------------)  + I tome
	0x0025f046, // n0x0fcf c0x0000 (---------------)  + I tomiya
	0x0034d3c6, // n0x0fd0 c0x0000 (---------------)  + I wakuya
	0x0025c786, // n0x0fd1 c0x0000 (---------------)  + I watari
	0x00293388, // n0x0fd2 c0x0000 (---------------)  + I yamamoto
	0x00210a83, // n0x0fd3 c0x0000 (---------------)  + I zao
	0x0020fa43, // n0x0fd4 c0x0000 (---------------)  + I aya
	0x00319785, // n0x0fd5 c0x0000 (---------------)  + I ebino
	0x0022e8c6, // n0x0fd6 c0x0000 (---------------)  + I gokase
	0x002a6745, // n0x0fd7 c0x0000 (---------------)  + I hyuga
	0x0023ec08, // n0x0fd8 c0x0000 (---------------)  + I kadogawa
	0x002959ca, // n0x0fd9 c0x0000 (---------------)  + I kawaminami
	0x002bc144, // n0x0fda c0x0000 (---------------)  + I kijo
	0x002bcd48, // n0x0fdb c0x0000 (---------------)  + I kitagawa
	0x0028ec88, // n0x0fdc c0x0000 (---------------)  + I kitakata
	0x0026dac7, // n0x0fdd c0x0000 (---------------)  + I kitaura
	0x002f2689, // n0x0fde c0x0000 (---------------)  + I kobayashi
	0x002ad0c8, // n0x0fdf c0x0000 (---------------)  + I kunitomi
	0x00336947, // n0x0fe0 c0x0000 (---------------)  + I kushima
	0x002949c6, // n0x0fe1 c0x0000 (---------------)  + I mimata
	0x0020f5ca, // n0x0fe2 c0x0000 (---------------)  + I miyakonojo
	0x0025f0c8, // n0x0fe3 c0x0000 (---------------)  + I miyazaki
	0x002b8689, // n0x0fe4 c0x0000 (---------------)  + I morotsuka
	0x002736c8, // n0x0fe5 c0x0000 (---------------)  + I nichinan
	0x0021a709, // n0x0fe6 c0x0000 (---------------)  + I nishimera
	0x002b8b07, // n0x0fe7 c0x0000 (---------------)  + I nobeoka
	0x0033f5c5, // n0x0fe8 c0x0000 (---------------)  + I saito
	0x0029b4c6, // n0x0fe9 c0x0000 (---------------)  + I shiiba
	0x0037b008, // n0x0fea c0x0000 (---------------)  + I shintomi
	0x0024c408, // n0x0feb c0x0000 (---------------)  + I takaharu
	0x00218ec8, // n0x0fec c0x0000 (---------------)  + I takanabe
	0x00216f08, // n0x0fed c0x0000 (---------------)  + I takazaki
	0x0020c2c5, // n0x0fee c0x0000 (---------------)  + I tsuno
	0x0020af04, // n0x0fef c0x0000 (---------------)  + I achi
	0x00387c08, // n0x0ff0 c0x0000 (---------------)  + I agematsu
	0x00208044, // n0x0ff1 c0x0000 (---------------)  + I anan
	0x0038fbc4, // n0x0ff2 c0x0000 (---------------)  + I aoki
	0x002b9ac5, // n0x0ff3 c0x0000 (---------------)  + I asahi
	0x0028a547, // n0x0ff4 c0x0000 (---------------)  + I azumino
	0x00202309, // n0x0ff5 c0x0000 (---------------)  + I chikuhoku
	0x003a39c7, // n0x0ff6 c0x0000 (---------------)  + I chikuma
	0x0020af45, // n0x0ff7 c0x0000 (---------------)  + I chino
	0x00271246, // n0x0ff8 c0x0000 (---------------)  + I fujimi
	0x0032e506, // n0x0ff9 c0x0000 (---------------)  + I hakuba
	0x002064c4, // n0x0ffa c0x0000 (---------------)  + I hara
	0x0029a286, // n0x0ffb c0x0000 (---------------)  + I hiraya
	0x0020ca44, // n0x0ffc c0x0000 (---------------)  + I iida
	0x00250a46, // n0x0ffd c0x0000 (---------------)  + I iijima
	0x00397fc6, // n0x0ffe c0x0000 (---------------)  + I iiyama
	0x002154c6, // n0x0fff c0x0000 (---------------)  + I iizuna
	0x00201785, // n0x1000 c0x0000 (---------------)  + I ikeda
	0x0023eac7, // n0x1001 c0x0000 (---------------)  + I ikusaka
	0x00208583, // n0x1002 c0x0000 (---------------)  + I ina
	0x00395609, // n0x1003 c0x0000 (---------------)  + I karuizawa
	0x002f1988, // n0x1004 c0x0000 (---------------)  + I kawakami
	0x0021c084, // n0x1005 c0x0000 (---------------)  + I kiso
	0x003367cd, // n0x1006 c0x0000 (---------------)  + I kisofukushima
	0x0028eb08, // n0x1007 c0x0000 (---------------)  + I kitaaiki
	0x0028a308, // n0x1008 c0x0000 (---------------)  + I komagane
	0x002b8606, // n0x1009 c0x0000 (---------------)  + I komoro
	0x0021c489, // n0x100a c0x0000 (---------------)  + I matsukawa
	0x0039df49, // n0x100b c0x0000 (---------------)  + I matsumoto
	0x0025bf85, // n0x100c c0x0000 (---------------)  + I miasa
	0x00295aca, // n0x100d c0x0000 (---------------)  + I minamiaiki
	0x0026660a, // n0x100e c0x0000 (---------------)  + I minamimaki
	0x00278e4c, // n0x100f c0x0000 (---------------)  + I minamiminowa
	0x00278fc6, // n0x1010 c0x0000 (---------------)  + I minowa
	0x00271b06, // n0x1011 c0x0000 (---------------)  + I miyada
	0x002bb8c6, // n0x1012 c0x0000 (---------------)  + I miyota
	0x00248b89, // n0x1013 c0x0000 (---------------)  + I mochizuki
	0x003a40c6, // n0x1014 c0x0000 (---------------)  + I nagano
	0x00281446, // n0x1015 c0x0000 (---------------)  + I nagawa
	0x002d5286, // n0x1016 c0x0000 (---------------)  + I nagiso
	0x002a7088, // n0x1017 c0x0000 (---------------)  + I nakagawa
	0x0024e906, // n0x1018 c0x0000 (---------------)  + I nakano
	0x002c274b, // n0x1019 c0x0000 (---------------)  + I nozawaonsen
	0x0028a6c5, // n0x101a c0x0000 (---------------)  + I obuse
	0x0023ecc5, // n0x101b c0x0000 (---------------)  + I ogawa
	0x00271d85, // n0x101c c0x0000 (---------------)  + I okaya
	0x003a4b06, // n0x101d c0x0000 (---------------)  + I omachi
	0x0020f583, // n0x101e c0x0000 (---------------)  + I omi
	0x0023d406, // n0x101f c0x0000 (---------------)  + I ookuwa
	0x00286fc7, // n0x1020 c0x0000 (---------------)  + I ooshika
	0x002b3b05, // n0x1021 c0x0000 (---------------)  + I otaki
	0x0025d685, // n0x1022 c0x0000 (---------------)  + I otari
	0x002dbd05, // n0x1023 c0x0000 (---------------)  + I sakae
	0x00311b06, // n0x1024 c0x0000 (---------------)  + I sakaki
	0x0025c044, // n0x1025 c0x0000 (---------------)  + I saku
	0x00365906, // n0x1026 c0x0000 (---------------)  + I sakuho
	0x0025ea09, // n0x1027 c0x0000 (---------------)  + I shimosuwa
	0x003a498c, // n0x1028 c0x0000 (---------------)  + I shinanomachi
	0x0028b948, // n0x1029 c0x0000 (---------------)  + I shiojiri
	0x0025eb44, // n0x102a c0x0000 (---------------)  + I suwa
	0x002e25c6, // n0x102b c0x0000 (---------------)  + I suzaka
	0x0029a8c6, // n0x102c c0x0000 (---------------)  + I takagi
	0x00218488, // n0x102d c0x0000 (---------------)  + I takamori
	0x002ba308, // n0x102e c0x0000 (---------------)  + I takayama
	0x003a4889, // n0x102f c0x0000 (---------------)  + I tateshina
	0x0020c247, // n0x1030 c0x0000 (---------------)  + I tatsuno
	0x002997c9, // n0x1031 c0x0000 (---------------)  + I togakushi
	0x00268306, // n0x1032 c0x0000 (---------------)  + I togura
	0x00229e04, // n0x1033 c0x0000 (---------------)  + I tomi
	0x0020aa44, // n0x1034 c0x0000 (---------------)  + I ueda
	0x00281b44, // n0x1035 c0x0000 (---------------)  + I wada
	0x00279248, // n0x1036 c0x0000 (---------------)  + I yamagata
	0x0020214a, // n0x1037 c0x0000 (---------------)  + I yamanouchi
	0x00348a06, // n0x1038 c0x0000 (---------------)  + I yasaka
	0x0034f987, // n0x1039 c0x0000 (---------------)  + I yasuoka
	0x002f9bc7, // n0x103a c0x0000 (---------------)  + I chijiwa
	0x002242c5, // n0x103b c0x0000 (---------------)  + I futsu
	0x0027f584, // n0x103c c0x0000 (---------------)  + I goto
	0x00285746, // n0x103d c0x0000 (---------------)  + I hasami
	0x0032f586, // n0x103e c0x0000 (---------------)  + I hirado
	0x00202003, // n0x103f c0x0000 (---------------)  + I iki
	0x002f17c7, // n0x1040 c0x0000 (---------------)  + I isahaya
	0x00325e48, // n0x1041 c0x0000 (---------------)  + I kawatana
	0x0025c0ca, // n0x1042 c0x0000 (---------------)  + I kuchinotsu
	0x002c5988, // n0x1043 c0x0000 (---------------)  + I matsuura
	0x002bbfc8, // n0x1044 c0x0000 (---------------)  + I nagasaki
	0x0038ffc5, // n0x1045 c0x0000 (---------------)  + I obama
	0x00357f45, // n0x1046 c0x0000 (---------------)  + I omura
	0x002a8785, // n0x1047 c0x0000 (---------------)  + I oseto
	0x00224686, // n0x1048 c0x0000 (---------------)  + I saikai
	0x00373d46, // n0x1049 c0x0000 (---------------)  + I sasebo
	0x00212e45, // n0x104a c0x0000 (---------------)  + I seihi
	0x00338709, // n0x104b c0x0000 (---------------)  + I shimabara
	0x0027f38c, // n0x104c c0x0000 (---------------)  + I shinkamigoto
	0x002a8847, // n0x104d c0x0000 (---------------)  + I togitsu
	0x0028ff08, // n0x104e c0x0000 (---------------)  + I tsushima
	0x00285d85, // n0x104f c0x0000 (---------------)  + I unzen
	0x006808c4, // n0x1050 c0x0001 (---------------)  ! I city
	0x00229bc4, // n0x1051 c0x0000 (---------------)  + I ando
	0x00313104, // n0x1052 c0x0000 (---------------)  + I gose
	0x0020b086, // n0x1053 c0x0000 (---------------)  + I heguri
	0x0029778e, // n0x1054 c0x0000 (---------------)  + I higashiyoshino
	0x00214647, // n0x1055 c0x0000 (---------------)  + I ikaruga
	0x00357a85, // n0x1056 c0x0000 (---------------)  + I ikoma
	0x00287fcc, // n0x1057 c0x0000 (---------------)  + I kamikitayama
	0x0029d447, // n0x1058 c0x0000 (---------------)  + I kanmaki
	0x00317d47, // n0x1059 c0x0000 (---------------)  + I kashiba
	0x00318589, // n0x105a c0x0000 (---------------)  + I kashihara
	0x00217c09, // n0x105b c0x0000 (---------------)  + I katsuragi
	0x00280645, // n0x105c c0x0000 (---------------)  + I kawai
	0x002f1988, // n0x105d c0x0000 (---------------)  + I kawakami
	0x002b8dc9, // n0x105e c0x0000 (---------------)  + I kawanishi
	0x002d0e45, // n0x105f c0x0000 (---------------)  + I koryo
	0x002b3a48, // n0x1060 c0x0000 (---------------)  + I kurotaki
	0x002c2d06, // n0x1061 c0x0000 (---------------)  + I mitsue
	0x0026b586, // n0x1062 c0x0000 (---------------)  + I miyake
	0x002b96c4, // n0x1063 c0x0000 (---------------)  + I nara
	0x00319848, // n0x1064 c0x0000 (---------------)  + I nosegawa
	0x00222b03, // n0x1065 c0x0000 (---------------)  + I oji
	0x00301d04, // n0x1066 c0x0000 (---------------)  + I ouda
	0x002f57c5, // n0x1067 c0x0000 (---------------)  + I oyodo
	0x002d4207, // n0x1068 c0x0000 (---------------)  + I sakurai
	0x00200645, // n0x1069 c0x0000 (---------------)  + I sango
	0x0027a609, // n0x106a c0x0000 (---------------)  + I shimoichi
	0x0025540d, // n0x106b c0x0000 (---------------)  + I shimokitayama
	0x00277186, // n0x106c c0x0000 (---------------)  + I shinjo
	0x00245844, // n0x106d c0x0000 (---------------)  + I soni
	0x00294ac8, // n0x106e c0x0000 (---------------)  + I takatori
	0x0027148a, // n0x106f c0x0000 (---------------)  + I tawaramoto
	0x00215d87, // n0x1070 c0x0000 (---------------)  + I tenkawa
	0x00341b85, // n0x1071 c0x0000 (---------------)  + I tenri
	0x0020cc43, // n0x1072 c0x0000 (---------------)  + I uda
	0x00296dce, // n0x1073 c0x0000 (---------------)  + I yamatokoriyama
	0x002881cc, // n0x1074 c0x0000 (---------------)  + I yamatotakada
	0x002f01c7, // n0x1075 c0x0000 (---------------)  + I yamazoe
	0x00297947, // n0x1076 c0x0000 (---------------)  + I yoshino
	0x00200c43, // n0x1077 c0x0000 (---------------)  + I aga
	0x003a4105, // n0x1078 c0x0000 (---------------)  + I agano
	0x00313105, // n0x1079 c0x0000 (---------------)  + I gosen
	0x00290b48, // n0x107a c0x0000 (---------------)  + I itoigawa
	0x0028d849, // n0x107b c0x0000 (---------------)  + I izumozaki
	0x00289306, // n0x107c c0x0000 (---------------)  + I joetsu
	0x00218504, // n0x107d c0x0000 (---------------)  + I kamo
	0x002aea86, // n0x107e c0x0000 (---------------)  + I kariwa
	0x0039288b, // n0x107f c0x0000 (---------------)  + I kashiwazaki
	0x002aafcc, // n0x1080 c0x0000 (---------------)  + I minamiuonuma
	0x00326407, // n0x1081 c0x0000 (---------------)  + I mitsuke
	0x002c6645, // n0x1082 c0x0000 (---------------)  + I muika
	0x0036f9c8, // n0x1083 c0x0000 (---------------)  + I murakami
	0x00353305, // n0x1084 c0x0000 (---------------)  + I myoko
	0x0038c6c7, // n0x1085 c0x0000 (---------------)  + I nagaoka
	0x002756c7, // n0x1086 c0x0000 (---------------)  + I niigata
	0x00247f85, // n0x1087 c0x0000 (---------------)  + I ojiya
	0x0020f583, // n0x1088 c0x0000 (---------------)  + I omi
	0x0035bd44, // n0x1089 c0x0000 (---------------)  + I sado
	0x00201405, // n0x108a c0x0000 (---------------)  + I sanjo
	0x002deac5, // n0x108b c0x0000 (---------------)  + I seiro
	0x002deac6, // n0x108c c0x0000 (---------------)  + I seirou
	0x0025ac08, // n0x108d c0x0000 (---------------)  + I sekikawa
	0x00317dc7, // n0x108e c0x0000 (---------------)  + I shibata
	0x00371d06, // n0x108f c0x0000 (---------------)  + I tagami
	0x003a2646, // n0x1090 c0x0000 (---------------)  + I tainai
	0x0027fb86, // n0x1091 c0x0000 (---------------)  + I tochio
	0x002a4349, // n0x1092 c0x0000 (---------------)  + I tokamachi
	0x003a2847, // n0x1093 c0x0000 (---------------)  + I tsubame
	0x00289186, // n0x1094 c0x0000 (---------------)  + I tsunan
	0x002ab146, // n0x1095 c0x0000 (---------------)  + I uonuma
	0x00248046, // n0x1096 c0x0000 (---------------)  + I yahiko
	0x002a1f05, // n0x1097 c0x0000 (---------------)  + I yoita
	0x0020a106, // n0x1098 c0x0000 (---------------)  + I yuzawa
	0x0037b685, // n0x1099 c0x0000 (---------------)  + I beppu
	0x0026b1c8, // n0x109a c0x0000 (---------------)  + I bungoono
	0x00288ecb, // n0x109b c0x0000 (---------------)  + I bungotakada
	0x00285546, // n0x109c c0x0000 (---------------)  + I hasama
	0x002f9c04, // n0x109d c0x0000 (---------------)  + I hiji
	0x002f2189, // n0x109e c0x0000 (---------------)  + I himeshima
	0x0029c144, // n0x109f c0x0000 (---------------)  + I hita
	0x002c2c88, // n0x10a0 c0x0000 (---------------)  + I kamitsue
	0x00284a07, // n0x10a1 c0x0000 (---------------)  + I kokonoe
	0x0027bdc4, // n0x10a2 c0x0000 (---------------)  + I kuju
	0x002ac988, // n0x10a3 c0x0000 (---------------)  + I kunisaki
	0x002b4a04, // n0x10a4 c0x0000 (---------------)  + I kusu
	0x002a1f44, // n0x10a5 c0x0000 (---------------)  + I oita
	0x00281945, // n0x10a6 c0x0000 (---------------)  + I saiki
	0x002d2306, // n0x10a7 c0x0000 (---------------)  + I taketa
	0x002eac07, // n0x10a8 c0x0000 (---------------)  + I tsukumi
	0x002056c3, // n0x10a9 c0x0000 (---------------)  + I usa
	0x00296885, // n0x10aa c0x0000 (---------------)  + I usuki
	0x002b72c4, // n0x10ab c0x0000 (---------------)  + I yufu
	0x002fe786, // n0x10ac c0x0000 (---------------)  + I akaiwa
	0x0025c008, // n0x10ad c0x0000 (---------------)  + I asakuchi
	0x00325b85, // n0x10ae c0x0000 (---------------)  + I bizen
	0x00288b89, // n0x10af c0x0000 (---------------)  + I hayashima
	0x00204cc5, // n0x10b0 c0x0000 (---------------)  + I ibara
	0x002b6cc8, // n0x10b1 c0x0000 (---------------)  + I kagamino
	0x00313ec7, // n0x10b2 c0x0000 (---------------)  + I kasaoka
	0x00378048, // n0x10b3 c0x0000 (---------------)  + I kibichuo
	0x002abc87, // n0x10b4 c0x0000 (---------------)  + I kumenan
	0x00357289, // n0x10b5 c0x0000 (---------------)  + I kurashiki
	0x00227706, // n0x10b6 c0x0000 (---------------)  + I maniwa
	0x003128c6, // n0x10b7 c0x0000 (---------------)  + I misaki
	0x00257304, // n0x10b8 c0x0000 (---------------)  + I nagi
	0x00294905, // n0x10b9 c0x0000 (---------------)  + I niimi
	0x002e92cc, // n0x10ba c0x0000 (---------------)  + I nishiawakura
	0x00271d87, // n0x10bb c0x0000 (---------------)  + I okayama
	0x00272187, // n0x10bc c0x0000 (---------------)  + I satosho
	0x002f9a88, // n0x10bd c0x0000 (---------------)  + I setouchi
	0x00277186, // n0x10be c0x0000 (---------------)  + I shinjo
	0x00298a84, // n0x10bf c0x0000 (---------------)  + I shoo
	0x0031b044, // n0x10c0 c0x0000 (---------------)  + I soja
	0x002793c9, // n0x10c1 c0x0000 (---------------)  + I takahashi
	0x002bb9c6, // n0x10c2 c0x0000 (---------------)  + I tamano
	0x00215047, // n0x10c3 c0x0000 (---------------)  + I tsuyama
	0x003a3804, // n0x10c4 c0x0000 (---------------)  + I wake
	0x002a91c6, // n0x10c5 c0x0000 (---------------)  + I yakage
	0x00317945, // n0x10c6 c0x0000 (---------------)  + I aguni
	0x0029c447, // n0x10c7 c0x0000 (---------------)  + I ginowan
	0x002c26c6, // n0x10c8 c0x0000 (---------------)  + I ginoza
	0x00241949, // n0x10c9 c0x0000 (---------------)  + I gushikami
	0x00278c87, // n0x10ca c0x0000 (---------------)  + I haebaru
	0x0025fc07, // n0x10cb c0x0000 (---------------)  + I higashi
	0x00299dc6, // n0x10cc c0x0000 (---------------)  + I hirara
	0x0023e585, // n0x10cd c0x0000 (---------------)  + I iheya
	0x00276e48, // n0x10ce c0x0000 (---------------)  + I ishigaki
	0x00219648, // n0x10cf c0x0000 (---------------)  + I ishikawa
	0x00234746, // n0x10d0 c0x0000 (---------------)  + I itoman
	0x00325bc5, // n0x10d1 c0x0000 (---------------)  + I izena
	0x0031a0c6, // n0x10d2 c0x0000 (---------------)  + I kadena
	0x00202043, // n0x10d3 c0x0000 (---------------)  + I kin
	0x002909c9, // n0x10d4 c0x0000 (---------------)  + I kitadaito
	0x002a01ce, // n0x10d5 c0x0000 (---------------)  + I kitanakagusuku
	0x002ab988, // n0x10d6 c0x0000 (---------------)  + I kumejima
	0x0029d688, // n0x10d7 c0x0000 (---------------)  + I kunigami
	0x0023454b, // n0x10d8 c0x0000 (---------------)  + I minamidaito
	0x00288dc6, // n0x10d9 c0x0000 (---------------)  + I motobu
	0x0024d844, // n0x10da c0x0000 (---------------)  + I nago
	0x0020db84, // n0x10db c0x0000 (---------------)  + I naha
	0x002a02ca, // n0x10dc c0x0000 (---------------)  + I nakagusuku
	0x00216087, // n0x10dd c0x0000 (---------------)  + I nakijin
	0x00289245, // n0x10de c0x0000 (---------------)  + I nanjo
	0x00212509, // n0x10df c0x0000 (---------------)  + I nishihara
	0x002b2a45, // n0x10e0 c0x0000 (---------------)  + I ogimi
	0x0038fc07, // n0x10e1 c0x0000 (---------------)  + I okinawa
	0x002f7344, // n0x10e2 c0x0000 (---------------)  + I onna
	0x0031cfc7, // n0x10e3 c0x0000 (---------------)  + I shimoji
	0x002aed08, // n0x10e4 c0x0000 (---------------)  + I taketomi
	0x002d2986, // n0x10e5 c0x0000 (---------------)  + I tarama
	0x002eba89, // n0x10e6 c0x0000 (---------------)  + I tokashiki
	0x002ad1ca, // n0x10e7 c0x0000 (---------------)  + I tomigusuku
	0x00216006, // n0x10e8 c0x0000 (---------------)  + I tonaki
	0x0028e646, // n0x10e9 c0x0000 (---------------)  + I urasoe
	0x002a5345, // n0x10ea c0x0000 (---------------)  + I uruma
	0x0036e205, // n0x10eb c0x0000 (---------------)  + I yaese
	0x002391c7, // n0x10ec c0x0000 (---------------)  + I yomitan
	0x00239648, // n0x10ed c0x0000 (---------------)  + I yonabaru
	0x00317888, // n0x10ee c0x0000 (---------------)  + I yonaguni
	0x0023b186, // n0x10ef c0x0000 (---------------)  + I zamami
	0x00222785, // n0x10f0 c0x0000 (---------------)  + I abeno
	0x0024d94e, // n0x10f1 c0x0000 (---------------)  + I chihayaakasaka
	0x00321084, // n0x10f2 c0x0000 (---------------)  + I chuo
	0x002346c5, // n0x10f3 c0x0000 (---------------)  + I daito
	0x00270bc9, // n0x10f4 c0x0000 (---------------)  + I fujiidera
	0x00263208, // n0x10f5 c0x0000 (---------------)  + I habikino
	0x0038f086, // n0x10f6 c0x0000 (---------------)  + I hannan
	0x0029300c, // n0x10f7 c0x0000 (---------------)  + I higashiosaka
	0x002955d0, // n0x10f8 c0x0000 (---------------)  + I higashisumiyoshi
	0x002973cf, // n0x10f9 c0x0000 (---------------)  + I higashiyodogawa
	0x00298b88, // n0x10fa c0x0000 (---------------)  + I hirakata
	0x002bcc07, // n0x10fb c0x0000 (---------------)  + I ibaraki
	0x00201785, // n0x10fc c0x0000 (---------------)  + I ikeda
	0x0026d905, // n0x10fd c0x0000 (---------------)  + I izumi
	0x002eaa89, // n0x10fe c0x0000 (---------------)  + I izumiotsu
	0x0028dc09, // n0x10ff c0x0000 (---------------)  + I izumisano
	0x0021d646, // n0x1100 c0x0000 (---------------)  + I kadoma
	0x002eff07, // n0x1101 c0x0000 (---------------)  + I kaizuka
	0x00383c05, // n0x1102 c0x0000 (---------------)  + I kanan
	0x0031d8c9, // n0x1103 c0x0000 (---------------)  + I kashiwara
	0x00305bc6, // n0x1104 c0x0000 (---------------)  + I katano
	0x003a3f0d, // n0x1105 c0x0000 (---------------)  + I kawachinagano
	0x00281a09, // n0x1106 c0x0000 (---------------)  + I kishiwada
	0x00202704, // n0x1107 c0x0000 (---------------)  + I kita
	0x002ab708, // n0x1108 c0x0000 (---------------)  + I kumatori
	0x00387cc9, // n0x1109 c0x0000 (---------------)  + I matsubara
	0x00348bc6, // n0x110a c0x0000 (---------------)  + I minato
	0x00271345, // n0x110b c0x0000 (---------------)  + I minoh
	0x003128c6, // n0x110c c0x0000 (---------------)  + I misaki
	0x00305389, // n0x110d c0x0000 (---------------)  + I moriguchi
	0x002c1a08, // n0x110e c0x0000 (---------------)  + I neyagawa
	0x00211505, // n0x110f c0x0000 (---------------)  + I nishi
	0x0025ab84, // n0x1110 c0x0000 (---------------)  + I nose
	0x002931cb, // n0x1111 c0x0000 (---------------)  + I osakasayama
	0x00348a85, // n0x1112 c0x0000 (---------------)  + I sakai
	0x00225586, // n0x1113 c0x0000 (---------------)  + I sayama
	0x0027b306, // n0x1114 c0x0000 (---------------)  + I sennan
	0x002403c6, // n0x1115 c0x0000 (---------------)  + I settsu
	0x0031d3cb, // n0x1116 c0x0000 (---------------)  + I shijonawate
	0x00288c89, // n0x1117 c0x0000 (---------------)  + I shimamoto
	0x00213185, // n0x1118 c0x0000 (---------------)  + I suita
	0x00377e07, // n0x1119 c0x0000 (---------------)  + I tadaoka
	0x00214106, // n0x111a c0x0000 (---------------)  + I taishi
	0x0039a2c6, // n0x111b c0x0000 (---------------)  + I tajiri
	0x0027a4c8, // n0x111c c0x0000 (---------------)  + I takaishi
	0x002d2409, // n0x111d c0x0000 (---------------)  + I takatsuki
	0x0026040c, // n0x111e c0x0000 (---------------)  + I tondabayashi
	0x00243848, // n0x111f c0x0000 (---------------)  + I toyonaka
	0x00249206, // n0x1120 c0x0000 (---------------)  + I toyono
	0x0033f1c3, // n0x1121 c0x0000 (---------------)  + I yao
	0x0024e3c6, // n0x1122 c0x0000 (---------------)  + I ariake
	0x0026d5c5, // n0x1123 c0x0000 (---------------)  + I arita
	0x00274fc8, // n0x1124 c0x0000 (---------------)  + I fukudomi
	0x00222186, // n0x1125 c0x0000 (---------------)  + I genkai
	0x0029c688, // n0x1126 c0x0000 (---------------)  + I hamatama
	0x00240105, // n0x1127 c0x0000 (---------------)  + I hizen
	0x00273c05, // n0x1128 c0x0000 (---------------)  + I imari
	0x00314148, // n0x1129 c0x0000 (---------------)  + I kamimine
	0x002e2a47, // n0x112a c0x0000 (---------------)  + I kanzaki
	0x00371947, // n0x112b c0x0000 (---------------)  + I karatsu
	0x002a2047, // n0x112c c0x0000 (---------------)  + I kashima
	0x0021c208, // n0x112d c0x0000 (---------------)  + I kitagata
	0x00287d08, // n0x112e c0x0000 (---------------)  + I kitahata
	0x00244286, // n0x112f c0x0000 (---------------)  + I kiyama
	0x002fa987, // n0x1130 c0x0000 (---------------)  + I kouhoku
	0x00366907, // n0x1131 c0x0000 (---------------)  + I kyuragi
	0x0026d48a, // n0x1132 c0x0000 (---------------)  + I nishiarita
	0x0027e183, // n0x1133 c0x0000 (---------------)  + I ogi
	0x003a4b06, // n0x1134 c0x0000 (---------------)  + I omachi
	0x00202285, // n0x1135 c0x0000 (---------------)  + I ouchi
	0x00206344, // n0x1136 c0x0000 (---------------)  + I saga
	0x00272cc9, // n0x1137 c0x0000 (---------------)  + I shiroishi
	0x00357204, // n0x1138 c0x0000 (---------------)  + I taku
	0x00223c04, // n0x1139 c0x0000 (---------------)  + I tara
	0x0029a744, // n0x113a c0x0000 (---------------)  + I tosu
	0x0029794b, // n0x113b c0x0000 (---------------)  + I yoshinogari
	0x00387e47, // n0x113c c0x0000 (---------------)  + I arakawa
	0x0024db85, // n0x113d c0x0000 (---------------)  + I asaka
	0x0028c7c8, // n0x113e c0x0000 (---------------)  + I chichibu
	0x00271246, // n0x113f c0x0000 (---------------)  + I fujimi
	0x00271248, // n0x1140 c0x0000 (---------------)  + I fujimino
	0x00274506, // n0x1141 c0x0000 (---------------)  + I fukaya
	0x0039cf05, // n0x1142 c0x0000 (---------------)  + I hanno
	0x00284445, // n0x1143 c0x0000 (---------------)  + I hanyu
	0x002860c6, // n0x1144 c0x0000 (---------------)  + I hasuda
	0x00286d48, // n0x1145 c0x0000 (---------------)  + I hatogaya
	0x00287a88, // n0x1146 c0x0000 (---------------)  + I hatoyama
	0x00272e86, // n0x1147 c0x0000 (---------------)  + I hidaka
	0x0028c60f, // n0x1148 c0x0000 (---------------)  + I higashichichibu
	0x00290490, // n0x1149 c0x0000 (---------------)  + I higashimatsuyama
	0x00393b45, // n0x114a c0x0000 (---------------)  + I honjo
	0x00208583, // n0x114b c0x0000 (---------------)  + I ina
	0x0024aa45, // n0x114c c0x0000 (---------------)  + I iruma
	0x002f4888, // n0x114d c0x0000 (---------------)  + I iwatsuki
	0x0028db09, // n0x114e c0x0000 (---------------)  + I kamiizumi
	0x002e0788, // n0x114f c0x0000 (---------------)  + I kamikawa
	0x00348e48, // n0x1150 c0x0000 (---------------)  + I kamisato
	0x00203348, // n0x1151 c0x0000 (---------------)  + I kasukabe
	0x00387f07, // n0x1152 c0x0000 (---------------)  + I kawagoe
	0x00270f09, // n0x1153 c0x0000 (---------------)  + I kawaguchi
	0x0029c888, // n0x1154 c0x0000 (---------------)  + I kawajima
	0x002a7504, // n0x1155 c0x0000 (---------------)  + I kazo
	0x0029a5c8, // n0x1156 c0x0000 (---------------)  + I kitamoto
	0x0027c609, // n0x1157 c0x0000 (---------------)  + I koshigaya
	0x00300fc7, // n0x1158 c0x0000 (---------------)  + I kounosu
	0x002a0144, // n0x1159 c0x0000 (---------------)  + I kuki
	0x003a3a88, // n0x115a c0x0000 (---------------)  + I kumagaya
	0x0023e88a, // n0x115b c0x0000 (---------------)  + I matsubushi
	0x002cd386, // n0x115c c0x0000 (---------------)  + I minano
	0x00298846, // n0x115d c0x0000 (---------------)  + I misato
	0x0021b209, // n0x115e c0x0000 (---------------)  + I miyashiro
	0x00295807, // n0x115f c0x0000 (---------------)  + I miyoshi
	0x002c3088, // n0x1160 c0x0000 (---------------)  + I moroyama
	0x00206c08, // n0x1161 c0x0000 (---------------)  + I nagatoro
	0x003a3688, // n0x1162 c0x0000 (---------------)  + I namegawa
	0x0034f4c5, // n0x1163 c0x0000 (---------------)  + I niiza
	0x0036f1c5, // n0x1164 c0x0000 (---------------)  + I ogano
	0x0023ecc5, // n0x1165 c0x0000 (---------------)  + I ogawa
	0x003130c5, // n0x1166 c0x0000 (---------------)  + I ogose
	0x002e3fc7, // n0x1167 c0x0000 (---------------)  + I okegawa
	0x0020f585, // n0x1168 c0x0000 (---------------)  + I omiya
	0x002b3b05, // n0x1169 c0x0000 (---------------)  + I otaki
	0x0033fa86, // n0x116a c0x0000 (---------------)  + I ranzan
	0x002e06c7, // n0x116b c0x0000 (---------------)  + I ryokami
	0x00349987, // n0x116c c0x0000 (---------------)  + I saitama
	0x0023eb86, // n0x116d c0x0000 (---------------)  + I sakado
	0x002c7b85, // n0x116e c0x0000 (---------------)  + I satte
	0x00225586, // n0x116f c0x0000 (---------------)  + I sayama
	0x00247105, // n0x1170 c0x0000 (---------------)  + I shiki
	0x002a1588, // n0x1171 c0x0000 (---------------)  + I shiraoka
	0x002cfb04, // n0x1172 c0x0000 (---------------)  + I soka
	0x002b9f86, // n0x1173 c0x0000 (---------------)  + I sugito
	0x0032d644, // n0x1174 c0x0000 (---------------)  + I toda
	0x00221948, // n0x1175 c0x0000 (---------------)  + I tokigawa
	0x0037d74a, // n0x1176 c0x0000 (---------------)  + I tokorozawa
	0x002739cc, // n0x1177 c0x0000 (---------------)  + I tsurugashima
	0x00204245, // n0x1178 c0x0000 (---------------)  + I urawa
	0x00357946, // n0x1179 c0x0000 (---------------)  + I warabi
	0x002605c6, // n0x117a c0x0000 (---------------)  + I yashio
	0x00238186, // n0x117b c0x0000 (---------------)  + I yokoze
	0x00249284, // n0x117c c0x0000 (---------------)  + I yono
	0x00317c05, // n0x117d c0x0000 (---------------)  + I yorii
	0x00274347, // n0x117e c0x0000 (---------------)  + I yoshida
	0x00295889, // n0x117f c0x0000 (---------------)  + I yoshikawa
	0x0029db07, // n0x1180 c0x0000 (---------------)  + I yoshimi
	0x006808c4, // n0x1181 c0x0001 (---------------)  ! I city
	0x006808c4, // n0x1182 c0x0001 (---------------)  ! I city
	0x00305105, // n0x1183 c0x0000 (---------------)  + I aisho
	0x00237d44, // n0x1184 c0x0000 (---------------)  + I gamo
	0x002929ca, // n0x1185 c0x0000 (---------------)  + I higashiomi
	0x002710c6, // n0x1186 c0x0000 (---------------)  + I hikone
	0x00348dc4, // n0x1187 c0x0000 (---------------)  + I koka
	0x00207ec5, // n0x1188 c0x0000 (---------------)  + I konan
	0x00353c85, // n0x1189 c0x0000 (---------------)  + I kosei
	0x002f7c04, // n0x118a c0x0000 (---------------)  + I koto
	0x0027af47, // n0x118b c0x0000 (---------------)  + I kusatsu
	0x00204c47, // n0x118c c0x0000 (---------------)  + I maibara
	0x002c2288, // n0x118d c0x0000 (---------------)  + I moriyama
	0x002ff288, // n0x118e c0x0000 (---------------)  + I nagahama
	0x00211509, // n0x118f c0x0000 (---------------)  + I nishiazai
	0x00254208, // n0x1190 c0x0000 (---------------)  + I notogawa
	0x00292b8b, // n0x1191 c0x0000 (---------------)  + I omihachiman
	0x0021bf84, // n0x1192 c0x0000 (---------------)  + I otsu
	0x002f6085, // n0x1193 c0x0000 (---------------)  + I ritto
	0x00278b85, // n0x1194 c0x0000 (---------------)  + I ryuoh
	0x002a1fc9, // n0x1195 c0x0000 (---------------)  + I takashima
	0x002d2409, // n0x1196 c0x0000 (---------------)  + I takatsuki
	0x002f2088, // n0x1197 c0x0000 (---------------)  + I torahime
	0x002557c8, // n0x1198 c0x0000 (---------------)  + I toyosato
	0x0026dc84, // n0x1199 c0x0000 (---------------)  + I yasu
	0x0029a905, // n0x119a c0x0000 (---------------)  + I akagi
	0x00201683, // n0x119b c0x0000 (---------------)  + I ama
	0x0021bf45, // n0x119c c0x0000 (---------------)  + I gotsu
	0x0029d886, // n0x119d c0x0000 (---------------)  + I hamada
	0x0028d68c, // n0x119e c0x0000 (---------------)  + I higashiizumo
	0x002196c6, // n0x119f c0x0000 (---------------)  + I hikawa
	0x00247146, // n0x11a0 c0x0000 (---------------)  + I hikimi
	0x0028d845, // n0x11a1 c0x0000 (---------------)  + I izumo
	0x00311b88, // n0x11a2 c0x0000 (---------------)  + I kakinoki
	0x002abb06, // n0x11a3 c0x0000 (---------------)  + I masuda
	0x0037c006, // n0x11a4 c0x0000 (---------------)  + I matsue
	0x00298846, // n0x11a5 c0x0000 (---------------)  + I misato
	0x0022304c, // n0x11a6 c0x0000 (---------------)  + I nishinoshima
	0x0025c944, // n0x11a7 c0x0000 (---------------)  + I ohda
	0x0027fcca, // n0x11a8 c0x0000 (---------------)  + I okinoshima
	0x0038f248, // n0x11a9 c0x0000 (---------------)  + I okuizumo
	0x0028d4c7, // n0x11aa c0x0000 (---------------)  + I shimane
	0x002430c6, // n0x11ab c0x0000 (---------------)  + I tamayu
	0x002893c7, // n0x11ac c0x0000 (---------------)  + I tsuwano
	0x002d9385, // n0x11ad c0x0000 (---------------)  + I unnan
	0x00325946, // n0x11ae c0x0000 (---------------)  + I yakumo
	0x0034c3c6, // n0x11af c0x0000 (---------------)  + I yasugi
	0x00371807, // n0x11b0 c0x0000 (---------------)  + I yatsuka
	0x00223c44, // n0x11b1 c0x0000 (---------------)  + I arai
	0x0034e5c5, // n0x11b2 c0x0000 (---------------)  + I atami
	0x00270bc4, // n0x11b3 c0x0000 (---------------)  + I fuji
	0x0028bc87, // n0x11b4 c0x0000 (---------------)  + I fujieda
	0x00270e08, // n0x11b5 c0x0000 (---------------)  + I fujikawa
	0x0027198a, // n0x11b6 c0x0000 (---------------)  + I fujinomiya
	0x00278387, // n0x11b7 c0x0000 (---------------)  + I fukuroi
	0x002348c7, // n0x11b8 c0x0000 (---------------)  + I gotemba
	0x002bcb87, // n0x11b9 c0x0000 (---------------)  + I haibara
	0x00353449, // n0x11ba c0x0000 (---------------)  + I hamamatsu
	0x0028d68a, // n0x11bb c0x0000 (---------------)  + I higashiizu
	0x00227e83, // n0x11bc c0x0000 (---------------)  + I ito
	0x00223b45, // n0x11bd c0x0000 (---------------)  + I iwata
	0x00215503, // n0x11be c0x0000 (---------------)  + I izu
	0x002ebc89, // n0x11bf c0x0000 (---------------)  + I izunokuni
	0x002b3848, // n0x11c0 c0x0000 (---------------)  + I kakegawa
	0x002a1707, // n0x11c1 c0x0000 (---------------)  + I kannami
	0x002e0889, // n0x11c2 c0x0000 (---------------)  + I kawanehon
	0x00219746, // n0x11c3 c0x0000 (---------------)  + I kawazu
	0x0039f748, // n0x11c4 c0x0000 (---------------)  + I kikugawa
	0x002d6d85, // n0x11c5 c0x0000 (---------------)  + I kosai
	0x0024ec0a, // n0x11c6 c0x0000 (---------------)  + I makinohara
	0x002c9489, // n0x11c7 c0x0000 (---------------)  + I matsuzaki
	0x002600c9, // n0x11c8 c0x0000 (---------------)  + I minamiizu
	0x0039de07, // n0x11c9 c0x0000 (---------------)  + I mishima
	0x002a2289, // n0x11ca c0x0000 (---------------)  + I morimachi
	0x002153c8, // n0x11cb c0x0000 (---------------)  + I nishiizu
	0x002e2746, // n0x11cc c0x0000 (---------------)  + I numazu
	0x00357b08, // n0x11cd c0x0000 (---------------)  + I omaezaki
	0x00210bc7, // n0x11ce c0x0000 (---------------)  + I shimada
	0x00227fc7, // n0x11cf c0x0000 (---------------)  + I shimizu
	0x002ab4c7, // n0x11d0 c0x0000 (---------------)  + I shimoda
	0x002a8f48, // n0x11d1 c0x0000 (---------------)  + I shizuoka
	0x002e2446, // n0x11d2 c0x0000 (---------------)  + I susono
	0x0023e645, // n0x11d3 c0x0000 (---------------)  + I yaizu
	0x00274347, // n0x11d4 c0x0000 (---------------)  + I yoshida
	0x0028e148, // n0x11d5 c0x0000 (---------------)  + I ashikaga
	0x003414c4, // n0x11d6 c0x0000 (---------------)  + I bato
	0x0027b6c4, // n0x11d7 c0x0000 (---------------)  + I haga
	0x002f1b87, // n0x11d8 c0x0000 (---------------)  + I ichikai
	0x002a6b07, // n0x11d9 c0x0000 (---------------)  + I iwafune
	0x002b8c4a, // n0x11da c0x0000 (---------------)  + I kaminokawa
	0x002e26c6, // n0x11db c0x0000 (---------------)  + I kanuma
	0x002f004a, // n0x11dc c0x0000 (---------------)  + I karasuyama
	0x002b2d07, // n0x11dd c0x0000 (---------------)  + I kuroiso
	0x00320e47, // n0x11de c0x0000 (---------------)  + I mashiko
	0x0023b284, // n0x11df c0x0000 (---------------)  + I mibu
	0x00252984, // n0x11e0 c0x0000 (---------------)  + I moka
	0x00264e06, // n0x11e1 c0x0000 (---------------)  + I motegi
	0x00339884, // n0x11e2 c0x0000 (---------------)  + I nasu
	0x0033988c, // n0x11e3 c0x0000 (---------------)  + I nasushiobara
	0x00202d05, // n0x11e4 c0x0000 (---------------)  + I nikko
	0x00216d49, // n0x11e5 c0x0000 (---------------)  + I nishikata
	0x0027e144, // n0x11e6 c0x0000 (---------------)  + I nogi
	0x00298b45, // n0x11e7 c0x0000 (---------------)  + I ohira
	0x00271408, // n0x11e8 c0x0000 (---------------)  + I ohtawara
	0x00254c85, // n0x11e9 c0x0000 (---------------)  + I oyama
	0x002d4206, // n0x11ea c0x0000 (---------------)  + I sakura
	0x0020b884, // n0x11eb c0x0000 (---------------)  + I sano
	0x002613ca, // n0x11ec c0x0000 (---------------)  + I shimotsuke
	0x00292006, // n0x11ed c0x0000 (---------------)  + I shioya
	0x0025144a, // n0x11ee c0x0000 (---------------)  + I takanezawa
	0x00341547, // n0x11ef c0x0000 (---------------)  + I tochigi
	0x0022a5c5, // n0x11f0 c0x0000 (---------------)  + I tsuga
	0x0021ab05, // n0x11f1 c0x0000 (---------------)  + I ujiie
	0x0022430a, // n0x11f2 c0x0000 (---------------)  + I utsunomiya
	0x0029a385, // n0x11f3 c0x0000 (---------------)  + I yaita
	0x00298746, // n0x11f4 c0x0000 (---------------)  + I aizumi
	0x00208044, // n0x11f5 c0x0000 (---------------)  + I anan
	0x002a7d86, // n0x11f6 c0x0000 (---------------)  + I ichiba
	0x00239285, // n0x11f7 c0x0000 (---------------)  + I itano
	0x00222246, // n0x11f8 c0x0000 (---------------)  + I kainan
	0x002e1e0c, // n0x11f9 c0x0000 (---------------)  + I komatsushima
	0x002c320a, // n0x11fa c0x0000 (---------------)  + I matsushige
	0x00266704, // n0x11fb c0x0000 (---------------)  + I mima
	0x00228206, // n0x11fc c0x0000 (---------------)  + I minami
	0x00295807, // n0x11fd c0x0000 (---------------)  + I miyoshi
	0x002c5d84, // n0x11fe c0x0000 (---------------)  + I mugi
	0x002a7088, // n0x11ff c0x0000 (---------------)  + I nakagawa
	0x0037d646, // n0x1200 c0x0000 (---------------)  + I naruto
	0x0024d7c9, // n0x1201 c0x0000 (---------------)  + I sanagochi
	0x002a4c09, // n0x1202 c0x0000 (---------------)  + I shishikui
	0x0036fe89, // n0x1203 c0x0000 (---------------)  + I tokushima
	0x003665c6, // n0x1204 c0x0000 (---------------)  + I wajiki
	0x00210cc6, // n0x1205 c0x0000 (---------------)  + I adachi
	0x00357c47, // n0x1206 c0x0000 (---------------)  + I akiruno
	0x00338648, // n0x1207 c0x0000 (---------------)  + I akishima
	0x00210ac9, // n0x1208 c0x0000 (---------------)  + I aogashima
	0x00387e47, // n0x1209 c0x0000 (---------------)  + I arakawa
	0x0028c946, // n0x120a c0x0000 (---------------)  + I bunkyo
	0x002dfbc7, // n0x120b c0x0000 (---------------)  + I chiyoda
	0x002b05c5, // n0x120c c0x0000 (---------------)  + I chofu
	0x00321084, // n0x120d c0x0000 (---------------)  + I chuo
	0x00357807, // n0x120e c0x0000 (---------------)  + I edogawa
	0x002b7345, // n0x120f c0x0000 (---------------)  + I fuchu
	0x00281885, // n0x1210 c0x0000 (---------------)  + I fussa
	0x002f3087, // n0x1211 c0x0000 (---------------)  + I hachijo
	0x00247e48, // n0x1212 c0x0000 (---------------)  + I hachioji
	0x0036f946, // n0x1213 c0x0000 (---------------)  + I hamura
	0x0028f4cd, // n0x1214 c0x0000 (---------------)  + I higashikurume
	0x00290d4f, // n0x1215 c0x0000 (---------------)  + I higashimurayama
	0x00296c0d, // n0x1216 c0x0000 (---------------)  + I higashiyamato
	0x0020af84, // n0x1217 c0x0000 (---------------)  + I hino
	0x00233886, // n0x1218 c0x0000 (---------------)  + I hinode
	0x002c9a08, // n0x1219 c0x0000 (---------------)  + I hinohara
	0x002d5245, // n0x121a c0x0000 (---------------)  + I inagi
	0x0026d648, // n0x121b c0x0000 (---------------)  + I itabashi
	0x0020de4a, // n0x121c c0x0000 (---------------)  + I katsushika
	0x00202704, // n0x121d c0x0000 (---------------)  + I kita
	0x002e21c6, // n0x121e c0x0000 (---------------)  + I kiyose
	0x00207207, // n0x121f c0x0000 (---------------)  + I kodaira
	0x0021f547, // n0x1220 c0x0000 (---------------)  + I koganei
	0x0029ab09, // n0x1221 c0x0000 (---------------)  + I kokubunji
	0x00357ac5, // n0x1222 c0x0000 (---------------)  + I komae
	0x002f7c04, // n0x1223 c0x0000 (---------------)  + I koto
	0x003240ca, // n0x1224 c0x0000 (---------------)  + I kouzushima
	0x002acc89, // n0x1225 c0x0000 (---------------)  + I kunitachi
	0x002a2387, // n0x1226 c0x0000 (---------------)  + I machida
	0x0028f786, // n0x1227 c0x0000 (---------------)  + I meguro
	0x00348bc6, // n0x1228 c0x0000 (---------------)  + I minato
	0x0029a846, // n0x1229 c0x0000 (---------------)  + I mitaka
	0x00358846, // n0x122a c0x0000 (---------------)  + I mizuho
	0x002c914f, // n0x122b c0x0000 (---------------)  + I musashimurayama
	0x002c98c9, // n0x122c c0x0000 (---------------)  + I musashino
	0x0024e906, // n0x122d c0x0000 (---------------)  + I nakano
	0x00248886, // n0x122e c0x0000 (---------------)  + I nerima
	0x00300009, // n0x122f c0x0000 (---------------)  + I ogasawara
	0x002faa87, // n0x1230 c0x0000 (---------------)  + I okutama
	0x00212943, // n0x1231 c0x0000 (---------------)  + I ome
	0x00209a86, // n0x1232 c0x0000 (---------------)  + I oshima
	0x00201503, // n0x1233 c0x0000 (---------------)  + I ota
	0x002408c8, // n0x1234 c0x0000 (---------------)  + I setagaya
	0x002dfa07, // n0x1235 c0x0000 (---------------)  + I shibuya
	0x00298d89, // n0x1236 c0x0000 (---------------)  + I shinagawa
	0x0027d108, // n0x1237 c0x0000 (---------------)  + I shinjuku
	0x00371a88, // n0x1238 c0x0000 (---------------)  + I suginami
	0x00213cc6, // n0x1239 c0x0000 (---------------)  + I sumida
	0x0033c709, // n0x123a c0x0000 (---------------)  + I tachikawa
	0x00275805, // n0x123b c0x0000 (---------------)  + I taito
	0x002430c4, // n0x123c c0x0000 (---------------)  + I tama
	0x00243b87, // n0x123d c0x0000 (---------------)  + I toshima
	0x00248c05, // n0x123e c0x0000 (---------------)  + I chizu
	0x0020af84, // n0x123f c0x0000 (---------------)  + I hino
	0x0024dc48, // n0x1240 c0x0000 (---------------)  + I kawahara
	0x00216344, // n0x1241 c0x0000 (---------------)  + I koge
	0x002f7c07, // n0x1242 c0x0000 (---------------)  + I kotoura
	0x00344046, // n0x1243 c0x0000 (---------------)  + I misasa
	0x002d3045, // n0x1244 c0x0000 (---------------)  + I nanbu
	0x002736c8, // n0x1245 c0x0000 (---------------)  + I nichinan
	0x00348a8b, // n0x1246 c0x0000 (---------------)  + I sakaiminato
	0x002ec7c7, // n0x1247 c0x0000 (---------------)  + I tottori
	0x00224586, // n0x1248 c0x0000 (---------------)  + I wakasa
	0x002bb0c4, // n0x1249 c0x0000 (---------------)  + I yazu
	0x003040c6, // n0x124a c0x0000 (---------------)  + I yonago
	0x002b9ac5, // n0x124b c0x0000 (---------------)  + I asahi
	0x002b7345, // n0x124c c0x0000 (---------------)  + I fuchu
	0x00276bc9, // n0x124d c0x0000 (---------------)  + I fukumitsu
	0x0027ab49, // n0x124e c0x0000 (---------------)  + I funahashi
	0x00228004, // n0x124f c0x0000 (---------------)  + I himi
	0x00228045, // n0x1250 c0x0000 (---------------)  + I imizu
	0x00228245, // n0x1251 c0x0000 (---------------)  + I inami
	0x0024ea86, // n0x1252 c0x0000 (---------------)  + I johana
	0x002f1a88, // n0x1253 c0x0000 (---------------)  + I kamiichi
	0x002b2606, // n0x1254 c0x0000 (---------------)  + I kurobe
	0x00325c8b, // n0x1255 c0x0000 (---------------)  + I nakaniikawa
	0x002f73ca, // n0x1256 c0x0000 (---------------)  + I namerikawa
	0x002eb9c5, // n0x1257 c0x0000 (---------------)  + I nanto
	0x002844c6, // n0x1258 c0x0000 (---------------)  + I nyuzen
	0x002ea385, // n0x1259 c0x0000 (---------------)  + I oyabe
	0x00213245, // n0x125a c0x0000 (---------------)  + I taira
	0x00287e87, // n0x125b c0x0000 (---------------)  + I takaoka
	0x00201548, // n0x125c c0x0000 (---------------)  + I tateyama
	0x00254284, // n0x125d c0x0000 (---------------)  + I toga
	0x0025be86, // n0x125e c0x0000 (---------------)  + I tonami
	0x00287b06, // n0x125f c0x0000 (---------------)  + I toyama
	0x00215587, // n0x1260 c0x0000 (---------------)  + I unazuki
	0x002f6684, // n0x1261 c0x0000 (---------------)  + I uozu
	0x00274e46, // n0x1262 c0x0000 (---------------)  + I yamada
	0x003082c5, // n0x1263 c0x0000 (---------------)  + I arida
	0x003082c9, // n0x1264 c0x0000 (---------------)  + I aridagawa
	0x00210ec4, // n0x1265 c0x0000 (---------------)  + I gobo
	0x0027f709, // n0x1266 c0x0000 (---------------)  + I hashimoto
	0x00272e86, // n0x1267 c0x0000 (---------------)  + I hidaka
	0x002b4488, // n0x1268 c0x0000 (---------------)  + I hirogawa
	0x00228245, // n0x1269 c0x0000 (---------------)  + I inami
	0x002f9cc5, // n0x126a c0x0000 (---------------)  + I iwade
	0x00222246, // n0x126b c0x0000 (---------------)  + I kainan
	0x00260309, // n0x126c c0x0000 (---------------)  + I kamitonda
	0x00217c09, // n0x126d c0x0000 (---------------)  + I katsuragi
	0x002471c6, // n0x126e c0x0000 (---------------)  + I kimino
	0x00263308, // n0x126f c0x0000 (---------------)  + I kinokawa
	0x00255548, // n0x1270 c0x0000 (---------------)  + I kitayama
	0x002ea344, // n0x1271 c0x0000 (---------------)  + I koya
	0x00358d44, // n0x1272 c0x0000 (---------------)  + I koza
	0x00358d48, // n0x1273 c0x0000 (---------------)  + I kozagawa
	0x0030fc88, // n0x1274 c0x0000 (---------------)  + I kudoyama
	0x002998c9, // n0x1275 c0x0000 (---------------)  + I kushimoto
	0x0029d806, // n0x1276 c0x0000 (---------------)  + I mihama
	0x00298846, // n0x1277 c0x0000 (---------------)  + I misato
	0x0030d44d, // n0x1278 c0x0000 (---------------)  + I nachikatsuura
	0x002deec6, // n0x1279 c0x0000 (---------------)  + I shingu
	0x00293709, // n0x127a c0x0000 (---------------)  + I shirahama
	0x003a4cc5, // n0x127b c0x0000 (---------------)  + I taiji
	0x002fdb86, // n0x127c c0x0000 (---------------)  + I tanabe
	0x0033c8c8, // n0x127d c0x0000 (---------------)  + I wakayama
	0x0030a445, // n0x127e c0x0000 (---------------)  + I yuasa
	0x00366944, // n0x127f c0x0000 (---------------)  + I yura
	0x002b9ac5, // n0x1280 c0x0000 (---------------)  + I asahi
	0x0027a1c8, // n0x1281 c0x0000 (---------------)  + I funagata
	0x00292789, // n0x1282 c0x0000 (---------------)  + I higashine
	0x00270c84, // n0x1283 c0x0000 (---------------)  + I iide
	0x003332c6, // n0x1284 c0x0000 (---------------)  + I kahoku
	0x00254b4a, // n0x1285 c0x0000 (---------------)  + I kaminoyama
	0x002c3a08, // n0x1286 c0x0000 (---------------)  + I kaneyama
	0x002b8dc9, // n0x1287 c0x0000 (---------------)  + I kawanishi
	0x00289c4a, // n0x1288 c0x0000 (---------------)  + I mamurogawa
	0x002e0806, // n0x1289 c0x0000 (---------------)  + I mikawa
	0x00290f08, // n0x128a c0x0000 (---------------)  + I murayama
	0x0038c485, // n0x128b c0x0000 (---------------)  + I nagai
	0x002c5808, // n0x128c c0x0000 (---------------)  + I nakayama
	0x002abd85, // n0x128d c0x0000 (---------------)  + I nanyo
	0x00219609, // n0x128e c0x0000 (---------------)  + I nishikawa
	0x0035d349, // n0x128f c0x0000 (---------------)  + I obanazawa
	0x00202e02, // n0x1290 c0x0000 (---------------)  + I oe
	0x00283085, // n0x1291 c0x0000 (---------------)  + I oguni
	0x00267f86, // n0x1292 c0x0000 (---------------)  + I ohkura
	0x00272dc7, // n0x1293 c0x0000 (---------------)  + I oishida
	0x0039a485, // n0x1294 c0x0000 (---------------)  + I sagae
	0x002ee546, // n0x1295 c0x0000 (---------------)  + I sakata
	0x0030a508, // n0x1296 c0x0000 (---------------)  + I sakegawa
	0x00277186, // n0x1297 c0x0000 (---------------)  + I shinjo
	0x002a33c9, // n0x1298 c0x0000 (---------------)  + I shirataka
	0x00272286, // n0x1299 c0x0000 (---------------)  + I shonai
	0x0027a348, // n0x129a c0x0000 (---------------)  + I takahata
	0x002a2a85, // n0x129b c0x0000 (---------------)  + I tendo
	0x00265e06, // n0x129c c0x0000 (---------------)  + I tozawa
	0x003363c8, // n0x129d c0x0000 (---------------)  + I tsuruoka
	0x00279248, // n0x129e c0x0000 (---------------)  + I yamagata
	0x00398048, // n0x129f c0x0000 (---------------)  + I yamanobe
	0x00361fc8, // n0x12a0 c0x0000 (---------------)  + I yonezawa
	0x0020a104, // n0x12a1 c0x0000 (---------------)  + I yuza
	0x00228543, // n0x12a2 c0x0000 (---------------)  + I abu
	0x002a3604, // n0x12a3 c0x0000 (---------------)  + I hagi
	0x00278586, // n0x12a4 c0x0000 (---------------)  + I hikari
	0x002b0604, // n0x12a5 c0x0000 (---------------)  + I hofu
	0x0029d5c7, // n0x12a6 c0x0000 (---------------)  + I iwakuni
	0x0037bf09, // n0x12a7 c0x0000 (---------------)  + I kudamatsu
	0x002ba8c5, // n0x12a8 c0x0000 (---------------)  + I mitou
	0x00206c06, // n0x12a9 c0x0000 (---------------)  + I nagato
	0x00209a86, // n0x12aa c0x0000 (---------------)  + I oshima
	0x0025aa4b, // n0x12ab c0x0000 (---------------)  + I shimonoseki
	0x002eb906, // n0x12ac c0x0000 (---------------)  + I shunan
	0x0030ff86, // n0x12ad c0x0000 (---------------)  + I tabuse
	0x002aef88, // n0x12ae c0x0000 (---------------)  + I tokuyama
	0x0025d5c6, // n0x12af c0x0000 (---------------)  + I toyota
	0x002a0943, // n0x12b0 c0x0000 (---------------)  + I ube
	0x002077c3, // n0x12b1 c0x0000 (---------------)  + I yuu
	0x00321084, // n0x12b2 c0x0000 (---------------)  + I chuo
	0x002300c5, // n0x12b3 c0x0000 (---------------)  + I doshi
	0x00366ac7, // n0x12b4 c0x0000 (---------------)  + I fuefuki
	0x00270e08, // n0x12b5 c0x0000 (---------------)  + I fujikawa
	0x00270e0f, // n0x12b6 c0x0000 (---------------)  + I fujikawaguchiko
	0x0027424b, // n0x12b7 c0x0000 (---------------)  + I fujiyoshida
	0x002f1888, // n0x12b8 c0x0000 (---------------)  + I hayakawa
	0x00333346, // n0x12b9 c0x0000 (---------------)  + I hokuto
	0x0032d34e, // n0x12ba c0x0000 (---------------)  + I ichikawamisato
	0x00222243, // n0x12bb c0x0000 (---------------)  + I kai
	0x00235ec4, // n0x12bc c0x0000 (---------------)  + I kofu
	0x002eb885, // n0x12bd c0x0000 (---------------)  + I koshu
	0x002f5546, // n0x12be c0x0000 (---------------)  + I kosuge
	0x0028584b, // n0x12bf c0x0000 (---------------)  + I minami-alps
	0x0028a606, // n0x12c0 c0x0000 (---------------)  + I minobu
	0x00211d89, // n0x12c1 c0x0000 (---------------)  + I nakamichi
	0x002d3045, // n0x12c2 c0x0000 (---------------)  + I nanbu
	0x00379488, // n0x12c3 c0x0000 (---------------)  + I narusawa
	0x00210288, // n0x12c4 c0x0000 (---------------)  + I nirasaki
	0x00217acc, // n0x12c5 c0x0000 (---------------)  + I nishikatsura
	0x00297986, // n0x12c6 c0x0000 (---------------)  + I oshino
	0x0021bf86, // n0x12c7 c0x0000 (---------------)  + I otsuki
	0x002aadc5, // n0x12c8 c0x0000 (---------------)  + I showa
	0x00281cc8, // n0x12c9 c0x0000 (---------------)  + I tabayama
	0x002739c5, // n0x12ca c0x0000 (---------------)  + I tsuru
	0x00375248, // n0x12cb c0x0000 (---------------)  + I uenohara
	0x0029704a, // n0x12cc c0x0000 (---------------)  + I yamanakako
	0x0029b349, // n0x12cd c0x0000 (---------------)  + I yamanashi
	0x006808c4, // n0x12ce c0x0001 (---------------)  ! I city
	0x2d203dc2, // n0x12cf c0x00b4 (n0x12d0-n0x12d1)  o I co
	0x000f4e08, // n0x12d0 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x12d1 c0x0000 (---------------)  + I com
	0x002325c3, // n0x12d2 c0x0000 (---------------)  + I edu
	0x00264783, // n0x12d3 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x12d4 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x12d5 c0x0000 (---------------)  + I net
	0x00223a43, // n0x12d6 c0x0000 (---------------)  + I org
	0x00325b83, // n0x12d7 c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x12d8 c0x0000 (---------------)  + I com
	0x002325c3, // n0x12d9 c0x0000 (---------------)  + I edu
	0x00264783, // n0x12da c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x12db c0x0000 (---------------)  + I info
	0x0021e283, // n0x12dc c0x0000 (---------------)  + I net
	0x00223a43, // n0x12dd c0x0000 (---------------)  + I org
	0x0022b603, // n0x12de c0x0000 (---------------)  + I ass
	0x002c7fc4, // n0x12df c0x0000 (---------------)  + I asso
	0x0022d0c3, // n0x12e0 c0x0000 (---------------)  + I com
	0x00235044, // n0x12e1 c0x0000 (---------------)  + I coop
	0x002325c3, // n0x12e2 c0x0000 (---------------)  + I edu
	0x0034ec04, // n0x12e3 c0x0000 (---------------)  + I gouv
	0x00264783, // n0x12e4 c0x0000 (---------------)  + I gov
	0x0039a747, // n0x12e5 c0x0000 (---------------)  + I medecin
	0x00214d03, // n0x12e6 c0x0000 (---------------)  + I mil
	0x0020f543, // n0x12e7 c0x0000 (---------------)  + I nom
	0x00241c88, // n0x12e8 c0x0000 (---------------)  + I notaires
	0x00223a43, // n0x12e9 c0x0000 (---------------)  + I org
	0x002ed1cb, // n0x12ea c0x0000 (---------------)  + I pharmaciens
	0x002d9d03, // n0x12eb c0x0000 (---------------)  + I prd
	0x002416c6, // n0x12ec c0x0000 (---------------)  + I presse
	0x00200142, // n0x12ed c0x0000 (---------------)  + I tm
	0x0026af0b, // n0x12ee c0x0000 (---------------)  + I veterinaire
	0x002325c3, // n0x12ef c0x0000 (---------------)  + I edu
	0x00264783, // n0x12f0 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x12f1 c0x0000 (---------------)  + I net
	0x00223a43, // n0x12f2 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x12f3 c0x0000 (---------------)  + I com
	0x002325c3, // n0x12f4 c0x0000 (---------------)  + I edu
	0x00264783, // n0x12f5 c0x0000 (---------------)  + I gov
	0x00223a43, // n0x12f6 c0x0000 (---------------)  + I org
	0x00225083, // n0x12f7 c0x0000 (---------------)  + I rep
	0x00202b83, // n0x12f8 c0x0000 (---------------)  + I tra
	0x00203982, // n0x12f9 c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x12fa c0x0000 (---------------)  +   blogspot
	0x00205685, // n0x12fb c0x0000 (---------------)  + I busan
	0x002fc548, // n0x12fc c0x0000 (---------------)  + I chungbuk
	0x0030b0c8, // n0x12fd c0x0000 (---------------)  + I chungnam
	0x00203dc2, // n0x12fe c0x0000 (---------------)  + I co
	0x00395a45, // n0x12ff c0x0000 (---------------)  + I daegu
	0x00325607, // n0x1300 c0x0000 (---------------)  + I daejeon
	0x002013c2, // n0x1301 c0x0000 (---------------)  + I es
	0x00211fc7, // n0x1302 c0x0000 (---------------)  + I gangwon
	0x00200702, // n0x1303 c0x0000 (---------------)  + I go
	0x0022bf47, // n0x1304 c0x0000 (---------------)  + I gwangju
	0x002eb689, // n0x1305 c0x0000 (---------------)  + I gyeongbuk
	0x0038c048, // n0x1306 c0x0000 (---------------)  + I gyeonggi
	0x003a3509, // n0x1307 c0x0000 (---------------)  + I gyeongnam
	0x00200602, // n0x1308 c0x0000 (---------------)  + I hs
	0x00261087, // n0x1309 c0x0000 (---------------)  + I incheon
	0x00246f44, // n0x130a c0x0000 (---------------)  + I jeju
	0x003256c7, // n0x130b c0x0000 (---------------)  + I jeonbuk
	0x002f72c7, // n0x130c c0x0000 (---------------)  + I jeonnam
	0x002b1542, // n0x130d c0x0000 (---------------)  + I kg
	0x00214d03, // n0x130e c0x0000 (---------------)  + I mil
	0x0020bbc2, // n0x130f c0x0000 (---------------)  + I ms
	0x00201e02, // n0x1310 c0x0000 (---------------)  + I ne
	0x00200282, // n0x1311 c0x0000 (---------------)  + I or
	0x002087c2, // n0x1312 c0x0000 (---------------)  + I pe
	0x00204902, // n0x1313 c0x0000 (---------------)  + I re
	0x00213402, // n0x1314 c0x0000 (---------------)  + I sc
	0x00283945, // n0x1315 c0x0000 (---------------)  + I seoul
	0x0024afc5, // n0x1316 c0x0000 (---------------)  + I ulsan
	0x0022d0c3, // n0x1317 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1318 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1319 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x131a c0x0000 (---------------)  + I net
	0x00223a43, // n0x131b c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x131c c0x0000 (---------------)  + I com
	0x002325c3, // n0x131d c0x0000 (---------------)  + I edu
	0x00264783, // n0x131e c0x0000 (---------------)  + I gov
	0x00214d03, // n0x131f c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1320 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1321 c0x0000 (---------------)  + I org
	0x00000301, // n0x1322 c0x0000 (---------------)  +   c
	0x0022d0c3, // n0x1323 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1324 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1325 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1326 c0x0000 (---------------)  + I info
	0x00267a43, // n0x1327 c0x0000 (---------------)  + I int
	0x0021e283, // n0x1328 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1329 c0x0000 (---------------)  + I org
	0x00220503, // n0x132a c0x0000 (---------------)  + I per
	0x0022d0c3, // n0x132b c0x0000 (---------------)  + I com
	0x002325c3, // n0x132c c0x0000 (---------------)  + I edu
	0x00264783, // n0x132d c0x0000 (---------------)  + I gov
	0x0021e283, // n0x132e c0x0000 (---------------)  + I net
	0x00223a43, // n0x132f c0x0000 (---------------)  + I org
	0x00203dc2, // n0x1330 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1331 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1332 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1333 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1334 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1335 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x1336 c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x1337 c0x0000 (---------------)  + I ac
	0x002b5504, // n0x1338 c0x0000 (---------------)  + I assn
	0x0022d0c3, // n0x1339 c0x0000 (---------------)  + I com
	0x002325c3, // n0x133a c0x0000 (---------------)  + I edu
	0x00264783, // n0x133b c0x0000 (---------------)  + I gov
	0x00352043, // n0x133c c0x0000 (---------------)  + I grp
	0x0022de05, // n0x133d c0x0000 (---------------)  + I hotel
	0x00267a43, // n0x133e c0x0000 (---------------)  + I int
	0x00314403, // n0x133f c0x0000 (---------------)  + I ltd
	0x0021e283, // n0x1340 c0x0000 (---------------)  + I net
	0x002006c3, // n0x1341 c0x0000 (---------------)  + I ngo
	0x00223a43, // n0x1342 c0x0000 (---------------)  + I org
	0x00213403, // n0x1343 c0x0000 (---------------)  + I sch
	0x0026e003, // n0x1344 c0x0000 (---------------)  + I soc
	0x002292c3, // n0x1345 c0x0000 (---------------)  + I web
	0x0022d0c3, // n0x1346 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1347 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1348 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1349 c0x0000 (---------------)  + I net
	0x00223a43, // n0x134a c0x0000 (---------------)  + I org
	0x00203dc2, // n0x134b c0x0000 (---------------)  + I co
	0x00223a43, // n0x134c c0x0000 (---------------)  + I org
	0x000f4e08, // n0x134d c0x0000 (---------------)  +   blogspot
	0x00264783, // n0x134e c0x0000 (---------------)  + I gov
	0x000f4e08, // n0x134f c0x0000 (---------------)  +   blogspot
	0x0024ee43, // n0x1350 c0x0000 (---------------)  + I asn
	0x0022d0c3, // n0x1351 c0x0000 (---------------)  + I com
	0x00230a84, // n0x1352 c0x0000 (---------------)  + I conf
	0x002325c3, // n0x1353 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1354 c0x0000 (---------------)  + I gov
	0x00203782, // n0x1355 c0x0000 (---------------)  + I id
	0x00214d03, // n0x1356 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1357 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1358 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1359 c0x0000 (---------------)  + I com
	0x002325c3, // n0x135a c0x0000 (---------------)  + I edu
	0x00264783, // n0x135b c0x0000 (---------------)  + I gov
	0x00203782, // n0x135c c0x0000 (---------------)  + I id
	0x00220d43, // n0x135d c0x0000 (---------------)  + I med
	0x0021e283, // n0x135e c0x0000 (---------------)  + I net
	0x00223a43, // n0x135f c0x0000 (---------------)  + I org
	0x002d2f03, // n0x1360 c0x0000 (---------------)  + I plc
	0x00213403, // n0x1361 c0x0000 (---------------)  + I sch
	0x00203982, // n0x1362 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x1363 c0x0000 (---------------)  + I co
	0x00264783, // n0x1364 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1365 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1366 c0x0000 (---------------)  + I org
	0x002416c5, // n0x1367 c0x0000 (---------------)  + I press
	0x002c7fc4, // n0x1368 c0x0000 (---------------)  + I asso
	0x00200142, // n0x1369 c0x0000 (---------------)  + I tm
	0x000f4e08, // n0x136a c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x136b c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x136c c0x0000 (---------------)  + I co
	0x000d444b, // n0x136d c0x0000 (---------------)  +   diskstation
	0x00101c07, // n0x136e c0x0000 (---------------)  +   dscloud
	0x002325c3, // n0x136f c0x0000 (---------------)  + I edu
	0x00264783, // n0x1370 c0x0000 (---------------)  + I gov
	0x00143184, // n0x1371 c0x0000 (---------------)  +   i234
	0x002441c3, // n0x1372 c0x0000 (---------------)  + I its
	0x00101b84, // n0x1373 c0x0000 (---------------)  +   myds
	0x0021e283, // n0x1374 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1375 c0x0000 (---------------)  + I org
	0x002da7c4, // n0x1376 c0x0000 (---------------)  + I priv
	0x000eb508, // n0x1377 c0x0000 (---------------)  +   synology
	0x00203dc2, // n0x1378 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1379 c0x0000 (---------------)  + I com
	0x002325c3, // n0x137a c0x0000 (---------------)  + I edu
	0x00264783, // n0x137b c0x0000 (---------------)  + I gov
	0x00214d03, // n0x137c c0x0000 (---------------)  + I mil
	0x0020f543, // n0x137d c0x0000 (---------------)  + I nom
	0x00223a43, // n0x137e c0x0000 (---------------)  + I org
	0x002d9d03, // n0x137f c0x0000 (---------------)  + I prd
	0x00200142, // n0x1380 c0x0000 (---------------)  + I tm
	0x000f4e08, // n0x1381 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1382 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1383 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1384 c0x0000 (---------------)  + I gov
	0x003a4dc3, // n0x1385 c0x0000 (---------------)  + I inf
	0x0020ff84, // n0x1386 c0x0000 (---------------)  + I name
	0x0021e283, // n0x1387 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1388 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1389 c0x0000 (---------------)  + I com
	0x002325c3, // n0x138a c0x0000 (---------------)  + I edu
	0x0034ec04, // n0x138b c0x0000 (---------------)  + I gouv
	0x00264783, // n0x138c c0x0000 (---------------)  + I gov
	0x0021e283, // n0x138d c0x0000 (---------------)  + I net
	0x00223a43, // n0x138e c0x0000 (---------------)  + I org
	0x002416c6, // n0x138f c0x0000 (---------------)  + I presse
	0x002325c3, // n0x1390 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1391 c0x0000 (---------------)  + I gov
	0x0016aa83, // n0x1392 c0x0000 (---------------)  +   nyc
	0x00223a43, // n0x1393 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1394 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1395 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1396 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1397 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1398 c0x0000 (---------------)  + I org
	0x00101c07, // n0x1399 c0x0000 (---------------)  +   dscloud
	0x000f4e08, // n0x139a c0x0000 (---------------)  +   blogspot
	0x00264783, // n0x139b c0x0000 (---------------)  + I gov
	0x0022d0c3, // n0x139c c0x0000 (---------------)  + I com
	0x002325c3, // n0x139d c0x0000 (---------------)  + I edu
	0x00264783, // n0x139e c0x0000 (---------------)  + I gov
	0x0021e283, // n0x139f c0x0000 (---------------)  + I net
	0x00223a43, // n0x13a0 c0x0000 (---------------)  + I org
	0x3562d0c3, // n0x13a1 c0x00d5 (n0x13a5-n0x13a6)  + I com
	0x002325c3, // n0x13a2 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x13a3 c0x0000 (---------------)  + I net
	0x00223a43, // n0x13a4 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x13a5 c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x13a6 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x13a7 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x13a8 c0x0000 (---------------)  + I com
	0x00264783, // n0x13a9 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x13aa c0x0000 (---------------)  + I net
	0x00200282, // n0x13ab c0x0000 (---------------)  + I or
	0x00223a43, // n0x13ac c0x0000 (---------------)  + I org
	0x00301a47, // n0x13ad c0x0000 (---------------)  + I academy
	0x0032fd8b, // n0x13ae c0x0000 (---------------)  + I agriculture
	0x002055c3, // n0x13af c0x0000 (---------------)  + I air
	0x002474c8, // n0x13b0 c0x0000 (---------------)  + I airguard
	0x003383c7, // n0x13b1 c0x0000 (---------------)  + I alabama
	0x0027e486, // n0x13b2 c0x0000 (---------------)  + I alaska
	0x00362bc5, // n0x13b3 c0x0000 (---------------)  + I amber
	0x002b1b89, // n0x13b4 c0x0000 (---------------)  + I ambulance
	0x00241448, // n0x13b5 c0x0000 (---------------)  + I american
	0x00326909, // n0x13b6 c0x0000 (---------------)  + I americana
	0x00326910, // n0x13b7 c0x0000 (---------------)  + I americanantiques
	0x00352acb, // n0x13b8 c0x0000 (---------------)  + I americanart
	0x002b19c9, // n0x13b9 c0x0000 (---------------)  + I amsterdam
	0x00205dc3, // n0x13ba c0x0000 (---------------)  + I and
	0x00237309, // n0x13bb c0x0000 (---------------)  + I annefrank
	0x00231586, // n0x13bc c0x0000 (---------------)  + I anthro
	0x0023158c, // n0x13bd c0x0000 (---------------)  + I anthropology
	0x00205748, // n0x13be c0x0000 (---------------)  + I antiques
	0x0039dc48, // n0x13bf c0x0000 (---------------)  + I aquarium
	0x0024a689, // n0x13c0 c0x0000 (---------------)  + I arboretum
	0x0029814e, // n0x13c1 c0x0000 (---------------)  + I archaeological
	0x0036c78b, // n0x13c2 c0x0000 (---------------)  + I archaeology
	0x002c140c, // n0x13c3 c0x0000 (---------------)  + I architecture
	0x00203b03, // n0x13c4 c0x0000 (---------------)  + I art
	0x00239fcc, // n0x13c5 c0x0000 (---------------)  + I artanddesign
	0x00205089, // n0x13c6 c0x0000 (---------------)  + I artcenter
	0x00203c87, // n0x13c7 c0x0000 (---------------)  + I artdeco
	0x0023250c, // n0x13c8 c0x0000 (---------------)  + I arteducation
	0x0038b5ca, // n0x13c9 c0x0000 (---------------)  + I artgallery
	0x00244d04, // n0x13ca c0x0000 (---------------)  + I arts
	0x0024830d, // n0x13cb c0x0000 (---------------)  + I artsandcrafts
	0x00239e88, // n0x13cc c0x0000 (---------------)  + I asmatart
	0x0038770d, // n0x13cd c0x0000 (---------------)  + I assassination
	0x00241f86, // n0x13ce c0x0000 (---------------)  + I assisi
	0x002c7fcb, // n0x13cf c0x0000 (---------------)  + I association
	0x0026a789, // n0x13d0 c0x0000 (---------------)  + I astronomy
	0x0033c5c7, // n0x13d1 c0x0000 (---------------)  + I atlanta
	0x003093c6, // n0x13d2 c0x0000 (---------------)  + I austin
	0x003146c9, // n0x13d3 c0x0000 (---------------)  + I australia
	0x0031e88a, // n0x13d4 c0x0000 (---------------)  + I automotive
	0x00351c88, // n0x13d5 c0x0000 (---------------)  + I aviation
	0x002d96c4, // n0x13d6 c0x0000 (---------------)  + I axis
	0x0026fe87, // n0x13d7 c0x0000 (---------------)  + I badajoz
	0x0029b5c7, // n0x13d8 c0x0000 (---------------)  + I baghdad
	0x003266c4, // n0x13d9 c0x0000 (---------------)  + I bahn
	0x002379c4, // n0x13da c0x0000 (---------------)  + I bale
	0x0026a009, // n0x13db c0x0000 (---------------)  + I baltimore
	0x002bbe09, // n0x13dc c0x0000 (---------------)  + I barcelona
	0x002af3c8, // n0x13dd c0x0000 (---------------)  + I baseball
	0x0020d585, // n0x13de c0x0000 (---------------)  + I basel
	0x00381705, // n0x13df c0x0000 (---------------)  + I baths
	0x0020a4c6, // n0x13e0 c0x0000 (---------------)  + I bauern
	0x002481c9, // n0x13e1 c0x0000 (---------------)  + I beauxarts
	0x002034cd, // n0x13e2 c0x0000 (---------------)  + I beeldengeluid
	0x002c0e88, // n0x13e3 c0x0000 (---------------)  + I bellevue
	0x0020a3c7, // n0x13e4 c0x0000 (---------------)  + I bergbau
	0x00362c48, // n0x13e5 c0x0000 (---------------)  + I berkeley
	0x0030b7c6, // n0x13e6 c0x0000 (---------------)  + I berlin
	0x00386c84, // n0x13e7 c0x0000 (---------------)  + I bern
	0x00373745, // n0x13e8 c0x0000 (---------------)  + I bible
	0x00201ac6, // n0x13e9 c0x0000 (---------------)  + I bilbao
	0x00202a04, // n0x13ea c0x0000 (---------------)  + I bill
	0x00204f87, // n0x13eb c0x0000 (---------------)  + I birdart
	0x002073ca, // n0x13ec c0x0000 (---------------)  + I birthplace
	0x002101c4, // n0x13ed c0x0000 (---------------)  + I bonn
	0x00215f46, // n0x13ee c0x0000 (---------------)  + I boston
	0x00217749, // n0x13ef c0x0000 (---------------)  + I botanical
	0x0021774f, // n0x13f0 c0x0000 (---------------)  + I botanicalgarden
	0x0021930d, // n0x13f1 c0x0000 (---------------)  + I botanicgarden
	0x00219ac6, // n0x13f2 c0x0000 (---------------)  + I botany
	0x0021b4d0, // n0x13f3 c0x0000 (---------------)  + I brandywinevalley
	0x0021b8c6, // n0x13f4 c0x0000 (---------------)  + I brasil
	0x0021cc07, // n0x13f5 c0x0000 (---------------)  + I bristol
	0x0021cf87, // n0x13f6 c0x0000 (---------------)  + I british
	0x0021cf8f, // n0x13f7 c0x0000 (---------------)  + I britishcolumbia
	0x0021dec9, // n0x13f8 c0x0000 (---------------)  + I broadcast
	0x00221b46, // n0x13f9 c0x0000 (---------------)  + I brunel
	0x00223707, // n0x13fa c0x0000 (---------------)  + I brussel
	0x00223708, // n0x13fb c0x0000 (---------------)  + I brussels
	0x00223fc9, // n0x13fc c0x0000 (---------------)  + I bruxelles
	0x0023b308, // n0x13fd c0x0000 (---------------)  + I building
	0x002d0787, // n0x13fe c0x0000 (---------------)  + I burghof
	0x00205683, // n0x13ff c0x0000 (---------------)  + I bus
	0x0022cf46, // n0x1400 c0x0000 (---------------)  + I bushey
	0x0034e708, // n0x1401 c0x0000 (---------------)  + I cadaques
	0x0029840a, // n0x1402 c0x0000 (---------------)  + I california
	0x00229389, // n0x1403 c0x0000 (---------------)  + I cambridge
	0x0020b303, // n0x1404 c0x0000 (---------------)  + I can
	0x00325506, // n0x1405 c0x0000 (---------------)  + I canada
	0x0025bcca, // n0x1406 c0x0000 (---------------)  + I capebreton
	0x002dc547, // n0x1407 c0x0000 (---------------)  + I carrier
	0x00203aca, // n0x1408 c0x0000 (---------------)  + I cartoonart
	0x0020c5ce, // n0x1409 c0x0000 (---------------)  + I casadelamoneda
	0x0021e006, // n0x140a c0x0000 (---------------)  + I castle
	0x00283287, // n0x140b c0x0000 (---------------)  + I castres
	0x002112c6, // n0x140c c0x0000 (---------------)  + I celtic
	0x00205146, // n0x140d c0x0000 (---------------)  + I center
	0x0036efcb, // n0x140e c0x0000 (---------------)  + I chattanooga
	0x0024594a, // n0x140f c0x0000 (---------------)  + I cheltenham
	0x0027044d, // n0x1410 c0x0000 (---------------)  + I chesapeakebay
	0x00210d87, // n0x1411 c0x0000 (---------------)  + I chicago
	0x0026e088, // n0x1412 c0x0000 (---------------)  + I children
	0x0026e089, // n0x1413 c0x0000 (---------------)  + I childrens
	0x0026e08f, // n0x1414 c0x0000 (---------------)  + I childrensgarden
	0x0039b3cc, // n0x1415 c0x0000 (---------------)  + I chiropractic
	0x002ae289, // n0x1416 c0x0000 (---------------)  + I chocolate
	0x003722ce, // n0x1417 c0x0000 (---------------)  + I christiansburg
	0x0039a84a, // n0x1418 c0x0000 (---------------)  + I cincinnati
	0x0038cd06, // n0x1419 c0x0000 (---------------)  + I cinema
	0x0032da06, // n0x141a c0x0000 (---------------)  + I circus
	0x0035518c, // n0x141b c0x0000 (---------------)  + I civilisation
	0x0035f80c, // n0x141c c0x0000 (---------------)  + I civilization
	0x00363108, // n0x141d c0x0000 (---------------)  + I civilwar
	0x0037f087, // n0x141e c0x0000 (---------------)  + I clinton
	0x002a7405, // n0x141f c0x0000 (---------------)  + I clock
	0x003a4384, // n0x1420 c0x0000 (---------------)  + I coal
	0x0037ea8e, // n0x1421 c0x0000 (---------------)  + I coastaldefence
	0x0031eb04, // n0x1422 c0x0000 (---------------)  + I cody
	0x0022aa87, // n0x1423 c0x0000 (---------------)  + I coldwar
	0x0025d1ca, // n0x1424 c0x0000 (---------------)  + I collection
	0x0022b754, // n0x1425 c0x0000 (---------------)  + I colonialwilliamsburg
	0x0022c98f, // n0x1426 c0x0000 (---------------)  + I coloradoplateau
	0x0021d148, // n0x1427 c0x0000 (---------------)  + I columbia
	0x0022ce08, // n0x1428 c0x0000 (---------------)  + I columbus
	0x0035b94d, // n0x1429 c0x0000 (---------------)  + I communication
	0x0035b94e, // n0x142a c0x0000 (---------------)  + I communications
	0x0022d0c9, // n0x142b c0x0000 (---------------)  + I community
	0x0022edc8, // n0x142c c0x0000 (---------------)  + I computer
	0x0022edcf, // n0x142d c0x0000 (---------------)  + I computerhistory
	0x0023220c, // n0x142e c0x0000 (---------------)  + I contemporary
	0x0023220f, // n0x142f c0x0000 (---------------)  + I contemporaryart
	0x002335c7, // n0x1430 c0x0000 (---------------)  + I convent
	0x0023604a, // n0x1431 c0x0000 (---------------)  + I copenhagen
	0x0021adcb, // n0x1432 c0x0000 (---------------)  + I corporation
	0x0023a808, // n0x1433 c0x0000 (---------------)  + I corvette
	0x0023bc07, // n0x1434 c0x0000 (---------------)  + I costume
	0x0032ad8d, // n0x1435 c0x0000 (---------------)  + I countryestate
	0x002262c6, // n0x1436 c0x0000 (---------------)  + I county
	0x002484c6, // n0x1437 c0x0000 (---------------)  + I crafts
	0x0023d289, // n0x1438 c0x0000 (---------------)  + I cranbrook
	0x00316048, // n0x1439 c0x0000 (---------------)  + I creation
	0x00242208, // n0x143a c0x0000 (---------------)  + I cultural
	0x0024220e, // n0x143b c0x0000 (---------------)  + I culturalcenter
	0x0032db87, // n0x143c c0x0000 (---------------)  + I culture
	0x00238485, // n0x143d c0x0000 (---------------)  + I cyber
	0x00243645, // n0x143e c0x0000 (---------------)  + I cymru
	0x0020e584, // n0x143f c0x0000 (---------------)  + I dali
	0x0027e746, // n0x1440 c0x0000 (---------------)  + I dallas
	0x002af2c8, // n0x1441 c0x0000 (---------------)  + I database
	0x0033a183, // n0x1442 c0x0000 (---------------)  + I ddr
	0x00256d0e, // n0x1443 c0x0000 (---------------)  + I decorativearts
	0x0032b148, // n0x1444 c0x0000 (---------------)  + I delaware
	0x0027320b, // n0x1445 c0x0000 (---------------)  + I delmenhorst
	0x0024f007, // n0x1446 c0x0000 (---------------)  + I denmark
	0x0026ce85, // n0x1447 c0x0000 (---------------)  + I depot
	0x002289c6, // n0x1448 c0x0000 (---------------)  + I design
	0x002a3ec7, // n0x1449 c0x0000 (---------------)  + I detroit
	0x002f0c88, // n0x144a c0x0000 (---------------)  + I dinosaur
	0x00238bc9, // n0x144b c0x0000 (---------------)  + I discovery
	0x00226545, // n0x144c c0x0000 (---------------)  + I dolls
	0x00280348, // n0x144d c0x0000 (---------------)  + I donostia
	0x00211a86, // n0x144e c0x0000 (---------------)  + I durham
	0x00369bca, // n0x144f c0x0000 (---------------)  + I eastafrica
	0x0037e989, // n0x1450 c0x0000 (---------------)  + I eastcoast
	0x002325c9, // n0x1451 c0x0000 (---------------)  + I education
	0x002325cb, // n0x1452 c0x0000 (---------------)  + I educational
	0x00286548, // n0x1453 c0x0000 (---------------)  + I egyptian
	0x00326589, // n0x1454 c0x0000 (---------------)  + I eisenbahn
	0x0020d646, // n0x1455 c0x0000 (---------------)  + I elburg
	0x0027ffca, // n0x1456 c0x0000 (---------------)  + I elvendrell
	0x00237f4a, // n0x1457 c0x0000 (---------------)  + I embroidery
	0x0023624c, // n0x1458 c0x0000 (---------------)  + I encyclopedic
	0x00390807, // n0x1459 c0x0000 (---------------)  + I england
	0x0038be4a, // n0x145a c0x0000 (---------------)  + I entomology
	0x0033554b, // n0x145b c0x0000 (---------------)  + I environment
	0x00335559, // n0x145c c0x0000 (---------------)  + I environmentalconservation
	0x0031ffc8, // n0x145d c0x0000 (---------------)  + I epilepsy
	0x00241745, // n0x145e c0x0000 (---------------)  + I essex
	0x002bd5c6, // n0x145f c0x0000 (---------------)  + I estate
	0x00306249, // n0x1460 c0x0000 (---------------)  + I ethnology
	0x00210046, // n0x1461 c0x0000 (---------------)  + I exeter
	0x0020f28a, // n0x1462 c0x0000 (---------------)  + I exhibition
	0x0036a7c6, // n0x1463 c0x0000 (---------------)  + I family
	0x002bd744, // n0x1464 c0x0000 (---------------)  + I farm
	0x002bd74d, // n0x1465 c0x0000 (---------------)  + I farmequipment
	0x00338c47, // n0x1466 c0x0000 (---------------)  + I farmers
	0x002fe2c9, // n0x1467 c0x0000 (---------------)  + I farmstead
	0x00361805, // n0x1468 c0x0000 (---------------)  + I field
	0x00361bc8, // n0x1469 c0x0000 (---------------)  + I figueres
	0x003746c9, // n0x146a c0x0000 (---------------)  + I filatelia
	0x00244544, // n0x146b c0x0000 (---------------)  + I film
	0x00244c07, // n0x146c c0x0000 (---------------)  + I fineart
	0x00244c08, // n0x146d c0x0000 (---------------)  + I finearts
	0x00245187, // n0x146e c0x0000 (---------------)  + I finland
	0x0025e848, // n0x146f c0x0000 (---------------)  + I flanders
	0x0024bf47, // n0x1470 c0x0000 (---------------)  + I florida
	0x002330c5, // n0x1471 c0x0000 (---------------)  + I force
	0x0025334c, // n0x1472 c0x0000 (---------------)  + I fortmissoula
	0x00253f09, // n0x1473 c0x0000 (---------------)  + I fortworth
	0x002b3eca, // n0x1474 c0x0000 (---------------)  + I foundation
	0x0037dc09, // n0x1475 c0x0000 (---------------)  + I francaise
	0x00237409, // n0x1476 c0x0000 (---------------)  + I frankfurt
	0x0024864c, // n0x1477 c0x0000 (---------------)  + I franziskaner
	0x002e048b, // n0x1478 c0x0000 (---------------)  + I freemasonry
	0x00255dc8, // n0x1479 c0x0000 (---------------)  + I freiburg
	0x00257508, // n0x147a c0x0000 (---------------)  + I fribourg
	0x0025a8c4, // n0x147b c0x0000 (---------------)  + I frog
	0x0027ba88, // n0x147c c0x0000 (---------------)  + I fundacio
	0x0027d409, // n0x147d c0x0000 (---------------)  + I furniture
	0x0038b687, // n0x147e c0x0000 (---------------)  + I gallery
	0x00217986, // n0x147f c0x0000 (---------------)  + I garden
	0x0023f607, // n0x1480 c0x0000 (---------------)  + I gateway
	0x00238e49, // n0x1481 c0x0000 (---------------)  + I geelvinck
	0x0039044b, // n0x1482 c0x0000 (---------------)  + I gemological
	0x00317707, // n0x1483 c0x0000 (---------------)  + I geology
	0x0035bf87, // n0x1484 c0x0000 (---------------)  + I georgia
	0x0027e1c7, // n0x1485 c0x0000 (---------------)  + I giessen
	0x00387684, // n0x1486 c0x0000 (---------------)  + I glas
	0x00387685, // n0x1487 c0x0000 (---------------)  + I glass
	0x002a1cc5, // n0x1488 c0x0000 (---------------)  + I gorge
	0x00328ecb, // n0x1489 c0x0000 (---------------)  + I grandrapids
	0x00388c44, // n0x148a c0x0000 (---------------)  + I graz
	0x002defc8, // n0x148b c0x0000 (---------------)  + I guernsey
	0x00280f0a, // n0x148c c0x0000 (---------------)  + I halloffame
	0x00211b47, // n0x148d c0x0000 (---------------)  + I hamburg
	0x00315447, // n0x148e c0x0000 (---------------)  + I handson
	0x002850d2, // n0x148f c0x0000 (---------------)  + I harvestcelebration
	0x00250946, // n0x1490 c0x0000 (---------------)  + I hawaii
	0x00366f06, // n0x1491 c0x0000 (---------------)  + I health
	0x003188ce, // n0x1492 c0x0000 (---------------)  + I heimatunduhren
	0x00251906, // n0x1493 c0x0000 (---------------)  + I hellas
	0x00209748, // n0x1494 c0x0000 (---------------)  + I helsinki
	0x0028b44f, // n0x1495 c0x0000 (---------------)  + I hembygdsforbund
	0x00387ac8, // n0x1496 c0x0000 (---------------)  + I heritage
	0x0035a948, // n0x1497 c0x0000 (---------------)  + I histoire
	0x0035404a, // n0x1498 c0x0000 (---------------)  + I historical
	0x00354051, // n0x1499 c0x0000 (---------------)  + I historicalsociety
	0x0029bb4e, // n0x149a c0x0000 (---------------)  + I historichouses
	0x0025064a, // n0x149b c0x0000 (---------------)  + I historisch
	0x0025064c, // n0x149c c0x0000 (---------------)  + I historisches
	0x0022efc7, // n0x149d c0x0000 (---------------)  + I history
	0x0022efd0, // n0x149e c0x0000 (---------------)  + I historyofscience
	0x00200f08, // n0x149f c0x0000 (---------------)  + I horology
	0x0029bd45, // n0x14a0 c0x0000 (---------------)  + I house
	0x002a49ca, // n0x14a1 c0x0000 (---------------)  + I humanities
	0x00202a4c, // n0x14a2 c0x0000 (---------------)  + I illustration
	0x0028cc8d, // n0x14a3 c0x0000 (---------------)  + I imageandsound
	0x0029f1c6, // n0x14a4 c0x0000 (---------------)  + I indian
	0x0029f1c7, // n0x14a5 c0x0000 (---------------)  + I indiana
	0x0029f1cc, // n0x14a6 c0x0000 (---------------)  + I indianapolis
	0x002e530c, // n0x14a7 c0x0000 (---------------)  + I indianmarket
	0x002f634c, // n0x14a8 c0x0000 (---------------)  + I intelligence
	0x0033254b, // n0x14a9 c0x0000 (---------------)  + I interactive
	0x0027ef04, // n0x14aa c0x0000 (---------------)  + I iraq
	0x0021b384, // n0x14ab c0x0000 (---------------)  + I iron
	0x0034c509, // n0x14ac c0x0000 (---------------)  + I isleofman
	0x002c5547, // n0x14ad c0x0000 (---------------)  + I jamison
	0x0036f4c9, // n0x14ae c0x0000 (---------------)  + I jefferson
	0x00276489, // n0x14af c0x0000 (---------------)  + I jerusalem
	0x0035ca47, // n0x14b0 c0x0000 (---------------)  + I jewelry
	0x0038b446, // n0x14b1 c0x0000 (---------------)  + I jewish
	0x0038b449, // n0x14b2 c0x0000 (---------------)  + I jewishart
	0x003951c3, // n0x14b3 c0x0000 (---------------)  + I jfk
	0x0027728a, // n0x14b4 c0x0000 (---------------)  + I journalism
	0x003a45c7, // n0x14b5 c0x0000 (---------------)  + I judaica
	0x0020600b, // n0x14b6 c0x0000 (---------------)  + I judygarland
	0x002702ca, // n0x14b7 c0x0000 (---------------)  + I juedisches
	0x0022c084, // n0x14b8 c0x0000 (---------------)  + I juif
	0x0034fac6, // n0x14b9 c0x0000 (---------------)  + I karate
	0x00278609, // n0x14ba c0x0000 (---------------)  + I karikatur
	0x00286984, // n0x14bb c0x0000 (---------------)  + I kids
	0x00202dca, // n0x14bc c0x0000 (---------------)  + I koebenhavn
	0x00224885, // n0x14bd c0x0000 (---------------)  + I koeln
	0x002b0dc5, // n0x14be c0x0000 (---------------)  + I kunst
	0x002b0dcd, // n0x14bf c0x0000 (---------------)  + I kunstsammlung
	0x002b110e, // n0x14c0 c0x0000 (---------------)  + I kunstunddesign
	0x0030ea85, // n0x14c1 c0x0000 (---------------)  + I labor
	0x00384146, // n0x14c2 c0x0000 (---------------)  + I labour
	0x002412c7, // n0x14c3 c0x0000 (---------------)  + I lajolla
	0x002c864a, // n0x14c4 c0x0000 (---------------)  + I lancashire
	0x0031ee06, // n0x14c5 c0x0000 (---------------)  + I landes
	0x00356f84, // n0x14c6 c0x0000 (---------------)  + I lans
	0x002d9b47, // n0x14c7 c0x0000 (---------------)  + I larsson
	0x00214bcb, // n0x14c8 c0x0000 (---------------)  + I lewismiller
	0x0030b887, // n0x14c9 c0x0000 (---------------)  + I lincoln
	0x00397e84, // n0x14ca c0x0000 (---------------)  + I linz
	0x002d7ac6, // n0x14cb c0x0000 (---------------)  + I living
	0x002d7acd, // n0x14cc c0x0000 (---------------)  + I livinghistory
	0x00236f8c, // n0x14cd c0x0000 (---------------)  + I localhistory
	0x00313c86, // n0x14ce c0x0000 (---------------)  + I london
	0x002c108a, // n0x14cf c0x0000 (---------------)  + I losangeles
	0x00224f86, // n0x14d0 c0x0000 (---------------)  + I louvre
	0x00292208, // n0x14d1 c0x0000 (---------------)  + I loyalist
	0x002afdc7, // n0x14d2 c0x0000 (---------------)  + I lucerne
	0x0022c50a, // n0x14d3 c0x0000 (---------------)  + I luxembourg
	0x00234ec6, // n0x14d4 c0x0000 (---------------)  + I luzern
	0x00210c83, // n0x14d5 c0x0000 (---------------)  + I mad
	0x00310646, // n0x14d6 c0x0000 (---------------)  + I madrid
	0x00200188, // n0x14d7 c0x0000 (---------------)  + I mallorca
	0x00292d8a, // n0x14d8 c0x0000 (---------------)  + I manchester
	0x0024ab07, // n0x14d9 c0x0000 (---------------)  + I mansion
	0x0024ab08, // n0x14da c0x0000 (---------------)  + I mansions
	0x00262344, // n0x14db c0x0000 (---------------)  + I manx
	0x00271ec7, // n0x14dc c0x0000 (---------------)  + I marburg
	0x00218048, // n0x14dd c0x0000 (---------------)  + I maritime
	0x0029ca08, // n0x14de c0x0000 (---------------)  + I maritimo
	0x00250b48, // n0x14df c0x0000 (---------------)  + I maryland
	0x0027610a, // n0x14e0 c0x0000 (---------------)  + I marylhurst
	0x003a15c5, // n0x14e1 c0x0000 (---------------)  + I media
	0x00232ac7, // n0x14e2 c0x0000 (---------------)  + I medical
	0x00250493, // n0x14e3 c0x0000 (---------------)  + I medizinhistorisches
	0x00252786, // n0x14e4 c0x0000 (---------------)  + I meeres
	0x00399a08, // n0x14e5 c0x0000 (---------------)  + I memorial
	0x00221209, // n0x14e6 c0x0000 (---------------)  + I mesaverde
	0x00211e88, // n0x14e7 c0x0000 (---------------)  + I michigan
	0x00213d4b, // n0x14e8 c0x0000 (---------------)  + I midatlantic
	0x002b2b08, // n0x14e9 c0x0000 (---------------)  + I military
	0x00214d04, // n0x14ea c0x0000 (---------------)  + I mill
	0x00314246, // n0x14eb c0x0000 (---------------)  + I miners
	0x002f6e46, // n0x14ec c0x0000 (---------------)  + I mining
	0x002d2149, // n0x14ed c0x0000 (---------------)  + I minnesota
	0x002b9d07, // n0x14ee c0x0000 (---------------)  + I missile
	0x00253448, // n0x14ef c0x0000 (---------------)  + I missoula
	0x0038f3c6, // n0x14f0 c0x0000 (---------------)  + I modern
	0x0022a284, // n0x14f1 c0x0000 (---------------)  + I moma
	0x002c2f45, // n0x14f2 c0x0000 (---------------)  + I money
	0x002bc9c8, // n0x14f3 c0x0000 (---------------)  + I monmouth
	0x002bd10a, // n0x14f4 c0x0000 (---------------)  + I monticello
	0x002bd3c8, // n0x14f5 c0x0000 (---------------)  + I montreal
	0x002c3686, // n0x14f6 c0x0000 (---------------)  + I moscow
	0x0029348a, // n0x14f7 c0x0000 (---------------)  + I motorcycle
	0x002dec48, // n0x14f8 c0x0000 (---------------)  + I muenchen
	0x002c5b88, // n0x14f9 c0x0000 (---------------)  + I muenster
	0x002c6e88, // n0x14fa c0x0000 (---------------)  + I mulhouse
	0x002c7846, // n0x14fb c0x0000 (---------------)  + I muncie
	0x002c9c06, // n0x14fc c0x0000 (---------------)  + I museet
	0x002d5acc, // n0x14fd c0x0000 (---------------)  + I museumcenter
	0x002ca1d0, // n0x14fe c0x0000 (---------------)  + I museumvereniging
	0x002769c5, // n0x14ff c0x0000 (---------------)  + I music
	0x002f8248, // n0x1500 c0x0000 (---------------)  + I national
	0x002f8250, // n0x1501 c0x0000 (---------------)  + I nationalfirearms
	0x003878d0, // n0x1502 c0x0000 (---------------)  + I nationalheritage
	0x0032678e, // n0x1503 c0x0000 (---------------)  + I nativeamerican
	0x002d574e, // n0x1504 c0x0000 (---------------)  + I naturalhistory
	0x002d5754, // n0x1505 c0x0000 (---------------)  + I naturalhistorymuseum
	0x0030464f, // n0x1506 c0x0000 (---------------)  + I naturalsciences
	0x00304a06, // n0x1507 c0x0000 (---------------)  + I nature
	0x00309891, // n0x1508 c0x0000 (---------------)  + I naturhistorisches
	0x00335b53, // n0x1509 c0x0000 (---------------)  + I natuurwetenschappen
	0x00335fc8, // n0x150a c0x0000 (---------------)  + I naumburg
	0x00303c05, // n0x150b c0x0000 (---------------)  + I naval
	0x002724c8, // n0x150c c0x0000 (---------------)  + I nebraska
	0x002bc5c5, // n0x150d c0x0000 (---------------)  + I neues
	0x00226b8c, // n0x150e c0x0000 (---------------)  + I newhampshire
	0x00299b89, // n0x150f c0x0000 (---------------)  + I newjersey
	0x0022a8c9, // n0x1510 c0x0000 (---------------)  + I newmexico
	0x0023f387, // n0x1511 c0x0000 (---------------)  + I newport
	0x00229689, // n0x1512 c0x0000 (---------------)  + I newspaper
	0x00338e87, // n0x1513 c0x0000 (---------------)  + I newyork
	0x00287906, // n0x1514 c0x0000 (---------------)  + I niepce
	0x00373547, // n0x1515 c0x0000 (---------------)  + I norfolk
	0x00235205, // n0x1516 c0x0000 (---------------)  + I north
	0x00351e43, // n0x1517 c0x0000 (---------------)  + I nrw
	0x0033a349, // n0x1518 c0x0000 (---------------)  + I nuernberg
	0x0020a609, // n0x1519 c0x0000 (---------------)  + I nuremberg
	0x0036aa83, // n0x151a c0x0000 (---------------)  + I nyc
	0x00397b84, // n0x151b c0x0000 (---------------)  + I nyny
	0x003138cd, // n0x151c c0x0000 (---------------)  + I oceanographic
	0x0020074f, // n0x151d c0x0000 (---------------)  + I oceanographique
	0x002f2fc5, // n0x151e c0x0000 (---------------)  + I omaha
	0x00310ac6, // n0x151f c0x0000 (---------------)  + I online
	0x00208f87, // n0x1520 c0x0000 (---------------)  + I ontario
	0x0033ba87, // n0x1521 c0x0000 (---------------)  + I openair
	0x002828c6, // n0x1522 c0x0000 (---------------)  + I oregon
	0x002828cb, // n0x1523 c0x0000 (---------------)  + I oregontrail
	0x0029cf85, // n0x1524 c0x0000 (---------------)  + I otago
	0x00393506, // n0x1525 c0x0000 (---------------)  + I oxford
	0x00203947, // n0x1526 c0x0000 (---------------)  + I pacific
	0x00268789, // n0x1527 c0x0000 (---------------)  + I paderborn
	0x00350d46, // n0x1528 c0x0000 (---------------)  + I palace
	0x0020fc45, // n0x1529 c0x0000 (---------------)  + I paleo
	0x003520cb, // n0x152a c0x0000 (---------------)  + I palmsprings
	0x00359f46, // n0x152b c0x0000 (---------------)  + I panama
	0x00266185, // n0x152c c0x0000 (---------------)  + I paris
	0x002b0188, // n0x152d c0x0000 (---------------)  + I pasadena
	0x00349688, // n0x152e c0x0000 (---------------)  + I pharmacy
	0x002cd50c, // n0x152f c0x0000 (---------------)  + I philadelphia
	0x002cd510, // n0x1530 c0x0000 (---------------)  + I philadelphiaarea
	0x002cdbc9, // n0x1531 c0x0000 (---------------)  + I philately
	0x002ce007, // n0x1532 c0x0000 (---------------)  + I phoenix
	0x002ce48b, // n0x1533 c0x0000 (---------------)  + I photography
	0x002cf9c6, // n0x1534 c0x0000 (---------------)  + I pilots
	0x002d064a, // n0x1535 c0x0000 (---------------)  + I pittsburgh
	0x002d110b, // n0x1536 c0x0000 (---------------)  + I planetarium
	0x002d1a0a, // n0x1537 c0x0000 (---------------)  + I plantation
	0x002d1c86, // n0x1538 c0x0000 (---------------)  + I plants
	0x002d2dc5, // n0x1539 c0x0000 (---------------)  + I plaza
	0x003382c6, // n0x153a c0x0000 (---------------)  + I portal
	0x0027dd48, // n0x153b c0x0000 (---------------)  + I portland
	0x0023f44a, // n0x153c c0x0000 (---------------)  + I portlligat
	0x0035b5dc, // n0x153d c0x0000 (---------------)  + I posts-and-telecommunications
	0x002d9dcc, // n0x153e c0x0000 (---------------)  + I preservation
	0x002da0c8, // n0x153f c0x0000 (---------------)  + I presidio
	0x002416c5, // n0x1540 c0x0000 (---------------)  + I press
	0x002dc707, // n0x1541 c0x0000 (---------------)  + I project
	0x00297d86, // n0x1542 c0x0000 (---------------)  + I public
	0x0037b745, // n0x1543 c0x0000 (---------------)  + I pubol
	0x00219d86, // n0x1544 c0x0000 (---------------)  + I quebec
	0x00282a88, // n0x1545 c0x0000 (---------------)  + I railroad
	0x002acf07, // n0x1546 c0x0000 (---------------)  + I railway
	0x00298048, // n0x1547 c0x0000 (---------------)  + I research
	0x0028338a, // n0x1548 c0x0000 (---------------)  + I resistance
	0x00314a4c, // n0x1549 c0x0000 (---------------)  + I riodejaneiro
	0x00314cc9, // n0x154a c0x0000 (---------------)  + I rochester
	0x00393807, // n0x154b c0x0000 (---------------)  + I rockart
	0x00227684, // n0x154c c0x0000 (---------------)  + I roma
	0x0024c586, // n0x154d c0x0000 (---------------)  + I russia
	0x0035a4ca, // n0x154e c0x0000 (---------------)  + I saintlouis
	0x00276585, // n0x154f c0x0000 (---------------)  + I salem
	0x0031c54c, // n0x1550 c0x0000 (---------------)  + I salvadordali
	0x00341788, // n0x1551 c0x0000 (---------------)  + I salzburg
	0x0022e748, // n0x1552 c0x0000 (---------------)  + I sandiego
	0x003921cc, // n0x1553 c0x0000 (---------------)  + I sanfrancisco
	0x0020bc0c, // n0x1554 c0x0000 (---------------)  + I santabarbara
	0x0020ee49, // n0x1555 c0x0000 (---------------)  + I santacruz
	0x0020f087, // n0x1556 c0x0000 (---------------)  + I santafe
	0x0034e8cc, // n0x1557 c0x0000 (---------------)  + I saskatchewan
	0x002b0ac4, // n0x1558 c0x0000 (---------------)  + I satx
	0x0032ca4a, // n0x1559 c0x0000 (---------------)  + I savannahga
	0x003a2f4c, // n0x155a c0x0000 (---------------)  + I schlesisches
	0x0026974b, // n0x155b c0x0000 (---------------)  + I schoenbrunn
	0x0037f40b, // n0x155c c0x0000 (---------------)  + I schokoladen
	0x00381f46, // n0x155d c0x0000 (---------------)  + I school
	0x0022df47, // n0x155e c0x0000 (---------------)  + I schweiz
	0x0022f207, // n0x155f c0x0000 (---------------)  + I science
	0x0022f20f, // n0x1560 c0x0000 (---------------)  + I science-fiction
	0x002e5c51, // n0x1561 c0x0000 (---------------)  + I scienceandhistory
	0x00308852, // n0x1562 c0x0000 (---------------)  + I scienceandindustry
	0x0022f94d, // n0x1563 c0x0000 (---------------)  + I sciencecenter
	0x0022f94e, // n0x1564 c0x0000 (---------------)  + I sciencecenters
	0x0022fc8e, // n0x1565 c0x0000 (---------------)  + I sciencehistory
	0x00304808, // n0x1566 c0x0000 (---------------)  + I sciences
	0x00304812, // n0x1567 c0x0000 (---------------)  + I sciencesnaturelles
	0x00392408, // n0x1568 c0x0000 (---------------)  + I scotland
	0x002f09c7, // n0x1569 c0x0000 (---------------)  + I seaport
	0x00248fca, // n0x156a c0x0000 (---------------)  + I settlement
	0x0021f0c8, // n0x156b c0x0000 (---------------)  + I settlers
	0x002518c5, // n0x156c c0x0000 (---------------)  + I shell
	0x002e3e0a, // n0x156d c0x0000 (---------------)  + I sherbrooke
	0x0021ca07, // n0x156e c0x0000 (---------------)  + I sibenik
	0x00352e04, // n0x156f c0x0000 (---------------)  + I silk
	0x00244243, // n0x1570 c0x0000 (---------------)  + I ski
	0x0028f985, // n0x1571 c0x0000 (---------------)  + I skole
	0x003542c7, // n0x1572 c0x0000 (---------------)  + I society
	0x002dae47, // n0x1573 c0x0000 (---------------)  + I sologne
	0x0028ce8e, // n0x1574 c0x0000 (---------------)  + I soundandvision
	0x002fcb4d, // n0x1575 c0x0000 (---------------)  + I southcarolina
	0x00322409, // n0x1576 c0x0000 (---------------)  + I southwest
	0x002046c5, // n0x1577 c0x0000 (---------------)  + I space
	0x003278c3, // n0x1578 c0x0000 (---------------)  + I spy
	0x003a3206, // n0x1579 c0x0000 (---------------)  + I square
	0x00360045, // n0x157a c0x0000 (---------------)  + I stadt
	0x00273448, // n0x157b c0x0000 (---------------)  + I stalbans
	0x0031b309, // n0x157c c0x0000 (---------------)  + I starnberg
	0x00209d85, // n0x157d c0x0000 (---------------)  + I state
	0x0032af8f, // n0x157e c0x0000 (---------------)  + I stateofdelaware
	0x002d2c07, // n0x157f c0x0000 (---------------)  + I station
	0x00362a45, // n0x1580 c0x0000 (---------------)  + I steam
	0x002cc60a, // n0x1581 c0x0000 (---------------)  + I steiermark
	0x002faf06, // n0x1582 c0x0000 (---------------)  + I stjohn
	0x00292389, // n0x1583 c0x0000 (---------------)  + I stockholm
	0x002dfd8c, // n0x1584 c0x0000 (---------------)  + I stpetersburg
	0x002e1109, // n0x1585 c0x0000 (---------------)  + I stuttgart
	0x00201146, // n0x1586 c0x0000 (---------------)  + I suisse
	0x00280d0c, // n0x1587 c0x0000 (---------------)  + I surgeonshall
	0x002e1986, // n0x1588 c0x0000 (---------------)  + I surrey
	0x002e4188, // n0x1589 c0x0000 (---------------)  + I svizzera
	0x002e4386, // n0x158a c0x0000 (---------------)  + I sweden
	0x00320146, // n0x158b c0x0000 (---------------)  + I sydney
	0x00256684, // n0x158c c0x0000 (---------------)  + I tank
	0x00256143, // n0x158d c0x0000 (---------------)  + I tcm
	0x002a59ca, // n0x158e c0x0000 (---------------)  + I technology
	0x00227991, // n0x158f c0x0000 (---------------)  + I telekommunikation
	0x002ae44a, // n0x1590 c0x0000 (---------------)  + I television
	0x00349245, // n0x1591 c0x0000 (---------------)  + I texas
	0x0031d607, // n0x1592 c0x0000 (---------------)  + I textile
	0x00250e47, // n0x1593 c0x0000 (---------------)  + I theater
	0x00218144, // n0x1594 c0x0000 (---------------)  + I time
	0x0021814b, // n0x1595 c0x0000 (---------------)  + I timekeeping
	0x00398848, // n0x1596 c0x0000 (---------------)  + I topology
	0x002ab806, // n0x1597 c0x0000 (---------------)  + I torino
	0x002f9b05, // n0x1598 c0x0000 (---------------)  + I touch
	0x002afb44, // n0x1599 c0x0000 (---------------)  + I town
	0x002945c9, // n0x159a c0x0000 (---------------)  + I transport
	0x00300584, // n0x159b c0x0000 (---------------)  + I tree
	0x002b22c7, // n0x159c c0x0000 (---------------)  + I trolley
	0x0031f7c5, // n0x159d c0x0000 (---------------)  + I trust
	0x0031f7c7, // n0x159e c0x0000 (---------------)  + I trustee
	0x00318b05, // n0x159f c0x0000 (---------------)  + I uhren
	0x0023fe83, // n0x15a0 c0x0000 (---------------)  + I ulm
	0x002f0888, // n0x15a1 c0x0000 (---------------)  + I undersea
	0x003179ca, // n0x15a2 c0x0000 (---------------)  + I university
	0x002056c3, // n0x15a3 c0x0000 (---------------)  + I usa
	0x002056ca, // n0x15a4 c0x0000 (---------------)  + I usantiques
	0x002873c6, // n0x15a5 c0x0000 (---------------)  + I usarts
	0x0032ad0f, // n0x15a6 c0x0000 (---------------)  + I uscountryestate
	0x0032db09, // n0x15a7 c0x0000 (---------------)  + I usculture
	0x00256c90, // n0x15a8 c0x0000 (---------------)  + I usdecorativearts
	0x00265648, // n0x15a9 c0x0000 (---------------)  + I usgarden
	0x002c3f09, // n0x15aa c0x0000 (---------------)  + I ushistory
	0x00295e47, // n0x15ab c0x0000 (---------------)  + I ushuaia
	0x002d7a4f, // n0x15ac c0x0000 (---------------)  + I uslivinghistory
	0x002e0c44, // n0x15ad c0x0000 (---------------)  + I utah
	0x0034ec84, // n0x15ae c0x0000 (---------------)  + I uvic
	0x002175c6, // n0x15af c0x0000 (---------------)  + I valley
	0x00230906, // n0x15b0 c0x0000 (---------------)  + I vantaa
	0x0030e40a, // n0x15b1 c0x0000 (---------------)  + I versailles
	0x0022d5c6, // n0x15b2 c0x0000 (---------------)  + I viking
	0x002ecb87, // n0x15b3 c0x0000 (---------------)  + I village
	0x002edf48, // n0x15b4 c0x0000 (---------------)  + I virginia
	0x002ee147, // n0x15b5 c0x0000 (---------------)  + I virtual
	0x002ee307, // n0x15b6 c0x0000 (---------------)  + I virtuel
	0x0034374a, // n0x15b7 c0x0000 (---------------)  + I vlaanderen
	0x002f06cb, // n0x15b8 c0x0000 (---------------)  + I volkenkunde
	0x002c2085, // n0x15b9 c0x0000 (---------------)  + I wales
	0x00308488, // n0x15ba c0x0000 (---------------)  + I wallonie
	0x0022ab83, // n0x15bb c0x0000 (---------------)  + I war
	0x00289fcc, // n0x15bc c0x0000 (---------------)  + I washingtondc
	0x0037088f, // n0x15bd c0x0000 (---------------)  + I watch-and-clock
	0x002a720d, // n0x15be c0x0000 (---------------)  + I watchandclock
	0x00235347, // n0x15bf c0x0000 (---------------)  + I western
	0x00322549, // n0x15c0 c0x0000 (---------------)  + I westfalen
	0x00351ec7, // n0x15c1 c0x0000 (---------------)  + I whaling
	0x00244e48, // n0x15c2 c0x0000 (---------------)  + I wildlife
	0x0022b94c, // n0x15c3 c0x0000 (---------------)  + I williamsburg
	0x0025b988, // n0x15c4 c0x0000 (---------------)  + I windmill
	0x00382648, // n0x15c5 c0x0000 (---------------)  + I workshop
	0x00305ece, // n0x15c6 c0x0000 (---------------)  + I xn--9dbhblg6di
	0x00316254, // n0x15c7 c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x00316764, // n0x15c8 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x0033204a, // n0x15c9 c0x0000 (---------------)  + I xn--h1aegh
	0x0035370b, // n0x15ca c0x0000 (---------------)  + I xn--lns-qla
	0x00338f44, // n0x15cb c0x0000 (---------------)  + I york
	0x00338f49, // n0x15cc c0x0000 (---------------)  + I yorkshire
	0x002e2248, // n0x15cd c0x0000 (---------------)  + I yosemite
	0x00243d85, // n0x15ce c0x0000 (---------------)  + I youth
	0x00339c8a, // n0x15cf c0x0000 (---------------)  + I zoological
	0x003a33c7, // n0x15d0 c0x0000 (---------------)  + I zoology
	0x002dbdc4, // n0x15d1 c0x0000 (---------------)  + I aero
	0x00325b83, // n0x15d2 c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x15d3 c0x0000 (---------------)  + I com
	0x00235044, // n0x15d4 c0x0000 (---------------)  + I coop
	0x002325c3, // n0x15d5 c0x0000 (---------------)  + I edu
	0x00264783, // n0x15d6 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x15d7 c0x0000 (---------------)  + I info
	0x00267a43, // n0x15d8 c0x0000 (---------------)  + I int
	0x00214d03, // n0x15d9 c0x0000 (---------------)  + I mil
	0x002ca1c6, // n0x15da c0x0000 (---------------)  + I museum
	0x0020ff84, // n0x15db c0x0000 (---------------)  + I name
	0x0021e283, // n0x15dc c0x0000 (---------------)  + I net
	0x00223a43, // n0x15dd c0x0000 (---------------)  + I org
	0x00220443, // n0x15de c0x0000 (---------------)  + I pro
	0x00203982, // n0x15df c0x0000 (---------------)  + I ac
	0x00325b83, // n0x15e0 c0x0000 (---------------)  + I biz
	0x00203dc2, // n0x15e1 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x15e2 c0x0000 (---------------)  + I com
	0x00235044, // n0x15e3 c0x0000 (---------------)  + I coop
	0x002325c3, // n0x15e4 c0x0000 (---------------)  + I edu
	0x00264783, // n0x15e5 c0x0000 (---------------)  + I gov
	0x00267a43, // n0x15e6 c0x0000 (---------------)  + I int
	0x002ca1c6, // n0x15e7 c0x0000 (---------------)  + I museum
	0x0021e283, // n0x15e8 c0x0000 (---------------)  + I net
	0x00223a43, // n0x15e9 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x15ea c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x15eb c0x0000 (---------------)  + I com
	0x002325c3, // n0x15ec c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x15ed c0x0000 (---------------)  + I gob
	0x0021e283, // n0x15ee c0x0000 (---------------)  + I net
	0x00223a43, // n0x15ef c0x0000 (---------------)  + I org
	0x000f4e08, // n0x15f0 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x15f1 c0x0000 (---------------)  + I com
	0x002325c3, // n0x15f2 c0x0000 (---------------)  + I edu
	0x00264783, // n0x15f3 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x15f4 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x15f5 c0x0000 (---------------)  + I name
	0x0021e283, // n0x15f6 c0x0000 (---------------)  + I net
	0x00223a43, // n0x15f7 c0x0000 (---------------)  + I org
	0x006af1c8, // n0x15f8 c0x0001 (---------------)  ! I teledata
	0x00200302, // n0x15f9 c0x0000 (---------------)  + I ca
	0x0021e542, // n0x15fa c0x0000 (---------------)  + I cc
	0x00203dc2, // n0x15fb c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x15fc c0x0000 (---------------)  + I com
	0x00205c82, // n0x15fd c0x0000 (---------------)  + I dr
	0x00202082, // n0x15fe c0x0000 (---------------)  + I in
	0x003a4f84, // n0x15ff c0x0000 (---------------)  + I info
	0x00207c84, // n0x1600 c0x0000 (---------------)  + I mobi
	0x00216582, // n0x1601 c0x0000 (---------------)  + I mx
	0x0020ff84, // n0x1602 c0x0000 (---------------)  + I name
	0x00200282, // n0x1603 c0x0000 (---------------)  + I or
	0x00223a43, // n0x1604 c0x0000 (---------------)  + I org
	0x00220443, // n0x1605 c0x0000 (---------------)  + I pro
	0x00381f46, // n0x1606 c0x0000 (---------------)  + I school
	0x0020da42, // n0x1607 c0x0000 (---------------)  + I tv
	0x00201102, // n0x1608 c0x0000 (---------------)  + I us
	0x002044c2, // n0x1609 c0x0000 (---------------)  + I ws
	0x37e21143, // n0x160a c0x00df (n0x160c-n0x160d)  o I her
	0x38212fc3, // n0x160b c0x00e0 (n0x160d-n0x160e)  o I his
	0x000516c6, // n0x160c c0x0000 (---------------)  +   forgot
	0x000516c6, // n0x160d c0x0000 (---------------)  +   forgot
	0x002c7fc4, // n0x160e c0x0000 (---------------)  + I asso
	0x0011010c, // n0x160f c0x0000 (---------------)  +   at-band-camp
	0x0007984c, // n0x1610 c0x0000 (---------------)  +   azure-mobile
	0x000bb10d, // n0x1611 c0x0000 (---------------)  +   azurewebsites
	0x00025387, // n0x1612 c0x0000 (---------------)  +   blogdns
	0x0001ec08, // n0x1613 c0x0000 (---------------)  +   broke-it
	0x00191f8a, // n0x1614 c0x0000 (---------------)  +   buyshouses
	0x38e36505, // n0x1615 c0x00e3 (n0x1643-n0x1644)  o I cdn77
	0x00036509, // n0x1616 c0x0000 (---------------)  +   cdn77-ssl
	0x00101c88, // n0x1617 c0x0000 (---------------)  +   cloudapp
	0x0019614a, // n0x1618 c0x0000 (---------------)  +   cloudfront
	0x001480c8, // n0x1619 c0x0000 (---------------)  +   dnsalias
	0x000749c7, // n0x161a c0x0000 (---------------)  +   dnsdojo
	0x0000d8c7, // n0x161b c0x0000 (---------------)  +   does-it
	0x00165b89, // n0x161c c0x0000 (---------------)  +   dontexist
	0x001a2cc7, // n0x161d c0x0000 (---------------)  +   dsmynas
	0x00189b08, // n0x161e c0x0000 (---------------)  +   dynalias
	0x000ec389, // n0x161f c0x0000 (---------------)  +   dynathome
	0x000a2acd, // n0x1620 c0x0000 (---------------)  +   endofinternet
	0x001a2b48, // n0x1621 c0x0000 (---------------)  +   familyds
	0x3923ba86, // n0x1622 c0x00e4 (n0x1644-n0x1646)  o I fastly
	0x0005b7c7, // n0x1623 c0x0000 (---------------)  +   from-az
	0x0005d087, // n0x1624 c0x0000 (---------------)  +   from-co
	0x00061e07, // n0x1625 c0x0000 (---------------)  +   from-la
	0x00067c87, // n0x1626 c0x0000 (---------------)  +   from-ny
	0x0000a482, // n0x1627 c0x0000 (---------------)  +   gb
	0x00039a87, // n0x1628 c0x0000 (---------------)  +   gets-it
	0x00045b0c, // n0x1629 c0x0000 (---------------)  +   ham-radio-op
	0x00141e07, // n0x162a c0x0000 (---------------)  +   homeftp
	0x0009ea06, // n0x162b c0x0000 (---------------)  +   homeip
	0x0009f749, // n0x162c c0x0000 (---------------)  +   homelinux
	0x000a0bc8, // n0x162d c0x0000 (---------------)  +   homeunix
	0x00022f82, // n0x162e c0x0000 (---------------)  +   hu
	0x00002082, // n0x162f c0x0000 (---------------)  +   in
	0x001982cb, // n0x1630 c0x0000 (---------------)  +   in-the-band
	0x00011709, // n0x1631 c0x0000 (---------------)  +   is-a-chef
	0x00043289, // n0x1632 c0x0000 (---------------)  +   is-a-geek
	0x000fdf48, // n0x1633 c0x0000 (---------------)  +   isa-geek
	0x000a8442, // n0x1634 c0x0000 (---------------)  +   jp
	0x0014d5c9, // n0x1635 c0x0000 (---------------)  +   kicks-ass
	0x00028f4d, // n0x1636 c0x0000 (---------------)  +   office-on-the
	0x000d67c7, // n0x1637 c0x0000 (---------------)  +   podzone
	0x001388c8, // n0x1638 c0x0000 (---------------)  +   rackmaze
	0x0003d74d, // n0x1639 c0x0000 (---------------)  +   scrapper-site
	0x00001242, // n0x163a c0x0000 (---------------)  +   se
	0x000636c6, // n0x163b c0x0000 (---------------)  +   selfip
	0x0008a788, // n0x163c c0x0000 (---------------)  +   sells-it
	0x000c7008, // n0x163d c0x0000 (---------------)  +   servebbs
	0x0006ef08, // n0x163e c0x0000 (---------------)  +   serveftp
	0x0004d048, // n0x163f c0x0000 (---------------)  +   thruhere
	0x00000bc2, // n0x1640 c0x0000 (---------------)  +   uk
	0x001374c6, // n0x1641 c0x0000 (---------------)  +   webhop
	0x0000a182, // n0x1642 c0x0000 (---------------)  +   za
	0x000002c1, // n0x1643 c0x0000 (---------------)  +   r
	0x396dabc4, // n0x1644 c0x00e5 (n0x1646-n0x1648)  o I prod
	0x39a36683, // n0x1645 c0x00e6 (n0x1648-n0x164b)  o I ssl
	0x00000101, // n0x1646 c0x0000 (---------------)  +   a
	0x0000ac06, // n0x1647 c0x0000 (---------------)  +   global
	0x00000101, // n0x1648 c0x0000 (---------------)  +   a
	0x00000001, // n0x1649 c0x0000 (---------------)  +   b
	0x0000ac06, // n0x164a c0x0000 (---------------)  +   global
	0x00244d04, // n0x164b c0x0000 (---------------)  + I arts
	0x0022d0c3, // n0x164c c0x0000 (---------------)  + I com
	0x00246bc4, // n0x164d c0x0000 (---------------)  + I firm
	0x003a4f84, // n0x164e c0x0000 (---------------)  + I info
	0x0021e283, // n0x164f c0x0000 (---------------)  + I net
	0x002210c5, // n0x1650 c0x0000 (---------------)  + I other
	0x00220503, // n0x1651 c0x0000 (---------------)  + I per
	0x00226e03, // n0x1652 c0x0000 (---------------)  + I rec
	0x003758c5, // n0x1653 c0x0000 (---------------)  + I store
	0x002292c3, // n0x1654 c0x0000 (---------------)  + I web
	0x3a62d0c3, // n0x1655 c0x00e9 (n0x165e-n0x165f)  + I com
	0x002325c3, // n0x1656 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1657 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1658 c0x0000 (---------------)  + I mil
	0x00207c84, // n0x1659 c0x0000 (---------------)  + I mobi
	0x0020ff84, // n0x165a c0x0000 (---------------)  + I name
	0x0021e283, // n0x165b c0x0000 (---------------)  + I net
	0x00223a43, // n0x165c c0x0000 (---------------)  + I org
	0x00213403, // n0x165d c0x0000 (---------------)  + I sch
	0x000f4e08, // n0x165e c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x165f c0x0000 (---------------)  + I ac
	0x00325b83, // n0x1660 c0x0000 (---------------)  + I biz
	0x00203dc2, // n0x1661 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1662 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1663 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x1664 c0x0000 (---------------)  + I gob
	0x00202082, // n0x1665 c0x0000 (---------------)  + I in
	0x003a4f84, // n0x1666 c0x0000 (---------------)  + I info
	0x00267a43, // n0x1667 c0x0000 (---------------)  + I int
	0x00214d03, // n0x1668 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1669 c0x0000 (---------------)  + I net
	0x0020f543, // n0x166a c0x0000 (---------------)  + I nom
	0x00223a43, // n0x166b c0x0000 (---------------)  + I org
	0x002292c3, // n0x166c c0x0000 (---------------)  + I web
	0x000f4e08, // n0x166d c0x0000 (---------------)  +   blogspot
	0x00361402, // n0x166e c0x0000 (---------------)  + I bv
	0x00003dc2, // n0x166f c0x0000 (---------------)  +   co
	0x3b621f42, // n0x1670 c0x00ed (n0x1946-n0x1947)  + I aa
	0x002ffc48, // n0x1671 c0x0000 (---------------)  + I aarborte
	0x002223c6, // n0x1672 c0x0000 (---------------)  + I aejrie
	0x002b6606, // n0x1673 c0x0000 (---------------)  + I afjord
	0x00221d47, // n0x1674 c0x0000 (---------------)  + I agdenes
	0x3ba09982, // n0x1675 c0x00ee (n0x1947-n0x1948)  + I ah
	0x3bf1e048, // n0x1676 c0x00ef (n0x1948-n0x1949)  o I akershus
	0x003a244a, // n0x1677 c0x0000 (---------------)  + I aknoluokta
	0x0025b248, // n0x1678 c0x0000 (---------------)  + I akrehamn
	0x002001c2, // n0x1679 c0x0000 (---------------)  + I al
	0x003a4409, // n0x167a c0x0000 (---------------)  + I alaheadju
	0x002c20c7, // n0x167b c0x0000 (---------------)  + I alesund
	0x00217906, // n0x167c c0x0000 (---------------)  + I algard
	0x0032bec9, // n0x167d c0x0000 (---------------)  + I alstahaug
	0x00232c04, // n0x167e c0x0000 (---------------)  + I alta
	0x002b7086, // n0x167f c0x0000 (---------------)  + I alvdal
	0x002b6a04, // n0x1680 c0x0000 (---------------)  + I amli
	0x002715c4, // n0x1681 c0x0000 (---------------)  + I amot
	0x00252f89, // n0x1682 c0x0000 (---------------)  + I andasuolo
	0x00205dc6, // n0x1683 c0x0000 (---------------)  + I andebu
	0x00229bc5, // n0x1684 c0x0000 (---------------)  + I andoy
	0x0025f985, // n0x1685 c0x0000 (---------------)  + I ardal
	0x0022db47, // n0x1686 c0x0000 (---------------)  + I aremark
	0x002b2f87, // n0x1687 c0x0000 (---------------)  + I arendal
	0x00336ac4, // n0x1688 c0x0000 (---------------)  + I arna
	0x00221f86, // n0x1689 c0x0000 (---------------)  + I aseral
	0x002db685, // n0x168a c0x0000 (---------------)  + I asker
	0x0034e345, // n0x168b c0x0000 (---------------)  + I askim
	0x002ea2c5, // n0x168c c0x0000 (---------------)  + I askoy
	0x003814c7, // n0x168d c0x0000 (---------------)  + I askvoll
	0x0024ee45, // n0x168e c0x0000 (---------------)  + I asnes
	0x00300b09, // n0x168f c0x0000 (---------------)  + I audnedaln
	0x002d4f45, // n0x1690 c0x0000 (---------------)  + I aukra
	0x002f0dc4, // n0x1691 c0x0000 (---------------)  + I aure
	0x0031ed47, // n0x1692 c0x0000 (---------------)  + I aurland
	0x002fea4e, // n0x1693 c0x0000 (---------------)  + I aurskog-holand
	0x00304289, // n0x1694 c0x0000 (---------------)  + I austevoll
	0x00318789, // n0x1695 c0x0000 (---------------)  + I austrheim
	0x00335386, // n0x1696 c0x0000 (---------------)  + I averoy
	0x002e6488, // n0x1697 c0x0000 (---------------)  + I badaddja
	0x002a7e8b, // n0x1698 c0x0000 (---------------)  + I bahcavuotna
	0x002cb80c, // n0x1699 c0x0000 (---------------)  + I bahccavuotna
	0x00262086, // n0x169a c0x0000 (---------------)  + I baidar
	0x0036c647, // n0x169b c0x0000 (---------------)  + I bajddar
	0x00225e05, // n0x169c c0x0000 (---------------)  + I balat
	0x002379ca, // n0x169d c0x0000 (---------------)  + I balestrand
	0x00302a09, // n0x169e c0x0000 (---------------)  + I ballangen
	0x002562c9, // n0x169f c0x0000 (---------------)  + I balsfjord
	0x003953c6, // n0x16a0 c0x0000 (---------------)  + I bamble
	0x002e35c5, // n0x16a1 c0x0000 (---------------)  + I bardu
	0x00278d45, // n0x16a2 c0x0000 (---------------)  + I barum
	0x00350ac9, // n0x16a3 c0x0000 (---------------)  + I batsfjord
	0x002ea44b, // n0x16a4 c0x0000 (---------------)  + I bearalvahki
	0x00274686, // n0x16a5 c0x0000 (---------------)  + I beardu
	0x00324586, // n0x16a6 c0x0000 (---------------)  + I beiarn
	0x0020a3c4, // n0x16a7 c0x0000 (---------------)  + I berg
	0x00284d86, // n0x16a8 c0x0000 (---------------)  + I bergen
	0x00238508, // n0x16a9 c0x0000 (---------------)  + I berlevag
	0x00200006, // n0x16aa c0x0000 (---------------)  + I bievat
	0x003871c6, // n0x16ab c0x0000 (---------------)  + I bindal
	0x002065c8, // n0x16ac c0x0000 (---------------)  + I birkenes
	0x00207647, // n0x16ad c0x0000 (---------------)  + I bjarkoy
	0x00207a49, // n0x16ae c0x0000 (---------------)  + I bjerkreim
	0x00208205, // n0x16af c0x0000 (---------------)  + I bjugn
	0x000f4e08, // n0x16b0 c0x0000 (---------------)  +   blogspot
	0x0020d844, // n0x16b1 c0x0000 (---------------)  + I bodo
	0x002ef284, // n0x16b2 c0x0000 (---------------)  + I bokn
	0x0020ec85, // n0x16b3 c0x0000 (---------------)  + I bomlo
	0x00385409, // n0x16b4 c0x0000 (---------------)  + I bremanger
	0x00220887, // n0x16b5 c0x0000 (---------------)  + I bronnoy
	0x0022088b, // n0x16b6 c0x0000 (---------------)  + I bronnoysund
	0x0022164a, // n0x16b7 c0x0000 (---------------)  + I brumunddal
	0x00225b05, // n0x16b8 c0x0000 (---------------)  + I bryne
	0x3c205682, // n0x16b9 c0x00f0 (n0x1949-n0x194a)  + I bu
	0x00205ec7, // n0x16ba c0x0000 (---------------)  + I budejju
	0x3c626948, // n0x16bb c0x00f1 (n0x194a-n0x194b)  o I buskerud
	0x002cb3c7, // n0x16bc c0x0000 (---------------)  + I bygland
	0x002ae045, // n0x16bd c0x0000 (---------------)  + I bykle
	0x00236d8a, // n0x16be c0x0000 (---------------)  + I cahcesuolo
	0x00003dc2, // n0x16bf c0x0000 (---------------)  +   co
	0x0025c9cb, // n0x16c0 c0x0000 (---------------)  + I davvenjarga
	0x0020c8ca, // n0x16c1 c0x0000 (---------------)  + I davvesiida
	0x00393646, // n0x16c2 c0x0000 (---------------)  + I deatnu
	0x0026ce83, // n0x16c3 c0x0000 (---------------)  + I dep
	0x00399d4d, // n0x16c4 c0x0000 (---------------)  + I dielddanuorri
	0x002fe4cc, // n0x16c5 c0x0000 (---------------)  + I divtasvuodna
	0x0030344d, // n0x16c6 c0x0000 (---------------)  + I divttasvuotna
	0x00359745, // n0x16c7 c0x0000 (---------------)  + I donna
	0x00261b45, // n0x16c8 c0x0000 (---------------)  + I dovre
	0x0033a1c7, // n0x16c9 c0x0000 (---------------)  + I drammen
	0x003925c9, // n0x16ca c0x0000 (---------------)  + I drangedal
	0x003a2346, // n0x16cb c0x0000 (---------------)  + I drobak
	0x0022d445, // n0x16cc c0x0000 (---------------)  + I dyroy
	0x0021e688, // n0x16cd c0x0000 (---------------)  + I egersund
	0x002727c3, // n0x16ce c0x0000 (---------------)  + I eid
	0x0030b3c8, // n0x16cf c0x0000 (---------------)  + I eidfjord
	0x00284c88, // n0x16d0 c0x0000 (---------------)  + I eidsberg
	0x002b7f87, // n0x16d1 c0x0000 (---------------)  + I eidskog
	0x002727c8, // n0x16d2 c0x0000 (---------------)  + I eidsvoll
	0x003a1f49, // n0x16d3 c0x0000 (---------------)  + I eigersund
	0x002343c7, // n0x16d4 c0x0000 (---------------)  + I elverum
	0x002ff647, // n0x16d5 c0x0000 (---------------)  + I enebakk
	0x0027e308, // n0x16d6 c0x0000 (---------------)  + I engerdal
	0x002f2a84, // n0x16d7 c0x0000 (---------------)  + I etne
	0x002f2a87, // n0x16d8 c0x0000 (---------------)  + I etnedal
	0x00241e88, // n0x16d9 c0x0000 (---------------)  + I evenassi
	0x00201d46, // n0x16da c0x0000 (---------------)  + I evenes
	0x0037c54f, // n0x16db c0x0000 (---------------)  + I evje-og-hornnes
	0x00211907, // n0x16dc c0x0000 (---------------)  + I farsund
	0x00240586, // n0x16dd c0x0000 (---------------)  + I fauske
	0x00246e85, // n0x16de c0x0000 (---------------)  + I fedje
	0x00340703, // n0x16df c0x0000 (---------------)  + I fet
	0x00340707, // n0x16e0 c0x0000 (---------------)  + I fetsund
	0x0022b203, // n0x16e1 c0x0000 (---------------)  + I fhs
	0x00245346, // n0x16e2 c0x0000 (---------------)  + I finnoy
	0x00247c86, // n0x16e3 c0x0000 (---------------)  + I fitjar
	0x00249386, // n0x16e4 c0x0000 (---------------)  + I fjaler
	0x00288985, // n0x16e5 c0x0000 (---------------)  + I fjell
	0x0025e843, // n0x16e6 c0x0000 (---------------)  + I fla
	0x00377cc8, // n0x16e7 c0x0000 (---------------)  + I flakstad
	0x003941c9, // n0x16e8 c0x0000 (---------------)  + I flatanger
	0x0036090b, // n0x16e9 c0x0000 (---------------)  + I flekkefjord
	0x00370f48, // n0x16ea c0x0000 (---------------)  + I flesberg
	0x0024bc05, // n0x16eb c0x0000 (---------------)  + I flora
	0x0024c705, // n0x16ec c0x0000 (---------------)  + I floro
	0x3ca2c142, // n0x16ed c0x00f2 (n0x194b-n0x194c)  + I fm
	0x00373609, // n0x16ee c0x0000 (---------------)  + I folkebibl
	0x0024f747, // n0x16ef c0x0000 (---------------)  + I folldal
	0x00393585, // n0x16f0 c0x0000 (---------------)  + I forde
	0x00252e87, // n0x16f1 c0x0000 (---------------)  + I forsand
	0x002552c6, // n0x16f2 c0x0000 (---------------)  + I fosnes
	0x00358705, // n0x16f3 c0x0000 (---------------)  + I frana
	0x0035fe8b, // n0x16f4 c0x0000 (---------------)  + I fredrikstad
	0x00255dc4, // n0x16f5 c0x0000 (---------------)  + I frei
	0x0025ae05, // n0x16f6 c0x0000 (---------------)  + I frogn
	0x0025af47, // n0x16f7 c0x0000 (---------------)  + I froland
	0x0026f886, // n0x16f8 c0x0000 (---------------)  + I frosta
	0x0026fcc5, // n0x16f9 c0x0000 (---------------)  + I froya
	0x0027bc87, // n0x16fa c0x0000 (---------------)  + I fuoisku
	0x0027cd07, // n0x16fb c0x0000 (---------------)  + I fuossko
	0x00287384, // n0x16fc c0x0000 (---------------)  + I fusa
	0x00283d8a, // n0x16fd c0x0000 (---------------)  + I fylkesbibl
	0x00284248, // n0x16fe c0x0000 (---------------)  + I fyresdal
	0x0038c509, // n0x16ff c0x0000 (---------------)  + I gaivuotna
	0x0021cdc5, // n0x1700 c0x0000 (---------------)  + I galsa
	0x0025cc06, // n0x1701 c0x0000 (---------------)  + I gamvik
	0x002386ca, // n0x1702 c0x0000 (---------------)  + I gangaviika
	0x0025f886, // n0x1703 c0x0000 (---------------)  + I gaular
	0x002af807, // n0x1704 c0x0000 (---------------)  + I gausdal
	0x0038c1cd, // n0x1705 c0x0000 (---------------)  + I giehtavuoatna
	0x00264f09, // n0x1706 c0x0000 (---------------)  + I gildeskal
	0x0023a605, // n0x1707 c0x0000 (---------------)  + I giske
	0x0026b947, // n0x1708 c0x0000 (---------------)  + I gjemnes
	0x00319048, // n0x1709 c0x0000 (---------------)  + I gjerdrum
	0x00336188, // n0x170a c0x0000 (---------------)  + I gjerstad
	0x00342747, // n0x170b c0x0000 (---------------)  + I gjesdal
	0x00318446, // n0x170c c0x0000 (---------------)  + I gjovik
	0x002108c7, // n0x170d c0x0000 (---------------)  + I gloppen
	0x00246dc3, // n0x170e c0x0000 (---------------)  + I gol
	0x00328ec4, // n0x170f c0x0000 (---------------)  + I gran
	0x003556c5, // n0x1710 c0x0000 (---------------)  + I grane
	0x0037cd47, // n0x1711 c0x0000 (---------------)  + I granvin
	0x00380ec9, // n0x1712 c0x0000 (---------------)  + I gratangen
	0x00219f48, // n0x1713 c0x0000 (---------------)  + I grimstad
	0x002af705, // n0x1714 c0x0000 (---------------)  + I grong
	0x00372604, // n0x1715 c0x0000 (---------------)  + I grue
	0x0022d705, // n0x1716 c0x0000 (---------------)  + I gulen
	0x0023fb8d, // n0x1717 c0x0000 (---------------)  + I guovdageaidnu
	0x00202f42, // n0x1718 c0x0000 (---------------)  + I ha
	0x0035ab46, // n0x1719 c0x0000 (---------------)  + I habmer
	0x00263606, // n0x171a c0x0000 (---------------)  + I hadsel
	0x0029fbca, // n0x171b c0x0000 (---------------)  + I hagebostad
	0x00346d46, // n0x171c c0x0000 (---------------)  + I halden
	0x0035a405, // n0x171d c0x0000 (---------------)  + I halsa
	0x002ff385, // n0x171e c0x0000 (---------------)  + I hamar
	0x002ff387, // n0x171f c0x0000 (---------------)  + I hamaroy
	0x00369a0c, // n0x1720 c0x0000 (---------------)  + I hammarfeasta
	0x002776ca, // n0x1721 c0x0000 (---------------)  + I hammerfest
	0x00284646, // n0x1722 c0x0000 (---------------)  + I hapmir
	0x002ba7c5, // n0x1723 c0x0000 (---------------)  + I haram
	0x00284bc6, // n0x1724 c0x0000 (---------------)  + I hareid
	0x00284f07, // n0x1725 c0x0000 (---------------)  + I harstad
	0x00286246, // n0x1726 c0x0000 (---------------)  + I hasvik
	0x0028888c, // n0x1727 c0x0000 (---------------)  + I hattfjelldal
	0x0032c009, // n0x1728 c0x0000 (---------------)  + I haugesund
	0x3ce30347, // n0x1729 c0x00f3 (n0x194c-n0x194f)  o I hedmark
	0x0028b805, // n0x172a c0x0000 (---------------)  + I hemne
	0x0028b806, // n0x172b c0x0000 (---------------)  + I hemnes
	0x0028be48, // n0x172c c0x0000 (---------------)  + I hemsedal
	0x002aa345, // n0x172d c0x0000 (---------------)  + I herad
	0x0029ddc5, // n0x172e c0x0000 (---------------)  + I hitra
	0x0029e008, // n0x172f c0x0000 (---------------)  + I hjartdal
	0x0029e20a, // n0x1730 c0x0000 (---------------)  + I hjelmeland
	0x3d24e142, // n0x1731 c0x00f4 (n0x194f-n0x1950)  + I hl
	0x3d60b742, // n0x1732 c0x00f5 (n0x1950-n0x1951)  + I hm
	0x00371e85, // n0x1733 c0x0000 (---------------)  + I hobol
	0x002b0603, // n0x1734 c0x0000 (---------------)  + I hof
	0x003822c8, // n0x1735 c0x0000 (---------------)  + I hokksund
	0x002924c3, // n0x1736 c0x0000 (---------------)  + I hol
	0x0029e484, // n0x1737 c0x0000 (---------------)  + I hole
	0x002924cb, // n0x1738 c0x0000 (---------------)  + I holmestrand
	0x002a8248, // n0x1739 c0x0000 (---------------)  + I holtalen
	0x002a13c8, // n0x173a c0x0000 (---------------)  + I honefoss
	0x3db1db89, // n0x173b c0x00f6 (n0x1951-n0x1952)  o I hordaland
	0x002a2549, // n0x173c c0x0000 (---------------)  + I hornindal
	0x002a29c6, // n0x173d c0x0000 (---------------)  + I horten
	0x002a3b48, // n0x173e c0x0000 (---------------)  + I hoyanger
	0x002a3d49, // n0x173f c0x0000 (---------------)  + I hoylandet
	0x002a5186, // n0x1740 c0x0000 (---------------)  + I hurdal
	0x002a5305, // n0x1741 c0x0000 (---------------)  + I hurum
	0x0035f206, // n0x1742 c0x0000 (---------------)  + I hvaler
	0x002a5c49, // n0x1743 c0x0000 (---------------)  + I hyllestad
	0x00238a47, // n0x1744 c0x0000 (---------------)  + I ibestad
	0x00265cc6, // n0x1745 c0x0000 (---------------)  + I idrett
	0x00376387, // n0x1746 c0x0000 (---------------)  + I inderoy
	0x003a21c7, // n0x1747 c0x0000 (---------------)  + I iveland
	0x00275404, // n0x1748 c0x0000 (---------------)  + I ivgu
	0x3de1ba49, // n0x1749 c0x00f7 (n0x1952-n0x1953)  + I jan-mayen
	0x002c0788, // n0x174a c0x0000 (---------------)  + I jessheim
	0x00351648, // n0x174b c0x0000 (---------------)  + I jevnaker
	0x0022c7c7, // n0x174c c0x0000 (---------------)  + I jolster
	0x002bbb86, // n0x174d c0x0000 (---------------)  + I jondal
	0x002f31c9, // n0x174e c0x0000 (---------------)  + I jorpeland
	0x002b7547, // n0x174f c0x0000 (---------------)  + I kafjord
	0x0025494a, // n0x1750 c0x0000 (---------------)  + I karasjohka
	0x002e7108, // n0x1751 c0x0000 (---------------)  + I karasjok
	0x00239047, // n0x1752 c0x0000 (---------------)  + I karlsoy
	0x00239506, // n0x1753 c0x0000 (---------------)  + I karmoy
	0x0021dc4a, // n0x1754 c0x0000 (---------------)  + I kautokeino
	0x00276fc8, // n0x1755 c0x0000 (---------------)  + I kirkenes
	0x00263085, // n0x1756 c0x0000 (---------------)  + I klabu
	0x0022a045, // n0x1757 c0x0000 (---------------)  + I klepp
	0x002ac7c7, // n0x1758 c0x0000 (---------------)  + I kommune
	0x002bf7c9, // n0x1759 c0x0000 (---------------)  + I kongsberg
	0x002c4acb, // n0x175a c0x0000 (---------------)  + I kongsvinger
	0x002cfd88, // n0x175b c0x0000 (---------------)  + I kopervik
	0x002d4fc9, // n0x175c c0x0000 (---------------)  + I kraanghke
	0x00249607, // n0x175d c0x0000 (---------------)  + I kragero
	0x002a95cc, // n0x175e c0x0000 (---------------)  + I kristiansand
	0x002a9f0c, // n0x175f c0x0000 (---------------)  + I kristiansund
	0x002aa20a, // n0x1760 c0x0000 (---------------)  + I krodsherad
	0x002aa48c, // n0x1761 c0x0000 (---------------)  + I krokstadelva
	0x002b6588, // n0x1762 c0x0000 (---------------)  + I kvafjord
	0x002b6788, // n0x1763 c0x0000 (---------------)  + I kvalsund
	0x002b6984, // n0x1764 c0x0000 (---------------)  + I kvam
	0x002b7709, // n0x1765 c0x0000 (---------------)  + I kvanangen
	0x002b7949, // n0x1766 c0x0000 (---------------)  + I kvinesdal
	0x002b7b8a, // n0x1767 c0x0000 (---------------)  + I kvinnherad
	0x002b7e09, // n0x1768 c0x0000 (---------------)  + I kviteseid
	0x002b8147, // n0x1769 c0x0000 (---------------)  + I kvitsoy
	0x003a064c, // n0x176a c0x0000 (---------------)  + I laakesvuemie
	0x0032b506, // n0x176b c0x0000 (---------------)  + I lahppi
	0x0024a448, // n0x176c c0x0000 (---------------)  + I langevag
	0x0025f946, // n0x176d c0x0000 (---------------)  + I lardal
	0x00376d86, // n0x176e c0x0000 (---------------)  + I larvik
	0x0023a507, // n0x176f c0x0000 (---------------)  + I lavagis
	0x00304488, // n0x1770 c0x0000 (---------------)  + I lavangen
	0x00319e8b, // n0x1771 c0x0000 (---------------)  + I leangaviika
	0x002cb287, // n0x1772 c0x0000 (---------------)  + I lebesby
	0x00252c49, // n0x1773 c0x0000 (---------------)  + I leikanger
	0x00279ac9, // n0x1774 c0x0000 (---------------)  + I leirfjord
	0x00358bc7, // n0x1775 c0x0000 (---------------)  + I leirvik
	0x002b6c44, // n0x1776 c0x0000 (---------------)  + I leka
	0x0031d747, // n0x1777 c0x0000 (---------------)  + I leksvik
	0x0024e786, // n0x1778 c0x0000 (---------------)  + I lenvik
	0x002135c6, // n0x1779 c0x0000 (---------------)  + I lerdal
	0x002c1245, // n0x177a c0x0000 (---------------)  + I lesja
	0x002ca988, // n0x177b c0x0000 (---------------)  + I levanger
	0x002bc4c4, // n0x177c c0x0000 (---------------)  + I lier
	0x002bc4c6, // n0x177d c0x0000 (---------------)  + I lierne
	0x0027758b, // n0x177e c0x0000 (---------------)  + I lillehammer
	0x003428c9, // n0x177f c0x0000 (---------------)  + I lillesand
	0x00314506, // n0x1780 c0x0000 (---------------)  + I lindas
	0x00387309, // n0x1781 c0x0000 (---------------)  + I lindesnes
	0x00381646, // n0x1782 c0x0000 (---------------)  + I loabat
	0x00253148, // n0x1783 c0x0000 (---------------)  + I lodingen
	0x00212ac3, // n0x1784 c0x0000 (---------------)  + I lom
	0x00203885, // n0x1785 c0x0000 (---------------)  + I loppa
	0x00213709, // n0x1786 c0x0000 (---------------)  + I lorenskog
	0x00215d05, // n0x1787 c0x0000 (---------------)  + I loten
	0x002dbac4, // n0x1788 c0x0000 (---------------)  + I lund
	0x0026eb06, // n0x1789 c0x0000 (---------------)  + I lunner
	0x00382905, // n0x178a c0x0000 (---------------)  + I luroy
	0x002d6586, // n0x178b c0x0000 (---------------)  + I luster
	0x002f3487, // n0x178c c0x0000 (---------------)  + I lyngdal
	0x00390706, // n0x178d c0x0000 (---------------)  + I lyngen
	0x0029108b, // n0x178e c0x0000 (---------------)  + I malatvuopmi
	0x0027fec7, // n0x178f c0x0000 (---------------)  + I malselv
	0x0020dd06, // n0x1790 c0x0000 (---------------)  + I malvik
	0x0034c686, // n0x1791 c0x0000 (---------------)  + I mandal
	0x0022dc06, // n0x1792 c0x0000 (---------------)  + I marker
	0x00336a89, // n0x1793 c0x0000 (---------------)  + I marnardal
	0x0021518a, // n0x1794 c0x0000 (---------------)  + I masfjorden
	0x003242c5, // n0x1795 c0x0000 (---------------)  + I masoy
	0x002232cd, // n0x1796 c0x0000 (---------------)  + I matta-varjjat
	0x0029e306, // n0x1797 c0x0000 (---------------)  + I meland
	0x00212986, // n0x1798 c0x0000 (---------------)  + I meldal
	0x00281106, // n0x1799 c0x0000 (---------------)  + I melhus
	0x00292185, // n0x179a c0x0000 (---------------)  + I meloy
	0x0031df87, // n0x179b c0x0000 (---------------)  + I meraker
	0x00296a47, // n0x179c c0x0000 (---------------)  + I midsund
	0x0034dece, // n0x179d c0x0000 (---------------)  + I midtre-gauldal
	0x00214d03, // n0x179e c0x0000 (---------------)  + I mil
	0x002bbb49, // n0x179f c0x0000 (---------------)  + I mjondalen
	0x0039ad89, // n0x17a0 c0x0000 (---------------)  + I mo-i-rana
	0x00237dc7, // n0x17a1 c0x0000 (---------------)  + I moareke
	0x00263cc7, // n0x17a2 c0x0000 (---------------)  + I modalen
	0x002a0545, // n0x17a3 c0x0000 (---------------)  + I modum
	0x00325a45, // n0x17a4 c0x0000 (---------------)  + I molde
	0x3e26a14f, // n0x17a5 c0x00f8 (n0x1953-n0x1955)  o I more-og-romsdal
	0x002c4147, // n0x17a6 c0x0000 (---------------)  + I mosjoen
	0x002c4308, // n0x17a7 c0x0000 (---------------)  + I moskenes
	0x002c4744, // n0x17a8 c0x0000 (---------------)  + I moss
	0x002c4986, // n0x17a9 c0x0000 (---------------)  + I mosvik
	0x3e6436c2, // n0x17aa c0x00f9 (n0x1955-n0x1956)  + I mr
	0x002c7ac6, // n0x17ab c0x0000 (---------------)  + I muosat
	0x002ca1c6, // n0x17ac c0x0000 (---------------)  + I museum
	0x0031a1ce, // n0x17ad c0x0000 (---------------)  + I naamesjevuemie
	0x0030b20a, // n0x17ae c0x0000 (---------------)  + I namdalseid
	0x002b0306, // n0x17af c0x0000 (---------------)  + I namsos
	0x0021f40a, // n0x17b0 c0x0000 (---------------)  + I namsskogan
	0x002be4c9, // n0x17b1 c0x0000 (---------------)  + I nannestad
	0x0030f245, // n0x17b2 c0x0000 (---------------)  + I naroy
	0x00383a88, // n0x17b3 c0x0000 (---------------)  + I narviika
	0x0039e4c6, // n0x17b4 c0x0000 (---------------)  + I narvik
	0x002d46c8, // n0x17b5 c0x0000 (---------------)  + I naustdal
	0x00308f08, // n0x17b6 c0x0000 (---------------)  + I navuotna
	0x00336f4b, // n0x17b7 c0x0000 (---------------)  + I nedre-eiker
	0x00221e45, // n0x17b8 c0x0000 (---------------)  + I nesna
	0x0024eec8, // n0x17b9 c0x0000 (---------------)  + I nesodden
	0x0020670c, // n0x17ba c0x0000 (---------------)  + I nesoddtangen
	0x002adf07, // n0x17bb c0x0000 (---------------)  + I nesseby
	0x00248f06, // n0x17bc c0x0000 (---------------)  + I nesset
	0x002afc08, // n0x17bd c0x0000 (---------------)  + I nissedal
	0x0027e608, // n0x17be c0x0000 (---------------)  + I nittedal
	0x3ea03842, // n0x17bf c0x00fa (n0x1956-n0x1957)  + I nl
	0x002b6e4b, // n0x17c0 c0x0000 (---------------)  + I nord-aurdal
	0x00389f49, // n0x17c1 c0x0000 (---------------)  + I nord-fron
	0x003484c9, // n0x17c2 c0x0000 (---------------)  + I nord-odal
	0x0023a387, // n0x17c3 c0x0000 (---------------)  + I norddal
	0x0026b748, // n0x17c4 c0x0000 (---------------)  + I nordkapp
	0x3ef1cc08, // n0x17c5 c0x00fb (n0x1957-n0x195b)  o I nordland
	0x00225f8b, // n0x17c6 c0x0000 (---------------)  + I nordre-land
	0x002fddc9, // n0x17c7 c0x0000 (---------------)  + I nordreisa
	0x0020e30d, // n0x17c8 c0x0000 (---------------)  + I nore-og-uvdal
	0x003396c8, // n0x17c9 c0x0000 (---------------)  + I notodden
	0x00305cc8, // n0x17ca c0x0000 (---------------)  + I notteroy
	0x3f204982, // n0x17cb c0x00fc (n0x195b-n0x195c)  + I nt
	0x00204e84, // n0x17cc c0x0000 (---------------)  + I odda
	0x3f603e02, // n0x17cd c0x00fd (n0x195c-n0x195d)  + I of
	0x002e7286, // n0x17ce c0x0000 (---------------)  + I oksnes
	0x3fa00fc2, // n0x17cf c0x00fe (n0x195d-n0x195e)  + I ol
	0x0022a2ca, // n0x17d0 c0x0000 (---------------)  + I omasvuotna
	0x003827c6, // n0x17d1 c0x0000 (---------------)  + I oppdal
	0x00224b48, // n0x17d2 c0x0000 (---------------)  + I oppegard
	0x0024fb08, // n0x17d3 c0x0000 (---------------)  + I orkanger
	0x002e6786, // n0x17d4 c0x0000 (---------------)  + I orkdal
	0x0033ce86, // n0x17d5 c0x0000 (---------------)  + I orland
	0x002de306, // n0x17d6 c0x0000 (---------------)  + I orskog
	0x002733c5, // n0x17d7 c0x0000 (---------------)  + I orsta
	0x0023b084, // n0x17d8 c0x0000 (---------------)  + I osen
	0x3febf244, // n0x17d9 c0x00ff (n0x195e-n0x195f)  + I oslo
	0x003296c6, // n0x17da c0x0000 (---------------)  + I osoyro
	0x0023ae87, // n0x17db c0x0000 (---------------)  + I osteroy
	0x4037bb47, // n0x17dc c0x0100 (n0x195f-n0x1960)  o I ostfold
	0x00349dcb, // n0x17dd c0x0000 (---------------)  + I ostre-toten
	0x002fee09, // n0x17de c0x0000 (---------------)  + I overhalla
	0x00261b8a, // n0x17df c0x0000 (---------------)  + I ovre-eiker
	0x003108c4, // n0x17e0 c0x0000 (---------------)  + I oyer
	0x002ff4c8, // n0x17e1 c0x0000 (---------------)  + I oygarden
	0x00265a8d, // n0x17e2 c0x0000 (---------------)  + I oystre-slidre
	0x002d8d49, // n0x17e3 c0x0000 (---------------)  + I porsanger
	0x002d8f88, // n0x17e4 c0x0000 (---------------)  + I porsangu
	0x002d9209, // n0x17e5 c0x0000 (---------------)  + I porsgrunn
	0x002da7c4, // n0x17e6 c0x0000 (---------------)  + I priv
	0x0021ac84, // n0x17e7 c0x0000 (---------------)  + I rade
	0x00278245, // n0x17e8 c0x0000 (---------------)  + I radoy
	0x0027008b, // n0x17e9 c0x0000 (---------------)  + I rahkkeravju
	0x002a81c6, // n0x17ea c0x0000 (---------------)  + I raholt
	0x00329505, // n0x17eb c0x0000 (---------------)  + I raisa
	0x003738c9, // n0x17ec c0x0000 (---------------)  + I rakkestad
	0x00222048, // n0x17ed c0x0000 (---------------)  + I ralingen
	0x00299044, // n0x17ee c0x0000 (---------------)  + I rana
	0x00237b49, // n0x17ef c0x0000 (---------------)  + I randaberg
	0x0024ddc5, // n0x17f0 c0x0000 (---------------)  + I rauma
	0x002b2fc8, // n0x17f1 c0x0000 (---------------)  + I rendalen
	0x0032ffc7, // n0x17f2 c0x0000 (---------------)  + I rennebu
	0x00318b88, // n0x17f3 c0x0000 (---------------)  + I rennesoy
	0x00278806, // n0x17f4 c0x0000 (---------------)  + I rindal
	0x0034dac7, // n0x17f5 c0x0000 (---------------)  + I ringebu
	0x0028b209, // n0x17f6 c0x0000 (---------------)  + I ringerike
	0x00352249, // n0x17f7 c0x0000 (---------------)  + I ringsaker
	0x00266205, // n0x17f8 c0x0000 (---------------)  + I risor
	0x0039a3c5, // n0x17f9 c0x0000 (---------------)  + I rissa
	0x40606182, // n0x17fa c0x0101 (n0x1960-n0x1961)  + I rl
	0x002f0b84, // n0x17fb c0x0000 (---------------)  + I roan
	0x002964c5, // n0x17fc c0x0000 (---------------)  + I rodoy
	0x0032fc86, // n0x17fd c0x0000 (---------------)  + I rollag
	0x00311a45, // n0x17fe c0x0000 (---------------)  + I romsa
	0x0024c7c7, // n0x17ff c0x0000 (---------------)  + I romskog
	0x0028f885, // n0x1800 c0x0000 (---------------)  + I roros
	0x0026f8c4, // n0x1801 c0x0000 (---------------)  + I rost
	0x00335446, // n0x1802 c0x0000 (---------------)  + I royken
	0x0022d4c7, // n0x1803 c0x0000 (---------------)  + I royrvik
	0x00243706, // n0x1804 c0x0000 (---------------)  + I ruovat
	0x00238d85, // n0x1805 c0x0000 (---------------)  + I rygge
	0x00303a48, // n0x1806 c0x0000 (---------------)  + I salangen
	0x002225c5, // n0x1807 c0x0000 (---------------)  + I salat
	0x00314387, // n0x1808 c0x0000 (---------------)  + I saltdal
	0x0037c8c9, // n0x1809 c0x0000 (---------------)  + I samnanger
	0x00342a0a, // n0x180a c0x0000 (---------------)  + I sandefjord
	0x00340bc7, // n0x180b c0x0000 (---------------)  + I sandnes
	0x00340bcc, // n0x180c c0x0000 (---------------)  + I sandnessjoen
	0x00229b86, // n0x180d c0x0000 (---------------)  + I sandoy
	0x002238c9, // n0x180e c0x0000 (---------------)  + I sarpsborg
	0x002d32c5, // n0x180f c0x0000 (---------------)  + I sauda
	0x0039fa48, // n0x1810 c0x0000 (---------------)  + I sauherad
	0x0020d603, // n0x1811 c0x0000 (---------------)  + I sel
	0x0020d605, // n0x1812 c0x0000 (---------------)  + I selbu
	0x0031fe85, // n0x1813 c0x0000 (---------------)  + I selje
	0x0022e9c7, // n0x1814 c0x0000 (---------------)  + I seljord
	0x40a11442, // n0x1815 c0x0102 (n0x1961-n0x1962)  + I sf
	0x0022e2c7, // n0x1816 c0x0000 (---------------)  + I siellak
	0x002f8606, // n0x1817 c0x0000 (---------------)  + I sigdal
	0x0021b986, // n0x1818 c0x0000 (---------------)  + I siljan
	0x002c4806, // n0x1819 c0x0000 (---------------)  + I sirdal
	0x0027e546, // n0x181a c0x0000 (---------------)  + I skanit
	0x00303288, // n0x181b c0x0000 (---------------)  + I skanland
	0x00272605, // n0x181c c0x0000 (---------------)  + I skaun
	0x00240647, // n0x181d c0x0000 (---------------)  + I skedsmo
	0x0024064d, // n0x181e c0x0000 (---------------)  + I skedsmokorset
	0x00244243, // n0x181f c0x0000 (---------------)  + I ski
	0x00302245, // n0x1820 c0x0000 (---------------)  + I skien
	0x002cc3c7, // n0x1821 c0x0000 (---------------)  + I skierva
	0x0026adc8, // n0x1822 c0x0000 (---------------)  + I skiptvet
	0x002cbf85, // n0x1823 c0x0000 (---------------)  + I skjak
	0x00225848, // n0x1824 c0x0000 (---------------)  + I skjervoy
	0x0036f3c6, // n0x1825 c0x0000 (---------------)  + I skodje
	0x002366c7, // n0x1826 c0x0000 (---------------)  + I slattum
	0x002baa85, // n0x1827 c0x0000 (---------------)  + I smola
	0x00221ec6, // n0x1828 c0x0000 (---------------)  + I snaase
	0x0035bc85, // n0x1829 c0x0000 (---------------)  + I snasa
	0x002b558a, // n0x182a c0x0000 (---------------)  + I snillfjord
	0x00349886, // n0x182b c0x0000 (---------------)  + I snoasa
	0x0022c387, // n0x182c c0x0000 (---------------)  + I sogndal
	0x002b6445, // n0x182d c0x0000 (---------------)  + I sogne
	0x002d1dc7, // n0x182e c0x0000 (---------------)  + I sokndal
	0x002d9ac4, // n0x182f c0x0000 (---------------)  + I sola
	0x002dba46, // n0x1830 c0x0000 (---------------)  + I solund
	0x00357045, // n0x1831 c0x0000 (---------------)  + I somna
	0x00205bcb, // n0x1832 c0x0000 (---------------)  + I sondre-land
	0x0024e609, // n0x1833 c0x0000 (---------------)  + I songdalen
	0x0036780a, // n0x1834 c0x0000 (---------------)  + I sor-aurdal
	0x00266288, // n0x1835 c0x0000 (---------------)  + I sor-fron
	0x0030e648, // n0x1836 c0x0000 (---------------)  + I sor-odal
	0x002e85cc, // n0x1837 c0x0000 (---------------)  + I sor-varanger
	0x002e8e07, // n0x1838 c0x0000 (---------------)  + I sorfold
	0x002f1688, // n0x1839 c0x0000 (---------------)  + I sorreisa
	0x002f4088, // n0x183a c0x0000 (---------------)  + I sortland
	0x002f7fc5, // n0x183b c0x0000 (---------------)  + I sorum
	0x002b83ca, // n0x183c c0x0000 (---------------)  + I spjelkavik
	0x003278c9, // n0x183d c0x0000 (---------------)  + I spydeberg
	0x40e01942, // n0x183e c0x0103 (n0x1962-n0x1963)  + I st
	0x00201946, // n0x183f c0x0000 (---------------)  + I stange
	0x00209d84, // n0x1840 c0x0000 (---------------)  + I stat
	0x002d77c9, // n0x1841 c0x0000 (---------------)  + I stathelle
	0x0024b689, // n0x1842 c0x0000 (---------------)  + I stavanger
	0x0021a587, // n0x1843 c0x0000 (---------------)  + I stavern
	0x00249f47, // n0x1844 c0x0000 (---------------)  + I steigen
	0x00276309, // n0x1845 c0x0000 (---------------)  + I steinkjer
	0x00393e08, // n0x1846 c0x0000 (---------------)  + I stjordal
	0x00393e0f, // n0x1847 c0x0000 (---------------)  + I stjordalshalsen
	0x002674c6, // n0x1848 c0x0000 (---------------)  + I stokke
	0x0023cb0b, // n0x1849 c0x0000 (---------------)  + I stor-elvdal
	0x003601c5, // n0x184a c0x0000 (---------------)  + I stord
	0x003601c7, // n0x184b c0x0000 (---------------)  + I stordal
	0x0038a709, // n0x184c c0x0000 (---------------)  + I storfjord
	0x00237ac6, // n0x184d c0x0000 (---------------)  + I strand
	0x00237ac7, // n0x184e c0x0000 (---------------)  + I stranda
	0x00308bc5, // n0x184f c0x0000 (---------------)  + I stryn
	0x002310c4, // n0x1850 c0x0000 (---------------)  + I sula
	0x002a8986, // n0x1851 c0x0000 (---------------)  + I suldal
	0x002119c4, // n0x1852 c0x0000 (---------------)  + I sund
	0x00301107, // n0x1853 c0x0000 (---------------)  + I sunndal
	0x002e1788, // n0x1854 c0x0000 (---------------)  + I surnadal
	0x412e34c8, // n0x1855 c0x0104 (n0x1963-n0x1964)  + I svalbard
	0x002e3ac5, // n0x1856 c0x0000 (---------------)  + I sveio
	0x002e3c07, // n0x1857 c0x0000 (---------------)  + I svelvik
	0x00299549, // n0x1858 c0x0000 (---------------)  + I sykkylven
	0x00208004, // n0x1859 c0x0000 (---------------)  + I tana
	0x00208008, // n0x185a c0x0000 (---------------)  + I tananger
	0x41645f88, // n0x185b c0x0105 (n0x1964-n0x1966)  o I telemark
	0x00218144, // n0x185c c0x0000 (---------------)  + I time
	0x00231a08, // n0x185d c0x0000 (---------------)  + I tingvoll
	0x00309484, // n0x185e c0x0000 (---------------)  + I tinn
	0x002649c9, // n0x185f c0x0000 (---------------)  + I tjeldsund
	0x00399945, // n0x1860 c0x0000 (---------------)  + I tjome
	0x41a00142, // n0x1861 c0x0106 (n0x1966-n0x1967)  + I tm
	0x00267505, // n0x1862 c0x0000 (---------------)  + I tokke
	0x0021cd05, // n0x1863 c0x0000 (---------------)  + I tolga
	0x00359d08, // n0x1864 c0x0000 (---------------)  + I tonsberg
	0x00233407, // n0x1865 c0x0000 (---------------)  + I torsken
	0x41e02b82, // n0x1866 c0x0107 (n0x1967-n0x1968)  + I tr
	0x002c5745, // n0x1867 c0x0000 (---------------)  + I trana
	0x0026f306, // n0x1868 c0x0000 (---------------)  + I tranby
	0x0028df06, // n0x1869 c0x0000 (---------------)  + I tranoy
	0x002f0b48, // n0x186a c0x0000 (---------------)  + I troandin
	0x002f4fc8, // n0x186b c0x0000 (---------------)  + I trogstad
	0x00311a06, // n0x186c c0x0000 (---------------)  + I tromsa
	0x0031af46, // n0x186d c0x0000 (---------------)  + I tromso
	0x00367e09, // n0x186e c0x0000 (---------------)  + I trondheim
	0x00352d46, // n0x186f c0x0000 (---------------)  + I trysil
	0x00286a8b, // n0x1870 c0x0000 (---------------)  + I tvedestrand
	0x00397d85, // n0x1871 c0x0000 (---------------)  + I tydal
	0x0021f006, // n0x1872 c0x0000 (---------------)  + I tynset
	0x0022d288, // n0x1873 c0x0000 (---------------)  + I tysfjord
	0x0022f806, // n0x1874 c0x0000 (---------------)  + I tysnes
	0x002263c6, // n0x1875 c0x0000 (---------------)  + I tysvar
	0x0020d14a, // n0x1876 c0x0000 (---------------)  + I ullensaker
	0x00283a0a, // n0x1877 c0x0000 (---------------)  + I ullensvang
	0x00284905, // n0x1878 c0x0000 (---------------)  + I ulvik
	0x002c3c47, // n0x1879 c0x0000 (---------------)  + I unjarga
	0x0033f3c6, // n0x187a c0x0000 (---------------)  + I utsira
	0x422000c2, // n0x187b c0x0108 (n0x1968-n0x1969)  + I va
	0x002cc507, // n0x187c c0x0000 (---------------)  + I vaapste
	0x0026df45, // n0x187d c0x0000 (---------------)  + I vadso
	0x00238644, // n0x187e c0x0000 (---------------)  + I vaga
	0x00238645, // n0x187f c0x0000 (---------------)  + I vagan
	0x003107c6, // n0x1880 c0x0000 (---------------)  + I vagsoy
	0x00322c07, // n0x1881 c0x0000 (---------------)  + I vaksdal
	0x002175c5, // n0x1882 c0x0000 (---------------)  + I valle
	0x0024b744, // n0x1883 c0x0000 (---------------)  + I vang
	0x0025cdc8, // n0x1884 c0x0000 (---------------)  + I vanylven
	0x00226485, // n0x1885 c0x0000 (---------------)  + I vardo
	0x0039d047, // n0x1886 c0x0000 (---------------)  + I varggat
	0x0028c4c5, // n0x1887 c0x0000 (---------------)  + I varoy
	0x00215ac5, // n0x1888 c0x0000 (---------------)  + I vefsn
	0x00332784, // n0x1889 c0x0000 (---------------)  + I vega
	0x00332789, // n0x188a c0x0000 (---------------)  + I vegarshei
	0x002db4c8, // n0x188b c0x0000 (---------------)  + I vennesla
	0x0036e606, // n0x188c c0x0000 (---------------)  + I verdal
	0x0033f9c6, // n0x188d c0x0000 (---------------)  + I verran
	0x00217e46, // n0x188e c0x0000 (---------------)  + I vestby
	0x427966c8, // n0x188f c0x0109 (n0x1969-n0x196a)  o I vestfold
	0x002e8447, // n0x1890 c0x0000 (---------------)  + I vestnes
	0x002e88cd, // n0x1891 c0x0000 (---------------)  + I vestre-slidre
	0x002e8fcc, // n0x1892 c0x0000 (---------------)  + I vestre-toten
	0x002e95c9, // n0x1893 c0x0000 (---------------)  + I vestvagoy
	0x002e9809, // n0x1894 c0x0000 (---------------)  + I vevelstad
	0x42b4be42, // n0x1895 c0x010a (n0x196a-n0x196b)  + I vf
	0x00394f83, // n0x1896 c0x0000 (---------------)  + I vgs
	0x0020ddc3, // n0x1897 c0x0000 (---------------)  + I vik
	0x0024e845, // n0x1898 c0x0000 (---------------)  + I vikna
	0x0037ce4a, // n0x1899 c0x0000 (---------------)  + I vindafjord
	0x003118c6, // n0x189a c0x0000 (---------------)  + I voagat
	0x002ef605, // n0x189b c0x0000 (---------------)  + I volda
	0x002f39c4, // n0x189c c0x0000 (---------------)  + I voss
	0x002f39cb, // n0x189d c0x0000 (---------------)  + I vossevangen
	0x00306c4c, // n0x189e c0x0000 (---------------)  + I xn--andy-ira
	0x0030748c, // n0x189f c0x0000 (---------------)  + I xn--asky-ira
	0x00307795, // n0x18a0 c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x0030a1cd, // n0x18a1 c0x0000 (---------------)  + I xn--avery-yua
	0x0030bc8f, // n0x18a2 c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x0030c052, // n0x18a3 c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x0030c4cf, // n0x18a4 c0x0000 (---------------)  + I xn--berlevg-jxa
	0x0030c892, // n0x18a5 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x0030cd13, // n0x18a6 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x0030d1cd, // n0x18a7 c0x0000 (---------------)  + I xn--bidr-5nac
	0x0030d78d, // n0x18a8 c0x0000 (---------------)  + I xn--bievt-0qa
	0x0030db0e, // n0x18a9 c0x0000 (---------------)  + I xn--bjarky-fya
	0x0030dfce, // n0x18aa c0x0000 (---------------)  + I xn--bjddar-pta
	0x0030e84c, // n0x18ab c0x0000 (---------------)  + I xn--blt-elab
	0x0030ebcc, // n0x18ac c0x0000 (---------------)  + I xn--bmlo-gra
	0x0030f00b, // n0x18ad c0x0000 (---------------)  + I xn--bod-2na
	0x0030f38e, // n0x18ae c0x0000 (---------------)  + I xn--brnny-wuac
	0x00310dd2, // n0x18af c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x0031168c, // n0x18b0 c0x0000 (---------------)  + I xn--brum-voa
	0x00311dd0, // n0x18b1 c0x0000 (---------------)  + I xn--btsfjord-9za
	0x003202d2, // n0x18b2 c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0032118c, // n0x18b3 c0x0000 (---------------)  + I xn--dnna-gra
	0x0032184d, // n0x18b4 c0x0000 (---------------)  + I xn--drbak-wua
	0x00321b8c, // n0x18b5 c0x0000 (---------------)  + I xn--dyry-ira
	0x00323751, // n0x18b6 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x0032470d, // n0x18b7 c0x0000 (---------------)  + I xn--finny-yua
	0x00327b0d, // n0x18b8 c0x0000 (---------------)  + I xn--fjord-lra
	0x0032810a, // n0x18b9 c0x0000 (---------------)  + I xn--fl-zia
	0x0032838c, // n0x18ba c0x0000 (---------------)  + I xn--flor-jra
	0x00328c8c, // n0x18bb c0x0000 (---------------)  + I xn--frde-gra
	0x0032920c, // n0x18bc c0x0000 (---------------)  + I xn--frna-woa
	0x00329a8c, // n0x18bd c0x0000 (---------------)  + I xn--frya-hra
	0x0032e093, // n0x18be c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x0032e990, // n0x18bf c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x0032ed90, // n0x18c0 c0x0000 (---------------)  + I xn--givuotna-8ya
	0x0033060d, // n0x18c1 c0x0000 (---------------)  + I xn--gjvik-wua
	0x00330c0c, // n0x18c2 c0x0000 (---------------)  + I xn--gls-elac
	0x00331809, // n0x18c3 c0x0000 (---------------)  + I xn--h-2fa
	0x0033470d, // n0x18c4 c0x0000 (---------------)  + I xn--hbmer-xqa
	0x00334a53, // n0x18c5 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0033add1, // n0x18c6 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0033b213, // n0x18c7 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0033d00f, // n0x18c8 c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0033d3cc, // n0x18c9 c0x0000 (---------------)  + I xn--hobl-ira
	0x0033d6cf, // n0x18ca c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0033da8d, // n0x18cb c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0033e08f, // n0x18cc c0x0000 (---------------)  + I xn--hyanger-q1a
	0x0033e450, // n0x18cd c0x0000 (---------------)  + I xn--hylandet-54a
	0x0033eece, // n0x18ce c0x0000 (---------------)  + I xn--indery-fya
	0x0034328e, // n0x18cf c0x0000 (---------------)  + I xn--jlster-bya
	0x003439d0, // n0x18d0 c0x0000 (---------------)  + I xn--jrpeland-54a
	0x00344c0d, // n0x18d1 c0x0000 (---------------)  + I xn--karmy-yua
	0x0034558e, // n0x18d2 c0x0000 (---------------)  + I xn--kfjord-iua
	0x0034590c, // n0x18d3 c0x0000 (---------------)  + I xn--klbu-woa
	0x003468d3, // n0x18d4 c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0034870e, // n0x18d5 c0x0000 (---------------)  + I xn--krager-gya
	0x0034a390, // n0x18d6 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x0034a791, // n0x18d7 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0034abcf, // n0x18d8 c0x0000 (---------------)  + I xn--krehamn-dxa
	0x0034af93, // n0x18d9 c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0034b9cd, // n0x18da c0x0000 (---------------)  + I xn--ksnes-uua
	0x0034bd0f, // n0x18db c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0034c0ce, // n0x18dc c0x0000 (---------------)  + I xn--kvitsy-fya
	0x0034c810, // n0x18dd c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x0034cc09, // n0x18de c0x0000 (---------------)  + I xn--l-1fa
	0x0034f610, // n0x18df c0x0000 (---------------)  + I xn--laheadju-7ya
	0x0034fc4f, // n0x18e0 c0x0000 (---------------)  + I xn--langevg-jxa
	0x003502cf, // n0x18e1 c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00350692, // n0x18e2 c0x0000 (---------------)  + I xn--leagaviika-52b
	0x00350f4e, // n0x18e3 c0x0000 (---------------)  + I xn--lesund-hua
	0x0035184d, // n0x18e4 c0x0000 (---------------)  + I xn--lgrd-poac
	0x0035248d, // n0x18e5 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x003527cd, // n0x18e6 c0x0000 (---------------)  + I xn--linds-pra
	0x0035448d, // n0x18e7 c0x0000 (---------------)  + I xn--loabt-0qa
	0x003547cd, // n0x18e8 c0x0000 (---------------)  + I xn--lrdal-sra
	0x00354b10, // n0x18e9 c0x0000 (---------------)  + I xn--lrenskog-54a
	0x00354f0b, // n0x18ea c0x0000 (---------------)  + I xn--lt-liac
	0x0035548c, // n0x18eb c0x0000 (---------------)  + I xn--lten-gra
	0x0035580c, // n0x18ec c0x0000 (---------------)  + I xn--lury-ira
	0x00355b0c, // n0x18ed c0x0000 (---------------)  + I xn--mely-ira
	0x00355e0e, // n0x18ee c0x0000 (---------------)  + I xn--merker-kua
	0x003621d0, // n0x18ef c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00364092, // n0x18f0 c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x0036450b, // n0x18f1 c0x0000 (---------------)  + I xn--mli-tla
	0x00364f8e, // n0x18f2 c0x0000 (---------------)  + I xn--mlselv-iua
	0x0036530e, // n0x18f3 c0x0000 (---------------)  + I xn--moreke-jua
	0x0036600e, // n0x18f4 c0x0000 (---------------)  + I xn--mosjen-eya
	0x0036818b, // n0x18f5 c0x0000 (---------------)  + I xn--mot-tla
	0x42f68756, // n0x18f6 c0x010b (n0x196b-n0x196d)  o I xn--mre-og-romsdal-qqb
	0x0036970d, // n0x18f7 c0x0000 (---------------)  + I xn--msy-ula0h
	0x0036a314, // n0x18f8 c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0036af8d, // n0x18f9 c0x0000 (---------------)  + I xn--muost-0qa
	0x0036c195, // n0x18fa c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0036d58d, // n0x18fb c0x0000 (---------------)  + I xn--nry-yla5g
	0x0036df0f, // n0x18fc c0x0000 (---------------)  + I xn--nttery-byae
	0x0036e78f, // n0x18fd c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0037114f, // n0x18fe c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0037150e, // n0x18ff c0x0000 (---------------)  + I xn--ostery-fya
	0x0037270d, // n0x1900 c0x0000 (---------------)  + I xn--osyro-wua
	0x003742d1, // n0x1901 c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0037654c, // n0x1902 c0x0000 (---------------)  + I xn--rady-ira
	0x0037684c, // n0x1903 c0x0000 (---------------)  + I xn--rdal-poa
	0x00376b4b, // n0x1904 c0x0000 (---------------)  + I xn--rde-ula
	0x0037710c, // n0x1905 c0x0000 (---------------)  + I xn--rdy-0nab
	0x003774cf, // n0x1906 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00377892, // n0x1907 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x0037824d, // n0x1908 c0x0000 (---------------)  + I xn--rholt-mra
	0x0037920c, // n0x1909 c0x0000 (---------------)  + I xn--risa-5na
	0x0037968c, // n0x190a c0x0000 (---------------)  + I xn--risr-ira
	0x0037998d, // n0x190b c0x0000 (---------------)  + I xn--rland-uua
	0x00379ccf, // n0x190c c0x0000 (---------------)  + I xn--rlingen-mxa
	0x0037a08e, // n0x190d c0x0000 (---------------)  + I xn--rmskog-bya
	0x0037cb0c, // n0x190e c0x0000 (---------------)  + I xn--rros-gra
	0x0037d0cd, // n0x190f c0x0000 (---------------)  + I xn--rskog-uua
	0x0037d40b, // n0x1910 c0x0000 (---------------)  + I xn--rst-0na
	0x0037d9cc, // n0x1911 c0x0000 (---------------)  + I xn--rsta-fra
	0x0037df4d, // n0x1912 c0x0000 (---------------)  + I xn--ryken-vua
	0x0037e28e, // n0x1913 c0x0000 (---------------)  + I xn--ryrvik-bya
	0x0037e709, // n0x1914 c0x0000 (---------------)  + I xn--s-1fa
	0x0037f6d3, // n0x1915 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x0038034d, // n0x1916 c0x0000 (---------------)  + I xn--sandy-yua
	0x0038068d, // n0x1917 c0x0000 (---------------)  + I xn--seral-lra
	0x00380c8c, // n0x1918 c0x0000 (---------------)  + I xn--sgne-gra
	0x0038110e, // n0x1919 c0x0000 (---------------)  + I xn--skierv-uta
	0x00382a4f, // n0x191a c0x0000 (---------------)  + I xn--skjervy-v1a
	0x00382e0c, // n0x191b c0x0000 (---------------)  + I xn--skjk-soa
	0x0038310d, // n0x191c c0x0000 (---------------)  + I xn--sknit-yqa
	0x0038344f, // n0x191d c0x0000 (---------------)  + I xn--sknland-fxa
	0x0038380c, // n0x191e c0x0000 (---------------)  + I xn--slat-5na
	0x00383f0c, // n0x191f c0x0000 (---------------)  + I xn--slt-elab
	0x003842cc, // n0x1920 c0x0000 (---------------)  + I xn--smla-hra
	0x003845cc, // n0x1921 c0x0000 (---------------)  + I xn--smna-gra
	0x00384c8d, // n0x1922 c0x0000 (---------------)  + I xn--snase-nra
	0x00384fd2, // n0x1923 c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0038564c, // n0x1924 c0x0000 (---------------)  + I xn--snes-poa
	0x0038594c, // n0x1925 c0x0000 (---------------)  + I xn--snsa-roa
	0x00385c51, // n0x1926 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0038608f, // n0x1927 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0038644f, // n0x1928 c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x00386813, // n0x1929 c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x003880ce, // n0x192a c0x0000 (---------------)  + I xn--srfold-bya
	0x0038864f, // n0x192b c0x0000 (---------------)  + I xn--srreisa-q1a
	0x00388a0c, // n0x192c c0x0000 (---------------)  + I xn--srum-gra
	0x43388d4e, // n0x192d c0x010c (n0x196d-n0x196e)  o I xn--stfold-9xa
	0x003890cf, // n0x192e c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x00389496, // n0x192f c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x0038a292, // n0x1930 c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x0038b84c, // n0x1931 c0x0000 (---------------)  + I xn--tjme-hra
	0x0038cf0f, // n0x1932 c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x0038d58d, // n0x1933 c0x0000 (---------------)  + I xn--trany-yua
	0x0038d8cf, // n0x1934 c0x0000 (---------------)  + I xn--trgstad-r1a
	0x0038dc8c, // n0x1935 c0x0000 (---------------)  + I xn--trna-woa
	0x0038df8d, // n0x1936 c0x0000 (---------------)  + I xn--troms-zua
	0x0038e2cd, // n0x1937 c0x0000 (---------------)  + I xn--tysvr-vra
	0x0038f7ce, // n0x1938 c0x0000 (---------------)  + I xn--unjrga-rta
	0x00390f0c, // n0x1939 c0x0000 (---------------)  + I xn--vads-jra
	0x0039120c, // n0x193a c0x0000 (---------------)  + I xn--vard-jra
	0x00391510, // n0x193b c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x00394411, // n0x193c c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x0039484b, // n0x193d c0x0000 (---------------)  + I xn--vg-yiab
	0x00394b8c, // n0x193e c0x0000 (---------------)  + I xn--vgan-qoa
	0x00394e8e, // n0x193f c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x00396bd1, // n0x1940 c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0039700e, // n0x1941 c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0039738d, // n0x1942 c0x0000 (---------------)  + I xn--vry-yla5g
	0x0039e28b, // n0x1943 c0x0000 (---------------)  + I xn--yer-zna
	0x0039eb8f, // n0x1944 c0x0000 (---------------)  + I xn--ygarden-p1a
	0x003a0094, // n0x1945 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x0028fbc2, // n0x1946 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1947 c0x0000 (---------------)  + I gs
	0x00201e03, // n0x1948 c0x0000 (---------------)  + I nes
	0x0028fbc2, // n0x1949 c0x0000 (---------------)  + I gs
	0x00201e03, // n0x194a c0x0000 (---------------)  + I nes
	0x0028fbc2, // n0x194b c0x0000 (---------------)  + I gs
	0x00209a82, // n0x194c c0x0000 (---------------)  + I os
	0x0035f245, // n0x194d c0x0000 (---------------)  + I valer
	0x003968cc, // n0x194e c0x0000 (---------------)  + I xn--vler-qoa
	0x0028fbc2, // n0x194f c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1950 c0x0000 (---------------)  + I gs
	0x00209a82, // n0x1951 c0x0000 (---------------)  + I os
	0x0028fbc2, // n0x1952 c0x0000 (---------------)  + I gs
	0x0028c2c5, // n0x1953 c0x0000 (---------------)  + I heroy
	0x00342a05, // n0x1954 c0x0000 (---------------)  + I sande
	0x0028fbc2, // n0x1955 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1956 c0x0000 (---------------)  + I gs
	0x0020c182, // n0x1957 c0x0000 (---------------)  + I bo
	0x0028c2c5, // n0x1958 c0x0000 (---------------)  + I heroy
	0x0030a709, // n0x1959 c0x0000 (---------------)  + I xn--b-5ga
	0x0033aacc, // n0x195a c0x0000 (---------------)  + I xn--hery-ira
	0x0028fbc2, // n0x195b c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x195c c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x195d c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x195e c0x0000 (---------------)  + I gs
	0x0035f245, // n0x195f c0x0000 (---------------)  + I valer
	0x0028fbc2, // n0x1960 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1961 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1962 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1963 c0x0000 (---------------)  + I gs
	0x0020c182, // n0x1964 c0x0000 (---------------)  + I bo
	0x0030a709, // n0x1965 c0x0000 (---------------)  + I xn--b-5ga
	0x0028fbc2, // n0x1966 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1967 c0x0000 (---------------)  + I gs
	0x0028fbc2, // n0x1968 c0x0000 (---------------)  + I gs
	0x00342a05, // n0x1969 c0x0000 (---------------)  + I sande
	0x0028fbc2, // n0x196a c0x0000 (---------------)  + I gs
	0x00342a05, // n0x196b c0x0000 (---------------)  + I sande
	0x0033aacc, // n0x196c c0x0000 (---------------)  + I xn--hery-ira
	0x003968cc, // n0x196d c0x0000 (---------------)  + I xn--vler-qoa
	0x00325b83, // n0x196e c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x196f c0x0000 (---------------)  + I com
	0x002325c3, // n0x1970 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1971 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1972 c0x0000 (---------------)  + I info
	0x0021e283, // n0x1973 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1974 c0x0000 (---------------)  + I org
	0x00138d08, // n0x1975 c0x0000 (---------------)  +   merseine
	0x000a28c4, // n0x1976 c0x0000 (---------------)  +   mine
	0x000f2908, // n0x1977 c0x0000 (---------------)  +   shacknet
	0x00203982, // n0x1978 c0x0000 (---------------)  + I ac
	0x44203dc2, // n0x1979 c0x0110 (n0x1988-n0x1989)  + I co
	0x0023ee03, // n0x197a c0x0000 (---------------)  + I cri
	0x002433c4, // n0x197b c0x0000 (---------------)  + I geek
	0x00206943, // n0x197c c0x0000 (---------------)  + I gen
	0x0033f884, // n0x197d c0x0000 (---------------)  + I govt
	0x00366f06, // n0x197e c0x0000 (---------------)  + I health
	0x0020a883, // n0x197f c0x0000 (---------------)  + I iwi
	0x002e2b84, // n0x1980 c0x0000 (---------------)  + I kiwi
	0x00268c85, // n0x1981 c0x0000 (---------------)  + I maori
	0x00214d03, // n0x1982 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1983 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1984 c0x0000 (---------------)  + I org
	0x0026f0ca, // n0x1985 c0x0000 (---------------)  + I parliament
	0x00381f46, // n0x1986 c0x0000 (---------------)  + I school
	0x0036568c, // n0x1987 c0x0000 (---------------)  + I xn--mori-qsa
	0x000f4e08, // n0x1988 c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x1989 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x198a c0x0000 (---------------)  + I com
	0x002325c3, // n0x198b c0x0000 (---------------)  + I edu
	0x00264783, // n0x198c c0x0000 (---------------)  + I gov
	0x00220d43, // n0x198d c0x0000 (---------------)  + I med
	0x002ca1c6, // n0x198e c0x0000 (---------------)  + I museum
	0x0021e283, // n0x198f c0x0000 (---------------)  + I net
	0x00223a43, // n0x1990 c0x0000 (---------------)  + I org
	0x00220443, // n0x1991 c0x0000 (---------------)  + I pro
	0x00003142, // n0x1992 c0x0000 (---------------)  +   ae
	0x00025387, // n0x1993 c0x0000 (---------------)  +   blogdns
	0x000cd9c8, // n0x1994 c0x0000 (---------------)  +   blogsite
	0x0000b54e, // n0x1995 c0x0000 (---------------)  +   bmoattachments
	0x000822d2, // n0x1996 c0x0000 (---------------)  +   boldlygoingnowhere
	0x44e36505, // n0x1997 c0x0113 (n0x19cf-n0x19d1)  o I cdn77
	0x45315d4c, // n0x1998 c0x0114 (n0x19d1-n0x19d2)  o I cdn77-secure
	0x001480c8, // n0x1999 c0x0000 (---------------)  +   dnsalias
	0x000749c7, // n0x199a c0x0000 (---------------)  +   dnsdojo
	0x0000cdcb, // n0x199b c0x0000 (---------------)  +   doesntexist
	0x00165b89, // n0x199c c0x0000 (---------------)  +   dontexist
	0x00147fc7, // n0x199d c0x0000 (---------------)  +   doomdns
	0x001a2cc7, // n0x199e c0x0000 (---------------)  +   dsmynas
	0x000748c7, // n0x199f c0x0000 (---------------)  +   duckdns
	0x0001a106, // n0x19a0 c0x0000 (---------------)  +   dvrdns
	0x00189b08, // n0x19a1 c0x0000 (---------------)  +   dynalias
	0x45820b06, // n0x19a2 c0x0116 (n0x19d3-n0x19d5)  +   dyndns
	0x000a2acd, // n0x19a3 c0x0000 (---------------)  +   endofinternet
	0x00102310, // n0x19a4 c0x0000 (---------------)  +   endoftheinternet
	0x45c25c02, // n0x19a5 c0x0117 (n0x19d5-n0x1a0c)  +   eu
	0x001a2b48, // n0x19a6 c0x0000 (---------------)  +   familyds
	0x00062887, // n0x19a7 c0x0000 (---------------)  +   from-me
	0x00090189, // n0x19a8 c0x0000 (---------------)  +   game-host
	0x00051786, // n0x19a9 c0x0000 (---------------)  +   gotdns
	0x0000f882, // n0x19aa c0x0000 (---------------)  +   hk
	0x0014904a, // n0x19ab c0x0000 (---------------)  +   hobby-site
	0x00020cc7, // n0x19ac c0x0000 (---------------)  +   homedns
	0x00141e07, // n0x19ad c0x0000 (---------------)  +   homeftp
	0x0009f749, // n0x19ae c0x0000 (---------------)  +   homelinux
	0x000a0bc8, // n0x19af c0x0000 (---------------)  +   homeunix
	0x000d974e, // n0x19b0 c0x0000 (---------------)  +   is-a-bruinsfan
	0x0000b1ce, // n0x19b1 c0x0000 (---------------)  +   is-a-candidate
	0x0001118f, // n0x19b2 c0x0000 (---------------)  +   is-a-celticsfan
	0x00011709, // n0x19b3 c0x0000 (---------------)  +   is-a-chef
	0x00043289, // n0x19b4 c0x0000 (---------------)  +   is-a-geek
	0x0005eccb, // n0x19b5 c0x0000 (---------------)  +   is-a-knight
	0x0006d08f, // n0x19b6 c0x0000 (---------------)  +   is-a-linux-user
	0x0013298c, // n0x19b7 c0x0000 (---------------)  +   is-a-patsfan
	0x000a36cb, // n0x19b8 c0x0000 (---------------)  +   is-a-soxfan
	0x000b3e08, // n0x19b9 c0x0000 (---------------)  +   is-found
	0x00149cc7, // n0x19ba c0x0000 (---------------)  +   is-lost
	0x000f1dc8, // n0x19bb c0x0000 (---------------)  +   is-saved
	0x000e628b, // n0x19bc c0x0000 (---------------)  +   is-very-bad
	0x000ec94c, // n0x19bd c0x0000 (---------------)  +   is-very-evil
	0x0011514c, // n0x19be c0x0000 (---------------)  +   is-very-good
	0x0013128c, // n0x19bf c0x0000 (---------------)  +   is-very-nice
	0x0013fe4d, // n0x19c0 c0x0000 (---------------)  +   is-very-sweet
	0x000fdf48, // n0x19c1 c0x0000 (---------------)  +   isa-geek
	0x0014d5c9, // n0x19c2 c0x0000 (---------------)  +   kicks-ass
	0x00175dcb, // n0x19c3 c0x0000 (---------------)  +   misconfused
	0x000d67c7, // n0x19c4 c0x0000 (---------------)  +   podzone
	0x000cd84a, // n0x19c5 c0x0000 (---------------)  +   readmyblog
	0x000636c6, // n0x19c6 c0x0000 (---------------)  +   selfip
	0x00091bcd, // n0x19c7 c0x0000 (---------------)  +   sellsyourhome
	0x000c7008, // n0x19c8 c0x0000 (---------------)  +   servebbs
	0x0006ef08, // n0x19c9 c0x0000 (---------------)  +   serveftp
	0x0016e2c9, // n0x19ca c0x0000 (---------------)  +   servegame
	0x000e0e0c, // n0x19cb c0x0000 (---------------)  +   stuff-4-sale
	0x00001102, // n0x19cc c0x0000 (---------------)  +   us
	0x001374c6, // n0x19cd c0x0000 (---------------)  +   webhop
	0x0000a182, // n0x19ce c0x0000 (---------------)  +   za
	0x00000301, // n0x19cf c0x0000 (---------------)  +   c
	0x0002bd43, // n0x19d0 c0x0000 (---------------)  +   rsc
	0x4576fc06, // n0x19d1 c0x0115 (n0x19d2-n0x19d3)  o I origin
	0x00036683, // n0x19d2 c0x0000 (---------------)  +   ssl
	0x00000702, // n0x19d3 c0x0000 (---------------)  +   go
	0x00020cc4, // n0x19d4 c0x0000 (---------------)  +   home
	0x000001c2, // n0x19d5 c0x0000 (---------------)  +   al
	0x000c7fc4, // n0x19d6 c0x0000 (---------------)  +   asso
	0x00000102, // n0x19d7 c0x0000 (---------------)  +   at
	0x00004202, // n0x19d8 c0x0000 (---------------)  +   au
	0x00002e82, // n0x19d9 c0x0000 (---------------)  +   be
	0x000fb3c2, // n0x19da c0x0000 (---------------)  +   bg
	0x00000302, // n0x19db c0x0000 (---------------)  +   ca
	0x00036502, // n0x19dc c0x0000 (---------------)  +   cd
	0x00002302, // n0x19dd c0x0000 (---------------)  +   ch
	0x00019ec2, // n0x19de c0x0000 (---------------)  +   cn
	0x000362c2, // n0x19df c0x0000 (---------------)  +   cy
	0x00035182, // n0x19e0 c0x0000 (---------------)  +   cz
	0x00000402, // n0x19e1 c0x0000 (---------------)  +   de
	0x000677c2, // n0x19e2 c0x0000 (---------------)  +   dk
	0x000325c3, // n0x19e3 c0x0000 (---------------)  +   edu
	0x00003502, // n0x19e4 c0x0000 (---------------)  +   ee
	0x000013c2, // n0x19e5 c0x0000 (---------------)  +   es
	0x00003a42, // n0x19e6 c0x0000 (---------------)  +   fi
	0x00035842, // n0x19e7 c0x0000 (---------------)  +   fr
	0x000008c2, // n0x19e8 c0x0000 (---------------)  +   gr
	0x00031342, // n0x19e9 c0x0000 (---------------)  +   hr
	0x00022f82, // n0x19ea c0x0000 (---------------)  +   hu
	0x00000042, // n0x19eb c0x0000 (---------------)  +   ie
	0x00001b02, // n0x19ec c0x0000 (---------------)  +   il
	0x00002082, // n0x19ed c0x0000 (---------------)  +   in
	0x00067a43, // n0x19ee c0x0000 (---------------)  +   int
	0x000011c2, // n0x19ef c0x0000 (---------------)  +   is
	0x00002742, // n0x19f0 c0x0000 (---------------)  +   it
	0x000a8442, // n0x19f1 c0x0000 (---------------)  +   jp
	0x00007b42, // n0x19f2 c0x0000 (---------------)  +   kr
	0x00000d82, // n0x19f3 c0x0000 (---------------)  +   lt
	0x00002ac2, // n0x19f4 c0x0000 (---------------)  +   lu
	0x0000dd82, // n0x19f5 c0x0000 (---------------)  +   lv
	0x00018742, // n0x19f6 c0x0000 (---------------)  +   mc
	0x00009502, // n0x19f7 c0x0000 (---------------)  +   me
	0x001626c2, // n0x19f8 c0x0000 (---------------)  +   mk
	0x000643c2, // n0x19f9 c0x0000 (---------------)  +   mt
	0x00065142, // n0x19fa c0x0000 (---------------)  +   my
	0x0001e283, // n0x19fb c0x0000 (---------------)  +   net
	0x000006c2, // n0x19fc c0x0000 (---------------)  +   ng
	0x00003842, // n0x19fd c0x0000 (---------------)  +   nl
	0x00000842, // n0x19fe c0x0000 (---------------)  +   no
	0x00010a42, // n0x19ff c0x0000 (---------------)  +   nz
	0x00066185, // n0x1a00 c0x0000 (---------------)  +   paris
	0x00007502, // n0x1a01 c0x0000 (---------------)  +   pl
	0x0006ae82, // n0x1a02 c0x0000 (---------------)  +   pt
	0x0003d1c3, // n0x1a03 c0x0000 (---------------)  +   q-a
	0x00000f82, // n0x1a04 c0x0000 (---------------)  +   ro
	0x0000efc2, // n0x1a05 c0x0000 (---------------)  +   ru
	0x00001242, // n0x1a06 c0x0000 (---------------)  +   se
	0x00009802, // n0x1a07 c0x0000 (---------------)  +   si
	0x00008882, // n0x1a08 c0x0000 (---------------)  +   sk
	0x00002b82, // n0x1a09 c0x0000 (---------------)  +   tr
	0x00000bc2, // n0x1a0a c0x0000 (---------------)  +   uk
	0x00001102, // n0x1a0b c0x0000 (---------------)  +   us
	0x00212703, // n0x1a0c c0x0000 (---------------)  + I abo
	0x00203982, // n0x1a0d c0x0000 (---------------)  + I ac
	0x0022d0c3, // n0x1a0e c0x0000 (---------------)  + I com
	0x002325c3, // n0x1a0f c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x1a10 c0x0000 (---------------)  + I gob
	0x0020ab83, // n0x1a11 c0x0000 (---------------)  + I ing
	0x00220d43, // n0x1a12 c0x0000 (---------------)  + I med
	0x0021e283, // n0x1a13 c0x0000 (---------------)  + I net
	0x0020f543, // n0x1a14 c0x0000 (---------------)  + I nom
	0x00223a43, // n0x1a15 c0x0000 (---------------)  + I org
	0x0028c203, // n0x1a16 c0x0000 (---------------)  + I sld
	0x000f4e08, // n0x1a17 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1a18 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1a19 c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x1a1a c0x0000 (---------------)  + I gob
	0x00214d03, // n0x1a1b c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1a1c c0x0000 (---------------)  + I net
	0x0020f543, // n0x1a1d c0x0000 (---------------)  + I nom
	0x00223a43, // n0x1a1e c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1a1f c0x0000 (---------------)  + I com
	0x002325c3, // n0x1a20 c0x0000 (---------------)  + I edu
	0x00223a43, // n0x1a21 c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1a22 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1a23 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1a24 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1a25 c0x0000 (---------------)  + I i
	0x00214d03, // n0x1a26 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1a27 c0x0000 (---------------)  + I net
	0x002006c3, // n0x1a28 c0x0000 (---------------)  + I ngo
	0x00223a43, // n0x1a29 c0x0000 (---------------)  + I org
	0x00325b83, // n0x1a2a c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x1a2b c0x0000 (---------------)  + I com
	0x002325c3, // n0x1a2c c0x0000 (---------------)  + I edu
	0x00281083, // n0x1a2d c0x0000 (---------------)  + I fam
	0x00210ec3, // n0x1a2e c0x0000 (---------------)  + I gob
	0x0022e8c3, // n0x1a2f c0x0000 (---------------)  + I gok
	0x00247843, // n0x1a30 c0x0000 (---------------)  + I gon
	0x0029d043, // n0x1a31 c0x0000 (---------------)  + I gop
	0x00247083, // n0x1a32 c0x0000 (---------------)  + I gos
	0x00264783, // n0x1a33 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1a34 c0x0000 (---------------)  + I info
	0x0021e283, // n0x1a35 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1a36 c0x0000 (---------------)  + I org
	0x002292c3, // n0x1a37 c0x0000 (---------------)  + I web
	0x00326104, // n0x1a38 c0x0000 (---------------)  + I agro
	0x00223cc3, // n0x1a39 c0x0000 (---------------)  + I aid
	0x00003b03, // n0x1a3a c0x0000 (---------------)  +   art
	0x00200103, // n0x1a3b c0x0000 (---------------)  + I atm
	0x00395808, // n0x1a3c c0x0000 (---------------)  + I augustow
	0x0021dc84, // n0x1a3d c0x0000 (---------------)  + I auto
	0x0033c14a, // n0x1a3e c0x0000 (---------------)  + I babia-gora
	0x003981c6, // n0x1a3f c0x0000 (---------------)  + I bedzin
	0x003899c7, // n0x1a40 c0x0000 (---------------)  + I beskidy
	0x0021d28a, // n0x1a41 c0x0000 (---------------)  + I bialowieza
	0x00267389, // n0x1a42 c0x0000 (---------------)  + I bialystok
	0x0039be87, // n0x1a43 c0x0000 (---------------)  + I bielawa
	0x003a198a, // n0x1a44 c0x0000 (---------------)  + I bieszczady
	0x00325b83, // n0x1a45 c0x0000 (---------------)  + I biz
	0x00371f0b, // n0x1a46 c0x0000 (---------------)  + I boleslawiec
	0x0038ca89, // n0x1a47 c0x0000 (---------------)  + I bydgoszcz
	0x00217f45, // n0x1a48 c0x0000 (---------------)  + I bytom
	0x002c7907, // n0x1a49 c0x0000 (---------------)  + I cieszyn
	0x00003dc2, // n0x1a4a c0x0000 (---------------)  +   co
	0x0022d0c3, // n0x1a4b c0x0000 (---------------)  + I com
	0x00256887, // n0x1a4c c0x0000 (---------------)  + I czeladz
	0x00367b45, // n0x1a4d c0x0000 (---------------)  + I czest
	0x002b6b09, // n0x1a4e c0x0000 (---------------)  + I dlugoleka
	0x002325c3, // n0x1a4f c0x0000 (---------------)  + I edu
	0x00221c46, // n0x1a50 c0x0000 (---------------)  + I elblag
	0x002b5243, // n0x1a51 c0x0000 (---------------)  + I elk
	0x0004e6c3, // n0x1a52 c0x0000 (---------------)  +   gda
	0x000f2d46, // n0x1a53 c0x0000 (---------------)  +   gdansk
	0x0013a546, // n0x1a54 c0x0000 (---------------)  +   gdynia
	0x0000a807, // n0x1a55 c0x0000 (---------------)  +   gliwice
	0x0020ea46, // n0x1a56 c0x0000 (---------------)  + I glogow
	0x00211cc5, // n0x1a57 c0x0000 (---------------)  + I gmina
	0x0023a247, // n0x1a58 c0x0000 (---------------)  + I gniezno
	0x003298c7, // n0x1a59 c0x0000 (---------------)  + I gorlice
	0x47a64783, // n0x1a5a c0x011e (n0x1add-n0x1b0c)  + I gov
	0x003213c7, // n0x1a5b c0x0000 (---------------)  + I grajewo
	0x00358ac3, // n0x1a5c c0x0000 (---------------)  + I gsm
	0x002c1fc5, // n0x1a5d c0x0000 (---------------)  + I ilawa
	0x003a4f84, // n0x1a5e c0x0000 (---------------)  + I info
	0x002b0bc8, // n0x1a5f c0x0000 (---------------)  + I jaworzno
	0x002a790c, // n0x1a60 c0x0000 (---------------)  + I jelenia-gora
	0x002a6cc5, // n0x1a61 c0x0000 (---------------)  + I jgora
	0x0031c986, // n0x1a62 c0x0000 (---------------)  + I kalisz
	0x00256747, // n0x1a63 c0x0000 (---------------)  + I karpacz
	0x003938c7, // n0x1a64 c0x0000 (---------------)  + I kartuzy
	0x00209f87, // n0x1a65 c0x0000 (---------------)  + I kaszuby
	0x0020b988, // n0x1a66 c0x0000 (---------------)  + I katowice
	0x0024614f, // n0x1a67 c0x0000 (---------------)  + I kazimierz-dolny
	0x0026b685, // n0x1a68 c0x0000 (---------------)  + I kepno
	0x0023ef07, // n0x1a69 c0x0000 (---------------)  + I ketrzyn
	0x002070c7, // n0x1a6a c0x0000 (---------------)  + I klodzko
	0x0029e5ca, // n0x1a6b c0x0000 (---------------)  + I kobierzyce
	0x00286389, // n0x1a6c c0x0000 (---------------)  + I kolobrzeg
	0x002c5405, // n0x1a6d c0x0000 (---------------)  + I konin
	0x002c844a, // n0x1a6e c0x0000 (---------------)  + I konskowola
	0x00137386, // n0x1a6f c0x0000 (---------------)  +   krakow
	0x002b52c5, // n0x1a70 c0x0000 (---------------)  + I kutno
	0x00364744, // n0x1a71 c0x0000 (---------------)  + I lapy
	0x003954c6, // n0x1a72 c0x0000 (---------------)  + I lebork
	0x0032c547, // n0x1a73 c0x0000 (---------------)  + I legnica
	0x0022b047, // n0x1a74 c0x0000 (---------------)  + I lezajsk
	0x0026a4c8, // n0x1a75 c0x0000 (---------------)  + I limanowa
	0x00212ac5, // n0x1a76 c0x0000 (---------------)  + I lomza
	0x00367a46, // n0x1a77 c0x0000 (---------------)  + I lowicz
	0x00387145, // n0x1a78 c0x0000 (---------------)  + I lubin
	0x00382085, // n0x1a79 c0x0000 (---------------)  + I lukow
	0x00224ec4, // n0x1a7a c0x0000 (---------------)  + I mail
	0x002e6687, // n0x1a7b c0x0000 (---------------)  + I malbork
	0x003030ca, // n0x1a7c c0x0000 (---------------)  + I malopolska
	0x002043c8, // n0x1a7d c0x0000 (---------------)  + I mazowsze
	0x002e27c6, // n0x1a7e c0x0000 (---------------)  + I mazury
	0x00020d43, // n0x1a7f c0x0000 (---------------)  +   med
	0x003a15c5, // n0x1a80 c0x0000 (---------------)  + I media
	0x0022ad06, // n0x1a81 c0x0000 (---------------)  + I miasta
	0x003a0886, // n0x1a82 c0x0000 (---------------)  + I mielec
	0x0031a486, // n0x1a83 c0x0000 (---------------)  + I mielno
	0x00214d03, // n0x1a84 c0x0000 (---------------)  + I mil
	0x003784c7, // n0x1a85 c0x0000 (---------------)  + I mragowo
	0x00207045, // n0x1a86 c0x0000 (---------------)  + I naklo
	0x0021e283, // n0x1a87 c0x0000 (---------------)  + I net
	0x003085cd, // n0x1a88 c0x0000 (---------------)  + I nieruchomosci
	0x0020f543, // n0x1a89 c0x0000 (---------------)  + I nom
	0x0026a5c8, // n0x1a8a c0x0000 (---------------)  + I nowaruda
	0x00397c04, // n0x1a8b c0x0000 (---------------)  + I nysa
	0x0026fb85, // n0x1a8c c0x0000 (---------------)  + I olawa
	0x0029e4c6, // n0x1a8d c0x0000 (---------------)  + I olecko
	0x00234c46, // n0x1a8e c0x0000 (---------------)  + I olkusz
	0x0021ef07, // n0x1a8f c0x0000 (---------------)  + I olsztyn
	0x002350c7, // n0x1a90 c0x0000 (---------------)  + I opoczno
	0x00240f85, // n0x1a91 c0x0000 (---------------)  + I opole
	0x00223a43, // n0x1a92 c0x0000 (---------------)  + I org
	0x0039c447, // n0x1a93 c0x0000 (---------------)  + I ostroda
	0x002c3849, // n0x1a94 c0x0000 (---------------)  + I ostroleka
	0x0020c3c9, // n0x1a95 c0x0000 (---------------)  + I ostrowiec
	0x0020e78a, // n0x1a96 c0x0000 (---------------)  + I ostrowwlkp
	0x00242b02, // n0x1a97 c0x0000 (---------------)  + I pc
	0x002c1f84, // n0x1a98 c0x0000 (---------------)  + I pila
	0x002d0544, // n0x1a99 c0x0000 (---------------)  + I pisz
	0x00214a87, // n0x1a9a c0x0000 (---------------)  + I podhale
	0x0022e188, // n0x1a9b c0x0000 (---------------)  + I podlasie
	0x002d7249, // n0x1a9c c0x0000 (---------------)  + I polkowice
	0x00302109, // n0x1a9d c0x0000 (---------------)  + I pomorskie
	0x002d7e07, // n0x1a9e c0x0000 (---------------)  + I pomorze
	0x0024dfc6, // n0x1a9f c0x0000 (---------------)  + I powiat
	0x000d94c6, // n0x1aa0 c0x0000 (---------------)  +   poznan
	0x002da7c4, // n0x1aa1 c0x0000 (---------------)  + I priv
	0x002da94a, // n0x1aa2 c0x0000 (---------------)  + I prochowice
	0x002ddc08, // n0x1aa3 c0x0000 (---------------)  + I pruszkow
	0x002de1c9, // n0x1aa4 c0x0000 (---------------)  + I przeworsk
	0x0028f346, // n0x1aa5 c0x0000 (---------------)  + I pulawy
	0x0032f605, // n0x1aa6 c0x0000 (---------------)  + I radom
	0x00204288, // n0x1aa7 c0x0000 (---------------)  + I rawa-maz
	0x002bd4ca, // n0x1aa8 c0x0000 (---------------)  + I realestate
	0x0027f083, // n0x1aa9 c0x0000 (---------------)  + I rel
	0x00333186, // n0x1aaa c0x0000 (---------------)  + I rybnik
	0x002d7f07, // n0x1aab c0x0000 (---------------)  + I rzeszow
	0x0020b885, // n0x1aac c0x0000 (---------------)  + I sanok
	0x00221505, // n0x1aad c0x0000 (---------------)  + I sejny
	0x002417c3, // n0x1aae c0x0000 (---------------)  + I sex
	0x00382744, // n0x1aaf c0x0000 (---------------)  + I shop
	0x0022a005, // n0x1ab0 c0x0000 (---------------)  + I sklep
	0x0027ce07, // n0x1ab1 c0x0000 (---------------)  + I skoczow
	0x002db605, // n0x1ab2 c0x0000 (---------------)  + I slask
	0x002cacc6, // n0x1ab3 c0x0000 (---------------)  + I slupsk
	0x000e73c5, // n0x1ab4 c0x0000 (---------------)  +   sopot
	0x0021c103, // n0x1ab5 c0x0000 (---------------)  + I sos
	0x002b03c9, // n0x1ab6 c0x0000 (---------------)  + I sosnowiec
	0x0026f94c, // n0x1ab7 c0x0000 (---------------)  + I stalowa-wola
	0x0029af4c, // n0x1ab8 c0x0000 (---------------)  + I starachowice
	0x002c4fc8, // n0x1ab9 c0x0000 (---------------)  + I stargard
	0x0025eb47, // n0x1aba c0x0000 (---------------)  + I suwalki
	0x002e4508, // n0x1abb c0x0000 (---------------)  + I swidnica
	0x002e510a, // n0x1abc c0x0000 (---------------)  + I swiebodzin
	0x002e5a8b, // n0x1abd c0x0000 (---------------)  + I swinoujscie
	0x0038cbc8, // n0x1abe c0x0000 (---------------)  + I szczecin
	0x0031ca88, // n0x1abf c0x0000 (---------------)  + I szczytno
	0x00289806, // n0x1ac0 c0x0000 (---------------)  + I szkola
	0x00239c05, // n0x1ac1 c0x0000 (---------------)  + I targi
	0x0031820a, // n0x1ac2 c0x0000 (---------------)  + I tarnobrzeg
	0x002235c5, // n0x1ac3 c0x0000 (---------------)  + I tgory
	0x00200142, // n0x1ac4 c0x0000 (---------------)  + I tm
	0x002ba947, // n0x1ac5 c0x0000 (---------------)  + I tourism
	0x0029b806, // n0x1ac6 c0x0000 (---------------)  + I travel
	0x0034f145, // n0x1ac7 c0x0000 (---------------)  + I turek
	0x002e6f49, // n0x1ac8 c0x0000 (---------------)  + I turystyka
	0x002c1785, // n0x1ac9 c0x0000 (---------------)  + I tychy
	0x00281205, // n0x1aca c0x0000 (---------------)  + I ustka
	0x002c1b89, // n0x1acb c0x0000 (---------------)  + I walbrzych
	0x0022ab86, // n0x1acc c0x0000 (---------------)  + I warmia
	0x00289e48, // n0x1acd c0x0000 (---------------)  + I warszawa
	0x00253bc3, // n0x1ace c0x0000 (---------------)  + I waw
	0x0020bf86, // n0x1acf c0x0000 (---------------)  + I wegrow
	0x0026ea46, // n0x1ad0 c0x0000 (---------------)  + I wielun
	0x002f5345, // n0x1ad1 c0x0000 (---------------)  + I wlocl
	0x002f5349, // n0x1ad2 c0x0000 (---------------)  + I wloclawek
	0x002aaa49, // n0x1ad3 c0x0000 (---------------)  + I wodzislaw
	0x00242e47, // n0x1ad4 c0x0000 (---------------)  + I wolomin
	0x000f51c4, // n0x1ad5 c0x0000 (---------------)  +   wroc
	0x002f51c7, // n0x1ad6 c0x0000 (---------------)  + I wroclaw
	0x00302009, // n0x1ad7 c0x0000 (---------------)  + I zachpomor
	0x0021d485, // n0x1ad8 c0x0000 (---------------)  + I zagan
	0x0012b788, // n0x1ad9 c0x0000 (---------------)  +   zakopane
	0x003424c5, // n0x1ada c0x0000 (---------------)  + I zarow
	0x00335285, // n0x1adb c0x0000 (---------------)  + I zgora
	0x0021e349, // n0x1adc c0x0000 (---------------)  + I zgorzelec
	0x00200942, // n0x1add c0x0000 (---------------)  + I ap
	0x00223ac4, // n0x1ade c0x0000 (---------------)  + I griw
	0x00201342, // n0x1adf c0x0000 (---------------)  + I ic
	0x002011c2, // n0x1ae0 c0x0000 (---------------)  + I is
	0x00269ec5, // n0x1ae1 c0x0000 (---------------)  + I kmpsp
	0x002cae08, // n0x1ae2 c0x0000 (---------------)  + I konsulat
	0x0036bf05, // n0x1ae3 c0x0000 (---------------)  + I kppsp
	0x002b8303, // n0x1ae4 c0x0000 (---------------)  + I kwp
	0x002b8305, // n0x1ae5 c0x0000 (---------------)  + I kwpsp
	0x002c7cc3, // n0x1ae6 c0x0000 (---------------)  + I mup
	0x0020bf42, // n0x1ae7 c0x0000 (---------------)  + I mw
	0x00260004, // n0x1ae8 c0x0000 (---------------)  + I oirm
	0x002debc3, // n0x1ae9 c0x0000 (---------------)  + I oum
	0x00203942, // n0x1aea c0x0000 (---------------)  + I pa
	0x002dc144, // n0x1aeb c0x0000 (---------------)  + I pinb
	0x002d0b43, // n0x1aec c0x0000 (---------------)  + I piw
	0x00208f42, // n0x1aed c0x0000 (---------------)  + I po
	0x00269f43, // n0x1aee c0x0000 (---------------)  + I psp
	0x00285a84, // n0x1aef c0x0000 (---------------)  + I psse
	0x002b0103, // n0x1af0 c0x0000 (---------------)  + I pup
	0x0022bec4, // n0x1af1 c0x0000 (---------------)  + I rzgw
	0x00200642, // n0x1af2 c0x0000 (---------------)  + I sa
	0x00269b43, // n0x1af3 c0x0000 (---------------)  + I sdn
	0x00213843, // n0x1af4 c0x0000 (---------------)  + I sko
	0x00205bc2, // n0x1af5 c0x0000 (---------------)  + I so
	0x00329142, // n0x1af6 c0x0000 (---------------)  + I sr
	0x002aa889, // n0x1af7 c0x0000 (---------------)  + I starostwo
	0x002025c2, // n0x1af8 c0x0000 (---------------)  + I ug
	0x00282e44, // n0x1af9 c0x0000 (---------------)  + I ugim
	0x00204102, // n0x1afa c0x0000 (---------------)  + I um
	0x00204104, // n0x1afb c0x0000 (---------------)  + I umig
	0x0024df84, // n0x1afc c0x0000 (---------------)  + I upow
	0x002dcf84, // n0x1afd c0x0000 (---------------)  + I uppo
	0x00201102, // n0x1afe c0x0000 (---------------)  + I us
	0x0023d4c2, // n0x1aff c0x0000 (---------------)  + I uw
	0x0020f003, // n0x1b00 c0x0000 (---------------)  + I uzs
	0x002e5703, // n0x1b01 c0x0000 (---------------)  + I wif
	0x0023e504, // n0x1b02 c0x0000 (---------------)  + I wiih
	0x00256204, // n0x1b03 c0x0000 (---------------)  + I winb
	0x002c37c4, // n0x1b04 c0x0000 (---------------)  + I wios
	0x002c5304, // n0x1b05 c0x0000 (---------------)  + I witd
	0x002f4843, // n0x1b06 c0x0000 (---------------)  + I wiw
	0x002eafc3, // n0x1b07 c0x0000 (---------------)  + I wsa
	0x00337304, // n0x1b08 c0x0000 (---------------)  + I wskr
	0x002f6644, // n0x1b09 c0x0000 (---------------)  + I wuoz
	0x002f6946, // n0x1b0a c0x0000 (---------------)  + I wzmiuw
	0x002cf782, // n0x1b0b c0x0000 (---------------)  + I zp
	0x00203dc2, // n0x1b0c c0x0000 (---------------)  + I co
	0x002325c3, // n0x1b0d c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b0e c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1b0f c0x0000 (---------------)  + I net
	0x00223a43, // n0x1b10 c0x0000 (---------------)  + I org
	0x00203982, // n0x1b11 c0x0000 (---------------)  + I ac
	0x00325b83, // n0x1b12 c0x0000 (---------------)  + I biz
	0x0022d0c3, // n0x1b13 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1b14 c0x0000 (---------------)  + I edu
	0x00201903, // n0x1b15 c0x0000 (---------------)  + I est
	0x00264783, // n0x1b16 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1b17 c0x0000 (---------------)  + I info
	0x002aab44, // n0x1b18 c0x0000 (---------------)  + I isla
	0x0020ff84, // n0x1b19 c0x0000 (---------------)  + I name
	0x0021e283, // n0x1b1a c0x0000 (---------------)  + I net
	0x00223a43, // n0x1b1b c0x0000 (---------------)  + I org
	0x00220443, // n0x1b1c c0x0000 (---------------)  + I pro
	0x002db004, // n0x1b1d c0x0000 (---------------)  + I prof
	0x002adac3, // n0x1b1e c0x0000 (---------------)  + I aca
	0x00202903, // n0x1b1f c0x0000 (---------------)  + I bar
	0x00217203, // n0x1b20 c0x0000 (---------------)  + I cpa
	0x00203603, // n0x1b21 c0x0000 (---------------)  + I eng
	0x002a9503, // n0x1b22 c0x0000 (---------------)  + I jur
	0x00266983, // n0x1b23 c0x0000 (---------------)  + I law
	0x00220d43, // n0x1b24 c0x0000 (---------------)  + I med
	0x0022d0c3, // n0x1b25 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1b26 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b27 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1b28 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1b29 c0x0000 (---------------)  + I org
	0x002d3403, // n0x1b2a c0x0000 (---------------)  + I plo
	0x0022f683, // n0x1b2b c0x0000 (---------------)  + I sec
	0x000f4e08, // n0x1b2c c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1b2d c0x0000 (---------------)  + I com
	0x002325c3, // n0x1b2e c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b2f c0x0000 (---------------)  + I gov
	0x00267a43, // n0x1b30 c0x0000 (---------------)  + I int
	0x0021e283, // n0x1b31 c0x0000 (---------------)  + I net
	0x0023c444, // n0x1b32 c0x0000 (---------------)  + I nome
	0x00223a43, // n0x1b33 c0x0000 (---------------)  + I org
	0x00297d84, // n0x1b34 c0x0000 (---------------)  + I publ
	0x002cb085, // n0x1b35 c0x0000 (---------------)  + I belau
	0x00203dc2, // n0x1b36 c0x0000 (---------------)  + I co
	0x002003c2, // n0x1b37 c0x0000 (---------------)  + I ed
	0x00200702, // n0x1b38 c0x0000 (---------------)  + I go
	0x00201e02, // n0x1b39 c0x0000 (---------------)  + I ne
	0x00200282, // n0x1b3a c0x0000 (---------------)  + I or
	0x0022d0c3, // n0x1b3b c0x0000 (---------------)  + I com
	0x00235044, // n0x1b3c c0x0000 (---------------)  + I coop
	0x002325c3, // n0x1b3d c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b3e c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1b3f c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1b40 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1b41 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x1b42 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1b43 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1b44 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b45 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1b46 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x1b47 c0x0000 (---------------)  + I name
	0x0021e283, // n0x1b48 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1b49 c0x0000 (---------------)  + I org
	0x00213403, // n0x1b4a c0x0000 (---------------)  + I sch
	0x002c7fc4, // n0x1b4b c0x0000 (---------------)  + I asso
	0x000f4e08, // n0x1b4c c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1b4d c0x0000 (---------------)  + I com
	0x0020f543, // n0x1b4e c0x0000 (---------------)  + I nom
	0x00244d04, // n0x1b4f c0x0000 (---------------)  + I arts
	0x000f4e08, // n0x1b50 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1b51 c0x0000 (---------------)  + I com
	0x00246bc4, // n0x1b52 c0x0000 (---------------)  + I firm
	0x003a4f84, // n0x1b53 c0x0000 (---------------)  + I info
	0x0020f543, // n0x1b54 c0x0000 (---------------)  + I nom
	0x00204982, // n0x1b55 c0x0000 (---------------)  + I nt
	0x00223a43, // n0x1b56 c0x0000 (---------------)  + I org
	0x00226e03, // n0x1b57 c0x0000 (---------------)  + I rec
	0x003758c5, // n0x1b58 c0x0000 (---------------)  + I store
	0x00200142, // n0x1b59 c0x0000 (---------------)  + I tm
	0x002f6783, // n0x1b5a c0x0000 (---------------)  + I www
	0x00203982, // n0x1b5b c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x1b5c c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x1b5d c0x0000 (---------------)  + I co
	0x002325c3, // n0x1b5e c0x0000 (---------------)  + I edu
	0x00264783, // n0x1b5f c0x0000 (---------------)  + I gov
	0x00202082, // n0x1b60 c0x0000 (---------------)  + I in
	0x00223a43, // n0x1b61 c0x0000 (---------------)  + I org
	0x00203982, // n0x1b62 c0x0000 (---------------)  + I ac
	0x003a1b47, // n0x1b63 c0x0000 (---------------)  + I adygeya
	0x0027c805, // n0x1b64 c0x0000 (---------------)  + I altai
	0x00289c84, // n0x1b65 c0x0000 (---------------)  + I amur
	0x00376206, // n0x1b66 c0x0000 (---------------)  + I amursk
	0x0023044b, // n0x1b67 c0x0000 (---------------)  + I arkhangelsk
	0x00253949, // n0x1b68 c0x0000 (---------------)  + I astrakhan
	0x0031c8c6, // n0x1b69 c0x0000 (---------------)  + I baikal
	0x0031e689, // n0x1b6a c0x0000 (---------------)  + I bashkiria
	0x002b2708, // n0x1b6b c0x0000 (---------------)  + I belgorod
	0x00204f83, // n0x1b6c c0x0000 (---------------)  + I bir
	0x000f4e08, // n0x1b6d c0x0000 (---------------)  +   blogspot
	0x00225707, // n0x1b6e c0x0000 (---------------)  + I bryansk
	0x00349408, // n0x1b6f c0x0000 (---------------)  + I buryatia
	0x0033a8c3, // n0x1b70 c0x0000 (---------------)  + I cbg
	0x00245944, // n0x1b71 c0x0000 (---------------)  + I chel
	0x0025dbcb, // n0x1b72 c0x0000 (---------------)  + I chelyabinsk
	0x002a6e85, // n0x1b73 c0x0000 (---------------)  + I chita
	0x002b73c8, // n0x1b74 c0x0000 (---------------)  + I chukotka
	0x0032a089, // n0x1b75 c0x0000 (---------------)  + I chuvashia
	0x00256183, // n0x1b76 c0x0000 (---------------)  + I cmw
	0x0022d0c3, // n0x1b77 c0x0000 (---------------)  + I com
	0x00201848, // n0x1b78 c0x0000 (---------------)  + I dagestan
	0x002e3687, // n0x1b79 c0x0000 (---------------)  + I dudinka
	0x00338a86, // n0x1b7a c0x0000 (---------------)  + I e-burg
	0x002325c3, // n0x1b7b c0x0000 (---------------)  + I edu
	0x0037e8c7, // n0x1b7c c0x0000 (---------------)  + I fareast
	0x00264783, // n0x1b7d c0x0000 (---------------)  + I gov
	0x002fa586, // n0x1b7e c0x0000 (---------------)  + I grozny
	0x00267a43, // n0x1b7f c0x0000 (---------------)  + I int
	0x00229ec7, // n0x1b80 c0x0000 (---------------)  + I irkutsk
	0x0026aac7, // n0x1b81 c0x0000 (---------------)  + I ivanovo
	0x0037fb87, // n0x1b82 c0x0000 (---------------)  + I izhevsk
	0x002e6605, // n0x1b83 c0x0000 (---------------)  + I jamal
	0x00207683, // n0x1b84 c0x0000 (---------------)  + I jar
	0x0020f7cb, // n0x1b85 c0x0000 (---------------)  + I joshkar-ola
	0x00369488, // n0x1b86 c0x0000 (---------------)  + I k-uralsk
	0x00265088, // n0x1b87 c0x0000 (---------------)  + I kalmykia
	0x00249846, // n0x1b88 c0x0000 (---------------)  + I kaluga
	0x002186c9, // n0x1b89 c0x0000 (---------------)  + I kamchatka
	0x00319547, // n0x1b8a c0x0000 (---------------)  + I karelia
	0x002ef945, // n0x1b8b c0x0000 (---------------)  + I kazan
	0x00372284, // n0x1b8c c0x0000 (---------------)  + I kchr
	0x002675c8, // n0x1b8d c0x0000 (---------------)  + I kemerovo
	0x0022b2ca, // n0x1b8e c0x0000 (---------------)  + I khabarovsk
	0x0022b509, // n0x1b8f c0x0000 (---------------)  + I khakassia
	0x0025cd43, // n0x1b90 c0x0000 (---------------)  + I khv
	0x00278085, // n0x1b91 c0x0000 (---------------)  + I kirov
	0x0032e6c3, // n0x1b92 c0x0000 (---------------)  + I kms
	0x0029bfc6, // n0x1b93 c0x0000 (---------------)  + I koenig
	0x002cff44, // n0x1b94 c0x0000 (---------------)  + I komi
	0x002f2e88, // n0x1b95 c0x0000 (---------------)  + I kostroma
	0x0037fd0b, // n0x1b96 c0x0000 (---------------)  + I krasnoyarsk
	0x0032e585, // n0x1b97 c0x0000 (---------------)  + I kuban
	0x002b2486, // n0x1b98 c0x0000 (---------------)  + I kurgan
	0x002b4145, // n0x1b99 c0x0000 (---------------)  + I kursk
	0x002b4688, // n0x1b9a c0x0000 (---------------)  + I kustanai
	0x002b5407, // n0x1b9b c0x0000 (---------------)  + I kuzbass
	0x00208747, // n0x1b9c c0x0000 (---------------)  + I lipetsk
	0x0033ca47, // n0x1b9d c0x0000 (---------------)  + I magadan
	0x00218044, // n0x1b9e c0x0000 (---------------)  + I mari
	0x0021d747, // n0x1b9f c0x0000 (---------------)  + I mari-el
	0x00273c46, // n0x1ba0 c0x0000 (---------------)  + I marine
	0x00214d03, // n0x1ba1 c0x0000 (---------------)  + I mil
	0x002c0588, // n0x1ba2 c0x0000 (---------------)  + I mordovia
	0x0024c843, // n0x1ba3 c0x0000 (---------------)  + I msk
	0x002c8288, // n0x1ba4 c0x0000 (---------------)  + I murmansk
	0x002ccf05, // n0x1ba5 c0x0000 (---------------)  + I mytis
	0x00309088, // n0x1ba6 c0x0000 (---------------)  + I nakhodka
	0x002327c7, // n0x1ba7 c0x0000 (---------------)  + I nalchik
	0x0021e283, // n0x1ba8 c0x0000 (---------------)  + I net
	0x00319c43, // n0x1ba9 c0x0000 (---------------)  + I nkz
	0x0039cf84, // n0x1baa c0x0000 (---------------)  + I nnov
	0x0036f287, // n0x1bab c0x0000 (---------------)  + I norilsk
	0x002069c3, // n0x1bac c0x0000 (---------------)  + I nov
	0x0026ab8b, // n0x1bad c0x0000 (---------------)  + I novosibirsk
	0x00213803, // n0x1bae c0x0000 (---------------)  + I nsk
	0x0024c804, // n0x1baf c0x0000 (---------------)  + I omsk
	0x00375948, // n0x1bb0 c0x0000 (---------------)  + I orenburg
	0x00223a43, // n0x1bb1 c0x0000 (---------------)  + I org
	0x002d0e85, // n0x1bb2 c0x0000 (---------------)  + I oryol
	0x0028f945, // n0x1bb3 c0x0000 (---------------)  + I oskol
	0x00206f46, // n0x1bb4 c0x0000 (---------------)  + I palana
	0x002109c5, // n0x1bb5 c0x0000 (---------------)  + I penza
	0x002cd2c4, // n0x1bb6 c0x0000 (---------------)  + I perm
	0x00203902, // n0x1bb7 c0x0000 (---------------)  + I pp
	0x002de483, // n0x1bb8 c0x0000 (---------------)  + I ptz
	0x003647ca, // n0x1bb9 c0x0000 (---------------)  + I pyatigorsk
	0x002707c3, // n0x1bba c0x0000 (---------------)  + I rnd
	0x002cbdc9, // n0x1bbb c0x0000 (---------------)  + I rubtsovsk
	0x00237206, // n0x1bbc c0x0000 (---------------)  + I ryazan
	0x002169c8, // n0x1bbd c0x0000 (---------------)  + I sakhalin
	0x002855c6, // n0x1bbe c0x0000 (---------------)  + I samara
	0x0021a247, // n0x1bbf c0x0000 (---------------)  + I saratov
	0x002bf608, // n0x1bc0 c0x0000 (---------------)  + I simbirsk
	0x002ed448, // n0x1bc1 c0x0000 (---------------)  + I smolensk
	0x002cf703, // n0x1bc2 c0x0000 (---------------)  + I snz
	0x00269f83, // n0x1bc3 c0x0000 (---------------)  + I spb
	0x0021ff49, // n0x1bc4 c0x0000 (---------------)  + I stavropol
	0x00286a43, // n0x1bc5 c0x0000 (---------------)  + I stv
	0x0033f2c6, // n0x1bc6 c0x0000 (---------------)  + I surgut
	0x0027c486, // n0x1bc7 c0x0000 (---------------)  + I syzran
	0x0030e2c6, // n0x1bc8 c0x0000 (---------------)  + I tambov
	0x0039c149, // n0x1bc9 c0x0000 (---------------)  + I tatarstan
	0x002f4c44, // n0x1bca c0x0000 (---------------)  + I test
	0x00204ac3, // n0x1bcb c0x0000 (---------------)  + I tom
	0x00369385, // n0x1bcc c0x0000 (---------------)  + I tomsk
	0x002eb389, // n0x1bcd c0x0000 (---------------)  + I tsaritsyn
	0x00208843, // n0x1bce c0x0000 (---------------)  + I tsk
	0x00356f04, // n0x1bcf c0x0000 (---------------)  + I tula
	0x002e7f84, // n0x1bd0 c0x0000 (---------------)  + I tuva
	0x0020da44, // n0x1bd1 c0x0000 (---------------)  + I tver
	0x00356a46, // n0x1bd2 c0x0000 (---------------)  + I tyumen
	0x00207843, // n0x1bd3 c0x0000 (---------------)  + I udm
	0x00207848, // n0x1bd4 c0x0000 (---------------)  + I udmurtia
	0x00253588, // n0x1bd5 c0x0000 (---------------)  + I ulan-ude
	0x00353b46, // n0x1bd6 c0x0000 (---------------)  + I vdonsk
	0x002ef74b, // n0x1bd7 c0x0000 (---------------)  + I vladikavkaz
	0x002efa88, // n0x1bd8 c0x0000 (---------------)  + I vladimir
	0x002efc8b, // n0x1bd9 c0x0000 (---------------)  + I vladivostok
	0x002f0489, // n0x1bda c0x0000 (---------------)  + I volgograd
	0x002f2c47, // n0x1bdb c0x0000 (---------------)  + I vologda
	0x002f3648, // n0x1bdc c0x0000 (---------------)  + I voronezh
	0x002f4283, // n0x1bdd c0x0000 (---------------)  + I vrn
	0x0037bd86, // n0x1bde c0x0000 (---------------)  + I vyatka
	0x002089c7, // n0x1bdf c0x0000 (---------------)  + I yakutia
	0x00291005, // n0x1be0 c0x0000 (---------------)  + I yamal
	0x00343589, // n0x1be1 c0x0000 (---------------)  + I yaroslavl
	0x00318d4d, // n0x1be2 c0x0000 (---------------)  + I yekaterinburg
	0x00216811, // n0x1be3 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x00228c85, // n0x1be4 c0x0000 (---------------)  + I zgrad
	0x00203982, // n0x1be5 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x1be6 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1be7 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1be8 c0x0000 (---------------)  + I edu
	0x0034ec04, // n0x1be9 c0x0000 (---------------)  + I gouv
	0x00264783, // n0x1bea c0x0000 (---------------)  + I gov
	0x00267a43, // n0x1beb c0x0000 (---------------)  + I int
	0x00214d03, // n0x1bec c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1bed c0x0000 (---------------)  + I net
	0x0022d0c3, // n0x1bee c0x0000 (---------------)  + I com
	0x002325c3, // n0x1bef c0x0000 (---------------)  + I edu
	0x00264783, // n0x1bf0 c0x0000 (---------------)  + I gov
	0x00220d43, // n0x1bf1 c0x0000 (---------------)  + I med
	0x0021e283, // n0x1bf2 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1bf3 c0x0000 (---------------)  + I org
	0x00297d83, // n0x1bf4 c0x0000 (---------------)  + I pub
	0x00213403, // n0x1bf5 c0x0000 (---------------)  + I sch
	0x0022d0c3, // n0x1bf6 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1bf7 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1bf8 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1bf9 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1bfa c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1bfb c0x0000 (---------------)  + I com
	0x002325c3, // n0x1bfc c0x0000 (---------------)  + I edu
	0x00264783, // n0x1bfd c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1bfe c0x0000 (---------------)  + I net
	0x00223a43, // n0x1bff c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1c00 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c01 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1c02 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1c03 c0x0000 (---------------)  + I info
	0x00220d43, // n0x1c04 c0x0000 (---------------)  + I med
	0x0021e283, // n0x1c05 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c06 c0x0000 (---------------)  + I org
	0x0020da42, // n0x1c07 c0x0000 (---------------)  + I tv
	0x00200101, // n0x1c08 c0x0000 (---------------)  + I a
	0x00203982, // n0x1c09 c0x0000 (---------------)  + I ac
	0x00200001, // n0x1c0a c0x0000 (---------------)  + I b
	0x0030bd82, // n0x1c0b c0x0000 (---------------)  + I bd
	0x000f4e08, // n0x1c0c c0x0000 (---------------)  +   blogspot
	0x0021b4c5, // n0x1c0d c0x0000 (---------------)  + I brand
	0x00200301, // n0x1c0e c0x0000 (---------------)  + I c
	0x0002d0c3, // n0x1c0f c0x0000 (---------------)  +   com
	0x00200401, // n0x1c10 c0x0000 (---------------)  + I d
	0x00200081, // n0x1c11 c0x0000 (---------------)  + I e
	0x00200381, // n0x1c12 c0x0000 (---------------)  + I f
	0x0022b202, // n0x1c13 c0x0000 (---------------)  + I fh
	0x0022b204, // n0x1c14 c0x0000 (---------------)  + I fhsk
	0x0035f1c3, // n0x1c15 c0x0000 (---------------)  + I fhv
	0x00200701, // n0x1c16 c0x0000 (---------------)  + I g
	0x00200601, // n0x1c17 c0x0000 (---------------)  + I h
	0x00200041, // n0x1c18 c0x0000 (---------------)  + I i
	0x00200c01, // n0x1c19 c0x0000 (---------------)  + I k
	0x00395247, // n0x1c1a c0x0000 (---------------)  + I komforb
	0x0037ff8f, // n0x1c1b c0x0000 (---------------)  + I kommunalforbund
	0x002d1606, // n0x1c1c c0x0000 (---------------)  + I komvux
	0x00200201, // n0x1c1d c0x0000 (---------------)  + I l
	0x00261f46, // n0x1c1e c0x0000 (---------------)  + I lanbib
	0x00200181, // n0x1c1f c0x0000 (---------------)  + I m
	0x002005c1, // n0x1c20 c0x0000 (---------------)  + I n
	0x0030954e, // n0x1c21 c0x0000 (---------------)  + I naturbruksgymn
	0x00200281, // n0x1c22 c0x0000 (---------------)  + I o
	0x00223a43, // n0x1c23 c0x0000 (---------------)  + I org
	0x00200981, // n0x1c24 c0x0000 (---------------)  + I p
	0x00295205, // n0x1c25 c0x0000 (---------------)  + I parti
	0x00203902, // n0x1c26 c0x0000 (---------------)  + I pp
	0x002416c5, // n0x1c27 c0x0000 (---------------)  + I press
	0x002002c1, // n0x1c28 c0x0000 (---------------)  + I r
	0x00200641, // n0x1c29 c0x0000 (---------------)  + I s
	0x00200141, // n0x1c2a c0x0000 (---------------)  + I t
	0x00200142, // n0x1c2b c0x0000 (---------------)  + I tm
	0x00200a81, // n0x1c2c c0x0000 (---------------)  + I u
	0x00200d01, // n0x1c2d c0x0000 (---------------)  + I w
	0x002045c1, // n0x1c2e c0x0000 (---------------)  + I x
	0x002010c1, // n0x1c2f c0x0000 (---------------)  + I y
	0x00204441, // n0x1c30 c0x0000 (---------------)  + I z
	0x000f4e08, // n0x1c31 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1c32 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c33 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1c34 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1c35 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c36 c0x0000 (---------------)  + I org
	0x00220503, // n0x1c37 c0x0000 (---------------)  + I per
	0x0022d0c3, // n0x1c38 c0x0000 (---------------)  + I com
	0x00264783, // n0x1c39 c0x0000 (---------------)  + I gov
	0x00085ec8, // n0x1c3a c0x0000 (---------------)  +   hashbang
	0x00214d03, // n0x1c3b c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1c3c c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c3d c0x0000 (---------------)  + I org
	0x014d1f88, // n0x1c3e c0x0005 (---------------)* o   platform
	0x000f4e08, // n0x1c3f c0x0000 (---------------)  +   blogspot
	0x000f4e08, // n0x1c40 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1c41 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c42 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1c43 c0x0000 (---------------)  + I gov
	0x0021e283, // n0x1c44 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c45 c0x0000 (---------------)  + I org
	0x00203b03, // n0x1c46 c0x0000 (---------------)  + I art
	0x000f4e08, // n0x1c47 c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1c48 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c49 c0x0000 (---------------)  + I edu
	0x0034ec04, // n0x1c4a c0x0000 (---------------)  + I gouv
	0x00223a43, // n0x1c4b c0x0000 (---------------)  + I org
	0x00291545, // n0x1c4c c0x0000 (---------------)  + I perso
	0x003179c4, // n0x1c4d c0x0000 (---------------)  + I univ
	0x0022d0c3, // n0x1c4e c0x0000 (---------------)  + I com
	0x0021e283, // n0x1c4f c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c50 c0x0000 (---------------)  + I org
	0x00203dc2, // n0x1c51 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1c52 c0x0000 (---------------)  + I com
	0x00231009, // n0x1c53 c0x0000 (---------------)  + I consulado
	0x002325c3, // n0x1c54 c0x0000 (---------------)  + I edu
	0x00234989, // n0x1c55 c0x0000 (---------------)  + I embaixada
	0x00264783, // n0x1c56 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1c57 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1c58 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c59 c0x0000 (---------------)  + I org
	0x002da5c8, // n0x1c5a c0x0000 (---------------)  + I principe
	0x00212847, // n0x1c5b c0x0000 (---------------)  + I saotome
	0x003758c5, // n0x1c5c c0x0000 (---------------)  + I store
	0x003a1b47, // n0x1c5d c0x0000 (---------------)  + I adygeya
	0x0023044b, // n0x1c5e c0x0000 (---------------)  + I arkhangelsk
	0x0020acc8, // n0x1c5f c0x0000 (---------------)  + I balashov
	0x0031e689, // n0x1c60 c0x0000 (---------------)  + I bashkiria
	0x00225707, // n0x1c61 c0x0000 (---------------)  + I bryansk
	0x00201848, // n0x1c62 c0x0000 (---------------)  + I dagestan
	0x002fa586, // n0x1c63 c0x0000 (---------------)  + I grozny
	0x0026aac7, // n0x1c64 c0x0000 (---------------)  + I ivanovo
	0x00265088, // n0x1c65 c0x0000 (---------------)  + I kalmykia
	0x00249846, // n0x1c66 c0x0000 (---------------)  + I kaluga
	0x00319547, // n0x1c67 c0x0000 (---------------)  + I karelia
	0x0022b509, // n0x1c68 c0x0000 (---------------)  + I khakassia
	0x00376ec9, // n0x1c69 c0x0000 (---------------)  + I krasnodar
	0x002b2486, // n0x1c6a c0x0000 (---------------)  + I kurgan
	0x002b3105, // n0x1c6b c0x0000 (---------------)  + I lenug
	0x002c0588, // n0x1c6c c0x0000 (---------------)  + I mordovia
	0x0024c843, // n0x1c6d c0x0000 (---------------)  + I msk
	0x002c8288, // n0x1c6e c0x0000 (---------------)  + I murmansk
	0x002327c7, // n0x1c6f c0x0000 (---------------)  + I nalchik
	0x002069c3, // n0x1c70 c0x0000 (---------------)  + I nov
	0x00239387, // n0x1c71 c0x0000 (---------------)  + I obninsk
	0x002109c5, // n0x1c72 c0x0000 (---------------)  + I penza
	0x002d6bc8, // n0x1c73 c0x0000 (---------------)  + I pokrovsk
	0x0026e005, // n0x1c74 c0x0000 (---------------)  + I sochi
	0x00269f83, // n0x1c75 c0x0000 (---------------)  + I spb
	0x00333449, // n0x1c76 c0x0000 (---------------)  + I togliatti
	0x002a3f47, // n0x1c77 c0x0000 (---------------)  + I troitsk
	0x00356f04, // n0x1c78 c0x0000 (---------------)  + I tula
	0x002e7f84, // n0x1c79 c0x0000 (---------------)  + I tuva
	0x002ef74b, // n0x1c7a c0x0000 (---------------)  + I vladikavkaz
	0x002efa88, // n0x1c7b c0x0000 (---------------)  + I vladimir
	0x002f2c47, // n0x1c7c c0x0000 (---------------)  + I vologda
	0x0022d0c3, // n0x1c7d c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c7e c0x0000 (---------------)  + I edu
	0x00210ec3, // n0x1c7f c0x0000 (---------------)  + I gob
	0x00223a43, // n0x1c80 c0x0000 (---------------)  + I org
	0x0023b903, // n0x1c81 c0x0000 (---------------)  + I red
	0x00264783, // n0x1c82 c0x0000 (---------------)  + I gov
	0x0022d0c3, // n0x1c83 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c84 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1c85 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1c86 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1c87 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1c88 c0x0000 (---------------)  + I org
	0x00203982, // n0x1c89 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x1c8a c0x0000 (---------------)  + I co
	0x00223a43, // n0x1c8b c0x0000 (---------------)  + I org
	0x000f4e08, // n0x1c8c c0x0000 (---------------)  +   blogspot
	0x00203982, // n0x1c8d c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x1c8e c0x0000 (---------------)  + I co
	0x00200702, // n0x1c8f c0x0000 (---------------)  + I go
	0x00202082, // n0x1c90 c0x0000 (---------------)  + I in
	0x00204142, // n0x1c91 c0x0000 (---------------)  + I mi
	0x0021e283, // n0x1c92 c0x0000 (---------------)  + I net
	0x00200282, // n0x1c93 c0x0000 (---------------)  + I or
	0x00203982, // n0x1c94 c0x0000 (---------------)  + I ac
	0x00325b83, // n0x1c95 c0x0000 (---------------)  + I biz
	0x00203dc2, // n0x1c96 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1c97 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1c98 c0x0000 (---------------)  + I edu
	0x00200702, // n0x1c99 c0x0000 (---------------)  + I go
	0x00264783, // n0x1c9a c0x0000 (---------------)  + I gov
	0x00267a43, // n0x1c9b c0x0000 (---------------)  + I int
	0x00214d03, // n0x1c9c c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x1c9d c0x0000 (---------------)  + I name
	0x0021e283, // n0x1c9e c0x0000 (---------------)  + I net
	0x00217843, // n0x1c9f c0x0000 (---------------)  + I nic
	0x00223a43, // n0x1ca0 c0x0000 (---------------)  + I org
	0x002f4c44, // n0x1ca1 c0x0000 (---------------)  + I test
	0x002292c3, // n0x1ca2 c0x0000 (---------------)  + I web
	0x00264783, // n0x1ca3 c0x0000 (---------------)  + I gov
	0x00203dc2, // n0x1ca4 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1ca5 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1ca6 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1ca7 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1ca8 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1ca9 c0x0000 (---------------)  + I net
	0x0020f543, // n0x1caa c0x0000 (---------------)  + I nom
	0x00223a43, // n0x1cab c0x0000 (---------------)  + I org
	0x00319a07, // n0x1cac c0x0000 (---------------)  + I agrinet
	0x0022d0c3, // n0x1cad c0x0000 (---------------)  + I com
	0x002213c7, // n0x1cae c0x0000 (---------------)  + I defense
	0x002d49c6, // n0x1caf c0x0000 (---------------)  + I edunet
	0x0020d203, // n0x1cb0 c0x0000 (---------------)  + I ens
	0x00208543, // n0x1cb1 c0x0000 (---------------)  + I fin
	0x00264783, // n0x1cb2 c0x0000 (---------------)  + I gov
	0x0021c903, // n0x1cb3 c0x0000 (---------------)  + I ind
	0x003a4f84, // n0x1cb4 c0x0000 (---------------)  + I info
	0x0035a544, // n0x1cb5 c0x0000 (---------------)  + I intl
	0x002d1386, // n0x1cb6 c0x0000 (---------------)  + I mincom
	0x00218c83, // n0x1cb7 c0x0000 (---------------)  + I nat
	0x0021e283, // n0x1cb8 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1cb9 c0x0000 (---------------)  + I org
	0x00291545, // n0x1cba c0x0000 (---------------)  + I perso
	0x00386d04, // n0x1cbb c0x0000 (---------------)  + I rnrt
	0x002df083, // n0x1cbc c0x0000 (---------------)  + I rns
	0x0020a5c3, // n0x1cbd c0x0000 (---------------)  + I rnu
	0x002ba947, // n0x1cbe c0x0000 (---------------)  + I tourism
	0x0032ff45, // n0x1cbf c0x0000 (---------------)  + I turen
	0x0022d0c3, // n0x1cc0 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1cc1 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1cc2 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1cc3 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1cc4 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1cc5 c0x0000 (---------------)  + I org
	0x00202f82, // n0x1cc6 c0x0000 (---------------)  + I av
	0x002c7143, // n0x1cc7 c0x0000 (---------------)  + I bbs
	0x002b2703, // n0x1cc8 c0x0000 (---------------)  + I bel
	0x00325b83, // n0x1cc9 c0x0000 (---------------)  + I biz
	0x51a2d0c3, // n0x1cca c0x0146 (n0x1cdb-n0x1cdc)  + I com
	0x00205c82, // n0x1ccb c0x0000 (---------------)  + I dr
	0x002325c3, // n0x1ccc c0x0000 (---------------)  + I edu
	0x00206943, // n0x1ccd c0x0000 (---------------)  + I gen
	0x00264783, // n0x1cce c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1ccf c0x0000 (---------------)  + I info
	0x00369643, // n0x1cd0 c0x0000 (---------------)  + I k12
	0x0026b683, // n0x1cd1 c0x0000 (---------------)  + I kep
	0x00214d03, // n0x1cd2 c0x0000 (---------------)  + I mil
	0x0020ff84, // n0x1cd3 c0x0000 (---------------)  + I name
	0x51e08642, // n0x1cd4 c0x0147 (n0x1cdc-n0x1cdd)  + I nc
	0x0021e283, // n0x1cd5 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1cd6 c0x0000 (---------------)  + I org
	0x002200c3, // n0x1cd7 c0x0000 (---------------)  + I pol
	0x00227983, // n0x1cd8 c0x0000 (---------------)  + I tel
	0x0020da42, // n0x1cd9 c0x0000 (---------------)  + I tv
	0x002292c3, // n0x1cda c0x0000 (---------------)  + I web
	0x000f4e08, // n0x1cdb c0x0000 (---------------)  +   blogspot
	0x00264783, // n0x1cdc c0x0000 (---------------)  + I gov
	0x002dbdc4, // n0x1cdd c0x0000 (---------------)  + I aero
	0x00325b83, // n0x1cde c0x0000 (---------------)  + I biz
	0x00203dc2, // n0x1cdf c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1ce0 c0x0000 (---------------)  + I com
	0x00235044, // n0x1ce1 c0x0000 (---------------)  + I coop
	0x002325c3, // n0x1ce2 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1ce3 c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1ce4 c0x0000 (---------------)  + I info
	0x00267a43, // n0x1ce5 c0x0000 (---------------)  + I int
	0x002bc1c4, // n0x1ce6 c0x0000 (---------------)  + I jobs
	0x00207c84, // n0x1ce7 c0x0000 (---------------)  + I mobi
	0x002ca1c6, // n0x1ce8 c0x0000 (---------------)  + I museum
	0x0020ff84, // n0x1ce9 c0x0000 (---------------)  + I name
	0x0021e283, // n0x1cea c0x0000 (---------------)  + I net
	0x00223a43, // n0x1ceb c0x0000 (---------------)  + I org
	0x00220443, // n0x1cec c0x0000 (---------------)  + I pro
	0x0029b806, // n0x1ced c0x0000 (---------------)  + I travel
	0x0004fe0b, // n0x1cee c0x0000 (---------------)  +   better-than
	0x00020b06, // n0x1cef c0x0000 (---------------)  +   dyndns
	0x0002910a, // n0x1cf0 c0x0000 (---------------)  +   on-the-web
	0x000f434a, // n0x1cf1 c0x0000 (---------------)  +   worse-than
	0x000f4e08, // n0x1cf2 c0x0000 (---------------)  +   blogspot
	0x00387104, // n0x1cf3 c0x0000 (---------------)  + I club
	0x0022d0c3, // n0x1cf4 c0x0000 (---------------)  + I com
	0x00325b44, // n0x1cf5 c0x0000 (---------------)  + I ebiz
	0x002325c3, // n0x1cf6 c0x0000 (---------------)  + I edu
	0x00290184, // n0x1cf7 c0x0000 (---------------)  + I game
	0x00264783, // n0x1cf8 c0x0000 (---------------)  + I gov
	0x00310743, // n0x1cf9 c0x0000 (---------------)  + I idv
	0x00214d03, // n0x1cfa c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1cfb c0x0000 (---------------)  + I net
	0x00223a43, // n0x1cfc c0x0000 (---------------)  + I org
	0x0031b7cb, // n0x1cfd c0x0000 (---------------)  + I xn--czrw28b
	0x0038e60a, // n0x1cfe c0x0000 (---------------)  + I xn--uc0atv
	0x003a0d4c, // n0x1cff c0x0000 (---------------)  + I xn--zf0ao64a
	0x00203982, // n0x1d00 c0x0000 (---------------)  + I ac
	0x00203dc2, // n0x1d01 c0x0000 (---------------)  + I co
	0x00200702, // n0x1d02 c0x0000 (---------------)  + I go
	0x0022de05, // n0x1d03 c0x0000 (---------------)  + I hotel
	0x003a4f84, // n0x1d04 c0x0000 (---------------)  + I info
	0x00209502, // n0x1d05 c0x0000 (---------------)  + I me
	0x00214d03, // n0x1d06 c0x0000 (---------------)  + I mil
	0x00207c84, // n0x1d07 c0x0000 (---------------)  + I mobi
	0x00201e02, // n0x1d08 c0x0000 (---------------)  + I ne
	0x00200282, // n0x1d09 c0x0000 (---------------)  + I or
	0x00213402, // n0x1d0a c0x0000 (---------------)  + I sc
	0x0020da42, // n0x1d0b c0x0000 (---------------)  + I tv
	0x00125b83, // n0x1d0c c0x0000 (---------------)  +   biz
	0x002a56c9, // n0x1d0d c0x0000 (---------------)  + I cherkassy
	0x0027c308, // n0x1d0e c0x0000 (---------------)  + I cherkasy
	0x00264609, // n0x1d0f c0x0000 (---------------)  + I chernigov
	0x00275249, // n0x1d10 c0x0000 (---------------)  + I chernihiv
	0x00369f4a, // n0x1d11 c0x0000 (---------------)  + I chernivtsi
	0x0029934a, // n0x1d12 c0x0000 (---------------)  + I chernovtsy
	0x00204002, // n0x1d13 c0x0000 (---------------)  + I ck
	0x00219ec2, // n0x1d14 c0x0000 (---------------)  + I cn
	0x00003dc2, // n0x1d15 c0x0000 (---------------)  +   co
	0x0022d0c3, // n0x1d16 c0x0000 (---------------)  + I com
	0x0020ef82, // n0x1d17 c0x0000 (---------------)  + I cr
	0x0023f0c6, // n0x1d18 c0x0000 (---------------)  + I crimea
	0x00350142, // n0x1d19 c0x0000 (---------------)  + I cv
	0x0021a1c2, // n0x1d1a c0x0000 (---------------)  + I dn
	0x002cc0ce, // n0x1d1b c0x0000 (---------------)  + I dnepropetrovsk
	0x00269b8e, // n0x1d1c c0x0000 (---------------)  + I dnipropetrovsk
	0x002750c7, // n0x1d1d c0x0000 (---------------)  + I dominic
	0x00313d47, // n0x1d1e c0x0000 (---------------)  + I donetsk
	0x002cf002, // n0x1d1f c0x0000 (---------------)  + I dp
	0x002325c3, // n0x1d20 c0x0000 (---------------)  + I edu
	0x00264783, // n0x1d21 c0x0000 (---------------)  + I gov
	0x00200b42, // n0x1d22 c0x0000 (---------------)  + I if
	0x00202082, // n0x1d23 c0x0000 (---------------)  + I in
	0x002356cf, // n0x1d24 c0x0000 (---------------)  + I ivano-frankivsk
	0x00216a42, // n0x1d25 c0x0000 (---------------)  + I kh
	0x00235a47, // n0x1d26 c0x0000 (---------------)  + I kharkiv
	0x0023ab07, // n0x1d27 c0x0000 (---------------)  + I kharkov
	0x00243487, // n0x1d28 c0x0000 (---------------)  + I kherson
	0x0024404c, // n0x1d29 c0x0000 (---------------)  + I khmelnitskiy
	0x00249a4c, // n0x1d2a c0x0000 (---------------)  + I khmelnytskyi
	0x00201cc4, // n0x1d2b c0x0000 (---------------)  + I kiev
	0x0027808a, // n0x1d2c c0x0000 (---------------)  + I kirovograd
	0x00237642, // n0x1d2d c0x0000 (---------------)  + I km
	0x00207b42, // n0x1d2e c0x0000 (---------------)  + I kr
	0x002aaf04, // n0x1d2f c0x0000 (---------------)  + I krym
	0x00261382, // n0x1d30 c0x0000 (---------------)  + I ks
	0x002b6582, // n0x1d31 c0x0000 (---------------)  + I kv
	0x00249c84, // n0x1d32 c0x0000 (---------------)  + I kyiv
	0x00217942, // n0x1d33 c0x0000 (---------------)  + I lg
	0x00200d82, // n0x1d34 c0x0000 (---------------)  + I lt
	0x002498c7, // n0x1d35 c0x0000 (---------------)  + I lugansk
	0x00399bc5, // n0x1d36 c0x0000 (---------------)  + I lutsk
	0x0020dd82, // n0x1d37 c0x0000 (---------------)  + I lv
	0x00235644, // n0x1d38 c0x0000 (---------------)  + I lviv
	0x003626c2, // n0x1d39 c0x0000 (---------------)  + I mk
	0x0026a948, // n0x1d3a c0x0000 (---------------)  + I mykolaiv
	0x0021e283, // n0x1d3b c0x0000 (---------------)  + I net
	0x00203008, // n0x1d3c c0x0000 (---------------)  + I nikolaev
	0x00204e82, // n0x1d3d c0x0000 (---------------)  + I od
	0x00233945, // n0x1d3e c0x0000 (---------------)  + I odesa
	0x0036ce46, // n0x1d3f c0x0000 (---------------)  + I odessa
	0x00223a43, // n0x1d40 c0x0000 (---------------)  + I org
	0x00207502, // n0x1d41 c0x0000 (---------------)  + I pl
	0x002d7487, // n0x1d42 c0x0000 (---------------)  + I poltava
	0x00003902, // n0x1d43 c0x0000 (---------------)  +   pp
	0x002da805, // n0x1d44 c0x0000 (---------------)  + I rivne
	0x00383dc5, // n0x1d45 c0x0000 (---------------)  + I rovno
	0x002012c2, // n0x1d46 c0x0000 (---------------)  + I rv
	0x002239c2, // n0x1d47 c0x0000 (---------------)  + I sb
	0x0039870a, // n0x1d48 c0x0000 (---------------)  + I sebastopol
	0x00240e0a, // n0x1d49 c0x0000 (---------------)  + I sevastopol
	0x00214cc2, // n0x1d4a c0x0000 (---------------)  + I sm
	0x00353284, // n0x1d4b c0x0000 (---------------)  + I sumy
	0x00200dc2, // n0x1d4c c0x0000 (---------------)  + I te
	0x002c1e48, // n0x1d4d c0x0000 (---------------)  + I ternopil
	0x0020a142, // n0x1d4e c0x0000 (---------------)  + I uz
	0x00296388, // n0x1d4f c0x0000 (---------------)  + I uzhgorod
	0x002ec047, // n0x1d50 c0x0000 (---------------)  + I vinnica
	0x002ecd49, // n0x1d51 c0x0000 (---------------)  + I vinnytsia
	0x00202fc2, // n0x1d52 c0x0000 (---------------)  + I vn
	0x002f3405, // n0x1d53 c0x0000 (---------------)  + I volyn
	0x0027c7c5, // n0x1d54 c0x0000 (---------------)  + I yalta
	0x002be18b, // n0x1d55 c0x0000 (---------------)  + I zaporizhzhe
	0x002bebcc, // n0x1d56 c0x0000 (---------------)  + I zaporizhzhia
	0x00229d48, // n0x1d57 c0x0000 (---------------)  + I zhitomir
	0x002f37c8, // n0x1d58 c0x0000 (---------------)  + I zhytomyr
	0x002cf782, // n0x1d59 c0x0000 (---------------)  + I zp
	0x0021efc2, // n0x1d5a c0x0000 (---------------)  + I zt
	0x00203982, // n0x1d5b c0x0000 (---------------)  + I ac
	0x000f4e08, // n0x1d5c c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x1d5d c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1d5e c0x0000 (---------------)  + I com
	0x00200702, // n0x1d5f c0x0000 (---------------)  + I go
	0x00201e02, // n0x1d60 c0x0000 (---------------)  + I ne
	0x00200282, // n0x1d61 c0x0000 (---------------)  + I or
	0x00223a43, // n0x1d62 c0x0000 (---------------)  + I org
	0x00213402, // n0x1d63 c0x0000 (---------------)  + I sc
	0x00203982, // n0x1d64 c0x0000 (---------------)  + I ac
	0x53e03dc2, // n0x1d65 c0x014f (n0x1d6f-n0x1d70)  + I co
	0x54264783, // n0x1d66 c0x0150 (n0x1d70-n0x1d71)  + I gov
	0x00314403, // n0x1d67 c0x0000 (---------------)  + I ltd
	0x00209502, // n0x1d68 c0x0000 (---------------)  + I me
	0x0021e283, // n0x1d69 c0x0000 (---------------)  + I net
	0x002005c3, // n0x1d6a c0x0000 (---------------)  + I nhs
	0x00223a43, // n0x1d6b c0x0000 (---------------)  + I org
	0x002d2f03, // n0x1d6c c0x0000 (---------------)  + I plc
	0x002200c6, // n0x1d6d c0x0000 (---------------)  + I police
	0x01613403, // n0x1d6e c0x0005 (---------------)* o I sch
	0x000f4e08, // n0x1d6f c0x0000 (---------------)  +   blogspot
	0x00001247, // n0x1d70 c0x0000 (---------------)  +   service
	0x54a01c82, // n0x1d71 c0x0152 (n0x1db0-n0x1db3)  + I ak
	0x54e001c2, // n0x1d72 c0x0153 (n0x1db3-n0x1db6)  + I al
	0x55202942, // n0x1d73 c0x0154 (n0x1db6-n0x1db9)  + I ar
	0x55602642, // n0x1d74 c0x0155 (n0x1db9-n0x1dbc)  + I as
	0x55a04402, // n0x1d75 c0x0156 (n0x1dbc-n0x1dbf)  + I az
	0x55e00302, // n0x1d76 c0x0157 (n0x1dbf-n0x1dc2)  + I ca
	0x56203dc2, // n0x1d77 c0x0158 (n0x1dc2-n0x1dc5)  + I co
	0x5662f482, // n0x1d78 c0x0159 (n0x1dc5-n0x1dc8)  + I ct
	0x56a1dfc2, // n0x1d79 c0x015a (n0x1dc8-n0x1dcb)  + I dc
	0x56e00402, // n0x1d7a c0x015b (n0x1dcb-n0x1dce)  + I de
	0x00269b83, // n0x1d7b c0x0000 (---------------)  + I dni
	0x00200383, // n0x1d7c c0x0000 (---------------)  + I fed
	0x57213582, // n0x1d7d c0x015c (n0x1dce-n0x1dd1)  + I fl
	0x57600c82, // n0x1d7e c0x015d (n0x1dd1-n0x1dd4)  + I ga
	0x57a0b102, // n0x1d7f c0x015e (n0x1dd4-n0x1dd7)  + I gu
	0x57e009c2, // n0x1d80 c0x015f (n0x1dd7-n0x1dd9)  + I hi
	0x582079c2, // n0x1d81 c0x0160 (n0x1dd9-n0x1ddc)  + I ia
	0x58603782, // n0x1d82 c0x0161 (n0x1ddc-n0x1ddf)  + I id
	0x58a01b02, // n0x1d83 c0x0162 (n0x1ddf-n0x1de2)  + I il
	0x58e02082, // n0x1d84 c0x0163 (n0x1de2-n0x1de5)  + I in
	0x000acb45, // n0x1d85 c0x0000 (---------------)  +   is-by
	0x00222583, // n0x1d86 c0x0000 (---------------)  + I isa
	0x00286984, // n0x1d87 c0x0000 (---------------)  + I kids
	0x59261382, // n0x1d88 c0x0164 (n0x1de5-n0x1de8)  + I ks
	0x596306c2, // n0x1d89 c0x0165 (n0x1de8-n0x1deb)  + I ky
	0x59a03102, // n0x1d8a c0x0166 (n0x1deb-n0x1dee)  + I la
	0x0007de4b, // n0x1d8b c0x0000 (---------------)  +   land-4-sale
	0x59e00182, // n0x1d8c c0x0167 (n0x1dee-n0x1df1)  + I ma
	0x5a646c82, // n0x1d8d c0x0169 (n0x1df4-n0x1df7)  + I md
	0x5aa09502, // n0x1d8e c0x016a (n0x1df7-n0x1dfa)  + I me
	0x5ae04142, // n0x1d8f c0x016b (n0x1dfa-n0x1dfd)  + I mi
	0x5b21e242, // n0x1d90 c0x016c (n0x1dfd-n0x1e00)  + I mn
	0x5b607c82, // n0x1d91 c0x016d (n0x1e00-n0x1e03)  + I mo
	0x5ba0bbc2, // n0x1d92 c0x016e (n0x1e03-n0x1e06)  + I ms
	0x5be643c2, // n0x1d93 c0x016f (n0x1e06-n0x1e09)  + I mt
	0x5c208642, // n0x1d94 c0x0170 (n0x1e09-n0x1e0c)  + I nc
	0x5c605c42, // n0x1d95 c0x0171 (n0x1e0c-n0x1e0e)  + I nd
	0x5ca01e02, // n0x1d96 c0x0172 (n0x1e0e-n0x1e11)  + I ne
	0x5ce005c2, // n0x1d97 c0x0173 (n0x1e11-n0x1e14)  + I nh
	0x5d201482, // n0x1d98 c0x0174 (n0x1e14-n0x1e17)  + I nj
	0x5d6354c2, // n0x1d99 c0x0175 (n0x1e17-n0x1e1a)  + I nm
	0x0035bc43, // n0x1d9a c0x0000 (---------------)  + I nsn
	0x5da093c2, // n0x1d9b c0x0176 (n0x1e1a-n0x1e1d)  + I nv
	0x5de19bc2, // n0x1d9c c0x0177 (n0x1e1d-n0x1e20)  + I ny
	0x5e2083c2, // n0x1d9d c0x0178 (n0x1e20-n0x1e23)  + I oh
	0x5e602482, // n0x1d9e c0x0179 (n0x1e23-n0x1e26)  + I ok
	0x5ea00282, // n0x1d9f c0x017a (n0x1e26-n0x1e29)  + I or
	0x5ee03942, // n0x1da0 c0x017b (n0x1e29-n0x1e2c)  + I pa
	0x5f2052c2, // n0x1da1 c0x017c (n0x1e2c-n0x1e2f)  + I pr
	0x5f605302, // n0x1da2 c0x017d (n0x1e2f-n0x1e32)  + I ri
	0x5fa13402, // n0x1da3 c0x017e (n0x1e32-n0x1e35)  + I sc
	0x5fe56cc2, // n0x1da4 c0x017f (n0x1e35-n0x1e37)  + I sd
	0x000e0e0c, // n0x1da5 c0x0000 (---------------)  +   stuff-4-sale
	0x6022a482, // n0x1da6 c0x0180 (n0x1e37-n0x1e3a)  + I tn
	0x6066c182, // n0x1da7 c0x0181 (n0x1e3a-n0x1e3d)  + I tx
	0x60a08a82, // n0x1da8 c0x0182 (n0x1e3d-n0x1e40)  + I ut
	0x60e000c2, // n0x1da9 c0x0183 (n0x1e40-n0x1e43)  + I va
	0x61201302, // n0x1daa c0x0184 (n0x1e43-n0x1e46)  + I vi
	0x6166e582, // n0x1dab c0x0185 (n0x1e46-n0x1e49)  + I vt
	0x61a00d02, // n0x1dac c0x0186 (n0x1e49-n0x1e4c)  + I wa
	0x61e0a8c2, // n0x1dad c0x0187 (n0x1e4c-n0x1e4f)  + I wi
	0x6226edc2, // n0x1dae c0x0188 (n0x1e4f-n0x1e50)  + I wv
	0x62666a02, // n0x1daf c0x0189 (n0x1e50-n0x1e53)  + I wy
	0x0021e542, // n0x1db0 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1db1 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1db2 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1db3 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1db4 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1db5 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1db6 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1db7 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1db8 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1db9 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dba c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dbb c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dbc c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dbd c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dbe c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dbf c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dc0 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dc1 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dc2 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dc3 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dc4 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dc5 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dc6 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dc7 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dc8 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dc9 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dca c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dcb c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dcc c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dcd c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dce c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dcf c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dd0 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dd1 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dd2 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dd3 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dd4 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dd5 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dd6 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dd7 c0x0000 (---------------)  + I cc
	0x00268ec3, // n0x1dd8 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dd9 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dda c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1ddb c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1ddc c0x0000 (---------------)  + I cc
	0x00369643, // n0x1ddd c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dde c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1ddf c0x0000 (---------------)  + I cc
	0x00369643, // n0x1de0 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1de1 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1de2 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1de3 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1de4 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1de5 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1de6 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1de7 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1de8 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1de9 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dea c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1deb c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dec c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1ded c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dee c0x0000 (---------------)  + I cc
	0x5a369643, // n0x1def c0x0168 (n0x1df1-n0x1df4)  + I k12
	0x00268ec3, // n0x1df0 c0x0000 (---------------)  + I lib
	0x002f9744, // n0x1df1 c0x0000 (---------------)  + I chtr
	0x0027c206, // n0x1df2 c0x0000 (---------------)  + I paroch
	0x002de543, // n0x1df3 c0x0000 (---------------)  + I pvt
	0x0021e542, // n0x1df4 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1df5 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1df6 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1df7 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1df8 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1df9 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dfa c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dfb c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dfc c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1dfd c0x0000 (---------------)  + I cc
	0x00369643, // n0x1dfe c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1dff c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e00 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e01 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e02 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e03 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e04 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e05 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e06 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e07 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e08 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e09 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e0a c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e0b c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e0c c0x0000 (---------------)  + I cc
	0x00268ec3, // n0x1e0d c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e0e c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e0f c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e10 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e11 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e12 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e13 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e14 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e15 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e16 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e17 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e18 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e19 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e1a c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e1b c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e1c c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e1d c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e1e c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e1f c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e20 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e21 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e22 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e23 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e24 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e25 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e26 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e27 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e28 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e29 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e2a c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e2b c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e2c c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e2d c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e2e c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e2f c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e30 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e31 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e32 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e33 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e34 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e35 c0x0000 (---------------)  + I cc
	0x00268ec3, // n0x1e36 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e37 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e38 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e39 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e3a c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e3b c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e3c c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e3d c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e3e c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e3f c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e40 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e41 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e42 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e43 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e44 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e45 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e46 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e47 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e48 c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e49 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e4a c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e4b c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e4c c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e4d c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e4e c0x0000 (---------------)  + I lib
	0x0021e542, // n0x1e4f c0x0000 (---------------)  + I cc
	0x0021e542, // n0x1e50 c0x0000 (---------------)  + I cc
	0x00369643, // n0x1e51 c0x0000 (---------------)  + I k12
	0x00268ec3, // n0x1e52 c0x0000 (---------------)  + I lib
	0x62e2d0c3, // n0x1e53 c0x018b (n0x1e59-n0x1e5a)  + I com
	0x002325c3, // n0x1e54 c0x0000 (---------------)  + I edu
	0x00395b03, // n0x1e55 c0x0000 (---------------)  + I gub
	0x00214d03, // n0x1e56 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1e57 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e58 c0x0000 (---------------)  + I org
	0x000f4e08, // n0x1e59 c0x0000 (---------------)  +   blogspot
	0x00203dc2, // n0x1e5a c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1e5b c0x0000 (---------------)  + I com
	0x0021e283, // n0x1e5c c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e5d c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1e5e c0x0000 (---------------)  + I com
	0x002325c3, // n0x1e5f c0x0000 (---------------)  + I edu
	0x00264783, // n0x1e60 c0x0000 (---------------)  + I gov
	0x00214d03, // n0x1e61 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1e62 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e63 c0x0000 (---------------)  + I org
	0x00244d04, // n0x1e64 c0x0000 (---------------)  + I arts
	0x00203dc2, // n0x1e65 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1e66 c0x0000 (---------------)  + I com
	0x00300643, // n0x1e67 c0x0000 (---------------)  + I e12
	0x002325c3, // n0x1e68 c0x0000 (---------------)  + I edu
	0x00246bc4, // n0x1e69 c0x0000 (---------------)  + I firm
	0x00210ec3, // n0x1e6a c0x0000 (---------------)  + I gob
	0x00264783, // n0x1e6b c0x0000 (---------------)  + I gov
	0x003a4f84, // n0x1e6c c0x0000 (---------------)  + I info
	0x00267a43, // n0x1e6d c0x0000 (---------------)  + I int
	0x00214d03, // n0x1e6e c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1e6f c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e70 c0x0000 (---------------)  + I org
	0x00226e03, // n0x1e71 c0x0000 (---------------)  + I rec
	0x003758c5, // n0x1e72 c0x0000 (---------------)  + I store
	0x0023da03, // n0x1e73 c0x0000 (---------------)  + I tec
	0x002292c3, // n0x1e74 c0x0000 (---------------)  + I web
	0x00203dc2, // n0x1e75 c0x0000 (---------------)  + I co
	0x0022d0c3, // n0x1e76 c0x0000 (---------------)  + I com
	0x00369643, // n0x1e77 c0x0000 (---------------)  + I k12
	0x0021e283, // n0x1e78 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e79 c0x0000 (---------------)  + I org
	0x00203982, // n0x1e7a c0x0000 (---------------)  + I ac
	0x00325b83, // n0x1e7b c0x0000 (---------------)  + I biz
	0x000f4e08, // n0x1e7c c0x0000 (---------------)  +   blogspot
	0x0022d0c3, // n0x1e7d c0x0000 (---------------)  + I com
	0x002325c3, // n0x1e7e c0x0000 (---------------)  + I edu
	0x00264783, // n0x1e7f c0x0000 (---------------)  + I gov
	0x00366f06, // n0x1e80 c0x0000 (---------------)  + I health
	0x003a4f84, // n0x1e81 c0x0000 (---------------)  + I info
	0x00267a43, // n0x1e82 c0x0000 (---------------)  + I int
	0x0020ff84, // n0x1e83 c0x0000 (---------------)  + I name
	0x0021e283, // n0x1e84 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e85 c0x0000 (---------------)  + I org
	0x00220443, // n0x1e86 c0x0000 (---------------)  + I pro
	0x0022d0c3, // n0x1e87 c0x0000 (---------------)  + I com
	0x002325c3, // n0x1e88 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1e89 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e8a c0x0000 (---------------)  + I org
	0x0022d0c3, // n0x1e8b c0x0000 (---------------)  + I com
	0x00020b06, // n0x1e8c c0x0000 (---------------)  +   dyndns
	0x002325c3, // n0x1e8d c0x0000 (---------------)  + I edu
	0x00264783, // n0x1e8e c0x0000 (---------------)  + I gov
	0x000cab86, // n0x1e8f c0x0000 (---------------)  +   mypets
	0x0021e283, // n0x1e90 c0x0000 (---------------)  + I net
	0x00223a43, // n0x1e91 c0x0000 (---------------)  + I org
	0x00300988, // n0x1e92 c0x0000 (---------------)  + I xn--80au
	0x00305949, // n0x1e93 c0x0000 (---------------)  + I xn--90azh
	0x003121c9, // n0x1e94 c0x0000 (---------------)  + I xn--c1avg
	0x0031f608, // n0x1e95 c0x0000 (---------------)  + I xn--d1at
	0x0036ee08, // n0x1e96 c0x0000 (---------------)  + I xn--o1ac
	0x0036ee09, // n0x1e97 c0x0000 (---------------)  + I xn--o1ach
	0x00203982, // n0x1e98 c0x0000 (---------------)  + I ac
	0x002ffac6, // n0x1e99 c0x0000 (---------------)  + I agrica
	0x00200d43, // n0x1e9a c0x0000 (---------------)  + I alt
	0x65603dc2, // n0x1e9b c0x0195 (n0x1ea9-n0x1eaa)  + I co
	0x002325c3, // n0x1e9c c0x0000 (---------------)  + I edu
	0x00264783, // n0x1e9d c0x0000 (---------------)  + I gov
	0x0025e007, // n0x1e9e c0x0000 (---------------)  + I grondar
	0x00266983, // n0x1e9f c0x0000 (---------------)  + I law
	0x00214d03, // n0x1ea0 c0x0000 (---------------)  + I mil
	0x0021e283, // n0x1ea1 c0x0000 (---------------)  + I net
	0x002006c3, // n0x1ea2 c0x0000 (---------------)  + I ngo
	0x00211503, // n0x1ea3 c0x0000 (---------------)  + I nis
	0x0020f543, // n0x1ea4 c0x0000 (---------------)  + I nom
	0x00223a43, // n0x1ea5 c0x0000 (---------------)  + I org
	0x00381f46, // n0x1ea6 c0x0000 (---------------)  + I school
	0x00200142, // n0x1ea7 c0x0000 (---------------)  + I tm
	0x002292c3, // n0x1ea8 c0x0000 (---------------)  + I web
	0x000f4e08, // n0x1ea9 c0x0000 (---------------)  +   blogspot
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x018105fe, // c0x0006 (n0x05fe-n0x0604)  +
	0x01814604, // c0x0007 (n0x0604-n0x0605)  +
	0x01834605, // c0x0008 (n0x0605-n0x060d)  +
	0x0199060d, // c0x0009 (n0x060d-n0x0664)  +
	0x019a4664, // c0x000a (n0x0664-n0x0669)  +
	0x019b8669, // c0x000b (n0x0669-n0x066e)  +
	0x019c866e, // c0x000c (n0x066e-n0x0672)  +
	0x019e4672, // c0x000d (n0x0672-n0x0679)  +
	0x019e8679, // c0x000e (n0x0679-n0x067a)  +
	0x01a0067a, // c0x000f (n0x067a-n0x0680)  +
	0x01a24680, // c0x0010 (n0x0680-n0x0689)  +
	0x01a28689, // c0x0011 (n0x0689-n0x068a)  +
	0x01a4068a, // c0x0012 (n0x068a-n0x0690)  +
	0x01a44690, // c0x0013 (n0x0690-n0x0691)  +
	0x01a60691, // c0x0014 (n0x0691-n0x0698)  +
	0x01a64698, // c0x0015 (n0x0698-n0x0699)  +
	0x01aac699, // c0x0016 (n0x0699-n0x06ab)  +
	0x01ab06ab, // c0x0017 (n0x06ab-n0x06ac)  +
	0x01ad06ac, // c0x0018 (n0x06ac-n0x06b4)  +
	0x01ae46b4, // c0x0019 (n0x06b4-n0x06b9)  +
	0x01ae86b9, // c0x001a (n0x06b9-n0x06ba)  +
	0x01b186ba, // c0x001b (n0x06ba-n0x06c6)  +
	0x01b446c6, // c0x001c (n0x06c6-n0x06d1)  +
	0x01b6c6d1, // c0x001d (n0x06d1-n0x06db)  +
	0x01b746db, // c0x001e (n0x06db-n0x06dd)  +
	0x01b786dd, // c0x001f (n0x06dd-n0x06de)  +
	0x01c0c6de, // c0x0020 (n0x06de-n0x0703)  +
	0x01c20703, // c0x0021 (n0x0703-n0x0708)  +
	0x01c34708, // c0x0022 (n0x0708-n0x070d)  +
	0x01c5470d, // c0x0023 (n0x070d-n0x0715)  +
	0x01c64715, // c0x0024 (n0x0715-n0x0719)  +
	0x01c78719, // c0x0025 (n0x0719-n0x071e)  +
	0x01c9c71e, // c0x0026 (n0x071e-n0x0727)  +
	0x01db4727, // c0x0027 (n0x0727-n0x076d)  +
	0x01db876d, // c0x0028 (n0x076d-n0x076e)  +
	0x01dcc76e, // c0x0029 (n0x076e-n0x0773)  +
	0x01de0773, // c0x002a (n0x0773-n0x0778)  +
	0x01de8778, // c0x002b (n0x0778-n0x077a)  +
	0x01df877a, // c0x002c (n0x077a-n0x077e)  +
	0x01dfc77e, // c0x002d (n0x077e-n0x077f)  +
	0x01e1477f, // c0x002e (n0x077f-n0x0785)  +
	0x01e58785, // c0x002f (n0x0785-n0x0796)  +
	0x01e68796, // c0x0030 (n0x0796-n0x079a)  +
	0x01e6c79a, // c0x0031 (n0x079a-n0x079b)  +
	0x01e7079b, // c0x0032 (n0x079b-n0x079c)  +
	0x01e7479c, // c0x0033 (n0x079c-n0x079d)  +
	0x01eb079d, // c0x0034 (n0x079d-n0x07ac)  +
	0x61eb47ac, // c0x0035 (n0x07ac-n0x07ad)* o
	0x01ec87ad, // c0x0036 (n0x07ad-n0x07b2)  +
	0x01ed87b2, // c0x0037 (n0x07b2-n0x07b6)  +
	0x01f8c7b6, // c0x0038 (n0x07b6-n0x07e3)  +
	0x21f907e3, // c0x0039 (n0x07e3-n0x07e4)  o
	0x01f947e4, // c0x003a (n0x07e4-n0x07e5)  +
	0x01f987e5, // c0x003b (n0x07e5-n0x07e6)  +
	0x21f9c7e6, // c0x003c (n0x07e6-n0x07e7)  o
	0x21fa07e7, // c0x003d (n0x07e7-n0x07e8)  o
	0x01fd47e8, // c0x003e (n0x07e8-n0x07f5)  +
	0x01fd87f5, // c0x003f (n0x07f5-n0x07f6)  +
	0x023187f6, // c0x0040 (n0x07f6-n0x08c6)  +
	0x223608c6, // c0x0041 (n0x08c6-n0x08d8)  o
	0x023848d8, // c0x0042 (n0x08d8-n0x08e1)  +
	0x0238c8e1, // c0x0043 (n0x08e1-n0x08e3)  +
	0x223908e3, // c0x0044 (n0x08e3-n0x08e4)  o
	0x023ac8e4, // c0x0045 (n0x08e4-n0x08eb)  +
	0x023c48eb, // c0x0046 (n0x08eb-n0x08f1)  +
	0x023c88f1, // c0x0047 (n0x08f1-n0x08f2)  +
	0x023d88f2, // c0x0048 (n0x08f2-n0x08f6)  +
	0x023e08f6, // c0x0049 (n0x08f6-n0x08f8)  +
	0x224148f8, // c0x004a (n0x08f8-n0x0905)  o
	0x02418905, // c0x004b (n0x0905-n0x0906)  +
	0x0241c906, // c0x004c (n0x0906-n0x0907)  +
	0x0243c907, // c0x004d (n0x0907-n0x090f)  +
	0x0244090f, // c0x004e (n0x090f-n0x0910)  +
	0x02454910, // c0x004f (n0x0910-n0x0915)  +
	0x0247c915, // c0x0050 (n0x0915-n0x091f)  +
	0x0249c91f, // c0x0051 (n0x091f-n0x0927)  +
	0x024cc927, // c0x0052 (n0x0927-n0x0933)  +
	0x024f4933, // c0x0053 (n0x0933-n0x093d)  +
	0x024f893d, // c0x0054 (n0x093d-n0x093e)  +
	0x0251c93e, // c0x0055 (n0x093e-n0x0947)  +
	0x02520947, // c0x0056 (n0x0947-n0x0948)  +
	0x02534948, // c0x0057 (n0x0948-n0x094d)  +
	0x0253894d, // c0x0058 (n0x094d-n0x094e)  +
	0x0255894e, // c0x0059 (n0x094e-n0x0956)  +
	0x02564956, // c0x005a (n0x0956-n0x0959)  +
	0x025c4959, // c0x005b (n0x0959-n0x0971)  +
	0x025e0971, // c0x005c (n0x0971-n0x0978)  +
	0x025ec978, // c0x005d (n0x0978-n0x097b)  +
	0x0260097b, // c0x005e (n0x097b-n0x0980)  +
	0x02618980, // c0x005f (n0x0980-n0x0986)  +
	0x0262c986, // c0x0060 (n0x0986-n0x098b)  +
	0x0264498b, // c0x0061 (n0x098b-n0x0991)  +
	0x0265c991, // c0x0062 (n0x0991-n0x0997)  +
	0x02674997, // c0x0063 (n0x0997-n0x099d)  +
	0x0269099d, // c0x0064 (n0x099d-n0x09a4)  +
	0x0269c9a4, // c0x0065 (n0x09a4-n0x09a7)  +
	0x026fc9a7, // c0x0066 (n0x09a7-n0x09bf)  +
	0x027149bf, // c0x0067 (n0x09bf-n0x09c5)  +
	0x027289c5, // c0x0068 (n0x09c5-n0x09ca)  +
	0x0276c9ca, // c0x0069 (n0x09ca-n0x09db)  +
	0x027ec9db, // c0x006a (n0x09db-n0x09fb)  +
	0x028189fb, // c0x006b (n0x09fb-n0x0a06)  +
	0x0281ca06, // c0x006c (n0x0a06-n0x0a07)  +
	0x02824a07, // c0x006d (n0x0a07-n0x0a09)  +
	0x02844a09, // c0x006e (n0x0a09-n0x0a11)  +
	0x02848a11, // c0x006f (n0x0a11-n0x0a12)  +
	0x02864a12, // c0x0070 (n0x0a12-n0x0a19)  +
	0x0286ca19, // c0x0071 (n0x0a19-n0x0a1b)  +
	0x028a0a1b, // c0x0072 (n0x0a1b-n0x0a28)  +
	0x028c8a28, // c0x0073 (n0x0a28-n0x0a32)  +
	0x028cca32, // c0x0074 (n0x0a32-n0x0a33)  +
	0x028e4a33, // c0x0075 (n0x0a33-n0x0a39)  +
	0x028fca39, // c0x0076 (n0x0a39-n0x0a3f)  +
	0x02920a3f, // c0x0077 (n0x0a3f-n0x0a48)  +
	0x02940a48, // c0x0078 (n0x0a48-n0x0a50)  +
	0x02f04a50, // c0x0079 (n0x0a50-n0x0bc1)  +
	0x02f10bc1, // c0x007a (n0x0bc1-n0x0bc4)  +
	0x02f30bc4, // c0x007b (n0x0bc4-n0x0bcc)  +
	0x030ecbcc, // c0x007c (n0x0bcc-n0x0c3b)  +
	0x031bcc3b, // c0x007d (n0x0c3b-n0x0c6f)  +
	0x0322cc6f, // c0x007e (n0x0c6f-n0x0c8b)  +
	0x03284c8b, // c0x007f (n0x0c8b-n0x0ca1)  +
	0x0336cca1, // c0x0080 (n0x0ca1-n0x0cdb)  +
	0x033c4cdb, // c0x0081 (n0x0cdb-n0x0cf1)  +
	0x03400cf1, // c0x0082 (n0x0cf1-n0x0d00)  +
	0x034fcd00, // c0x0083 (n0x0d00-n0x0d3f)  +
	0x035c8d3f, // c0x0084 (n0x0d3f-n0x0d72)  +
	0x03660d72, // c0x0085 (n0x0d72-n0x0d98)  +
	0x036f0d98, // c0x0086 (n0x0d98-n0x0dbc)  +
	0x03754dbc, // c0x0087 (n0x0dbc-n0x0dd5)  +
	0x0398cdd5, // c0x0088 (n0x0dd5-n0x0e63)  +
	0x03a44e63, // c0x0089 (n0x0e63-n0x0e91)  +
	0x03b10e91, // c0x008a (n0x0e91-n0x0ec4)  +
	0x03b5cec4, // c0x008b (n0x0ec4-n0x0ed7)  +
	0x03be4ed7, // c0x008c (n0x0ed7-n0x0ef9)  +
	0x03c20ef9, // c0x008d (n0x0ef9-n0x0f08)  +
	0x03c70f08, // c0x008e (n0x0f08-n0x0f1c)  +
	0x03ce8f1c, // c0x008f (n0x0f1c-n0x0f3a)  +
	0x63cecf3a, // c0x0090 (n0x0f3a-n0x0f3b)* o
	0x63cf0f3b, // c0x0091 (n0x0f3b-n0x0f3c)* o
	0x63cf4f3c, // c0x0092 (n0x0f3c-n0x0f3d)* o
	0x03d70f3d, // c0x0093 (n0x0f3d-n0x0f5c)  +
	0x03dd8f5c, // c0x0094 (n0x0f5c-n0x0f76)  +
	0x03e54f76, // c0x0095 (n0x0f76-n0x0f95)  +
	0x03eccf95, // c0x0096 (n0x0f95-n0x0fb3)  +
	0x03f50fb3, // c0x0097 (n0x0fb3-n0x0fd4)  +
	0x03fbcfd4, // c0x0098 (n0x0fd4-n0x0fef)  +
	0x040e8fef, // c0x0099 (n0x0fef-n0x103a)  +
	0x0414103a, // c0x009a (n0x103a-n0x1050)  +
	0x64145050, // c0x009b (n0x1050-n0x1051)* o
	0x041dd051, // c0x009c (n0x1051-n0x1077)  +
	0x04265077, // c0x009d (n0x1077-n0x1099)  +
	0x042b1099, // c0x009e (n0x1099-n0x10ac)  +
	0x043190ac, // c0x009f (n0x10ac-n0x10c6)  +
	0x043c10c6, // c0x00a0 (n0x10c6-n0x10f0)  +
	0x044890f0, // c0x00a1 (n0x10f0-n0x1122)  +
	0x044f1122, // c0x00a2 (n0x1122-n0x113c)  +
	0x0460513c, // c0x00a3 (n0x113c-n0x1181)  +
	0x64609181, // c0x00a4 (n0x1181-n0x1182)* o
	0x6460d182, // c0x00a5 (n0x1182-n0x1183)* o
	0x04669183, // c0x00a6 (n0x1183-n0x119a)  +
	0x046c519a, // c0x00a7 (n0x119a-n0x11b1)  +
	0x047551b1, // c0x00a8 (n0x11b1-n0x11d5)  +
	0x047d11d5, // c0x00a9 (n0x11d5-n0x11f4)  +
	0x048151f4, // c0x00aa (n0x11f4-n0x1205)  +
	0x048f9205, // c0x00ab (n0x1205-n0x123e)  +
	0x0492d23e, // c0x00ac (n0x123e-n0x124b)  +
	0x0498d24b, // c0x00ad (n0x124b-n0x1263)  +
	0x04a01263, // c0x00ae (n0x1263-n0x1280)  +
	0x04a89280, // c0x00af (n0x1280-n0x12a2)  +
	0x04ac92a2, // c0x00b0 (n0x12a2-n0x12b2)  +
	0x04b392b2, // c0x00b1 (n0x12b2-n0x12ce)  +
	0x64b3d2ce, // c0x00b2 (n0x12ce-n0x12cf)* o
	0x64b412cf, // c0x00b3 (n0x12cf-n0x12d0)* o
	0x24b452d0, // c0x00b4 (n0x12d0-n0x12d1)  o
	0x04b5d2d1, // c0x00b5 (n0x12d1-n0x12d7)  +
	0x04b792d7, // c0x00b6 (n0x12d7-n0x12de)  +
	0x04bbd2de, // c0x00b7 (n0x12de-n0x12ef)  +
	0x04bcd2ef, // c0x00b8 (n0x12ef-n0x12f3)  +
	0x04be52f3, // c0x00b9 (n0x12f3-n0x12f9)  +
	0x04c5d2f9, // c0x00ba (n0x12f9-n0x1317)  +
	0x04c71317, // c0x00bb (n0x1317-n0x131c)  +
	0x04c8931c, // c0x00bc (n0x131c-n0x1322)  +
	0x04cad322, // c0x00bd (n0x1322-n0x132b)  +
	0x04cc132b, // c0x00be (n0x132b-n0x1330)  +
	0x04cd9330, // c0x00bf (n0x1330-n0x1336)  +
	0x04cdd336, // c0x00c0 (n0x1336-n0x1337)  +
	0x04d19337, // c0x00c1 (n0x1337-n0x1346)  +
	0x04d2d346, // c0x00c2 (n0x1346-n0x134b)  +
	0x04d3534b, // c0x00c3 (n0x134b-n0x134d)  +
	0x04d3d34d, // c0x00c4 (n0x134d-n0x134f)  +
	0x04d4134f, // c0x00c5 (n0x134f-n0x1350)  +
	0x04d65350, // c0x00c6 (n0x1350-n0x1359)  +
	0x04d89359, // c0x00c7 (n0x1359-n0x1362)  +
	0x04da1362, // c0x00c8 (n0x1362-n0x1368)  +
	0x04da9368, // c0x00c9 (n0x1368-n0x136a)  +
	0x04dad36a, // c0x00ca (n0x136a-n0x136b)  +
	0x04de136b, // c0x00cb (n0x136b-n0x1378)  +
	0x04e05378, // c0x00cc (n0x1378-n0x1381)  +
	0x04e25381, // c0x00cd (n0x1381-n0x1389)  +
	0x04e41389, // c0x00ce (n0x1389-n0x1390)  +
	0x04e51390, // c0x00cf (n0x1390-n0x1394)  +
	0x04e65394, // c0x00d0 (n0x1394-n0x1399)  +
	0x04e69399, // c0x00d1 (n0x1399-n0x139a)  +
	0x04e7139a, // c0x00d2 (n0x139a-n0x139c)  +
	0x04e8539c, // c0x00d3 (n0x139c-n0x13a1)  +
	0x04e953a1, // c0x00d4 (n0x13a1-n0x13a5)  +
	0x04e993a5, // c0x00d5 (n0x13a5-n0x13a6)  +
	0x04eb53a6, // c0x00d6 (n0x13a6-n0x13ad)  +
	0x057453ad, // c0x00d7 (n0x13ad-n0x15d1)  +
	0x0577d5d1, // c0x00d8 (n0x15d1-n0x15df)  +
	0x057a95df, // c0x00d9 (n0x15df-n0x15ea)  +
	0x057c15ea, // c0x00da (n0x15ea-n0x15f0)  +
	0x057e15f0, // c0x00db (n0x15f0-n0x15f8)  +
	0x657e55f8, // c0x00dc (n0x15f8-n0x15f9)* o
	0x058295f9, // c0x00dd (n0x15f9-n0x160a)  +
	0x0583160a, // c0x00de (n0x160a-n0x160c)  +
	0x2583560c, // c0x00df (n0x160c-n0x160d)  o
	0x2583960d, // c0x00e0 (n0x160d-n0x160e)  o
	0x0583d60e, // c0x00e1 (n0x160e-n0x160f)  +
	0x0590d60f, // c0x00e2 (n0x160f-n0x1643)  +
	0x25911643, // c0x00e3 (n0x1643-n0x1644)  o
	0x25919644, // c0x00e4 (n0x1644-n0x1646)  o
	0x25921646, // c0x00e5 (n0x1646-n0x1648)  o
	0x2592d648, // c0x00e6 (n0x1648-n0x164b)  o
	0x0595564b, // c0x00e7 (n0x164b-n0x1655)  +
	0x05979655, // c0x00e8 (n0x1655-n0x165e)  +
	0x0597d65e, // c0x00e9 (n0x165e-n0x165f)  +
	0x259b565f, // c0x00ea (n0x165f-n0x166d)  o
	0x059c166d, // c0x00eb (n0x166d-n0x1670)  +
	0x06519670, // c0x00ec (n0x1670-n0x1946)  +
	0x0651d946, // c0x00ed (n0x1946-n0x1947)  +
	0x06521947, // c0x00ee (n0x1947-n0x1948)  +
	0x26525948, // c0x00ef (n0x1948-n0x1949)  o
	0x06529949, // c0x00f0 (n0x1949-n0x194a)  +
	0x2652d94a, // c0x00f1 (n0x194a-n0x194b)  o
	0x0653194b, // c0x00f2 (n0x194b-n0x194c)  +
	0x2653d94c, // c0x00f3 (n0x194c-n0x194f)  o
	0x0654194f, // c0x00f4 (n0x194f-n0x1950)  +
	0x06545950, // c0x00f5 (n0x1950-n0x1951)  +
	0x26549951, // c0x00f6 (n0x1951-n0x1952)  o
	0x0654d952, // c0x00f7 (n0x1952-n0x1953)  +
	0x26555953, // c0x00f8 (n0x1953-n0x1955)  o
	0x06559955, // c0x00f9 (n0x1955-n0x1956)  +
	0x0655d956, // c0x00fa (n0x1956-n0x1957)  +
	0x2656d957, // c0x00fb (n0x1957-n0x195b)  o
	0x0657195b, // c0x00fc (n0x195b-n0x195c)  +
	0x0657595c, // c0x00fd (n0x195c-n0x195d)  +
	0x0657995d, // c0x00fe (n0x195d-n0x195e)  +
	0x0657d95e, // c0x00ff (n0x195e-n0x195f)  +
	0x2658195f, // c0x0100 (n0x195f-n0x1960)  o
	0x06585960, // c0x0101 (n0x1960-n0x1961)  +
	0x06589961, // c0x0102 (n0x1961-n0x1962)  +
	0x0658d962, // c0x0103 (n0x1962-n0x1963)  +
	0x06591963, // c0x0104 (n0x1963-n0x1964)  +
	0x26599964, // c0x0105 (n0x1964-n0x1966)  o
	0x0659d966, // c0x0106 (n0x1966-n0x1967)  +
	0x065a1967, // c0x0107 (n0x1967-n0x1968)  +
	0x065a5968, // c0x0108 (n0x1968-n0x1969)  +
	0x265a9969, // c0x0109 (n0x1969-n0x196a)  o
	0x065ad96a, // c0x010a (n0x196a-n0x196b)  +
	0x265b596b, // c0x010b (n0x196b-n0x196d)  o
	0x265b996d, // c0x010c (n0x196d-n0x196e)  o
	0x065d596e, // c0x010d (n0x196e-n0x1975)  +
	0x065e1975, // c0x010e (n0x1975-n0x1978)  +
	0x06621978, // c0x010f (n0x1978-n0x1988)  +
	0x06625988, // c0x0110 (n0x1988-n0x1989)  +
	0x06649989, // c0x0111 (n0x1989-n0x1992)  +
	0x0673d992, // c0x0112 (n0x1992-n0x19cf)  +
	0x267459cf, // c0x0113 (n0x19cf-n0x19d1)  o
	0x267499d1, // c0x0114 (n0x19d1-n0x19d2)  o
	0x2674d9d2, // c0x0115 (n0x19d2-n0x19d3)  o
	0x067559d3, // c0x0116 (n0x19d3-n0x19d5)  +
	0x068319d5, // c0x0117 (n0x19d5-n0x1a0c)  +
	0x0685da0c, // c0x0118 (n0x1a0c-n0x1a17)  +
	0x0687da17, // c0x0119 (n0x1a17-n0x1a1f)  +
	0x06889a1f, // c0x011a (n0x1a1f-n0x1a22)  +
	0x068a9a22, // c0x011b (n0x1a22-n0x1a2a)  +
	0x068e1a2a, // c0x011c (n0x1a2a-n0x1a38)  +
	0x06b75a38, // c0x011d (n0x1a38-n0x1add)  +
	0x06c31add, // c0x011e (n0x1add-n0x1b0c)  +
	0x06c45b0c, // c0x011f (n0x1b0c-n0x1b11)  +
	0x06c79b11, // c0x0120 (n0x1b11-n0x1b1e)  +
	0x06c95b1e, // c0x0121 (n0x1b1e-n0x1b25)  +
	0x06cb1b25, // c0x0122 (n0x1b25-n0x1b2c)  +
	0x06cd5b2c, // c0x0123 (n0x1b2c-n0x1b35)  +
	0x06cedb35, // c0x0124 (n0x1b35-n0x1b3b)  +
	0x06d09b3b, // c0x0125 (n0x1b3b-n0x1b42)  +
	0x06d2db42, // c0x0126 (n0x1b42-n0x1b4b)  +
	0x06d3db4b, // c0x0127 (n0x1b4b-n0x1b4f)  +
	0x06d6db4f, // c0x0128 (n0x1b4f-n0x1b5b)  +
	0x06d89b5b, // c0x0129 (n0x1b5b-n0x1b62)  +
	0x06f95b62, // c0x012a (n0x1b62-n0x1be5)  +
	0x06fb9be5, // c0x012b (n0x1be5-n0x1bee)  +
	0x06fd9bee, // c0x012c (n0x1bee-n0x1bf6)  +
	0x06fedbf6, // c0x012d (n0x1bf6-n0x1bfb)  +
	0x07001bfb, // c0x012e (n0x1bfb-n0x1c00)  +
	0x07021c00, // c0x012f (n0x1c00-n0x1c08)  +
	0x070c5c08, // c0x0130 (n0x1c08-n0x1c31)  +
	0x070e1c31, // c0x0131 (n0x1c31-n0x1c38)  +
	0x070fdc38, // c0x0132 (n0x1c38-n0x1c3f)  +
	0x07101c3f, // c0x0133 (n0x1c3f-n0x1c40)  +
	0x07105c40, // c0x0134 (n0x1c40-n0x1c41)  +
	0x07119c41, // c0x0135 (n0x1c41-n0x1c46)  +
	0x07139c46, // c0x0136 (n0x1c46-n0x1c4e)  +
	0x07145c4e, // c0x0137 (n0x1c4e-n0x1c51)  +
	0x07175c51, // c0x0138 (n0x1c51-n0x1c5d)  +
	0x071f5c5d, // c0x0139 (n0x1c5d-n0x1c7d)  +
	0x07209c7d, // c0x013a (n0x1c7d-n0x1c82)  +
	0x0720dc82, // c0x013b (n0x1c82-n0x1c83)  +
	0x07225c83, // c0x013c (n0x1c83-n0x1c89)  +
	0x07231c89, // c0x013d (n0x1c89-n0x1c8c)  +
	0x07235c8c, // c0x013e (n0x1c8c-n0x1c8d)  +
	0x07251c8d, // c0x013f (n0x1c8d-n0x1c94)  +
	0x0728dc94, // c0x0140 (n0x1c94-n0x1ca3)  +
	0x07291ca3, // c0x0141 (n0x1ca3-n0x1ca4)  +
	0x072b1ca4, // c0x0142 (n0x1ca4-n0x1cac)  +
	0x07301cac, // c0x0143 (n0x1cac-n0x1cc0)  +
	0x07319cc0, // c0x0144 (n0x1cc0-n0x1cc6)  +
	0x0736dcc6, // c0x0145 (n0x1cc6-n0x1cdb)  +
	0x07371cdb, // c0x0146 (n0x1cdb-n0x1cdc)  +
	0x07375cdc, // c0x0147 (n0x1cdc-n0x1cdd)  +
	0x073b9cdd, // c0x0148 (n0x1cdd-n0x1cee)  +
	0x073c9cee, // c0x0149 (n0x1cee-n0x1cf2)  +
	0x07401cf2, // c0x014a (n0x1cf2-n0x1d00)  +
	0x07431d00, // c0x014b (n0x1d00-n0x1d0c)  +
	0x0756dd0c, // c0x014c (n0x1d0c-n0x1d5b)  +
	0x07591d5b, // c0x014d (n0x1d5b-n0x1d64)  +
	0x075bdd64, // c0x014e (n0x1d64-n0x1d6f)  +
	0x075c1d6f, // c0x014f (n0x1d6f-n0x1d70)  +
	0x075c5d70, // c0x0150 (n0x1d70-n0x1d71)  +
	0x076c1d71, // c0x0151 (n0x1d71-n0x1db0)  +
	0x076cddb0, // c0x0152 (n0x1db0-n0x1db3)  +
	0x076d9db3, // c0x0153 (n0x1db3-n0x1db6)  +
	0x076e5db6, // c0x0154 (n0x1db6-n0x1db9)  +
	0x076f1db9, // c0x0155 (n0x1db9-n0x1dbc)  +
	0x076fddbc, // c0x0156 (n0x1dbc-n0x1dbf)  +
	0x07709dbf, // c0x0157 (n0x1dbf-n0x1dc2)  +
	0x07715dc2, // c0x0158 (n0x1dc2-n0x1dc5)  +
	0x07721dc5, // c0x0159 (n0x1dc5-n0x1dc8)  +
	0x0772ddc8, // c0x015a (n0x1dc8-n0x1dcb)  +
	0x07739dcb, // c0x015b (n0x1dcb-n0x1dce)  +
	0x07745dce, // c0x015c (n0x1dce-n0x1dd1)  +
	0x07751dd1, // c0x015d (n0x1dd1-n0x1dd4)  +
	0x0775ddd4, // c0x015e (n0x1dd4-n0x1dd7)  +
	0x07765dd7, // c0x015f (n0x1dd7-n0x1dd9)  +
	0x07771dd9, // c0x0160 (n0x1dd9-n0x1ddc)  +
	0x0777dddc, // c0x0161 (n0x1ddc-n0x1ddf)  +
	0x07789ddf, // c0x0162 (n0x1ddf-n0x1de2)  +
	0x07795de2, // c0x0163 (n0x1de2-n0x1de5)  +
	0x077a1de5, // c0x0164 (n0x1de5-n0x1de8)  +
	0x077adde8, // c0x0165 (n0x1de8-n0x1deb)  +
	0x077b9deb, // c0x0166 (n0x1deb-n0x1dee)  +
	0x077c5dee, // c0x0167 (n0x1dee-n0x1df1)  +
	0x077d1df1, // c0x0168 (n0x1df1-n0x1df4)  +
	0x077dddf4, // c0x0169 (n0x1df4-n0x1df7)  +
	0x077e9df7, // c0x016a (n0x1df7-n0x1dfa)  +
	0x077f5dfa, // c0x016b (n0x1dfa-n0x1dfd)  +
	0x07801dfd, // c0x016c (n0x1dfd-n0x1e00)  +
	0x0780de00, // c0x016d (n0x1e00-n0x1e03)  +
	0x07819e03, // c0x016e (n0x1e03-n0x1e06)  +
	0x07825e06, // c0x016f (n0x1e06-n0x1e09)  +
	0x07831e09, // c0x0170 (n0x1e09-n0x1e0c)  +
	0x07839e0c, // c0x0171 (n0x1e0c-n0x1e0e)  +
	0x07845e0e, // c0x0172 (n0x1e0e-n0x1e11)  +
	0x07851e11, // c0x0173 (n0x1e11-n0x1e14)  +
	0x0785de14, // c0x0174 (n0x1e14-n0x1e17)  +
	0x07869e17, // c0x0175 (n0x1e17-n0x1e1a)  +
	0x07875e1a, // c0x0176 (n0x1e1a-n0x1e1d)  +
	0x07881e1d, // c0x0177 (n0x1e1d-n0x1e20)  +
	0x0788de20, // c0x0178 (n0x1e20-n0x1e23)  +
	0x07899e23, // c0x0179 (n0x1e23-n0x1e26)  +
	0x078a5e26, // c0x017a (n0x1e26-n0x1e29)  +
	0x078b1e29, // c0x017b (n0x1e29-n0x1e2c)  +
	0x078bde2c, // c0x017c (n0x1e2c-n0x1e2f)  +
	0x078c9e2f, // c0x017d (n0x1e2f-n0x1e32)  +
	0x078d5e32, // c0x017e (n0x1e32-n0x1e35)  +
	0x078dde35, // c0x017f (n0x1e35-n0x1e37)  +
	0x078e9e37, // c0x0180 (n0x1e37-n0x1e3a)  +
	0x078f5e3a, // c0x0181 (n0x1e3a-n0x1e3d)  +
	0x07901e3d, // c0x0182 (n0x1e3d-n0x1e40)  +
	0x0790de40, // c0x0183 (n0x1e40-n0x1e43)  +
	0x07919e43, // c0x0184 (n0x1e43-n0x1e46)  +
	0x07925e46, // c0x0185 (n0x1e46-n0x1e49)  +
	0x07931e49, // c0x0186 (n0x1e49-n0x1e4c)  +
	0x0793de4c, // c0x0187 (n0x1e4c-n0x1e4f)  +
	0x07941e4f, // c0x0188 (n0x1e4f-n0x1e50)  +
	0x0794de50, // c0x0189 (n0x1e50-n0x1e53)  +
	0x07965e53, // c0x018a (n0x1e53-n0x1e59)  +
	0x07969e59, // c0x018b (n0x1e59-n0x1e5a)  +
	0x07979e5a, // c0x018c (n0x1e5a-n0x1e5e)  +
	0x07991e5e, // c0x018d (n0x1e5e-n0x1e64)  +
	0x079d5e64, // c0x018e (n0x1e64-n0x1e75)  +
	0x079e9e75, // c0x018f (n0x1e75-n0x1e7a)  +
	0x07a1de7a, // c0x0190 (n0x1e7a-n0x1e87)  +
	0x07a2de87, // c0x0191 (n0x1e87-n0x1e8b)  +
	0x07a49e8b, // c0x0192 (n0x1e8b-n0x1e92)  +
	0x07a61e92, // c0x0193 (n0x1e92-n0x1e98)  +
	0x27aa5e98, // c0x0194 (n0x1e98-n0x1ea9)  o
	0x07aa9ea9, // c0x0195 (n0x1ea9-n0x1eaa)  +
}

// max children 405 (capacity 511)
// max text offset 26956 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 7850 (capacity 16383)
// max lo 7849 (capacity 16383)
