/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * ALSA SoC Audio driver for CS4234 codec
 *
 * Copyright (C) 2020 Cirrus Logic, Inc. and
 *                    Cirrus Logic International Semiconductor Ltd.
 */

#ifndef CS4234_H
#define CS4234_H

#define CS4234_DEVID_AB			0x01
#define CS4234_DEVID_CD			0x02
#define CS4234_DEVID_EF			0x03
#define CS4234_REVID			0x05

#define CS4234_CLOCK_SP			0x06
#define CS4234_BASE_RATE_MASK		0xC0
#define CS4234_BASE_RATE_SHIFT		6
#define CS4234_SPEED_MODE_MASK		0x30
#define CS4234_SPEED_MODE_SHIFT		4
#define CS4234_MCLK_RATE_MASK		0x0E
#define CS4234_MCLK_RATE_SHIFT		1

#define CS4234_SAMPLE_WIDTH		0x07
#define CS4234_SDOUTX_SW_MASK		0xC0
#define CS4234_SDOUTX_SW_SHIFT		6
#define CS4234_INPUT_SW_MASK		0x30
#define CS4234_INPUT_SW_SHIFT		4
#define CS4234_LOW_LAT_SW_MASK		0x0C
#define CS4234_LOW_LAT_SW_SHIFT		2
#define CS4234_DAC5_SW_MASK		0x03
#define CS4234_DAC5_SW_SHIFT		0

#define CS4234_SP_CTRL			0x08
#define CS4234_INVT_SCLK_MASK		0x80
#define CS4234_INVT_SCLK_SHIFT		7
#define CS4234_DAC5_SRC_MASK		0x70
#define CS4234_DAC5_SRC_SHIFT		4
#define CS4234_SP_FORMAT_MASK		0x0C
#define CS4234_SP_FORMAT_SHIFT		2
#define CS4234_SDO_CHAIN_MASK		0x02
#define CS4234_SDO_CHAIN_SHIFT		1
#define CS4234_MST_SLV_MASK		0x01
#define CS4234_MST_SLV_SHIFT		0

#define CS4234_SP_DATA_SEL		0x09
#define CS4234_DAC14_SRC_MASK		0x38
#define CS4234_DAC14_SRC_SHIFT		3
#define CS4234_LL_SRC_MASK		0x07
#define CS4234_LL_SRC_SHIFT		0

#define CS4234_SDIN1_MASK1		0x0A
#define CS4234_SDIN1_MASK2		0x0B
#define CS4234_SDIN2_MASK1		0x0C
#define CS4234_SDIN2_MASK2		0x0D

#define CS4234_TPS_CTRL			0x0E
#define CS4234_TPS_MODE_MASK		0x80
#define CS4234_TPS_MODE_SHIFT		7
#define CS4234_TPS_OFST_MASK		0x70
#define CS4234_TPS_OFST_SHIFT		4
#define CS4234_GRP_DELAY_MASK		0x0F
#define CS4234_GRP_DELAY_SHIFT		0

#define CS4234_ADC_CTRL1		0x0F
#define CS4234_VA_SEL_MASK		0x20
#define CS4234_VA_SEL_SHIFT		5
#define CS4234_ENA_HPF_MASK		0x10
#define CS4234_ENA_HPF_SHIFT		4
#define CS4234_INV_ADC_MASK		0x0F
#define CS4234_INV_ADC4_MASK		0x08
#define CS4234_INV_ADC4_SHIFT		3
#define CS4234_INV_ADC3_MASK		0x04
#define CS4234_INV_ADC3_SHIFT		2
#define CS4234_INV_ADC2_MASK		0x02
#define CS4234_INV_ADC2_SHIFT		1
#define CS4234_INV_ADC1_MASK		0x01
#define CS4234_INV_ADC1_SHIFT		0

#define CS4234_ADC_CTRL2		0x10
#define CS4234_MUTE_ADC4_MASK		0x80
#define CS4234_MUTE_ADC4_SHIFT		7
#define CS4234_MUTE_ADC3_MASK		0x40
#define CS4234_MUTE_ADC3_SHIFT		6
#define CS4234_MUTE_ADC2_MASK		0x20
#define CS4234_MUTE_ADC2_SHIFT		5
#define CS4234_MUTE_ADC1_MASK		0x10
#define CS4234_MUTE_ADC1_SHIFT		4
#define CS4234_PDN_ADC4_MASK		0x08
#define CS4234_PDN_ADC4_SHIFT		3
#define CS4234_PDN_ADC3_MASK		0x04
#define CS4234_PDN_ADC3_SHIFT		2
#define CS4234_PDN_ADC2_MASK		0x02
#define CS4234_PDN_ADC2_SHIFT		1
#define CS4234_PDN_ADC1_MASK		0x01
#define CS4234_PDN_ADC1_SHIFT		0

#define CS4234_LOW_LAT_CTRL1		0x11
#define CS4234_LL_NG_MASK		0xE0
#define CS4234_LL_NG_SHIFT		5
#define CS4234_INV_LL_MASK		0x0F
#define CS4234_INV_LL4_MASK		0x08
#define CS4234_INV_LL4_SHIFT		3
#define CS4234_INV_LL3_MASK		0x04
#define CS4234_INV_LL3_SHIFT		2
#define CS4234_INV_LL2_MASK		0x02
#define CS4234_INV_LL2_SHIFT		1
#define CS4234_INV_LL1_MASK		0x01
#define CS4234_INV_LL1_SHIFT		0

#define CS4234_DAC_CTRL1		0x12
#define CS4234_DAC14_NG_MASK		0xE0
#define CS4234_DAC14_NG_SHIFT		5
#define CS4234_DAC14_DE_MASK		0x10
#define CS4234_DAC14_DE_SHIFT		4
#define CS4234_DAC5_DE_MASK		0x08
#define CS4234_DAC5_DE_SHIFT		3
#define CS4234_DAC5_MVC_MASK		0x04
#define CS4234_DAC5_MVC_SHIFT		2
#define CS4234_DAC5_CFG_FLTR_MASK	0x03
#define CS4234_DAC5_CFG_FLTR_SHIFT	0

#define CS4234_DAC_CTRL2		0x13
#define CS4234_DAC5_NG_MASK		0xE0
#define CS4234_DAC5_NG_SHIFT		5
#define CS4234_INV_DAC_MASK		0x1F
#define CS4234_INV_DAC5_MASK		0x10
#define CS4234_INV_DAC5_SHIFT		4
#define CS4234_INV_DAC4_MASK		0x08
#define CS4234_INV_DAC4_SHIFT		3
#define CS4234_INV_DAC3_MASK		0x04
#define CS4234_INV_DAC3_SHIFT		2
#define CS4234_INV_DAC2_MASK		0x02
#define CS4234_INV_DAC2_SHIFT		1
#define CS4234_INV_DAC1_MASK		0x01
#define CS4234_INV_DAC1_SHIFT		0

#define CS4234_DAC_CTRL3		0x14
#define CS4234_DAC5_ATT_MASK		0x80
#define CS4234_DAC5_ATT_SHIFT		7
#define CS4234_DAC14_ATT_MASK		0x40
#define CS4234_DAC14_ATT_SHIFT		6
#define CS4234_MUTE_LL_MASK		0x20
#define CS4234_MUTE_LL_SHIFT		5
#define CS4234_MUTE_DAC5_MASK		0x10
#define CS4234_MUTE_DAC5_SHIFT		4
#define CS4234_MUTE_DAC4_MASK		0x08
#define CS4234_MUTE_DAC4_SHIFT		3
#define CS4234_MUTE_DAC3_MASK		0x04
#define CS4234_MUTE_DAC3_SHIFT		2
#define CS4234_MUTE_DAC2_MASK		0x02
#define CS4234_MUTE_DAC2_SHIFT		1
#define CS4234_MUTE_DAC1_MASK		0x01
#define CS4234_MUTE_DAC1_SHIFT		0

#define CS4234_DAC_CTRL4		0x15
#define CS4234_VQ_RAMP_MASK		0x80
#define CS4234_VQ_RAMP_SHIFT		7
#define CS4234_TPS_GAIN_MASK		0x40
#define CS4234_TPS_GAIN_SHIFT		6
#define CS4234_PDN_DAC5_MASK		0x10
#define CS4234_PDN_DAC5_SHIFT		4
#define CS4234_PDN_DAC4_MASK		0x08
#define CS4234_PDN_DAC4_SHIFT		3
#define CS4234_PDN_DAC3_MASK		0x04
#define CS4234_PDN_DAC3_SHIFT		2
#define CS4234_PDN_DAC2_MASK		0x02
#define CS4234_PDN_DAC2_SHIFT		1
#define CS4234_PDN_DAC1_MASK		0x01
#define CS4234_PDN_DAC1_SHIFT		0

#define CS4234_VOLUME_MODE		0x16
#define CS4234_MUTE_DELAY_MASK		0xC0
#define CS4234_MUTE_DELAY_SHIFT		6
#define CS4234_MIN_DELAY_MASK		0x38
#define CS4234_MIN_DELAY_SHIFT		3
#define CS4234_MAX_DELAY_MASK		0x07
#define CS4234_MAX_DELAY_SHIFT		0

#define CS4234_MASTER_VOL		0x17
#define CS4234_DAC1_VOL			0x18
#define CS4234_DAC2_VOL			0x19
#define CS4234_DAC3_VOL			0x1A
#define CS4234_DAC4_VOL			0x1B
#define CS4234_DAC5_VOL			0x1C

#define CS4234_INT_CTRL			0x1E
#define CS4234_INT_MODE_MASK		0x80
#define CS4234_INT_MODE_SHIFT		7
#define CS4234_INT_PIN_MASK		0x60
#define CS4234_INT_PIN_SHIFT		5

#define CS4234_INT_MASK1		0x1F
#define CS4234_MSK_TST_MODE_MASK	0x80
#define CS4234_MSK_TST_MODE_ERR_SHIFT	7
#define CS4234_MSK_SP_ERR_MASK		0x40
#define CS4234_MSK_SP_ERR_SHIFT		6
#define CS4234_MSK_CLK_ERR_MASK		0x08
#define CS4234_MSK_CLK_ERR_SHIFT	5
#define CS4234_MSK_ADC4_OVFL_MASK	0x08
#define CS4234_MSK_ADC4_OVFL_SHIFT	3
#define CS4234_MSK_ADC3_OVFL_MASK	0x04
#define CS4234_MSK_ADC3_OVFL_SHIFT	2
#define CS4234_MSK_ADC2_OVFL_MASK	0x02
#define CS4234_MSK_ADC2_OVFL_SHIFT	1
#define CS4234_MSK_ADC1_OVFL_MASK	0x01
#define CS4234_MSK_ADC1_OVFL_SHIFT	0

#define CS4234_INT_MASK2		0x20
#define CS4234_MSK_DAC5_CLIP_MASK	0x10
#define CS4234_MSK_DAC5_CLIP_SHIFT	4
#define CS4234_MSK_DAC4_CLIP_MASK	0x08
#define CS4234_MSK_DAC4_CLIP_SHIFT	3
#define CS4234_MSK_DAC3_CLIP_MASK	0x04
#define CS4234_MSK_DAC3_CLIP_SHIFT	2
#define CS4234_MSK_DAC2_CLIP_MASK	0x02
#define CS4234_MSK_DAC2_CLIP_SHIFT	1
#define CS4234_MSK_DAC1_CLIP_MASK	0x01
#define CS4234_MSK_DAC1_CLIP_SHIFT	0

#define CS4234_INT_NOTIFY1		0x21
#define CS4234_TST_MODE_MASK		0x80
#define CS4234_TST_MODE_SHIFT		7
#define CS4234_SP_ERR_MASK		0x40
#define CS4234_SP_ERR_SHIFT		6
#define CS4234_CLK_MOD_ERR_MASK		0x08
#define CS4234_CLK_MOD_ERR_SHIFT	5
#define CS4234_ADC4_OVFL_MASK		0x08
#define CS4234_ADC4_OVFL_SHIFT		3
#define CS4234_ADC3_OVFL_MASK		0x04
#define CS4234_ADC3_OVFL_SHIFT		2
#define CS4234_ADC2_OVFL_MASK		0x02
#define CS4234_ADC2_OVFL_SHIFT		1
#define CS4234_ADC1_OVFL_MASK		0x01
#define CS4234_ADC1_OVFL_SHIFT		0

#define CS4234_INT_NOTIFY2		0x22
#define CS4234_DAC5_CLIP_MASK		0x10
#define CS4234_DAC5_CLIP_SHIFT		4
#define CS4234_DAC4_CLIP_MASK		0x08
#define CS4234_DAC4_CLIP_SHIFT		3
#define CS4234_DAC3_CLIP_MASK		0x04
#define CS4234_DAC3_CLIP_SHIFT		2
#define CS4234_DAC2_CLIP_MASK		0x02
#define CS4234_DAC2_CLIP_SHIFT		1
#define CS4234_DAC1_CLIP_MASK		0x01
#define CS4234_DAC1_CLIP_SHIFT		0

#define CS4234_MAX_REGISTER		CS4234_INT_NOTIFY2

#define CS4234_SUPPORTED_ID		0x423400
#define CS4234_BOOT_TIME_US		3000
#define CS4234_HOLD_RESET_TIME_US	1000
#define CS4234_VQ_CHARGE_MS		1000

#define CS4234_PCM_RATES	(SNDRV_PCM_RATE_32000 | SNDRV_PCM_RATE_44100 | \
				 SNDRV_PCM_RATE_48000 | SNDRV_PCM_RATE_64000 | \
				 SNDRV_PCM_RATE_88200 | SNDRV_PCM_RATE_96000)

#define CS4234_FORMATS (SNDRV_PCM_FMTBIT_S16_LE | SNDRV_PCM_FMTBIT_S18_3LE | \
			SNDRV_PCM_FMTBIT_S20_LE | SNDRV_PCM_FMTBIT_S24_LE | \
			SNDRV_PCM_FMTBIT_S24_3LE)

enum cs4234_supplies {
	CS4234_SUPPLY_VA = 0,
	CS4234_SUPPLY_VL,
};

enum cs4234_va_sel {
	CS4234_3V3 = 0,
	CS4234_5V,
};

enum cs4234_sp_format {
	CS4234_LEFT_J = 0,
	CS4234_I2S,
	CS4234_TDM,
};

enum cs4234_base_rate_advisory {
	CS4234_48K = 0,
	CS4234_44K1,
	CS4234_32K,
};

#endif
