; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -inline -enable-noalias-to-md-conversion -S < %s | FileCheck %s --check-prefixes=CHECK,NO_ASSUME
; RUN: opt -inline -enable-noalias-to-md-conversion --enable-knowledge-retention -S < %s | FileCheck %s --check-prefixes=CHECK,USE_ASSUME

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @hello(float* noalias nocapture %a, float* noalias nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@hello
; CHECK-SAME: (float* noalias nocapture [[A:%.*]], float* noalias nocapture readonly [[C:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], float* [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
; ASSUME-LABEL: @hello(
; ASSUME-NEXT:  entry:
; ASSUME-NEXT:    [[TMP0:%.*]] = load float, float* [[C:%.*]], align 4
; ASSUME-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A:%.*]], i64 5
; ASSUME-NEXT:    store float [[TMP0]], float* [[ARRAYIDX]], align 4
; ASSUME-NEXT:    ret void
entry:
  %0 = load float, float* %c, align 4
  %arrayidx = getelementptr inbounds float, float* %a, i64 5
  store float %0, float* %arrayidx, align 4
  ret void
}

define void @foo(float* noalias nocapture %a, float* noalias nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: (float* noalias nocapture [[A:%.*]], float* noalias nocapture readonly [[C:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[C]], align 4, !alias.scope !0, !noalias !3
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds float, float* [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], float* [[ARRAYIDX_I]], align 4, !alias.scope !3, !noalias !0
; CHECK-NEXT:    [[TMP1:%.*]] = load float, float* [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A]], i64 7
; CHECK-NEXT:    store float [[TMP1]], float* [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
; ASSUME-LABEL: @foo(
; ASSUME-NEXT:  entry:
; ASSUME-NEXT:    call void @llvm.assume(i1 true) [ "noalias"(float* [[A:%.*]]), "noalias"(float* [[C:%.*]]) ]
; ASSUME-NEXT:    [[TMP0:%.*]] = load float, float* [[C]], align 4, !alias.scope !0, !noalias !3
; ASSUME-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds float, float* [[A]], i64 5
; ASSUME-NEXT:    store float [[TMP0]], float* [[ARRAYIDX_I]], align 4, !alias.scope !3, !noalias !0
; ASSUME-NEXT:    [[TMP1:%.*]] = load float, float* [[C]], align 4
; ASSUME-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A]], i64 7
; ASSUME-NEXT:    store float [[TMP1]], float* [[ARRAYIDX]], align 4
; ASSUME-NEXT:    ret void
entry:
  tail call void @hello(float* %a, float* %c)
  %0 = load float, float* %c, align 4
  %arrayidx = getelementptr inbounds float, float* %a, i64 7
  store float %0, float* %arrayidx, align 4
  ret void
}

define void @hello2(float* noalias nocapture %a, float* noalias nocapture %b, float* nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@hello2
; CHECK-SAME: (float* noalias nocapture [[A:%.*]], float* noalias nocapture [[B:%.*]], float* nocapture readonly [[C:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A]], i64 6
; CHECK-NEXT:    store float [[TMP0]], float* [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, float* [[B]], i64 8
; CHECK-NEXT:    store float [[TMP0]], float* [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = load float, float* %c, align 4
  %arrayidx = getelementptr inbounds float, float* %a, i64 6
  store float %0, float* %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds float, float* %b, i64 8
  store float %0, float* %arrayidx1, align 4
  ret void
}

; Check that when hello() is inlined into foo(), and then foo() is inlined into
; foo2(), the noalias scopes are properly concatenated.
define void @foo2(float* nocapture %a, float* nocapture %b, float* nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@foo2
; CHECK-SAME: (float* nocapture [[A:%.*]], float* nocapture [[B:%.*]], float* nocapture readonly [[C:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, float* [[C]], align 4, !alias.scope !5, !noalias !10
; CHECK-NEXT:    [[ARRAYIDX_I_I:%.*]] = getelementptr inbounds float, float* [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], float* [[ARRAYIDX_I_I]], align 4, !alias.scope !10, !noalias !5
; CHECK-NEXT:    [[TMP1:%.*]] = load float, float* [[C]], align 4, !alias.scope !13, !noalias !14
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds float, float* [[A]], i64 7
; CHECK-NEXT:    store float [[TMP1]], float* [[ARRAYIDX_I]], align 4, !alias.scope !14, !noalias !13
; CHECK-NEXT:    [[TMP2:%.*]] = load float, float* [[C]], align 4, !noalias !15
; CHECK-NEXT:    [[ARRAYIDX_I1:%.*]] = getelementptr inbounds float, float* [[A]], i64 6
; CHECK-NEXT:    store float [[TMP2]], float* [[ARRAYIDX_I1]], align 4, !alias.scope !19, !noalias !20
; CHECK-NEXT:    [[ARRAYIDX1_I:%.*]] = getelementptr inbounds float, float* [[B]], i64 8
; CHECK-NEXT:    store float [[TMP2]], float* [[ARRAYIDX1_I]], align 4, !alias.scope !20, !noalias !19
; CHECK-NEXT:    [[TMP3:%.*]] = load float, float* [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, float* [[A]], i64 7
; CHECK-NEXT:    store float [[TMP3]], float* [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  tail call void @foo(float* %a, float* %c)
  tail call void @hello2(float* %a, float* %b, float* %c)
  %0 = load float, float* %c, align 4
  %arrayidx = getelementptr inbounds float, float* %a, i64 7
  store float %0, float* %arrayidx, align 4
  ret void
}

; NO_ASSUME: !0 = !{!1}
; NO_ASSUME: !1 = distinct !{!1, !2, !"hello: %c"}
; NO_ASSUME: !2 = distinct !{!2, !"hello"}
; NO_ASSUME: !3 = !{!4}
; NO_ASSUME: !4 = distinct !{!4, !2, !"hello: %a"}
; NO_ASSUME: !5 = !{!6, !8}
; NO_ASSUME: !6 = distinct !{!6, !7, !"hello: %c"}
; NO_ASSUME: !7 = distinct !{!7, !"hello"}
; NO_ASSUME: !8 = distinct !{!8, !9, !"foo: %c"}
; NO_ASSUME: !9 = distinct !{!9, !"foo"}
; NO_ASSUME: !10 = !{!11, !12}
; NO_ASSUME: !11 = distinct !{!11, !7, !"hello: %a"}
; NO_ASSUME: !12 = distinct !{!12, !9, !"foo: %a"}
; NO_ASSUME: !13 = !{!8}
; NO_ASSUME: !14 = !{!12}
; NO_ASSUME: !15 = !{!16, !18}
; NO_ASSUME: !16 = distinct !{!16, !17, !"hello2: %a"}
; NO_ASSUME: !17 = distinct !{!17, !"hello2"}
; NO_ASSUME: !18 = distinct !{!18, !17, !"hello2: %b"}
; NO_ASSUME: !19 = !{!16}
; NO_ASSUME: !20 = !{!18}

attributes #0 = { nounwind uwtable }

