.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XSendEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSendEvent, XDisplayMotionBufferSize, XGetMotionEvents, XTimeCoord \- send events and pointer motion history structure
.SH SYNTAX
.HP
Status XSendEvent\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, Bool
\fIpropagate\fP\^, long \fIevent_mask\fP\^, XEvent *\fIevent_send\fP\^); 
.HP
unsigned long XDisplayMotionBufferSize\^(\^Display *\fIdisplay\fP\^); 
.HP
XTimeCoord *XGetMotionEvents\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
Time \fIstart\fP\^, Time \fIstop\fP\^, int *\fInevents_return\fP\^); 
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies the event mask.
.IP \fIevent_send\fP 1i
Specifies the event that is to be sent.
.IP \fInevents_return\fP 1i
Returns the number of events from the motion history buffer.
.IP \fIpropagate\fP 1i
Specifies a Boolean value.
.IP \fIstart\fP 1i
.br
.ns
.IP \fIstop\fP 1i
Specify the time interval in which the events are returned from the motion
history buffer.
You can pass a timestamp or
.ZN CurrentTime .
.ds Wi the window the event is to be sent to,
.ZN PointerWindow ,
or
.ZN InputFocus .
.IP \fIw\fP 1i
Specifies the window \*(Wi.
.SH DESCRIPTION
The
.ZN XSendEvent
function identifies the destination window, 
determines which clients should receive the specified events, 
and ignores any active grabs.
This function requires you to pass an event mask.
For a discussion of the valid event mask names,
see section 10.3.
This function uses the w argument to identify the destination window as follows:
.IP \(bu 5
If w is
.ZN PointerWindow ,
the destination window is the window that contains the pointer.
.IP \(bu 5
If w is
.ZN InputFocus 
and if the focus window contains the pointer, 
the destination window is the window that contains the pointer; 
otherwise, the destination window is the focus window.
.LP
To determine which clients should receive the specified events,
.ZN XSendEvent
uses the propagate argument as follows:
.IP \(bu 5
If event_mask is the empty set,
the event is sent to the client that created the destination window.
If that client no longer exists,
no event is sent.
.IP \(bu 5
If propagate is 
.ZN False ,
the event is sent to every client selecting on destination any of the event
types in the event_mask argument.
.IP \(bu 5
If propagate is 
.ZN True 
and no clients have selected on destination any of
the event types in event-mask, the destination is replaced with the
closest ancestor of destination for which some client has selected a
type in event-mask and for which no intervening window has that type in its
do-not-propagate-mask. 
If no such window exists or if the window is
an ancestor of the focus window and 
.ZN InputFocus 
was originally specified
as the destination, the event is not sent to any clients.
Otherwise, the event is reported to every client selecting on the final
destination any of the types specified in event_mask.
.LP
The event in the
.ZN XEvent
structure must be one of the core events or one of the events
defined by an extension (or a 
.ZN BadValue
error results) so that the X server can correctly byte-swap 
the contents as necessary.  
The contents of the event are
otherwise unaltered and unchecked by the X server except to force send_event to
.ZN True
in the forwarded event and to set the serial number in the event correctly;
therefore these fields
and the display field are ignored by
.ZN XSendEvent .
.LP
.ZN XSendEvent
returns zero if the conversion to wire protocol format failed
and returns nonzero otherwise.
.ZN XSendEvent
can generate
.ZN BadValue 
and
.ZN BadWindow 
errors.
.LP
The server may retain the recent history of the pointer motion
and do so to a finer granularity than is reported by
.ZN MotionNotify
events.
The
.ZN XGetMotionEvents
function makes this history available.
.LP
The
.ZN XGetMotionEvents
function returns all events in the motion history buffer that fall between the
specified start and stop times, inclusive, and that have coordinates
that lie within the specified window (including its borders) at its present
placement.
If the server does not support motion history, 
if the start time is later than the stop time,
or if the start time is in the future, 
no events are returned;
.ZN XGetMotionEvents
returns NULL.
If the stop time is in the future, it is equivalent to specifying
.ZN CurrentTime .
.ZN XGetMotionEvents
can generate a
.ZN BadWindow 
error.
.SH STRUCTURES
The
.ZN XTimeCoord
structure contains:
.LP
.Ds 0
typedef struct {
        Time time;
        short x, y;
} XTimeCoord;
.De
.LP
The time member is set to the time, in milliseconds. 
The x and y members are set to the coordinates of the pointer and
are reported relative to the origin
of the specified window.
.SH DIAGNOSTICS
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAnyEvent(__libmansuffix__),
XIfEvent(__libmansuffix__),
XNextEvent(__libmansuffix__),
XPutBackEvent(__libmansuffix__)
.br
\fI\*(xL\fP
