/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Map;
import org.junit.contrib.truth.Truth;

@GwtCompatible
public class MultimapRemoveAllTester<K, V>
extends AbstractMultimapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllAbsentKey() {
        Truth.ASSERT.that(this.multimap().removeAll(this.sampleKeys().e3)).isEmpty();
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPresentKey() {
        Truth.ASSERT.that(this.multimap().removeAll(this.sampleKeys().e0)).hasContentsInOrder(new Object[]{this.sampleValues().e0});
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPropagatesToGet() {
        Collection getResult = this.multimap().get(this.sampleKeys().e0);
        this.multimap().removeAll(this.sampleKeys().e0);
        Truth.ASSERT.that(getResult).isEmpty();
        this.expectMissing((Map.Entry)this.samples.e0);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllMultipleValues() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e1), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e2));
        Truth.ASSERT.that(this.multimap().removeAll(this.sampleKeys().e0)).hasContentsAnyOrder(new Object[]{this.sampleValues().e0, this.sampleValues().e1, this.sampleValues().e2});
        MultimapRemoveAllTester.assertTrue((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testRemoveAllNullKeyPresent() {
        this.initMultimapWithNullKey();
        Truth.ASSERT.that(this.multimap().removeAll(null)).hasContentsInOrder(new Object[]{this.getValueForNullKey()});
        this.expectMissing(Helpers.mapEntry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_QUERIES})
    public void testRemoveAllNullKeyAbsent() {
        Truth.ASSERT.that(this.multimap().removeAll(null)).isEmpty();
        this.expectUnchanged();
    }
}

