/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2009 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ArrayMath.java,v $
 * $Revision: 1.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

package com.sun.star.NLPSolver;

/**
 *
 * @author Andreas Schneider <Andreas.Schneider@Sun.COM>
 */
public class ArrayMath {

    public static double[] createVector(int size, double initValue) {
        double[] result = new double[size];
        setVector(result, initValue);
        return result;
    }

    /**
     * Initialize a double vector with a specifig value for each component.
     * @param vector The vector to be modified.
     * @param value The value to be written into the vectors components.
     */
    public static void setVector(double[] vector, double value) {
        for (int i = 0; i < vector.length; i++)
            vector[i] = value;
    }

    /**
     * Adds the values of one vector to the other.
     * @param vector1 The vector to be written to.
     * @param vector2 The vector which is added to vector1.
     */
    public static void addToVector(double[] vector1, double[] vector2) {
        for (int i = 0; i < vector1.length; i++)
            vector1[i] += vector2[i];
    }

    public static double[] addVectors(double[] vector1, double[] vector2) {
        double[] result = new double[vector1.length];
        for (int i = 0; i < vector1.length; i++)
            result[i] = vector1[i] + vector2[i];
        return result;
    }

    public static void subtractFromVector(double[] vector1, double[] vector2) {
        for (int i = 0; i < vector1.length; i++)
            vector1[i] -= vector2[i];
    }

    public static double[] subtractVectors(double[] vector1, double[] vector2) {
        double[] result = new double[vector1.length];
        for (int i = 0; i < vector1.length; i++)
            result[i] = vector1[i] - vector2[i];
        return result;
    }

    /**
     * Devides each component of vector by value.
     * @param vector The target vector.
     * @param value The value the components are divided by.
     */
    public static void divideVectorBy(double[] vector, double value) {
        for (int i = 0; i < vector.length; i++)
            vector[i] /= value;
    }

    public static void multiplyVectorBy(double[] vector, double value) {
        for (int i = 0; i < vector.length; i++)
            vector[i] *= value;
    }

    public static double getDistance(double[] vector1, double[] vector2) {
        double result = 0.0;
        for (int i = 0; i < vector1.length; i++)
            result += Math.pow(vector2[i] - vector1[i], 2.0);
        result = Math.sqrt(result);
        return result;
    }

}
