#ifndef INCLUDE_INPUTMANAGER_H
#define INCLUDE_INPUTMANAGER_H
/* ----------------------------------------------------------------------------
 * input_manager.h
 * prototypes and definitions for input_manager.c.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <glib.h>
#include <pbbtaglist.h>

typedef void (*inputqueue_t)();

#define MAXINPUTS   16
#define TIMERCOUNT  3     /* ATTENTION: keep an eye on the init routine */
#define EVDEVCOUNT	32

/* queue identifier */
#define KBDQUEUE	0      /* keyboard events */
#define MOUSEQUEUE	1      /* mouse events */
#define T100QUEUE	2      /* timer tic every 100ms */
#define T1000QUEUE	3      /* timer tic every second */
#define QUERYQUEUE	4      /* ask for properties */
#define CONFIGQUEUE	5      /* set properties */
#define SECUREQUEUE 6      /* called if user is idle */

#define QUEUECOUNT	7

#define MOD_NONE			0
#define MOD_SHIFT			1     /* 001 */
#define MOD_ALT				2     /* 010 */
#define MOD_SHIFTALT		3
#define MOD_CTRL			4     /* 100 */
#define MOD_SHIFTCTRL		5
#define MOD_ALTCTRL			6
#define MOD_SHIFTALTCTRL	7

#define BITS_PER_LONG (sizeof(long) * 8)
#define NBITS(x) ((((x)-1)/BITS_PER_LONG)+1)
#define OFF(x) ((x)%BITS_PER_LONG)
#define LONG(x) ((x)/BITS_PER_LONG)
#define test_bit(bit, array) ((array[LONG(bit)] >> OFF(bit)) & 1)

typedef struct inputsource {
	GIOChannel *io;
	guint watch;
	int (*handler)(int fd, gpointer user_data);
	gpointer user_data;
} InputSource;

/* public prototypes */
int inputmanager_init ();
void cbFreeInputSource (gpointer data, gpointer user_data);
void inputmanager_exit ();
int track_modifier(unsigned short code, unsigned int value);
int get_modifier();

gint cbEventDevices (gconstpointer a, gconstpointer b);
void scanEventDevices ();
void destroyInputSource (gpointer data);
gboolean handleInputSource (GIOChannel *io, GIOCondition condition, gpointer data);
InputSource *addInputSource (int fd, int (*handler)(), gpointer user_data, gboolean close_on_exit);
int register_function (int queueid, void (*func)());
long process_queue_single (int queueid, long tag, long data);
int process_queue (int queueid, struct tagitem *taglist);
void ipc_handler ();
gboolean input_event_handler (int fd, gpointer user_data);
/*gboolean mice_handler (int fd, gpointer user_data);*/
gboolean cb_timer100 (gpointer data);
gboolean cb_timer1000 (gpointer data);

#endif    /* INCLUDE_INPUTMANAGER_H */
