%% The contents of this file are subject to the Mozilla Public License
%% Version 1.1 (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License
%% at http://www.mozilla.org/MPL/
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and
%% limitations under the License.
%%
%% The Original Code is RabbitMQ.
%%
%% The Initial Developer of the Original Code is Pivotal Software, Inc.
%% Copyright (c) 2018-2019 Pivotal Software, Inc.  All rights reserved.
%%

-record(formatted_block, {lines = [] :: [stdout_formatter:formatted_line()],
                          props = #{width => 0,
                                    height => 0}
                          :: stdout_formatter:formatted_block_props()}).

-record(formatted_line, {content = "" :: unicode:chardata(),
                         props = #{width => 0,
                                   reformat_ok => false}
                         :: stdout_formatter:formatted_line_props()}).

-record(paragraph, {content :: term(),
                    props = #{} :: stdout_formatter:paragraph_props()}).

-record(cell, {content = #formatted_block{} :: stdout_formatter:formattable(),
               props = #{} :: stdout_formatter:cell_props()}).

-record(row, {cells = [] :: [stdout_formatter:formattable() | #cell{}],
              props = #{} :: stdout_formatter:row_props()}).

-record(table, {rows = [] :: [[stdout_formatter:formattable() | #cell{}] |
                              #row{}],
                props = #{} :: stdout_formatter:table_props()}).
