#!/bin/sh -e

list="$(sed -r -n '/^strace_SOURCES[[:space:]]*=/,/^[[:space:]]*# end of strace_SOURCES/ s/^[[:space:]]*([[:alnum:]][^.]*\.c)[[:space:]]*\\$/\1/p' Makefile.am |
	xargs -r grep -Elx '#[[:space:]]*include[[:space:]]+MPERS_DEFS' |
	tr '\n' ' ')"

cat > mpers.am <<EOF
# Generated by $0; do not edit.
mpers_source_files = $list
EOF

sed -r -n 's/^#[[:space:]]*include[[:space:]]*"xlat\/([a-z][a-z_0-9]*)\.h".*/extern const struct xlat \1[];/p' \
	$list > mpers_xlat.h
