# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Utility classes used for testing main on linux."""

from twisted.internet import defer

from ubuntu_sso import main
from ubuntuone.devtools.testcases.dbus import DBusTestCase


class BaseTestCase(DBusTestCase):
    """The base test case with platform specific support."""

    @defer.inlineCallbacks
    def setUp(self):
        yield super(BaseTestCase, self).setUp()

        self.sso_service = main.UbuntuSSOService()
        yield self.sso_service.start()
        self.addCleanup(self.sso_service.shutdown)

        self.sso_client = yield main.get_sso_client()
        self.addCleanup(self.sso_client.disconnect)
