/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICCOI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateCommentINI(char *comment)

	Put a comment into the INI file

ob(ject): cfgCreateCommentINI
su(bsystem): inifile/1
sh(ort description):  Append a comment to the INI file
lo(ng description): Append a comment to the INI file currently opened for writing.\par
	If a value has been appended previously, the first line is appended
	to the value, unless the first character of the comment is \tok{'\n'}.
	The comment sign (the semicolon) and the data are delimited by one space.\newline
	If the first character of the comment is \tok{'\n'}, it is ignored (see above).\newline
	One semicolon and one space are prepended to each line as comment character, meaning the
	comment \tok{"Line 1\nLine 2"} is broken into two lines of output:\newline
	\tok{; Line 1}\newline
	\tok{; Line 2}\newline
	One \tok{'\n'} character is automatically appended to the whole comment,
	meaning \tok{"Line\n"} actually results into two lines of output:\newline
	\tok{; Line}\newline
	\tok{; }\newline
re(lated to):
fi(le): cfgiccoi.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICCOI.C 1.4 1999/12/13 02:22:17 ska Exp ska $";
#endif

int cfgCreateCommentINI(const char * const comment)
{	const char *p;
	int ch;

	DBG_ENTER("cfgCreateCommentINI", Suppl_inifile1)
	DBG_ARGUMENTS( ("cmt=\"%s\"", comment) )

	chkHeap
	if(!comment || !*comment)	DBG_RETURN_I( CFG_ERR_NONE)
	if(!cfgi_ini)	DBG_RETURN_I( CFG_ERR_NOTOPEN)

	chkHeap
	if(*(p = comment) == '\n') {
		/* Don't start the comment at the tail of a value */
		CFGI_NXTLINE
		++p;
	}
	else if(!cfgi_nlwritten) {
		/* append the first line to the previous line */
		/* separate comment sign from the data */
		putc(' ', cfgi_ini);
	}

	chkHeap
	if(*p) {
		fputs("; ", cfgi_ini);
		while((ch = *p++) != '\0') {
			putc(ch, cfgi_ini);
			if(ch == '\n')
				fputs("; ", cfgi_ini);
		}
	}

	chkHeap
	putc('\n', cfgi_ini);
	cfgi_nlwritten = 1;

	DBG_RETURN_I( CFG_ERR_NONE)
}
