/* file selection */
enum FileSelectionType {MODEL_FILE=0, PROJECT_FILE};

/* simulation */
enum SimulationType {SIMUL_OP=1, SIMUL_DC, SIMUL_AC, SIMUL_TRAN, 
		     SIMUL_TF, SIMUL_NOISE};

/* type of simulation for ac noise param */
enum SweepType {SWEEP_DEC=0, SWEEP_LIN, SWEEP_OCT, SWEEP_LIST};

/* type of devices which can be found in spice */
enum SpiceDeviceType { SPICE_DIPOLE=0, SPICE_TRANSISTOR, SPICE_OTHER,
		       SPICE_VOLTAGE_SOURCE, SPICE_CURRENT_SOURCE};

typedef struct KeyValueStruct {
  gchar *key;
  gchar *value;
} KeyValue;

typedef struct SpiceDeviceStruct {
  gchar *name; /* the device name */
  gint type;   /* the device type */
  GList *result; /* list of KeyValue for the device params and op_values */
} SpiceDevice;

/* structures used for the netlist */
typedef  struct SpiceNetlistStruct {
  GList *nodenames; /* list of nodenames (gchar) */
  GList *devices;  /* list of SpiceDevice */
  GList *op_result; /* list of KeyValue of OP-Results */
} SpiceNetlist;

/* all the spice values */
typedef struct SpiceVariableStruct {
  gboolean op_show_netlist;
  gboolean op_show_models;
  gboolean op_show_results_schematic;

  gchar *dc_source1;
  gchar *dc_start1;
  gchar *dc_stop1;
  gchar *dc_inc1;
  gchar *dc_source2;
  gchar *dc_start2;
  gchar *dc_stop2;
  gchar *dc_inc2;

  enum SweepType ac_type;
  gchar *ac_points;
  gchar *ac_fmin;
  gchar *ac_fmax;

  gchar *noise_node;
  gchar *noise_source;
  enum SweepType noise_type;
  gchar *noise_points;
  gchar *noise_fmin;
  gchar *noise_fmax;

  gchar *tran_tstop;
  gchar *tran_tstep;
  gchar *tran_tmax;
  gchar *tran_tstart;

  gchar *tf_output;
  gchar *tf_source;

  gboolean param_activ;
  gchar *param_name;
  gchar *param_param;
  enum SweepType param_type;
  gchar *param_start;
  gchar *param_stop;
  gchar *param_step;
  gchar *param_values;

  /* plotting the results */
  gchar *plot_pre;
  gboolean plot_xdefault;
  gchar *plot_xvalue;
  gboolean plot_xlogscale;
  gboolean plot_xlinscale;
  gchar *plot_yvalues;
  gboolean plot_ylogscale;
  gboolean plot_autoupdate;
} SpiceVariables;


typedef struct PostProcessingStruct {
  GtkWidget *dialog;
  gchar *commands;
} PostProcessing;

typedef struct SpiceLibraryStruct {
  GtkWidget *dialog;
  GList *libs;
  GtkListStore *store;
  GtkTreeModel *model;
} SpiceLibrary;

typedef struct GedaSettingsStruct {
  GtkWidget *dialog;
  gboolean include_cwd;
  gchar *include_dir;
  gboolean pinlabel_attr;
  gchar *attr;
  gchar *gschem_textsize;
  gchar *gschem_gridsize;
  gboolean gnetlist_priority_node;
  gboolean gnetlist_hierarchy_allow;
  gchar *gnetlist_command_line;
} GedaSettings;

typedef struct ExternalProgrammsStruct {
  GtkWidget *dialog;
  gchar *editor;
  gchar *plot_command;
  gchar *spice_command;
  gchar *browser;
  gchar *html_files;
  gchar *spicehelp_command;
} ExternalProgramms;

typedef struct TextviewerStruct {
  GtkWidget *dialog;
} Textviewer;

typedef struct EasySpiceStruct {
  /* window pointers */
  GtkWidget *win_main;
  GtkWidget *dialog_file;
  GtkWidget *dialog_spicelib;
  GtkWidget *dialog_analyse;
  GtkWidget *dialog_mainquit;
  
  /* project and filenames */
  gchar *project;
  gchar *file_schematic;
  gchar *file_schematic_tmp;
  gchar *file_spice_netlist;
  gchar *file_spice_simul;
  gchar *file_spice_results;
  gchar *file_spice_raw;
  gchar *file_spice_plot;
  gchar *file_spice_loadplot;
  gchar *file_spice_error;
  gchar *file_easyspice_project;
  
  /* programm names, ... */
  ExternalProgramms *commands;

  /* geda settings */
  GedaSettings *geda;

  /* spice post processing dialog */
  PostProcessing *postproc;
  
  /* Textviewer dialog data */
  Textviewer *textviewer;

  /* spice lib dialog data */
  SpiceLibrary *spicelibrary;  

  /* spice settings (from win_main) */
  SpiceVariables *spice_vars;
  SpiceNetlist *netlist;
  
  /* variables for parametric simulations */
  gint current_simul;
  gint current_n_step;

  /* unix process id's for external commands */
  gint simulator_pid;
  gint plotcommand_pid;
} EasySpice;
