/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class MaskFilter
extends RGBImageFilter {
    private Color _newColor;
    private Color _oldColor;
    private static MaskFilter _maskFilter = null;

    public static MaskFilter getInstance(Color color, Color color2) {
        if (_maskFilter == null) {
            _maskFilter = new MaskFilter(color, color2);
        } else {
            _maskFilter.setOldColor(color);
            _maskFilter.setNewColor(color2);
        }
        return _maskFilter;
    }

    private void setNewColor(Color color) {
        this._newColor = color;
    }

    private void setOldColor(Color color) {
        this._oldColor = color;
    }

    public static Image createImage(Image image, Color color, Color color2) {
        MaskFilter maskFilter = MaskFilter.getInstance(color, color2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), maskFilter);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        return image2;
    }

    public static Image createNegativeImage(Image image) {
        return MaskFilter.createImage(image, Color.black, Color.white);
    }

    public MaskFilter(Color color, Color color2) {
        this._newColor = color2;
        this._oldColor = color;
        this.canFilterIndexColorModel = true;
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        if (this._newColor != null && this._oldColor != null && n3 == this._oldColor.getRGB()) {
            return this._newColor.getRGB();
        }
        return n3;
    }
}

