/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ArrayUtil;

public class MultiMemberVisitor
implements MemberVisitor {
    private MemberVisitor[] memberVisitors;
    private int memberVisitorCount;

    public MultiMemberVisitor() {
        this.memberVisitors = new MemberVisitor[16];
    }

    public MultiMemberVisitor(MemberVisitor ... memberVisitorArray) {
        this.memberVisitors = memberVisitorArray;
        this.memberVisitorCount = memberVisitorArray.length;
    }

    public void addMemberVisitor(MemberVisitor memberVisitor) {
        this.memberVisitors = ArrayUtil.add(this.memberVisitors, this.memberVisitorCount++, memberVisitor);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

