!===============================================================================
! Copyright 2005-2020 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!      F95 interface for LAPACK routines
!*******************************************************************************
! This file was generated automatically!
!*******************************************************************************

MODULE F95_PRECISION
    INTEGER, PARAMETER :: SP = KIND(1.0E0)
    INTEGER, PARAMETER :: DP = KIND(1.0D0)
END MODULE F95_PRECISION

MODULE LAPACK95

INTERFACE GETRF
    PURE SUBROUTINE SGETRF_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! SGETRF(M,N,A,LDA,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGETRF_F95
    PURE SUBROUTINE DGETRF_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! DGETRF(M,N,A,LDA,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGETRF_F95
    PURE SUBROUTINE CGETRF_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! CGETRF(M,N,A,LDA,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGETRF_F95
    PURE SUBROUTINE ZGETRF_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! ZGETRF(M,N,A,LDA,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGETRF_F95
END INTERFACE GETRF

INTERFACE MKL_GETRFNPI
    PURE SUBROUTINE MKL_SGETRFNPI_F95(A,NFACT,INFO)
        ! Fortran77 call:
        ! MKL_SGETRFNPI(M,N,NFACT,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: NFACT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE MKL_SGETRFNPI_F95
    PURE SUBROUTINE MKL_DGETRFNPI_F95(A,NFACT,INFO)
        ! Fortran77 call:
        ! MKL_DGETRFNPI(M,N,NFACT,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: NFACT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE MKL_DGETRFNPI_F95
    PURE SUBROUTINE MKL_CGETRFNPI_F95(A,NFACT,INFO)
        ! Fortran77 call:
        ! MKL_CGETRFNPI(M,N,NFACT,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: NFACT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE MKL_CGETRFNPI_F95
    PURE SUBROUTINE MKL_ZGETRFNPI_F95(A,NFACT,INFO)
        ! Fortran77 call:
        ! MKL_ZGETRFNPI(M,N,NFACT,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: NFACT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE MKL_ZGETRFNPI_F95
END INTERFACE MKL_GETRFNPI

INTERFACE GBTRF
    PURE SUBROUTINE SGBTRF_F95(AB,KL,M,IPIV,INFO)
        ! Fortran77 call:
        ! SGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGBTRF_F95
    PURE SUBROUTINE DGBTRF_F95(AB,KL,M,IPIV,INFO)
        ! Fortran77 call:
        ! DGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGBTRF_F95
    PURE SUBROUTINE CGBTRF_F95(AB,KL,M,IPIV,INFO)
        ! Fortran77 call:
        ! CGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGBTRF_F95
    PURE SUBROUTINE ZGBTRF_F95(AB,KL,M,IPIV,INFO)
        ! Fortran77 call:
        ! ZGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGBTRF_F95
END INTERFACE GBTRF

INTERFACE GTTRF
    PURE SUBROUTINE SGTTRF_F95(DL,D,DU,DU2,IPIV,INFO)
        ! Fortran77 call:
        ! SGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(OUT) :: DU2(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGTTRF_F95
    PURE SUBROUTINE DGTTRF_F95(DL,D,DU,DU2,IPIV,INFO)
        ! Fortran77 call:
        ! DGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(OUT) :: DU2(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGTTRF_F95
    PURE SUBROUTINE CGTTRF_F95(DL,D,DU,DU2,IPIV,INFO)
        ! Fortran77 call:
        ! CGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(OUT) :: DU2(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGTTRF_F95
    PURE SUBROUTINE ZGTTRF_F95(DL,D,DU,DU2,IPIV,INFO)
        ! Fortran77 call:
        ! ZGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(OUT) :: DU2(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGTTRF_F95
END INTERFACE GTTRF

INTERFACE DTTRFB
    PURE SUBROUTINE SDTTRFB_F95(DL,D,DU,INFO)
        ! Fortran77 call:
        ! SDTTRFB(N,DL,D,DU,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
    END SUBROUTINE SDTTRFB_F95
    PURE SUBROUTINE DDTTRFB_F95(DL,D,DU,INFO)
        ! Fortran77 call:
        ! DDTTRFB(N,DL,D,DU,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
    END SUBROUTINE DDTTRFB_F95
    PURE SUBROUTINE CDTTRFB_F95(DL,D,DU,INFO)
        ! Fortran77 call:
        ! CDTTRFB(N,DL,D,DU,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
    END SUBROUTINE CDTTRFB_F95
    PURE SUBROUTINE ZDTTRFB_F95(DL,D,DU,INFO)
        ! Fortran77 call:
        ! ZDTTRFB(N,DL,D,DU,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
    END SUBROUTINE ZDTTRFB_F95
END INTERFACE DTTRFB

INTERFACE POTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPOTRF_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! SPOTRF(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE SPOTRF_F95
    PURE SUBROUTINE DPOTRF_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! DPOTRF(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE DPOTRF_F95
    PURE SUBROUTINE CPOTRF_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! CPOTRF(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE CPOTRF_F95
    PURE SUBROUTINE ZPOTRF_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOTRF(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE ZPOTRF_F95
END INTERFACE POTRF

INTERFACE PPTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPTRF_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! SPPTRF(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE SPPTRF_F95
    PURE SUBROUTINE DPPTRF_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! DPPTRF(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE DPPTRF_F95
    PURE SUBROUTINE CPPTRF_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! CPPTRF(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE CPPTRF_F95
    PURE SUBROUTINE ZPPTRF_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPTRF(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE ZPPTRF_F95
END INTERFACE PPTRF

INTERFACE PBTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBTRF_F95(AB,UPLO,INFO)
        ! Fortran77 call:
        ! SPBTRF(UPLO,N,KD,AB,LDAB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
    END SUBROUTINE SPBTRF_F95
    PURE SUBROUTINE DPBTRF_F95(AB,UPLO,INFO)
        ! Fortran77 call:
        ! DPBTRF(UPLO,N,KD,AB,LDAB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
    END SUBROUTINE DPBTRF_F95
    PURE SUBROUTINE CPBTRF_F95(AB,UPLO,INFO)
        ! Fortran77 call:
        ! CPBTRF(UPLO,N,KD,AB,LDAB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
    END SUBROUTINE CPBTRF_F95
    PURE SUBROUTINE ZPBTRF_F95(AB,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBTRF(UPLO,N,KD,AB,LDAB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
    END SUBROUTINE ZPBTRF_F95
END INTERFACE PBTRF

INTERFACE PTTRF
    PURE SUBROUTINE SPTTRF_F95(D,E,INFO)
        ! Fortran77 call:
        ! SPTTRF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE SPTTRF_F95
    PURE SUBROUTINE DPTTRF_F95(D,E,INFO)
        ! Fortran77 call:
        ! DPTTRF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE DPTTRF_F95
    PURE SUBROUTINE CPTTRF_F95(D,E,INFO)
        ! Fortran77 call:
        ! CPTTRF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE CPTTRF_F95
    PURE SUBROUTINE ZPTTRF_F95(D,E,INFO)
        ! Fortran77 call:
        ! ZPTTRF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE ZPTTRF_F95
END INTERFACE PTTRF

INTERFACE SYTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYTRF_F95
    PURE SUBROUTINE DSYTRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYTRF_F95
    PURE SUBROUTINE CSYTRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYTRF_F95
    PURE SUBROUTINE ZSYTRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYTRF_F95
END INTERFACE SYTRF

INTERFACE SYTRF_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYTRF_ROOK_F95
    PURE SUBROUTINE DSYTRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYTRF_ROOK_F95
    PURE SUBROUTINE CSYTRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYTRF_ROOK_F95
    PURE SUBROUTINE ZSYTRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYTRF_ROOK_F95
END INTERFACE SYTRF_ROOK

INTERFACE HETRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHETRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHETRF_F95
    PURE SUBROUTINE ZHETRF_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHETRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHETRF_F95
END INTERFACE HETRF

INTERFACE HETRF_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHETRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHETRF_ROOK_F95
    PURE SUBROUTINE ZHETRF_ROOK_F95(A,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHETRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHETRF_ROOK_F95
END INTERFACE HETRF_ROOK

INTERFACE SPTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSPTRF_F95
    PURE SUBROUTINE DSPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSPTRF_F95
    PURE SUBROUTINE CSPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSPTRF_F95
    PURE SUBROUTINE ZSPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSPTRF_F95
END INTERFACE SPTRF

INTERFACE HPTRF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHPTRF_F95
    PURE SUBROUTINE ZHPTRF_F95(AP,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHPTRF(UPLO,N,AP,IPIV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHPTRF_F95
END INTERFACE HPTRF

INTERFACE GETRS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGETRS_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! SGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SGETRS_F95
    PURE SUBROUTINE SGETRS1_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! SGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SGETRS1_F95
    PURE SUBROUTINE DGETRS_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! DGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DGETRS_F95
    PURE SUBROUTINE DGETRS1_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! DGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DGETRS1_F95
    PURE SUBROUTINE CGETRS_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! CGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CGETRS_F95
    PURE SUBROUTINE CGETRS1_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! CGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CGETRS1_F95
    PURE SUBROUTINE ZGETRS_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZGETRS_F95
    PURE SUBROUTINE ZGETRS1_F95(A,IPIV,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZGETRS1_F95
END INTERFACE GETRS

INTERFACE GBTRS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGBTRS_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! SGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGBTRS_F95
    PURE SUBROUTINE SGBTRS1_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! SGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGBTRS1_F95
    PURE SUBROUTINE DGBTRS_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! DGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGBTRS_F95
    PURE SUBROUTINE DGBTRS1_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! DGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGBTRS1_F95
    PURE SUBROUTINE CGBTRS_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! CGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGBTRS_F95
    PURE SUBROUTINE CGBTRS1_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! CGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGBTRS1_F95
    PURE SUBROUTINE ZGBTRS_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! ZGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGBTRS_F95
    PURE SUBROUTINE ZGBTRS1_F95(AB,B,IPIV,KL,TRANS,INFO)
        ! Fortran77 call:
        ! ZGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGBTRS1_F95
END INTERFACE GBTRS

INTERFACE GTTRS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGTTRS_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! SGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGTTRS_F95
    PURE SUBROUTINE SGTTRS1_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! SGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGTTRS1_F95
    PURE SUBROUTINE DGTTRS_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! DGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGTTRS_F95
    PURE SUBROUTINE DGTTRS1_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! DGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGTTRS1_F95
    PURE SUBROUTINE CGTTRS_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! CGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGTTRS_F95
    PURE SUBROUTINE CGTTRS1_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! CGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGTTRS1_F95
    PURE SUBROUTINE ZGTTRS_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! ZGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGTTRS_F95
    PURE SUBROUTINE ZGTTRS1_F95(DL,D,DU,DU2,B,IPIV,TRANS,INFO)
        ! Fortran77 call:
        ! ZGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGTTRS1_F95
END INTERFACE GTTRS

INTERFACE DTTRSB
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SDTTRSB_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! SDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SDTTRSB_F95
    PURE SUBROUTINE SDTTRSB1_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! SDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SDTTRSB1_F95
    PURE SUBROUTINE DDTTRSB_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! DDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DDTTRSB_F95
    PURE SUBROUTINE DDTTRSB1_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! DDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DDTTRSB1_F95
    PURE SUBROUTINE CDTTRSB_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! CDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CDTTRSB_F95
    PURE SUBROUTINE CDTTRSB1_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! CDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CDTTRSB1_F95
    PURE SUBROUTINE ZDTTRSB_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZDTTRSB_F95
    PURE SUBROUTINE ZDTTRSB1_F95(DL,D,DU,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZDTTRSB1_F95
END INTERFACE DTTRSB

INTERFACE POTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPOTRS_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPOTRS_F95
    PURE SUBROUTINE SPOTRS1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPOTRS1_F95
    PURE SUBROUTINE DPOTRS_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPOTRS_F95
    PURE SUBROUTINE DPOTRS1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPOTRS1_F95
    PURE SUBROUTINE CPOTRS_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPOTRS_F95
    PURE SUBROUTINE CPOTRS1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPOTRS1_F95
    PURE SUBROUTINE ZPOTRS_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPOTRS_F95
    PURE SUBROUTINE ZPOTRS1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPOTRS1_F95
END INTERFACE POTRS

INTERFACE PPTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPTRS_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPPTRS_F95
    PURE SUBROUTINE SPPTRS1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPPTRS1_F95
    PURE SUBROUTINE DPPTRS_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPPTRS_F95
    PURE SUBROUTINE DPPTRS1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPPTRS1_F95
    PURE SUBROUTINE CPPTRS_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPPTRS_F95
    PURE SUBROUTINE CPPTRS1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPPTRS1_F95
    PURE SUBROUTINE ZPPTRS_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPPTRS_F95
    PURE SUBROUTINE ZPPTRS1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPPTRS1_F95
END INTERFACE PPTRS

INTERFACE PBTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBTRS_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPBTRS_F95
    PURE SUBROUTINE SPBTRS1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPBTRS1_F95
    PURE SUBROUTINE DPBTRS_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPBTRS_F95
    PURE SUBROUTINE DPBTRS1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPBTRS1_F95
    PURE SUBROUTINE CPBTRS_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPBTRS_F95
    PURE SUBROUTINE CPBTRS1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPBTRS1_F95
    PURE SUBROUTINE ZPBTRS_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPBTRS_F95
    PURE SUBROUTINE ZPBTRS1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPBTRS1_F95
END INTERFACE PBTRS

INTERFACE PTTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPTTRS_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! SPTTRS(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPTTRS_F95
    PURE SUBROUTINE SPTTRS1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! SPTTRS(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPTTRS1_F95
    PURE SUBROUTINE DPTTRS_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! DPTTRS(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPTTRS_F95
    PURE SUBROUTINE DPTTRS1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! DPTTRS(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPTTRS1_F95
    PURE SUBROUTINE CPTTRS_F95(D,E,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPTTRS_F95
    PURE SUBROUTINE CPTTRS1_F95(D,E,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPTTRS1_F95
    PURE SUBROUTINE ZPTTRS_F95(D,E,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPTTRS_F95
    PURE SUBROUTINE ZPTTRS1_F95(D,E,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPTTRS1_F95
END INTERFACE PTTRS

INTERFACE SYTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS_F95
    PURE SUBROUTINE SSYTRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS1_F95
    PURE SUBROUTINE DSYTRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS_F95
    PURE SUBROUTINE DSYTRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS1_F95
    PURE SUBROUTINE CSYTRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS_F95
    PURE SUBROUTINE CSYTRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS1_F95
    PURE SUBROUTINE ZSYTRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS_F95
    PURE SUBROUTINE ZSYTRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS1_F95
END INTERFACE SYTRS

INTERFACE SYTRS_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS_ROOK_F95
    PURE SUBROUTINE SSYTRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS1_ROOK_F95
    PURE SUBROUTINE DSYTRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS_ROOK_F95
    PURE SUBROUTINE DSYTRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS1_ROOK_F95
    PURE SUBROUTINE CSYTRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS_ROOK_F95
    PURE SUBROUTINE CSYTRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS1_ROOK_F95
    PURE SUBROUTINE ZSYTRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS_ROOK_F95
    PURE SUBROUTINE ZSYTRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS1_ROOK_F95
END INTERFACE SYTRS_ROOK

INTERFACE HETRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS_F95
    PURE SUBROUTINE CHETRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS1_F95
    PURE SUBROUTINE ZHETRS_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS_F95
    PURE SUBROUTINE ZHETRS1_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS1_F95
END INTERFACE HETRS

INTERFACE HETRS_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS_ROOK_F95
    PURE SUBROUTINE CHETRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS1_ROOK_F95
    PURE SUBROUTINE ZHETRS_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS_ROOK_F95
    PURE SUBROUTINE ZHETRS1_ROOK_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS1_ROOK_F95
END INTERFACE HETRS_ROOK

INTERFACE SPTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSPTRS_F95
    PURE SUBROUTINE SSPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSPTRS1_F95
    PURE SUBROUTINE DSPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSPTRS_F95
    PURE SUBROUTINE DSPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSPTRS1_F95
    PURE SUBROUTINE CSPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSPTRS_F95
    PURE SUBROUTINE CSPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSPTRS1_F95
    PURE SUBROUTINE ZSPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSPTRS_F95
    PURE SUBROUTINE ZSPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSPTRS1_F95
END INTERFACE SPTRS

INTERFACE HPTRS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHPTRS_F95
    PURE SUBROUTINE CHPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHPTRS1_F95
    PURE SUBROUTINE ZHPTRS_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHPTRS_F95
    PURE SUBROUTINE ZHPTRS1_F95(AP,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHPTRS1_F95
END INTERFACE HPTRS

INTERFACE TRTRS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STRTRS_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE STRTRS_F95
    PURE SUBROUTINE STRTRS1_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE STRTRS1_F95
    PURE SUBROUTINE DTRTRS_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DTRTRS_F95
    PURE SUBROUTINE DTRTRS1_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DTRTRS1_F95
    PURE SUBROUTINE CTRTRS_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CTRTRS_F95
    PURE SUBROUTINE CTRTRS1_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CTRTRS1_F95
    PURE SUBROUTINE ZTRTRS_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZTRTRS_F95
    PURE SUBROUTINE ZTRTRS1_F95(A,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZTRTRS1_F95
END INTERFACE TRTRS

INTERFACE TPTRS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STPTRS_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE STPTRS_F95
    PURE SUBROUTINE STPTRS1_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE STPTRS1_F95
    PURE SUBROUTINE DTPTRS_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DTPTRS_F95
    PURE SUBROUTINE DTPTRS1_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DTPTRS1_F95
    PURE SUBROUTINE CTPTRS_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CTPTRS_F95
    PURE SUBROUTINE CTPTRS1_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CTPTRS1_F95
    PURE SUBROUTINE ZTPTRS_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZTPTRS_F95
    PURE SUBROUTINE ZTPTRS1_F95(AP,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZTPTRS1_F95
END INTERFACE TPTRS

INTERFACE TBTRS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STBTRS_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE STBTRS_F95
    PURE SUBROUTINE STBTRS1_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! STBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE STBTRS1_F95
    PURE SUBROUTINE DTBTRS_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DTBTRS_F95
    PURE SUBROUTINE DTBTRS1_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! DTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DTBTRS1_F95
    PURE SUBROUTINE CTBTRS_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CTBTRS_F95
    PURE SUBROUTINE CTBTRS1_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! CTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CTBTRS1_F95
    PURE SUBROUTINE ZTBTRS_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZTBTRS_F95
    PURE SUBROUTINE ZTBTRS1_F95(AB,B,UPLO,TRANS,DIAG,INFO)
        ! Fortran77 call:
        ! ZTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZTBTRS1_F95
END INTERFACE TBTRS

INTERFACE GECON
        ! NORM='1','O','I'; default: '1'
    PURE SUBROUTINE SGECON_F95(A,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! SGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE SGECON_F95
    PURE SUBROUTINE DGECON_F95(A,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! DGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE DGECON_F95
    PURE SUBROUTINE CGECON_F95(A,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! CGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE CGECON_F95
    PURE SUBROUTINE ZGECON_F95(A,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! ZGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE ZGECON_F95
END INTERFACE GECON

INTERFACE GBCON
        ! NORM='1','O','I'; default: '1'
    PURE SUBROUTINE SGBCON_F95(AB,IPIV,ANORM,RCOND,KL,NORM,INFO)
        ! Fortran77 call:
        ! SGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGBCON_F95
    PURE SUBROUTINE DGBCON_F95(AB,IPIV,ANORM,RCOND,KL,NORM,INFO)
        ! Fortran77 call:
        ! DGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGBCON_F95
    PURE SUBROUTINE CGBCON_F95(AB,IPIV,ANORM,RCOND,KL,NORM,INFO)
        ! Fortran77 call:
        ! CGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGBCON_F95
    PURE SUBROUTINE ZGBCON_F95(AB,IPIV,ANORM,RCOND,KL,NORM,INFO)
        ! Fortran77 call:
        ! ZGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGBCON_F95
END INTERFACE GBCON

INTERFACE GTCON
        ! NORM='1','O','I'; default: '1'
    PURE SUBROUTINE SGTCON_F95(DL,D,DU,DU2,IPIV,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! SGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGTCON_F95
    PURE SUBROUTINE DGTCON_F95(DL,D,DU,DU2,IPIV,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! DGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGTCON_F95
    PURE SUBROUTINE CGTCON_F95(DL,D,DU,DU2,IPIV,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! CGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGTCON_F95
    PURE SUBROUTINE ZGTCON_F95(DL,D,DU,DU2,IPIV,ANORM,RCOND,NORM,INFO)
        ! Fortran77 call:
        ! ZGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGTCON_F95
END INTERFACE GTCON

INTERFACE POCON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPOCON_F95(A,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE SPOCON_F95
    PURE SUBROUTINE DPOCON_F95(A,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE DPOCON_F95
    PURE SUBROUTINE CPOCON_F95(A,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE CPOCON_F95
    PURE SUBROUTINE ZPOCON_F95(A,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE ZPOCON_F95
END INTERFACE POCON

INTERFACE PPCON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPCON_F95(AP,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SPPCON(UPLO,N,AP,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE SPPCON_F95
    PURE SUBROUTINE DPPCON_F95(AP,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DPPCON(UPLO,N,AP,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE DPPCON_F95
    PURE SUBROUTINE CPPCON_F95(AP,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CPPCON(UPLO,N,AP,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE CPPCON_F95
    PURE SUBROUTINE ZPPCON_F95(AP,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPCON(UPLO,N,AP,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE ZPPCON_F95
END INTERFACE PPCON

INTERFACE PBCON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBCON_F95(AB,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE SPBCON_F95
    PURE SUBROUTINE DPBCON_F95(AB,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE DPBCON_F95
    PURE SUBROUTINE CPBCON_F95(AB,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE CPBCON_F95
    PURE SUBROUTINE ZPBCON_F95(AB,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE ZPBCON_F95
END INTERFACE PBCON

INTERFACE PTCON
    PURE SUBROUTINE SPTCON_F95(D,E,ANORM,RCOND,INFO)
        ! Fortran77 call:
        ! SPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
    END SUBROUTINE SPTCON_F95
    PURE SUBROUTINE DPTCON_F95(D,E,ANORM,RCOND,INFO)
        ! Fortran77 call:
        ! DPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
    END SUBROUTINE DPTCON_F95
    PURE SUBROUTINE CPTCON_F95(D,E,ANORM,RCOND,INFO)
        ! Fortran77 call:
        ! CPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
    END SUBROUTINE CPTCON_F95
    PURE SUBROUTINE ZPTCON_F95(D,E,ANORM,RCOND,INFO)
        ! Fortran77 call:
        ! ZPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
    END SUBROUTINE ZPTCON_F95
END INTERFACE PTCON

INTERFACE SYCON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYCON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYCON_F95
    PURE SUBROUTINE DSYCON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYCON_F95
    PURE SUBROUTINE CSYCON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYCON_F95
    PURE SUBROUTINE ZSYCON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYCON_F95
END INTERFACE SYCON

INTERFACE SYCON_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYCON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYCON_ROOK_F95
    PURE SUBROUTINE DSYCON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYCON_ROOK_F95
    PURE SUBROUTINE CSYCON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYCON_ROOK_F95
    PURE SUBROUTINE ZSYCON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYCON_ROOK_F95
END INTERFACE SYCON_ROOK

INTERFACE HECON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHECON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CHECON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHECON_F95
    PURE SUBROUTINE ZHECON_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZHECON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHECON_F95
END INTERFACE HECON

INTERFACE HECON_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHECON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CHECON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHECON_ROOK_F95
    PURE SUBROUTINE ZHECON_ROOK_F95(A,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZHECON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHECON_ROOK_F95
END INTERFACE HECON_ROOK

INTERFACE SPCON
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! SSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSPCON_F95
    PURE SUBROUTINE DSPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! DSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSPCON_F95
    PURE SUBROUTINE CSPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSPCON_F95
    PURE SUBROUTINE ZSPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSPCON_F95
END INTERFACE SPCON

INTERFACE HPCON
    PURE SUBROUTINE CHPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! CHPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHPCON_F95
    PURE SUBROUTINE ZHPCON_F95(AP,IPIV,ANORM,RCOND,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: ANORM
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHPCON_F95
END INTERFACE HPCON

INTERFACE TRCON
        ! NORM='1','O','I'; default: '1'
        ! UPLO='U','L'; default: 'U'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STRCON_F95(A,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! STRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE STRCON_F95
    PURE SUBROUTINE DTRCON_F95(A,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! DTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE DTRCON_F95
    PURE SUBROUTINE CTRCON_F95(A,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! CTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE CTRCON_F95
    PURE SUBROUTINE ZTRCON_F95(A,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! ZTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE ZTRCON_F95
END INTERFACE TRCON

INTERFACE TPCON
        ! NORM='1','O','I'; default: '1'
        ! UPLO='U','L'; default: 'U'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STPCON_F95(AP,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! STPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE STPCON_F95
    PURE SUBROUTINE DTPCON_F95(AP,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! DTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE DTPCON_F95
    PURE SUBROUTINE CTPCON_F95(AP,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! CTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE CTPCON_F95
    PURE SUBROUTINE ZTPCON_F95(AP,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! ZTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
    END SUBROUTINE ZTPCON_F95
END INTERFACE TPCON

INTERFACE TBCON
        ! NORM='1','O','I'; default: '1'
        ! UPLO='U','L'; default: 'U'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STBCON_F95(AB,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! STBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE STBCON_F95
    PURE SUBROUTINE DTBCON_F95(AB,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! DTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE DTBCON_F95
    PURE SUBROUTINE CTBCON_F95(AB,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! CTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE CTBCON_F95
    PURE SUBROUTINE ZTBCON_F95(AB,RCOND,UPLO,DIAG,NORM,INFO)
        ! Fortran77 call:
        ! ZTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: RCOND
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: NORM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
    END SUBROUTINE ZTBCON_F95
END INTERFACE TBCON

INTERFACE GERFS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGERFS_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGERFS_F95
    PURE SUBROUTINE SGERFS1_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SGERFS1_F95
    PURE SUBROUTINE DGERFS_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGERFS_F95
    PURE SUBROUTINE DGERFS1_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DGERFS1_F95
    PURE SUBROUTINE CGERFS_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGERFS_F95
    PURE SUBROUTINE CGERFS1_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CGERFS1_F95
    PURE SUBROUTINE ZGERFS_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGERFS_F95
    PURE SUBROUTINE ZGERFS1_F95(A,AF,IPIV,B,X,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZGERFS1_F95
END INTERFACE GERFS

INTERFACE GBRFS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGBRFS_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGBRFS_F95
    PURE SUBROUTINE SGBRFS1_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SGBRFS1_F95
    PURE SUBROUTINE DGBRFS_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGBRFS_F95
    PURE SUBROUTINE DGBRFS1_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DGBRFS1_F95
    PURE SUBROUTINE CGBRFS_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGBRFS_F95
    PURE SUBROUTINE CGBRFS1_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CGBRFS1_F95
    PURE SUBROUTINE ZGBRFS_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGBRFS_F95
    PURE SUBROUTINE ZGBRFS1_F95(AB,AFB,IPIV,B,X,KL,TRANS,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZGBRFS1_F95
END INTERFACE GBRFS

INTERFACE GTRFS
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGTRFS_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,   &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DLF(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: DUF(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGTRFS_F95
    PURE SUBROUTINE SGTRFS1_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,  &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! SGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DLF(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: DUF(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SGTRFS1_F95
    PURE SUBROUTINE DGTRFS_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,   &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DLF(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: DUF(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGTRFS_F95
    PURE SUBROUTINE DGTRFS1_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,  &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! DGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: DLF(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: DUF(:)
        REAL(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DGTRFS1_F95
    PURE SUBROUTINE CGTRFS_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,   &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DLF(:)
        COMPLEX(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: DUF(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGTRFS_F95
    PURE SUBROUTINE CGTRFS1_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,  &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! CGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DLF(:)
        COMPLEX(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: DUF(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CGTRFS1_F95
    PURE SUBROUTINE ZGTRFS_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,   &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DLF(:)
        COMPLEX(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: DUF(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGTRFS_F95
    PURE SUBROUTINE ZGTRFS1_F95(DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,X,TRANS,  &
     &                                                   FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,LDX,
        !   FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: DLF(:)
        COMPLEX(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: DUF(:)
        COMPLEX(WP), INTENT(IN) :: DU2(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZGTRFS1_F95
END INTERFACE GTRFS

INTERFACE PORFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPORFS_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPORFS_F95
    PURE SUBROUTINE SPORFS1_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SPORFS1_F95
    PURE SUBROUTINE DPORFS_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPORFS_F95
    PURE SUBROUTINE DPORFS1_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DPORFS1_F95
    PURE SUBROUTINE CPORFS_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPORFS_F95
    PURE SUBROUTINE CPORFS1_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CPORFS1_F95
    PURE SUBROUTINE ZPORFS_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPORFS_F95
    PURE SUBROUTINE ZPORFS1_F95(A,AF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZPORFS1_F95
END INTERFACE PORFS

INTERFACE PPRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPRFS_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPPRFS_F95
    PURE SUBROUTINE SPPRFS1_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SPPRFS1_F95
    PURE SUBROUTINE DPPRFS_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPPRFS_F95
    PURE SUBROUTINE DPPRFS1_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DPPRFS1_F95
    PURE SUBROUTINE CPPRFS_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPPRFS_F95
    PURE SUBROUTINE CPPRFS1_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CPPRFS1_F95
    PURE SUBROUTINE ZPPRFS_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPPRFS_F95
    PURE SUBROUTINE ZPPRFS1_F95(AP,AFP,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZPPRFS1_F95
END INTERFACE PPRFS

INTERFACE PBRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBRFS_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPBRFS_F95
    PURE SUBROUTINE SPBRFS1_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SPBRFS1_F95
    PURE SUBROUTINE DPBRFS_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPBRFS_F95
    PURE SUBROUTINE DPBRFS1_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: AFB(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DPBRFS1_F95
    PURE SUBROUTINE CPBRFS_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPBRFS_F95
    PURE SUBROUTINE CPBRFS1_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CPBRFS1_F95
    PURE SUBROUTINE ZPBRFS_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPBRFS_F95
    PURE SUBROUTINE ZPBRFS1_F95(AB,AFB,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: AFB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZPBRFS1_F95
END INTERFACE PBRFS

INTERFACE PTRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPTRFS_F95(D,DF,E,EF,B,X,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: EF(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPTRFS_F95
    PURE SUBROUTINE SPTRFS1_F95(D,DF,E,EF,B,X,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: EF(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SPTRFS1_F95
    PURE SUBROUTINE DPTRFS_F95(D,DF,E,EF,B,X,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: EF(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPTRFS_F95
    PURE SUBROUTINE DPTRFS1_F95(D,DF,E,EF,B,X,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: EF(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DPTRFS1_F95
    PURE SUBROUTINE CPTRFS_F95(D,DF,E,EF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: EF(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPTRFS_F95
    PURE SUBROUTINE CPTRFS1_F95(D,DF,E,EF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: EF(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CPTRFS1_F95
    PURE SUBROUTINE ZPTRFS_F95(D,DF,E,EF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: EF(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPTRFS_F95
    PURE SUBROUTINE ZPTRFS1_F95(D,DF,E,EF,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DF(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: EF(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZPTRFS1_F95
END INTERFACE PTRFS

INTERFACE SYRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYRFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SSYRFS_F95
    PURE SUBROUTINE SSYRFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SSYRFS1_F95
    PURE SUBROUTINE DSYRFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DSYRFS_F95
    PURE SUBROUTINE DSYRFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DSYRFS1_F95
    PURE SUBROUTINE CSYRFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CSYRFS_F95
    PURE SUBROUTINE CSYRFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CSYRFS1_F95
    PURE SUBROUTINE ZSYRFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZSYRFS_F95
    PURE SUBROUTINE ZSYRFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZSYRFS1_F95
END INTERFACE SYRFS

INTERFACE HERFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHERFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CHERFS_F95
    PURE SUBROUTINE CHERFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CHERFS1_F95
    PURE SUBROUTINE ZHERFS_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZHERFS_F95
    PURE SUBROUTINE ZHERFS1_F95(A,AF,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: AF(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZHERFS1_F95
END INTERFACE HERFS

INTERFACE SPRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SSPRFS_F95
    PURE SUBROUTINE SSPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! SSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE SSPRFS1_F95
    PURE SUBROUTINE DSPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DSPRFS_F95
    PURE SUBROUTINE DSPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE DSPRFS1_F95
    PURE SUBROUTINE CSPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CSPRFS_F95
    PURE SUBROUTINE CSPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CSPRFS1_F95
    PURE SUBROUTINE ZSPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZSPRFS_F95
    PURE SUBROUTINE ZSPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZSPRFS1_F95
END INTERFACE SPRFS

INTERFACE HPRFS
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CHPRFS_F95
    PURE SUBROUTINE CHPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE CHPRFS1_F95
    PURE SUBROUTINE ZHPRFS_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZHPRFS_F95
    PURE SUBROUTINE ZHPRFS1_F95(AP,AFP,IPIV,B,X,UPLO,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: AFP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(INOUT) :: X(:)
    END SUBROUTINE ZHPRFS1_F95
END INTERFACE HPRFS

INTERFACE TRRFS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STRRFS_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE STRRFS_F95
    PURE SUBROUTINE STRRFS1_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE STRRFS1_F95
    PURE SUBROUTINE DTRRFS_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DTRRFS_F95
    PURE SUBROUTINE DTRRFS1_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE DTRRFS1_F95
    PURE SUBROUTINE CTRRFS_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CTRRFS_F95
    PURE SUBROUTINE CTRRFS1_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE CTRRFS1_F95
    PURE SUBROUTINE ZTRRFS_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZTRRFS_F95
    PURE SUBROUTINE ZTRRFS1_F95(A,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR,BERR,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE ZTRRFS1_F95
END INTERFACE TRRFS

INTERFACE TPRFS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STPRFS_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE STPRFS_F95
    PURE SUBROUTINE STPRFS1_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE STPRFS1_F95
    PURE SUBROUTINE DTPRFS_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DTPRFS_F95
    PURE SUBROUTINE DTPRFS1_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE DTPRFS1_F95
    PURE SUBROUTINE CTPRFS_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CTPRFS_F95
    PURE SUBROUTINE CTPRFS1_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE CTPRFS1_F95
    PURE SUBROUTINE ZTPRFS_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZTPRFS_F95
    PURE SUBROUTINE ZTPRFS1_F95(AP,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE ZTPRFS1_F95
END INTERFACE TPRFS

INTERFACE TBRFS
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C','T'; default: 'N'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STBRFS_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE STBRFS_F95
    PURE SUBROUTINE STBRFS1_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! STBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE STBRFS1_F95
    PURE SUBROUTINE DTBRFS_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DTBRFS_F95
    PURE SUBROUTINE DTBRFS1_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! DTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(IN) :: X(:)
    END SUBROUTINE DTBRFS1_F95
    PURE SUBROUTINE CTBRFS_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CTBRFS_F95
    PURE SUBROUTINE CTBRFS1_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! CTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE CTBRFS1_F95
    PURE SUBROUTINE ZTBRFS_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(IN) :: X(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZTBRFS_F95
    PURE SUBROUTINE ZTBRFS1_F95(AB,B,X,UPLO,TRANS,DIAG,FERR,BERR,INFO)
        ! Fortran77 call:
        ! ZTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(IN) :: X(:)
    END SUBROUTINE ZTBRFS1_F95
END INTERFACE TBRFS

INTERFACE GETRI
    PURE SUBROUTINE SGETRI_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! SGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SGETRI_F95
    PURE SUBROUTINE DGETRI_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! DGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DGETRI_F95
    PURE SUBROUTINE CGETRI_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! CGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CGETRI_F95
    PURE SUBROUTINE ZGETRI_F95(A,IPIV,INFO)
        ! Fortran77 call:
        ! ZGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZGETRI_F95
END INTERFACE GETRI

INTERFACE POTRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPOTRI_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! SPOTRI(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE SPOTRI_F95
    PURE SUBROUTINE DPOTRI_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! DPOTRI(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE DPOTRI_F95
    PURE SUBROUTINE CPOTRI_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! CPOTRI(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE CPOTRI_F95
    PURE SUBROUTINE ZPOTRI_F95(A,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOTRI(UPLO,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE ZPOTRI_F95
END INTERFACE POTRI

INTERFACE PPTRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPTRI_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! SPPTRI(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE SPPTRI_F95
    PURE SUBROUTINE DPPTRI_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! DPPTRI(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE DPPTRI_F95
    PURE SUBROUTINE CPPTRI_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! CPPTRI(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE CPPTRI_F95
    PURE SUBROUTINE ZPPTRI_F95(AP,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPTRI(UPLO,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE ZPPTRI_F95
END INTERFACE PPTRI

INTERFACE SYTRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRI_F95
    PURE SUBROUTINE DSYTRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRI_F95
    PURE SUBROUTINE CSYTRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRI_F95
    PURE SUBROUTINE ZSYTRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRI_F95
END INTERFACE SYTRI

INTERFACE SYTRI_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRI_ROOK_F95
    PURE SUBROUTINE DSYTRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRI_ROOK_F95
    PURE SUBROUTINE CSYTRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRI_ROOK_F95
    PURE SUBROUTINE ZSYTRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRI_ROOK_F95
END INTERFACE SYTRI_ROOK

INTERFACE HETRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRI_F95
    PURE SUBROUTINE ZHETRI_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRI_F95
END INTERFACE HETRI

INTERFACE HETRI_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRI_ROOK_F95
    PURE SUBROUTINE ZHETRI_ROOK_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRI_ROOK_F95
END INTERFACE HETRI_ROOK

INTERFACE SPTRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSPTRI_F95
    PURE SUBROUTINE DSPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSPTRI_F95
    PURE SUBROUTINE CSPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSPTRI_F95
    PURE SUBROUTINE ZSPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSPTRI_F95
END INTERFACE SPTRI

INTERFACE HPTRI
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHPTRI_F95
    PURE SUBROUTINE ZHPTRI_F95(AP,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPTRI(UPLO,N,AP,IPIV,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHPTRI_F95
END INTERFACE HPTRI

INTERFACE TRTRI
        ! UPLO='U','L'; default: 'U'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STRTRI_F95(A,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! STRTRI(UPLO,DIAG,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE STRTRI_F95
    PURE SUBROUTINE DTRTRI_F95(A,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! DTRTRI(UPLO,DIAG,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE DTRTRI_F95
    PURE SUBROUTINE CTRTRI_F95(A,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! CTRTRI(UPLO,DIAG,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE CTRTRI_F95
    PURE SUBROUTINE ZTRTRI_F95(A,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! ZTRTRI(UPLO,DIAG,N,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE ZTRTRI_F95
END INTERFACE TRTRI

INTERFACE TPTRI
        ! UPLO='U','L'; default: 'U'
        ! DIAG='N','U'; default: 'N'
    PURE SUBROUTINE STPTRI_F95(AP,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! STPTRI(UPLO,DIAG,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE STPTRI_F95
    PURE SUBROUTINE DTPTRI_F95(AP,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! DTPTRI(UPLO,DIAG,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE DTPTRI_F95
    PURE SUBROUTINE CTPTRI_F95(AP,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! CTPTRI(UPLO,DIAG,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE CTPTRI_F95
    PURE SUBROUTINE ZTPTRI_F95(AP,UPLO,DIAG,INFO)
        ! Fortran77 call:
        ! ZTPTRI(UPLO,DIAG,N,AP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIAG
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
    END SUBROUTINE ZTPTRI_F95
END INTERFACE TPTRI

INTERFACE GEEQU
    PURE SUBROUTINE SGEEQU_F95(A,R,C,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! SGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE SGEEQU_F95
    PURE SUBROUTINE DGEEQU_F95(A,R,C,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! DGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE DGEEQU_F95
    PURE SUBROUTINE CGEEQU_F95(A,R,C,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! CGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE CGEEQU_F95
    PURE SUBROUTINE ZGEEQU_F95(A,R,C,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! ZGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE ZGEEQU_F95
END INTERFACE GEEQU

INTERFACE GBEQU
    PURE SUBROUTINE SGBEQU_F95(AB,R,C,KL,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! SGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE SGBEQU_F95
    PURE SUBROUTINE DGBEQU_F95(AB,R,C,KL,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! DGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE DGBEQU_F95
    PURE SUBROUTINE CGBEQU_F95(AB,R,C,KL,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! CGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE CGBEQU_F95
    PURE SUBROUTINE ZGBEQU_F95(AB,R,C,KL,ROWCND,COLCND,AMAX,INFO)
        ! Fortran77 call:
        ! ZGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        REAL(WP), INTENT(OUT), OPTIONAL :: ROWCND
        REAL(WP), INTENT(OUT), OPTIONAL :: COLCND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: R(:)
        REAL(WP), INTENT(OUT) :: C(:)
    END SUBROUTINE ZGBEQU_F95
END INTERFACE GBEQU

INTERFACE POEQU
    PURE SUBROUTINE SPOEQU_F95(A,S,SCOND,AMAX,INFO)
        ! Fortran77 call:
        ! SPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE SPOEQU_F95
    PURE SUBROUTINE DPOEQU_F95(A,S,SCOND,AMAX,INFO)
        ! Fortran77 call:
        ! DPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE DPOEQU_F95
    PURE SUBROUTINE CPOEQU_F95(A,S,SCOND,AMAX,INFO)
        ! Fortran77 call:
        ! CPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE CPOEQU_F95
    PURE SUBROUTINE ZPOEQU_F95(A,S,SCOND,AMAX,INFO)
        ! Fortran77 call:
        ! ZPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE ZPOEQU_F95
END INTERFACE POEQU

INTERFACE PPEQU
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPEQU_F95(AP,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! SPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE SPPEQU_F95
    PURE SUBROUTINE DPPEQU_F95(AP,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! DPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE DPPEQU_F95
    PURE SUBROUTINE CPPEQU_F95(AP,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! CPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE CPPEQU_F95
    PURE SUBROUTINE ZPPEQU_F95(AP,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE ZPPEQU_F95
END INTERFACE PPEQU

INTERFACE PBEQU
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBEQU_F95(AB,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! SPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE SPBEQU_F95
    PURE SUBROUTINE DPBEQU_F95(AB,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! DPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE DPBEQU_F95
    PURE SUBROUTINE CPBEQU_F95(AB,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! CPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE CPBEQU_F95
    PURE SUBROUTINE ZPBEQU_F95(AB,S,SCOND,AMAX,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT), OPTIONAL :: SCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: AMAX
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
    END SUBROUTINE ZPBEQU_F95
END INTERFACE PBEQU

INTERFACE GESV
    PURE SUBROUTINE SGESV_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! SGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGESV_F95
    PURE SUBROUTINE SGESV1_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! SGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGESV1_F95
    PURE SUBROUTINE DGESV_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! DGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGESV_F95
    PURE SUBROUTINE DGESV1_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! DGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGESV1_F95
    PURE SUBROUTINE CGESV_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! CGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGESV_F95
    PURE SUBROUTINE CGESV1_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! CGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGESV1_F95
    PURE SUBROUTINE ZGESV_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! ZGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGESV_F95
    PURE SUBROUTINE ZGESV1_F95(A,B,IPIV,INFO)
        ! Fortran77 call:
        ! ZGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGESV1_F95
END INTERFACE GESV

INTERFACE GESVX
        ! FACT='N','E','F'; default: 'N'
        ! TRANS='N','C','T'; default: 'N'
        ! EQUED='N','B','C','R'; default: 'N'
        ! Default R(i)=1.0_WP
        ! Default C(i)=1.0_WP
    PURE SUBROUTINE SGESVX_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR, &
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! SGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGESVX_F95
    PURE SUBROUTINE SGESVX1_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR,&
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! SGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE SGESVX1_F95
    PURE SUBROUTINE DGESVX_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR, &
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! DGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGESVX_F95
    PURE SUBROUTINE DGESVX1_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR,&
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! DGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE DGESVX1_F95
    PURE SUBROUTINE CGESVX_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR, &
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! CGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGESVX_F95
    PURE SUBROUTINE CGESVX1_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR,&
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! CGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE CGESVX1_F95
    PURE SUBROUTINE ZGESVX_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR, &
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! ZGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGESVX_F95
    PURE SUBROUTINE ZGESVX1_F95(A,B,X,AF,IPIV,FACT,TRANS,EQUED,R,C,FERR,&
     &                                           BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! ZGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE ZGESVX1_F95
END INTERFACE GESVX

INTERFACE GBSV
    PURE SUBROUTINE SGBSV_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! SGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGBSV_F95
    PURE SUBROUTINE SGBSV1_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! SGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGBSV1_F95
    PURE SUBROUTINE DGBSV_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! DGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGBSV_F95
    PURE SUBROUTINE DGBSV1_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! DGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGBSV1_F95
    PURE SUBROUTINE CGBSV_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! CGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGBSV_F95
    PURE SUBROUTINE CGBSV1_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! CGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGBSV1_F95
    PURE SUBROUTINE ZGBSV_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! ZGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGBSV_F95
    PURE SUBROUTINE ZGBSV1_F95(AB,B,KL,IPIV,INFO)
        ! Fortran77 call:
        ! ZGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGBSV1_F95
END INTERFACE GBSV

INTERFACE GBSVX
        ! FACT='N','E','F'; default: 'N'
        ! TRANS='N','C','T'; default: 'N'
        ! EQUED='N','B','C','R'; default: 'N'
        ! Default R(i)=1.0_WP
        ! Default C(i)=1.0_WP
    PURE SUBROUTINE SGBSVX_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C, &
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! SGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGBSVX_F95
    PURE SUBROUTINE SGBSVX1_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C,&
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! SGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE SGBSVX1_F95
    PURE SUBROUTINE DGBSVX_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C, &
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! DGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGBSVX_F95
    PURE SUBROUTINE DGBSVX1_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C,&
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! DGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE DGBSVX1_F95
    PURE SUBROUTINE CGBSVX_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C, &
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! CGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGBSVX_F95
    PURE SUBROUTINE CGBSVX1_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C,&
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! CGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE CGBSVX1_F95
    PURE SUBROUTINE ZGBSVX_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C, &
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! ZGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGBSVX_F95
    PURE SUBROUTINE ZGBSVX1_F95(AB,B,X,KL,AFB,IPIV,FACT,TRANS,EQUED,R,C,&
     &                                      FERR,BERR,RCOND,RPVGRW,INFO)
        ! Fortran77 call:
        ! ZGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,EQUED,R,
        !   C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        REAL(WP), INTENT(OUT), OPTIONAL :: RPVGRW
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: R(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:)
    END SUBROUTINE ZGBSVX1_F95
END INTERFACE GBSVX

INTERFACE GTSV
    PURE SUBROUTINE SGTSV_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! SGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SGTSV_F95
    PURE SUBROUTINE SGTSV1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! SGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SGTSV1_F95
    PURE SUBROUTINE DGTSV_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! DGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DGTSV_F95
    PURE SUBROUTINE DGTSV1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! DGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DGTSV1_F95
    PURE SUBROUTINE CGTSV_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! CGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CGTSV_F95
    PURE SUBROUTINE CGTSV1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! CGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CGTSV1_F95
    PURE SUBROUTINE ZGTSV_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! ZGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZGTSV_F95
    PURE SUBROUTINE ZGTSV1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! ZGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZGTSV1_F95
END INTERFACE GTSV

INTERFACE GTSVX
        ! FACT='N','F'; default: 'N'
        ! TRANS='N','C','T'; default: 'N'
    PURE SUBROUTINE SGTSVX_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,    &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! SGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SGTSVX_F95
    PURE SUBROUTINE SGTSVX1_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,   &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! SGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SGTSVX1_F95
    PURE SUBROUTINE DGTSVX_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,    &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! DGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DGTSVX_F95
    PURE SUBROUTINE DGTSVX1_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,   &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! DGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: DL(:)
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DGTSVX1_F95
    PURE SUBROUTINE CGTSVX_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,    &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! CGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CGTSVX_F95
    PURE SUBROUTINE CGTSVX1_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,   &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! CGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CGTSVX1_F95
    PURE SUBROUTINE ZGTSVX_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,    &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! ZGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZGTSVX_F95
    PURE SUBROUTINE ZGTSVX1_F95(DL,D,DU,B,X,DLF,DF,DUF,DU2,IPIV,FACT,   &
     &                                       TRANS,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! ZGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: DL(:)
        COMPLEX(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DLF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DUF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: DU2(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZGTSVX1_F95
END INTERFACE GTSVX

INTERFACE DTSVB
    PURE SUBROUTINE SDTSVB_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! SDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SDTSVB_F95
    PURE SUBROUTINE SDTSVB1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! SDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SDTSVB1_F95
    PURE SUBROUTINE DDTSVB_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! DDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DDTSVB_F95
    PURE SUBROUTINE DDTSVB1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! DDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: DL(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(IN) :: DU(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DDTSVB1_F95
    PURE SUBROUTINE CDTSVB_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! CDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CDTSVB_F95
    PURE SUBROUTINE CDTSVB1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! CDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CDTSVB1_F95
    PURE SUBROUTINE ZDTSVB_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! ZDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZDTSVB_F95
    PURE SUBROUTINE ZDTSVB1_F95(DL,D,DU,B,INFO)
        ! Fortran77 call:
        ! ZDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: DL(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(IN) :: DU(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZDTSVB1_F95
END INTERFACE DTSVB

INTERFACE POSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPOSV_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPOSV_F95
    PURE SUBROUTINE SPOSV1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPOSV1_F95
    PURE SUBROUTINE DPOSV_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPOSV_F95
    PURE SUBROUTINE DPOSV1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPOSV1_F95
    PURE SUBROUTINE CPOSV_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPOSV_F95
    PURE SUBROUTINE CPOSV1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPOSV1_F95
    PURE SUBROUTINE ZPOSV_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPOSV_F95
    PURE SUBROUTINE ZPOSV1_F95(A,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPOSV1_F95
END INTERFACE POSV

INTERFACE POSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','E','F'; default: 'N'
        ! EQUED='N','Y'; default: 'N'
        ! Default S(i)=1.0_WP
    PURE SUBROUTINE SPOSVX_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPOSVX_F95
    PURE SUBROUTINE SPOSVX1_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,   &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SPOSVX1_F95
    PURE SUBROUTINE DPOSVX_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPOSVX_F95
    PURE SUBROUTINE DPOSVX1_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,   &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DPOSVX1_F95
    PURE SUBROUTINE CPOSVX_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPOSVX_F95
    PURE SUBROUTINE CPOSVX1_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,   &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CPOSVX1_F95
    PURE SUBROUTINE ZPOSVX_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPOSVX_F95
    PURE SUBROUTINE ZPOSVX1_F95(A,B,X,UPLO,AF,FACT,EQUED,S,FERR,BERR,   &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,LDX,
        !   RCOND,FERR,BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZPOSVX1_F95
END INTERFACE POSVX

INTERFACE PPSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPPSV_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPPSV_F95
    PURE SUBROUTINE SPPSV1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPPSV1_F95
    PURE SUBROUTINE DPPSV_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPPSV_F95
    PURE SUBROUTINE DPPSV1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPPSV1_F95
    PURE SUBROUTINE CPPSV_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPPSV_F95
    PURE SUBROUTINE CPPSV1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPPSV1_F95
    PURE SUBROUTINE ZPPSV_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPPSV_F95
    PURE SUBROUTINE ZPPSV1_F95(AP,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPPSV1_F95
END INTERFACE PPSV

INTERFACE PPSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','E','F'; default: 'N'
        ! EQUED='N','Y'; default: 'N'
        ! Default S(i)=1.0_WP
    PURE SUBROUTINE SPPSVX_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPPSVX_F95
    PURE SUBROUTINE SPPSVX1_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SPPSVX1_F95
    PURE SUBROUTINE DPPSVX_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPPSVX_F95
    PURE SUBROUTINE DPPSVX1_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DPPSVX1_F95
    PURE SUBROUTINE CPPSVX_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPPSVX_F95
    PURE SUBROUTINE CPPSVX1_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CPPSVX1_F95
    PURE SUBROUTINE ZPPSVX_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPPSVX_F95
    PURE SUBROUTINE ZPPSVX1_F95(AP,B,X,UPLO,AFP,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZPPSVX1_F95
END INTERFACE PPSVX

INTERFACE PBSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBSV_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPBSV_F95
    PURE SUBROUTINE SPBSV1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! SPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPBSV1_F95
    PURE SUBROUTINE DPBSV_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPBSV_F95
    PURE SUBROUTINE DPBSV1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! DPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPBSV1_F95
    PURE SUBROUTINE CPBSV_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPBSV_F95
    PURE SUBROUTINE CPBSV1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! CPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPBSV1_F95
    PURE SUBROUTINE ZPBSV_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPBSV_F95
    PURE SUBROUTINE ZPBSV1_F95(AB,B,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPBSV1_F95
END INTERFACE PBSV

INTERFACE PBSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','E','F'; default: 'N'
        ! EQUED='N','Y'; default: 'N'
        ! Default S(i)=1.0_WP
    PURE SUBROUTINE SPBSVX_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPBSVX_F95
    PURE SUBROUTINE SPBSVX1_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SPBSVX1_F95
    PURE SUBROUTINE DPBSVX_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPBSVX_F95
    PURE SUBROUTINE DPBSVX1_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DPBSVX1_F95
    PURE SUBROUTINE CPBSVX_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPBSVX_F95
    PURE SUBROUTINE CPBSVX1_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CPBSVX1_F95
    PURE SUBROUTINE ZPBSVX_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR,  &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPBSVX_F95
    PURE SUBROUTINE ZPBSVX1_F95(AB,B,X,UPLO,AFB,FACT,EQUED,S,FERR,BERR, &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S,B,LDB,X,
        !   LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        CHARACTER(LEN=1), INTENT(INOUT), OPTIONAL :: EQUED
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZPBSVX1_F95
END INTERFACE PBSVX

INTERFACE PTSV
    PURE SUBROUTINE SPTSV_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! SPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SPTSV_F95
    PURE SUBROUTINE SPTSV1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! SPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SPTSV1_F95
    PURE SUBROUTINE DPTSV_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! DPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DPTSV_F95
    PURE SUBROUTINE DPTSV1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! DPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DPTSV1_F95
    PURE SUBROUTINE CPTSV_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! CPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CPTSV_F95
    PURE SUBROUTINE CPTSV1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! CPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CPTSV1_F95
    PURE SUBROUTINE ZPTSV_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! ZPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZPTSV_F95
    PURE SUBROUTINE ZPTSV1_F95(D,E,B,INFO)
        ! Fortran77 call:
        ! ZPTSV(N,NRHS,D,E,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZPTSV1_F95
END INTERFACE PTSV

INTERFACE PTSVX
        ! FACT='N','F'; default: 'N'
    PURE SUBROUTINE SPTSVX_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! SPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SPTSVX_F95
    PURE SUBROUTINE SPTSVX1_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! SPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
    END SUBROUTINE SPTSVX1_F95
    PURE SUBROUTINE DPTSVX_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! DPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DPTSVX_F95
    PURE SUBROUTINE DPTSVX1_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! DPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
    END SUBROUTINE DPTSVX1_F95
    PURE SUBROUTINE CPTSVX_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! CPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CPTSVX_F95
    PURE SUBROUTINE CPTSVX1_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! CPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
    END SUBROUTINE CPTSVX1_F95
    PURE SUBROUTINE ZPTSVX_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! ZPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZPTSVX_F95
    PURE SUBROUTINE ZPTSVX1_F95(D,E,B,X,DF,EF,FACT,FERR,BERR,RCOND,INFO)
        ! Fortran77 call:
        ! ZPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        COMPLEX(WP), INTENT(IN) :: E(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: DF(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: EF(:)
    END SUBROUTINE ZPTSVX1_F95
END INTERFACE PTSVX

INTERFACE SYSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYSV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYSV_F95
    PURE SUBROUTINE SSYSV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYSV1_F95
    PURE SUBROUTINE DSYSV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYSV_F95
    PURE SUBROUTINE DSYSV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYSV1_F95
    PURE SUBROUTINE CSYSV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYSV_F95
    PURE SUBROUTINE CSYSV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYSV1_F95
    PURE SUBROUTINE ZSYSV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYSV_F95
    PURE SUBROUTINE ZSYSV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYSV1_F95
END INTERFACE SYSV

INTERFACE SYSV_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYSV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYSV_ROOK_F95
    PURE SUBROUTINE SSYSV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYSV1_ROOK_F95
    PURE SUBROUTINE DSYSV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYSV_ROOK_F95
    PURE SUBROUTINE DSYSV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYSV1_ROOK_F95
    PURE SUBROUTINE CSYSV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYSV_ROOK_F95
    PURE SUBROUTINE CSYSV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYSV1_ROOK_F95
    PURE SUBROUTINE ZSYSV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYSV_ROOK_F95
    PURE SUBROUTINE ZSYSV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYSV1_ROOK_F95
END INTERFACE SYSV_ROOK

INTERFACE SYSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','F'; default: 'N'
    PURE SUBROUTINE SSYSVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! SSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SSYSVX_F95
    PURE SUBROUTINE SSYSVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! SSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSYSVX1_F95
    PURE SUBROUTINE DSYSVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! DSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DSYSVX_F95
    PURE SUBROUTINE DSYSVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! DSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSYSVX1_F95
    PURE SUBROUTINE CSYSVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! CSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CSYSVX_F95
    PURE SUBROUTINE CSYSVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! CSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSYSVX1_F95
    PURE SUBROUTINE ZSYSVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! ZSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZSYSVX_F95
    PURE SUBROUTINE ZSYSVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! ZSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSYSVX1_F95
END INTERFACE SYSVX

INTERFACE HESVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','F'; default: 'N'
    PURE SUBROUTINE CHESVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! CHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CHESVX_F95
    PURE SUBROUTINE CHESVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! CHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHESVX1_F95
    PURE SUBROUTINE ZHESVX_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND, &
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZHESVX_F95
    PURE SUBROUTINE ZHESVX1_F95(A,B,X,UPLO,AF,IPIV,FACT,FERR,BERR,RCOND,&
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,RCOND,
        !   FERR,BERR,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AF(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHESVX1_F95
END INTERFACE HESVX

INTERFACE HESV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHESV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHESV_F95
    PURE SUBROUTINE CHESV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHESV1_F95
    PURE SUBROUTINE ZHESV_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHESV_F95
    PURE SUBROUTINE ZHESV1_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHESV1_F95
END INTERFACE HESV

INTERFACE HESV_ROOK
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHESV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHESV_ROOK_F95
    PURE SUBROUTINE CHESV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHESV1_ROOK_F95
    PURE SUBROUTINE ZHESV_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHESV_ROOK_F95
    PURE SUBROUTINE ZHESV1_ROOK_F95(A,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHESV1_ROOK_F95
END INTERFACE HESV_ROOK

INTERFACE SPSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSPSV_F95
    PURE SUBROUTINE SSPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! SSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSPSV1_F95
    PURE SUBROUTINE DSPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSPSV_F95
    PURE SUBROUTINE DSPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! DSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSPSV1_F95
    PURE SUBROUTINE CSPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSPSV_F95
    PURE SUBROUTINE CSPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSPSV1_F95
    PURE SUBROUTINE ZSPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSPSV_F95
    PURE SUBROUTINE ZSPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSPSV1_F95
END INTERFACE SPSV

INTERFACE SPSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','F'; default: 'N'
    PURE SUBROUTINE SSPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE SSPSVX_F95
    PURE SUBROUTINE SSPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! SSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE SSPSVX1_F95
    PURE SUBROUTINE DSPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT) :: X(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE DSPSVX_F95
    PURE SUBROUTINE DSPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! DSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: B(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE DSPSVX1_F95
    PURE SUBROUTINE CSPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CSPSVX_F95
    PURE SUBROUTINE CSPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CSPSVX1_F95
    PURE SUBROUTINE ZSPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZSPSVX_F95
    PURE SUBROUTINE ZSPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZSPSVX1_F95
END INTERFACE SPSVX

INTERFACE HPSVX
        ! UPLO='U','L'; default: 'U'
        ! FACT='N','F'; default: 'N'
    PURE SUBROUTINE CHPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE CHPSVX_F95
    PURE SUBROUTINE CHPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! CHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHPSVX1_F95
    PURE SUBROUTINE ZHPSVX_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,     &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: X(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: FERR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BERR(:)
    END SUBROUTINE ZHPSVX_F95
    PURE SUBROUTINE ZHPSVX1_F95(AP,B,X,UPLO,AFP,IPIV,FACT,FERR,BERR,    &
     &                                                       RCOND,INFO)
        ! Fortran77 call:
        ! ZHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,FERR,
        !   BERR,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: FACT
        REAL(WP), INTENT(OUT), OPTIONAL :: FERR
        REAL(WP), INTENT(OUT), OPTIONAL :: BERR
        REAL(WP), INTENT(OUT), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: B(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: AFP(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHPSVX1_F95
END INTERFACE HPSVX

INTERFACE HPSV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHPSV_F95
    PURE SUBROUTINE CHPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! CHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE CHPSV1_F95
    PURE SUBROUTINE ZHPSV_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHPSV_F95
    PURE SUBROUTINE ZHPSV1_F95(AP,B,UPLO,IPIV,INFO)
        ! Fortran77 call:
        ! ZHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IPIV(:)
    END SUBROUTINE ZHPSV1_F95
END INTERFACE HPSV

INTERFACE GEQRF
    PURE SUBROUTINE SGEQRF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGEQRF_F95
    PURE SUBROUTINE DGEQRF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGEQRF_F95
    PURE SUBROUTINE CGEQRF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGEQRF_F95
    PURE SUBROUTINE ZGEQRF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGEQRF_F95
END INTERFACE GEQRF

INTERFACE GEQPF
    PURE SUBROUTINE SGEQPF_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! SGEQPF(M,N,A,LDA,JPVT,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGEQPF_F95
    PURE SUBROUTINE DGEQPF_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! DGEQPF(M,N,A,LDA,JPVT,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGEQPF_F95
    PURE SUBROUTINE CGEQPF_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! CGEQPF(M,N,A,LDA,JPVT,TAU,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGEQPF_F95
    PURE SUBROUTINE ZGEQPF_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! ZGEQPF(M,N,A,LDA,JPVT,TAU,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGEQPF_F95
END INTERFACE GEQPF

INTERFACE GEQP3
    PURE SUBROUTINE SGEQP3_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! SGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGEQP3_F95
    PURE SUBROUTINE DGEQP3_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! DGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGEQP3_F95
    PURE SUBROUTINE CGEQP3_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! CGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGEQP3_F95
    PURE SUBROUTINE ZGEQP3_F95(A,JPVT,TAU,INFO)
        ! Fortran77 call:
        ! ZGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(INOUT) :: JPVT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGEQP3_F95
END INTERFACE GEQP3

INTERFACE ORGQR
    PURE SUBROUTINE SORGQR_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SORGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGQR_F95
    PURE SUBROUTINE DORGQR_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DORGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGQR_F95
END INTERFACE ORGQR

INTERFACE ORMQR
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMQR_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMQR_F95
    PURE SUBROUTINE DORMQR_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMQR_F95
END INTERFACE ORMQR

INTERFACE UNGQR
    PURE SUBROUTINE CUNGQR_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CUNGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGQR_F95
    PURE SUBROUTINE ZUNGQR_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZUNGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGQR_F95
END INTERFACE UNGQR

INTERFACE UNMQR
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMQR_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMQR_F95
    PURE SUBROUTINE ZUNMQR_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMQR_F95
END INTERFACE UNMQR

INTERFACE GELQF
    PURE SUBROUTINE SGELQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGELQF_F95
    PURE SUBROUTINE DGELQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGELQF_F95
    PURE SUBROUTINE CGELQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGELQF_F95
    PURE SUBROUTINE ZGELQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGELQF_F95
END INTERFACE GELQF

INTERFACE ORGLQ
    PURE SUBROUTINE SORGLQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SORGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGLQ_F95
    PURE SUBROUTINE DORGLQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DORGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGLQ_F95
END INTERFACE ORGLQ

INTERFACE ORMLQ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMLQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMLQ_F95
    PURE SUBROUTINE DORMLQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMLQ_F95
END INTERFACE ORMLQ

INTERFACE UNGLQ
    PURE SUBROUTINE CUNGLQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CUNGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGLQ_F95
    PURE SUBROUTINE ZUNGLQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZUNGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGLQ_F95
END INTERFACE UNGLQ

INTERFACE UNMLQ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMLQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMLQ_F95
    PURE SUBROUTINE ZUNMLQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMLQ_F95
END INTERFACE UNMLQ

INTERFACE GEQLF
    PURE SUBROUTINE SGEQLF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGEQLF_F95
    PURE SUBROUTINE DGEQLF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGEQLF_F95
    PURE SUBROUTINE CGEQLF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGEQLF_F95
    PURE SUBROUTINE ZGEQLF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGEQLF_F95
END INTERFACE GEQLF

INTERFACE ORGQL
    PURE SUBROUTINE SORGQL_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SORGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGQL_F95
    PURE SUBROUTINE DORGQL_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DORGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGQL_F95
END INTERFACE ORGQL

INTERFACE UNGQL
    PURE SUBROUTINE CUNGQL_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CUNGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGQL_F95
    PURE SUBROUTINE ZUNGQL_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZUNGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGQL_F95
END INTERFACE UNGQL

INTERFACE ORMQL
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMQL_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMQL_F95
    PURE SUBROUTINE DORMQL_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMQL_F95
END INTERFACE ORMQL

INTERFACE UNMQL
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMQL_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMQL_F95
    PURE SUBROUTINE ZUNMQL_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMQL_F95
END INTERFACE UNMQL

INTERFACE GERQF
    PURE SUBROUTINE SGERQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGERQF_F95
    PURE SUBROUTINE DGERQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGERQF_F95
    PURE SUBROUTINE CGERQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGERQF_F95
    PURE SUBROUTINE ZGERQF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGERQF_F95
END INTERFACE GERQF

INTERFACE ORGRQ
    PURE SUBROUTINE SORGRQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! SORGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGRQ_F95
    PURE SUBROUTINE DORGRQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DORGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGRQ_F95
END INTERFACE ORGRQ

INTERFACE UNGRQ
    PURE SUBROUTINE CUNGRQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CUNGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGRQ_F95
    PURE SUBROUTINE ZUNGRQ_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZUNGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGRQ_F95
END INTERFACE UNGRQ

INTERFACE ORMRQ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMRQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMRQ_F95
    PURE SUBROUTINE DORMRQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMRQ_F95
END INTERFACE ORMRQ

INTERFACE UNMRQ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMRQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMRQ_F95
    PURE SUBROUTINE ZUNMRQ_F95(A,TAU,C,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMRQ_F95
END INTERFACE UNMRQ

INTERFACE TZRZF
    PURE SUBROUTINE STZRZF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! STZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE STZRZF_F95
    PURE SUBROUTINE DTZRZF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! DTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DTZRZF_F95
    PURE SUBROUTINE CTZRZF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! CTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CTZRZF_F95
    PURE SUBROUTINE ZTZRZF_F95(A,TAU,INFO)
        ! Fortran77 call:
        ! ZTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZTZRZF_F95
END INTERFACE TZRZF

INTERFACE ORMRZ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMRZ_F95(A,TAU,C,L,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMRZ_F95
    PURE SUBROUTINE DORMRZ_F95(A,TAU,C,L,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMRZ_F95
END INTERFACE ORMRZ

INTERFACE UNMRZ
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMRZ_F95(A,TAU,C,L,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMRZ_F95
    PURE SUBROUTINE ZUNMRZ_F95(A,TAU,C,L,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMRZ_F95
END INTERFACE UNMRZ

INTERFACE GGQRF
    PURE SUBROUTINE SGGQRF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! SGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE SGGQRF_F95
    PURE SUBROUTINE DGGQRF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! DGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE DGGQRF_F95
    PURE SUBROUTINE CGGQRF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! CGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE CGGQRF_F95
    PURE SUBROUTINE ZGGQRF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! ZGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE ZGGQRF_F95
END INTERFACE GGQRF

INTERFACE GGRQF
    PURE SUBROUTINE SGGRQF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! SGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE SGGRQF_F95
    PURE SUBROUTINE DGGRQF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! DGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE DGGRQF_F95
    PURE SUBROUTINE CGGRQF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! CGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE CGGRQF_F95
    PURE SUBROUTINE ZGGRQF_F95(A,B,TAUA,TAUB,INFO)
        ! Fortran77 call:
        ! ZGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUB(:)
    END SUBROUTINE ZGGRQF_F95
END INTERFACE GGRQF

INTERFACE GEBRD
    PURE SUBROUTINE SGEBRD_F95(A,D,E,TAUQ,TAUP,INFO)
        ! Fortran77 call:
        ! SGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUQ(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUP(:)
    END SUBROUTINE SGEBRD_F95
    PURE SUBROUTINE DGEBRD_F95(A,D,E,TAUQ,TAUP,INFO)
        ! Fortran77 call:
        ! DGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUQ(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUP(:)
    END SUBROUTINE DGEBRD_F95
    PURE SUBROUTINE CGEBRD_F95(A,D,E,TAUQ,TAUP,INFO)
        ! Fortran77 call:
        ! CGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUQ(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUP(:)
    END SUBROUTINE CGEBRD_F95
    PURE SUBROUTINE ZGEBRD_F95(A,D,E,TAUQ,TAUP,INFO)
        ! Fortran77 call:
        ! ZGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUQ(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAUP(:)
    END SUBROUTINE ZGEBRD_F95
END INTERFACE GEBRD

INTERFACE GBBRD
    PURE SUBROUTINE SGBBRD_F95(AB,C,D,E,Q,PT,KL,M,INFO)
        ! Fortran77 call:
        ! SGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,LDC,
        !   WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: PT(:,:)
    END SUBROUTINE SGBBRD_F95
    PURE SUBROUTINE DGBBRD_F95(AB,C,D,E,Q,PT,KL,M,INFO)
        ! Fortran77 call:
        ! DGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,LDC,
        !   WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: PT(:,:)
    END SUBROUTINE DGBBRD_F95
    PURE SUBROUTINE CGBBRD_F95(AB,C,D,E,Q,PT,KL,M,INFO)
        ! Fortran77 call:
        ! CGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,LDC,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: PT(:,:)
    END SUBROUTINE CGBBRD_F95
    PURE SUBROUTINE ZGBBRD_F95(AB,C,D,E,Q,PT,KL,M,INFO)
        ! Fortran77 call:
        ! ZGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,LDC,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: KL
        INTEGER, INTENT(IN), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: E(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: PT(:,:)
    END SUBROUTINE ZGBBRD_F95
END INTERFACE GBBRD

INTERFACE ORGBR
        ! VECT='Q','P'; default: 'Q'
    PURE SUBROUTINE SORGBR_F95(A,TAU,VECT,INFO)
        ! Fortran77 call:
        ! SORGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGBR_F95
    PURE SUBROUTINE DORGBR_F95(A,TAU,VECT,INFO)
        ! Fortran77 call:
        ! DORGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGBR_F95
END INTERFACE ORGBR

INTERFACE ORMBR
        ! VECT='Q','P'; default: 'Q'
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMBR_F95(A,TAU,C,VECT,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMBR_F95
    PURE SUBROUTINE DORMBR_F95(A,TAU,C,VECT,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMBR_F95
END INTERFACE ORMBR

INTERFACE UNGBR
        ! VECT='Q','P'; default: 'Q'
    PURE SUBROUTINE CUNGBR_F95(A,TAU,VECT,INFO)
        ! Fortran77 call:
        ! CUNGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGBR_F95
    PURE SUBROUTINE ZUNGBR_F95(A,TAU,VECT,INFO)
        ! Fortran77 call:
        ! ZUNGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGBR_F95
END INTERFACE UNGBR

INTERFACE UNMBR
        ! VECT='Q','P'; default: 'Q'
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMBR_F95(A,TAU,C,VECT,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMBR_F95
    PURE SUBROUTINE ZUNMBR_F95(A,TAU,C,VECT,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMBR_F95
END INTERFACE UNMBR

INTERFACE RBDSQR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SBDSQR_F95(D,E,VT,U,C,UPLO,INFO)
        ! Fortran77 call:
        ! SBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
    END SUBROUTINE SBDSQR_F95
    PURE SUBROUTINE DBDSQR_F95(D,E,VT,U,C,UPLO,INFO)
        ! Fortran77 call:
        ! DBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
    END SUBROUTINE DBDSQR_F95
END INTERFACE RBDSQR

INTERFACE BDSQR
    PURE SUBROUTINE CBDSQR_F95(D,E,VT,U,C,UPLO,INFO)
        ! Fortran77 call:
        ! CBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VT(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
    END SUBROUTINE CBDSQR_F95
    PURE SUBROUTINE ZBDSQR_F95(D,E,VT,U,C,UPLO,INFO)
        ! Fortran77 call:
        ! ZBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VT(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: C(:,:)
    END SUBROUTINE ZBDSQR_F95
END INTERFACE BDSQR

INTERFACE BDSDC
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SBDSDC_F95(D,E,U,VT,Q,IQ,UPLO,INFO)
        ! Fortran77 call:
        ! SBDSDC(UPLO,COMPQ,N,D,E,U,LDU,VT,LDVT,Q,IQ,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IQ(:)
    END SUBROUTINE SBDSDC_F95
    PURE SUBROUTINE DBDSDC_F95(D,E,U,VT,Q,IQ,UPLO,INFO)
        ! Fortran77 call:
        ! DBDSDC(UPLO,COMPQ,N,D,E,U,LDU,VT,LDVT,Q,IQ,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IQ(:)
    END SUBROUTINE DBDSDC_F95
END INTERFACE BDSDC

INTERFACE SYTRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRD_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE SSYTRD_F95
    PURE SUBROUTINE DSYTRD_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE DSYTRD_F95
END INTERFACE SYTRD

INTERFACE ORGTR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SORGTR_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! SORGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGTR_F95
    PURE SUBROUTINE DORGTR_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! DORGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGTR_F95
END INTERFACE ORGTR

INTERFACE ORMTR
        ! SIDE='L','R'; default: 'L'
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMTR_F95(A,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! SORMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMTR_F95
    PURE SUBROUTINE DORMTR_F95(A,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! DORMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMTR_F95
END INTERFACE ORMTR

INTERFACE HETRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRD_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE CHETRD_F95
    PURE SUBROUTINE ZHETRD_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE ZHETRD_F95
END INTERFACE HETRD

INTERFACE UNGTR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CUNGTR_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! CUNGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGTR_F95
    PURE SUBROUTINE ZUNGTR_F95(A,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! ZUNGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGTR_F95
END INTERFACE UNGTR

INTERFACE UNMTR
        ! SIDE='L','R'; default: 'L'
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMTR_F95(A,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMTR_F95
    PURE SUBROUTINE ZUNMTR_F95(A,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMTR_F95
END INTERFACE UNMTR

INTERFACE SPTRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPTRD_F95(AP,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! SSPTRD(UPLO,N,AP,D,E,TAU,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE SSPTRD_F95
    PURE SUBROUTINE DSPTRD_F95(AP,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! DSPTRD(UPLO,N,AP,D,E,TAU,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE DSPTRD_F95
END INTERFACE SPTRD

INTERFACE OPGTR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SOPGTR_F95(AP,TAU,Q,UPLO,INFO)
        ! Fortran77 call:
        ! SOPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(OUT) :: Q(:,:)
    END SUBROUTINE SOPGTR_F95
    PURE SUBROUTINE DOPGTR_F95(AP,TAU,Q,UPLO,INFO)
        ! Fortran77 call:
        ! DOPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(OUT) :: Q(:,:)
    END SUBROUTINE DOPGTR_F95
END INTERFACE OPGTR

INTERFACE OPMTR
        ! SIDE='L','R'; default: 'L'
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SOPMTR_F95(AP,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! SOPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SOPMTR_F95
    PURE SUBROUTINE DOPMTR_F95(AP,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! DOPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DOPMTR_F95
END INTERFACE OPMTR

INTERFACE HPTRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPTRD_F95(AP,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! CHPTRD(UPLO,N,AP,D,E,TAU,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE CHPTRD_F95
    PURE SUBROUTINE ZHPTRD_F95(AP,TAU,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPTRD(UPLO,N,AP,D,E,TAU,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(OUT) :: TAU(:)
    END SUBROUTINE ZHPTRD_F95
END INTERFACE HPTRD

INTERFACE UPGTR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CUPGTR_F95(AP,TAU,Q,UPLO,INFO)
        ! Fortran77 call:
        ! CUPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(OUT) :: Q(:,:)
    END SUBROUTINE CUPGTR_F95
    PURE SUBROUTINE ZUPGTR_F95(AP,TAU,Q,UPLO,INFO)
        ! Fortran77 call:
        ! ZUPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(OUT) :: Q(:,:)
    END SUBROUTINE ZUPGTR_F95
END INTERFACE UPGTR

INTERFACE UPMTR
        ! SIDE='L','R'; default: 'L'
        ! UPLO='U','L'; default: 'U'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUPMTR_F95(AP,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! CUPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUPMTR_F95
    PURE SUBROUTINE ZUPMTR_F95(AP,TAU,C,SIDE,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! ZUPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUPMTR_F95
END INTERFACE UPMTR

INTERFACE SBTRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBTRD_F95(AB,Q,VECT,UPLO,INFO)
        ! Fortran77 call:
        ! SSBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE SSBTRD_F95
    PURE SUBROUTINE DSBTRD_F95(AB,Q,VECT,UPLO,INFO)
        ! Fortran77 call:
        ! DSBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DSBTRD_F95
END INTERFACE SBTRD

INTERFACE HBTRD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBTRD_F95(AB,Q,VECT,UPLO,INFO)
        ! Fortran77 call:
        ! CHBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CHBTRD_F95
    PURE SUBROUTINE ZHBTRD_F95(AB,Q,VECT,UPLO,INFO)
        ! Fortran77 call:
        ! ZHBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: VECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZHBTRD_F95
END INTERFACE HBTRD

INTERFACE STERF
    PURE SUBROUTINE SSTERF_F95(D,E,INFO)
        ! Fortran77 call:
        ! SSTERF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE SSTERF_F95
    PURE SUBROUTINE DSTERF_F95(D,E,INFO)
        ! Fortran77 call:
        ! DSTERF(N,D,E,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
    END SUBROUTINE DSTERF_F95
END INTERFACE STERF

INTERFACE RSTEQR
    PURE SUBROUTINE SSTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! SSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSTEQR_F95
    PURE SUBROUTINE DSTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! DSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSTEQR_F95
END INTERFACE RSTEQR

INTERFACE STEQR
    PURE SUBROUTINE CSTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! CSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CSTEQR_F95
    PURE SUBROUTINE ZSTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! ZSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZSTEQR_F95
END INTERFACE STEQR

INTERFACE RSTEDC
    PURE SUBROUTINE SSTEDC_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! SSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSTEDC_F95
    PURE SUBROUTINE DSTEDC_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! DSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSTEDC_F95
END INTERFACE RSTEDC

INTERFACE STEDC
    PURE SUBROUTINE CSTEDC_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! CSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CSTEDC_F95
    PURE SUBROUTINE ZSTEDC_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! ZSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZSTEDC_F95
END INTERFACE STEDC

INTERFACE RSTEGR
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSTEGR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! SSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE SSTEGR_F95
    PURE SUBROUTINE DSTEGR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! DSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE DSTEGR_F95
END INTERFACE RSTEGR

INTERFACE STEGR
    PURE SUBROUTINE CSTEGR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! CSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE CSTEGR_F95
    PURE SUBROUTINE ZSTEGR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! ZSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE ZSTEGR_F95
END INTERFACE STEGR

INTERFACE RPTEQR
    PURE SUBROUTINE SPTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! SPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SPTEQR_F95
    PURE SUBROUTINE DPTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! DPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DPTEQR_F95
END INTERFACE RPTEQR

INTERFACE PTEQR
    PURE SUBROUTINE CPTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! CPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CPTEQR_F95
    PURE SUBROUTINE ZPTEQR_F95(D,E,Z,COMPZ,INFO)
        ! Fortran77 call:
        ! ZPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZPTEQR_F95
END INTERFACE PTEQR

INTERFACE STEBZ
        ! ORDER='B','E'; default: 'B'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSTEBZ_F95(D,E,M,NSPLIT,W,IBLOCK,ISPLIT,ORDER,VL,VU,&
     &                                                IL,IU,ABSTOL,INFO)
        ! Fortran77 call:
        ! SSTEBZ(RANGE,ORDER,N,VL,VU,IL,IU,ABSTOL,D,E,M,NSPLIT,W,IBLOCK,
        !   ISPLIT,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT) :: M
        INTEGER, INTENT(OUT) :: NSPLIT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: ORDER
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        INTEGER, INTENT(OUT) :: IBLOCK(:)
        INTEGER, INTENT(OUT) :: ISPLIT(:)
    END SUBROUTINE SSTEBZ_F95
    PURE SUBROUTINE DSTEBZ_F95(D,E,M,NSPLIT,W,IBLOCK,ISPLIT,ORDER,VL,VU,&
     &                                                IL,IU,ABSTOL,INFO)
        ! Fortran77 call:
        ! DSTEBZ(RANGE,ORDER,N,VL,VU,IL,IU,ABSTOL,D,E,M,NSPLIT,W,IBLOCK,
        !   ISPLIT,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT) :: M
        INTEGER, INTENT(OUT) :: NSPLIT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: ORDER
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        INTEGER, INTENT(OUT) :: IBLOCK(:)
        INTEGER, INTENT(OUT) :: ISPLIT(:)
    END SUBROUTINE DSTEBZ_F95
END INTERFACE STEBZ

INTERFACE STEIN
    PURE SUBROUTINE SSTEIN_F95(D,E,W,IBLOCK,ISPLIT,Z,IFAILV,INFO)
        ! Fortran77 call:
        ! SSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,IFAILV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: W(:)
        INTEGER, INTENT(IN) :: IBLOCK(:)
        INTEGER, INTENT(IN) :: ISPLIT(:)
        REAL(WP), INTENT(OUT) :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILV(:)
    END SUBROUTINE SSTEIN_F95
    PURE SUBROUTINE DSTEIN_F95(D,E,W,IBLOCK,ISPLIT,Z,IFAILV,INFO)
        ! Fortran77 call:
        ! DSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,IFAILV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: W(:)
        INTEGER, INTENT(IN) :: IBLOCK(:)
        INTEGER, INTENT(IN) :: ISPLIT(:)
        REAL(WP), INTENT(OUT) :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILV(:)
    END SUBROUTINE DSTEIN_F95
    PURE SUBROUTINE CSTEIN_F95(D,E,W,IBLOCK,ISPLIT,Z,IFAILV,INFO)
        ! Fortran77 call:
        ! CSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,IFAILV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: W(:)
        INTEGER, INTENT(IN) :: IBLOCK(:)
        INTEGER, INTENT(IN) :: ISPLIT(:)
        COMPLEX(WP), INTENT(OUT) :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILV(:)
    END SUBROUTINE CSTEIN_F95
    PURE SUBROUTINE ZSTEIN_F95(D,E,W,IBLOCK,ISPLIT,Z,IFAILV,INFO)
        ! Fortran77 call:
        ! ZSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,IFAILV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(IN) :: E(:)
        REAL(WP), INTENT(IN) :: W(:)
        INTEGER, INTENT(IN) :: IBLOCK(:)
        INTEGER, INTENT(IN) :: ISPLIT(:)
        COMPLEX(WP), INTENT(OUT) :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILV(:)
    END SUBROUTINE ZSTEIN_F95
END INTERFACE STEIN

INTERFACE DISNA
        ! JOB='E','L','R'; default: 'E'
        ! MINMN='M','N'; default: 'M';  Superfluous if JOB='E'
    PURE SUBROUTINE SDISNA_F95(D,SEP,JOB,MINMN,INFO)
        ! Fortran77 call:
        ! SDISNA(JOB,M,N,D,SEP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: MINMN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(OUT) :: SEP(:)
    END SUBROUTINE SDISNA_F95
    PURE SUBROUTINE DDISNA_F95(D,SEP,JOB,MINMN,INFO)
        ! Fortran77 call:
        ! DDISNA(JOB,M,N,D,SEP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: MINMN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: D(:)
        REAL(WP), INTENT(OUT) :: SEP(:)
    END SUBROUTINE DDISNA_F95
END INTERFACE DISNA

INTERFACE SYGST
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYGST_F95(A,B,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! SSYGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
    END SUBROUTINE SSYGST_F95
    PURE SUBROUTINE DSYGST_F95(A,B,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! DSYGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
    END SUBROUTINE DSYGST_F95
END INTERFACE SYGST

INTERFACE HEGST
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHEGST_F95(A,B,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! CHEGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
    END SUBROUTINE CHEGST_F95
    PURE SUBROUTINE ZHEGST_F95(A,B,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! ZHEGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
    END SUBROUTINE ZHEGST_F95
END INTERFACE HEGST

INTERFACE SPGST
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPGST_F95(AP,BP,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! SSPGST(ITYPE,UPLO,N,AP,BP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(IN) :: BP(:)
    END SUBROUTINE SSPGST_F95
    PURE SUBROUTINE DSPGST_F95(AP,BP,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! DSPGST(ITYPE,UPLO,N,AP,BP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(IN) :: BP(:)
    END SUBROUTINE DSPGST_F95
END INTERFACE SPGST

INTERFACE HPGST
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPGST_F95(AP,BP,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! CHPGST(ITYPE,UPLO,N,AP,BP,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: BP(:)
    END SUBROUTINE CHPGST_F95
    PURE SUBROUTINE ZHPGST_F95(AP,BP,ITYPE,UPLO,INFO)
        ! Fortran77 call:
        ! ZHPGST(ITYPE,UPLO,N,AP,BP,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(IN) :: BP(:)
    END SUBROUTINE ZHPGST_F95
END INTERFACE HPGST

INTERFACE SBGST
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBGST_F95(AB,BB,X,UPLO,INFO)
        ! Fortran77 call:
        ! SSBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(IN) :: BB(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: X(:,:)
    END SUBROUTINE SSBGST_F95
    PURE SUBROUTINE DSBGST_F95(AB,BB,X,UPLO,INFO)
        ! Fortran77 call:
        ! DSBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(IN) :: BB(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: X(:,:)
    END SUBROUTINE DSBGST_F95
END INTERFACE SBGST

INTERFACE HBGST
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBGST_F95(AB,BB,X,UPLO,INFO)
        ! Fortran77 call:
        ! CHBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: BB(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: X(:,:)
    END SUBROUTINE CHBGST_F95
    PURE SUBROUTINE ZHBGST_F95(AB,BB,X,UPLO,INFO)
        ! Fortran77 call:
        ! ZHBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(IN) :: BB(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: X(:,:)
    END SUBROUTINE ZHBGST_F95
END INTERFACE HBGST

INTERFACE PBSTF
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SPBSTF_F95(BB,UPLO,INFO)
        ! Fortran77 call:
        ! SPBSTF(UPLO,N,KB,BB,LDBB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: BB(:,:)
    END SUBROUTINE SPBSTF_F95
    PURE SUBROUTINE DPBSTF_F95(BB,UPLO,INFO)
        ! Fortran77 call:
        ! DPBSTF(UPLO,N,KB,BB,LDBB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: BB(:,:)
    END SUBROUTINE DPBSTF_F95
    PURE SUBROUTINE CPBSTF_F95(BB,UPLO,INFO)
        ! Fortran77 call:
        ! CPBSTF(UPLO,N,KB,BB,LDBB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
    END SUBROUTINE CPBSTF_F95
    PURE SUBROUTINE ZPBSTF_F95(BB,UPLO,INFO)
        ! Fortran77 call:
        ! ZPBSTF(UPLO,N,KB,BB,LDBB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
    END SUBROUTINE ZPBSTF_F95
END INTERFACE PBSTF

INTERFACE GEHRD
        ! Default ILO=1
        ! Default IHI=N
    PURE SUBROUTINE SGEHRD_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! SGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE SGEHRD_F95
    PURE SUBROUTINE DGEHRD_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! DGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE DGEHRD_F95
    PURE SUBROUTINE CGEHRD_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! CGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE CGEHRD_F95
    PURE SUBROUTINE ZGEHRD_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! ZGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: TAU(:)
    END SUBROUTINE ZGEHRD_F95
END INTERFACE GEHRD

INTERFACE ORGHR
        ! Default ILO=1
        ! Default IHI=N
    PURE SUBROUTINE SORGHR_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! SORGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE SORGHR_F95
    PURE SUBROUTINE DORGHR_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! DORGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE DORGHR_F95
END INTERFACE ORGHR

INTERFACE ORMHR
        ! Default ILO=1
        ! Default IHI=N
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SORMHR_F95(A,TAU,C,ILO,IHI,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SORMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SORMHR_F95
    PURE SUBROUTINE DORMHR_F95(A,TAU,C,ILO,IHI,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! DORMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: TAU(:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DORMHR_F95
END INTERFACE ORMHR

INTERFACE UNGHR
        ! Default ILO=1
        ! Default IHI=N
    PURE SUBROUTINE CUNGHR_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! CUNGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE CUNGHR_F95
    PURE SUBROUTINE ZUNGHR_F95(A,TAU,ILO,IHI,INFO)
        ! Fortran77 call:
        ! ZUNGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
    END SUBROUTINE ZUNGHR_F95
END INTERFACE UNGHR

INTERFACE UNMHR
        ! Default ILO=1
        ! Default IHI=N
        ! SIDE='L','R'; default: 'L'
        ! TRANS='N','C'; default: 'N'
    PURE SUBROUTINE CUNMHR_F95(A,TAU,C,ILO,IHI,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! CUNMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CUNMHR_F95
    PURE SUBROUTINE ZUNMHR_F95(A,TAU,C,ILO,IHI,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! ZUNMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: TAU(:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZUNMHR_F95
END INTERFACE UNMHR

INTERFACE GEBAL
        ! Default ILO=1
        ! Default IHI=N
        ! JOB='B','S','P','N'; default: 'B'
    PURE SUBROUTINE SGEBAL_F95(A,SCALE,ILO,IHI,JOB,INFO)
        ! Fortran77 call:
        ! SGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
    END SUBROUTINE SGEBAL_F95
    PURE SUBROUTINE DGEBAL_F95(A,SCALE,ILO,IHI,JOB,INFO)
        ! Fortran77 call:
        ! DGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
    END SUBROUTINE DGEBAL_F95
    PURE SUBROUTINE CGEBAL_F95(A,SCALE,ILO,IHI,JOB,INFO)
        ! Fortran77 call:
        ! CGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
    END SUBROUTINE CGEBAL_F95
    PURE SUBROUTINE ZGEBAL_F95(A,SCALE,ILO,IHI,JOB,INFO)
        ! Fortran77 call:
        ! ZGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
    END SUBROUTINE ZGEBAL_F95
END INTERFACE GEBAL

INTERFACE GEBAK
        ! Default ILO=1
        ! Default IHI=N
        ! JOB='B','S','P','N'; default: 'B'
        ! SIDE='L','R'; default: 'L'
    PURE SUBROUTINE SGEBAK_F95(V,SCALE,ILO,IHI,JOB,SIDE,INFO)
        ! Fortran77 call:
        ! SGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: V(:,:)
        REAL(WP), INTENT(IN) :: SCALE(:)
    END SUBROUTINE SGEBAK_F95
    PURE SUBROUTINE DGEBAK_F95(V,SCALE,ILO,IHI,JOB,SIDE,INFO)
        ! Fortran77 call:
        ! DGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: V(:,:)
        REAL(WP), INTENT(IN) :: SCALE(:)
    END SUBROUTINE DGEBAK_F95
    PURE SUBROUTINE CGEBAK_F95(V,SCALE,ILO,IHI,JOB,SIDE,INFO)
        ! Fortran77 call:
        ! CGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: V(:,:)
        REAL(WP), INTENT(IN) :: SCALE(:)
    END SUBROUTINE CGEBAK_F95
    PURE SUBROUTINE ZGEBAK_F95(V,SCALE,ILO,IHI,JOB,SIDE,INFO)
        ! Fortran77 call:
        ! ZGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: V(:,:)
        REAL(WP), INTENT(IN) :: SCALE(:)
    END SUBROUTINE ZGEBAK_F95
END INTERFACE GEBAK

INTERFACE HSEQR
        ! JOB='E','S'; default: 'E'
    PURE SUBROUTINE SHSEQR_F95(H,WR,WI,ILO,IHI,Z,JOB,COMPZ,INFO)
        ! Fortran77 call:
        ! SHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,WR,WI,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: H(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SHSEQR_F95
    PURE SUBROUTINE DHSEQR_F95(H,WR,WI,ILO,IHI,Z,JOB,COMPZ,INFO)
        ! Fortran77 call:
        ! DHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,WR,WI,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: H(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DHSEQR_F95
    PURE SUBROUTINE CHSEQR_F95(H,W,ILO,IHI,Z,JOB,COMPZ,INFO)
        ! Fortran77 call:
        ! CHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,W,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: H(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHSEQR_F95
    PURE SUBROUTINE ZHSEQR_F95(H,W,ILO,IHI,Z,JOB,COMPZ,INFO)
        ! Fortran77 call:
        ! ZHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,W,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: H(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHSEQR_F95
END INTERFACE HSEQR

INTERFACE HSEIN
        ! INITV='N','U'; default: 'N'
        ! EIGSRC='N','Q'; default: 'N'
    PURE SUBROUTINE SHSEIN_F95(H,WR,WI,SELECT,VL,VR,IFAILL,IFAILR,INITV,&
     &                                                    EIGSRC,M,INFO)
        ! Fortran77 call:
        ! SHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,WR,WI,VL,LDVL,VR,LDVR,
        !   MM,M,WORK,IFAILL,IFAILR,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: INITV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: EIGSRC
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: H(:,:)
        REAL(WP), INTENT(INOUT) :: WR(:)
        REAL(WP), INTENT(IN) :: WI(:)
        LOGICAL, INTENT(INOUT) :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILL(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILR(:)
    END SUBROUTINE SHSEIN_F95
    PURE SUBROUTINE DHSEIN_F95(H,WR,WI,SELECT,VL,VR,IFAILL,IFAILR,INITV,&
     &                                                    EIGSRC,M,INFO)
        ! Fortran77 call:
        ! DHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,WR,WI,VL,LDVL,VR,LDVR,
        !   MM,M,WORK,IFAILL,IFAILR,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: INITV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: EIGSRC
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: H(:,:)
        REAL(WP), INTENT(INOUT) :: WR(:)
        REAL(WP), INTENT(IN) :: WI(:)
        LOGICAL, INTENT(INOUT) :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILL(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILR(:)
    END SUBROUTINE DHSEIN_F95
    PURE SUBROUTINE CHSEIN_F95(H,W,SELECT,VL,VR,IFAILL,IFAILR,INITV,    &
     &                                                    EIGSRC,M,INFO)
        ! Fortran77 call:
        ! CHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,W,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,RWORK,IFAILL,IFAILR,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: INITV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: EIGSRC
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: H(:,:)
        COMPLEX(WP), INTENT(INOUT) :: W(:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILL(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILR(:)
    END SUBROUTINE CHSEIN_F95
    PURE SUBROUTINE ZHSEIN_F95(H,W,SELECT,VL,VR,IFAILL,IFAILR,INITV,    &
     &                                                    EIGSRC,M,INFO)
        ! Fortran77 call:
        ! ZHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,W,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,RWORK,IFAILL,IFAILR,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: INITV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: EIGSRC
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: H(:,:)
        COMPLEX(WP), INTENT(INOUT) :: W(:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILL(:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAILR(:)
    END SUBROUTINE ZHSEIN_F95
END INTERFACE HSEIN

INTERFACE TREVC
    PURE SUBROUTINE STREVC_F95(T,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! STREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM,M,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: T(:,:)
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE STREVC_F95
    PURE SUBROUTINE DTREVC_F95(T,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! DTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM,M,WORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: T(:,:)
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE DTREVC_F95
    PURE SUBROUTINE CTREVC_F95(T,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! CTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM,M,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE CTREVC_F95
    PURE SUBROUTINE ZTREVC_F95(T,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! ZTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM,M,WORK,
        !   RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE ZTREVC_F95
END INTERFACE TREVC

INTERFACE TRSNA
    PURE SUBROUTINE STRSNA_F95(T,S,SEP,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! STRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,SEP,MM,M,
        !   WORK,LDWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SEP(:)
        ! VL: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE STRSNA_F95
    PURE SUBROUTINE DTRSNA_F95(T,S,SEP,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! DTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,SEP,MM,M,
        !   WORK,LDWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SEP(:)
        ! VL: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE DTRSNA_F95
    PURE SUBROUTINE CTRSNA_F95(T,S,SEP,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! CTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,SEP,MM,M,
        !   WORK,LDWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SEP(:)
        ! VL: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE CTRSNA_F95
    PURE SUBROUTINE ZTRSNA_F95(T,S,SEP,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! ZTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,SEP,MM,M,
        !   WORK,LDWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SEP(:)
        ! VL: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE ZTRSNA_F95
END INTERFACE TRSNA

INTERFACE TREXC
    PURE SUBROUTINE STREXC_F95(T,IFST,ILST,Q,INFO)
        ! Fortran77 call:
        ! STREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(INOUT) :: IFST
        INTEGER, INTENT(INOUT) :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: T(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE STREXC_F95
    PURE SUBROUTINE DTREXC_F95(T,IFST,ILST,Q,INFO)
        ! Fortran77 call:
        ! DTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(INOUT) :: IFST
        INTEGER, INTENT(INOUT) :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: T(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DTREXC_F95
    PURE SUBROUTINE CTREXC_F95(T,IFST,ILST,Q,INFO)
        ! Fortran77 call:
        ! CTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: IFST
        INTEGER, INTENT(IN) :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CTREXC_F95
    PURE SUBROUTINE ZTREXC_F95(T,IFST,ILST,Q,INFO)
        ! Fortran77 call:
        ! ZTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: IFST
        INTEGER, INTENT(IN) :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZTREXC_F95
END INTERFACE TREXC

INTERFACE TRSEN
    PURE SUBROUTINE STRSEN_F95(T,SELECT,WR,WI,M,S,SEP,Q,INFO)
        ! Fortran77 call:
        ! STRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,WR,WI,M,S,SEP,WORK,
        !   LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(OUT), OPTIONAL :: S
        REAL(WP), INTENT(OUT), OPTIONAL :: SEP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: T(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: WR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: WI(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE STRSEN_F95
    PURE SUBROUTINE DTRSEN_F95(T,SELECT,WR,WI,M,S,SEP,Q,INFO)
        ! Fortran77 call:
        ! DTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,WR,WI,M,S,SEP,WORK,
        !   LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(OUT), OPTIONAL :: S
        REAL(WP), INTENT(OUT), OPTIONAL :: SEP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: T(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: WR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: WI(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DTRSEN_F95
    PURE SUBROUTINE CTRSEN_F95(T,SELECT,W,M,S,SEP,Q,INFO)
        ! Fortran77 call:
        ! CTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,W,M,S,SEP,WORK,LWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(OUT), OPTIONAL :: S
        REAL(WP), INTENT(OUT), OPTIONAL :: SEP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: W(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CTRSEN_F95
    PURE SUBROUTINE ZTRSEN_F95(T,SELECT,W,M,S,SEP,Q,INFO)
        ! Fortran77 call:
        ! ZTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,W,M,S,SEP,WORK,LWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(OUT), OPTIONAL :: S
        REAL(WP), INTENT(OUT), OPTIONAL :: SEP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: W(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZTRSEN_F95
END INTERFACE TRSEN

INTERFACE TRSYL
        ! TRANA='N','C','T'; default: 'N'
        ! TRANB='N','C','T'; default: 'N'
        ! ISGN=+1,-1; default: +1
    PURE SUBROUTINE STRSYL_F95(A,B,C,SCALE,TRANA,TRANB,ISGN,INFO)
        ! Fortran77 call:
        ! STRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: SCALE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANA
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANB
        INTEGER, INTENT(IN), OPTIONAL :: ISGN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE STRSYL_F95
    PURE SUBROUTINE DTRSYL_F95(A,B,C,SCALE,TRANA,TRANB,ISGN,INFO)
        ! Fortran77 call:
        ! DTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: SCALE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANA
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANB
        INTEGER, INTENT(IN), OPTIONAL :: ISGN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DTRSYL_F95
    PURE SUBROUTINE CTRSYL_F95(A,B,C,SCALE,TRANA,TRANB,ISGN,INFO)
        ! Fortran77 call:
        ! CTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(OUT) :: SCALE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANA
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANB
        INTEGER, INTENT(IN), OPTIONAL :: ISGN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CTRSYL_F95
    PURE SUBROUTINE ZTRSYL_F95(A,B,C,SCALE,TRANA,TRANB,ISGN,INFO)
        ! Fortran77 call:
        ! ZTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(OUT) :: SCALE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANA
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANB
        INTEGER, INTENT(IN), OPTIONAL :: ISGN
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZTRSYL_F95
END INTERFACE TRSYL

INTERFACE GGHRD
        ! Default ILO=1
        ! Default IHI=N
    PURE SUBROUTINE SGGHRD_F95(A,B,ILO,IHI,Q,Z,COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! SGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SGGHRD_F95
    PURE SUBROUTINE DGGHRD_F95(A,B,ILO,IHI,Q,Z,COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! DGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DGGHRD_F95
    PURE SUBROUTINE CGGHRD_F95(A,B,ILO,IHI,Q,Z,COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! CGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CGGHRD_F95
    PURE SUBROUTINE ZGGHRD_F95(A,B,ILO,IHI,Q,Z,COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! ZGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZGGHRD_F95
END INTERFACE GGHRD

INTERFACE GGBAL
        ! Default ILO=1
        ! Default IHI=N
        ! JOB='B','S','P','N'; default: 'B'
    PURE SUBROUTINE SGGBAL_F95(A,B,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! SGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE SGGBAL_F95
    PURE SUBROUTINE DGGBAL_F95(A,B,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! DGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE DGGBAL_F95
    PURE SUBROUTINE CGGBAL_F95(A,B,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! CGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE CGGBAL_F95
    PURE SUBROUTINE ZGGBAL_F95(A,B,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! ZGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE ZGGBAL_F95
END INTERFACE GGBAL

INTERFACE GGBAK
        ! Default ILO=1
        ! Default IHI=N
        ! JOB='B','S','P','N'; default: 'B'
    PURE SUBROUTINE SGGBAK_F95(V,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! SGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: V(:,:)
        ! LSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: LSCALE(:)
        ! RSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE SGGBAK_F95
    PURE SUBROUTINE DGGBAK_F95(V,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! DGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: V(:,:)
        ! LSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: LSCALE(:)
        ! RSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE DGGBAK_F95
    PURE SUBROUTINE CGGBAK_F95(V,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! CGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: V(:,:)
        ! LSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: LSCALE(:)
        ! RSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE CGGBAK_F95
    PURE SUBROUTINE ZGGBAK_F95(V,ILO,IHI,LSCALE,RSCALE,JOB,INFO)
        ! Fortran77 call:
        ! ZGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: V(:,:)
        ! LSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: LSCALE(:)
        ! RSCALE: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: RSCALE(:)
    END SUBROUTINE ZGGBAK_F95
END INTERFACE GGBAK

INTERFACE HGEQZ
        ! Default ILO=1
        ! Default IHI=N
        ! JOB='E','S'; default: 'E'
    PURE SUBROUTINE SHGEQZ_F95(H,T,ILO,IHI,ALPHAR,ALPHAI,BETA,Q,Z,JOB,  &
     &                                                 COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! SHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHAR,ALPHAI,
        !   BETA,Q,LDQ,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: H(:,:)
        REAL(WP), INTENT(INOUT) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SHGEQZ_F95
    PURE SUBROUTINE DHGEQZ_F95(H,T,ILO,IHI,ALPHAR,ALPHAI,BETA,Q,Z,JOB,  &
     &                                                 COMPQ,COMPZ,INFO)
        ! Fortran77 call:
        ! DHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHAR,ALPHAI,
        !   BETA,Q,LDQ,Z,LDZ,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: H(:,:)
        REAL(WP), INTENT(INOUT) :: T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DHGEQZ_F95
    PURE SUBROUTINE CHGEQZ_F95(H,T,ILO,IHI,ALPHA,BETA,Q,Z,JOB,COMPQ,    &
     &                                                       COMPZ,INFO)
        ! Fortran77 call:
        ! CHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHA,BETA,Q,LDQ,
        !   Z,LDZ,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: H(:,:)
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHGEQZ_F95
    PURE SUBROUTINE ZHGEQZ_F95(H,T,ILO,IHI,ALPHA,BETA,Q,Z,JOB,COMPQ,    &
     &                                                       COMPZ,INFO)
        ! Fortran77 call:
        ! ZHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHA,BETA,Q,LDQ,
        !   Z,LDZ,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ILO
        INTEGER, INTENT(IN), OPTIONAL :: IHI
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPQ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: COMPZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: H(:,:)
        COMPLEX(WP), INTENT(INOUT) :: T(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHGEQZ_F95
END INTERFACE HGEQZ

INTERFACE TGEVC
    PURE SUBROUTINE STGEVC_F95(S,P,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! STGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: S(:,:)
        REAL(WP), INTENT(IN) :: P(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE STGEVC_F95
    PURE SUBROUTINE DTGEVC_F95(S,P,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! DTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: S(:,:)
        REAL(WP), INTENT(IN) :: P(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE DTGEVC_F95
    PURE SUBROUTINE CTGEVC_F95(S,P,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! CTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: S(:,:)
        COMPLEX(WP), INTENT(IN) :: P(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE CTGEVC_F95
    PURE SUBROUTINE ZTGEVC_F95(S,P,HOWMNY,SELECT,VL,VR,M,INFO)
        ! Fortran77 call:
        ! ZTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,LDVR,MM,M,
        !   WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: HOWMNY
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: S(:,:)
        COMPLEX(WP), INTENT(IN) :: P(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE ZTGEVC_F95
END INTERFACE TGEVC

INTERFACE TGEXC
    PURE SUBROUTINE STGEXC_F95(A,B,IFST,ILST,Z,Q,INFO)
        ! Fortran77 call:
        ! STGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,ILST,WORK,
        !   LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(INOUT), OPTIONAL :: IFST
        INTEGER, INTENT(INOUT), OPTIONAL :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE STGEXC_F95
    PURE SUBROUTINE DTGEXC_F95(A,B,IFST,ILST,Z,Q,INFO)
        ! Fortran77 call:
        ! DTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,ILST,WORK,
        !   LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(INOUT), OPTIONAL :: IFST
        INTEGER, INTENT(INOUT), OPTIONAL :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DTGEXC_F95
    PURE SUBROUTINE CTGEXC_F95(A,B,IFST,ILST,Z,Q,INFO)
        ! Fortran77 call:
        ! CTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,ILST,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(INOUT), OPTIONAL :: IFST
        INTEGER, INTENT(INOUT), OPTIONAL :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CTGEXC_F95
    PURE SUBROUTINE ZTGEXC_F95(A,B,IFST,ILST,Z,Q,INFO)
        ! Fortran77 call:
        ! ZTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,ILST,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(INOUT), OPTIONAL :: IFST
        INTEGER, INTENT(INOUT), OPTIONAL :: ILST
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZTGEXC_F95
END INTERFACE TGEXC

INTERFACE TGSEN
        ! IJOB=0,1,2,3,4,5; default: 0
    PURE SUBROUTINE STGSEN_F95(A,B,SELECT,ALPHAR,ALPHAI,BETA,IJOB,Q,Z,  &
     &                                                 PL,PR,DIF,M,INFO)
        ! Fortran77 call:
        ! STGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHAR,ALPHAI,
        !   BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        REAL(WP), INTENT(OUT), OPTIONAL :: PL
        REAL(WP), INTENT(OUT), OPTIONAL :: PR
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(2)
    END SUBROUTINE STGSEN_F95
    PURE SUBROUTINE DTGSEN_F95(A,B,SELECT,ALPHAR,ALPHAI,BETA,IJOB,Q,Z,  &
     &                                                 PL,PR,DIF,M,INFO)
        ! Fortran77 call:
        ! DTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHAR,ALPHAI,
        !   BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        REAL(WP), INTENT(OUT), OPTIONAL :: PL
        REAL(WP), INTENT(OUT), OPTIONAL :: PR
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAR(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHAI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(2)
    END SUBROUTINE DTGSEN_F95
    PURE SUBROUTINE CTGSEN_F95(A,B,SELECT,ALPHA,BETA,IJOB,Q,Z,PL,PR,DIF,&
     &                                                           M,INFO)
        ! Fortran77 call:
        ! CTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHA,BETA,Q,LDQ,
        !   Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        REAL(WP), INTENT(OUT), OPTIONAL :: PL
        REAL(WP), INTENT(OUT), OPTIONAL :: PR
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(2)
    END SUBROUTINE CTGSEN_F95
    PURE SUBROUTINE ZTGSEN_F95(A,B,SELECT,ALPHA,BETA,IJOB,Q,Z,PL,PR,DIF,&
     &                                                           M,INFO)
        ! Fortran77 call:
        ! ZTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHA,BETA,Q,LDQ,
        !   Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        REAL(WP), INTENT(OUT), OPTIONAL :: PL
        REAL(WP), INTENT(OUT), OPTIONAL :: PR
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        LOGICAL, INTENT(IN) :: SELECT(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Z(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(2)
    END SUBROUTINE ZTGSEN_F95
END INTERFACE TGSEN

INTERFACE TGSYL
        ! IJOB=0,1,2,3,4; default: 0
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE STGSYL_F95(A,B,C,D,E,F,IJOB,TRANS,SCALE,DIF,INFO)
        ! Fortran77 call:
        ! STGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,LDF,
        !   SCALE,DIF,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: SCALE
        REAL(WP), INTENT(OUT), OPTIONAL :: DIF
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
        REAL(WP), INTENT(IN) :: D(:,:)
        REAL(WP), INTENT(IN) :: E(:,:)
        REAL(WP), INTENT(INOUT) :: F(:,:)
    END SUBROUTINE STGSYL_F95
    PURE SUBROUTINE DTGSYL_F95(A,B,C,D,E,F,IJOB,TRANS,SCALE,DIF,INFO)
        ! Fortran77 call:
        ! DTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,LDF,
        !   SCALE,DIF,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: SCALE
        REAL(WP), INTENT(OUT), OPTIONAL :: DIF
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
        REAL(WP), INTENT(IN) :: D(:,:)
        REAL(WP), INTENT(IN) :: E(:,:)
        REAL(WP), INTENT(INOUT) :: F(:,:)
    END SUBROUTINE DTGSYL_F95
    PURE SUBROUTINE CTGSYL_F95(A,B,C,D,E,F,IJOB,TRANS,SCALE,DIF,INFO)
        ! Fortran77 call:
        ! CTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,LDF,
        !   SCALE,DIF,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: SCALE
        REAL(WP), INTENT(OUT), OPTIONAL :: DIF
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
        COMPLEX(WP), INTENT(IN) :: D(:,:)
        COMPLEX(WP), INTENT(IN) :: E(:,:)
        COMPLEX(WP), INTENT(INOUT) :: F(:,:)
    END SUBROUTINE CTGSYL_F95
    PURE SUBROUTINE ZTGSYL_F95(A,B,C,D,E,F,IJOB,TRANS,SCALE,DIF,INFO)
        ! Fortran77 call:
        ! ZTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,LDF,
        !   SCALE,DIF,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: IJOB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(OUT), OPTIONAL :: SCALE
        REAL(WP), INTENT(OUT), OPTIONAL :: DIF
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
        COMPLEX(WP), INTENT(IN) :: D(:,:)
        COMPLEX(WP), INTENT(IN) :: E(:,:)
        COMPLEX(WP), INTENT(INOUT) :: F(:,:)
    END SUBROUTINE ZTGSYL_F95
END INTERFACE TGSYL

INTERFACE TGSNA
    PURE SUBROUTINE STGSNA_F95(A,B,S,DIF,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! STGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,LDVR,S,DIF,
        !   MM,M,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(:)
        ! VL: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE STGSNA_F95
    PURE SUBROUTINE DTGSNA_F95(A,B,S,DIF,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! DTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,LDVR,S,DIF,
        !   MM,M,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(:)
        ! VL: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE DTGSNA_F95
    PURE SUBROUTINE CTGSNA_F95(A,B,S,DIF,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! CTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,LDVR,S,DIF,
        !   MM,M,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(:)
        ! VL: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE CTGSNA_F95
    PURE SUBROUTINE ZTGSNA_F95(A,B,S,DIF,VL,VR,SELECT,M,INFO)
        ! Fortran77 call:
        ! ZTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,LDVR,S,DIF,
        !   MM,M,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: M
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(IN) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: DIF(:)
        ! VL: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VL(:,:)
        ! VR: INOUT intent instead of IN because PURE.
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: VR(:,:)
        ! SELECT: INOUT intent instead of IN because PURE.
        LOGICAL, INTENT(INOUT), OPTIONAL, TARGET :: SELECT(:)
    END SUBROUTINE ZTGSNA_F95
END INTERFACE TGSNA

INTERFACE GGSVP
    PURE SUBROUTINE SGGSVP_F95(A,B,TOLA,TOLB,K,L,U,V,Q,INFO)
        ! Fortran77 call:
        ! SGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,U,LDU,V,
        !   LDV,Q,LDQ,IWORK,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE SGGSVP_F95
    PURE SUBROUTINE DGGSVP_F95(A,B,TOLA,TOLB,K,L,U,V,Q,INFO)
        ! Fortran77 call:
        ! DGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,U,LDU,V,
        !   LDV,Q,LDQ,IWORK,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DGGSVP_F95
    PURE SUBROUTINE CGGSVP_F95(A,B,TOLA,TOLB,K,L,U,V,Q,INFO)
        ! Fortran77 call:
        ! CGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,U,LDU,V,
        !   LDV,Q,LDQ,IWORK,RWORK,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CGGSVP_F95
    PURE SUBROUTINE ZGGSVP_F95(A,B,TOLA,TOLB,K,L,U,V,Q,INFO)
        ! Fortran77 call:
        ! ZGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,U,LDU,V,
        !   LDV,Q,LDQ,IWORK,RWORK,TAU,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZGGSVP_F95
END INTERFACE GGSVP

INTERFACE TGSJA
    PURE SUBROUTINE STGSJA_F95(A,B,TOLA,TOLB,K,L,U,V,Q,JOBU,JOBV,JOBQ,  &
     &                                           ALPHA,BETA,NCYCLE,INFO)
        ! Fortran77 call:
        ! STGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,ALPHA,
        !   BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBQ
        INTEGER, INTENT(OUT), OPTIONAL :: NCYCLE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
    END SUBROUTINE STGSJA_F95
    PURE SUBROUTINE DTGSJA_F95(A,B,TOLA,TOLB,K,L,U,V,Q,JOBU,JOBV,JOBQ,  &
     &                                           ALPHA,BETA,NCYCLE,INFO)
        ! Fortran77 call:
        ! DTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,ALPHA,
        !   BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBQ
        INTEGER, INTENT(OUT), OPTIONAL :: NCYCLE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
    END SUBROUTINE DTGSJA_F95
    PURE SUBROUTINE CTGSJA_F95(A,B,TOLA,TOLB,K,L,U,V,Q,JOBU,JOBV,JOBQ,  &
     &                                           ALPHA,BETA,NCYCLE,INFO)
        ! Fortran77 call:
        ! CTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,ALPHA,
        !   BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBQ
        INTEGER, INTENT(OUT), OPTIONAL :: NCYCLE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
    END SUBROUTINE CTGSJA_F95
    PURE SUBROUTINE ZTGSJA_F95(A,B,TOLA,TOLB,K,L,U,V,Q,JOBU,JOBV,JOBQ,  &
     &                                           ALPHA,BETA,NCYCLE,INFO)
        ! Fortran77 call:
        ! ZTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,ALPHA,
        !   BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: TOLA
        REAL(WP), INTENT(IN) :: TOLB
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: L
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBQ
        INTEGER, INTENT(OUT), OPTIONAL :: NCYCLE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(INOUT), OPTIONAL, TARGET :: Q(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: ALPHA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: BETA(:)
    END SUBROUTINE ZTGSJA_F95
END INTERFACE TGSJA

INTERFACE GELS
        ! TRANS='N','T'; default: 'N'
    PURE SUBROUTINE SGELS_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! SGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE SGELS_F95
    PURE SUBROUTINE SGELS1_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! SGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE SGELS1_F95
    PURE SUBROUTINE DGELS_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! DGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DGELS_F95
    PURE SUBROUTINE DGELS1_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! DGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE DGELS1_F95
    PURE SUBROUTINE CGELS_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! CGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CGELS_F95
    PURE SUBROUTINE CGELS1_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! CGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE CGELS1_F95
    PURE SUBROUTINE ZGELS_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZGELS_F95
    PURE SUBROUTINE ZGELS1_F95(A,B,TRANS,INFO)
        ! Fortran77 call:
        ! ZGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
    END SUBROUTINE ZGELS1_F95
END INTERFACE GELS

INTERFACE GELSY
        ! Default RCOND=100*EPSILON(1.0_WP)
        ! Default JPVT(i)=0
    PURE SUBROUTINE SGELSY_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE SGELSY_F95
    PURE SUBROUTINE SGELSY1_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE SGELSY1_F95
    PURE SUBROUTINE DGELSY_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE DGELSY_F95
    PURE SUBROUTINE DGELSY1_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE DGELSY1_F95
    PURE SUBROUTINE CGELSY_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE CGELSY_F95
    PURE SUBROUTINE CGELSY1_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE CGELSY1_F95
    PURE SUBROUTINE ZGELSY_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE ZGELSY_F95
    PURE SUBROUTINE ZGELSY1_F95(A,B,RANK,JPVT,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(INOUT), OPTIONAL, TARGET :: JPVT(:)
    END SUBROUTINE ZGELSY1_F95
END INTERFACE GELSY

INTERFACE GELSS
        ! Default RCOND=100*EPSILON(1.0_WP)
    PURE SUBROUTINE SGELSS_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SGELSS_F95
    PURE SUBROUTINE SGELSS1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SGELSS1_F95
    PURE SUBROUTINE DGELSS_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DGELSS_F95
    PURE SUBROUTINE DGELSS1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DGELSS1_F95
    PURE SUBROUTINE CGELSS_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CGELSS_F95
    PURE SUBROUTINE CGELSS1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CGELSS1_F95
    PURE SUBROUTINE ZGELSS_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZGELSS_F95
    PURE SUBROUTINE ZGELSS1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZGELSS1_F95
END INTERFACE GELSS

INTERFACE GELSD
        ! Default RCOND=100*EPSILON(1.0_WP)
    PURE SUBROUTINE SGELSD_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SGELSD_F95
    PURE SUBROUTINE SGELSD1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! SGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE SGELSD1_F95
    PURE SUBROUTINE DGELSD_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DGELSD_F95
    PURE SUBROUTINE DGELSD1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! DGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE DGELSD1_F95
    PURE SUBROUTINE CGELSD_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CGELSD_F95
    PURE SUBROUTINE CGELSD1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! CGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE CGELSD1_F95
    PURE SUBROUTINE ZGELSD_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZGELSD_F95
    PURE SUBROUTINE ZGELSD1_F95(A,B,RANK,S,RCOND,INFO)
        ! Fortran77 call:
        ! ZGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,RWORK,
        !   IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: RANK
        REAL(WP), INTENT(IN), OPTIONAL :: RCOND
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: S(:)
    END SUBROUTINE ZGELSD1_F95
END INTERFACE GELSD

INTERFACE GGLSE
    PURE SUBROUTINE SGGLSE_F95(A,B,C,D,X,INFO)
        ! Fortran77 call:
        ! SGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(OUT) :: X(:)
    END SUBROUTINE SGGLSE_F95
    PURE SUBROUTINE DGGLSE_F95(A,B,C,D,X,INFO)
        ! Fortran77 call:
        ! DGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: C(:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(OUT) :: X(:)
    END SUBROUTINE DGGLSE_F95
    PURE SUBROUTINE CGGLSE_F95(A,B,C,D,X,INFO)
        ! Fortran77 call:
        ! CGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
    END SUBROUTINE CGGLSE_F95
    PURE SUBROUTINE ZGGLSE_F95(A,B,C,D,X,INFO)
        ! Fortran77 call:
        ! ZGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
    END SUBROUTINE ZGGLSE_F95
END INTERFACE GGLSE

INTERFACE GGGLM
    PURE SUBROUTINE SGGGLM_F95(A,B,D,X,Y,INFO)
        ! Fortran77 call:
        ! SGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(OUT) :: Y(:)
    END SUBROUTINE SGGGLM_F95
    PURE SUBROUTINE DGGGLM_F95(A,B,D,X,Y,INFO)
        ! Fortran77 call:
        ! DGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(OUT) :: X(:)
        REAL(WP), INTENT(OUT) :: Y(:)
    END SUBROUTINE DGGGLM_F95
    PURE SUBROUTINE CGGGLM_F95(A,B,D,X,Y,INFO)
        ! Fortran77 call:
        ! CGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(OUT) :: Y(:)
    END SUBROUTINE CGGGLM_F95
    PURE SUBROUTINE ZGGGLM_F95(A,B,D,X,Y,INFO)
        ! Fortran77 call:
        ! ZGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(INOUT) :: D(:)
        COMPLEX(WP), INTENT(OUT) :: X(:)
        COMPLEX(WP), INTENT(OUT) :: Y(:)
    END SUBROUTINE ZGGGLM_F95
END INTERFACE GGGLM

INTERFACE SYEV
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYEV_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! SSYEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE SSYEV_F95
    PURE SUBROUTINE DSYEV_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! DSYEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE DSYEV_F95
END INTERFACE SYEV

INTERFACE HEEV
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHEEV_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! CHEEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE CHEEV_F95
    PURE SUBROUTINE ZHEEV_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! ZHEEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE ZHEEV_F95
END INTERFACE HEEV

INTERFACE SYEVD
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYEVD_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! SSYEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE SSYEVD_F95
    PURE SUBROUTINE DSYEVD_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! DSYEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE DSYEVD_F95
END INTERFACE SYEVD

INTERFACE HEEVD
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHEEVD_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! CHEEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,LRWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE CHEEVD_F95
    PURE SUBROUTINE ZHEEVD_F95(A,W,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! ZHEEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,LRWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE ZHEEVD_F95
END INTERFACE HEEVD

INTERFACE SYEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSYEVX_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,   &
     &                                                             INFO)
        ! Fortran77 call:
        ! SSYEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   WORK,LWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE SSYEVX_F95
    PURE SUBROUTINE DSYEVX_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,   &
     &                                                             INFO)
        ! Fortran77 call:
        ! DSYEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   WORK,LWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE DSYEVX_F95
END INTERFACE SYEVX

INTERFACE HEEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHEEVX_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,   &
     &                                                             INFO)
        ! Fortran77 call:
        ! CHEEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE CHEEVX_F95
    PURE SUBROUTINE ZHEEVX_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,   &
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHEEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE ZHEEVX_F95
END INTERFACE HEEVX

INTERFACE SYEVR
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSYEVR_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! SSYEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE SSYEVR_F95
    PURE SUBROUTINE DSYEVR_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! DSYEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE DSYEVR_F95
END INTERFACE SYEVR

INTERFACE HEEVR
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHEEVR_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! CHEEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   ISUPPZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE CHEEVR_F95
    PURE SUBROUTINE ZHEEVR_F95(A,W,UPLO,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHEEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,
        !   ISUPPZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE ZHEEVR_F95
END INTERFACE HEEVR

INTERFACE SPEV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPEV_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSPEV_F95
    PURE SUBROUTINE DSPEV_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSPEV_F95
END INTERFACE SPEV

INTERFACE HPEV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPEV_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHPEV_F95
    PURE SUBROUTINE ZHPEV_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHPEV_F95
END INTERFACE HPEV

INTERFACE SPEVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPEVD_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSPEVD_F95
    PURE SUBROUTINE DSPEVD_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSPEVD_F95
END INTERFACE SPEVD

INTERFACE HPEVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPEVD_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHPEVD_F95
    PURE SUBROUTINE ZHPEVD_F95(AP,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHPEVD_F95
END INTERFACE HPEVD

INTERFACE SPEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSPEVX_F95(AP,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! SSPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE SSPEVX_F95
    PURE SUBROUTINE DSPEVX_F95(AP,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! DSPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE DSPEVX_F95
END INTERFACE SPEVX

INTERFACE HPEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHPEVX_F95(AP,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! CHPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE CHPEVX_F95
    PURE SUBROUTINE ZHPEVX_F95(AP,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,  &
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE ZHPEVX_F95
END INTERFACE HPEVX

INTERFACE SBEV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBEV_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSBEV_F95
    PURE SUBROUTINE DSBEV_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSBEV_F95
END INTERFACE SBEV

INTERFACE HBEV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBEV_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHBEV_F95
    PURE SUBROUTINE ZHBEV_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHBEV_F95
END INTERFACE HBEV

INTERFACE SBEVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBEVD_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSBEVD_F95
    PURE SUBROUTINE DSBEVD_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSBEVD_F95
END INTERFACE SBEVD

INTERFACE HBEVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBEVD_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,
        !   IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHBEVD_F95
    PURE SUBROUTINE ZHBEVD_F95(AB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,
        !   IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHBEVD_F95
END INTERFACE HBEVD

INTERFACE SBEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSBEVX_F95(AB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,ABSTOL,&
     &                                                             INFO)
        ! Fortran77 call:
        ! SSBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE SSBEVX_F95
    PURE SUBROUTINE DSBEVX_F95(AB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,ABSTOL,&
     &                                                             INFO)
        ! Fortran77 call:
        ! DSBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DSBEVX_F95
END INTERFACE SBEVX

INTERFACE HBEVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHBEVX_F95(AB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,ABSTOL,&
     &                                                             INFO)
        ! Fortran77 call:
        ! CHBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CHBEVX_F95
    PURE SUBROUTINE ZHBEVX_F95(AB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,ABSTOL,&
     &                                                             INFO)
        ! Fortran77 call:
        ! ZHBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZHBEVX_F95
END INTERFACE HBEVX

INTERFACE STEV
    PURE SUBROUTINE SSTEV_F95(D,E,Z,INFO)
        ! Fortran77 call:
        ! SSTEV(JOBZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSTEV_F95
    PURE SUBROUTINE DSTEV_F95(D,E,Z,INFO)
        ! Fortran77 call:
        ! DSTEV(JOBZ,N,D,E,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSTEV_F95
END INTERFACE STEV

INTERFACE STEVD
    PURE SUBROUTINE SSTEVD_F95(D,E,Z,INFO)
        ! Fortran77 call:
        ! SSTEVD(JOBZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSTEVD_F95
    PURE SUBROUTINE DSTEVD_F95(D,E,Z,INFO)
        ! Fortran77 call:
        ! DSTEVD(JOBZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSTEVD_F95
END INTERFACE STEVD

INTERFACE STEVX
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSTEVX_F95(D,E,W,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,INFO)
        ! Fortran77 call:
        ! SSTEVX(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE SSTEVX_F95
    PURE SUBROUTINE DSTEVX_F95(D,E,W,Z,VL,VU,IL,IU,M,IFAIL,ABSTOL,INFO)
        ! Fortran77 call:
        ! DSTEVX(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,
        !   IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE DSTEVX_F95
END INTERFACE STEVX

INTERFACE STEVR
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSTEVR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! SSTEVR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE SSTEVR_F95
    PURE SUBROUTINE DSTEVR_F95(D,E,W,Z,VL,VU,IL,IU,M,ISUPPZ,ABSTOL,INFO)
        ! Fortran77 call:
        ! DSTEVR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,ISUPPZ,
        !   WORK,LWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: D(:)
        REAL(WP), INTENT(INOUT) :: E(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: ISUPPZ(:)
    END SUBROUTINE DSTEVR_F95
END INTERFACE STEVR

INTERFACE GEES
    PURE SUBROUTINE SGEES_F95(A,WR,WI,VS,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! SGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,WR,WI,VS,LDVS,WORK,LWORK,
        !   BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(WR,WI)
                USE F95_PRECISION, ONLY: WP => SP
                REAL(WP), INTENT(IN) :: WR,WI
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE SGEES_F95
    PURE SUBROUTINE DGEES_F95(A,WR,WI,VS,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! DGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,WR,WI,VS,LDVS,WORK,LWORK,
        !   BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(WR,WI)
                USE F95_PRECISION, ONLY: WP => DP
                REAL(WP), INTENT(IN) :: WR,WI
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE DGEES_F95
    PURE SUBROUTINE CGEES_F95(A,W,VS,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! CGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,W,VS,LDVS,WORK,LWORK,
        !   RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(W)
                USE F95_PRECISION, ONLY: WP => SP
                COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE CGEES_F95
    PURE SUBROUTINE ZGEES_F95(A,W,VS,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! ZGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,W,VS,LDVS,WORK,LWORK,
        !   RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(W)
                USE F95_PRECISION, ONLY: WP => DP
                COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE ZGEES_F95
END INTERFACE GEES

INTERFACE GEESX
    PURE SUBROUTINE SGEESX_F95(A,WR,WI,VS,SELECT,SDIM,RCONDE,RCONDV,    &
     &                                                             INFO)
        ! Fortran77 call:
        ! SGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,WR,WI,VS,LDVS,
        !   RCONDE,RCONDV,WORK,LWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDE
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDV
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(WR,WI)
                USE F95_PRECISION, ONLY: WP => SP
                REAL(WP), INTENT(IN) :: WR,WI
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE SGEESX_F95
    PURE SUBROUTINE DGEESX_F95(A,WR,WI,VS,SELECT,SDIM,RCONDE,RCONDV,    &
     &                                                             INFO)
        ! Fortran77 call:
        ! DGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,WR,WI,VS,LDVS,
        !   RCONDE,RCONDV,WORK,LWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDE
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDV
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(WR,WI)
                USE F95_PRECISION, ONLY: WP => DP
                REAL(WP), INTENT(IN) :: WR,WI
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE DGEESX_F95
    PURE SUBROUTINE CGEESX_F95(A,W,VS,SELECT,SDIM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! CGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,W,VS,LDVS,RCONDE,
        !   RCONDV,WORK,LWORK,RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDE
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDV
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(W)
                USE F95_PRECISION, ONLY: WP => SP
                COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE CGEESX_F95
    PURE SUBROUTINE ZGEESX_F95(A,W,VS,SELECT,SDIM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! ZGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,W,VS,LDVS,RCONDE,
        !   RCONDV,WORK,LWORK,RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDE
        REAL(WP), INTENT(OUT), OPTIONAL :: RCONDV
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VS(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(W)
                USE F95_PRECISION, ONLY: WP => DP
                COMPLEX(WP), INTENT(IN) :: W
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE ZGEESX_F95
END INTERFACE GEESX

INTERFACE GEEV
    PURE SUBROUTINE SGEEV_F95(A,WR,WI,VL,VR,INFO)
        ! Fortran77 call:
        ! SGEEV(JOBVL,JOBVR,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,WORK,LWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE SGEEV_F95
    PURE SUBROUTINE DGEEV_F95(A,WR,WI,VL,VR,INFO)
        ! Fortran77 call:
        ! DGEEV(JOBVL,JOBVR,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,WORK,LWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE DGEEV_F95
    PURE SUBROUTINE CGEEV_F95(A,W,VL,VR,INFO)
        ! Fortran77 call:
        ! CGEEV(JOBVL,JOBVR,N,A,LDA,W,VL,LDVL,VR,LDVR,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE CGEEV_F95
    PURE SUBROUTINE ZGEEV_F95(A,W,VL,VR,INFO)
        ! Fortran77 call:
        ! ZGEEV(JOBVL,JOBVR,N,A,LDA,W,VL,LDVL,VR,LDVR,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE ZGEEV_F95
END INTERFACE GEEV

INTERFACE GEEVX
        ! BALANC='N','B','P','S'; default: 'N'
    PURE SUBROUTINE SGEEVX_F95(A,WR,WI,VL,VR,BALANC,ILO,IHI,SCALE,ABNRM,&
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! SGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,
        !   ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE SGEEVX_F95
    PURE SUBROUTINE DGEEVX_F95(A,WR,WI,VL,VR,BALANC,ILO,IHI,SCALE,ABNRM,&
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! DGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,
        !   ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: WR(:)
        REAL(WP), INTENT(OUT) :: WI(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE DGEEVX_F95
    PURE SUBROUTINE CGEEVX_F95(A,W,VL,VR,BALANC,ILO,IHI,SCALE,ABNRM,    &
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! CGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,W,VL,LDVL,VR,LDVR,ILO,
        !   IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE CGEEVX_F95
    PURE SUBROUTINE ZGEEVX_F95(A,W,VL,VR,BALANC,ILO,IHI,SCALE,ABNRM,    &
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! ZGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,W,VL,LDVL,VR,LDVR,ILO,
        !   IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: SCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE ZGEEVX_F95
END INTERFACE GEEVX

INTERFACE GESVD
        ! JOB='N','U','V'; default: 'N'
    PURE SUBROUTINE SGESVD_F95(A,S,U,VT,WW,JOB,INFO)
        ! Fortran77 call:
        ! SGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL :: WW(:)
    END SUBROUTINE SGESVD_F95
    PURE SUBROUTINE DGESVD_F95(A,S,U,VT,WW,JOB,INFO)
        ! Fortran77 call:
        ! DGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL :: WW(:)
    END SUBROUTINE DGESVD_F95
    PURE SUBROUTINE CGESVD_F95(A,S,U,VT,WW,JOB,INFO)
        ! Fortran77 call:
        ! CGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL :: WW(:)
    END SUBROUTINE CGESVD_F95
    PURE SUBROUTINE ZGESVD_F95(A,S,U,VT,WW,JOB,INFO)
        ! Fortran77 call:
        ! ZGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL :: WW(:)
    END SUBROUTINE ZGESVD_F95
END INTERFACE GESVD

INTERFACE GESDD
        ! JOBZ='N','A','S','O'; default: 'N'
    PURE SUBROUTINE SGESDD_F95(A,S,U,VT,JOBZ,INFO)
        ! Fortran77 call:
        ! SGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
    END SUBROUTINE SGESDD_F95
    PURE SUBROUTINE DGESDD_F95(A,S,U,VT,JOBZ,INFO)
        ! Fortran77 call:
        ! DGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
    END SUBROUTINE DGESDD_F95
    PURE SUBROUTINE CGESDD_F95(A,S,U,VT,JOBZ,INFO)
        ! Fortran77 call:
        ! CGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,RWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
    END SUBROUTINE CGESDD_F95
    PURE SUBROUTINE ZGESDD_F95(A,S,U,VT,JOBZ,INFO)
        ! Fortran77 call:
        ! ZGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,RWORK,IWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: S(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VT(:,:)
    END SUBROUTINE ZGESDD_F95
END INTERFACE GESDD

INTERFACE GGSVD
    PURE SUBROUTINE SGGSVD_F95(A,B,ALPHA,BETA,K,L,U,V,Q,IWORK,INFO)
        ! Fortran77 call:
        ! SGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,BETA,U,LDU,
        !   V,LDV,Q,LDQ,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHA(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IWORK(:)
    END SUBROUTINE SGGSVD_F95
    PURE SUBROUTINE DGGSVD_F95(A,B,ALPHA,BETA,K,L,U,V,Q,IWORK,INFO)
        ! Fortran77 call:
        ! DGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,BETA,U,LDU,
        !   V,LDV,Q,LDQ,WORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHA(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IWORK(:)
    END SUBROUTINE DGGSVD_F95
    PURE SUBROUTINE CGGSVD_F95(A,B,ALPHA,BETA,K,L,U,V,Q,IWORK,INFO)
        ! Fortran77 call:
        ! CGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,BETA,U,LDU,
        !   V,LDV,Q,LDQ,WORK,RWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHA(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IWORK(:)
    END SUBROUTINE CGGSVD_F95
    PURE SUBROUTINE ZGGSVD_F95(A,B,ALPHA,BETA,K,L,U,V,Q,IWORK,INFO)
        ! Fortran77 call:
        ! ZGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,BETA,U,LDU,
        !   V,LDV,Q,LDQ,WORK,RWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: K
        INTEGER, INTENT(OUT), OPTIONAL :: L
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHA(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: U(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: V(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IWORK(:)
    END SUBROUTINE ZGGSVD_F95
END INTERFACE GGSVD

INTERFACE SYGV
        ! ITYPE=1,2,3; default: 1
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYGV_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! SSYGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE SSYGV_F95
    PURE SUBROUTINE DSYGV_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! DSYGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE DSYGV_F95
END INTERFACE SYGV

INTERFACE HEGV
        ! ITYPE=1,2,3; default: 1
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHEGV_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! CHEGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE CHEGV_F95
    PURE SUBROUTINE ZHEGV_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! ZHEGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE ZHEGV_F95
END INTERFACE HEGV

INTERFACE SYGVD
        ! ITYPE=1,2,3; default: 1
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYGVD_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! SSYGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE SSYGVD_F95
    PURE SUBROUTINE DSYGVD_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! DSYGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE DSYGVD_F95
END INTERFACE SYGVD

INTERFACE HEGVD
        ! ITYPE=1,2,3; default: 1
        ! JOBZ='N','V'; default: 'N'
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHEGVD_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! CHEGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,RWORK,
        !   LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE CHEGVD_F95
    PURE SUBROUTINE ZHEGVD_F95(A,B,W,ITYPE,JOBZ,UPLO,INFO)
        ! Fortran77 call:
        ! ZHEGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,RWORK,
        !   LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBZ
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
    END SUBROUTINE ZHEGVD_F95
END INTERFACE HEGVD

INTERFACE SYGVX
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSYGVX_F95(A,B,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,  &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! SSYGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE SSYGVX_F95
    PURE SUBROUTINE DSYGVX_F95(A,B,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,  &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! DSYGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE DSYGVX_F95
END INTERFACE SYGVX

INTERFACE HEGVX
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHEGVX_F95(A,B,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,  &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! CHEGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE CHEGVX_F95
    PURE SUBROUTINE ZHEGVX_F95(A,B,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,  &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! ZHEGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,IU,ABSTOL,
        !   M,W,Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE ZHEGVX_F95
END INTERFACE HEGVX

INTERFACE SPGV
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPGV_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSPGV_F95
    PURE SUBROUTINE DSPGV_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSPGV_F95
END INTERFACE SPGV

INTERFACE HPGV
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPGV_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHPGV_F95
    PURE SUBROUTINE ZHPGV_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHPGV_F95
END INTERFACE HPGV

INTERFACE SPGVD
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSPGVD_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSPGVD_F95
    PURE SUBROUTINE DSPGVD_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,IWORK,
        !   LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSPGVD_F95
END INTERFACE SPGVD

INTERFACE HPGVD
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHPGVD_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,RWORK,
        !   LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHPGVD_F95
    PURE SUBROUTINE ZHPGVD_F95(AP,BP,W,ITYPE,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,RWORK,
        !   LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHPGVD_F95
END INTERFACE HPGVD

INTERFACE SPGVX
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSPGVX_F95(AP,BP,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,&
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! SSPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,ABSTOL,M,W,Z,
        !   LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE SSPGVX_F95
    PURE SUBROUTINE DSPGVX_F95(AP,BP,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,&
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! DSPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,ABSTOL,M,W,Z,
        !   LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AP(:)
        REAL(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE DSPGVX_F95
END INTERFACE SPGVX

INTERFACE HPGVX
        ! ITYPE=1,2,3; default: 1
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHPGVX_F95(AP,BP,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,&
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! CHPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,ABSTOL,M,W,Z,
        !   LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE CHPGVX_F95
    PURE SUBROUTINE ZHPGVX_F95(AP,BP,W,ITYPE,UPLO,Z,VL,VU,IL,IU,M,IFAIL,&
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! ZHPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,ABSTOL,M,W,Z,
        !   LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN), OPTIONAL :: ITYPE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AP(:)
        COMPLEX(WP), INTENT(INOUT) :: BP(:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
    END SUBROUTINE ZHPGVX_F95
END INTERFACE HPGVX

INTERFACE SBGV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBGV_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSBGV_F95
    PURE SUBROUTINE DSBGV_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSBGV_F95
END INTERFACE SBGV

INTERFACE HBGV
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBGV_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHBGV_F95
    PURE SUBROUTINE ZHBGV_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,RWORK,
        !   INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHBGV_F95
END INTERFACE HBGV

INTERFACE SBGVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSBGVD_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! SSBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,LWORK,
        !   IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE SSBGVD_F95
    PURE SUBROUTINE DSBGVD_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! DSBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,LWORK,
        !   IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE DSBGVD_F95
END INTERFACE SBGVD

INTERFACE HBGVD
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHBGVD_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! CHBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,LWORK,
        !   RWORK,LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE CHBGVD_F95
    PURE SUBROUTINE ZHBGVD_F95(AB,BB,W,UPLO,Z,INFO)
        ! Fortran77 call:
        ! ZHBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,LWORK,
        !   RWORK,LRWORK,IWORK,LIWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
    END SUBROUTINE ZHBGVD_F95
END INTERFACE HBGVD

INTERFACE SBGVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE SSBGVX_F95(AB,BB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,    &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! SSBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ,VL,VU,IL,
        !   IU,ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE SSBGVX_F95
    PURE SUBROUTINE DSBGVX_F95(AB,BB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,    &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! DSBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ,VL,VU,IL,
        !   IU,ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: AB(:,:)
        REAL(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE DSBGVX_F95
END INTERFACE SBGVX

INTERFACE HBGVX
        ! UPLO='U','L'; default: 'U'
        ! Default VL=-HUGE(VL)
        ! Default VU=HUGE(VL)
        ! Default IL=1
        ! Default IU=N
        ! Default ABSTOL=0.0_WP
    PURE SUBROUTINE CHBGVX_F95(AB,BB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,    &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! CHBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ,VL,VU,IL,
        !   IU,ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE CHBGVX_F95
    PURE SUBROUTINE ZHBGVX_F95(AB,BB,W,UPLO,Z,VL,VU,IL,IU,M,IFAIL,Q,    &
     &                                                      ABSTOL,INFO)
        ! Fortran77 call:
        ! ZHBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ,VL,VU,IL,
        !   IU,ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(IN), OPTIONAL :: VL
        REAL(WP), INTENT(IN), OPTIONAL :: VU
        INTEGER, INTENT(IN), OPTIONAL :: IL
        INTEGER, INTENT(IN), OPTIONAL :: IU
        INTEGER, INTENT(OUT), OPTIONAL :: M
        REAL(WP), INTENT(IN), OPTIONAL :: ABSTOL
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: AB(:,:)
        COMPLEX(WP), INTENT(INOUT) :: BB(:,:)
        REAL(WP), INTENT(OUT) :: W(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Z(:,:)
        INTEGER, INTENT(OUT), OPTIONAL, TARGET :: IFAIL(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: Q(:,:)
    END SUBROUTINE ZHBGVX_F95
END INTERFACE HBGVX

INTERFACE GGES
    PURE SUBROUTINE SGGES_F95(A,B,ALPHAR,ALPHAI,BETA,VSL,VSR,SELECT,    &
     &                                                        SDIM,INFO)
        ! Fortran77 call:
        ! SGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,ALPHAR,
        !   ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
                USE F95_PRECISION, ONLY: WP => SP
                REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE SGGES_F95
    PURE SUBROUTINE DGGES_F95(A,B,ALPHAR,ALPHAI,BETA,VSL,VSR,SELECT,    &
     &                                                        SDIM,INFO)
        ! Fortran77 call:
        ! DGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,ALPHAR,
        !   ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
                USE F95_PRECISION, ONLY: WP => DP
                REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE DGGES_F95
    PURE SUBROUTINE CGGES_F95(A,B,ALPHA,BETA,VSL,VSR,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! CGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,ALPHA,BETA,
        !   VSL,LDVSL,VSR,LDVSR,WORK,LWORK,RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
                USE F95_PRECISION, ONLY: WP => SP
                COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE CGGES_F95
    PURE SUBROUTINE ZGGES_F95(A,B,ALPHA,BETA,VSL,VSR,SELECT,SDIM,INFO)
        ! Fortran77 call:
        ! ZGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,ALPHA,BETA,
        !   VSL,LDVSL,VSR,LDVSR,WORK,LWORK,RWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
                USE F95_PRECISION, ONLY: WP => DP
                COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE ZGGES_F95
END INTERFACE GGES

INTERFACE GGESX
    PURE SUBROUTINE SGGESX_F95(A,B,ALPHAR,ALPHAI,BETA,VSL,VSR,SELECT,   &
     &                                          SDIM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! SGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB,SDIM,
        !   ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,
        !   LWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(2)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(2)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
                USE F95_PRECISION, ONLY: WP => SP
                REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE SGGESX_F95
    PURE SUBROUTINE DGGESX_F95(A,B,ALPHAR,ALPHAI,BETA,VSL,VSR,SELECT,   &
     &                                          SDIM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! DGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB,SDIM,
        !   ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,
        !   LWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(2)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(2)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
                USE F95_PRECISION, ONLY: WP => DP
                REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE DGGESX_F95
    PURE SUBROUTINE CGGESX_F95(A,B,ALPHA,BETA,VSL,VSR,SELECT,SDIM,      &
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! CGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB,SDIM,
        !   ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,LWORK,
        !   RWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(2)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(2)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
                USE F95_PRECISION, ONLY: WP => SP
                COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE CGGESX_F95
    PURE SUBROUTINE ZGGESX_F95(A,B,ALPHA,BETA,VSL,VSR,SELECT,SDIM,      &
     &                                               RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! ZGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB,SDIM,
        !   ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,LWORK,
        !   RWORK,IWORK,LIWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: SDIM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VSR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(2)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(2)
        INTERFACE
            PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
                USE F95_PRECISION, ONLY: WP => DP
                COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
            END FUNCTION SELECT
        END INTERFACE
        OPTIONAL :: SELECT
    END SUBROUTINE ZGGESX_F95
END INTERFACE GGESX

INTERFACE GGEV
    PURE SUBROUTINE SGGEV_F95(A,B,ALPHAR,ALPHAI,BETA,VL,VR,INFO)
        ! Fortran77 call:
        ! SGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHAR,ALPHAI,BETA,VL,LDVL,VR,
        !   LDVR,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE SGGEV_F95
    PURE SUBROUTINE DGGEV_F95(A,B,ALPHAR,ALPHAI,BETA,VL,VR,INFO)
        ! Fortran77 call:
        ! DGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHAR,ALPHAI,BETA,VL,LDVL,VR,
        !   LDVR,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE DGGEV_F95
    PURE SUBROUTINE CGGEV_F95(A,B,ALPHA,BETA,VL,VR,INFO)
        ! Fortran77 call:
        ! CGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHA,BETA,VL,LDVL,VR,LDVR,
        !   WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE CGGEV_F95
    PURE SUBROUTINE ZGGEV_F95(A,B,ALPHA,BETA,VL,VR,INFO)
        ! Fortran77 call:
        ! ZGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHA,BETA,VL,LDVL,VR,LDVR,
        !   WORK,LWORK,RWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
    END SUBROUTINE ZGGEV_F95
END INTERFACE GGEV

INTERFACE GGEVX
        ! BALANC='N','B','P'; default: 'N'
    PURE SUBROUTINE SGGEVX_F95(A,B,ALPHAR,ALPHAI,BETA,VL,VR,BALANC,ILO, &
     &                 IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! SGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHAR,ALPHAI,
        !   BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,
        !   RCONDE,RCONDV,WORK,LWORK,IWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        REAL(WP), INTENT(OUT), OPTIONAL :: BBNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE SGGEVX_F95
    PURE SUBROUTINE DGGEVX_F95(A,B,ALPHAR,ALPHAI,BETA,VL,VR,BALANC,ILO, &
     &                 IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! DGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHAR,ALPHAI,
        !   BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,
        !   RCONDE,RCONDV,WORK,LWORK,IWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        REAL(WP), INTENT(OUT), OPTIONAL :: BBNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: ALPHAR(:)
        REAL(WP), INTENT(OUT) :: ALPHAI(:)
        REAL(WP), INTENT(OUT) :: BETA(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE DGGEVX_F95
    PURE SUBROUTINE CGGEVX_F95(A,B,ALPHA,BETA,VL,VR,BALANC,ILO,IHI,     &
     &                     LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! CGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHA,BETA,VL,
        !   LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,
        !   RCONDV,WORK,LWORK,RWORK,IWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        REAL(WP), INTENT(OUT), OPTIONAL :: BBNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE CGGEVX_F95
    PURE SUBROUTINE ZGGEVX_F95(A,B,ALPHA,BETA,VL,VR,BALANC,ILO,IHI,     &
     &                     LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,RCONDV,INFO)
        ! Fortran77 call:
        ! ZGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHA,BETA,VL,
        !   LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE,
        !   RCONDV,WORK,LWORK,RWORK,IWORK,BWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: BALANC
        INTEGER, INTENT(OUT), OPTIONAL :: ILO
        INTEGER, INTENT(OUT), OPTIONAL :: IHI
        REAL(WP), INTENT(OUT), OPTIONAL :: ABNRM
        REAL(WP), INTENT(OUT), OPTIONAL :: BBNRM
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: ALPHA(:)
        COMPLEX(WP), INTENT(OUT) :: BETA(:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VL(:,:)
        COMPLEX(WP), INTENT(OUT), OPTIONAL, TARGET :: VR(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: LSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RSCALE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDE(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: RCONDV(:)
    END SUBROUTINE ZGGEVX_F95
END INTERFACE GGEVX

INTERFACE MKL_TPPACK
    PURE SUBROUTINE MKL_DTPPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_DTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(OUT) :: AP(:,:)
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE MKL_DTPPACK_F95
    PURE SUBROUTINE MKL_CTPPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_CTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(OUT) :: AP(:,:)
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE MKL_CTPPACK_F95
    PURE SUBROUTINE MKL_ZTPPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_ZTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(OUT) :: AP(:,:)
        COMPLEX(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE MKL_ZTPPACK_F95
    PURE SUBROUTINE MKL_STPPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_STPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(OUT) :: AP(:,:)
        REAL(WP), INTENT(IN) :: A(:,:)
    END SUBROUTINE MKL_STPPACK_F95
END INTERFACE MKL_TPPACK

INTERFACE MKL_TPUNPACK
    PURE SUBROUTINE MKL_DTPUNPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_DTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:,:)
        REAL(WP), INTENT(OUT) :: A(:,:)
    END SUBROUTINE MKL_DTPUNPACK_F95
    PURE SUBROUTINE MKL_CTPUNPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_CTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:,:)
        COMPLEX(WP), INTENT(OUT) :: A(:,:)
    END SUBROUTINE MKL_CTPUNPACK_F95
    PURE SUBROUTINE MKL_ZTPUNPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_ZTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: AP(:,:)
        COMPLEX(WP), INTENT(OUT) :: A(:,:)
    END SUBROUTINE MKL_ZTPUNPACK_F95
    PURE SUBROUTINE MKL_STPUNPACK_F95(AP,I,J,ROWS,COLS,A,UPLO,TRANS,INFO)
        ! Fortran77 call:
        ! MKL_STPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I
        INTEGER, INTENT(IN) :: J
        INTEGER, INTENT(IN) :: ROWS
        INTEGER, INTENT(IN) :: COLS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL:: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: AP(:,:)
        REAL(WP), INTENT(OUT) :: A(:,:)
    END SUBROUTINE MKL_STPUNPACK_F95
END INTERFACE MKL_TPUNPACK

INTERFACE SYCONV
    PURE SUBROUTINE SSYCONV_F95(A,IPIV,E,UPLO,WAY,INFO)
        ! Fortran77 call:
        ! SSYCONV(UPLO,WAY,N,A,LDA,IPIV,E,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: WAY
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(OUT) :: E(:)
    END SUBROUTINE SSYCONV_F95
    PURE SUBROUTINE DSYCONV_F95(A,IPIV,E,UPLO,WAY,INFO)
        ! Fortran77 call:
        ! DSYCONV(UPLO,WAY,N,A,LDA,IPIV,E,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: WAY
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        REAL(WP), INTENT(OUT) :: E(:)
    END SUBROUTINE DSYCONV_F95
    PURE SUBROUTINE CSYCONV_F95(A,IPIV,E,UPLO,WAY,INFO)
        ! Fortran77 call:
        ! CSYCONV(UPLO,WAY,N,A,LDA,IPIV,E,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: WAY
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(OUT) :: E(:)
    END SUBROUTINE CSYCONV_F95
    PURE SUBROUTINE ZSYCONV_F95(A,IPIV,E,UPLO,WAY,INFO)
        ! Fortran77 call:
        ! ZSYCONV(UPLO,WAY,N,A,LDA,IPIV,E,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: WAY
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
        COMPLEX(WP), INTENT(OUT) :: E(:)
    END SUBROUTINE ZSYCONV_F95
END INTERFACE SYCONV
INTERFACE SYSWAPR
    PURE SUBROUTINE SSYSWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! SSYSWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE SSYSWAPR_F95
    PURE SUBROUTINE DSYSWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! DSYSWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        REAL(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE DSYSWAPR_F95
    PURE SUBROUTINE CSYSWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! CSYSWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE CSYSWAPR_F95
    PURE SUBROUTINE ZSYSWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! ZSYSWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE ZSYSWAPR_F95
END INTERFACE SYSWAPR
INTERFACE HESWAPR
    PURE SUBROUTINE CHESWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! CHESWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE CHESWAPR_F95
    PURE SUBROUTINE ZHESWAPR_F95(A,I1,I2,UPLO)
        ! Fortran77 call:
        ! ZHESWAPR(UPLO,N,A,I1,I2)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: I1
        INTEGER, INTENT(IN) :: I2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
    END SUBROUTINE ZHESWAPR_F95
END INTERFACE HESWAPR
INTERFACE SYTRI2
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRI2_F95
    PURE SUBROUTINE DSYTRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRI2_F95
    PURE SUBROUTINE CSYTRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRI2_F95
    PURE SUBROUTINE ZSYTRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRI2_F95
END INTERFACE SYTRI2
INTERFACE SYTRI2X
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRI2X_F95
    PURE SUBROUTINE DSYTRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRI2X_F95
    PURE SUBROUTINE CSYTRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRI2X_F95
    PURE SUBROUTINE ZSYTRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRI2X_F95
END INTERFACE SYTRI2X
INTERFACE SYTRS2
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SSYTRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS2_F95
    PURE SUBROUTINE SSYTRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SSYTRS21_F95
    PURE SUBROUTINE DSYTRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS2_F95
    PURE SUBROUTINE DSYTRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DSYTRS21_F95
    PURE SUBROUTINE CSYTRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS2_F95
    PURE SUBROUTINE CSYTRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CSYTRS21_F95
    PURE SUBROUTINE ZSYTRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS2_F95
    PURE SUBROUTINE ZSYTRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZSYTRS21_F95
END INTERFACE SYTRS2
INTERFACE HETRS2
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE CHETRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS2_F95
    PURE SUBROUTINE CHETRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRS21_F95
    PURE SUBROUTINE ZHETRS2_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS2_F95
    PURE SUBROUTINE ZHETRS21_F95(A,B,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRS21_F95
END INTERFACE HETRS2
INTERFACE LAPMR
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SLAPMR_F95(X,K,FORWRD)
        ! Fortran77 call:
        ! SLAPMR(FORWRD,M,N,X,LDX,K)
        USE F95_PRECISION, ONLY: WP => SP
        LOGICAL, INTENT(IN), OPTIONAL :: FORWRD
        REAL(WP), INTENT(INOUT) :: X(:,:)
        INTEGER, INTENT(INOUT) :: K(:)
    END SUBROUTINE SLAPMR_F95
    PURE SUBROUTINE DLAPMR_F95(X,K,FORWRD)
        ! Fortran77 call:
        ! DLAPMR(FORWRD,M,N,X,LDX,K)
        USE F95_PRECISION, ONLY: WP => DP
        LOGICAL, INTENT(IN), OPTIONAL :: FORWRD
        REAL(WP), INTENT(INOUT) :: X(:,:)
        INTEGER, INTENT(INOUT) :: K(:)
    END SUBROUTINE DLAPMR_F95
    PURE SUBROUTINE CLAPMR_F95(X,K,FORWRD)
        ! Fortran77 call:
        ! CLAPMR(FORWRD,M,N,X,LDX,K)
        USE F95_PRECISION, ONLY: WP => SP
        LOGICAL, INTENT(IN), OPTIONAL :: FORWRD
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        INTEGER, INTENT(INOUT) :: K(:)
    END SUBROUTINE CLAPMR_F95
    PURE SUBROUTINE ZLAPMR_F95(X,K,FORWRD)
        ! Fortran77 call:
        ! ZLAPMR(FORWRD,M,N,X,LDX,K)
        USE F95_PRECISION, ONLY: WP => DP
        LOGICAL, INTENT(IN), OPTIONAL :: FORWRD
        COMPLEX(WP), INTENT(INOUT) :: X(:,:)
        INTEGER, INTENT(INOUT) :: K(:)
    END SUBROUTINE ZLAPMR_F95
END INTERFACE LAPMR
INTERFACE LARTGP
    PURE SUBROUTINE SLARTGP_F95(F,G,CS,SN,R)
        ! Fortran77 call:
        ! SLARTGP( F,G,CS,SN,R )
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: F
        REAL(WP), INTENT(IN) :: G
        REAL(WP), INTENT(OUT) :: CS
        REAL(WP), INTENT(OUT) :: SN
        REAL(WP), INTENT(OUT) :: R
    END SUBROUTINE SLARTGP_F95
    PURE SUBROUTINE DLARTGP_F95(F,G,CS,SN,R)
        ! Fortran77 call:
        ! DLARTGP( F,G,CS,SN,R )
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: F
        REAL(WP), INTENT(IN) :: G
        REAL(WP), INTENT(OUT) :: CS
        REAL(WP), INTENT(OUT) :: SN
        REAL(WP), INTENT(OUT) :: R
    END SUBROUTINE DLARTGP_F95
END INTERFACE LARTGP
INTERFACE LARTGS
    PURE SUBROUTINE SLARTGS_F95(X,Y,SIGMA,SN,CS)
        ! Fortran77 call:
        ! SLARTGS( X,Y,SIGMA,CS,SN )
        USE F95_PRECISION, ONLY: WP => SP
        REAL(WP), INTENT(IN) :: X
        REAL(WP), INTENT(IN) :: Y
        REAL(WP), INTENT(IN) :: SIGMA
        REAL(WP), INTENT(OUT) :: SN
        REAL(WP), INTENT(OUT) :: CS
    END SUBROUTINE SLARTGS_F95
    PURE SUBROUTINE DLARTGS_F95(X,Y,SIGMA,SN,CS)
        ! Fortran77 call:
        ! DLARTGS( X,Y,SIGMA,CS,SN )
        USE F95_PRECISION, ONLY: WP => DP
        REAL(WP), INTENT(IN) :: X
        REAL(WP), INTENT(IN) :: Y
        REAL(WP), INTENT(IN) :: SIGMA
        REAL(WP), INTENT(OUT) :: SN
        REAL(WP), INTENT(OUT) :: CS
    END SUBROUTINE DLARTGS_F95
END INTERFACE LARTGS
INTERFACE UNBDB
    PURE SUBROUTINE CUNBDB_F95(X11,X12,X21,X22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! CUNBDB(TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X12(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: PHI(:)
        COMPLEX(WP), INTENT(OUT) :: TAUP1(:)
        COMPLEX(WP), INTENT(OUT) :: TAUP2(:)
        COMPLEX(WP), INTENT(OUT) :: TAUQ1(:)
        COMPLEX(WP), INTENT(OUT) :: TAUQ2(:)
    END SUBROUTINE CUNBDB_F95
    PURE SUBROUTINE ZUNBDB_F95(X11,X12,X21,X22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! ZUNBDB(TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X12(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: PHI(:)
        COMPLEX(WP), INTENT(OUT) :: TAUP1(:)
        COMPLEX(WP), INTENT(OUT) :: TAUP2(:)
        COMPLEX(WP), INTENT(OUT) :: TAUQ1(:)
        COMPLEX(WP), INTENT(OUT) :: TAUQ2(:)
    END SUBROUTINE ZUNBDB_F95
END INTERFACE UNBDB
INTERFACE UNCSD
    PURE SUBROUTINE CUNCSD_F95(X11,X12,X21,X22,THETA,U1,U2,V1T,V2T,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! CUNCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,WORK,LWORK,RWORK,LRWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X12(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        COMPLEX(WP), INTENT(OUT) :: U1(:,:)
        COMPLEX(WP), INTENT(OUT) :: U2(:,:)
        COMPLEX(WP), INTENT(OUT) :: V1T(:,:)
        COMPLEX(WP), INTENT(OUT) :: V2T(:,:)
    END SUBROUTINE CUNCSD_F95
    PURE SUBROUTINE ZUNCSD_F95(X11,X12,X21,X22,THETA,U1,U2,V1T,V2T,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! ZUNCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,WORK,LWORK,RWORK,LRWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X12(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        COMPLEX(WP), INTENT(OUT) :: U1(:,:)
        COMPLEX(WP), INTENT(OUT) :: U2(:,:)
        COMPLEX(WP), INTENT(OUT) :: V1T(:,:)
        COMPLEX(WP), INTENT(OUT) :: V2T(:,:)
    END SUBROUTINE ZUNCSD_F95
END INTERFACE UNCSD
INTERFACE UNCSD2BY1
    PURE SUBROUTINE CUNCSD2BY1_F95(X11,X21,THETA,U1,U2,V1T,JOBU1,JOBU2,JOBV1T,INFO)
        ! Fortran77 call:
        ! CUNCSD2BY1(JOBU1,JOBU2,JOBV1T,M,P,Q,X11,LDX11,X21,LDX21,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,WORK,LWORK,RWORK,LRWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        COMPLEX(WP), INTENT(OUT) :: U1(:,:)
        COMPLEX(WP), INTENT(OUT) :: U2(:,:)
        COMPLEX(WP), INTENT(OUT) :: V1T(:,:)
    END SUBROUTINE CUNCSD2BY1_F95
    PURE SUBROUTINE ZUNCSD2BY1_F95(X11,X21,THETA,U1,U2,V1T,JOBU1,JOBU2,JOBV1T,INFO)
        ! Fortran77 call:
        ! ZUNCSD2BY1(JOBU1,JOBU2,JOBV1T,M,P,Q,X11,LDX11,X21,LDX21,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,WORK,LWORK,RWORK,LRWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: X11(:,:)
        COMPLEX(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        COMPLEX(WP), INTENT(OUT) :: U1(:,:)
        COMPLEX(WP), INTENT(OUT) :: U2(:,:)
        COMPLEX(WP), INTENT(OUT) :: V1T(:,:)
    END SUBROUTINE ZUNCSD2BY1_F95
END INTERFACE UNCSD2BY1
INTERFACE ORBDB
    PURE SUBROUTINE SORBDB_F95(X11,X12,X21,X22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! SORBDB(TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X12(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: PHI(:)
        REAL(WP), INTENT(OUT) :: TAUP1(:)
        REAL(WP), INTENT(OUT) :: TAUP2(:)
        REAL(WP), INTENT(OUT) :: TAUQ1(:)
        REAL(WP), INTENT(OUT) :: TAUQ2(:)
    END SUBROUTINE SORBDB_F95
    PURE SUBROUTINE DORBDB_F95(X11,X12,X21,X22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! DORBDB(TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,PHI,TAUP1,TAUP2,TAUQ1,TAUQ2,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X12(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: PHI(:)
        REAL(WP), INTENT(OUT) :: TAUP1(:)
        REAL(WP), INTENT(OUT) :: TAUP2(:)
        REAL(WP), INTENT(OUT) :: TAUQ1(:)
        REAL(WP), INTENT(OUT) :: TAUQ2(:)
    END SUBROUTINE DORBDB_F95
END INTERFACE ORBDB
INTERFACE ORCSD
    PURE SUBROUTINE SORCSD_F95(X11,X12,X21,X22,THETA,U1,U2,V1T,V2T,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! SORCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X12(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: U1(:,:)
        REAL(WP), INTENT(OUT) :: U2(:,:)
        REAL(WP), INTENT(OUT) :: V1T(:,:)
        REAL(WP), INTENT(OUT) :: V2T(:,:)
    END SUBROUTINE SORCSD_F95
    PURE SUBROUTINE DORCSD_F95(X11,X12,X21,X22,THETA,U1,U2,V1T,V2T,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,INFO)
        ! Fortran77 call:
        ! DORCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,SIGNS,M,P,Q,X11,LDX11,X12,LDX12,X21,LDX21,X22,LDX22,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIGNS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X12(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(INOUT) :: X22(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: U1(:,:)
        REAL(WP), INTENT(OUT) :: U2(:,:)
        REAL(WP), INTENT(OUT) :: V1T(:,:)
        REAL(WP), INTENT(OUT) :: V2T(:,:)
    END SUBROUTINE DORCSD_F95
END INTERFACE ORCSD
INTERFACE ORCSD2BY1
    PURE SUBROUTINE SORCSD2BY1_F95(X11,X21,THETA,U1,U2,V1T,JOBU1,JOBU2,JOBV1T,INFO)
        ! Fortran77 call:
        ! SORCSD2BY1(JOBU1,JOBU2,JOBV1T,M,P,Q,X11,LDX11,X21,LDX21,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: U1(:,:)
        REAL(WP), INTENT(OUT) :: U2(:,:)
        REAL(WP), INTENT(OUT) :: V1T(:,:)
    END SUBROUTINE SORCSD2BY1_F95
    PURE SUBROUTINE DORCSD2BY1_F95(X11,X21,THETA,U1,U2,V1T,JOBU1,JOBU2,JOBV1T,INFO)
        ! Fortran77 call:
        ! DORCSD2BY1(JOBU1,JOBU2,JOBV1T,M,P,Q,X11,LDX11,X21,LDX21,THETA,U1,LDU1,U2,LDU2,V1T,LDV1T,WORK,LWORK,IWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: X11(:,:)
        REAL(WP), INTENT(INOUT) :: X21(:,:)
        REAL(WP), INTENT(OUT) :: THETA(:)
        REAL(WP), INTENT(OUT) :: U1(:,:)
        REAL(WP), INTENT(OUT) :: U2(:,:)
        REAL(WP), INTENT(OUT) :: V1T(:,:)
    END SUBROUTINE DORCSD2BY1_F95
END INTERFACE ORCSD2BY1
INTERFACE BBCSD
    PURE SUBROUTINE SBBCSD_F95(THETA,PHI,U1,U2,V1T,V2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,INFO)
        ! Fortran77 call:
        ! SBBCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,M,P,Q,THETA,PHI,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: THETA(:)
        REAL(WP), INTENT(INOUT) :: PHI(:)
        REAL(WP), INTENT(INOUT) :: U1(:,:)
        REAL(WP), INTENT(INOUT) :: U2(:,:)
        REAL(WP), INTENT(INOUT) :: V1T(:,:)
        REAL(WP), INTENT(INOUT) :: V2T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22E(:)
    END SUBROUTINE SBBCSD_F95
    PURE SUBROUTINE DBBCSD_F95(THETA,PHI,U1,U2,V1T,V2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,INFO)
        ! Fortran77 call:
        ! DBBCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,M,P,Q,THETA,PHI,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: THETA(:)
        REAL(WP), INTENT(INOUT) :: PHI(:)
        REAL(WP), INTENT(INOUT) :: U1(:,:)
        REAL(WP), INTENT(INOUT) :: U2(:,:)
        REAL(WP), INTENT(INOUT) :: V1T(:,:)
        REAL(WP), INTENT(INOUT) :: V2T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22E(:)
    END SUBROUTINE DBBCSD_F95
    PURE SUBROUTINE CBBCSD_F95(THETA,PHI,U1,U2,V1T,V2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,INFO)
        ! Fortran77 call:
        ! CBBCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,M,P,Q,THETA,PHI,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,RWORK,LRWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: THETA(:)
        REAL(WP), INTENT(INOUT) :: PHI(:)
        COMPLEX(WP), INTENT(INOUT) :: U1(:,:)
        COMPLEX(WP), INTENT(INOUT) :: U2(:,:)
        COMPLEX(WP), INTENT(INOUT) :: V1T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: V2T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22E(:)
    END SUBROUTINE CBBCSD_F95
    PURE SUBROUTINE ZBBCSD_F95(THETA,PHI,U1,U2,V1T,V2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,INFO)
        ! Fortran77 call:
        ! ZBBCSD(JOBU1,JOBU2,JOBV1T,JOBV2T,TRANS,M,P,Q,THETA,PHI,U1,LDU1,U2,LDU2,V1T,LDV1T,V2T,LDV2T,B11D,B11E,B12D,B12E,B21D,B21E,B22D,B22E,RWORK,LRWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU1
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBU2
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV1T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: JOBV2T
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: THETA(:)
        REAL(WP), INTENT(INOUT) :: PHI(:)
        COMPLEX(WP), INTENT(INOUT) :: U1(:,:)
        COMPLEX(WP), INTENT(INOUT) :: U2(:,:)
        COMPLEX(WP), INTENT(INOUT) :: V1T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: V2T(:,:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B11E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B12E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B21E(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22D(:)
        REAL(WP), INTENT(OUT), OPTIONAL, TARGET :: B22E(:)
    END SUBROUTINE ZBBCSD_F95
END INTERFACE BBCSD
INTERFACE HETRI2
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SHETRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! SHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SHETRI2_F95
    PURE SUBROUTINE DHETRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! DHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DHETRI2_F95
    PURE SUBROUTINE CHETRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRI2_F95
    PURE SUBROUTINE ZHETRI2_F95(A,IPIV,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRI2_F95
END INTERFACE HETRI2
INTERFACE HETRI2X
        ! UPLO='U','L'; default: 'U'
    PURE SUBROUTINE SHETRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! SHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE SHETRI2X_F95
    PURE SUBROUTINE DHETRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! DHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE DHETRI2X_F95
    PURE SUBROUTINE CHETRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! CHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE CHETRI2X_F95
    PURE SUBROUTINE ZHETRI2X_F95(A,IPIV,NB,UPLO,INFO)
        ! Fortran77 call:
        ! ZHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        INTEGER, INTENT(IN) :: IPIV(:)
    END SUBROUTINE ZHETRI2X_F95
END INTERFACE HETRI2X
INTERFACE GEQRT
    PURE SUBROUTINE DGEQRT_F95(A,T,NB,INFO)
        ! Fortran77 call:
        ! DGEQRT( M,N,NB,A,LDA,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE DGEQRT_F95
    PURE SUBROUTINE CGEQRT_F95(A,T,NB,INFO)
        ! Fortran77 call:
        ! CGEQRT( M,N,NB,A,LDA,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE CGEQRT_F95
    PURE SUBROUTINE ZGEQRT_F95(A,T,NB,INFO)
        ! Fortran77 call:
        ! ZGEQRT( M,N,NB,A,LDA,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE ZGEQRT_F95
    PURE SUBROUTINE SGEQRT_F95(A,T,NB,INFO)
        ! Fortran77 call:
        ! SGEQRT( M,N,NB,A,LDA,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE SGEQRT_F95
END INTERFACE GEQRT
INTERFACE GEQRT2
    PURE SUBROUTINE DGEQRT2_F95(A,T,INFO)
        ! Fortran77 call:
        ! DGEQRT2( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE DGEQRT2_F95
    PURE SUBROUTINE CGEQRT2_F95(A,T,INFO)
        ! Fortran77 call:
        ! CGEQRT2( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE CGEQRT2_F95
    PURE SUBROUTINE ZGEQRT2_F95(A,T,INFO)
        ! Fortran77 call:
        ! ZGEQRT2( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE ZGEQRT2_F95
    PURE SUBROUTINE SGEQRT2_F95(A,T,INFO)
        ! Fortran77 call:
        ! SGEQRT2( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE SGEQRT2_F95
END INTERFACE GEQRT2
INTERFACE GEQRT3
    PURE SUBROUTINE DGEQRT3_F95(A,T,INFO)
        ! Fortran77 call:
        ! DGEQRT3( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE DGEQRT3_F95
    PURE SUBROUTINE CGEQRT3_F95(A,T,INFO)
        ! Fortran77 call:
        ! CGEQRT3( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE CGEQRT3_F95
    PURE SUBROUTINE ZGEQRT3_F95(A,T,INFO)
        ! Fortran77 call:
        ! ZGEQRT3( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE ZGEQRT3_F95
    PURE SUBROUTINE SGEQRT3_F95(A,T,INFO)
        ! Fortran77 call:
        ! SGEQRT3( M,N,A,LDA,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE SGEQRT3_F95
END INTERFACE GEQRT3
INTERFACE GEMQRT
        ! SIDE='l','r' ; default: 'l'
        ! TRANS='n','c' ; default: 'n'
    PURE SUBROUTINE DGEMQRT_F95(V,T,C,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! DGEMQRT( SIDE,TRANS,M,N,K,NB,V,LDV,T,LDT,C,LDC,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE DGEMQRT_F95
    PURE SUBROUTINE CGEMQRT_F95(V,T,C,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! CGEMQRT( SIDE,TRANS,M,N,K,NB,V,LDV,T,LDT,C,LDC,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE CGEMQRT_F95
    PURE SUBROUTINE ZGEMQRT_F95(V,T,C,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! ZGEMQRT( SIDE,TRANS,M,N,K,NB,V,LDV,T,LDT,C,LDC,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE ZGEMQRT_F95
    PURE SUBROUTINE SGEMQRT_F95(V,T,C,K,NB,SIDE,TRANS,INFO)
        ! Fortran77 call:
        ! SGEMQRT( SIDE,TRANS,M,N,K,NB,V,LDV,T,LDT,C,LDC,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(INOUT) :: C(:,:)
    END SUBROUTINE SGEMQRT_F95
END INTERFACE GEMQRT
INTERFACE TPQRT
    PURE SUBROUTINE DTPQRT_F95(A,B,T,NB,INFO)
        ! Fortran77 call:
        ! DTPQRT( M,N,L,NB,A,LDA,B,LDB,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE DTPQRT_F95
    PURE SUBROUTINE CTPQRT_F95(A,B,T,NB,INFO)
        ! Fortran77 call:
        ! CTPQRT( M,N,L,NB,A,LDA,B,LDB,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE CTPQRT_F95
    PURE SUBROUTINE ZTPQRT_F95(A,B,T,NB,INFO)
        ! Fortran77 call:
        ! ZTPQRT( M,N,L,NB,A,LDA,B,LDB,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE ZTPQRT_F95
    PURE SUBROUTINE STPQRT_F95(A,B,T,NB,INFO)
        ! Fortran77 call:
        ! STPQRT( M,N,L,NB,A,LDA,B,LDB,T,LDT,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: NB
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE STPQRT_F95
END INTERFACE TPQRT
INTERFACE TPQRT2
    PURE SUBROUTINE DTPQRT2_F95(A,B,T,INFO)
        ! Fortran77 call:
        ! DTPQRT2( M,N,L,A,LDA,B,LDB,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE DTPQRT2_F95
    PURE SUBROUTINE CTPQRT2_F95(A,B,T,INFO)
        ! Fortran77 call:
        ! CTPQRT2( M,N,L,A,LDA,B,LDB,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE CTPQRT2_F95
    PURE SUBROUTINE ZTPQRT2_F95(A,B,T,INFO)
        ! Fortran77 call:
        ! ZTPQRT2( M,N,L,A,LDA,B,LDB,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
        COMPLEX(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE ZTPQRT2_F95
    PURE SUBROUTINE STPQRT2_F95(A,B,T,INFO)
        ! Fortran77 call:
        ! STPQRT2( M,N,L,A,LDA,B,LDB,T,LDT,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
        REAL(WP), INTENT(OUT) :: T(:,:)
    END SUBROUTINE STPQRT2_F95
END INTERFACE TPQRT2
INTERFACE TPRFB
        ! SIDE='l','r' ; default: 'l'
        ! TRANS='n','t' ; default: 'n'
        ! DIRECT='f','b' ; default: 'f'
        ! STOREV='c','r' ; default: 'c'
    PURE SUBROUTINE DTPRFB_F95(T,V,A,B,DIRECT,STOREV,SIDE,TRANS)
        ! Fortran77 call:
        ! DTPRFB( SIDE,TRANS,DIRECT,STOREV,M,N,K,L,V,LDV,T,LDT,A,LDA,B,LDB,WORK,LDWORK )
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIRECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: STOREV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DTPRFB_F95
    PURE SUBROUTINE CTPRFB_F95(T,V,A,B,DIRECT,STOREV,TRANS,SIDE)
        ! Fortran77 call:
        ! CTPRFB( SIDE,TRANS,DIRECT,STOREV,M,N,K,L,V,LDV,T,LDT,A,LDA,B,LDB,WORK,LDWORK )
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIRECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: STOREV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CTPRFB_F95
    PURE SUBROUTINE ZTPRFB_F95(T,V,A,B,DIRECT,STOREV,TRANS,SIDE)
        ! Fortran77 call:
        ! ZTPRFB( SIDE,TRANS,DIRECT,STOREV,M,N,K,L,V,LDV,T,LDT,A,LDA,B,LDB,WORK,LDWORK )
        USE F95_PRECISION, ONLY: WP => DP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIRECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: STOREV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZTPRFB_F95
    PURE SUBROUTINE STPRFB_F95(T,V,A,B,DIRECT,STOREV,TRANS,SIDE)
        ! Fortran77 call:
        ! STPRFB( SIDE,TRANS,DIRECT,STOREV,M,N,K,L,V,LDV,T,LDT,A,LDA,B,LDB,WORK,LDWORK )
        USE F95_PRECISION, ONLY: WP => SP
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: DIRECT
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: STOREV
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE STPRFB_F95
END INTERFACE TPRFB
INTERFACE TPMQRT
        ! SIDE='l','r' ; default: 'l'
        ! TRANS='n','c' ; default: 'n'
    PURE SUBROUTINE DTPMQRT_F95(V,T,A,B,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! DTPMQRT( SIDE,TRANS,M,N,K,L,NB,V,LDV,T,LDT,A,LDA,B,LDB,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE DTPMQRT_F95
    PURE SUBROUTINE CTPMQRT_F95(V,T,A,B,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! CTPMQRT( SIDE,TRANS,M,N,K,L,NB,V,LDV,T,LDT,A,LDA,B,LDB,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE CTPMQRT_F95
    PURE SUBROUTINE ZTPMQRT_F95(V,T,A,B,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! ZTPMQRT( SIDE,TRANS,M,N,K,L,NB,V,LDV,T,LDT,A,LDA,B,LDB,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => DP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(WP), INTENT(IN) :: V(:,:)
        COMPLEX(WP), INTENT(IN) :: T(:,:)
        COMPLEX(WP), INTENT(INOUT) :: A(:,:)
        COMPLEX(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE ZTPMQRT_F95
    PURE SUBROUTINE STPMQRT_F95(V,T,A,B,K,NB,TRANS,SIDE,INFO)
        ! Fortran77 call:
        ! STPMQRT( SIDE,TRANS,M,N,K,L,NB,V,LDV,T,LDT,A,LDA,B,LDB,WORK,INFO )
        USE F95_PRECISION, ONLY: WP => SP
        INTEGER, INTENT(IN) :: K
        INTEGER, INTENT(IN) :: NB
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: TRANS
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: SIDE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(WP), INTENT(IN) :: V(:,:)
        REAL(WP), INTENT(IN) :: T(:,:)
        REAL(WP), INTENT(INOUT) :: A(:,:)
        REAL(WP), INTENT(INOUT) :: B(:,:)
    END SUBROUTINE STPMQRT_F95
END INTERFACE TPMQRT
END MODULE LAPACK95
