/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import java.io.DataInputStream;
import java.io.IOException;

public class BoxHeader {
    private long _length;
    private String _type;
    private Jpeg2000Module _module;
    private DataInputStream _dstream;
    private long _headerLength;

    public BoxHeader(Jpeg2000Module jpeg2000Module, DataInputStream dataInputStream) {
        this._module = jpeg2000Module;
        this._dstream = dataInputStream;
    }

    public void readHeader() throws IOException {
        this._length = ModuleBase.readUnsignedInt(this._dstream, true, this._module);
        this._type = this._module.read4Chars(this._dstream);
        if (this._length == 1L) {
            this._length = ModuleBase.readSignedLong(this._dstream, true, this._module);
            this._headerLength = 16L;
        } else {
            this._headerLength = 8L;
        }
    }

    public long getLength() {
        return this._length;
    }

    public long getHeaderLength() {
        return this._headerLength;
    }

    public long getDataLength() {
        return this._length - this._headerLength;
    }

    public String getType() {
        return this._type;
    }
}

