#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Wandersong
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220509.1

# Set game-specific variables

GAME_ID='wandersong'
GAME_NAME='Wandersong'

ARCHIVE_BASE_0='wandersong-drmfree.zip'
ARCHIVE_BASE_0_MD5='27851a4ba540505f11e122f4c9a686b5'
ARCHIVE_BASE_0_TYPE='zip'
ARCHIVE_BASE_0_SIZE='2000000'
ARCHIVE_BASE_0_VERSION='1.0-itch1'
ARCHIVE_BASE_0_URL='https://banov.itch.io/wandersong'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_DOC_DATA_FILES='
ws_credits'
ARCHIVE_GAME_BIN_FILES='
wandersong.exe
GMFile.dll
GMIni.dll'
ARCHIVE_GAME_DATA_FILES='
*.ogg
*.dat
audioData
levels
palettes'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='wandersong.exe'
APP_MAIN_ICON='wandersong.exe'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/AppData/Local/wandersong'
DATA_DIRS="$DATA_DIRS ./userdata"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
