# Print Debian packages providing given Mono libraries list.
# USAGE: dependencies_mono_list_debian $dependencies_mono
dependencies_mono_list_debian() {
	local dependencies_mono
	dependencies_mono="$1"

	local dependency_mono
	while read -r dependency_mono; do
		dependencies_mono_single_debian "$dependency_mono"
	done <<- EOL
	$(printf '%s' "$dependencies_commands")
	EOL
}

# Print Debian packages providing given Mono library.
# USAGE: dependencies_mono_single_debian $dependency_mono
dependencies_mono_single_debian() {
	local dependency_mono
	dependency_mono="$1"

	local package_name
	case "$dependency_mono" in
		('mscorlib.dll')
			package_name='libmono-corlib4.5-cil'
		;;
		('I18N.dll')
			package_name='libmono-i18n4.0-cil'
		;;
		('I18N.West.dll')
			package_name='libmono-i18n-west4.0-cil'
		;;
		('Microsoft.CSharp.dll')
			package_name='libmono-microsoft-csharp4.0-cil'
		;;
		('Mono.CSharp.dll')
			package_name='libmono-csharp4.0c-cil'
		;;
		('Mono.Posix.dll')
			package_name='libmono-posix4.0-cil'
		;;
		('Mono.Security.dll')
			package_name='libmono-security4.0-cil'
		;;
		('OpenTK.dll')
			package_name='libopentk1.1-cil'
		;;
		('OpenTK.Compatibility.dll')
			package_name='libopentk1.1-cil'
		;;
		('OpenTK.GLControl.dll')
			package_name='libopentk1.1-cil'
		;;
		('System.dll')
			package_name='libmono-system4.0-cil'
		;;
		('System.ComponentModel.DataAnnotations.dll')
			package_name='libmono-system-componentmodel-dataannotations4.0-cil'
		;;
		('System.Configuration.dll')
			package_name='libmono-system-configuration4.0-cil'
		;;
		('System.Configuration.Install.dll')
			package_name='libmono-system-configuration-install4.0-cil'
		;;
		('System.Core.dll')
			package_name='libmono-system-core4.0-cil'
		;;
		('System.Data.dll')
			package_name='libmono-system-data4.0-cil'
		;;
		('System.Design.dll')
			package_name='libmono-system-design4.0-cil'
		;;
		('System.Drawing.dll')
			package_name='libmono-system-drawing4.0-cil'
		;;
		('System.IO.Compression.dll')
			package_name='libmono-system-io-compression4.0-cil'
		;;
		('System.IO.Compression.FileSystem.dll')
			package_name='libmono-system-io-compression-filesystem4.0-cil'
		;;
		('System.Management.dll')
			package_name='libmono-system-management4.0-cil'
		;;
		('System.Net.dll')
			package_name='libmono-system-net4.0-cil'
		;;
		('System.Net.Http.dll')
			package_name='libmono-system-net-http4.0-cil'
		;;
		('System.Numerics.dll')
			package_name='libmono-system-numerics4.0-cil'
		;;
		('System.Runtime.Serialization.dll')
			package_name='libmono-system-runtime-serialization4.0-cil'
		;;
		('System.Security.dll')
			package_name='libmono-system-security4.0-cil'
		;;
		('System.Transactions.dll')
			package_name='libmono-system-transactions4.0-cil'
		;;
		('System.Web.dll')
			package_name='libmono-system-web4.0-cil'
		;;
		('System.Web.Extensions.dll')
			package_name='libmono-system-web-extensions4.0-cil'
		;;
		('System.Web.Http.dll')
			package_name='libmono-system-web-http4.0-cil'
		;;
		('System.Web.Services.dll')
			package_name='libmono-system-web-services4.0-cil'
		;;
		('System.Windows.Forms.dll')
			package_name='libmono-system-windows-forms4.0-cil'
		;;
		('System.Xml.dll')
			package_name='libmono-system-xml4.0-cil'
		;;
		('System.Xml.Linq.dll')
			package_name='libmono-system-xml-linq4.0-cil'
		;;
		('WindowsBase.dll')
			package_name='libmono-windowsbase4.0-cil'
		;;
	esac

	if [ -n "${package_name:-}" ]; then
		printf '%s\n' "$package_name"
		return 0
	fi

	dependencies_unknown_mono_libraries_add "$dependency_mono"
}

