!{\src2tex{textfont=tt}}
!!****f* ABINIT/identq
!! NAME
!! identq
!!
!! FUNCTION
!! Identify q-points in whole BZ
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  q(3,nq)=coordinates of q-points in IBZ
!!  ninv=if 2, inversion is considered; if 1, inversion is not considered
!!  nq= number of q points in IBZ
!!  nqbzmx= maximum number of q points in BZ
!!  nop= number of symmetry operations
!!  op(3,3,nop)= symmetry operation matrices
!!
!! OUTPUT
!!  qbz(3,nqbzmx)= q-points in whole BZ
!!  qtab(nqbzmx)= table giving for each q-point in the BZ (qBZ), the corresponding
!!   irreducible point (qIBZ), where qBZ= (IR) qIBZ and I is the inversion or the identity operation
!!  qtabi(nkbzmx)= for each q-point in the BZ defines whether inversion has to be 
!!   considered in the relation qBZ=(IR) qIBZ (1 => only R; -1 => -R)  
!!  qtabo(nqbzmx)= the symmetry operation R that takes qIBZ to each qBZ
!!  nqbz= no. of q-points in whole BZ
!!
!! NOTES
!! For q close to zero only one q-point is counted (i.e. not the
!! rotations and reflections of the little q, nor other little
!! q-points in the qIBZ set)
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      dosym
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine identq(q,nq,nqbzmx,op,nop,ninv,qbz,qtab,qtabi,qtabo,nqbz)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => identq
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ninv,nop,nq,nqbzmx
 integer,intent(out) :: nqbz
!arrays
 integer,intent(out) :: qtab(nqbzmx),qtabi(nqbzmx),qtabo(nqbzmx)
 real(dp),intent(in) :: op(3,3,nop),q(3,nq)
 real(dp),intent(out) :: qbz(3,nqbzmx)

!Local variables ------------------------------
!scalars
 integer :: ii,iinv,iold,iop,iq,iqbz,jj,nqeq0
 character(len=500) :: message
!arrays
 real(dp) :: qnew(3)

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 integer :: icmpk2
 integer :: itst0
#endif
!End of the abilint section

 write(message,'(a)')' identq: identifying q-points'
 call wrtout(06,message,'COLL')

 !Zero no. of q-points found
 nqbz=0

 nqeq0=0

 !Loop over q-points in IBZ
 do iq=1,nq

  !If q is close to zero, treat it differently as described above
  if(itst0(q(1,iq))==1) then
   if(nqeq0==0) then
    nqeq0=1
    nqbz=nqbz+1
    if(nqbz>nqbzmx) then
     write(*,*) '**error identq 1: nqbzmx too small;'
     write(*,*) '                  increase nqbzmx!'
     stop
    end if
    qbz(1,nqbz)=q(1,iq)
    qbz(2,nqbz)=q(2,iq)
    qbz(3,nqbz)=q(3,iq)
    qtab(nqbz)=iq
    qtabo(nqbz)=1
    qtabi(nqbz)=1
   end if
  else
   !Loop over symmetry operations R and inversions I
   do iop=1,nop
    do iinv=1,ninv
     !Form RIk
     call dosym(op(1,1,iop),iinv,q(1,iq),qnew(1))
     !Check whether it has already been found (to within a RL vector)
     iold=0
     do iqbz=1,nqbz
      iold=iold+icmpk2(qnew,qbz(1,iqbz))
     end do
     if(iold==0) then
      nqbz=nqbz+1
      if(nqbz>nqbzmx) then
       write(*,*) '**error identq 2: nqbzmx too small;'
       write(*,*) '                  increase nqbzmx!'
       stop
      end if
      qbz(1,nqbz)=qnew(1)
      qbz(2,nqbz)=qnew(2)
      qbz(3,nqbz)=qnew(3)
      qtab(nqbz)=iq
      qtabo(nqbz)=iop
      qtabi(nqbz)=3-2*iinv
     end if
    end do
   end do
  end if

 end do

 !Print out results
 write(6,'(a,i3,/,a,/,(i5,3f12.6))') ' q-points in irreducible wedge (IBZ) ',&
& nq,' q-points [reciprocal lattice units]:',(jj,(q(ii,jj),ii=1,3),jj=1,nq)
 write(6,'(a,i5,a,/,a,i7,a,/,(4(i5,3f5.2)))')&
& ' together with the',nop,' symmetry operations and inversion',&
& ' have yielded',nqbz,' q-points in Brillouin Zone (BZ):',&
& (jj,(qbz(ii,jj),ii=1,3),jj=1,nqbz)
 write(*,*)

end subroutine identq
!!***
