# An Anarchist FAQ after ten years

It is now ten years since ["An Anarchist FAQ"](index.md) (AFAQ) was
officially released. A lot has happened over that time, unfortunately
finishing it has not been one of them!

Over that decade, AFAQ has changed considerably. It was initially conceived as
a energy-saving device to stop anarchists having to continually make the same
points against claims that "anarcho"-capitalism was a form of anarchism. As
would be expected, the quality of the initial versions and sections were
pretty mixed. Most of it was extremely good (even if we do say so ourselves!)
and has required little change over the decade (mostly we have built upon and
expanded the original material). A few bits were less good and have been
researched more and rewritten. We have also, of course, made mistakes and
corrected them when we have been informed about them or have discovered them
ourselves. In general, though, our initial work has stood up well and while we
were occasionally wrong on a few details, the general thrust of even these
areas has been proven correct. Overall, our aim to produce an FAQ which
reflected the majority of anarchist thought, both currently and historically
from an international perspective, has been a success as shown by the number
of mirrors, links and translations AFAQ has seen (being published by AK Press
confirms this).

Since the official release, AFAQ has changed. When we released it back in
1996, we had already decided to make it a FAQ about anarchism rather than an
FAQ on why anarchism is anti-capitalist. However, the first versions still
bore the marks of its origins. We realised that this limited it somewhat and
we have slowly revised the AFAQ so that it has become a resource about
anarchism (indeed, if it were to be started again the section on
"anarcho"-capitalism would be placed into an appendix, where it belongs). This
means that the aim of AFAQ has changed. I would say that it has two related
goals:

> 1\. To present the case for anarchism, to convince people they should become
> anarchists.

> 2\. To be a resource for existing anarchists, to use to bolster their
> activism and activities by presenting facts and arguments to allow them to
> defend anarchism against those opposed to it (Marxists, capitalists, etc.).

Te second goal explains why, for example, we spend a lot of time refuting
capitalist economics and Marxism/Leninism (partly, because many of the facts
and arguments are in academic books which are unavailable to the general
public). We hope that AFAQ has proved useful to our comrades as much as we
hope we have convinced non-anarchists, at best, to become anarchists, or, at
worse, to take our ideas seriously. Hopefully, the two aims are mutually
complementary.

Not only has AFAQ changed over the last ten years, so has the anarchist and
general political landscape on the internet. When AFAQ was being initially
created, the number of anarchists on-line was small. There were not that many
anarchist webpages and, relatively speaking, right-wing "libertarians" were
un-opposed in arguing that "anarcho"-capitalism was a form of anarchism (the
only FAQ was Caplan's biased and inaccurate "Anarchist Theory FAQ"). As a non-
American, I was surprised that this oxymoron even existed (I still am, as are
all the anarchists I mention it to). Anarchism has always been a **socialist**
theory and the concept of an "anarchism" which supported the economic system
anarchism was born opposing is nonsense. Arguing with its supporters and
reading up on it convinced me that the only real link it has with anarchism is
simply its attempted appropriation of the name. [1] Hence the pressing need
for a **real** anarchist FAQ, a need AFAQ successfully met.

Luckily, over the 1990s things changed. More anarchists went online, anarchist
organisations created a web presence and the balance of forces changed to
reflect reality (i.e. there are far more anarchists than
"anarcho"-capitalists). The anti-capitalist movement helped, putting
anarchists back in the news (the BBC even linked to AFAQ for those interested
in finding out what anarchists wanted!) Even in the USA, things got better and
after Seattle genuine anarchism could no longer be ignored. This produced some
articles by "anarcho"-capitalists, explaining how there are two forms of
anarchism and that the two have nothing or little in common (if that is the
case, why call your ideology anarchism?). Anarchist organisations and activism
increased and the awareness that anarchism was anti-hierarchy, anti-state
**and** anti-capitalist increased. As an added bonus, some genuine
individualist anarchists appeared, refuting the claim that
"anarcho"-capitalism was merely a form of "updated" individualist anarchism.
All these developments were welcomed, as were the words of praise and
encouragement we received for our work on AFAQ from many anarchists
(including, it must be stressed, individualist ones). Today, genuine anarchism
in all its forms has a much greater profile, as is anarchist opposition to
"anarcho"-capitalism and its claims. We hope AFAQ played a role, however
small, in that process.

Of course, the battle is not over. On Wikipedia, for example,
right-"libertarians" are busy trying to rewrite the history of anarchism. Some
anarchists have tried to counteract this attempt, and have meant with
differing degrees of success. We urge you to get involved, if you have the
time and energy as numbers, sadly, do seem to count. This is because we
anarchists are up against people who, apparently, do not have a life and so
can wage a war of attrition against those who try and include relevant facts
to the entries (such as the obvious anti-capitalism of "traditional"
anarchism, that anarchism is **not** compatible with government or hierarchy
-- hence an- **archy**! -- or that calling yourself an anarchist does not
necessarily make it so). It is a shame that such a promising project has been
derailed by ideologues whose ignorance of the subject matter is matched only
by their hatred of AFAQ which they deny is a "credible" or valid reference on
anarchism.

I am not surprised that AFAQ is hated by the "libertarian" right (nor will I
be surprised if it is equally hated by the authoritarian left). After all, it
presents the case for genuine anarchism, exposes the claims of a capitalist
"anarchism" for the nonsense they are and shows how deeply authoritarian
right-wing "libertarianism" actually is. That the FAQ can be called "biased"
by these people goes without saying (it is, after all, a FAQ about anarchism
written by anarchists). What seems funny is that they just do not comprehend
that anarchists take offence to their pretensions of labelling their ideology
"anarchism," that we would seek to refute such claims and that their notion
that "anarcho"-capitalism is anarchist is far more biased. Let us hope that
more academics will pay attention to this and the obvious fact that there is a
very long list of anarchists, famous and not-so-famous, who consider the whole
concept an oxymoron.

Equally unsurprising is the attempt to deny that AFAQ is a valid reference on
Wikipedia. This boils down to the claim that the authors are "nobodies." Given
that Kropotkin always stressed that anarchism was born from the people, I take
that intended insult as a badge of pride. I have always taken the position
that it is not who says something that counts, but what they say. In other
words, I would far sooner quote a "nobody" who knows what they are talking
about than a "somebody" who does not. As AFAQ indicates with its many
refutations of straw man arguments against anarchism, there are plenty of the
latter. Ultimately, the logical conclusion of such an argument is that
anarchists are not qualified to discuss anarchism, an inherently silly
position but useful if you are seeking to turn anarchism into something it is
not.

Given that even such an usually reliable expert as the late, great, Paul
Avrich made mistakes, this position is by far the most sensible. Between what
a suitably qualified "expert" writes and what actual anarchists say and do, I
always go for the latter. Any serious scientist would do so, but sadly many do
not -- instead, we get ideology. A classic example is Eric Hobsbawm's thesis
on **"Primitive Rebels"** which he decided to illustrate, in part, with the
example of Spanish anarchism. As we recount as part of our appendix on
"Marxism and Spanish Anarchism" while being undoubtedly a "somebody" and
immensely qualified to write on the subject, his account was utter nonsense.
This was proven beyond doubt when an anthologist interviewed the survivors of
the Casas Viejas massacre. Their account of the event had only appeared
previously in anarchist papers at the time and both, needless to say, refuted
Hobsbawm.

So, to be called a "nobody" is quite a complement, given how many of the
"somebodies" have not stopped being ignorant of anarchism from putting pen to
paper and exposing that ignorance to the world (the worse recent example of
this, outside of Marxism, must be George Monbiot's terrible comments in his
**"Age of Consent"** ). So, when it comes to saying what anarchism is, I turn
to anarchists. This is what the "experts" should be doing anyway if they were
doing their job.

Are we "qualified" to write about anarchism? Well, the the collective has
always been made up of anarchists, so we have an anarchist FAQ written by
anarchists. It has always been a popular site, given the number of mirrors,
translations and links it has been given (one mirror called it "world
famous"). It is being published by AK Press, one of the leading anarchist
publishers in the world.

I am the main editor and contributor to AFAQ. While one contributor to
Wikipedia claimed I as an American academic, this is not the case. I have a
"real" job and work on AFAQ in my spare time (I do despair when people,
particularly leftists, assume that wage slaves are incapable of producing
works like AFAQ). I have been always been an anarchist since becoming
politically aware which means I have been an anarchist activist for
approximately 20 years (time flies when you are having fun!). I have been a
member of numerous anarchist groups and have contributed to many anarchist
publications and websites. As can be seen from my personal webpage [2], I
regularly contribute articles to **Freedom** (the leading English-language
anarchist newspaper). Rarely does an issue come out without something by me it
in. Moreover, some of the longer articles have appeared in **Black Flag**
(before and after I joined its editorial committee). My works have also been
published in **Scottish Anarchist** , **Anarcho-Syndicalist Review** and
**Free Voices** and some have been translated into other languages. I am also
otherwise involved with). In addition, I have been invited to speak at
anarchist conferences in Scotland and Ireland, as well as by Marxist parties
to debate the merits of anarchism. Due to family commitments, my specifically
anarchist activities are pretty much limited to writing these days, but I
remain a reasonably active trade unionist.

I will leave it up to the reader to decide whether we are "qualified" to write
about anarchism or not!

But as I said, I always consider what is said more important than who says it.
The fact that AFAQ is so popular with anarchists is what counts and I hope
that we continue to be. We are always looking for help and suggestions, so if
you want to get involved or want something added or changed, please contact us
-- we consider AFAQ as a resource for anarchists and we want it to reflect
what anarchists think and do. [3] However, if you do want something changed or
added be prepared to do some or all of the work yourself as we have our own
plans on future developments and may not be able to provide the time or energy
for other changes. Also, if you spot a mistake or a typo, please inform us as
no matter how often we check errors do creep in. We take our task seriously
and correct all errors when informed of them (differences in interpretation or
terminology are not, of course, errors). [4]

Speaking personally, I have enjoyed being part of this project. I have learned
a lot and have gained a better understanding of many anarchist thinkers and
historical events. For example, I can now understand why Daniel Guerin was so
interested in Proudhon and why it has been a crying shame that Voltairine de
Cleyre's works have been unavailable for 8 decades. As such, my understanding
and appreciation of anarchism has been enriched by working on AFAQ and I hope
that others have had a similar experience reading it. On the negative side,
I've had to read some terrible books and articles but very few, if any, of
those were anarchist. But this is minor. The work has been worth it and while
it has taken longer than any of us had imagined at the start, I'm glad that we
are still working on it ten years later as AFAQ is much improved for all that
time and energy. If nothing else, this work has reinforced my belief in the
positive ideas and ideals of anarchism and confirmed why I became an anarchist
so long ago. And, let me be honest, I would not do it unless I enjoyed it!

What of the future? Obviously, we know that AFAQ is not the final word on
anarchism (we have always stressed that this is **An** Anarchist FAQ and not
"The Anarchist FAQ," although some do call it that). The immediate aim is to
revise the existing main sections of AFAQ for publication, which we are slowly
doing. In the process some previous work is being added to and, in some cases,
totally revised. After ten years, our knowledge of many subjects has expanded
considerably. We have also asked a couple of individualist anarchist comrades
to have a look over section G and hopefully their input will flesh out that
section when it comes to be revised (for all its flaws, individualist
anarchism deserves far more than to be appropriated by the right and social
anarchists should be helping its modern supporters attempts to reclaim their
radical tradition). [5] Once the revision of the main body of AFAQ is
complete, the appendix on the Russian Revolution will be finished and then all
the appendices will be revised.

After that, AFAQ will be added to once new information becomes available and
new anarchist social movements and ideas develop. We have not covered
everything nor does AFAQ discussed all developments within anarchism in all
countries. If you think we have missed something, then contact us and we can
arrange to include the subject and issues missing. As noted above, though, do
**not** expect us to do all the work for you. This is a resource for the
movement and, as such, we expect fellow anarchists to help out beyond merely
suggesting things they expect **others** to do!

Hopefully, after summarising 19th and 20th century anarchism, the anarchists
of the 21st century will use that to build and develop new ideas and movements
and create both viable anarchist alternatives under statism and capitalism
and, eventually, a free society. Whether we do so or not is, ultimately, up to
us. Let us hope we can rise to the challenge! I do hope that anarchists can
rise above the often silly arguments that we often inflict on each other and
concentrate on the 90%+ that unites us rather than the often insignificant
differences some consider so important. One thing is sure, if we do not then
the worse will happen.

Finally, another personal note. On the way to work, I go past a little park.
This little oasis of green in the city is a joy to behold, more so since
someone has added this piece of graffiti to one of its walls:

_"Resistance is **never** futile! Have a nice day, y'all. Love Friday, XXX"_

With that in mind, we dedicate the ten year anniversary release of "An
Anarchist FAQ" to all those "nobodies," all those anarchists who are not
famous or have the appropriate "qualifications", but whose activity, thoughts,
ideas, ideals, dreams and hopes give the "somebodies" something to write about
(even if they fail to get some, or even all of it, right).

Iain McKay

_**Notes**_

1\. While "anarcho"-capitalism has some overlap with individualist anarchism,
it lacks the radical and socialist sensibility and aims of the likes of Tucker
which makes the latter anarchist, albeit a flawed and inconsistent form.
Unlike the former, individualist anarchism **can** become consistent anarchism
by simply applying its own principles in a logical manner.

2\. Under my pseudonym "Anarcho" (given what's on it, I'm surprised I bother
using "Anarcho" these days as it is obvious who writes the articles). It is

3\. Apologies for those who sent emails over the years and never received a
reply -- some were lost and, given how much busy we are, emails are always the
first to suffer.

4\. For a discussion of one early incident, mentioned in the Wikipedia entry
on AFAQ, see my article ( _"An Anarchist FAQ, David Friedman and Medieval
Iceland"_ on my webpage). Suffice to say, once we became aware of his new
criticism this year (Friedman did not bother to inform us directly), we sped
up our planned revision and expansion of that section and corrected the few
mistakes that had remained. In summary, it can be said our original critique
remained valid in spite of some serious errors in details caused by a failure
to check sources in a rush to officially release it. We learned our lesson and
try not to make the same mistake again (and have not, as far as I am aware).

5\. A few people have said that AFAQ does not give equal billing to
individualist anarchism. However, in terms of numbers and influence it has
always been very much a minority trend in anarchism outside of America. By the
1880s, this was probably the case in America as well and by the turn of the
20th century it was definitely the case (as noted by, among others, Paul
Avrich). As such, it is hardly a flaw that AFAQ has presented the majority
position on anarchism (social anarchism), particularly as this is the position
of the people involved.

[‹ An Anarchist FAQ Introduction](intro.md "Go to previous page")
[up](intro.md "Go to parent page") [An Anarchist FAQ: Introduction to Volume
1 ›](vol1intro.md "Go to next page")

