/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import org.w3c.dom.Attr;

final class TinyAttributeImpl
extends TinyNodeImpl
implements Attr {
    public TinyAttributeImpl(TinyDocumentImpl tinyDocumentImpl, int n) {
        this.document = tinyDocumentImpl;
        this.nodeNr = n;
    }

    public NodeInfo getParent() {
        return this.document.getNode(this.document.attParent[this.nodeNr]);
    }

    protected long getSequenceNumber() {
        long l = ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.document.alpha[this.document.attParent[this.nodeNr]]);
        return l;
    }

    public final int getNodeKind() {
        return 2;
    }

    public String getStringValue() {
        return this.document.attValue[this.nodeNr].toString();
    }

    public int getFingerprint() {
        return this.document.attCode[this.nodeNr] & 0xFFFFF;
    }

    public int getNameCode() {
        return this.document.attCode[this.nodeNr];
    }

    public String getPrefix() {
        int n = this.document.attCode[this.nodeNr];
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.document.getNamePool().getPrefix(n);
    }

    public String getDisplayName() {
        return this.document.getNamePool().getDisplayName(this.document.attCode[this.nodeNr]);
    }

    public String getLocalPart() {
        return this.document.getNamePool().getLocalName(this.document.attCode[this.nodeNr]);
    }

    public final String getURI() {
        return this.document.getNamePool().getURI(this.document.attCode[this.nodeNr]);
    }

    public int getTypeAnnotation() {
        return this.document.getAttributeAnnotation(this.nodeNr);
    }

    public String generateId() {
        return this.getParent().generateId() + "a" + this.document.attCode[this.nodeNr];
    }

    public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        int n2 = this.document.attCode[this.nodeNr];
        int n3 = bl ? this.getTypeAnnotation() : -1;
        receiver.attribute(n2, n3, this.getStringValue(), 0);
    }

    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }
}

