# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ListBlobsIncludeItem(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    COPY = "copy"
    DELETED = "deleted"
    METADATA = "metadata"
    SNAPSHOTS = "snapshots"
    UNCOMMITTEDBLOBS = "uncommittedblobs"
    VERSIONS = "versions"
    TAGS = "tags"

class PathExpiryOptions(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NEVER_EXPIRE = "NeverExpire"
    RELATIVE_TO_CREATION = "RelativeToCreation"
    RELATIVE_TO_NOW = "RelativeToNow"
    ABSOLUTE = "Absolute"

class PathGetPropertiesAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    GET_ACCESS_CONTROL = "getAccessControl"
    GET_STATUS = "getStatus"

class PathLeaseAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ACQUIRE = "acquire"
    BREAK_ENUM = "break"
    CHANGE = "change"
    RENEW = "renew"
    RELEASE = "release"

class PathRenameMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    LEGACY = "legacy"
    POSIX = "posix"

class PathResourceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DIRECTORY = "directory"
    FILE = "file"

class PathSetAccessControlRecursiveMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SET = "set"
    MODIFY = "modify"
    REMOVE = "remove"

class PathUpdateAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    APPEND = "append"
    FLUSH = "flush"
    SET_PROPERTIES = "setProperties"
    SET_ACCESS_CONTROL = "setAccessControl"
    SET_ACCESS_CONTROL_RECURSIVE = "setAccessControlRecursive"
