/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxcoo
 * Create date:	2006-01-06 19:03
 */

#ifndef RATEMEASURE_H_
#define RATEMEASURE_H_

#include "BitStorm.h"
#include <list>

#define MaxPriorityLevel		5

typedef struct
{
	IRateMeasureClient* client;
	bool remove;
}TRateMeasureCtx;

typedef std::list<TRateMeasureCtx> TRateMeasureClientList;

class CRateMeasure : public IRateMeasure
{
public:
	CRateMeasure();
	virtual ~CRateMeasure();
private:
	TRateMeasureClientList _clientList;
	unsigned int _upSpeed;
	unsigned int _downSpeed;
	unsigned int _lastTick;
	unsigned int _upCount;
	unsigned int _downCount;
	
	bool _writeBlocked;
	bool _readBlocked;
private:
	void resetAllPriority();
	void scheduleUpload();
	void scheduleDownload();
	void blockReadAll(bool block);
	void blockWriteAll(bool block);
public:	
	void addClient(IRateMeasureClient* client);
	void removeClient(IRateMeasureClient* client);	
	
	void update();
	
	void setUploadSpeed(unsigned int sp);
	void setDownloadSpeed(unsigned int sp);	
	unsigned int getUploadSpeed();
	unsigned int getDownloadSpeed();	
};

#endif /*RATEMEASURE_H_*/
