//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobSelectorWidget.h
//! @brief     Defines class JobSelectorWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBSELECTORWIDGET_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBSELECTORWIDGET_H

#include <QWidget>

class QSplitter;
class JobModel;
class JobItem;
class JobListView;
class JobPropertiesWidget;

//! The JobSelectorWidget class represents left panel of JobView. Contains a tree to select jobs
//! on the top and job property editor at the bottom.

class JobSelectorWidget : public QWidget {
    Q_OBJECT

public:
    explicit JobSelectorWidget(JobModel* jobModel, QWidget* parent = nullptr);
    ~JobSelectorWidget();

    void resizeEvent(QResizeEvent* event) override;

    QVector<JobItem*> selectedJobItems() const;

signals:
    void selectedJobsChanged(const QVector<JobItem*>& jobs);

public slots:
    void makeJobItemSelected(JobItem*);

private slots:
    void onSelectedJobsChanged(const QVector<JobItem*>& jobs);

private:
    void applySettings();
    void saveSettings();

    QSplitter* m_splitter;
    JobListView* m_jobListView;
    JobPropertiesWidget* m_jobProperties;
    JobModel* m_jobModel;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBSELECTORWIDGET_H
