#!/usr/bin/env python
import re
from subprocess import call, PIPE
import sys

def minigrep(pattern, filename):
    setup = open(filename, 'rb')
    for line in setup:
        match = re.search(pattern, line)
        if match is not None:
            return match

version = minigrep("__version__ = '([^']*)'", '__init__.py').group(1)
print "Release: %s" % version

newsmatch = minigrep('Release %s' % (version), 'NEWS')
if newsmatch is None:
    print "NEWS entry missing"
    sys.exit(1)
else:
    print "NEWS entry found"

setupmatch = minigrep('version="%s"' % (version), 'setup.py')
if setupmatch is None:
    print "setup.py is stale"
    sys.exit(1)
else:
    print "setup.py is good"

if call(['bzr', 'diff'], stdout=PIPE) != 0:
    print "Please commit before releasing"
    sys.exit(1)
