; Inno Setup script.
;
; Initially generated by the Inno Setup Script Wizard.
; See https://jrsoftware.org/ishelp/ .
;
; For debug purposes you can run it from InnoSetup GUI, just uncomment and adjust MyAppSrcDir .
; But for production it should always be used from command-line by calling
; "./pack_release.sh windows_installer".
; The pack_release.sh will prepare directory for this to work (MyAppSrcDir),
; and configure output dir and filename.

#define MyAppName "Castle Game Engine"
#define MyAppPublisher "Michalis Kamburelis & Castle Game Engine Contributors"
#define MyAppURL "https://castle-engine.io/"
#define MyAppExeFullName "bin\castle-editor.exe"

; CGE version.
; Define passed on the command-line by pack_release.sh.
;#define MyAppVersion "7.0-alpha.snapshot"

; CGE directory to distribute.
; Usually created by pack_release.sh , and define passed on the command-line by pack_release.sh.
; We assume it has the same contents as the files we pack to zip.
;#define MyAppSrcDir "C:\customize-MyAppSrcDir-in-innosetup-file"

[Setup]
; NOTE: The value of AppId uniquely identifies this application. Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{8B78FCA1-AD29-42A5-B48A-D1C11297CB48}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={autopf}\{#MyAppName}
DisableProgramGroupPage=yes
LicenseFile={#MyAppSrcDir}\COPYING.md

; This works, but actually showing README.md at this point feels more distracting than helpful.
; Our website, from which user presumably downloaded the CGE, presents engine much better.
; InfoAfterFile={#MyAppSrcDir}\README.md

; TODO: This is better (give both options, use dialog),
; but for now in admin mode opening+running examples doesn't work without
; manual copy (because they are read-only).
; So to make things simpler, for now we just default to user-only install.
; ; Uncomment the following line to run in non administrative install mode (install for current user only.)
; ;PrivilegesRequired=lowest
; PrivilegesRequiredOverridesAllowed=dialog
PrivilegesRequired=lowest

OutputBaseFilename=castle-engine-setup
SetupIconFile={#MyAppSrcDir}\doc\pasdoc\logo\castle_game_engine_icon.ico
Compression=lzma
SolidCompression=yes
WizardStyle=modern

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "armenian"; MessagesFile: "compiler:Languages\Armenian.isl"
Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "bulgarian"; MessagesFile: "compiler:Languages\Bulgarian.isl"
Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "corsican"; MessagesFile: "compiler:Languages\Corsican.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "danish"; MessagesFile: "compiler:Languages\Danish.isl"
Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "finnish"; MessagesFile: "compiler:Languages\Finnish.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"
Name: "hebrew"; MessagesFile: "compiler:Languages\Hebrew.isl"
Name: "icelandic"; MessagesFile: "compiler:Languages\Icelandic.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "japanese"; MessagesFile: "compiler:Languages\Japanese.isl"
Name: "norwegian"; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: "polish"; MessagesFile: "compiler:Languages\Polish.isl"
Name: "portuguese"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "slovak"; MessagesFile: "compiler:Languages\Slovak.isl"
Name: "slovenian"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "turkish"; MessagesFile: "compiler:Languages\Turkish.isl"
Name: "ukrainian"; MessagesFile: "compiler:Languages\Ukrainian.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "{#MyAppSrcDir}\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{autoprograms}\{#MyAppName}"; Filename: "{app}\{#MyAppExeFullName}"
Name: "{autodesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeFullName}"; Tasks: desktopicon

[Run]
Filename: "{app}\{#MyAppExeFullName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent

