from __future__ import absolute_import, division, print_function
from scitbx.array_family import flex
from libtbx import group_args
from libtbx.utils import user_plus_sys_time
import sys
from mmtbx.refinement.real_space import individual_sites
import mmtbx
from libtbx.test_utils import approx_equal
import random

pdb_str_1 = """\
CRYST1   44.034   76.843   61.259  90.00  90.00  90.00 P 1
ATOM      1  N   ASP L   1      41.447  57.169  45.669  1.00 34.60           N
ATOM      2  CA  ASP L   1      40.038  57.202  45.296  1.00 33.86           C
ATOM      3  C   ASP L   1      39.148  56.790  46.463  1.00 34.02           C
ATOM      4  O   ASP L   1      39.627  56.584  47.579  1.00 32.23           O
ATOM      5  CB  ASP L   1      39.782  56.293  44.092  1.00 33.99           C
ATOM      6  CG  ASP L   1      40.582  56.702  42.872  1.00 36.93           C
ATOM      7  OD1 ASP L   1      41.690  57.254  43.043  1.00 36.67           O
ATOM      8  OD2 ASP L   1      40.104  56.473  41.741  1.00 38.81           O
ATOM      9  N   VAL L   2      37.851  56.671  46.199  1.00 31.94           N
ATOM     10  CA  VAL L   2      36.892  56.284  47.227  1.00 29.81           C
ATOM     11  C   VAL L   2      36.530  54.807  47.114  1.00 28.28           C
ATOM     12  O   VAL L   2      35.964  54.372  46.111  1.00 27.24           O
ATOM     13  CB  VAL L   2      35.606  57.127  47.144  1.00 30.66           C
ATOM     14  CG1 VAL L   2      34.601  56.664  48.188  1.00 29.42           C
ATOM     15  CG2 VAL L   2      35.927  58.603  47.321  1.00 31.43           C
ATOM     16  N   GLN L   3      36.861  54.041  48.148  1.00 25.93           N
ATOM     17  CA  GLN L   3      36.573  52.612  48.166  1.00 24.46           C
ATOM     18  C   GLN L   3      35.111  52.348  48.513  1.00 23.33           C
ATOM     19  O   GLN L   3      34.627  52.769  49.564  1.00 20.10           O
ATOM     20  CB  GLN L   3      37.487  51.893  49.160  1.00 29.74           C
ATOM     21  CG  GLN L   3      37.255  50.393  49.245  1.00 39.72           C
ATOM     22  CD  GLN L   3      38.179  49.715  50.238  1.00 51.31           C
ATOM     23  OE1 GLN L   3      38.121  48.500  50.428  1.00 57.11           O
ATOM     24  NE2 GLN L   3      39.037  50.500  50.879  1.00 54.00           N
ATOM     25  N   MET L   4      34.414  51.648  47.624  1.00 24.27           N
ATOM     26  CA  MET L   4      33.008  51.326  47.834  1.00 22.89           C
ATOM     27  C   MET L   4      32.787  49.818  47.865  1.00 21.48           C
ATOM     28  O   MET L   4      32.978  49.132  46.861  1.00 23.73           O
ATOM     29  CB  MET L   4      32.143  51.962  46.744  1.00 22.77           C
ATOM     30  CG  MET L   4      32.234  53.478  46.685  1.00 20.45           C
ATOM     31  SD  MET L   4      31.709  54.267  48.219  1.00 23.95           S
ATOM     32  CE  MET L   4      30.016  53.694  48.332  1.00 24.76           C
ATOM     33  N   THR L   5      32.384  49.307  49.024  1.00 20.55           N
ATOM     34  CA  THR L   5      32.137  47.880  49.188  1.00 20.64           C
ATOM     35  C   THR L   5      30.758  47.623  49.787  1.00 20.08           C
ATOM     36  O   THR L   5      30.470  48.043  50.908  1.00 20.87           O
ATOM     37  CB  THR L   5      33.205  47.222  50.082  1.00 23.39           C
ATOM     38  OG1 THR L   5      34.500  47.405  49.497  1.00 30.91           O
ATOM     39  CG2 THR L   5      32.928  45.734  50.235  1.00 26.97           C
ATOM     40  N   GLN L   6      29.910  46.932  49.033  1.00 21.97           N
ATOM     41  CA  GLN L   6      28.560  46.619  49.487  1.00 25.11           C
ATOM     42  C   GLN L   6      28.538  45.331  50.302  1.00 25.56           C
ATOM     43  O   GLN L   6      29.299  44.401  50.033  1.00 26.32           O
ATOM     44  CB  GLN L   6      27.607  46.505  48.296  1.00 20.36           C
ATOM     45  CG  GLN L   6      27.503  47.771  47.461  1.00 21.68           C
ATOM     46  CD  GLN L   6      26.548  47.622  46.293  1.00 20.77           C
ATOM     47  OE1 GLN L   6      26.357  48.553  45.510  1.00 24.00           O
ATOM     48  NE2 GLN L   6      25.943  46.447  46.169  1.00 16.25           N
ATOM     49  N   THR L   7      27.660  45.282  51.299  1.00 27.28           N
ATOM     50  CA  THR L   7      27.538  44.109  52.157  1.00 29.94           C
ATOM     51  C   THR L   7      26.089  43.889  52.585  1.00 30.28           C
ATOM     52  O   THR L   7      25.491  44.753  53.226  1.00 30.65           O
ATOM     53  CB  THR L   7      28.422  44.233  53.412  1.00 33.05           C
ATOM     54  OG1 THR L   7      29.794  44.368  53.022  1.00 36.48           O
ATOM     55  CG2 THR L   7      28.269  43.004  54.295  1.00 38.31           C
ATOM     56  N   PRO L   8      25.520  42.725  52.232  1.00 29.43           N
ATOM     57  CA  PRO L   8      26.179  41.675  51.448  1.00 27.63           C
ATOM     58  C   PRO L   8      26.083  41.916  49.943  1.00 27.58           C
ATOM     59  O   PRO L   8      25.780  43.030  49.515  1.00 28.53           O
ATOM     60  CB  PRO L   8      25.407  40.419  51.846  1.00 27.24           C
ATOM     61  CG  PRO L   8      24.029  40.920  52.105  1.00 29.03           C
ATOM     62  CD  PRO L   8      24.184  42.305  52.692  1.00 28.99           C
ATOM     63  N   LEU L   9      26.338  40.876  49.156  1.00 27.41           N
ATOM     64  CA  LEU L   9      26.274  40.980  47.703  1.00 25.92           C
ATOM     65  C   LEU L   9      25.097  40.188  47.145  1.00 23.43           C
ATOM     66  O   LEU L   9      24.438  40.621  46.199  1.00 22.17           O
ATOM     67  CB  LEU L   9      27.581  40.494  47.073  1.00 26.82           C
ATOM     68  CG  LEU L   9      28.849  41.254  47.468  1.00 33.53           C
ATOM     69  CD1 LEU L   9      30.067  40.663  46.777  1.00 35.06           C
ATOM     70  CD2 LEU L   9      28.710  42.734  47.147  1.00 36.76           C
ATOM     71  N   THR L  10      24.838  39.026  47.735  1.00 20.90           N
ATOM     72  CA  THR L  10      23.740  38.173  47.299  1.00 23.73           C
ATOM     73  C   THR L  10      22.684  38.031  48.390  1.00 25.10           C
ATOM     74  O   THR L  10      23.005  37.746  49.544  1.00 24.48           O
ATOM     75  CB  THR L  10      24.238  36.772  46.895  1.00 23.27           C
ATOM     76  OG1 THR L  10      24.872  36.146  48.018  1.00 30.08           O
ATOM     77  CG2 THR L  10      25.232  36.871  45.748  1.00 27.84           C
ATOM     78  N   LEU L  11      21.424  38.231  48.018  1.00 26.12           N
ATOM     79  CA  LEU L  11      20.320  38.127  48.964  1.00 30.70           C
ATOM     80  C   LEU L  11      19.036  37.690  48.268  1.00 32.76           C
ATOM     81  O   LEU L  11      18.621  38.290  47.276  1.00 33.60           O
ATOM     82  CB  LEU L  11      20.101  39.460  49.682  1.00 33.97           C
ATOM     83  CG  LEU L  11      18.971  39.499  50.712  1.00 39.69           C
ATOM     84  CD1 LEU L  11      19.220  38.487  51.820  1.00 43.19           C
ATOM     85  CD2 LEU L  11      18.813  40.899  51.285  1.00 43.64           C
ATOM     86  N   SER L  12      18.411  36.641  48.793  1.00 31.08           N
ATOM     87  CA  SER L  12      17.172  36.122  48.224  1.00 30.15           C
ATOM     88  C   SER L  12      15.954  36.698  48.939  1.00 29.02           C
ATOM     89  O   SER L  12      15.715  36.406  50.111  1.00 28.74           O
ATOM     90  CB  SER L  12      17.150  34.594  48.293  1.00 32.01           C
ATOM     91  OG  SER L  12      15.951  34.077  47.743  1.00 36.13           O
ATOM     92  N   VAL L  13      15.187  37.516  48.226  1.00 26.21           N
ATOM     93  CA  VAL L  13      13.995  38.135  48.791  1.00 28.30           C
ATOM     94  C   VAL L  13      12.731  37.623  48.109  1.00 28.12           C
ATOM     95  O   VAL L  13      12.554  37.789  46.902  1.00 28.03           O
ATOM     96  CB  VAL L  13      14.046  39.670  48.671  1.00 28.47           C
ATOM     97  CG1 VAL L  13      12.767  40.288  49.216  1.00 31.69           C
ATOM     98  CG2 VAL L  13      15.263  40.219  49.399  1.00 29.64           C
ATOM     99  N   THR L  14      11.854  36.999  48.890  1.00 27.89           N
ATOM    100  CA  THR L  14      10.605  36.462  48.364  1.00 28.32           C
ATOM    101  C   THR L  14       9.565  37.562  48.182  1.00 26.52           C
ATOM    102  O   THR L  14       9.776  38.704  48.591  1.00 25.01           O
ATOM    103  CB  THR L  14      10.028  35.370  49.284  1.00 28.53           C
ATOM    104  OG1 THR L  14       9.757  35.925  50.577  1.00 32.97           O
ATOM    105  CG2 THR L  14      11.012  34.219  49.426  1.00 29.78           C
ATOM    106  N   ILE L  15       8.441  37.211  47.566  1.00 27.49           N
ATOM    107  CA  ILE L  15       7.366  38.167  47.328  1.00 30.40           C
ATOM    108  C   ILE L  15       6.549  38.404  48.594  1.00 31.66           C
ATOM    109  O   ILE L  15       5.902  37.491  49.107  1.00 30.80           O
ATOM    110  CB  ILE L  15       6.426  37.692  46.204  1.00 33.00           C
ATOM    111  CG1 ILE L  15       7.217  37.443  44.918  1.00 34.49           C
ATOM    112  CG2 ILE L  15       5.321  38.709  45.968  1.00 31.76           C
ATOM    113  CD1 ILE L  15       7.934  38.669  44.395  1.00 35.24           C
ATOM    114  N   GLY L  16       6.584  39.635  49.092  1.00 33.59           N
ATOM    115  CA  GLY L  16       5.851  39.993  50.293  1.00 31.81           C
ATOM    116  C   GLY L  16       6.763  40.448  51.415  1.00 32.58           C
ATOM    117  O   GLY L  16       6.472  41.422  52.108  1.00 30.43           O
ATOM    118  N   GLN L  17       7.872  39.737  51.594  1.00 32.24           N
ATOM    119  CA  GLN L  17       8.835  40.069  52.638  1.00 34.33           C
ATOM    120  C   GLN L  17       9.671  41.284  52.251  1.00 34.70           C
ATOM    121  O   GLN L  17      10.146  41.381  51.120  1.00 32.37           O
ATOM    122  CB  GLN L  17       9.746  38.873  52.925  1.00 37.95           C
ATOM    123  CG  GLN L  17       9.011  37.627  53.398  1.00 45.88           C
ATOM    124  CD  GLN L  17       8.386  37.798  54.770  1.00 49.94           C
ATOM    125  OE1 GLN L  17       8.791  38.662  55.548  1.00 49.94           O
ATOM    126  NE2 GLN L  17       7.392  36.971  55.073  1.00 51.10           N
ATOM    127  N   PRO L  18       9.852  42.219  53.197  1.00 33.30           N
ATOM    128  CA  PRO L  18      10.636  43.435  52.960  1.00 32.71           C
ATOM    129  C   PRO L  18      12.130  43.148  52.836  1.00 30.96           C
ATOM    130  O   PRO L  18      12.602  42.121  53.321  1.00 30.74           O
ATOM    131  CB  PRO L  18      10.345  44.284  54.200  1.00 31.82           C
ATOM    132  CG  PRO L  18      10.030  43.288  55.261  1.00 33.36           C
ATOM    133  CD  PRO L  18       9.307  42.171  54.565  1.00 34.01           C
ATOM    134  N   ALA L  19      12.859  44.052  52.190  1.00 28.50           N
ATOM    135  CA  ALA L  19      14.295  43.888  52.004  1.00 27.23           C
ATOM    136  C   ALA L  19      15.068  45.035  52.646  1.00 27.07           C
ATOM    137  O   ALA L  19      14.488  46.055  53.018  1.00 24.32           O
ATOM    138  CB  ALA L  19      14.630  43.786  50.524  1.00 30.04           C
ATOM    139  N   SER L  20      16.379  44.861  52.773  1.00 24.81           N
ATOM    140  CA  SER L  20      17.234  45.880  53.370  1.00 27.97           C
ATOM    141  C   SER L  20      18.650  45.809  52.809  1.00 26.96           C
ATOM    142  O   SER L  20      19.479  45.035  53.288  1.00 27.07           O
ATOM    143  CB  SER L  20      17.262  45.732  54.892  1.00 29.31           C
ATOM    144  OG  SER L  20      18.090  46.717  55.485  1.00 39.96           O
ATOM    145  N   ILE L  21      18.921  46.622  51.793  1.00 26.94           N
ATOM    146  CA  ILE L  21      20.237  46.652  51.166  1.00 26.44           C
ATOM    147  C   ILE L  21      21.105  47.757  51.759  1.00 24.60           C
ATOM    148  O   ILE L  21      20.788  48.940  51.640  1.00 22.55           O
ATOM    149  CB  ILE L  21      20.132  46.856  49.643  1.00 26.88           C
ATOM    150  CG1 ILE L  21      19.269  45.760  49.016  1.00 25.90           C
ATOM    151  CG2 ILE L  21      21.515  46.879  49.012  1.00 22.24           C
ATOM    152  CD1 ILE L  21      19.806  44.362  49.231  1.00 34.36           C
ATOM    153  N   SER L  22      22.202  47.362  52.397  1.00 24.87           N
ATOM    154  CA  SER L  22      23.117  48.317  53.010  1.00 25.53           C
ATOM    155  C   SER L  22      24.200  48.753  52.028  1.00 24.12           C
ATOM    156  O   SER L  22      24.540  48.021  51.099  1.00 20.85           O
ATOM    157  CB  SER L  22      23.756  47.717  54.265  1.00 27.44           C
ATOM    158  OG  SER L  22      22.771  47.372  55.223  1.00 40.03           O
ATOM    159  N   CYS L  23      24.738  49.950  52.242  1.00 22.21           N
ATOM    160  CA  CYS L  23      25.782  50.486  51.377  1.00 24.67           C
ATOM    161  C   CYS L  23      26.707  51.424  52.147  1.00 24.91           C
ATOM    162  O   CYS L  23      26.394  52.599  52.339  1.00 26.77           O
ATOM    163  CB  CYS L  23      25.167  51.217  50.183  1.00 27.61           C
ATOM    164  SG  CYS L  23      26.374  51.926  49.038  1.00 39.58           S
ATOM    165  N   GLU L  24      27.845  50.896  52.585  1.00 26.57           N
ATOM    166  CA  GLU L  24      28.816  51.684  53.334  1.00 28.88           C
ATOM    167  C   GLU L  24      29.855  52.307  52.408  1.00 24.96           C
ATOM    168  O   GLU L  24      29.969  51.927  51.243  1.00 19.29           O
ATOM    169  CB  GLU L  24      29.505  50.820  54.392  1.00 37.33           C
ATOM    170  CG  GLU L  24      28.556  50.216  55.415  1.00 48.95           C
ATOM    171  CD  GLU L  24      29.274  49.367  56.446  1.00 57.09           C
ATOM    172  OE1 GLU L  24      30.515  49.250  56.362  1.00 62.46           O
ATOM    173  OE2 GLU L  24      28.598  48.817  57.340  1.00 61.25           O
ATOM    174  N   SER L  25      30.611  53.265  52.934  1.00 23.05           N
ATOM    175  CA  SER L  25      31.642  53.942  52.157  1.00 24.10           C
ATOM    176  C   SER L  25      32.957  54.011  52.927  1.00 23.38           C
ATOM    177  O   SER L  25      33.137  53.321  53.930  1.00 23.77           O
ATOM    178  CB  SER L  25      31.184  55.349  51.770  1.00 23.21           C
ATOM    179  OG  SER L  25      30.915  56.132  52.921  1.00 24.94           O
ATOM    180  N   SER L  26      33.873  54.848  52.450  1.00 23.43           N
ATOM    181  CA  SER L  26      35.172  55.009  53.092  1.00 22.76           C
ATOM    182  C   SER L  26      35.307  56.392  53.721  1.00 25.79           C
ATOM    183  O   SER L  26      35.257  56.536  54.943  1.00 27.95           O
ATOM    184  CB  SER L  26      36.300  54.777  52.086  1.00 23.39           C
ATOM    185  OG  SER L  26      36.224  55.698  51.012  1.00 21.58           O
ATOM    186  N   GLN L  27      35.478  57.406  52.879  1.00 23.64           N
ATOM    187  CA  GLN L  27      35.620  58.778  53.351  1.00 24.84           C
ATOM    188  C   GLN L  27      34.261  59.455  53.493  1.00 25.95           C
ATOM    189  O   GLN L  27      33.220  58.825  53.310  1.00 26.41           O
ATOM    190  CB  GLN L  27      36.512  59.581  52.402  1.00 27.09           C
ATOM    191  CG  GLN L  27      37.920  59.027  52.256  1.00 35.67           C
ATOM    192  CD  GLN L  27      38.774  59.848  51.310  1.00 38.53           C
ATOM    193  OE1 GLN L  27      39.942  59.535  51.079  1.00 43.32           O
ATOM    194  NE2 GLN L  27      38.194  60.907  50.756  1.00 40.19           N
ATOM    195  N   SER L  27A     34.279  60.743  53.820  1.00 21.30           N
ATOM    196  CA  SER L  27A     33.049  61.508  53.989  1.00 23.38           C
ATOM    197  C   SER L  27A     32.486  61.952  52.643  1.00 22.05           C
ATOM    198  O   SER L  27A     33.213  62.469  51.795  1.00 19.83           O
ATOM    199  CB  SER L  27A     33.294  62.725  54.884  1.00 20.17           C
ATOM    200  OG  SER L  27A     32.106  63.479  55.055  1.00 24.39           O
ATOM    201  N   LEU L  27B     31.186  61.748  52.455  1.00 21.73           N
ATOM    202  CA  LEU L  27B     30.522  62.128  51.214  1.00 20.41           C
ATOM    203  C   LEU L  27B     29.659  63.370  51.410  1.00 21.13           C
ATOM    204  O   LEU L  27B     28.569  63.475  50.848  1.00 21.34           O
ATOM    205  CB  LEU L  27B     29.670  60.973  50.686  1.00 17.54           C
ATOM    206  CG  LEU L  27B     30.411  59.672  50.369  1.00 21.70           C
ATOM    207  CD1 LEU L  27B     29.444  58.613  49.863  1.00 19.78           C
ATOM    208  CD2 LEU L  27B     31.521  59.918  49.359  1.00 17.87           C
ATOM    209  N   LEU L  27C     30.154  64.308  52.210  1.00 19.63           N
ATOM    210  CA  LEU L  27C     29.428  65.542  52.486  1.00 20.26           C
ATOM    211  C   LEU L  27C     30.132  66.747  51.870  1.00 20.73           C
ATOM    212  O   LEU L  27C     31.238  67.105  52.275  1.00 20.62           O
ATOM    213  CB  LEU L  27C     29.265  65.743  53.994  1.00 22.61           C
ATOM    214  CG  LEU L  27C     28.521  67.005  54.435  1.00 24.16           C
ATOM    215  CD1 LEU L  27C     27.104  67.014  53.883  1.00 24.09           C
ATOM    216  CD2 LEU L  27C     28.511  67.120  55.951  1.00 27.61           C
ATOM    217  N   TYR L  27D     29.484  67.368  50.890  1.00 20.20           N
ATOM    218  CA  TYR L  27D     30.044  68.536  50.221  1.00 23.42           C
ATOM    219  C   TYR L  27D     29.845  69.784  51.076  1.00 23.19           C
ATOM    220  O   TYR L  27D     29.057  69.778  52.023  1.00 23.52           O
ATOM    221  CB  TYR L  27D     29.406  68.719  48.841  1.00 25.39           C
ATOM    222  CG  TYR L  27D     30.201  69.600  47.901  1.00 30.37           C
ATOM    223  CD1 TYR L  27D     31.334  69.118  47.259  1.00 34.82           C
ATOM    224  CD2 TYR L  27D     29.812  70.910  47.648  1.00 33.19           C
ATOM    225  CE1 TYR L  27D     32.063  69.917  46.398  1.00 38.04           C
ATOM    226  CE2 TYR L  27D     30.535  71.716  46.788  1.00 34.49           C
ATOM    227  CZ  TYR L  27D     31.658  71.215  46.166  1.00 36.73           C
ATOM    228  OH  TYR L  27D     32.380  72.014  45.309  1.00 41.25           O
ATOM    229  N   SER L  27E     30.560  70.853  50.740  1.00 22.89           N
ATOM    230  CA  SER L  27E     30.491  72.095  51.502  1.00 25.51           C
ATOM    231  C   SER L  27E     29.239  72.905  51.173  1.00 26.55           C
ATOM    232  O   SER L  27E     29.012  73.970  51.748  1.00 27.33           O
ATOM    233  CB  SER L  27E     31.739  72.943  51.248  1.00 22.60           C
ATOM    234  OG  SER L  27E     31.863  73.270  49.874  1.00 29.11           O
ATOM    235  N   ASN L  28      28.430  72.399  50.247  1.00 23.50           N
ATOM    236  CA  ASN L  28      27.201  73.078  49.853  1.00 19.92           C
ATOM    237  C   ASN L  28      26.135  73.022  50.944  1.00 22.34           C
ATOM    238  O   ASN L  28      25.381  73.976  51.137  1.00 25.95           O
ATOM    239  CB  ASN L  28      26.654  72.477  48.556  1.00 19.19           C
ATOM    240  CG  ASN L  28      26.545  70.964  48.610  1.00 22.32           C
ATOM    241  OD1 ASN L  28      26.625  70.359  49.680  1.00 19.98           O
ATOM    242  ND2 ASN L  28      26.360  70.344  47.450  1.00 21.69           N
ATOM    243  N   GLY L  29      26.080  71.900  51.653  1.00 23.30           N
ATOM    244  CA  GLY L  29      25.111  71.717  52.717  1.00 23.12           C
ATOM    245  C   GLY L  29      24.424  70.367  52.652  1.00 25.74           C
ATOM    246  O   GLY L  29      23.881  69.887  53.647  1.00 22.95           O
ATOM    247  N   LYS L  30      24.449  69.753  51.473  1.00 25.83           N
ATOM    248  CA  LYS L  30      23.824  68.450  51.275  1.00 26.77           C
ATOM    249  C   LYS L  30      24.850  67.405  50.849  1.00 26.51           C
ATOM    250  O   LYS L  30      26.043  67.693  50.758  1.00 24.03           O
ATOM    251  CB  LYS L  30      22.707  68.545  50.234  1.00 28.32           C
ATOM    252  CG  LYS L  30      21.590  69.506  50.608  1.00 34.89           C
ATOM    253  CD  LYS L  30      20.517  69.550  49.532  1.00 43.34           C
ATOM    254  CE  LYS L  30      19.400  70.511  49.906  1.00 47.80           C
ATOM    255  NZ  LYS L  30      18.734  70.121  51.180  1.00 45.05           N
ATOM    256  N   THR L  31      24.377  66.190  50.589  1.00 24.46           N
ATOM    257  CA  THR L  31      25.252  65.101  50.172  1.00 25.48           C
ATOM    258  C   THR L  31      24.890  64.606  48.776  1.00 25.18           C
ATOM    259  O   THR L  31      23.794  64.867  48.279  1.00 22.28           O
ATOM    260  CB  THR L  31      25.191  63.919  51.158  1.00 27.75           C
ATOM    261  OG1 THR L  31      26.063  62.874  50.711  1.00 28.87           O
ATOM    262  CG2 THR L  31      23.771  63.380  51.258  1.00 35.45           C
ATOM    263  N   TYR L  32      25.818  63.892  48.147  1.00 21.74           N
ATOM    264  CA  TYR L  32      25.600  63.360  46.807  1.00 21.62           C
ATOM    265  C   TYR L  32      25.519  61.837  46.823  1.00 20.47           C
ATOM    266  O   TYR L  32      26.464  61.161  47.229  1.00 20.35           O
ATOM    267  CB  TYR L  32      26.712  63.817  45.860  1.00 25.26           C
ATOM    268  CG  TYR L  32      26.749  65.311  45.627  1.00 29.46           C
ATOM    269  CD1 TYR L  32      25.603  66.084  45.760  1.00 30.70           C
ATOM    270  CD2 TYR L  32      27.932  65.948  45.273  1.00 32.63           C
ATOM    271  CE1 TYR L  32      25.633  67.450  45.548  1.00 29.14           C
ATOM    272  CE2 TYR L  32      27.971  67.313  45.058  1.00 31.78           C
ATOM    273  CZ  TYR L  32      26.820  68.058  45.197  1.00 32.44           C
ATOM    274  OH  TYR L  32      26.855  69.417  44.984  1.00 25.41           O
ATOM    275  N   LEU L  33      24.385  61.305  46.380  1.00 16.46           N
ATOM    276  CA  LEU L  33      24.182  59.862  46.336  1.00 14.29           C
ATOM    277  C   LEU L  33      23.183  59.480  45.249  1.00 14.89           C
ATOM    278  O   LEU L  33      22.050  59.961  45.236  1.00 14.83           O
ATOM    279  CB  LEU L  33      23.704  59.345  47.694  1.00 19.02           C
ATOM    280  CG  LEU L  33      23.455  57.839  47.795  1.00 24.27           C
ATOM    281  CD1 LEU L  33      24.728  57.063  47.491  1.00 23.06           C
ATOM    282  CD2 LEU L  33      22.916  57.474  49.170  1.00 26.31           C
ATOM    283  N   ASN L  34      23.610  58.611  44.338  1.00 14.89           N
ATOM    284  CA  ASN L  34      22.755  58.164  43.245  1.00 13.35           C
ATOM    285  C   ASN L  34      22.675  56.644  43.168  1.00 16.45           C
ATOM    286  O   ASN L  34      23.662  55.948  43.404  1.00 12.72           O
ATOM    287  CB  ASN L  34      23.255  58.728  41.914  1.00 17.67           C
ATOM    288  CG  ASN L  34      23.263  60.244  41.889  1.00 21.95           C
ATOM    289  OD1 ASN L  34      22.276  60.876  41.513  1.00 20.35           O
ATOM    290  ND2 ASN L  34      24.382  60.836  42.291  1.00 26.68           N
ATOM    291  N   TRP L  35      21.493  56.135  42.836  1.00 14.93           N
ATOM    292  CA  TRP L  35      21.282  54.697  42.724  1.00 15.61           C
ATOM    293  C   TRP L  35      20.956  54.298  41.289  1.00 17.92           C
ATOM    294  O   TRP L  35      19.937  54.711  40.736  1.00 16.60           O
ATOM    295  CB  TRP L  35      20.162  54.245  43.663  1.00 16.06           C
ATOM    296  CG  TRP L  35      20.436  54.535  45.107  1.00 14.52           C
ATOM    297  CD1 TRP L  35      20.101  55.666  45.793  1.00 16.42           C
ATOM    298  CD2 TRP L  35      21.102  53.680  46.044  1.00 17.46           C
ATOM    299  NE1 TRP L  35      20.518  55.568  47.099  1.00 14.83           N
ATOM    300  CE2 TRP L  35      21.135  54.358  47.278  1.00 16.93           C
ATOM    301  CE3 TRP L  35      21.673  52.407  45.958  1.00 17.09           C
ATOM    302  CZ2 TRP L  35      21.716  53.807  48.418  1.00 14.21           C
ATOM    303  CZ3 TRP L  35      22.250  51.861  47.091  1.00 21.53           C
ATOM    304  CH2 TRP L  35      22.268  52.560  48.304  1.00 18.08           C
ATOM    305  N   LEU L  36      21.828  53.492  40.691  1.00 16.84           N
ATOM    306  CA  LEU L  36      21.636  53.039  39.319  1.00 17.45           C
ATOM    307  C   LEU L  36      21.271  51.560  39.270  1.00 14.78           C
ATOM    308  O   LEU L  36      21.903  50.732  39.926  1.00 13.21           O
ATOM    309  CB  LEU L  36      22.896  53.297  38.489  1.00 14.08           C
ATOM    310  CG  LEU L  36      23.348  54.754  38.376  1.00 21.94           C
ATOM    311  CD1 LEU L  36      24.607  54.863  37.529  1.00 23.95           C
ATOM    312  CD2 LEU L  36      22.235  55.619  37.803  1.00 22.33           C
ATOM    313  N   LEU L  37      20.246  51.234  38.489  1.00 13.66           N
ATOM    314  CA  LEU L  37      19.797  49.854  38.350  1.00 14.99           C
ATOM    315  C   LEU L  37      19.971  49.361  36.917  1.00 14.95           C
ATOM    316  O   LEU L  37      19.204  49.728  36.026  1.00 16.53           O
ATOM    317  CB  LEU L  37      18.335  49.720  38.779  1.00 16.19           C
ATOM    318  CG  LEU L  37      17.726  48.319  38.688  1.00 14.96           C
ATOM    319  CD1 LEU L  37      18.496  47.340  39.562  1.00 17.06           C
ATOM    320  CD2 LEU L  37      16.255  48.345  39.072  1.00 18.19           C
ATOM    321  N   GLN L  38      20.985  48.529  36.702  1.00 14.33           N
ATOM    322  CA  GLN L  38      21.263  47.987  35.377  1.00 15.88           C
ATOM    323  C   GLN L  38      20.509  46.682  35.144  1.00 15.91           C
ATOM    324  O   GLN L  38      20.797  45.666  35.778  1.00 18.08           O
ATOM    325  CB  GLN L  38      22.766  47.766  35.194  1.00 17.23           C
ATOM    326  CG  GLN L  38      23.148  47.194  33.839  1.00 15.66           C
ATOM    327  CD  GLN L  38      24.643  46.986  33.695  1.00 15.82           C
ATOM    328  OE1 GLN L  38      25.412  47.269  34.613  1.00 18.16           O
ATOM    329  NE2 GLN L  38      25.063  46.489  32.537  1.00 16.89           N
ATOM    330  N   ARG L  39      19.543  46.717  34.233  1.00 14.18           N
ATOM    331  CA  ARG L  39      18.750  45.537  33.911  1.00 20.33           C
ATOM    332  C   ARG L  39      19.387  44.738  32.779  1.00 21.95           C
ATOM    333  O   ARG L  39      19.758  45.302  31.750  1.00 22.64           O
ATOM    334  CB  ARG L  39      17.322  45.937  33.535  1.00 19.28           C
ATOM    335  CG  ARG L  39      16.574  46.673  34.634  1.00 26.32           C
ATOM    336  CD  ARG L  39      15.164  47.036  34.196  1.00 30.01           C
ATOM    337  NE  ARG L  39      14.433  47.747  35.240  1.00 37.68           N
ATOM    338  CZ  ARG L  39      14.427  49.069  35.381  1.00 42.04           C
ATOM    339  NH1 ARG L  39      15.115  49.830  34.541  1.00 42.72           N
ATOM    340  NH2 ARG L  39      13.732  49.630  36.361  1.00 41.07           N
ATOM    341  N   PRO L  40      19.519  43.416  32.973  1.00 25.36           N
ATOM    342  CA  PRO L  40      20.105  42.511  31.977  1.00 26.92           C
ATOM    343  C   PRO L  40      19.339  42.519  30.657  1.00 27.27           C
ATOM    344  O   PRO L  40      18.390  41.753  30.490  1.00 29.19           O
ATOM    345  CB  PRO L  40      20.010  41.138  32.651  1.00 27.23           C
ATOM    346  CG  PRO L  40      19.940  41.434  34.110  1.00 27.26           C
ATOM    347  CD  PRO L  40      19.162  42.709  34.214  1.00 24.09           C
ATOM    348  N   GLY L  41      19.754  43.378  29.731  1.00 28.99           N
ATOM    349  CA  GLY L  41      19.109  43.473  28.435  1.00 29.79           C
ATOM    350  C   GLY L  41      18.615  44.874  28.131  1.00 33.61           C
ATOM    351  O   GLY L  41      18.332  45.206  26.980  1.00 34.06           O
ATOM    352  N   GLN L  42      18.512  45.699  29.168  1.00 32.20           N
ATOM    353  CA  GLN L  42      18.046  47.072  29.011  1.00 29.83           C
ATOM    354  C   GLN L  42      19.101  48.071  29.474  1.00 27.43           C
ATOM    355  O   GLN L  42      20.199  47.687  29.878  1.00 25.20           O
ATOM    356  CB  GLN L  42      16.744  47.287  29.784  1.00 30.55           C
ATOM    357  CG  GLN L  42      15.600  46.391  29.336  1.00 40.46           C
ATOM    358  CD  GLN L  42      14.325  46.639  30.117  1.00 46.52           C
ATOM    359  OE1 GLN L  42      14.277  47.505  30.991  1.00 53.14           O
ATOM    360  NE2 GLN L  42      13.282  45.878  29.805  1.00 48.57           N
ATOM    361  N   SER L  43      18.760  49.354  29.412  1.00 24.38           N
ATOM    362  CA  SER L  43      19.676  50.412  29.821  1.00 25.35           C
ATOM    363  C   SER L  43      19.400  50.857  31.254  1.00 22.38           C
ATOM    364  O   SER L  43      18.242  50.976  31.657  1.00 17.94           O
ATOM    365  CB  SER L  43      19.572  51.606  28.870  1.00 27.87           C
ATOM    366  OG  SER L  43      18.259  52.137  28.860  1.00 37.63           O
ATOM    367  N   PRO L  44      20.469  51.097  32.030  1.00 20.31           N
ATOM    368  CA  PRO L  44      20.364  51.549  33.422  1.00 20.54           C
ATOM    369  C   PRO L  44      19.612  52.871  33.553  1.00 20.65           C
ATOM    370  O   PRO L  44      19.708  53.724  32.671  1.00 17.85           O
ATOM    371  CB  PRO L  44      21.826  51.712  33.849  1.00 17.98           C
ATOM    372  CG  PRO L  44      22.589  50.814  32.939  1.00 19.43           C
ATOM    373  CD  PRO L  44      21.869  50.878  31.627  1.00 22.70           C
ATOM    374  N   LYS L  45      18.873  53.031  34.646  1.00 17.24           N
ATOM    375  CA  LYS L  45      18.102  54.246  34.877  1.00 16.32           C
ATOM    376  C   LYS L  45      18.154  54.662  36.344  1.00 14.58           C
ATOM    377  O   LYS L  45      17.975  53.837  37.240  1.00 11.26           O
ATOM    378  CB  LYS L  45      16.649  54.050  34.437  1.00 22.35           C
ATOM    379  CG  LYS L  45      15.772  55.278  34.619  1.00 28.96           C
ATOM    380  CD  LYS L  45      14.347  55.010  34.163  1.00 37.31           C
ATOM    381  CE  LYS L  45      13.469  56.238  34.346  1.00 43.23           C
ATOM    382  NZ  LYS L  45      13.404  56.667  35.770  1.00 43.54           N
ATOM    383  N   ARG L  46      18.403  55.946  36.581  1.00 12.76           N
ATOM    384  CA  ARG L  46      18.472  56.478  37.937  1.00 16.71           C
ATOM    385  C   ARG L  46      17.093  56.498  38.589  1.00 14.60           C
ATOM    386  O   ARG L  46      16.125  56.979  38.000  1.00 14.89           O
ATOM    387  CB  ARG L  46      19.075  57.884  37.931  1.00 14.67           C
ATOM    388  CG  ARG L  46      19.215  58.508  39.309  1.00 15.93           C
ATOM    389  CD  ARG L  46      19.843  59.890  39.225  1.00 15.47           C
ATOM    390  NE  ARG L  46      19.046  60.804  38.411  1.00 16.37           N
ATOM    391  CZ  ARG L  46      19.371  62.071  38.177  1.00 16.05           C
ATOM    392  NH1 ARG L  46      20.480  62.580  38.695  1.00 13.47           N
ATOM    393  NH2 ARG L  46      18.586  62.830  37.424  1.00 12.81           N
ATOM    394  N   LEU L  47      17.011  55.974  39.808  1.00 14.40           N
ATOM    395  CA  LEU L  47      15.743  55.902  40.526  1.00 15.42           C
ATOM    396  C   LEU L  47      15.658  56.954  41.627  1.00 18.73           C
ATOM    397  O   LEU L  47      14.690  57.711  41.700  1.00 19.02           O
ATOM    398  CB  LEU L  47      15.547  54.506  41.120  1.00 12.06           C
ATOM    399  CG  LEU L  47      15.521  53.343  40.127  1.00 19.55           C
ATOM    400  CD1 LEU L  47      15.321  52.021  40.851  1.00 18.49           C
ATOM    401  CD2 LEU L  47      14.437  53.554  39.080  1.00 19.39           C
ATOM    402  N   ILE L  48      16.673  56.993  42.484  1.00 18.50           N
ATOM    403  CA  ILE L  48      16.700  57.938  43.596  1.00 16.46           C
ATOM    404  C   ILE L  48      17.985  58.759  43.603  1.00 16.98           C
ATOM    405  O   ILE L  48      19.085  58.208  43.656  1.00 14.42           O
ATOM    406  CB  ILE L  48      16.560  57.218  44.952  1.00 18.05           C
ATOM    407  CG1 ILE L  48      15.250  56.428  45.008  1.00 19.86           C
ATOM    408  CG2 ILE L  48      16.631  58.217  46.097  1.00 17.08           C
ATOM    409  CD1 ILE L  48      15.042  55.681  46.307  1.00 25.31           C
ATOM    410  N   TYR L  49      17.840  60.079  43.548  1.00 16.21           N
ATOM    411  CA  TYR L  49      18.987  60.978  43.593  1.00 17.49           C
ATOM    412  C   TYR L  49      18.893  61.914  44.793  1.00 17.53           C
ATOM    413  O   TYR L  49      17.800  62.325  45.182  1.00 18.53           O
ATOM    414  CB  TYR L  49      19.094  61.786  42.296  1.00 15.12           C
ATOM    415  CG  TYR L  49      17.970  62.776  42.083  1.00 18.97           C
ATOM    416  CD1 TYR L  49      16.748  62.368  41.562  1.00 19.08           C
ATOM    417  CD2 TYR L  49      18.134  64.120  42.391  1.00 18.51           C
ATOM    418  CE1 TYR L  49      15.719  63.270  41.363  1.00 18.77           C
ATOM    419  CE2 TYR L  49      17.111  65.029  42.195  1.00 22.10           C
ATOM    420  CZ  TYR L  49      15.906  64.598  41.681  1.00 22.13           C
ATOM    421  OH  TYR L  49      14.885  65.499  41.483  1.00 24.02           O
ATOM    422  N   LEU L  50      20.047  62.238  45.373  1.00 18.75           N
ATOM    423  CA  LEU L  50      20.135  63.111  46.543  1.00 18.23           C
ATOM    424  C   LEU L  50      19.308  62.584  47.716  1.00 19.33           C
ATOM    425  O   LEU L  50      18.764  63.363  48.499  1.00 17.93           O
ATOM    426  CB  LEU L  50      19.694  64.534  46.188  1.00 20.23           C
ATOM    427  CG  LEU L  50      20.498  65.238  45.092  1.00 17.31           C
ATOM    428  CD1 LEU L  50      19.963  66.640  44.849  1.00 18.72           C
ATOM    429  CD2 LEU L  50      21.976  65.278  45.451  1.00  7.48           C
ATOM    430  N   VAL L  51      19.221  61.259  47.818  1.00 18.13           N
ATOM    431  CA  VAL L  51      18.526  60.579  48.912  1.00 16.91           C
ATOM    432  C   VAL L  51      17.064  61.006  49.060  1.00 16.58           C
ATOM    433  O   VAL L  51      16.152  60.237  48.755  1.00 18.45           O
ATOM    434  CB  VAL L  51      19.244  60.806  50.259  1.00 22.06           C
ATOM    435  CG1 VAL L  51      18.539  60.044  51.372  1.00 16.84           C
ATOM    436  CG2 VAL L  51      20.701  60.382  50.160  1.00 19.42           C
ATOM    437  N   SER L  52      16.850  62.231  49.531  1.00 16.63           N
ATOM    438  CA  SER L  52      15.507  62.729  49.810  1.00 19.17           C
ATOM    439  C   SER L  52      14.669  62.895  48.544  1.00 19.81           C
ATOM    440  O   SER L  52      13.458  62.677  48.561  1.00 21.93           O
ATOM    441  CB  SER L  52      15.582  64.062  50.558  1.00 20.87           C
ATOM    442  OG  SER L  52      16.266  65.038  49.792  1.00 21.76           O
ATOM    443  N   LYS L  53      15.317  63.282  47.451  1.00 20.59           N
ATOM    444  CA  LYS L  53      14.615  63.517  46.194  1.00 23.42           C
ATOM    445  C   LYS L  53      14.442  62.230  45.393  1.00 22.07           C
ATOM    446  O   LYS L  53      15.204  61.278  45.555  1.00 24.54           O
ATOM    447  CB  LYS L  53      15.357  64.560  45.356  1.00 25.03           C
ATOM    448  CG  LYS L  53      15.488  65.916  46.031  1.00 29.66           C
ATOM    449  CD  LYS L  53      16.220  66.909  45.143  1.00 33.90           C
ATOM    450  CE  LYS L  53      16.349  68.264  45.820  1.00 42.85           C
ATOM    451  NZ  LYS L  53      17.103  68.176  47.101  1.00 47.15           N
ATOM    452  N   LEU L  54      13.429  62.208  44.532  1.00 20.82           N
ATOM    453  CA  LEU L  54      13.162  61.050  43.686  1.00 22.53           C
ATOM    454  C   LEU L  54      12.902  61.479  42.245  1.00 25.63           C
ATOM    455  O   LEU L  54      12.550  62.630  41.986  1.00 23.36           O
ATOM    456  CB  LEU L  54      11.968  60.248  44.216  1.00 24.44           C
ATOM    457  CG  LEU L  54      12.101  59.532  45.564  1.00 28.62           C
ATOM    458  CD1 LEU L  54      11.777  60.461  46.727  1.00 32.75           C
ATOM    459  CD2 LEU L  54      11.217  58.294  45.601  1.00 29.37           C
ATOM    460  N   ASP L  55      13.077  60.549  41.312  1.00 23.13           N
ATOM    461  CA  ASP L  55      12.839  60.827  39.901  1.00 22.15           C
ATOM    462  C   ASP L  55      11.387  60.555  39.523  1.00 23.92           C
ATOM    463  O   ASP L  55      10.555  60.263  40.383  1.00 20.33           O
ATOM    464  CB  ASP L  55      13.775  59.995  39.022  1.00 19.91           C
ATOM    465  CG  ASP L  55      15.233  60.358  39.215  1.00 21.77           C
ATOM    466  OD1 ASP L  55      15.707  61.299  38.544  1.00 20.55           O
ATOM    467  OD2 ASP L  55      15.908  59.702  40.036  1.00 23.10           O
ATOM    468  N   SER L  56      11.088  60.652  38.231  1.00 26.03           N
ATOM    469  CA  SER L  56       9.738  60.415  37.736  1.00 31.82           C
ATOM    470  C   SER L  56       9.505  58.933  37.461  1.00 31.81           C
ATOM    471  O   SER L  56      10.404  58.228  37.004  1.00 35.23           O
ATOM    472  CB  SER L  56       9.480  61.232  36.469  1.00 33.67           C
ATOM    473  OG  SER L  56       9.620  62.619  36.719  1.00 43.12           O
ATOM    474  N   GLY L  57       8.292  58.467  37.743  1.00 33.54           N
ATOM    475  CA  GLY L  57       7.942  57.075  37.532  1.00 33.25           C
ATOM    476  C   GLY L  57       8.536  56.163  38.587  1.00 34.17           C
ATOM    477  O   GLY L  57       8.756  54.977  38.344  1.00 37.35           O
ATOM    478  N   VAL L  58       8.795  56.721  39.765  1.00 31.48           N
ATOM    479  CA  VAL L  58       9.370  55.957  40.866  1.00 26.25           C
ATOM    480  C   VAL L  58       8.321  55.656  41.933  1.00 29.64           C
ATOM    481  O   VAL L  58       7.710  56.573  42.482  1.00 28.05           O
ATOM    482  CB  VAL L  58      10.551  56.704  41.514  1.00 26.35           C
ATOM    483  CG1 VAL L  58      11.108  55.904  42.682  1.00 22.70           C
ATOM    484  CG2 VAL L  58      11.634  56.977  40.482  1.00 18.63           C
ATOM    485  N   PRO L  59       8.109  54.363  42.223  1.00 30.43           N
ATOM    486  CA  PRO L  59       7.141  53.911  43.229  1.00 32.06           C
ATOM    487  C   PRO L  59       7.443  54.452  44.625  1.00 32.74           C
ATOM    488  O   PRO L  59       8.575  54.849  44.903  1.00 33.07           O
ATOM    489  CB  PRO L  59       7.287  52.385  43.197  1.00 33.06           C
ATOM    490  CG  PRO L  59       7.841  52.086  41.846  1.00 32.07           C
ATOM    491  CD  PRO L  59       8.752  53.232  41.533  1.00 29.67           C
ATOM    492  N   ASP L  60       6.434  54.461  45.489  1.00 31.16           N
ATOM    493  CA  ASP L  60       6.591  54.961  46.850  1.00 32.37           C
ATOM    494  C   ASP L  60       7.349  53.961  47.720  1.00 30.41           C
ATOM    495  O   ASP L  60       7.912  54.324  48.753  1.00 27.13           O
ATOM    496  CB  ASP L  60       5.223  55.269  47.466  1.00 40.86           C
ATOM    497  CG  ASP L  60       5.330  55.909  48.836  1.00 49.34           C
ATOM    498  OD1 ASP L  60       5.322  55.168  49.842  1.00 54.47           O
ATOM    499  OD2 ASP L  60       5.421  57.152  48.908  1.00 53.40           O
ATOM    500  N   ARG L  61       7.362  52.703  47.291  1.00 28.18           N
ATOM    501  CA  ARG L  61       8.041  51.644  48.029  1.00 26.81           C
ATOM    502  C   ARG L  61       9.552  51.858  48.052  1.00 24.82           C
ATOM    503  O   ARG L  61      10.219  51.533  49.034  1.00 24.48           O
ATOM    504  CB  ARG L  61       7.716  50.278  47.422  1.00 30.87           C
ATOM    505  CG  ARG L  61       6.234  49.939  47.414  1.00 37.65           C
ATOM    506  CD  ARG L  61       5.982  48.581  46.780  1.00 39.88           C
ATOM    507  NE  ARG L  61       6.454  48.526  45.400  1.00 39.46           N
ATOM    508  CZ  ARG L  61       5.716  48.853  44.344  1.00 36.67           C
ATOM    509  NH1 ARG L  61       4.465  49.260  44.508  1.00 43.76           N
ATOM    510  NH2 ARG L  61       6.228  48.773  43.124  1.00 32.38           N
ATOM    511  N   PHE L  62      10.085  52.407  46.965  1.00 21.85           N
ATOM    512  CA  PHE L  62      11.515  52.673  46.865  1.00 24.54           C
ATOM    513  C   PHE L  62      11.875  54.002  47.521  1.00 23.56           C
ATOM    514  O   PHE L  62      11.762  55.061  46.904  1.00 20.33           O
ATOM    515  CB  PHE L  62      11.961  52.671  45.402  1.00 21.32           C
ATOM    516  CG  PHE L  62      11.768  51.351  44.711  1.00 24.06           C
ATOM    517  CD1 PHE L  62      10.602  51.082  44.013  1.00 25.50           C
ATOM    518  CD2 PHE L  62      12.754  50.379  44.759  1.00 26.55           C
ATOM    519  CE1 PHE L  62      10.422  49.868  43.376  1.00 24.36           C
ATOM    520  CE2 PHE L  62      12.580  49.164  44.124  1.00 25.25           C
ATOM    521  CZ  PHE L  62      11.413  48.908  43.432  1.00 21.45           C
ATOM    522  N   THR L  63      12.309  53.938  48.776  1.00 22.89           N
ATOM    523  CA  THR L  63      12.686  55.135  49.518  1.00 24.67           C
ATOM    524  C   THR L  63      14.055  54.972  50.170  1.00 22.41           C
ATOM    525  O   THR L  63      14.250  54.099  51.015  1.00 22.38           O
ATOM    526  CB  THR L  63      11.648  55.476  50.604  1.00 27.75           C
ATOM    527  OG1 THR L  63      10.369  55.691  49.995  1.00 34.04           O
ATOM    528  CG2 THR L  63      12.062  56.728  51.362  1.00 30.09           C
ATOM    529  N   GLY L  64      14.999  55.818  49.772  1.00 23.19           N
ATOM    530  CA  GLY L  64      16.345  55.769  50.313  1.00 17.74           C
ATOM    531  C   GLY L  64      16.467  56.506  51.632  1.00 20.94           C
ATOM    532  O   GLY L  64      15.735  57.461  51.890  1.00 20.63           O
ATOM    533  N   SER L  65      17.396  56.059  52.470  1.00 20.93           N
ATOM    534  CA  SER L  65      17.616  56.679  53.772  1.00 20.49           C
ATOM    535  C   SER L  65      19.082  56.592  54.183  1.00 20.64           C
ATOM    536  O   SER L  65      19.922  56.108  53.425  1.00 20.55           O
ATOM    537  CB  SER L  65      16.732  56.023  54.834  1.00 19.60           C
ATOM    538  OG  SER L  65      17.016  54.639  54.951  1.00 26.02           O
ATOM    539  N   GLY L  66      19.381  57.063  55.389  1.00 21.77           N
ATOM    540  CA  GLY L  66      20.739  57.040  55.901  1.00 22.74           C
ATOM    541  C   GLY L  66      21.403  58.402  55.846  1.00 24.85           C
ATOM    542  O   GLY L  66      21.006  59.265  55.063  1.00 24.29           O
ATOM    543  N   SER L  67      22.419  58.594  56.681  1.00 27.01           N
ATOM    544  CA  SER L  67      23.143  59.858  56.728  1.00 30.72           C
ATOM    545  C   SER L  67      24.612  59.639  57.075  1.00 29.06           C
ATOM    546  O   SER L  67      24.977  58.617  57.657  1.00 27.98           O
ATOM    547  CB  SER L  67      22.500  60.807  57.741  1.00 32.77           C
ATOM    548  OG  SER L  67      23.195  62.041  57.798  1.00 40.98           O
ATOM    549  N   GLY L  68      25.451  60.605  56.714  1.00 29.28           N
ATOM    550  CA  GLY L  68      26.874  60.520  56.985  1.00 28.85           C
ATOM    551  C   GLY L  68      27.600  59.629  55.996  1.00 29.75           C
ATOM    552  O   GLY L  68      27.588  59.884  54.792  1.00 32.70           O
ATOM    553  N   THR L  69      28.234  58.580  56.508  1.00 30.01           N
ATOM    554  CA  THR L  69      28.971  57.644  55.666  1.00 27.46           C
ATOM    555  C   THR L  69      28.329  56.261  55.685  1.00 25.79           C
ATOM    556  O   THR L  69      28.914  55.288  55.210  1.00 24.35           O
ATOM    557  CB  THR L  69      30.441  57.524  56.109  1.00 27.91           C
ATOM    558  OG1 THR L  69      30.499  57.046  57.458  1.00 26.61           O
ATOM    559  CG2 THR L  69      31.136  58.874  56.023  1.00 24.72           C
ATOM    560  N   ASP L  70      27.123  56.181  56.238  1.00 22.97           N
ATOM    561  CA  ASP L  70      26.401  54.918  56.322  1.00 25.61           C
ATOM    562  C   ASP L  70      24.998  55.043  55.737  1.00 22.62           C
ATOM    563  O   ASP L  70      24.150  55.752  56.279  1.00 22.80           O
ATOM    564  CB  ASP L  70      26.324  54.440  57.773  1.00 28.61           C
ATOM    565  CG  ASP L  70      27.692  54.219  58.387  1.00 37.03           C
ATOM    566  OD1 ASP L  70      28.244  55.174  58.974  1.00 40.10           O
ATOM    567  OD2 ASP L  70      28.217  53.090  58.284  1.00 41.86           O
ATOM    568  N   PHE L  71      24.761  54.351  54.627  1.00 20.71           N
ATOM    569  CA  PHE L  71      23.461  54.382  53.967  1.00 20.13           C
ATOM    570  C   PHE L  71      22.896  52.976  53.800  1.00 21.75           C
ATOM    571  O   PHE L  71      23.636  52.025  53.547  1.00 22.22           O
ATOM    572  CB  PHE L  71      23.566  55.073  52.606  1.00 19.20           C
ATOM    573  CG  PHE L  71      24.028  56.500  52.683  1.00 17.28           C
ATOM    574  CD1 PHE L  71      23.119  57.527  52.874  1.00 18.11           C
ATOM    575  CD2 PHE L  71      25.372  56.815  52.564  1.00 19.84           C
ATOM    576  CE1 PHE L  71      23.541  58.841  52.945  1.00 18.03           C
ATOM    577  CE2 PHE L  71      25.800  58.127  52.635  1.00 17.27           C
ATOM    578  CZ  PHE L  71      24.883  59.142  52.825  1.00 18.64           C
ATOM    579  N   THR L  72      21.581  52.851  53.942  1.00 21.07           N
ATOM    580  CA  THR L  72      20.915  51.561  53.809  1.00 22.12           C
ATOM    581  C   THR L  72      19.562  51.704  53.120  1.00 21.14           C
ATOM    582  O   THR L  72      18.666  52.379  53.626  1.00 22.76           O
ATOM    583  CB  THR L  72      20.714  50.887  55.179  1.00 24.07           C
ATOM    584  OG1 THR L  72      21.985  50.687  55.809  1.00 25.91           O
ATOM    585  CG2 THR L  72      20.018  49.544  55.016  1.00 19.04           C
ATOM    586  N   LEU L  73      19.422  51.064  51.964  1.00 18.96           N
ATOM    587  CA  LEU L  73      18.177  51.113  51.207  1.00 20.26           C
ATOM    588  C   LEU L  73      17.182  50.077  51.719  1.00 23.48           C
ATOM    589  O   LEU L  73      17.481  48.883  51.761  1.00 24.00           O
ATOM    590  CB  LEU L  73      18.446  50.893  49.717  1.00 20.30           C
ATOM    591  CG  LEU L  73      17.225  50.912  48.796  1.00 19.01           C
ATOM    592  CD1 LEU L  73      16.508  52.251  48.880  1.00 22.55           C
ATOM    593  CD2 LEU L  73      17.628  50.603  47.362  1.00 22.81           C
ATOM    594  N   ARG L  74      15.998  50.540  52.106  1.00 23.90           N
ATOM    595  CA  ARG L  74      14.961  49.655  52.622  1.00 27.69           C
ATOM    596  C   ARG L  74      13.739  49.643  51.709  1.00 27.05           C
ATOM    597  O   ARG L  74      13.220  50.695  51.336  1.00 28.12           O
ATOM    598  CB  ARG L  74      14.555  50.073  54.036  1.00 33.87           C
ATOM    599  CG  ARG L  74      15.691  50.035  55.045  1.00 43.57           C
ATOM    600  CD  ARG L  74      15.218  50.456  56.427  1.00 52.01           C
ATOM    601  NE  ARG L  74      16.297  50.421  57.409  1.00 59.20           N
ATOM    602  CZ  ARG L  74      16.152  50.743  58.690  1.00 62.75           C
ATOM    603  NH1 ARG L  74      17.189  50.682  59.513  1.00 64.77           N
ATOM    604  NH2 ARG L  74      14.968  51.126  59.150  1.00 66.17           N
ATOM    605  N   ILE L  75      13.285  48.446  51.352  1.00 25.99           N
ATOM    606  CA  ILE L  75      12.120  48.293  50.489  1.00 27.63           C
ATOM    607  C   ILE L  75      10.963  47.649  51.247  1.00 27.31           C
ATOM    608  O   ILE L  75      11.124  46.600  51.869  1.00 28.64           O
ATOM    609  CB  ILE L  75      12.447  47.445  49.245  1.00 25.47           C
ATOM    610  CG1 ILE L  75      13.652  48.029  48.504  1.00 23.16           C
ATOM    611  CG2 ILE L  75      11.239  47.360  48.324  1.00 25.23           C
ATOM    612  CD1 ILE L  75      14.046  47.249  47.269  1.00 25.74           C
ATOM    613  N   SER L  76       9.797  48.286  51.190  1.00 28.10           N
ATOM    614  CA  SER L  76       8.615  47.786  51.883  1.00 28.05           C
ATOM    615  C   SER L  76       8.098  46.498  51.249  1.00 29.07           C
ATOM    616  O   SER L  76       7.754  45.546  51.950  1.00 33.00           O
ATOM    617  CB  SER L  76       7.512  48.846  51.889  1.00 24.33           C
ATOM    618  OG  SER L  76       7.135  49.198  50.570  1.00 28.42           O
ATOM    619  N   ARG L  77       8.045  46.475  49.921  1.00 32.79           N
ATOM    620  CA  ARG L  77       7.563  45.305  49.196  1.00 34.86           C
ATOM    621  C   ARG L  77       8.258  45.165  47.846  1.00 34.04           C
ATOM    622  O   ARG L  77       8.320  46.115  47.066  1.00 36.30           O
ATOM    623  CB  ARG L  77       6.047  45.384  49.003  1.00 39.00           C
ATOM    624  CG  ARG L  77       5.450  44.188  48.279  1.00 48.60           C
ATOM    625  CD  ARG L  77       3.938  44.310  48.168  1.00 55.14           C
ATOM    626  NE  ARG L  77       3.539  45.502  47.425  1.00 59.60           N
ATOM    627  CZ  ARG L  77       3.332  45.530  46.113  1.00 63.57           C
ATOM    628  NH1 ARG L  77       3.486  44.428  45.392  1.00 65.41           N
ATOM    629  NH2 ARG L  77       2.970  46.659  45.520  1.00 64.21           N
ATOM    630  N   VAL L  78       8.780  43.973  47.576  1.00 31.01           N
ATOM    631  CA  VAL L  78       9.475  43.704  46.323  1.00 30.39           C
ATOM    632  C   VAL L  78       8.597  42.905  45.365  1.00 27.49           C
ATOM    633  O   VAL L  78       8.142  41.809  45.694  1.00 27.85           O
ATOM    634  CB  VAL L  78      10.790  42.938  46.560  1.00 30.51           C
ATOM    635  CG1 VAL L  78      11.473  42.632  45.235  1.00 31.54           C
ATOM    636  CG2 VAL L  78      11.712  43.734  47.471  1.00 28.69           C
ATOM    637  N   GLU L  79       8.363  43.460  44.181  1.00 26.98           N
ATOM    638  CA  GLU L  79       7.546  42.795  43.172  1.00 29.28           C
ATOM    639  C   GLU L  79       8.384  41.846  42.321  1.00 29.52           C
ATOM    640  O   GLU L  79       9.494  41.473  42.700  1.00 29.52           O
ATOM    641  CB  GLU L  79       6.853  43.826  42.279  1.00 30.19           C
ATOM    642  CG  GLU L  79       5.917  44.764  43.024  1.00 38.46           C
ATOM    643  CD  GLU L  79       5.235  45.758  42.105  1.00 45.24           C
ATOM    644  OE1 GLU L  79       5.525  45.742  40.890  1.00 47.35           O
ATOM    645  OE2 GLU L  79       4.409  46.556  42.597  1.00 49.11           O
ATOM    646  N   ALA L  80       7.845  41.459  41.170  1.00 29.76           N
ATOM    647  CA  ALA L  80       8.541  40.555  40.263  1.00 29.91           C
ATOM    648  C   ALA L  80       9.301  41.329  39.192  1.00 29.01           C
ATOM    649  O   ALA L  80      10.132  40.767  38.478  1.00 25.16           O
ATOM    650  CB  ALA L  80       7.559  39.587  39.622  1.00 32.00           C
ATOM    651  N   GLU L  81       9.011  42.621  39.085  1.00 30.57           N
ATOM    652  CA  GLU L  81       9.666  43.475  38.101  1.00 33.36           C
ATOM    653  C   GLU L  81      10.717  44.364  38.758  1.00 28.20           C
ATOM    654  O   GLU L  81      11.197  45.323  38.156  1.00 30.19           O
ATOM    655  CB  GLU L  81       8.638  44.337  37.361  1.00 39.51           C
ATOM    656  CG  GLU L  81       7.702  43.562  36.441  1.00 51.62           C
ATOM    657  CD  GLU L  81       6.610  42.822  37.192  1.00 58.32           C
ATOM    658  OE1 GLU L  81       6.442  43.074  38.404  1.00 60.07           O
ATOM    659  OE2 GLU L  81       5.920  41.988  36.569  1.00 60.57           O
ATOM    660  N   ASP L  82      11.069  44.037  39.998  1.00 24.54           N
ATOM    661  CA  ASP L  82      12.064  44.804  40.738  1.00 22.63           C
ATOM    662  C   ASP L  82      13.411  44.089  40.754  1.00 22.17           C
ATOM    663  O   ASP L  82      14.231  44.310  41.644  1.00 21.01           O
ATOM    664  CB  ASP L  82      11.588  45.059  42.170  1.00 25.45           C
ATOM    665  CG  ASP L  82      10.288  45.839  42.221  1.00 24.90           C
ATOM    666  OD1 ASP L  82      10.037  46.640  41.297  1.00 22.30           O
ATOM    667  OD2 ASP L  82       9.519  45.650  43.187  1.00 24.70           O
ATOM    668  N   LEU L  83      13.632  43.232  39.762  1.00 21.11           N
ATOM    669  CA  LEU L  83      14.879  42.484  39.660  1.00 21.79           C
ATOM    670  C   LEU L  83      15.995  43.334  39.060  1.00 18.59           C
ATOM    671  O   LEU L  83      15.755  44.441  38.578  1.00 15.11           O
ATOM    672  CB  LEU L  83      14.671  41.212  38.830  1.00 24.29           C
ATOM    673  CG  LEU L  83      13.729  41.275  37.622  1.00 27.27           C
ATOM    674  CD1 LEU L  83      14.345  42.034  36.452  1.00 28.06           C
ATOM    675  CD2 LEU L  83      13.316  39.873  37.196  1.00 25.40           C
ATOM    676  N   GLY L  84      17.216  42.809  39.094  1.00 19.70           N
ATOM    677  CA  GLY L  84      18.365  43.515  38.557  1.00 17.27           C
ATOM    678  C   GLY L  84      19.475  43.675  39.577  1.00 17.16           C
ATOM    679  O   GLY L  84      19.378  43.176  40.698  1.00 16.72           O
ATOM    680  N   VAL L  85      20.534  44.375  39.186  1.00 16.05           N
ATOM    681  CA  VAL L  85      21.671  44.604  40.070  1.00 16.03           C
ATOM    682  C   VAL L  85      21.794  46.078  40.438  1.00 15.07           C
ATOM    683  O   VAL L  85      21.954  46.934  39.568  1.00 17.13           O
ATOM    684  CB  VAL L  85      22.989  44.132  39.428  1.00 15.91           C
ATOM    685  CG1 VAL L  85      24.162  44.420  40.352  1.00 16.56           C
ATOM    686  CG2 VAL L  85      22.916  42.650  39.095  1.00 14.84           C
ATOM    687  N   TYR L  86      21.717  46.368  41.733  1.00 15.75           N
ATOM    688  CA  TYR L  86      21.816  47.740  42.219  1.00 16.77           C
ATOM    689  C   TYR L  86      23.271  48.148  42.428  1.00 18.90           C
ATOM    690  O   TYR L  86      24.059  47.398  43.003  1.00 23.45           O
ATOM    691  CB  TYR L  86      21.032  47.905  43.522  1.00 15.76           C
ATOM    692  CG  TYR L  86      19.553  47.617  43.390  1.00 17.49           C
ATOM    693  CD1 TYR L  86      19.049  46.345  43.628  1.00 15.27           C
ATOM    694  CD2 TYR L  86      18.661  48.618  43.028  1.00 16.16           C
ATOM    695  CE1 TYR L  86      17.698  46.077  43.508  1.00 16.14           C
ATOM    696  CE2 TYR L  86      17.309  48.360  42.906  1.00 15.26           C
ATOM    697  CZ  TYR L  86      16.833  47.089  43.147  1.00 13.24           C
ATOM    698  OH  TYR L  86      15.487  46.827  43.027  1.00 17.64           O
ATOM    699  N   TYR L  87      23.619  49.341  41.957  1.00 18.08           N
ATOM    700  CA  TYR L  87      24.976  49.855  42.098  1.00 14.95           C
ATOM    701  C   TYR L  87      25.002  51.118  42.951  1.00 17.80           C
ATOM    702  O   TYR L  87      24.224  52.046  42.727  1.00 16.92           O
ATOM    703  CB  TYR L  87      25.590  50.136  40.724  1.00 15.51           C
ATOM    704  CG  TYR L  87      25.735  48.909  39.853  1.00 15.88           C
ATOM    705  CD1 TYR L  87      24.733  48.542  38.964  1.00 12.65           C
ATOM    706  CD2 TYR L  87      26.875  48.119  39.917  1.00 13.98           C
ATOM    707  CE1 TYR L  87      24.861  47.421  38.165  1.00 13.18           C
ATOM    708  CE2 TYR L  87      27.013  46.996  39.122  1.00 13.43           C
ATOM    709  CZ  TYR L  87      26.003  46.653  38.248  1.00 14.55           C
ATOM    710  OH  TYR L  87      26.136  45.536  37.455  1.00 20.34           O
ATOM    711  N   CYS L  88      25.900  51.148  43.930  1.00 15.76           N
ATOM    712  CA  CYS L  88      26.034  52.300  44.813  1.00 22.32           C
ATOM    713  C   CYS L  88      27.197  53.188  44.383  1.00 17.35           C
ATOM    714  O   CYS L  88      28.335  52.986  44.807  1.00 17.46           O
ATOM    715  CB  CYS L  88      26.225  51.846  46.262  1.00 25.30           C
ATOM    716  SG  CYS L  88      26.380  53.196  47.454  1.00 48.74           S
ATOM    717  N   VAL L  89      26.903  54.172  43.539  1.00 16.22           N
ATOM    718  CA  VAL L  89      27.924  55.087  43.044  1.00 16.22           C
ATOM    719  C   VAL L  89      27.623  56.527  43.456  1.00 19.21           C
ATOM    720  O   VAL L  89      26.525  57.036  43.226  1.00 18.94           O
ATOM    721  CB  VAL L  89      28.058  55.001  41.506  1.00 17.57           C
ATOM    722  CG1 VAL L  89      26.686  54.976  40.843  1.00 16.58           C
ATOM    723  CG2 VAL L  89      28.908  56.146  40.972  1.00 19.58           C
ATOM    724  N   GLN L  90      28.603  57.176  44.076  1.00 15.38           N
ATOM    725  CA  GLN L  90      28.450  58.558  44.516  1.00 14.86           C
ATOM    726  C   GLN L  90      29.154  59.521  43.565  1.00 15.42           C
ATOM    727  O   GLN L  90      29.808  59.100  42.612  1.00 16.84           O
ATOM    728  CB  GLN L  90      28.983  58.727  45.942  1.00 12.57           C
ATOM    729  CG  GLN L  90      30.384  58.169  46.167  1.00 17.62           C
ATOM    730  CD  GLN L  90      31.480  59.134  45.755  1.00 18.58           C
ATOM    731  OE1 GLN L  90      31.252  60.338  45.637  1.00 18.92           O
ATOM    732  NE2 GLN L  90      32.679  58.607  45.534  1.00 19.78           N
ATOM    733  N   GLY L  91      29.015  60.816  43.832  1.00 14.46           N
ATOM    734  CA  GLY L  91      29.634  61.835  43.005  1.00 17.96           C
ATOM    735  C   GLY L  91      30.071  63.046  43.806  1.00 19.37           C
ATOM    736  O   GLY L  91      29.901  64.184  43.370  1.00 25.05           O
ATOM    737  N   THR L  92      30.637  62.798  44.982  1.00 17.41           N
ATOM    738  CA  THR L  92      31.100  63.873  45.852  1.00 18.38           C
ATOM    739  C   THR L  92      32.565  64.203  45.590  1.00 19.60           C
ATOM    740  O   THR L  92      32.914  65.351  45.314  1.00 20.34           O
ATOM    741  CB  THR L  92      30.922  63.512  47.338  1.00 15.49           C
ATOM    742  OG1 THR L  92      29.539  63.252  47.608  1.00 21.26           O
ATOM    743  CG2 THR L  92      31.402  64.651  48.225  1.00 21.66           C
ATOM    744  N   HIS L  93      33.420  63.189  45.678  1.00 19.71           N
ATOM    745  CA  HIS L  93      34.850  63.370  45.459  1.00 21.93           C
ATOM    746  C   HIS L  93      35.195  63.315  43.975  1.00 21.31           C
ATOM    747  O   HIS L  93      34.315  63.160  43.128  1.00 24.51           O
ATOM    748  CB  HIS L  93      35.647  62.312  46.224  1.00 22.05           C
ATOM    749  CG  HIS L  93      35.436  62.349  47.705  1.00 24.92           C
ATOM    750  ND1 HIS L  93      36.219  63.107  48.549  1.00 28.88           N
ATOM    751  CD2 HIS L  93      34.530  61.724  48.493  1.00 23.28           C
ATOM    752  CE1 HIS L  93      35.805  62.946  49.794  1.00 28.99           C
ATOM    753  NE2 HIS L  93      34.781  62.111  49.787  1.00 25.25           N
ATOM    754  N   PHE L  94      36.481  63.443  43.667  1.00 19.99           N
ATOM    755  CA  PHE L  94      36.947  63.414  42.286  1.00 22.72           C
ATOM    756  C   PHE L  94      38.084  62.410  42.114  1.00 21.64           C
ATOM    757  O   PHE L  94      39.046  62.421  42.882  1.00 28.16           O
ATOM    758  CB  PHE L  94      37.399  64.808  41.844  1.00 25.40           C
ATOM    759  CG  PHE L  94      37.817  64.884  40.402  1.00 28.81           C
ATOM    760  CD1 PHE L  94      39.154  64.809  40.048  1.00 30.47           C
ATOM    761  CD2 PHE L  94      36.871  65.031  39.401  1.00 30.95           C
ATOM    762  CE1 PHE L  94      39.540  64.879  38.722  1.00 27.48           C
ATOM    763  CE2 PHE L  94      37.250  65.102  38.073  1.00 29.08           C
ATOM    764  CZ  PHE L  94      38.586  65.026  37.734  1.00 26.89           C
ATOM    765  N   PRO L  95      37.976  61.534  41.102  1.00 19.24           N
ATOM    766  CA  PRO L  95      36.843  61.461  40.174  1.00 20.09           C
ATOM    767  C   PRO L  95      35.685  60.630  40.721  1.00 18.33           C
ATOM    768  O   PRO L  95      35.651  60.330  41.915  1.00 17.07           O
ATOM    769  CB  PRO L  95      37.454  60.793  38.943  1.00 18.87           C
ATOM    770  CG  PRO L  95      38.492  59.890  39.512  1.00 15.80           C
ATOM    771  CD  PRO L  95      39.051  60.597  40.726  1.00 19.88           C
ATOM    772  N   ARG L  96      34.751  60.264  39.850  1.00 19.22           N
ATOM    773  CA  ARG L  96      33.597  59.468  40.251  1.00 16.81           C
ATOM    774  C   ARG L  96      33.960  57.992  40.370  1.00 16.75           C
ATOM    775  O   ARG L  96      34.486  57.394  39.431  1.00 14.32           O
ATOM    776  CB  ARG L  96      32.450  59.649  39.255  1.00 20.25           C
ATOM    777  CG  ARG L  96      31.205  58.844  39.589  1.00 21.91           C
ATOM    778  CD  ARG L  96      30.107  59.074  38.564  1.00 18.74           C
ATOM    779  NE  ARG L  96      29.707  60.476  38.496  1.00 29.18           N
ATOM    780  CZ  ARG L  96      28.742  61.015  39.235  1.00 24.53           C
ATOM    781  NH1 ARG L  96      28.074  60.268  40.102  1.00 25.00           N
ATOM    782  NH2 ARG L  96      28.446  62.301  39.107  1.00 34.42           N
ATOM    783  N   THR L  97      33.676  57.409  41.530  1.00 13.95           N
ATOM    784  CA  THR L  97      33.971  56.002  41.774  1.00 16.33           C
ATOM    785  C   THR L  97      32.690  55.189  41.925  1.00 16.80           C
ATOM    786  O   THR L  97      31.786  55.570  42.668  1.00 14.18           O
ATOM    787  CB  THR L  97      34.838  55.817  43.033  1.00 13.03           C
ATOM    788  OG1 THR L  97      34.140  56.326  44.176  1.00 17.02           O
ATOM    789  CG2 THR L  97      36.161  56.552  42.883  1.00 15.08           C
ATOM    790  N   PHE L  98      32.621  54.066  41.216  1.00 16.56           N
ATOM    791  CA  PHE L  98      31.451  53.198  41.270  1.00 16.71           C
ATOM    792  C   PHE L  98      31.514  52.261  42.472  1.00 17.49           C
ATOM    793  O   PHE L  98      32.483  52.273  43.230  1.00 16.40           O
ATOM    794  CB  PHE L  98      31.325  52.387  39.978  1.00 15.96           C
ATOM    795  CG  PHE L  98      31.154  53.230  38.747  1.00 16.27           C
ATOM    796  CD1 PHE L  98      32.253  53.619  37.999  1.00 20.04           C
ATOM    797  CD2 PHE L  98      29.894  53.634  38.337  1.00 11.91           C
ATOM    798  CE1 PHE L  98      32.099  54.396  36.865  1.00 15.96           C
ATOM    799  CE2 PHE L  98      29.733  54.410  37.205  1.00 17.45           C
ATOM    800  CZ  PHE L  98      30.837  54.791  36.468  1.00 15.89           C
ATOM    801  N   GLY L  99      30.474  51.451  42.640  1.00 15.92           N
ATOM    802  CA  GLY L  99      30.409  50.513  43.744  1.00 15.99           C
ATOM    803  C   GLY L  99      30.497  49.070  43.287  1.00 19.28           C
ATOM    804  O   GLY L  99      30.867  48.792  42.146  1.00 16.40           O
ATOM    805  N   GLY L 100      30.155  48.149  44.182  1.00 15.57           N
ATOM    806  CA  GLY L 100      30.195  46.732  43.871  1.00 17.20           C
ATOM    807  C   GLY L 100      29.034  46.297  42.998  1.00 18.45           C
ATOM    808  O   GLY L 100      29.107  46.369  41.772  1.00 19.07           O
ATOM    809  N   GLY L 101      27.960  45.842  43.634  1.00 16.21           N
ATOM    810  CA  GLY L 101      26.781  45.396  42.916  1.00 12.89           C
ATOM    811  C   GLY L 101      26.022  44.314  43.660  1.00 16.63           C
ATOM    812  O   GLY L 101      26.571  43.254  43.962  1.00 19.11           O
ATOM    813  N   THR L 102      24.755  44.583  43.955  1.00 15.99           N
ATOM    814  CA  THR L 102      23.914  43.627  44.665  1.00 15.79           C
ATOM    815  C   THR L 102      22.863  43.024  43.739  1.00 17.18           C
ATOM    816  O   THR L 102      21.932  43.707  43.313  1.00 18.05           O
ATOM    817  CB  THR L 102      23.210  44.280  45.870  1.00 18.01           C
ATOM    818  OG1 THR L 102      24.190  44.808  46.771  1.00 18.32           O
ATOM    819  CG2 THR L 102      22.351  43.260  46.602  1.00 19.32           C
ATOM    820  N   LYS L 103      23.019  41.741  43.431  1.00 19.74           N
ATOM    821  CA  LYS L 103      22.087  41.045  42.551  1.00 18.89           C
ATOM    822  C   LYS L 103      20.897  40.497  43.331  1.00 19.24           C
ATOM    823  O   LYS L 103      21.064  39.757  44.300  1.00 16.37           O
ATOM    824  CB  LYS L 103      22.797  39.911  41.809  1.00 24.56           C
ATOM    825  CG  LYS L 103      21.898  39.130  40.864  1.00 27.08           C
ATOM    826  CD  LYS L 103      22.665  38.022  40.161  1.00 35.16           C
ATOM    827  CE  LYS L 103      21.766  37.242  39.216  1.00 40.81           C
ATOM    828  NZ  LYS L 103      20.626  36.606  39.931  1.00 46.41           N
ATOM    829  N   LEU L 104      19.694  40.865  42.900  1.00 19.61           N
ATOM    830  CA  LEU L 104      18.473  40.407  43.553  1.00 18.56           C
ATOM    831  C   LEU L 104      17.835  39.257  42.782  1.00 20.05           C
ATOM    832  O   LEU L 104      17.481  39.402  41.611  1.00 18.81           O
ATOM    833  CB  LEU L 104      17.478  41.561  43.696  1.00 19.25           C
ATOM    834  CG  LEU L 104      16.144  41.226  44.367  1.00 20.38           C
ATOM    835  CD1 LEU L 104      16.368  40.715  45.782  1.00 26.95           C
ATOM    836  CD2 LEU L 104      15.224  42.437  44.369  1.00 25.45           C
ATOM    837  N   GLU L 105      17.691  38.114  43.445  1.00 20.23           N
ATOM    838  CA  GLU L 105      17.099  36.936  42.822  1.00 21.84           C
ATOM    839  C   GLU L 105      15.834  36.500  43.552  1.00 19.89           C
ATOM    840  O   GLU L 105      15.847  36.289  44.765  1.00 18.85           O
ATOM    841  CB  GLU L 105      18.108  35.786  42.786  1.00 22.56           C
ATOM    842  CG  GLU L 105      17.576  34.514  42.147  1.00 28.91           C
ATOM    843  CD  GLU L 105      18.602  33.398  42.128  1.00 28.52           C
ATOM    844  OE1 GLU L 105      19.731  33.618  42.614  1.00 31.75           O
ATOM    845  OE2 GLU L 105      18.279  32.300  41.627  1.00 30.07           O
ATOM    846  N   ILE L 106      14.742  36.367  42.806  1.00 20.63           N
ATOM    847  CA  ILE L 106      13.467  35.953  43.379  1.00 20.50           C
ATOM    848  C   ILE L 106      13.440  34.448  43.626  1.00 23.46           C
ATOM    849  O   ILE L 106      13.670  33.656  42.712  1.00 25.56           O
ATOM    850  CB  ILE L 106      12.287  36.337  42.467  1.00 23.28           C
ATOM    851  CG1 ILE L 106      12.295  37.842  42.190  1.00 20.53           C
ATOM    852  CG2 ILE L 106      10.967  35.914  43.094  1.00 18.46           C
ATOM    853  CD1 ILE L 106      12.177  38.693  43.435  1.00 25.40           C
ATOM    854  N   LYS L 107      13.160  34.061  44.866  1.00 23.70           N
ATOM    855  CA  LYS L 107      13.104  32.651  45.236  1.00 26.21           C
ATOM    856  C   LYS L 107      11.890  31.965  44.619  1.00 27.53           C
ATOM    857  O   LYS L 107      10.752  32.224  45.012  1.00 31.16           O
ATOM    858  CB  LYS L 107      13.078  32.498  46.758  1.00 30.61           C
ATOM    859  CG  LYS L 107      13.021  31.056  47.235  1.00 35.39           C
ATOM    860  CD  LYS L 107      12.995  30.977  48.753  1.00 40.95           C
ATOM    861  CE  LYS L 107      14.238  31.606  49.361  1.00 46.41           C
ATOM    862  NZ  LYS L 107      14.227  31.536  50.848  1.00 49.96           N
ATOM    863  N   ARG L 108      12.140  31.088  43.652  1.00 26.17           N
ATOM    864  CA  ARG L 108      11.070  30.364  42.977  1.00 23.61           C
ATOM    865  C   ARG L 108      10.885  28.973  43.577  1.00 20.29           C
ATOM    866  O   ARG L 108      11.856  28.254  43.811  1.00 16.30           O
ATOM    867  CB  ARG L 108      11.358  30.258  41.478  1.00 23.68           C
ATOM    868  CG  ARG L 108      10.277  29.540  40.685  1.00 27.29           C
ATOM    869  CD  ARG L 108      10.628  29.476  39.207  1.00 19.40           C
ATOM    870  NE  ARG L 108       9.600  28.788  38.431  1.00 24.12           N
ATOM    871  CZ  ARG L 108       8.557  29.392  37.872  1.00 23.93           C
ATOM    872  NH1 ARG L 108       8.398  30.702  38.002  1.00 20.08           N
ATOM    873  NH2 ARG L 108       7.671  28.686  37.183  1.00 22.29           N
ATOM    874  N   ALA L 109       9.633  28.602  43.825  1.00 18.63           N
ATOM    875  CA  ALA L 109       9.318  27.299  44.397  1.00 18.59           C
ATOM    876  C   ALA L 109       9.552  26.181  43.386  1.00 17.80           C
ATOM    877  O   ALA L 109       9.671  26.431  42.186  1.00 16.24           O
ATOM    878  CB  ALA L 109       7.881  27.272  44.894  1.00 18.15           C
ATOM    879  N   ASP L 110       9.617  24.949  43.878  1.00 17.16           N
ATOM    880  CA  ASP L 110       9.843  23.791  43.021  1.00 19.95           C
ATOM    881  C   ASP L 110       8.608  23.471  42.186  1.00 19.90           C
ATOM    882  O   ASP L 110       7.477  23.628  42.647  1.00 19.52           O
ATOM    883  CB  ASP L 110      10.240  22.574  43.860  1.00 22.52           C
ATOM    884  CG  ASP L 110      11.506  22.807  44.660  1.00 24.08           C
ATOM    885  OD1 ASP L 110      12.369  23.583  44.199  1.00 25.66           O
ATOM    886  OD2 ASP L 110      11.639  22.213  45.751  1.00 26.01           O
ATOM    887  N   ALA L 111       8.832  23.021  40.956  1.00 18.87           N
ATOM    888  CA  ALA L 111       7.739  22.677  40.054  1.00 14.27           C
ATOM    889  C   ALA L 111       8.102  21.477  39.186  1.00 15.19           C
ATOM    890  O   ALA L 111       8.115  20.340  39.657  1.00 16.97           O
ATOM    891  CB  ALA L 111       7.374  23.871  39.185  1.00 12.29           C
ATOM    892  N   ALA L 112       8.396  21.737  37.916  1.00 13.07           N
ATOM    893  CA  ALA L 112       8.758  20.679  36.981  1.00 15.40           C
ATOM    894  C   ALA L 112       9.691  21.203  35.894  1.00 17.41           C
ATOM    895  O   ALA L 112       9.339  22.126  35.160  1.00 18.71           O
ATOM    896  CB  ALA L 112       7.510  20.071  36.360  1.00 16.36           C
ATOM    897  N   PRO L 113      10.890  20.611  35.790  1.00 16.05           N
ATOM    898  CA  PRO L 113      11.885  21.012  34.790  1.00 17.58           C
ATOM    899  C   PRO L 113      11.484  20.604  33.375  1.00 18.90           C
ATOM    900  O   PRO L 113      10.605  19.759  33.203  1.00 19.53           O
ATOM    901  CB  PRO L 113      13.146  20.269  35.235  1.00 16.01           C
ATOM    902  CG  PRO L 113      12.631  19.065  35.942  1.00 18.66           C
ATOM    903  CD  PRO L 113      11.377  19.510  36.641  1.00 14.79           C
ATOM    904  N   THR L 114      12.125  21.203  32.377  1.00 18.84           N
ATOM    905  CA  THR L 114      11.830  20.896  30.983  1.00 20.37           C
ATOM    906  C   THR L 114      13.109  20.770  30.162  1.00 20.61           C
ATOM    907  O   THR L 114      13.848  21.740  29.995  1.00 17.94           O
ATOM    908  CB  THR L 114      10.927  21.971  30.348  1.00 25.95           C
ATOM    909  OG1 THR L 114       9.696  22.056  31.075  1.00 34.32           O
ATOM    910  CG2 THR L 114      10.631  21.627  28.896  1.00 23.64           C
ATOM    911  N   VAL L 115      13.364  19.569  29.653  1.00 19.54           N
ATOM    912  CA  VAL L 115      14.553  19.314  28.849  1.00 17.09           C
ATOM    913  C   VAL L 115      14.181  18.964  27.412  1.00 17.02           C
ATOM    914  O   VAL L 115      13.511  17.963  27.160  1.00 16.34           O
ATOM    915  CB  VAL L 115      15.401  18.174  29.442  1.00 16.92           C
ATOM    916  CG1 VAL L 115      16.600  17.886  28.551  1.00 16.49           C
ATOM    917  CG2 VAL L 115      15.849  18.524  30.853  1.00 16.78           C
ATOM    918  N   SER L 116      14.620  19.797  26.473  1.00 19.59           N
ATOM    919  CA  SER L 116      14.333  19.578  25.061  1.00 17.45           C
ATOM    920  C   SER L 116      15.602  19.244  24.285  1.00 19.10           C
ATOM    921  O   SER L 116      16.664  19.813  24.538  1.00 18.10           O
ATOM    922  CB  SER L 116      13.654  20.809  24.455  1.00 18.92           C
ATOM    923  OG  SER L 116      12.432  21.093  25.114  1.00 25.77           O
ATOM    924  N   ILE L 117      15.485  18.318  23.338  1.00 18.19           N
ATOM    925  CA  ILE L 117      16.621  17.908  22.522  1.00 17.31           C
ATOM    926  C   ILE L 117      16.210  17.720  21.062  1.00 15.86           C
ATOM    927  O   ILE L 117      15.214  17.059  20.765  1.00 16.41           O
ATOM    928  CB  ILE L 117      17.259  16.605  23.061  1.00 16.44           C
ATOM    929  CG1 ILE L 117      18.308  16.071  22.083  1.00 15.90           C
ATOM    930  CG2 ILE L 117      16.192  15.553  23.340  1.00 14.41           C
ATOM    931  CD1 ILE L 117      18.985  14.800  22.547  1.00 21.22           C
ATOM    932  N   PHE L 118      16.976  18.319  20.156  1.00 14.79           N
ATOM    933  CA  PHE L 118      16.690  18.224  18.729  1.00 14.46           C
ATOM    934  C   PHE L 118      17.900  17.706  17.957  1.00 18.29           C
ATOM    935  O   PHE L 118      19.024  18.153  18.185  1.00 17.68           O
ATOM    936  CB  PHE L 118      16.258  19.584  18.177  1.00 14.37           C
ATOM    937  CG  PHE L 118      15.013  20.130  18.817  1.00 17.41           C
ATOM    938  CD1 PHE L 118      15.094  20.977  19.911  1.00 15.72           C
ATOM    939  CD2 PHE L 118      13.762  19.797  18.326  1.00 20.13           C
ATOM    940  CE1 PHE L 118      13.951  21.481  20.502  1.00 17.58           C
ATOM    941  CE2 PHE L 118      12.615  20.298  18.912  1.00 21.67           C
ATOM    942  CZ  PHE L 118      12.709  21.141  20.002  1.00 18.40           C
ATOM    943  N   PRO L 119      17.668  16.754  17.040  1.00 19.81           N
ATOM    944  CA  PRO L 119      18.724  16.168  16.205  1.00 18.67           C
ATOM    945  C   PRO L 119      19.430  17.209  15.341  1.00 19.51           C
ATOM    946  O   PRO L 119      18.784  18.143  14.866  1.00 19.80           O
ATOM    947  CB  PRO L 119      17.964  15.163  15.332  1.00 18.85           C
ATOM    948  CG  PRO L 119      16.728  14.847  16.102  1.00 24.77           C
ATOM    949  CD  PRO L 119      16.360  16.123  16.794  1.00 19.58           C
ATOM    950  N   PRO L 120      20.748  17.050  15.145  1.00 20.97           N
ATOM    951  CA  PRO L 120      21.556  17.964  14.328  1.00 21.56           C
ATOM    952  C   PRO L 120      21.068  18.045  12.884  1.00 25.06           C
ATOM    953  O   PRO L 120      20.520  17.073  12.364  1.00 22.77           O
ATOM    954  CB  PRO L 120      22.958  17.347  14.393  1.00 19.92           C
ATOM    955  CG  PRO L 120      22.959  16.539  15.645  1.00 24.16           C
ATOM    956  CD  PRO L 120      21.569  15.996  15.764  1.00 20.72           C
ATOM    957  N   SER L 121      21.268  19.196  12.251  1.00 26.39           N
ATOM    958  CA  SER L 121      20.844  19.394  10.870  1.00 29.46           C
ATOM    959  C   SER L 121      21.827  18.758   9.893  1.00 30.81           C
ATOM    960  O   SER L 121      22.896  18.293  10.287  1.00 31.79           O
ATOM    961  CB  SER L 121      20.692  20.886  10.566  1.00 29.86           C
ATOM    962  OG  SER L 121      21.917  21.573  10.754  1.00 27.09           O
ATOM    963  N   SER L 122      21.457  18.742   8.616  1.00 32.31           N
ATOM    964  CA  SER L 122      22.304  18.162   7.581  1.00 34.62           C
ATOM    965  C   SER L 122      23.197  19.220   6.941  1.00 32.62           C
ATOM    966  O   SER L 122      24.104  18.900   6.174  1.00 32.68           O
ATOM    967  CB  SER L 122      21.450  17.479   6.511  1.00 38.34           C
ATOM    968  OG  SER L 122      20.665  16.440   7.071  1.00 47.42           O
ATOM    969  N   GLU L 123      22.933  20.483   7.263  1.00 28.22           N
ATOM    970  CA  GLU L 123      23.713  21.590   6.722  1.00 30.40           C
ATOM    971  C   GLU L 123      25.080  21.680   7.393  1.00 30.09           C
ATOM    972  O   GLU L 123      26.057  22.106   6.777  1.00 31.18           O
ATOM    973  CB  GLU L 123      22.957  22.909   6.889  1.00 33.77           C
ATOM    974  CG  GLU L 123      21.609  22.946   6.187  1.00 40.35           C
ATOM    975  CD  GLU L 123      20.890  24.267   6.375  1.00 45.31           C
ATOM    976  OE1 GLU L 123      21.444  25.156   7.054  1.00 47.85           O
ATOM    977  OE2 GLU L 123      19.769  24.416   5.844  1.00 46.12           O
ATOM    978  N   GLN L 124      25.140  21.278   8.658  1.00 25.71           N
ATOM    979  CA  GLN L 124      26.387  21.310   9.413  1.00 25.58           C
ATOM    980  C   GLN L 124      27.283  20.133   9.040  1.00 23.66           C
ATOM    981  O   GLN L 124      28.506  20.266   8.979  1.00 22.13           O
ATOM    982  CB  GLN L 124      26.101  21.301  10.917  1.00 24.39           C
ATOM    983  CG  GLN L 124      27.343  21.402  11.788  1.00 21.71           C
ATOM    984  CD  GLN L 124      27.018  21.397  13.269  1.00 20.46           C
ATOM    985  OE1 GLN L 124      27.911  21.487  14.112  1.00 22.15           O
ATOM    986  NE2 GLN L 124      25.735  21.291  13.594  1.00 14.28           N
ATOM    987  N   LEU L 125      26.666  18.983   8.787  1.00 27.37           N
ATOM    988  CA  LEU L 125      27.404  17.780   8.420  1.00 32.30           C
ATOM    989  C   LEU L 125      27.959  17.880   7.003  1.00 34.69           C
ATOM    990  O   LEU L 125      28.933  17.210   6.659  1.00 35.46           O
ATOM    991  CB  LEU L 125      26.510  16.545   8.548  1.00 29.48           C
ATOM    992  CG  LEU L 125      25.940  16.260   9.938  1.00 26.81           C
ATOM    993  CD1 LEU L 125      25.067  15.015   9.916  1.00 27.37           C
ATOM    994  CD2 LEU L 125      27.058  16.117  10.959  1.00 26.09           C
ATOM    995  N   THR L 126      27.332  18.719   6.184  1.00 40.52           N
ATOM    996  CA  THR L 126      27.764  18.910   4.805  1.00 43.58           C
ATOM    997  C   THR L 126      29.077  19.682   4.740  1.00 44.41           C
ATOM    998  O   THR L 126      30.036  19.244   4.104  1.00 48.12           O
ATOM    999  CB  THR L 126      26.699  19.656   3.979  1.00 44.51           C
ATOM   1000  OG1 THR L 126      25.473  18.914   3.993  1.00 41.35           O
ATOM   1001  CG2 THR L 126      27.164  19.830   2.541  1.00 46.76           C
ATOM   1002  N   SER L 127      29.115  20.833   5.404  1.00 42.70           N
ATOM   1003  CA  SER L 127      30.310  21.668   5.425  1.00 42.23           C
ATOM   1004  C   SER L 127      31.391  21.062   6.314  1.00 40.37           C
ATOM   1005  O   SER L 127      32.583  21.245   6.070  1.00 41.28           O
ATOM   1006  CB  SER L 127      29.968  23.081   5.901  1.00 45.53           C
ATOM   1007  OG  SER L 127      29.421  23.061   7.208  1.00 45.92           O
ATOM   1008  N   GLY L 128      30.965  20.341   7.347  1.00 38.21           N
ATOM   1009  CA  GLY L 128      31.891  19.710   8.268  1.00 35.37           C
ATOM   1010  C   GLY L 128      31.621  20.085   9.712  1.00 35.07           C
ATOM   1011  O   GLY L 128      31.335  21.242  10.020  1.00 32.83           O
ATOM   1012  N   GLY L 129      31.712  19.101  10.601  1.00 33.96           N
ATOM   1013  CA  GLY L 129      31.479  19.328  12.015  1.00 30.00           C
ATOM   1014  C   GLY L 129      30.118  18.834  12.465  1.00 27.95           C
ATOM   1015  O   GLY L 129      29.222  18.623  11.648  1.00 26.40           O
ATOM   1016  N   ALA L 130      29.964  18.648  13.772  1.00 23.55           N
ATOM   1017  CA  ALA L 130      28.704  18.178  14.337  1.00 24.62           C
ATOM   1018  C   ALA L 130      28.487  18.741  15.737  1.00 23.91           C
ATOM   1019  O   ALA L 130      29.428  18.858  16.522  1.00 24.92           O
ATOM   1020  CB  ALA L 130      28.671  16.658  14.364  1.00 19.30           C
ATOM   1021  N   SER L 131      27.241  19.087  16.044  1.00 23.29           N
ATOM   1022  CA  SER L 131      26.899  19.639  17.349  1.00 19.61           C
ATOM   1023  C   SER L 131      25.546  19.124  17.829  1.00 20.26           C
ATOM   1024  O   SER L 131      24.551  19.200  17.108  1.00 24.19           O
ATOM   1025  CB  SER L 131      26.891  21.169  17.298  1.00 16.15           C
ATOM   1026  OG  SER L 131      28.163  21.673  16.929  1.00 19.83           O
ATOM   1027  N   VAL L 132      25.517  18.601  19.050  1.00 19.51           N
ATOM   1028  CA  VAL L 132      24.287  18.077  19.630  1.00 18.55           C
ATOM   1029  C   VAL L 132      23.497  19.177  20.330  1.00 20.78           C
ATOM   1030  O   VAL L 132      23.965  19.766  21.305  1.00 17.15           O
ATOM   1031  CB  VAL L 132      24.573  16.945  20.634  1.00 19.20           C
ATOM   1032  CG1 VAL L 132      23.279  16.457  21.268  1.00 13.22           C
ATOM   1033  CG2 VAL L 132      25.303  15.800  19.948  1.00 23.47           C
ATOM   1034  N   VAL L 133      22.298  19.450  19.827  1.00 18.23           N
ATOM   1035  CA  VAL L 133      21.444  20.484  20.400  1.00 15.80           C
ATOM   1036  C   VAL L 133      20.713  19.974  21.637  1.00 15.97           C
ATOM   1037  O   VAL L 133      19.892  19.060  21.552  1.00 17.77           O
ATOM   1038  CB  VAL L 133      20.411  20.993  19.377  1.00 13.36           C
ATOM   1039  CG1 VAL L 133      19.498  22.029  20.016  1.00 13.68           C
ATOM   1040  CG2 VAL L 133      21.112  21.571  18.158  1.00  9.78           C
ATOM   1041  N   CYS L 134      21.016  20.571  22.785  1.00 17.40           N
ATOM   1042  CA  CYS L 134      20.384  20.184  24.041  1.00 16.32           C
ATOM   1043  C   CYS L 134      20.214  21.389  24.960  1.00 15.78           C
ATOM   1044  O   CYS L 134      21.087  21.689  25.775  1.00 15.24           O
ATOM   1045  CB  CYS L 134      21.203  19.098  24.741  1.00 20.58           C
ATOM   1046  SG  CYS L 134      20.490  18.508  26.295  1.00 31.17           S
ATOM   1047  N   PHE L 135      19.085  22.077  24.822  1.00 18.11           N
ATOM   1048  CA  PHE L 135      18.804  23.258  25.630  1.00 16.09           C
ATOM   1049  C   PHE L 135      18.015  22.896  26.884  1.00 18.18           C
ATOM   1050  O   PHE L 135      17.110  22.062  26.841  1.00 20.13           O
ATOM   1051  CB  PHE L 135      18.038  24.299  24.810  1.00 18.31           C
ATOM   1052  CG  PHE L 135      18.814  24.846  23.646  1.00 20.82           C
ATOM   1053  CD1 PHE L 135      20.199  24.863  23.664  1.00 19.63           C
ATOM   1054  CD2 PHE L 135      18.158  25.344  22.532  1.00 21.88           C
ATOM   1055  CE1 PHE L 135      20.915  25.366  22.594  1.00 20.73           C
ATOM   1056  CE2 PHE L 135      18.868  25.849  21.459  1.00 25.03           C
ATOM   1057  CZ  PHE L 135      20.249  25.860  21.490  1.00 22.78           C
ATOM   1058  N   LEU L 136      18.363  23.530  27.999  1.00 13.63           N
ATOM   1059  CA  LEU L 136      17.684  23.283  29.266  1.00 17.06           C
ATOM   1060  C   LEU L 136      16.971  24.540  29.754  1.00 16.06           C
ATOM   1061  O   LEU L 136      17.604  25.562  30.017  1.00 14.67           O
ATOM   1062  CB  LEU L 136      18.673  22.794  30.329  1.00 18.25           C
ATOM   1063  CG  LEU L 136      19.189  21.353  30.239  1.00 21.45           C
ATOM   1064  CD1 LEU L 136      20.237  21.191  29.145  1.00 21.34           C
ATOM   1065  CD2 LEU L 136      19.742  20.901  31.584  1.00 24.55           C
ATOM   1066  N   ASN L 137      15.650  24.457  29.872  1.00 16.52           N
ATOM   1067  CA  ASN L 137      14.849  25.589  30.323  1.00 18.54           C
ATOM   1068  C   ASN L 137      14.071  25.270  31.595  1.00 19.47           C
ATOM   1069  O   ASN L 137      13.891  24.102  31.943  1.00 18.01           O
ATOM   1070  CB  ASN L 137      13.886  26.031  29.220  1.00 20.96           C
ATOM   1071  CG  ASN L 137      14.604  26.455  27.954  1.00 23.88           C
ATOM   1072  OD1 ASN L 137      15.731  26.949  28.002  1.00 26.18           O
ATOM   1073  ND2 ASN L 137      13.954  26.265  26.812  1.00 26.70           N
ATOM   1074  N   ASN L 138      13.617  26.319  32.277  1.00 17.59           N
ATOM   1075  CA  ASN L 138      12.849  26.193  33.514  1.00 18.38           C
ATOM   1076  C   ASN L 138      13.568  25.365  34.575  1.00 19.05           C
ATOM   1077  O   ASN L 138      13.194  24.223  34.843  1.00 15.36           O
ATOM   1078  CB  ASN L 138      11.472  25.586  33.227  1.00 18.43           C
ATOM   1079  CG  ASN L 138      10.653  26.428  32.268  1.00 22.22           C
ATOM   1080  OD1 ASN L 138      10.718  26.246  31.052  1.00 22.47           O
ATOM   1081  ND2 ASN L 138       9.876  27.358  32.812  1.00 22.19           N
ATOM   1082  N   PHE L 139      14.600  25.948  35.175  1.00 14.98           N
ATOM   1083  CA  PHE L 139      15.366  25.269  36.213  1.00 14.11           C
ATOM   1084  C   PHE L 139      15.725  26.224  37.347  1.00 15.67           C
ATOM   1085  O   PHE L 139      15.926  27.418  37.125  1.00 14.51           O
ATOM   1086  CB  PHE L 139      16.635  24.643  35.624  1.00 17.14           C
ATOM   1087  CG  PHE L 139      17.542  25.629  34.940  1.00 16.17           C
ATOM   1088  CD1 PHE L 139      18.571  26.244  35.634  1.00 13.43           C
ATOM   1089  CD2 PHE L 139      17.370  25.935  33.600  1.00 15.00           C
ATOM   1090  CE1 PHE L 139      19.407  27.149  35.007  1.00 13.20           C
ATOM   1091  CE2 PHE L 139      18.202  26.839  32.967  1.00 17.22           C
ATOM   1092  CZ  PHE L 139      19.222  27.446  33.672  1.00 15.06           C
ATOM   1093  N   TYR L 140      15.803  25.690  38.561  1.00 14.36           N
ATOM   1094  CA  TYR L 140      16.123  26.494  39.734  1.00 14.95           C
ATOM   1095  C   TYR L 140      16.901  25.675  40.761  1.00 15.08           C
ATOM   1096  O   TYR L 140      16.507  24.557  41.092  1.00 16.18           O
ATOM   1097  CB  TYR L 140      14.846  27.058  40.361  1.00 14.28           C
ATOM   1098  CG  TYR L 140      15.087  27.976  41.539  1.00 13.36           C
ATOM   1099  CD1 TYR L 140      15.017  27.501  42.842  1.00 17.13           C
ATOM   1100  CD2 TYR L 140      15.382  29.320  41.347  1.00 17.19           C
ATOM   1101  CE1 TYR L 140      15.236  28.338  43.921  1.00 14.54           C
ATOM   1102  CE2 TYR L 140      15.603  30.164  42.419  1.00 19.10           C
ATOM   1103  CZ  TYR L 140      15.529  29.668  43.703  1.00 20.15           C
ATOM   1104  OH  TYR L 140      15.748  30.504  44.774  1.00 20.14           O
ATOM   1105  N   PRO L 141      18.012  26.231  41.270  1.00 15.78           N
ATOM   1106  CA  PRO L 141      18.540  27.546  40.893  1.00 17.30           C
ATOM   1107  C   PRO L 141      19.456  27.487  39.673  1.00 15.63           C
ATOM   1108  O   PRO L 141      19.245  26.668  38.778  1.00 12.76           O
ATOM   1109  CB  PRO L 141      19.321  27.967  42.135  1.00 17.74           C
ATOM   1110  CG  PRO L 141      19.833  26.677  42.679  1.00 22.02           C
ATOM   1111  CD  PRO L 141      18.774  25.638  42.383  1.00 16.48           C
ATOM   1112  N   LYS L 142      20.465  28.352  39.647  1.00 18.47           N
ATOM   1113  CA  LYS L 142      21.411  28.398  38.538  1.00 18.85           C
ATOM   1114  C   LYS L 142      22.311  27.167  38.527  1.00 15.52           C
ATOM   1115  O   LYS L 142      22.594  26.602  37.470  1.00 16.21           O
ATOM   1116  CB  LYS L 142      22.259  29.670  38.612  1.00 25.85           C
ATOM   1117  CG  LYS L 142      23.269  29.812  37.485  1.00 32.81           C
ATOM   1118  CD  LYS L 142      24.083  31.088  37.632  1.00 38.93           C
ATOM   1119  CE  LYS L 142      25.097  31.230  36.509  1.00 42.09           C
ATOM   1120  NZ  LYS L 142      24.442  31.281  35.173  1.00 47.87           N
ATOM   1121  N   ASP L 143      22.757  26.756  39.710  1.00 15.98           N
ATOM   1122  CA  ASP L 143      23.627  25.593  39.840  1.00 19.76           C
ATOM   1123  C   ASP L 143      22.868  24.300  39.561  1.00 20.48           C
ATOM   1124  O   ASP L 143      21.918  23.961  40.267  1.00 18.29           O
ATOM   1125  CB  ASP L 143      24.251  25.545  41.236  1.00 22.61           C
ATOM   1126  CG  ASP L 143      25.087  26.772  41.543  1.00 26.06           C
ATOM   1127  OD1 ASP L 143      26.301  26.754  41.251  1.00 24.44           O
ATOM   1128  OD2 ASP L 143      24.530  27.754  42.076  1.00 29.19           O
ATOM   1129  N   ILE L 144      23.294  23.581  38.527  1.00 16.19           N
ATOM   1130  CA  ILE L 144      22.657  22.325  38.152  1.00 19.42           C
ATOM   1131  C   ILE L 144      23.689  21.309  37.664  1.00 21.24           C
ATOM   1132  O   ILE L 144      24.542  21.622  36.832  1.00 21.92           O
ATOM   1133  CB  ILE L 144      21.579  22.544  37.064  1.00 19.92           C
ATOM   1134  CG1 ILE L 144      21.063  21.204  36.534  1.00 20.37           C
ATOM   1135  CG2 ILE L 144      22.121  23.404  35.928  1.00 22.23           C
ATOM   1136  CD1 ILE L 144      19.997  21.337  35.468  1.00 20.41           C
ATOM   1137  N   ASN L 145      23.615  20.094  38.198  1.00 23.65           N
ATOM   1138  CA  ASN L 145      24.541  19.033  37.821  1.00 27.30           C
ATOM   1139  C   ASN L 145      24.243  18.485  36.430  1.00 26.78           C
ATOM   1140  O   ASN L 145      23.340  17.667  36.256  1.00 26.72           O
ATOM   1141  CB  ASN L 145      24.500  17.901  38.850  1.00 36.37           C
ATOM   1142  CG  ASN L 145      25.469  16.781  38.525  1.00 45.62           C
ATOM   1143  OD1 ASN L 145      26.647  16.842  38.878  1.00 51.88           O
ATOM   1144  ND2 ASN L 145      24.976  15.749  37.851  1.00 51.20           N
ATOM   1145  N   VAL L 146      25.008  18.941  35.444  1.00 23.67           N
ATOM   1146  CA  VAL L 146      24.829  18.496  34.067  1.00 24.32           C
ATOM   1147  C   VAL L 146      26.053  17.735  33.570  1.00 24.18           C
ATOM   1148  O   VAL L 146      27.145  18.294  33.467  1.00 26.85           O
ATOM   1149  CB  VAL L 146      24.554  19.681  33.122  1.00 24.76           C
ATOM   1150  CG1 VAL L 146      24.433  19.196  31.685  1.00 24.31           C
ATOM   1151  CG2 VAL L 146      23.296  20.420  33.550  1.00 24.43           C
ATOM   1152  N   LYS L 147      25.864  16.455  33.263  1.00 22.48           N
ATOM   1153  CA  LYS L 147      26.952  15.616  32.776  1.00 28.63           C
ATOM   1154  C   LYS L 147      26.654  15.084  31.378  1.00 26.89           C
ATOM   1155  O   LYS L 147      25.523  15.167  30.900  1.00 25.73           O
ATOM   1156  CB  LYS L 147      27.204  14.453  33.738  1.00 33.35           C
ATOM   1157  CG  LYS L 147      27.591  14.883  35.143  1.00 42.63           C
ATOM   1158  CD  LYS L 147      27.828  13.680  36.043  1.00 49.12           C
ATOM   1159  CE  LYS L 147      28.217  14.111  37.448  1.00 52.65           C
ATOM   1160  NZ  LYS L 147      28.453  12.943  38.341  1.00 57.07           N
ATOM   1161  N   TRP L 148      27.677  14.540  30.727  1.00 22.69           N
ATOM   1162  CA  TRP L 148      27.527  13.996  29.382  1.00 19.52           C
ATOM   1163  C   TRP L 148      28.149  12.608  29.274  1.00 21.40           C
ATOM   1164  O   TRP L 148      29.369  12.456  29.350  1.00 21.95           O
ATOM   1165  CB  TRP L 148      28.156  14.935  28.351  1.00 18.93           C
ATOM   1166  CG  TRP L 148      27.535  16.298  28.322  1.00 16.05           C
ATOM   1167  CD1 TRP L 148      27.905  17.384  29.061  1.00 15.60           C
ATOM   1168  CD2 TRP L 148      26.431  16.721  27.512  1.00 15.47           C
ATOM   1169  NE1 TRP L 148      27.101  18.457  28.762  1.00 17.97           N
ATOM   1170  CE2 TRP L 148      26.188  18.076  27.813  1.00 16.42           C
ATOM   1171  CE3 TRP L 148      25.626  16.086  26.562  1.00 16.97           C
ATOM   1172  CZ2 TRP L 148      25.173  18.807  27.199  1.00 15.78           C
ATOM   1173  CZ3 TRP L 148      24.619  16.814  25.952  1.00 17.54           C
ATOM   1174  CH2 TRP L 148      24.402  18.160  26.273  1.00 17.61           C
ATOM   1175  N   LYS L 149      27.304  11.598  29.096  1.00 17.84           N
ATOM   1176  CA  LYS L 149      27.769  10.222  28.970  1.00 19.97           C
ATOM   1177  C   LYS L 149      27.434   9.652  27.596  1.00 19.33           C
ATOM   1178  O   LYS L 149      26.309   9.214  27.353  1.00 18.65           O
ATOM   1179  CB  LYS L 149      27.158   9.347  30.067  1.00 22.42           C
ATOM   1180  CG  LYS L 149      27.507   9.788  31.479  1.00 28.84           C
ATOM   1181  CD  LYS L 149      26.870   8.875  32.515  1.00 32.85           C
ATOM   1182  CE  LYS L 149      27.221   9.314  33.927  1.00 37.81           C
ATOM   1183  NZ  LYS L 149      26.604   8.429  34.953  1.00 41.47           N
ATOM   1184  N   ILE L 150      28.417   9.660  26.702  1.00 17.42           N
ATOM   1185  CA  ILE L 150      28.225   9.151  25.349  1.00 20.99           C
ATOM   1186  C   ILE L 150      28.717   7.712  25.224  1.00 21.56           C
ATOM   1187  O   ILE L 150      29.910   7.442  25.371  1.00 20.44           O
ATOM   1188  CB  ILE L 150      28.953  10.023  24.310  1.00 21.07           C
ATOM   1189  CG1 ILE L 150      28.481  11.475  24.408  1.00 20.67           C
ATOM   1190  CG2 ILE L 150      28.730   9.478  22.907  1.00 22.97           C
ATOM   1191  CD1 ILE L 150      29.156  12.405  23.423  1.00 21.43           C
ATOM   1192  N   ASP L 151      27.784   6.801  24.954  1.00 21.23           N
ATOM   1193  CA  ASP L 151      28.082   5.379  24.792  1.00 21.70           C
ATOM   1194  C   ASP L 151      28.803   4.800  26.007  1.00 21.71           C
ATOM   1195  O   ASP L 151      29.738   4.011  25.867  1.00 21.00           O
ATOM   1196  CB  ASP L 151      28.915   5.145  23.528  1.00 18.71           C
ATOM   1197  CG  ASP L 151      28.206   5.605  22.270  1.00 21.03           C
ATOM   1198  OD1 ASP L 151      26.958   5.566  22.240  1.00 17.93           O
ATOM   1199  OD2 ASP L 151      28.896   6.007  21.310  1.00 19.26           O
ATOM   1200  N   GLY L 152      28.364   5.198  27.196  1.00 19.40           N
ATOM   1201  CA  GLY L 152      28.959   4.717  28.429  1.00 18.40           C
ATOM   1202  C   GLY L 152      30.070   5.616  28.934  1.00 21.91           C
ATOM   1203  O   GLY L 152      30.110   5.967  30.113  1.00 22.54           O
ATOM   1204  N   SER L 153      30.977   5.990  28.036  1.00 21.41           N
ATOM   1205  CA  SER L 153      32.100   6.849  28.392  1.00 23.78           C
ATOM   1206  C   SER L 153      31.643   8.283  28.637  1.00 23.93           C
ATOM   1207  O   SER L 153      30.734   8.778  27.970  1.00 25.28           O
ATOM   1208  CB  SER L 153      33.167   6.817  27.296  1.00 26.71           C
ATOM   1209  OG  SER L 153      34.264   7.649  27.629  1.00 33.36           O
ATOM   1210  N   GLU L 154      32.280   8.946  29.597  1.00 23.42           N
ATOM   1211  CA  GLU L 154      31.941  10.324  29.932  1.00 27.46           C
ATOM   1212  C   GLU L 154      32.809  11.309  29.156  1.00 28.73           C
ATOM   1213  O   GLU L 154      34.036  11.281  29.254  1.00 23.48           O
ATOM   1214  CB  GLU L 154      32.091  10.562  31.436  1.00 30.72           C
ATOM   1215  CG  GLU L 154      31.756  11.978  31.876  1.00 40.94           C
ATOM   1216  CD  GLU L 154      31.913  12.175  33.371  1.00 44.76           C
ATOM   1217  OE1 GLU L 154      32.286  11.205  34.065  1.00 47.13           O
ATOM   1218  OE2 GLU L 154      31.664  13.300  33.853  1.00 48.44           O
ATOM   1219  N   ARG L 155      32.163  12.180  28.386  1.00 28.39           N
ATOM   1220  CA  ARG L 155      32.874  13.175  27.593  1.00 31.83           C
ATOM   1221  C   ARG L 155      32.664  14.578  28.152  1.00 35.20           C
ATOM   1222  O   ARG L 155      31.551  15.105  28.131  1.00 36.17           O
ATOM   1223  CB  ARG L 155      32.423  13.118  26.132  1.00 35.82           C
ATOM   1224  CG  ARG L 155      33.119  14.122  25.228  1.00 39.58           C
ATOM   1225  CD  ARG L 155      34.622  13.899  25.208  1.00 44.28           C
ATOM   1226  NE  ARG L 155      34.971  12.566  24.723  1.00 50.36           N
ATOM   1227  CZ  ARG L 155      35.193  12.270  23.446  1.00 51.58           C
ATOM   1228  NH1 ARG L 155      35.103  13.214  22.519  1.00 53.09           N
ATOM   1229  NH2 ARG L 155      35.505  11.030  23.096  1.00 49.31           N
ATOM   1230  N   GLN L 156      33.739  15.179  28.651  1.00 36.90           N
ATOM   1231  CA  GLN L 156      33.674  16.521  29.217  1.00 41.03           C
ATOM   1232  C   GLN L 156      34.561  17.490  28.443  1.00 40.56           C
ATOM   1233  O   GLN L 156      34.831  18.600  28.900  1.00 41.63           O
ATOM   1234  CB  GLN L 156      34.079  16.501  30.693  1.00 46.15           C
ATOM   1235  CG  GLN L 156      33.200  15.622  31.570  1.00 54.47           C
ATOM   1236  CD  GLN L 156      31.790  16.163  31.719  1.00 60.74           C
ATOM   1237  OE1 GLN L 156      30.839  15.404  31.902  1.00 63.89           O
ATOM   1238  NE2 GLN L 156      31.650  17.482  31.651  1.00 61.58           N
ATOM   1239  N   ASN L 157      35.012  17.062  27.268  1.00 40.13           N
ATOM   1240  CA  ASN L 157      35.869  17.890  26.428  1.00 39.57           C
ATOM   1241  C   ASN L 157      35.092  18.548  25.294  1.00 37.34           C
ATOM   1242  O   ASN L 157      34.385  17.877  24.541  1.00 35.32           O
ATOM   1243  CB  ASN L 157      37.019  17.058  25.858  1.00 44.69           C
ATOM   1244  CG  ASN L 157      37.893  16.454  26.939  1.00 53.16           C
ATOM   1245  OD1 ASN L 157      37.645  15.341  27.404  1.00 58.47           O
ATOM   1246  ND2 ASN L 157      38.923  17.187  27.346  1.00 55.00           N
ATOM   1247  N   GLY L 158      35.226  19.865  25.177  1.00 33.30           N
ATOM   1248  CA  GLY L 158      34.540  20.613  24.140  1.00 31.53           C
ATOM   1249  C   GLY L 158      33.130  21.000  24.541  1.00 28.14           C
ATOM   1250  O   GLY L 158      32.311  21.360  23.696  1.00 31.41           O
ATOM   1251  N   VAL L 159      32.847  20.924  25.837  1.00 26.63           N
ATOM   1252  CA  VAL L 159      31.528  21.267  26.355  1.00 26.51           C
ATOM   1253  C   VAL L 159      31.393  22.772  26.564  1.00 26.19           C
ATOM   1254  O   VAL L 159      32.100  23.361  27.382  1.00 28.52           O
ATOM   1255  CB  VAL L 159      31.237  20.545  27.684  1.00 23.11           C
ATOM   1256  CG1 VAL L 159      29.880  20.963  28.229  1.00 19.32           C
ATOM   1257  CG2 VAL L 159      31.300  19.037  27.492  1.00 21.08           C
ATOM   1258  N   LEU L 160      30.481  23.389  25.820  1.00 24.95           N
ATOM   1259  CA  LEU L 160      30.251  24.825  25.923  1.00 25.07           C
ATOM   1260  C   LEU L 160      28.901  25.123  26.564  1.00 24.12           C
ATOM   1261  O   LEU L 160      27.852  24.911  25.955  1.00 19.14           O
ATOM   1262  CB  LEU L 160      30.334  25.480  24.543  1.00 26.58           C
ATOM   1263  CG  LEU L 160      31.664  25.334  23.801  1.00 33.27           C
ATOM   1264  CD1 LEU L 160      31.605  26.029  22.449  1.00 31.99           C
ATOM   1265  CD2 LEU L 160      32.810  25.880  24.639  1.00 32.28           C
ATOM   1266  N   ASN L 161      28.933  25.616  27.798  1.00 21.11           N
ATOM   1267  CA  ASN L 161      27.712  25.943  28.525  1.00 23.63           C
ATOM   1268  C   ASN L 161      27.500  27.448  28.636  1.00 23.38           C
ATOM   1269  O   ASN L 161      28.374  28.175  29.109  1.00 24.04           O
ATOM   1270  CB  ASN L 161      27.740  25.316  29.920  1.00 22.67           C
ATOM   1271  CG  ASN L 161      27.851  23.804  29.877  1.00 19.52           C
ATOM   1272  OD1 ASN L 161      27.378  23.162  28.939  1.00 22.32           O
ATOM   1273  ND2 ASN L 161      28.478  23.228  30.896  1.00 24.65           N
ATOM   1274  N   SER L 162      26.333  27.910  28.198  1.00 23.28           N
ATOM   1275  CA  SER L 162      26.003  29.329  28.250  1.00 21.47           C
ATOM   1276  C   SER L 162      24.593  29.548  28.790  1.00 18.33           C
ATOM   1277  O   SER L 162      23.609  29.176  28.151  1.00 16.76           O
ATOM   1278  CB  SER L 162      26.138  29.962  26.863  1.00 19.49           C
ATOM   1279  OG  SER L 162      25.821  31.342  26.898  1.00 24.49           O
ATOM   1280  N   TRP L 163      24.504  30.152  29.970  1.00 18.88           N
ATOM   1281  CA  TRP L 163      23.216  30.418  30.599  1.00 18.92           C
ATOM   1282  C   TRP L 163      22.719  31.822  30.269  1.00 19.32           C
ATOM   1283  O   TRP L 163      23.440  32.622  29.673  1.00 18.36           O
ATOM   1284  CB  TRP L 163      23.313  30.238  32.115  1.00 21.13           C
ATOM   1285  CG  TRP L 163      23.722  28.858  32.530  1.00 22.37           C
ATOM   1286  CD1 TRP L 163      22.898  27.803  32.795  1.00 21.25           C
ATOM   1287  CD2 TRP L 163      25.059  28.382  32.729  1.00 20.84           C
ATOM   1288  NE1 TRP L 163      23.639  26.700  33.146  1.00 22.48           N
ATOM   1289  CE2 TRP L 163      24.968  27.029  33.113  1.00 24.58           C
ATOM   1290  CE3 TRP L 163      26.324  28.968  32.619  1.00 23.86           C
ATOM   1291  CZ2 TRP L 163      26.093  26.254  33.387  1.00 27.02           C
ATOM   1292  CZ3 TRP L 163      27.439  28.197  32.892  1.00 25.29           C
ATOM   1293  CH2 TRP L 163      27.316  26.855  33.272  1.00 25.90           C
ATOM   1294  N   THR L 164      21.483  32.114  30.661  1.00 19.58           N
ATOM   1295  CA  THR L 164      20.888  33.421  30.410  1.00 21.33           C
ATOM   1296  C   THR L 164      20.663  34.183  31.711  1.00 23.17           C
ATOM   1297  O   THR L 164      21.376  33.978  32.693  1.00 20.66           O
ATOM   1298  CB  THR L 164      19.549  33.296  29.660  1.00 21.89           C
ATOM   1299  OG1 THR L 164      18.625  32.536  30.448  1.00 21.92           O
ATOM   1300  CG2 THR L 164      19.751  32.608  28.319  1.00 25.31           C
ATOM   1301  N   ASP L 165      19.667  35.063  31.711  1.00 26.05           N
ATOM   1302  CA  ASP L 165      19.346  35.858  32.891  1.00 28.15           C
ATOM   1303  C   ASP L 165      17.923  35.590  33.367  1.00 25.38           C
ATOM   1304  O   ASP L 165      17.214  34.759  32.800  1.00 25.33           O
ATOM   1305  CB  ASP L 165      19.532  37.348  32.600  1.00 30.96           C
ATOM   1306  CG  ASP L 165      20.952  37.691  32.196  1.00 40.38           C
ATOM   1307  OD1 ASP L 165      21.253  37.651  30.984  1.00 46.27           O
ATOM   1308  OD2 ASP L 165      21.768  38.000  33.090  1.00 41.46           O
ATOM   1309  N   GLN L 166      17.510  36.300  34.413  1.00 24.81           N
ATOM   1310  CA  GLN L 166      16.172  36.140  34.968  1.00 23.45           C
ATOM   1311  C   GLN L 166      15.153  36.979  34.205  1.00 26.11           C
ATOM   1312  O   GLN L 166      15.342  38.181  34.016  1.00 24.29           O
ATOM   1313  CB  GLN L 166      16.159  36.517  36.451  1.00 21.44           C
ATOM   1314  CG  GLN L 166      14.801  36.374  37.117  1.00 20.14           C
ATOM   1315  CD  GLN L 166      14.827  36.757  38.584  1.00 21.34           C
ATOM   1316  OE1 GLN L 166      15.869  37.136  39.119  1.00 20.59           O
ATOM   1317  NE2 GLN L 166      13.678  36.662  39.242  1.00 20.10           N
ATOM   1318  N   ASP L 167      14.074  36.339  33.767  1.00 27.95           N
ATOM   1319  CA  ASP L 167      13.026  37.025  33.023  1.00 29.93           C
ATOM   1320  C   ASP L 167      12.108  37.793  33.970  1.00 32.32           C
ATOM   1321  O   ASP L 167      12.032  37.484  35.159  1.00 28.91           O
ATOM   1322  CB  ASP L 167      12.218  36.026  32.190  1.00 35.59           C
ATOM   1323  CG  ASP L 167      11.363  36.701  31.136  1.00 43.09           C
ATOM   1324  OD1 ASP L 167      11.836  36.846  29.989  1.00 45.39           O
ATOM   1325  OD2 ASP L 167      10.221  37.090  31.455  1.00 50.52           O
ATOM   1326  N   SER L 168      11.414  38.795  33.439  1.00 33.22           N
ATOM   1327  CA  SER L 168      10.540  39.636  34.250  1.00 35.23           C
ATOM   1328  C   SER L 168       9.095  39.144  34.232  1.00 34.61           C
ATOM   1329  O   SER L 168       8.167  39.912  34.488  1.00 37.19           O
ATOM   1330  CB  SER L 168      10.601  41.087  33.767  1.00 36.36           C
ATOM   1331  OG  SER L 168      10.189  41.193  32.416  1.00 37.66           O
ATOM   1332  N   LYS L 169       8.908  37.863  33.930  1.00 34.88           N
ATOM   1333  CA  LYS L 169       7.575  37.271  33.903  1.00 36.42           C
ATOM   1334  C   LYS L 169       7.514  36.009  34.757  1.00 32.69           C
ATOM   1335  O   LYS L 169       6.964  36.019  35.858  1.00 30.70           O
ATOM   1336  CB  LYS L 169       7.154  36.953  32.467  1.00 42.22           C
ATOM   1337  CG  LYS L 169       7.060  38.171  31.561  1.00 48.53           C
ATOM   1338  CD  LYS L 169       6.640  37.780  30.153  1.00 55.82           C
ATOM   1339  CE  LYS L 169       6.547  38.997  29.247  1.00 58.26           C
ATOM   1340  NZ  LYS L 169       6.137  38.629  27.864  1.00 58.72           N
ATOM   1341  N   ASP L 170       8.081  34.923  34.241  1.00 28.93           N
ATOM   1342  CA  ASP L 170       8.084  33.649  34.951  1.00 22.71           C
ATOM   1343  C   ASP L 170       9.243  33.559  35.940  1.00 22.10           C
ATOM   1344  O   ASP L 170       9.295  32.642  36.761  1.00 21.97           O
ATOM   1345  CB  ASP L 170       8.145  32.486  33.958  1.00 24.60           C
ATOM   1346  CG  ASP L 170       9.178  32.699  32.866  1.00 26.56           C
ATOM   1347  OD1 ASP L 170      10.172  33.417  33.108  1.00 29.66           O
ATOM   1348  OD2 ASP L 170       8.995  32.147  31.760  1.00 30.73           O
ATOM   1349  N   SER L 171      10.163  34.517  35.848  1.00 20.46           N
ATOM   1350  CA  SER L 171      11.337  34.580  36.717  1.00 20.51           C
ATOM   1351  C   SER L 171      12.153  33.291  36.670  1.00 17.25           C
ATOM   1352  O   SER L 171      12.575  32.774  37.705  1.00 19.71           O
ATOM   1353  CB  SER L 171      10.922  34.886  38.160  1.00 20.21           C
ATOM   1354  OG  SER L 171      10.245  36.129  38.243  1.00 22.92           O
ATOM   1355  N   THR L 172      12.370  32.778  35.464  1.00 17.43           N
ATOM   1356  CA  THR L 172      13.136  31.552  35.279  1.00 18.12           C
ATOM   1357  C   THR L 172      14.430  31.819  34.518  1.00 18.93           C
ATOM   1358  O   THR L 172      14.771  32.968  34.239  1.00 18.61           O
ATOM   1359  CB  THR L 172      12.320  30.484  34.526  1.00 17.96           C
ATOM   1360  OG1 THR L 172      11.956  30.982  33.232  1.00 19.22           O
ATOM   1361  CG2 THR L 172      11.060  30.132  35.301  1.00 15.25           C
ATOM   1362  N   TYR L 173      15.147  30.750  34.185  1.00 17.92           N
ATOM   1363  CA  TYR L 173      16.404  30.868  33.456  1.00 15.72           C
ATOM   1364  C   TYR L 173      16.444  29.910  32.270  1.00 16.14           C
ATOM   1365  O   TYR L 173      15.597  29.025  32.145  1.00 14.22           O
ATOM   1366  CB  TYR L 173      17.590  30.603  34.385  1.00 17.15           C
ATOM   1367  CG  TYR L 173      17.689  31.569  35.545  1.00 16.57           C
ATOM   1368  CD1 TYR L 173      17.091  31.283  36.765  1.00 18.39           C
ATOM   1369  CD2 TYR L 173      18.381  32.766  35.420  1.00 18.69           C
ATOM   1370  CE1 TYR L 173      17.179  32.162  37.828  1.00 18.47           C
ATOM   1371  CE2 TYR L 173      18.475  33.652  36.477  1.00 18.35           C
ATOM   1372  CZ  TYR L 173      17.872  33.345  37.678  1.00 20.09           C
ATOM   1373  OH  TYR L 173      17.962  34.223  38.733  1.00 19.70           O
ATOM   1374  N   SER L 174      17.433  30.092  31.401  1.00 16.15           N
ATOM   1375  CA  SER L 174      17.585  29.245  30.224  1.00 14.61           C
ATOM   1376  C   SER L 174      19.045  28.859  30.008  1.00 15.98           C
ATOM   1377  O   SER L 174      19.938  29.702  30.090  1.00 13.49           O
ATOM   1378  CB  SER L 174      17.038  29.949  28.982  1.00 16.40           C
ATOM   1379  OG  SER L 174      15.661  30.251  29.131  1.00 18.71           O
ATOM   1380  N   MET L 175      19.279  27.580  29.732  1.00 19.92           N
ATOM   1381  CA  MET L 175      20.630  27.080  29.505  1.00 17.78           C
ATOM   1382  C   MET L 175      20.830  26.675  28.048  1.00 16.18           C
ATOM   1383  O   MET L 175      20.069  25.874  27.506  1.00 17.47           O
ATOM   1384  CB  MET L 175      20.924  25.895  30.426  1.00 22.48           C
ATOM   1385  CG  MET L 175      22.316  25.307  30.256  1.00 26.43           C
ATOM   1386  SD  MET L 175      22.623  23.915  31.360  1.00 29.78           S
ATOM   1387  CE  MET L 175      24.301  23.487  30.906  1.00 30.86           C
ATOM   1388  N   SER L 176      21.860  27.233  27.420  1.00 11.84           N
ATOM   1389  CA  SER L 176      22.163  26.931  26.026  1.00 15.67           C
ATOM   1390  C   SER L 176      23.466  26.149  25.903  1.00 16.12           C
ATOM   1391  O   SER L 176      24.510  26.711  25.572  1.00 13.99           O
ATOM   1392  CB  SER L 176      22.243  28.218  25.204  1.00 16.14           C
ATOM   1393  OG  SER L 176      22.538  27.939  23.846  1.00 18.80           O
ATOM   1394  N   SER L 177      23.398  24.849  26.171  1.00 16.05           N
ATOM   1395  CA  SER L 177      24.572  23.987  26.091  1.00 14.43           C
ATOM   1396  C   SER L 177      24.705  23.364  24.706  1.00 18.55           C
ATOM   1397  O   SER L 177      23.737  22.842  24.154  1.00 19.28           O
ATOM   1398  CB  SER L 177      24.506  22.891  27.156  1.00 15.92           C
ATOM   1399  OG  SER L 177      25.642  22.047  27.091  1.00 15.12           O
ATOM   1400  N   THR L 178      25.911  23.423  24.149  1.00 18.43           N
ATOM   1401  CA  THR L 178      26.173  22.866  22.828  1.00 16.88           C
ATOM   1402  C   THR L 178      27.543  22.200  22.772  1.00 20.48           C
ATOM   1403  O   THR L 178      28.572  22.859  22.924  1.00 22.05           O
ATOM   1404  CB  THR L 178      26.093  23.947  21.734  1.00 17.16           C
ATOM   1405  OG1 THR L 178      24.787  24.537  21.735  1.00 19.94           O
ATOM   1406  CG2 THR L 178      26.369  23.341  20.366  1.00 20.41           C
ATOM   1407  N   LEU L 179      27.550  20.889  22.552  1.00 22.32           N
ATOM   1408  CA  LEU L 179      28.794  20.132  22.473  1.00 21.07           C
ATOM   1409  C   LEU L 179      29.407  20.224  21.080  1.00 21.29           C
ATOM   1410  O   LEU L 179      28.856  19.697  20.113  1.00 20.43           O
ATOM   1411  CB  LEU L 179      28.554  18.668  22.847  1.00 21.66           C
ATOM   1412  CG  LEU L 179      29.777  17.749  22.809  1.00 22.35           C
ATOM   1413  CD1 LEU L 179      30.847  18.238  23.774  1.00 20.94           C
ATOM   1414  CD2 LEU L 179      29.382  16.314  23.124  1.00 22.39           C
ATOM   1415  N   THR L 180      30.549  20.897  20.984  1.00 24.12           N
ATOM   1416  CA  THR L 180      31.235  21.065  19.709  1.00 25.84           C
ATOM   1417  C   THR L 180      32.099  19.852  19.382  1.00 26.44           C
ATOM   1418  O   THR L 180      33.064  19.556  20.087  1.00 21.40           O
ATOM   1419  CB  THR L 180      32.117  22.327  19.705  1.00 29.86           C
ATOM   1420  OG1 THR L 180      31.305  23.482  19.952  1.00 33.73           O
ATOM   1421  CG2 THR L 180      32.818  22.483  18.364  1.00 31.34           C
ATOM   1422  N   LEU L 181      31.746  19.153  18.308  1.00 27.84           N
ATOM   1423  CA  LEU L 181      32.491  17.974  17.881  1.00 27.88           C
ATOM   1424  C   LEU L 181      32.980  18.122  16.444  1.00 25.63           C
ATOM   1425  O   LEU L 181      32.754  19.149  15.804  1.00 23.18           O
ATOM   1426  CB  LEU L 181      31.629  16.717  18.017  1.00 30.84           C
ATOM   1427  CG  LEU L 181      31.133  16.382  19.425  1.00 33.62           C
ATOM   1428  CD1 LEU L 181      30.288  15.117  19.410  1.00 35.84           C
ATOM   1429  CD2 LEU L 181      32.302  16.239  20.387  1.00 31.77           C
ATOM   1430  N   THR L 182      33.650  17.090  15.943  1.00 28.50           N
ATOM   1431  CA  THR L 182      34.169  17.103  14.580  1.00 28.26           C
ATOM   1432  C   THR L 182      33.209  16.410  13.619  1.00 29.68           C
ATOM   1433  O   THR L 182      31.991  16.481  13.785  1.00 30.89           O
ATOM   1434  CB  THR L 182      35.549  16.423  14.495  1.00 26.83           C
ATOM   1435  OG1 THR L 182      35.437  15.055  14.907  1.00 24.66           O
ATOM   1436  CG2 THR L 182      36.551  17.137  15.389  1.00 28.72           C
ATOM   1437  N   LYS L 183      33.764  15.741  12.614  1.00 33.77           N
ATOM   1438  CA  LYS L 183      32.957  15.040  11.622  1.00 33.68           C
ATOM   1439  C   LYS L 183      33.166  13.531  11.705  1.00 34.33           C
ATOM   1440  O   LYS L 183      32.214  12.757  11.611  1.00 29.48           O
ATOM   1441  CB  LYS L 183      33.287  15.540  10.214  1.00 33.64           C
ATOM   1442  CG  LYS L 183      32.473  14.880   9.113  1.00 35.35           C
ATOM   1443  CD  LYS L 183      32.849  15.426   7.745  1.00 39.24           C
ATOM   1444  CE  LYS L 183      32.033  14.769   6.644  1.00 37.84           C
ATOM   1445  NZ  LYS L 183      30.573  14.998   6.822  1.00 41.73           N
ATOM   1446  N   ASP L 184      34.417  13.121  11.885  1.00 34.54           N
ATOM   1447  CA  ASP L 184      34.755  11.706  11.972  1.00 35.73           C
ATOM   1448  C   ASP L 184      34.310  11.109  13.304  1.00 33.93           C
ATOM   1449  O   ASP L 184      34.068   9.906  13.405  1.00 30.41           O
ATOM   1450  CB  ASP L 184      36.260  11.502  11.784  1.00 42.36           C
ATOM   1451  CG  ASP L 184      36.751  12.002  10.439  1.00 49.31           C
ATOM   1452  OD1 ASP L 184      35.966  11.970   9.469  1.00 52.20           O
ATOM   1453  OD2 ASP L 184      37.923  12.426  10.353  1.00 53.88           O
ATOM   1454  N   GLU L 185      34.204  11.957  14.321  1.00 30.53           N
ATOM   1455  CA  GLU L 185      33.789  11.516  15.648  1.00 29.57           C
ATOM   1456  C   GLU L 185      32.304  11.167  15.670  1.00 24.71           C
ATOM   1457  O   GLU L 185      31.884  10.239  16.363  1.00 21.51           O
ATOM   1458  CB  GLU L 185      34.094  12.594  16.690  1.00 32.91           C
ATOM   1459  CG  GLU L 185      33.752  12.199  18.118  1.00 40.76           C
ATOM   1460  CD  GLU L 185      34.075  13.291  19.118  1.00 44.06           C
ATOM   1461  OE1 GLU L 185      34.573  14.356  18.697  1.00 45.45           O
ATOM   1462  OE2 GLU L 185      33.831  13.084  20.326  1.00 47.65           O
ATOM   1463  N   TYR L 186      31.515  11.913  14.904  1.00 22.95           N
ATOM   1464  CA  TYR L 186      30.075  11.690  14.836  1.00 22.27           C
ATOM   1465  C   TYR L 186      29.752  10.387  14.110  1.00 23.92           C
ATOM   1466  O   TYR L 186      28.727   9.758  14.371  1.00 22.37           O
ATOM   1467  CB  TYR L 186      29.385  12.867  14.141  1.00 22.25           C
ATOM   1468  CG  TYR L 186      27.877  12.761  14.096  1.00 22.07           C
ATOM   1469  CD1 TYR L 186      27.102  13.143  15.183  1.00 22.70           C
ATOM   1470  CD2 TYR L 186      27.227  12.284  12.965  1.00 19.16           C
ATOM   1471  CE1 TYR L 186      25.723  13.049  15.147  1.00 21.19           C
ATOM   1472  CE2 TYR L 186      25.849  12.186  12.919  1.00 22.00           C
ATOM   1473  CZ  TYR L 186      25.102  12.571  14.012  1.00 21.40           C
ATOM   1474  OH  TYR L 186      23.730  12.476  13.971  1.00 25.39           O
ATOM   1475  N   GLU L 187      30.634   9.987  13.200  1.00 25.44           N
ATOM   1476  CA  GLU L 187      30.443   8.760  12.436  1.00 28.75           C
ATOM   1477  C   GLU L 187      30.696   7.526  13.296  1.00 30.29           C
ATOM   1478  O   GLU L 187      30.101   6.471  13.074  1.00 34.87           O
ATOM   1479  CB  GLU L 187      31.361   8.744  11.212  1.00 29.14           C
ATOM   1480  CG  GLU L 187      31.122   9.889  10.241  1.00 32.84           C
ATOM   1481  CD  GLU L 187      32.047   9.839   9.041  1.00 36.60           C
ATOM   1482  OE1 GLU L 187      32.877   8.908   8.966  1.00 36.69           O
ATOM   1483  OE2 GLU L 187      31.944  10.730   8.172  1.00 42.02           O
ATOM   1484  N   ARG L 188      31.580   7.666  14.278  1.00 29.68           N
ATOM   1485  CA  ARG L 188      31.913   6.562  15.172  1.00 32.85           C
ATOM   1486  C   ARG L 188      30.799   6.315  16.184  1.00 30.86           C
ATOM   1487  O   ARG L 188      30.284   5.202  16.295  1.00 30.27           O
ATOM   1488  CB  ARG L 188      33.230   6.839  15.898  1.00 37.96           C
ATOM   1489  CG  ARG L 188      34.428   6.994  14.975  1.00 48.78           C
ATOM   1490  CD  ARG L 188      35.700   7.267  15.761  1.00 55.97           C
ATOM   1491  NE  ARG L 188      36.860   7.417  14.888  1.00 63.85           N
ATOM   1492  CZ  ARG L 188      37.645   6.413  14.509  1.00 67.24           C
ATOM   1493  NH1 ARG L 188      38.680   6.642  13.713  1.00 68.10           N
ATOM   1494  NH2 ARG L 188      37.395   5.179  14.927  1.00 68.59           N
ATOM   1495  N   HIS L 189      30.432   7.359  16.920  1.00 24.75           N
ATOM   1496  CA  HIS L 189      29.379   7.256  17.923  1.00 23.71           C
ATOM   1497  C   HIS L 189      28.000   7.210  17.273  1.00 24.64           C
ATOM   1498  O   HIS L 189      27.852   7.512  16.089  1.00 26.79           O
ATOM   1499  CB  HIS L 189      29.459   8.427  18.905  1.00 22.68           C
ATOM   1500  CG  HIS L 189      30.757   8.506  19.647  1.00 25.34           C
ATOM   1501  ND1 HIS L 189      30.973   7.851  20.840  1.00 26.15           N
ATOM   1502  CD2 HIS L 189      31.907   9.162  19.364  1.00 24.67           C
ATOM   1503  CE1 HIS L 189      32.200   8.101  21.261  1.00 26.25           C
ATOM   1504  NE2 HIS L 189      32.788   8.894  20.384  1.00 23.41           N
ATOM   1505  N   ASN L 190      26.995   6.831  18.055  1.00 25.08           N
ATOM   1506  CA  ASN L 190      25.629   6.738  17.554  1.00 25.31           C
ATOM   1507  C   ASN L 190      24.617   7.304  18.545  1.00 25.45           C
ATOM   1508  O   ASN L 190      23.812   8.169  18.199  1.00 24.83           O
ATOM   1509  CB  ASN L 190      25.281   5.285  17.226  1.00 29.15           C
ATOM   1510  CG  ASN L 190      23.871   5.130  16.691  1.00 31.49           C
ATOM   1511  OD1 ASN L 190      22.928   4.903  17.449  1.00 30.98           O
ATOM   1512  ND2 ASN L 190      23.720   5.251  15.377  1.00 34.25           N
ATOM   1513  N   SER L 191      24.663   6.810  19.778  1.00 23.83           N
ATOM   1514  CA  SER L 191      23.744   7.258  20.817  1.00 24.93           C
ATOM   1515  C   SER L 191      24.325   8.429  21.604  1.00 22.62           C
ATOM   1516  O   SER L 191      25.500   8.423  21.969  1.00 26.10           O
ATOM   1517  CB  SER L 191      23.406   6.106  21.765  1.00 25.58           C
ATOM   1518  OG  SER L 191      24.572   5.603  22.394  1.00 35.76           O
ATOM   1519  N   TYR L 192      23.492   9.433  21.861  1.00 20.96           N
ATOM   1520  CA  TYR L 192      23.916  10.609  22.611  1.00 18.77           C
ATOM   1521  C   TYR L 192      22.935  10.925  23.735  1.00 20.42           C
ATOM   1522  O   TYR L 192      21.987  11.688  23.549  1.00 20.12           O
ATOM   1523  CB  TYR L 192      24.058  11.816  21.682  1.00 15.79           C
ATOM   1524  CG  TYR L 192      25.093  11.635  20.594  1.00 19.38           C
ATOM   1525  CD1 TYR L 192      24.739  11.133  19.348  1.00 18.58           C
ATOM   1526  CD2 TYR L 192      26.424  11.965  20.813  1.00 13.17           C
ATOM   1527  CE1 TYR L 192      25.682  10.965  18.351  1.00 17.30           C
ATOM   1528  CE2 TYR L 192      27.374  11.801  19.823  1.00 19.20           C
ATOM   1529  CZ  TYR L 192      26.997  11.301  18.594  1.00 19.28           C
ATOM   1530  OH  TYR L 192      27.940  11.136  17.605  1.00 22.20           O
ATOM   1531  N   THR L 193      23.170  10.332  24.901  1.00 18.07           N
ATOM   1532  CA  THR L 193      22.301  10.538  26.054  1.00 17.57           C
ATOM   1533  C   THR L 193      22.566  11.886  26.716  1.00 16.70           C
ATOM   1534  O   THR L 193      23.668  12.145  27.201  1.00 17.17           O
ATOM   1535  CB  THR L 193      22.480   9.422  27.100  1.00 16.02           C
ATOM   1536  OG1 THR L 193      22.169   8.154  26.508  1.00 19.60           O
ATOM   1537  CG2 THR L 193      21.565   9.657  28.293  1.00 13.67           C
ATOM   1538  N   CYS L 194      21.549  12.742  26.732  1.00 16.69           N
ATOM   1539  CA  CYS L 194      21.664  14.058  27.350  1.00 17.33           C
ATOM   1540  C   CYS L 194      21.243  14.011  28.815  1.00 17.62           C
ATOM   1541  O   CYS L 194      20.071  14.199  29.140  1.00 16.52           O
ATOM   1542  CB  CYS L 194      20.820  15.083  26.590  1.00 18.04           C
ATOM   1543  SG  CYS L 194      20.912  16.765  27.249  1.00 32.91           S
ATOM   1544  N   GLU L 195      22.207  13.757  29.694  1.00 17.34           N
ATOM   1545  CA  GLU L 195      21.936  13.667  31.124  1.00 19.88           C
ATOM   1546  C   GLU L 195      21.665  15.042  31.727  1.00 20.22           C
ATOM   1547  O   GLU L 195      22.444  15.977  31.540  1.00 21.05           O
ATOM   1548  CB  GLU L 195      23.106  12.997  31.848  1.00 24.97           C
ATOM   1549  CG  GLU L 195      22.905  12.849  33.348  1.00 32.91           C
ATOM   1550  CD  GLU L 195      24.081  12.177  34.029  1.00 36.32           C
ATOM   1551  OE1 GLU L 195      25.057  11.832  33.330  1.00 38.85           O
ATOM   1552  OE2 GLU L 195      24.030  11.995  35.264  1.00 41.20           O
ATOM   1553  N   ALA L 196      20.556  15.156  32.449  1.00 16.39           N
ATOM   1554  CA  ALA L 196      20.182  16.412  33.088  1.00 21.33           C
ATOM   1555  C   ALA L 196      19.605  16.168  34.478  1.00 20.72           C
ATOM   1556  O   ALA L 196      18.417  16.388  34.715  1.00 17.53           O
ATOM   1557  CB  ALA L 196      19.185  17.170  32.224  1.00 18.50           C
ATOM   1558  N   THR L 197      20.453  15.711  35.393  1.00 18.09           N
ATOM   1559  CA  THR L 197      20.029  15.427  36.759  1.00 19.90           C
ATOM   1560  C   THR L 197      19.787  16.713  37.542  1.00 18.30           C
ATOM   1561  O   THR L 197      20.700  17.518  37.730  1.00 17.35           O
ATOM   1562  CB  THR L 197      21.068  14.570  37.506  1.00 24.04           C
ATOM   1563  OG1 THR L 197      21.259  13.332  36.810  1.00 29.31           O
ATOM   1564  CG2 THR L 197      20.602  14.283  38.925  1.00 28.68           C
ATOM   1565  N   HIS L 198      18.553  16.899  37.998  1.00 15.62           N
ATOM   1566  CA  HIS L 198      18.190  18.084  38.765  1.00 15.66           C
ATOM   1567  C   HIS L 198      17.988  17.728  40.236  1.00 17.04           C
ATOM   1568  O   HIS L 198      17.765  16.566  40.576  1.00 16.66           O
ATOM   1569  CB  HIS L 198      16.925  18.727  38.191  1.00 13.31           C
ATOM   1570  CG  HIS L 198      16.670  20.115  38.692  1.00 17.08           C
ATOM   1571  ND1 HIS L 198      15.783  20.387  39.711  1.00 17.72           N
ATOM   1572  CD2 HIS L 198      17.186  21.308  38.313  1.00 14.19           C
ATOM   1573  CE1 HIS L 198      15.764  21.688  39.939  1.00 14.45           C
ATOM   1574  NE2 HIS L 198      16.606  22.270  39.104  1.00 16.89           N
ATOM   1575  N   LYS L 199      18.067  18.733  41.103  1.00 16.74           N
ATOM   1576  CA  LYS L 199      17.928  18.520  42.540  1.00 19.00           C
ATOM   1577  C   LYS L 199      16.494  18.168  42.926  1.00 20.97           C
ATOM   1578  O   LYS L 199      16.252  17.591  43.987  1.00 21.85           O
ATOM   1579  CB  LYS L 199      18.385  19.762  43.309  1.00 20.45           C
ATOM   1580  CG  LYS L 199      17.612  21.025  42.967  1.00 22.66           C
ATOM   1581  CD  LYS L 199      18.115  22.215  43.768  1.00 26.15           C
ATOM   1582  CE  LYS L 199      17.962  21.979  45.262  1.00 21.03           C
ATOM   1583  NZ  LYS L 199      18.450  23.138  46.060  1.00 21.64           N
ATOM   1584  N   THR L 200      15.547  18.516  42.061  1.00 18.72           N
ATOM   1585  CA  THR L 200      14.138  18.237  42.314  1.00 19.72           C
ATOM   1586  C   THR L 200      13.677  16.992  41.562  1.00 20.83           C
ATOM   1587  O   THR L 200      12.501  16.861  41.222  1.00 26.38           O
ATOM   1588  CB  THR L 200      13.246  19.426  41.914  1.00 19.77           C
ATOM   1589  OG1 THR L 200      13.387  19.682  40.511  1.00 17.69           O
ATOM   1590  CG2 THR L 200      13.637  20.672  42.694  1.00 14.54           C
ATOM   1591  N   SER L 201      14.610  16.082  41.306  1.00 21.32           N
ATOM   1592  CA  SER L 201      14.301  14.848  40.594  1.00 24.17           C
ATOM   1593  C   SER L 201      15.236  13.718  41.016  1.00 25.64           C
ATOM   1594  O   SER L 201      16.457  13.861  40.970  1.00 23.14           O
ATOM   1595  CB  SER L 201      14.389  15.065  39.082  1.00 22.05           C
ATOM   1596  OG  SER L 201      15.689  15.480  38.701  1.00 29.12           O
ATOM   1597  N   THR L 202      14.652  12.597  41.426  1.00 27.73           N
ATOM   1598  CA  THR L 202      15.431  11.441  41.854  1.00 28.56           C
ATOM   1599  C   THR L 202      16.032  10.710  40.658  1.00 28.92           C
ATOM   1600  O   THR L 202      17.249  10.546  40.565  1.00 31.68           O
ATOM   1601  CB  THR L 202      14.575  10.454  42.670  1.00 31.31           C
ATOM   1602  OG1 THR L 202      14.052  11.116  43.828  1.00 36.27           O
ATOM   1603  CG2 THR L 202      15.409   9.260  43.106  1.00 32.66           C
ATOM   1604  N   SER L 203      15.172  10.272  39.745  1.00 27.56           N
ATOM   1605  CA  SER L 203      15.616   9.562  38.551  1.00 23.75           C
ATOM   1606  C   SER L 203      16.111  10.533  37.485  1.00 22.24           C
ATOM   1607  O   SER L 203      15.451  11.531  37.194  1.00 21.15           O
ATOM   1608  CB  SER L 203      14.485   8.696  37.991  1.00 20.42           C
ATOM   1609  OG  SER L 203      14.058   7.736  38.942  1.00 28.52           O
ATOM   1610  N   PRO L 204      17.281  10.241  36.897  1.00 23.24           N
ATOM   1611  CA  PRO L 204      17.873  11.089  35.857  1.00 25.65           C
ATOM   1612  C   PRO L 204      17.093  11.031  34.547  1.00 24.82           C
ATOM   1613  O   PRO L 204      16.524   9.992  34.213  1.00 25.58           O
ATOM   1614  CB  PRO L 204      19.275  10.502  35.685  1.00 28.16           C
ATOM   1615  CG  PRO L 204      19.129   9.075  36.083  1.00 27.58           C
ATOM   1616  CD  PRO L 204      18.121   9.069  37.198  1.00 22.91           C
ATOM   1617  N   ILE L 205      17.072  12.142  33.817  1.00 27.99           N
ATOM   1618  CA  ILE L 205      16.361  12.210  32.546  1.00 25.93           C
ATOM   1619  C   ILE L 205      17.215  11.664  31.407  1.00 26.15           C
ATOM   1620  O   ILE L 205      18.293  12.185  31.122  1.00 25.01           O
ATOM   1621  CB  ILE L 205      15.938  13.652  32.213  1.00 30.56           C
ATOM   1622  CG1 ILE L 205      15.076  14.229  33.338  1.00 33.11           C
ATOM   1623  CG2 ILE L 205      15.193  13.697  30.887  1.00 33.39           C
ATOM   1624  CD1 ILE L 205      14.620  15.651  33.092  1.00 40.58           C
ATOM   1625  N   VAL L 206      16.727  10.611  30.758  1.00 25.61           N
ATOM   1626  CA  VAL L 206      17.447   9.991  29.653  1.00 22.56           C
ATOM   1627  C   VAL L 206      16.791  10.314  28.315  1.00 23.74           C
ATOM   1628  O   VAL L 206      15.685   9.857  28.028  1.00 26.04           O
ATOM   1629  CB  VAL L 206      17.526   8.462  29.819  1.00 24.03           C
ATOM   1630  CG1 VAL L 206      18.249   7.836  28.636  1.00 24.31           C
ATOM   1631  CG2 VAL L 206      18.221   8.106  31.124  1.00 22.72           C
ATOM   1632  N   LYS L 207      17.480  11.107  27.501  1.00 21.44           N
ATOM   1633  CA  LYS L 207      16.972  11.488  26.188  1.00 22.91           C
ATOM   1634  C   LYS L 207      17.980  11.160  25.091  1.00 22.91           C
ATOM   1635  O   LYS L 207      18.642  12.049  24.557  1.00 20.68           O
ATOM   1636  CB  LYS L 207      16.628  12.979  26.157  1.00 22.57           C
ATOM   1637  CG  LYS L 207      15.530  13.385  27.126  1.00 29.92           C
ATOM   1638  CD  LYS L 207      14.230  12.656  26.825  1.00 29.61           C
ATOM   1639  CE  LYS L 207      13.130  13.067  27.790  1.00 36.42           C
ATOM   1640  NZ  LYS L 207      11.851  12.360  27.507  1.00 38.91           N
ATOM   1641  N   SER L 208      18.091   9.877  24.761  1.00 22.93           N
ATOM   1642  CA  SER L 208      19.019   9.429  23.730  1.00 23.69           C
ATOM   1643  C   SER L 208      18.301   9.189  22.406  1.00 22.47           C
ATOM   1644  O   SER L 208      17.085   8.999  22.374  1.00 19.97           O
ATOM   1645  CB  SER L 208      19.740   8.155  24.176  1.00 30.36           C
ATOM   1646  OG  SER L 208      18.819   7.108  24.423  1.00 31.97           O
ATOM   1647  N   PHE L 209      19.062   9.198  21.316  1.00 21.36           N
ATOM   1648  CA  PHE L 209      18.501   8.978  19.989  1.00 22.67           C
ATOM   1649  C   PHE L 209      19.441   8.144  19.125  1.00 26.96           C
ATOM   1650  O   PHE L 209      20.618   7.983  19.449  1.00 22.94           O
ATOM   1651  CB  PHE L 209      18.198  10.315  19.304  1.00 24.63           C
ATOM   1652  CG  PHE L 209      19.401  11.204  19.141  1.00 23.08           C
ATOM   1653  CD1 PHE L 209      20.152  11.172  17.977  1.00 22.08           C
ATOM   1654  CD2 PHE L 209      19.777  12.076  20.150  1.00 22.40           C
ATOM   1655  CE1 PHE L 209      21.257  11.989  17.824  1.00 26.03           C
ATOM   1656  CE2 PHE L 209      20.881  12.895  20.003  1.00 21.71           C
ATOM   1657  CZ  PHE L 209      21.621  12.851  18.839  1.00 20.59           C
ATOM   1658  N   ASN L 210      18.915   7.616  18.025  1.00 29.68           N
ATOM   1659  CA  ASN L 210      19.706   6.797  17.114  1.00 35.91           C
ATOM   1660  C   ASN L 210      19.745   7.384  15.708  1.00 38.80           C
ATOM   1661  O   ASN L 210      18.854   8.137  15.314  1.00 35.50           O
ATOM   1662  CB  ASN L 210      19.157   5.370  17.069  1.00 39.78           C
ATOM   1663  CG  ASN L 210      19.183   4.692  18.425  1.00 42.87           C
ATOM   1664  OD1 ASN L 210      20.041   4.980  19.259  1.00 45.62           O
ATOM   1665  ND2 ASN L 210      18.240   3.785  18.651  1.00 47.45           N
ATOM   1666  N   ARG L 211      20.782   7.035  14.954  1.00 43.49           N
ATOM   1667  CA  ARG L 211      20.939   7.525  13.590  1.00 50.94           C
ATOM   1668  C   ARG L 211      20.248   6.604  12.591  1.00 56.96           C
ATOM   1669  O   ARG L 211      20.101   6.945  11.417  1.00 61.08           O
ATOM   1670  CB  ARG L 211      22.421   7.667  13.238  1.00 48.48           C
ATOM   1671  CG  ARG L 211      23.183   8.631  14.134  1.00 44.50           C
ATOM   1672  CD  ARG L 211      24.649   8.736  13.735  1.00 43.64           C
ATOM   1673  NE  ARG L 211      25.370   7.480  13.924  1.00 42.96           N
ATOM   1674  CZ  ARG L 211      25.666   6.630  12.945  1.00 42.42           C
ATOM   1675  NH1 ARG L 211      25.305   6.900  11.698  1.00 43.30           N
ATOM   1676  NH2 ARG L 211      26.325   5.511  13.213  1.00 40.19           N
ATOM   1677  N   ASN L 212      19.825   5.436  13.064  1.00 63.62           N
ATOM   1678  CA  ASN L 212      19.148   4.465  12.213  1.00 70.84           C
ATOM   1679  C   ASN L 212      17.700   4.856  11.942  1.00 76.13           C
ATOM   1680  O   ASN L 212      17.127   4.483  10.918  1.00 78.13           O
ATOM   1681  CB  ASN L 212      19.203   3.074  12.847  1.00 71.04           C
ATOM   1682  CG  ASN L 212      20.622   2.584  13.056  1.00 72.56           C
ATOM   1683  OD1 ASN L 212      21.531   2.941  12.306  1.00 70.76           O
ATOM   1684  ND2 ASN L 212      20.819   1.761  14.079  1.00 73.07           N
ATOM   1685  N   GLU L 213      17.113   5.610  12.865  1.00 80.14           N
ATOM   1686  CA  GLU L 213      15.731   6.055  12.727  1.00 84.85           C
ATOM   1687  C   GLU L 213      15.639   7.577  12.735  1.00 86.71           C
ATOM   1688  O   GLU L 213      15.867   8.213  13.765  1.00 86.91           O
ATOM   1689  CB  GLU L 213      14.866   5.469  13.845  1.00 87.98           C
ATOM   1690  CG  GLU L 213      13.404   5.880  13.778  1.00 92.53           C
ATOM   1691  CD  GLU L 213      12.579   5.282  14.900  1.00 94.81           C
ATOM   1692  OE1 GLU L 213      13.149   4.544  15.731  1.00 95.41           O
ATOM   1693  OE2 GLU L 213      11.360   5.549  14.951  1.00 95.58           O
ATOM   1694  N   CYS L 214      15.309   8.145  11.577  1.00 89.38           N
ATOM   1695  CA  CYS L 214      15.161   9.591  11.409  1.00 92.10           C
ATOM   1696  C   CYS L 214      16.431  10.355  11.782  1.00 92.54           C
ATOM   1697  O   CYS L 214      17.507   9.777  11.934  1.00 91.81           O
ATOM   1698  CB  CYS L 214      13.979  10.109  12.234  1.00 94.22           C
ATOM   1699  SG  CYS L 214      12.384   9.381  11.793  1.00 97.85           S
ATOM   1700  OXT CYS L 214      16.410  11.577  11.930  1.00 93.46           O
TER
"""

def get_pdb_inputs(pdb_str):
  ppf = mmtbx.utils.process_pdb_file_srv().process_pdb_files(
    raw_records=pdb_str.splitlines())[0]
  xrs = ppf.xray_structure(show_summary = False)
  restraints_manager = mmtbx.restraints.manager(
    geometry      = ppf.geometry_restraints_manager(show_energies = False),
    normalization = True)
  return group_args(
    ph  = ppf.all_chain_proxies.pdb_hierarchy,
    grm = restraints_manager,
    xrs = xrs)

def get_map(xrs):
  f_calc = xrs.structure_factors(d_min = 1.0).f_calc()
  fft_map = f_calc.fft_map(resolution_factor=0.25)
  fft_map.apply_sigma_scaling()
  return fft_map.real_map_unpadded()

def exercise():
  """
  Exercise refine "easy".
  """
  pi = get_pdb_inputs(pdb_str=pdb_str_1)
  pi.ph.write_pdb_file(file_name="answer.pdb")
  sel = pi.ph.atom_selection_cache().selection(string = "resid 1:107")
  map_data = get_map(xrs=pi.xrs)
  xrs = pi.xrs.deep_copy_scatterers()
  xrs_fixed = xrs.select(selection = ~sel)
  xrs_poor = xrs.deep_copy_scatterers()
  xrs_poor.shake_sites_in_place(mean_distance=0.5, selection=sel)
  #
  x1 = xrs_poor.select(selection = sel)
  x2 = xrs.select(selection = sel)
  d = flex.mean(x1.distances(other=x2))
  assert approx_equal(d, 0.5, 0.05)
  #
  ero = individual_sites.easy(
    map_data                    = map_data,
    xray_structure              = xrs_poor,
    pdb_hierarchy               = pi.ph,
    geometry_restraints_manager = pi.grm,
    selection                   = sel,
    log                         = sys.stdout)
  xrs_refined = ero.xray_structure
  # comapre fixed
  x1 = xrs_refined.select(selection = ~sel)
  d = x1.distances(other=xrs_fixed)
  assert approx_equal(d.min_max_mean().as_tuple(), [0,0,0])
  # compare refined
  x1 = xrs_refined.select(selection = sel)
  x2 = xrs.select(selection = sel)
  d = flex.mean(x1.distances(other=x2))
  assert d < 0.05
  ero.pdb_hierarchy.write_pdb_file(file_name="refined.pdb")

if(__name__ == "__main__"):
  flex.set_random_seed(10000)
  random.seed(10000)
  timer = user_plus_sys_time()
  exercise()
  print("Time: %6.2f" % timer.elapsed())
