(* :Name: CheckPlot3D *)

(* :Title: CheckPlot3D *)

(* :Author: Tom Wickham-Jones*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package provides functions for drawing
	a grid on a three-dimensional surface.
*)


(* :History:
	Created summer 1994 by Tom Wickham-Jones.
	
	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)


BeginPackage[ "ExtendGraphics`CheckPlot3D`", "Utilities`FilterOptions`"]


CheckPlot3D::usage =
	"CheckPlot3D[ fun, xrng, yrng] generates a three-dimensional plot
	of fun over xrng and yrng.  The elements of the surface are
	alternately black and white."


Begin["`Private`"]



Options[ CheckPlot3D] =
	Join[ Options[ Graphics3D], {PlotPoints -> 25}];

SetOptions[ CheckPlot3D, Lighting -> False,BoxRatios -> {1,1,0.4}];

CheckPlot3D[ fun_, {x_, x0_, x1_}, {y_, y0_, y1_},opts___] :=
	Block[{nx, ny,xi,yi,polys,ix,iy,opt},
		opt = Join[ {opts}, Options[ CheckPlot3D]] ;
		pts = PlotPoints /. opt ;
		xi = (x1-x0)/pts;
		yi = (y1-y0)/pts;
		polys =
		  Table[
		  	{
			If[ Mod[ix,2] === Mod[iy,2], GrayLevel[0.25],GrayLevel[1]],
		    Polygon[
		      Part[ Flatten[
			    Table[ {x, y, fun }, 
				    {x, x0+xi(ix-1), x0+xi*ix,xi}, 
				    {y, y0+yi(iy-1), y0+yi*iy,yi}],
					1],{1,2,4,3}]]
			},
		    {ix,pts},{iy,pts}] ;
		opt = Apply[ Sequence, opt] ;
		Show[ 
		  Graphics3D[ {EdgeForm[ Thickness[0.001]],
		    polys}, FilterOptions[Graphics3D,opt]]]
		]
		
End[]

EndPackage[]

(*

<<ExtendGraphics`CheckPlot3D`

CheckPlot3D[ Sin[ x y], {x,-2,2}, {y, -2,2}]


CheckPlot3D[ Sin[ x y], {x,0,2Pi}, {y,0,Pi}]


*)



