use Test::More tests => 8;
use Test::Refcount;

use CipUX::RPC;
use CipUX::RPC::Server;
use CipUX::RPC::Server::Daemon;
use CipUX::RPC::Test::Client;

#diag('test CipUX::RPC');
my $object0 = CipUX::RPC->new( { cache_dir => 'blib/cache' } );
is_oneref( $object0, '$object0 has a refcount of 1' );
my $otherref0 = $object0;
is_refcount( $object0, 2, '$object0 now has 2 references' );

#diag('test CipUX::RPC::Server');
my $object1 = CipUX::RPC::Server->new( { cache_dir => 'blib/cache' } );
is_oneref( $object1, '$object1 has a refcount of 1' );
my $otherref1 = $object1;
is_refcount( $object1, 2, '$object1 now has 2 references' );

#diag('test CipUX::RPC::Daemon');
my $object2 = CipUX::RPC::Server::Daemon->new(
    { cache_dir => 'blib/cache', name => 'cipux_rpcd' } );
is_oneref( $object2, '$object2 has a refcount of 1' );
my $otherref2 = $object2;
is_refcount( $object2, 2, '$object2 now has 2 references' );

#diag('test CipUX::RPC::Test::Client');
my $object3 = CipUX::RPC::Test::Client->new(
    { name => 'cipux_rpc_test_client', cache_dir => 'blib/cache' } );
is_oneref( $object3, '$object3 has a refcount of 1' );
my $otherref = $object3;
is_refcount( $object3, 2, '$object3 now has 2 references' );
