;;;; -*- Mode: Common-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:          memstore.asd
;;;; Purpose:       ASDF system definition for memstore package
;;;; Programmer:    Kevin M. Rosenberg
;;;; Date Started:  July 2011
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defpackage #:memstore-system (:use #:asdf #:cl))
(in-package #:memstore-system)

(defsystem memstore
  :name "memstore"
  :author "Kevin M. Rosenberg <kevin@rosenberg.net>"
  :version "1.0"
  :licence "BSD"
  :depends-on (memcache cl-store flexi-streams zlib salza2 chipz)
  :components ((:module src
                :serial t
                :components
                        ((:file "package")
                         (:file "compress")
                         (:file "memstore")))))

(defmethod operation-done-p ((o test-op) (c (eql (find-system :memstore))))
  ;; Always returns NIL so that tests are never marked as done.
  nil)

(defmethod perform ((o test-op) (c (eql (find-system 'memstore))))
  (asdf:load-system 'memstore-tests)
  (asdf:test-system 'memstore-tests))
