/**
 * collectd - src/utils_random.h
 * Copyright (C) 2013       Florian Forster
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *   Florian Forster <octo at collectd.org>
 **/

/**
 * Returns a random double value in the range [0..1), i.e. excluding 1.
 *
 * This function is thread- and reentrant-safe.
 */
double cdrand_d();

/**
 * cdrand_u returns a random uint32_t value uniformly distributed in the range
 * [0-2^32).
 *
 * This function is thread- and reentrant-safe.
 */
uint32_t cdrand_u();

/**
 * Returns a random long between min and max, inclusively.
 *
 * If min is larger than max, the result may be rounded incorrectly and may be
 * outside the intended range. This function is thread- and reentrant-safe.
 */
long cdrand_range(long min, long max);
