/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.vfs2.provider;

import org.junit.Assert;
import org.junit.Test;

/**
 *
 * @version $Id: UriParserTestCase.java 1546274 2013-11-28 03:48:11Z ggregory $
 */
public class UriParserTestCase
{

    @Test
    public void testColonInFileName()
    {
        Assert.assertEquals(null, UriParser.extractScheme("some/path/some:file"));
    }

    @Test
    public void testNormalScheme()
    {
        Assert.assertEquals("ftp", UriParser.extractScheme("ftp://user:pass@host/some/path/some:file"));
    }

}
