/* $Id: kmo_priv_wave_cal.h,v 1.8 2013-08-07 14:39:15 aagudo Exp $
 *
 * This file is part of the KMOS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-08-07 14:39:15 $
 * $Revision: 1.8 $
 * $Name: not supported by cvs2svn $
 */

#ifndef KMOS_PRIV_WAVE_CAL_H
#define KMOS_PRIV_WAVE_CAL_H

/*------------------------------------------------------------------------------
 *                        Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

#include "kmclipm_vector.h"

#define ID_IFUS 1   // 1 if number of IFUs should be stored in QC parameters
                    // QC_ARC_MAX_DIFFID and QC_ARC_MAX_SDVID
                    // 0 if number of slitlets should be stored
                    // (1-14: IFU1, 15-28: IFU2, ..., 99-112: IFU8

/**
    @brief Available calibration lamps configurations.

    - ARGON:      Only argon lamp on
    - NEON:       Only neon lamp on
    - ARGON_NEON: Both lamps on
*/
enum lampConfiguration {ARGON, NEON, ARGON_NEON};

/*------------------------------------------------------------------------------
 *                        Prototypes
 *----------------------------------------------------------------------------*/

cpl_error_code  kmo_calc_wave_calib(const cpl_image *data,
                                    const cpl_image *bad_pix,
                                    const cpl_image *xcal,
                                    const cpl_image *ycal,
                                    const char *filter_id,
                                    enum lampConfiguration lamp_config,
                                    const int detector_nr,
                                    cpl_array *ifu_inactive,
                                    cpl_table **edge_table,
                                    const cpl_bivector *lines,
                                    const cpl_table *reflines,
                                    double disp,
                                    cpl_image **lcal,
                                    double *qc_ar_eff,
                                    double *qc_ne_eff,
                                    int flip_trace,
                                    const int fit_order,
                                    const int line_estimate_method);

cpl_vector*     kmo_extract_initial_trace(
                                    const cpl_image *data,
                                    const cpl_image *bad_pix,
                                    const cpl_vector *left_edge,
                                    const cpl_vector *right_edge,
                                    const int edge_offset);

cpl_error_code  kmo_estimate_lines( const cpl_vector *trace,
                                    const cpl_vector *lines,
                                    const char *filter_id,
                                    double disp,
                                    cpl_vector **positions,
                                    cpl_vector **lambdas,
                                    int dbg_detector_nr,
                                    int dbg_ifu_nr,
                                    int dbg_slitlet_nr,
                                    const char *data_fits_name);

cpl_bivector*     kmo_get_lines(const cpl_table *arclines,
                                    enum lampConfiguration lamp_config);

cpl_error_code  kmo_extrapolate_arclines(
                                    const cpl_image *data,
                                    const cpl_image *bad_pix,
                                    const cpl_vector *positions,
                                    const cpl_vector *lambdas,
                                    const cpl_vector *left_edge,
                                    const cpl_vector *right_edge,
                                    cpl_vector **xarray,
                                    cpl_image **yarray,
                                    kmclipm_vector **larray,
                                    cpl_vector **qc_vec,
                                    int dbg_detector_nr,
                                    int dbg_ifu_nr,
                                    int dbg_slitlet_nr,
                                    const char *filter_id,
                                    enum lampConfiguration lamp_config);

cpl_error_code  kmo_fit_arcline(const int left_edge,
                                    const int right_edge,
                                    const int ypos,
                                    const int min_left_edge,
                                    const cpl_image *data,
                                    const cpl_image *badpix,
                                    kmclipm_vector **yline,
                                    kmclipm_vector **sline,
                                    kmclipm_vector **fline);

int             kmo_fit_spectrum(const cpl_image *bad_pix,
                                    const cpl_vector *xarray,
                                    const cpl_image *yarray,
                                    const cpl_vector *larray,
                                    const cpl_vector *left_edge,
                                    const cpl_vector *right_edge,
                                    cpl_image **lcal,
                                    double *min_lambda,
                                    double *max_lambda,
                                    const int fit_order,
                                    int dbg_detector_nr,
                                    int dbg_ifu_nr,
                                    int dbg_slitlet_nr);

int             kmo_fit_spectrum_1( const cpl_image *bad_pix,
                                    const cpl_vector *xarray,
                                    const cpl_image *yarray,
                                    const cpl_vector *larray,
                                    const cpl_vector *left_edge,
                                    const cpl_vector *right_edge,
                                    cpl_image **lcal,
                                    double *pfitpar,
                                    const int fit_order,
                                    int *valid_columns,
                                    const int fitpar_offset,
                                    int dbg_detector_nr,
                                    int dbg_ifu_nr,
                                    int dbg_slitlet_nr,
                                    const char* data_fits_name);

int             kmo_fit_spectrum_2( const cpl_image *bad_pix,
                                    const cpl_vector *xarray,
                                    const cpl_image *yarray,
                                    const cpl_vector *larray,
                                    const cpl_vector *left_edge,
                                    const cpl_vector *right_edge,
                                    cpl_image **lcal,
                                    double *min_lambda,
                                    double *max_lambda,
                                    double *pfitpar,
                                    const int fit_order,
                                    int *valid_columns,
                                    const int fitpar_offset,
                                    int dbg_detector_nr,
                                    int dbg_ifu_nr,
                                    int dbg_slitlet_nr);

cpl_image*      kmo_reconstructed_arc_image(cpl_frameset *frameset,
                                    cpl_image *arcDetImg_data,
                                    cpl_image *darkDetImg_data,
                                    cpl_image *xcalDetImg,
                                    cpl_image *ycalDetImg,
                                    cpl_image *lcalDetImg,
                                    cpl_array *ifu_inactive,
                                    int flip,
                                    int device_nr,
                                    const char *suffix,
                                    const char *filter_id,
                                    enum lampConfiguration lamp_config,
                                    cpl_propertylist **qc_header);

cpl_error_code  kmo_calc_qc_wave_cal(
                                    const cpl_imagelist *data_cube,
                                    double crpix,
                                    double crval,
                                    double cdelt,
                                    double ref_wavelength,
                                    double *pos_mean_offset,
                                    double *pos_stdev,
                                    double *pos_95ile,
                                    double *fwhm_mean_offset,
                                    double *fwhm_stdev,
                                    double *fwhm_95ile);

cpl_error_code  kmo_priv_reject_qc( const kmclipm_vector *gpeak,
                                    double *mean,
                                    double *stddev);

double          kmo_calc_fitted_slitlet_edge(
                                    cpl_table *edge_table,
                                    int row,
                                    int y);

int             kmo_image_get_saturated(const cpl_image *data,
                            float threshold);

char**          kmo_get_filter_setup(const cpl_propertylist *pl,
                             int nr_devices,
                             int check_return);

#endif
