/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_misc1.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:40 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc1.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC1_H__
#define BCHP_MISC1_H__

/***************************************************************************
 *MISC1 - Registers for DMA List Control
 ***************************************************************************/
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0    0x00502000 /* Tx DMA Descriptor List0 First Descriptor lower Address */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST0    0x00502004 /* Tx DMA Descriptor List0 First Descriptor Upper Address */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1    0x00502008 /* Tx DMA Descriptor List1 First Descriptor Lower Address */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST1    0x0050200c /* Tx DMA Descriptor List1 First Descriptor Upper Address */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS      0x00502010 /* Tx DMA Software Descriptor List Control and Status */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS           0x00502018 /* Tx DMA Engine Error Status */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_L_ADDR  0x0050201c /* Tx DMA List0 Current Descriptor Lower Address */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_U_ADDR  0x00502020 /* Tx DMA List0 Current Descriptor Upper Address */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM 0x00502024 /* Tx DMA List0 Current Descriptor Upper Address */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_L_ADDR  0x00502028 /* Tx DMA List1 Current Descriptor Lower Address */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_U_ADDR  0x0050202c /* Tx DMA List1 Current Descriptor Upper Address */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM 0x00502030 /* Tx DMA List1 Current Descriptor Upper Address */
#define BCHP_MISC1_TX_DMA_CTRL                   0x00502034 /* Tx DMA Flea Interface Control */
#define BCHP_MISC1_TX_DMA_STATE                  0x00502038 /* Tx DMA Flea Interface State */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0  0x00502040 /* Y Rx Descriptor List0 First Descriptor Lower Address */
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST0  0x00502044 /* Y Rx Descriptor List0 First Descriptor Upper Address */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1  0x00502048 /* Y Rx Descriptor List1 First Descriptor Lower Address */
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST1  0x0050204c /* Y Rx Descriptor List1 First Descriptor Upper Address */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS    0x00502050 /* Y Rx Software Descriptor List Control and Status */
#define BCHP_MISC1_Y_RX_ERROR_STATUS             0x00502054 /* Y Rx Engine Error Status */
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_L_ADDR    0x00502058 /* Y Rx List0 Current Descriptor Lower Address */
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_U_ADDR    0x0050205c /* Y Rx List0 Current Descriptor Upper Address */
#define BCHP_MISC1_Y_RX_LIST0_CUR_BYTE_CNT       0x00502060 /* Y Rx List0 Current Descriptor Byte Count */
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_L_ADDR    0x00502064 /* Y Rx List1 Current Descriptor Lower address */
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_U_ADDR    0x00502068 /* Y Rx List1 Current Descriptor Upper address */
#define BCHP_MISC1_Y_RX_LIST1_CUR_BYTE_CNT       0x0050206c /* Y Rx List1 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0 0x00502080 /* HIF Rx Descriptor List0 First Descriptor lower Address */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST0 0x00502084 /* HIF Rx Descriptor List0 First Descriptor Upper Address */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1 0x00502088 /* HIF Rx Descriptor List1 First Descriptor Lower Address */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST1 0x0050208c /* HIF Rx Descriptor List1 First Descriptor Upper Address */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS  0x00502090 /* HIF Rx Software Descriptor List Control and Status */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS           0x00502094 /* HIF Rx Engine Error Status */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_L_ADDR  0x00502098 /* HIF Rx List0 Current Descriptor Lower Address */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_U_ADDR  0x0050209c /* HIF Rx List0 Current Descriptor Upper Address */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_BYTE_CNT     0x005020a0 /* HIF Rx List0 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_L_ADDR  0x005020a4 /* HIF Rx List1 Current Descriptor Lower Address */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_U_ADDR  0x005020a8 /* HIF Rx List1 Current Descriptor Upper Address */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_BYTE_CNT     0x005020ac /* HIF Rx List1 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_DMA_CTRL                  0x005020b0 /* HIF Rx DMA Flea Interface Control */
#define BCHP_MISC1_HIF_DMA_STATE                 0x005020b4 /* HIF Rx DMA Flea Interface State */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG         0x005020c0 /* DMA Debug Options Register */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS     0x005020c4 /* Read Channel Error Status */
#define BCHP_MISC1_PCIE_DMA_CTRL                 0x005020c8 /* PCIE DMA Control Register */
#define BCHP_MISC1_HIF_RXDMA_BASE_ADDR           0x005020cc /* HIF Rx DMA Base DRAM Address */
#define BCHP_MISC1_HIF_RXDMA_LENGTH              0x005020d0 /* HIF Rx DMA Transfer Length */

/***************************************************************************
 *TX_FIRST_DESC_L_ADDR_LIST0 - Tx DMA Descriptor List0 First Descriptor lower Address
 ***************************************************************************/
/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST0 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_MASK       0xffffffe0
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_SHIFT      5

/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST0 :: reserved0 [04:01] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_reserved0_MASK       0x0000001e
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_reserved0_SHIFT      1

/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST0 :: TX_DESC_LIST0_VALID [00:00] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_TX_DESC_LIST0_VALID_MASK 0x00000001
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0_TX_DESC_LIST0_VALID_SHIFT 0

/***************************************************************************
 *TX_FIRST_DESC_U_ADDR_LIST0 - Tx DMA Descriptor List0 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_FIRST_DESC_U_ADDR_LIST0 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_MASK       0xffffffff
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_SHIFT      0

/***************************************************************************
 *TX_FIRST_DESC_L_ADDR_LIST1 - Tx DMA Descriptor List1 First Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST1 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_MASK       0xffffffe0
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_SHIFT      5

/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST1 :: reserved0 [04:01] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_reserved0_MASK       0x0000001e
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_reserved0_SHIFT      1

/* MISC1 :: TX_FIRST_DESC_L_ADDR_LIST1 :: TX_DESC_LIST1_VALID [00:00] */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_TX_DESC_LIST1_VALID_MASK 0x00000001
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1_TX_DESC_LIST1_VALID_SHIFT 0

/***************************************************************************
 *TX_FIRST_DESC_U_ADDR_LIST1 - Tx DMA Descriptor List1 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_FIRST_DESC_U_ADDR_LIST1 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_MASK       0xffffffff
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_SHIFT      0

/***************************************************************************
 *TX_SW_DESC_LIST_CTRL_STS - Tx DMA Software Descriptor List Control and Status
 ***************************************************************************/
/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: reserved0 [31:04] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_reserved0_MASK         0xfffffff0
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_reserved0_SHIFT        4

/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: DMA_DATA_SERV_PTR [03:03] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_MASK 0x00000008
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_SHIFT 3

/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: DESC_SERV_PTR [02:02] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_MASK     0x00000004
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_SHIFT    2

/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: TX_DMA_HALT_ON_ERROR [01:01] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_HALT_ON_ERROR_MASK 0x00000002
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_HALT_ON_ERROR_SHIFT 1

/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: TX_DMA_RUN_STOP [00:00] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_RUN_STOP_MASK   0x00000001
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_RUN_STOP_SHIFT  0

/***************************************************************************
 *TX_DMA_ERROR_STATUS - Tx DMA Engine Error Status
 ***************************************************************************/
/* MISC1 :: TX_DMA_ERROR_STATUS :: reserved0 [31:10] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved0_MASK              0xfffffc00
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved0_SHIFT             10

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L1_DESC_TX_ABORT_ERRORS [09:09] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_DESC_TX_ABORT_ERRORS_MASK 0x00000200
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_DESC_TX_ABORT_ERRORS_SHIFT 9

/* MISC1 :: TX_DMA_ERROR_STATUS :: reserved1 [08:08] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved1_MASK              0x00000100
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved1_SHIFT             8

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L0_DESC_TX_ABORT_ERRORS [07:07] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_DESC_TX_ABORT_ERRORS_MASK 0x00000080
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_DESC_TX_ABORT_ERRORS_SHIFT 7

/* MISC1 :: TX_DMA_ERROR_STATUS :: reserved2 [06:06] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved2_MASK              0x00000040
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved2_SHIFT             6

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L1_DMA_DATA_TX_ABORT_ERRORS [05:05] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_DMA_DATA_TX_ABORT_ERRORS_MASK 0x00000020
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_DMA_DATA_TX_ABORT_ERRORS_SHIFT 5

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L1_FIFO_FULL_ERRORS [04:04] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_FIFO_FULL_ERRORS_MASK 0x00000010
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L1_FIFO_FULL_ERRORS_SHIFT 4

/* MISC1 :: TX_DMA_ERROR_STATUS :: reserved3 [03:03] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved3_MASK              0x00000008
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved3_SHIFT             3

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L0_DMA_DATA_TX_ABORT_ERRORS [02:02] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_DMA_DATA_TX_ABORT_ERRORS_MASK 0x00000004
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_DMA_DATA_TX_ABORT_ERRORS_SHIFT 2

/* MISC1 :: TX_DMA_ERROR_STATUS :: TX_L0_FIFO_FULL_ERRORS [01:01] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_FIFO_FULL_ERRORS_MASK 0x00000002
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_TX_L0_FIFO_FULL_ERRORS_SHIFT 1

/* MISC1 :: TX_DMA_ERROR_STATUS :: reserved4 [00:00] */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved4_MASK              0x00000001
#define BCHP_MISC1_TX_DMA_ERROR_STATUS_reserved4_SHIFT             0

/***************************************************************************
 *TX_DMA_LIST0_CUR_DESC_L_ADDR - Tx DMA List0 Current Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST0_CUR_DESC_L_ADDR :: TX_DMA_L0_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_L_ADDR_TX_DMA_L0_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_L_ADDR_TX_DMA_L0_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: TX_DMA_LIST0_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_L_ADDR_reserved0_MASK     0x0000001f
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_L_ADDR_reserved0_SHIFT    0

/***************************************************************************
 *TX_DMA_LIST0_CUR_DESC_U_ADDR - Tx DMA List0 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST0_CUR_DESC_U_ADDR :: TX_DMA_L0_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_U_ADDR_TX_DMA_L0_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_TX_DMA_LIST0_CUR_DESC_U_ADDR_TX_DMA_L0_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *TX_DMA_LIST0_CUR_BYTE_CNT_REM - Tx DMA List0 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST0_CUR_BYTE_CNT_REM :: reserved0 [31:24] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_reserved0_MASK    0xff000000
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_reserved0_SHIFT   24

/* MISC1 :: TX_DMA_LIST0_CUR_BYTE_CNT_REM :: TX_DMA_L0_CUR_BYTE_CNT_REM [23:02] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_TX_DMA_L0_CUR_BYTE_CNT_REM_MASK 0x00fffffc
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_TX_DMA_L0_CUR_BYTE_CNT_REM_SHIFT 2

/* MISC1 :: TX_DMA_LIST0_CUR_BYTE_CNT_REM :: reserved1 [01:00] */
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_reserved1_MASK    0x00000003
#define BCHP_MISC1_TX_DMA_LIST0_CUR_BYTE_CNT_REM_reserved1_SHIFT   0

/***************************************************************************
 *TX_DMA_LIST1_CUR_DESC_L_ADDR - Tx DMA List1 Current Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST1_CUR_DESC_L_ADDR :: TX_DMA_L1_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_L_ADDR_TX_DMA_L1_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_L_ADDR_TX_DMA_L1_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: TX_DMA_LIST1_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_L_ADDR_reserved0_MASK     0x0000001f
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_L_ADDR_reserved0_SHIFT    0

/***************************************************************************
 *TX_DMA_LIST1_CUR_DESC_U_ADDR - Tx DMA List1 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST1_CUR_DESC_U_ADDR :: TX_DMA_L1_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_U_ADDR_TX_DMA_L1_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_TX_DMA_LIST1_CUR_DESC_U_ADDR_TX_DMA_L1_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *TX_DMA_LIST1_CUR_BYTE_CNT_REM - Tx DMA List1 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: TX_DMA_LIST1_CUR_BYTE_CNT_REM :: reserved0 [31:24] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_reserved0_MASK    0xff000000
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_reserved0_SHIFT   24

/* MISC1 :: TX_DMA_LIST1_CUR_BYTE_CNT_REM :: TX_DMA_L1_CUR_BYTE_CNT_REM [23:02] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_TX_DMA_L1_CUR_BYTE_CNT_REM_MASK 0x00fffffc
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_TX_DMA_L1_CUR_BYTE_CNT_REM_SHIFT 2

/* MISC1 :: TX_DMA_LIST1_CUR_BYTE_CNT_REM :: reserved1 [01:00] */
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_reserved1_MASK    0x00000003
#define BCHP_MISC1_TX_DMA_LIST1_CUR_BYTE_CNT_REM_reserved1_SHIFT   0

/***************************************************************************
 *TX_DMA_CTRL - Tx DMA Flea Interface Control
 ***************************************************************************/
/* MISC1 :: TX_DMA_CTRL :: reserved0 [31:02] */
#define BCHP_MISC1_TX_DMA_CTRL_reserved0_MASK                      0xfffffffc
#define BCHP_MISC1_TX_DMA_CTRL_reserved0_SHIFT                     2

/* MISC1 :: TX_DMA_CTRL :: TX_DMA_FLUSH_REQUEST [01:01] */
#define BCHP_MISC1_TX_DMA_CTRL_TX_DMA_FLUSH_REQUEST_MASK           0x00000002
#define BCHP_MISC1_TX_DMA_CTRL_TX_DMA_FLUSH_REQUEST_SHIFT          1

/* MISC1 :: TX_DMA_CTRL :: TX_DMA_ENABLE [00:00] */
#define BCHP_MISC1_TX_DMA_CTRL_TX_DMA_ENABLE_MASK                  0x00000001
#define BCHP_MISC1_TX_DMA_CTRL_TX_DMA_ENABLE_SHIFT                 0

/***************************************************************************
 *TX_DMA_STATE - Tx DMA Flea Interface State
 ***************************************************************************/
/* MISC1 :: TX_DMA_STATE :: reserved0 [31:04] */
#define BCHP_MISC1_TX_DMA_STATE_reserved0_MASK                     0xfffffff0
#define BCHP_MISC1_TX_DMA_STATE_reserved0_SHIFT                    4

/* MISC1 :: TX_DMA_STATE :: TX_DMA_ERROR [03:03] */
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_ERROR_MASK                  0x00000008
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_ERROR_SHIFT                 3

/* MISC1 :: TX_DMA_STATE :: TX_DMA_FLUSH_ACTIVE [02:02] */
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_FLUSH_ACTIVE_MASK           0x00000004
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_FLUSH_ACTIVE_SHIFT          2

/* MISC1 :: TX_DMA_STATE :: TX_DMA_FIFO_ACTIVE [01:01] */
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_FIFO_ACTIVE_MASK            0x00000002
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_FIFO_ACTIVE_SHIFT           1

/* MISC1 :: TX_DMA_STATE :: TX_DMA_ACTIVE [00:00] */
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_ACTIVE_MASK                 0x00000001
#define BCHP_MISC1_TX_DMA_STATE_TX_DMA_ACTIVE_SHIFT                0

/***************************************************************************
 *Y_RX_FIRST_DESC_L_ADDR_LIST0 - Y Rx Descriptor List0 First Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST0 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_MASK     0xffffffe0
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_SHIFT    5

/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST0 :: reserved0 [04:01] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_reserved0_MASK     0x0000001e
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_reserved0_SHIFT    1

/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST0 :: RX_DESC_LIST0_VALID [00:00] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_RX_DESC_LIST0_VALID_MASK 0x00000001
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST0_RX_DESC_LIST0_VALID_SHIFT 0

/***************************************************************************
 *Y_RX_FIRST_DESC_U_ADDR_LIST0 - Y Rx Descriptor List0 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: Y_RX_FIRST_DESC_U_ADDR_LIST0 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_MASK     0xffffffff
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_SHIFT    0

/***************************************************************************
 *Y_RX_FIRST_DESC_L_ADDR_LIST1 - Y Rx Descriptor List1 First Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST1 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_MASK     0xffffffe0
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_SHIFT    5

/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST1 :: reserved0 [04:01] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_reserved0_MASK     0x0000001e
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_reserved0_SHIFT    1

/* MISC1 :: Y_RX_FIRST_DESC_L_ADDR_LIST1 :: RX_DESC_LIST1_VALID [00:00] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_RX_DESC_LIST1_VALID_MASK 0x00000001
#define BCHP_MISC1_Y_RX_FIRST_DESC_L_ADDR_LIST1_RX_DESC_LIST1_VALID_SHIFT 0

/***************************************************************************
 *Y_RX_FIRST_DESC_U_ADDR_LIST1 - Y Rx Descriptor List1 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: Y_RX_FIRST_DESC_U_ADDR_LIST1 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_MASK     0xffffffff
#define BCHP_MISC1_Y_RX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_SHIFT    0

/***************************************************************************
 *Y_RX_SW_DESC_LIST_CTRL_STS - Y Rx Software Descriptor List Control and Status
 ***************************************************************************/
/* MISC1 :: Y_RX_SW_DESC_LIST_CTRL_STS :: reserved0 [31:04] */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_reserved0_MASK       0xfffffff0
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_reserved0_SHIFT      4

/* MISC1 :: Y_RX_SW_DESC_LIST_CTRL_STS :: DMA_DATA_SERV_PTR [03:03] */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_MASK 0x00000008
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_SHIFT 3

/* MISC1 :: Y_RX_SW_DESC_LIST_CTRL_STS :: DESC_SERV_PTR [02:02] */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_MASK   0x00000004
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_SHIFT  2

/* MISC1 :: Y_RX_SW_DESC_LIST_CTRL_STS :: RX_HALT_ON_ERROR [01:01] */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_RX_HALT_ON_ERROR_MASK 0x00000002
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_RX_HALT_ON_ERROR_SHIFT 1

/* MISC1 :: Y_RX_SW_DESC_LIST_CTRL_STS :: RX_RUN_STOP [00:00] */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_RX_RUN_STOP_MASK     0x00000001
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS_RX_RUN_STOP_SHIFT    0

/***************************************************************************
 *Y_RX_ERROR_STATUS - Y Rx Engine Error Status
 ***************************************************************************/
/* MISC1 :: Y_RX_ERROR_STATUS :: reserved0 [31:14] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved0_MASK                0xffffc000
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved0_SHIFT               14

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L1_UNDERRUN_ERROR [13:13] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_UNDERRUN_ERROR_MASK     0x00002000
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_UNDERRUN_ERROR_SHIFT    13

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L1_OVERRUN_ERROR [12:12] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_OVERRUN_ERROR_MASK      0x00001000
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_OVERRUN_ERROR_SHIFT     12

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L0_UNDERRUN_ERROR [11:11] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_UNDERRUN_ERROR_MASK     0x00000800
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_UNDERRUN_ERROR_SHIFT    11

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L0_OVERRUN_ERROR [10:10] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_OVERRUN_ERROR_MASK      0x00000400
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_OVERRUN_ERROR_SHIFT     10

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L1_DESC_TX_ABORT_ERRORS [09:09] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_DESC_TX_ABORT_ERRORS_MASK 0x00000200
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_DESC_TX_ABORT_ERRORS_SHIFT 9

/* MISC1 :: Y_RX_ERROR_STATUS :: reserved1 [08:08] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved1_MASK                0x00000100
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved1_SHIFT               8

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L0_DESC_TX_ABORT_ERRORS [07:07] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_DESC_TX_ABORT_ERRORS_MASK 0x00000080
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_DESC_TX_ABORT_ERRORS_SHIFT 7

/* MISC1 :: Y_RX_ERROR_STATUS :: reserved2 [06:05] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved2_MASK                0x00000060
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved2_SHIFT               5

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L1_FIFO_FULL_ERRORS [04:04] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_FIFO_FULL_ERRORS_MASK   0x00000010
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L1_FIFO_FULL_ERRORS_SHIFT  4

/* MISC1 :: Y_RX_ERROR_STATUS :: reserved3 [03:02] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved3_MASK                0x0000000c
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved3_SHIFT               2

/* MISC1 :: Y_RX_ERROR_STATUS :: RX_L0_FIFO_FULL_ERRORS [01:01] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_FIFO_FULL_ERRORS_MASK   0x00000002
#define BCHP_MISC1_Y_RX_ERROR_STATUS_RX_L0_FIFO_FULL_ERRORS_SHIFT  1

/* MISC1 :: Y_RX_ERROR_STATUS :: reserved4 [00:00] */
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved4_MASK                0x00000001
#define BCHP_MISC1_Y_RX_ERROR_STATUS_reserved4_SHIFT               0

/***************************************************************************
 *Y_RX_LIST0_CUR_DESC_L_ADDR - Y Rx List0 Current Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST0_CUR_DESC_L_ADDR :: RX_L0_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_L_ADDR_RX_L0_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_L_ADDR_RX_L0_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: Y_RX_LIST0_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_L_ADDR_reserved0_MASK       0x0000001f
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_L_ADDR_reserved0_SHIFT      0

/***************************************************************************
 *Y_RX_LIST0_CUR_DESC_U_ADDR - Y Rx List0 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST0_CUR_DESC_U_ADDR :: RX_L0_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_U_ADDR_RX_L0_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_Y_RX_LIST0_CUR_DESC_U_ADDR_RX_L0_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *Y_RX_LIST0_CUR_BYTE_CNT - Y Rx List0 Current Descriptor Byte Count
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST0_CUR_BYTE_CNT :: RX_L0_CUR_BYTE_CNT [31:00] */
#define BCHP_MISC1_Y_RX_LIST0_CUR_BYTE_CNT_RX_L0_CUR_BYTE_CNT_MASK 0xffffffff
#define BCHP_MISC1_Y_RX_LIST0_CUR_BYTE_CNT_RX_L0_CUR_BYTE_CNT_SHIFT 0

/***************************************************************************
 *Y_RX_LIST1_CUR_DESC_L_ADDR - Y Rx List1 Current Descriptor Lower address
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST1_CUR_DESC_L_ADDR :: RX_L1_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_L_ADDR_RX_L1_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_L_ADDR_RX_L1_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: Y_RX_LIST1_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_L_ADDR_reserved0_MASK       0x0000001f
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_L_ADDR_reserved0_SHIFT      0

/***************************************************************************
 *Y_RX_LIST1_CUR_DESC_U_ADDR - Y Rx List1 Current Descriptor Upper address
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST1_CUR_DESC_U_ADDR :: RX_L1_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_U_ADDR_RX_L1_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_Y_RX_LIST1_CUR_DESC_U_ADDR_RX_L1_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *Y_RX_LIST1_CUR_BYTE_CNT - Y Rx List1 Current Descriptor Byte Count
 ***************************************************************************/
/* MISC1 :: Y_RX_LIST1_CUR_BYTE_CNT :: RX_L1_CUR_BYTE_CNT [31:00] */
#define BCHP_MISC1_Y_RX_LIST1_CUR_BYTE_CNT_RX_L1_CUR_BYTE_CNT_MASK 0xffffffff
#define BCHP_MISC1_Y_RX_LIST1_CUR_BYTE_CNT_RX_L1_CUR_BYTE_CNT_SHIFT 0

/***************************************************************************
 *HIF_RX_FIRST_DESC_L_ADDR_LIST0 - HIF Rx Descriptor List0 First Descriptor lower Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST0 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_MASK   0xffffffe0
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_DESC_ADDR_SHIFT  5

/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST0 :: reserved0 [04:01] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_reserved0_MASK   0x0000001e
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_reserved0_SHIFT  1

/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST0 :: RX_DESC_LIST0_VALID [00:00] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_RX_DESC_LIST0_VALID_MASK 0x00000001
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST0_RX_DESC_LIST0_VALID_SHIFT 0

/***************************************************************************
 *HIF_RX_FIRST_DESC_U_ADDR_LIST0 - HIF Rx Descriptor List0 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_FIRST_DESC_U_ADDR_LIST0 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_MASK   0xffffffff
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST0_DESC_ADDR_SHIFT  0

/***************************************************************************
 *HIF_RX_FIRST_DESC_L_ADDR_LIST1 - HIF Rx Descriptor List1 First Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST1 :: DESC_ADDR [31:05] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_MASK   0xffffffe0
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_DESC_ADDR_SHIFT  5

/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST1 :: reserved0 [04:01] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_reserved0_MASK   0x0000001e
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_reserved0_SHIFT  1

/* MISC1 :: HIF_RX_FIRST_DESC_L_ADDR_LIST1 :: RX_DESC_LIST1_VALID [00:00] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_RX_DESC_LIST1_VALID_MASK 0x00000001
#define BCHP_MISC1_HIF_RX_FIRST_DESC_L_ADDR_LIST1_RX_DESC_LIST1_VALID_SHIFT 0

/***************************************************************************
 *HIF_RX_FIRST_DESC_U_ADDR_LIST1 - HIF Rx Descriptor List1 First Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_FIRST_DESC_U_ADDR_LIST1 :: DESC_ADDR [31:00] */
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_MASK   0xffffffff
#define BCHP_MISC1_HIF_RX_FIRST_DESC_U_ADDR_LIST1_DESC_ADDR_SHIFT  0

/***************************************************************************
 *HIF_RX_SW_DESC_LIST_CTRL_STS - HIF Rx Software Descriptor List Control and Status
 ***************************************************************************/
/* MISC1 :: HIF_RX_SW_DESC_LIST_CTRL_STS :: reserved0 [31:04] */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_reserved0_MASK     0xfffffff0
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_reserved0_SHIFT    4

/* MISC1 :: HIF_RX_SW_DESC_LIST_CTRL_STS :: DMA_DATA_SERV_PTR [03:03] */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_MASK 0x00000008
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_DMA_DATA_SERV_PTR_SHIFT 3

/* MISC1 :: HIF_RX_SW_DESC_LIST_CTRL_STS :: DESC_SERV_PTR [02:02] */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_MASK 0x00000004
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_DESC_SERV_PTR_SHIFT 2

/* MISC1 :: HIF_RX_SW_DESC_LIST_CTRL_STS :: RX_HALT_ON_ERROR [01:01] */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_RX_HALT_ON_ERROR_MASK 0x00000002
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_RX_HALT_ON_ERROR_SHIFT 1

/* MISC1 :: HIF_RX_SW_DESC_LIST_CTRL_STS :: RX_RUN_STOP [00:00] */
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_RX_RUN_STOP_MASK   0x00000001
#define BCHP_MISC1_HIF_RX_SW_DESC_LIST_CTRL_STS_RX_RUN_STOP_SHIFT  0

/***************************************************************************
 *HIF_RX_ERROR_STATUS - HIF Rx Engine Error Status
 ***************************************************************************/
/* MISC1 :: HIF_RX_ERROR_STATUS :: reserved0 [31:14] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved0_MASK              0xffffc000
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved0_SHIFT             14

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L1_UNDERRUN_ERROR [13:13] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_UNDERRUN_ERROR_MASK   0x00002000
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_UNDERRUN_ERROR_SHIFT  13

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L1_OVERRUN_ERROR [12:12] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_OVERRUN_ERROR_MASK    0x00001000
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_OVERRUN_ERROR_SHIFT   12

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L0_UNDERRUN_ERROR [11:11] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_UNDERRUN_ERROR_MASK   0x00000800
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_UNDERRUN_ERROR_SHIFT  11

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L0_OVERRUN_ERROR [10:10] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_OVERRUN_ERROR_MASK    0x00000400
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_OVERRUN_ERROR_SHIFT   10

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L1_DESC_TX_ABORT_ERRORS [09:09] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_DESC_TX_ABORT_ERRORS_MASK 0x00000200
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_DESC_TX_ABORT_ERRORS_SHIFT 9

/* MISC1 :: HIF_RX_ERROR_STATUS :: reserved1 [08:08] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved1_MASK              0x00000100
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved1_SHIFT             8

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L0_DESC_TX_ABORT_ERRORS [07:07] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_DESC_TX_ABORT_ERRORS_MASK 0x00000080
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_DESC_TX_ABORT_ERRORS_SHIFT 7

/* MISC1 :: HIF_RX_ERROR_STATUS :: reserved2 [06:05] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved2_MASK              0x00000060
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved2_SHIFT             5

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L1_FIFO_FULL_ERRORS [04:04] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_FIFO_FULL_ERRORS_MASK 0x00000010
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L1_FIFO_FULL_ERRORS_SHIFT 4

/* MISC1 :: HIF_RX_ERROR_STATUS :: reserved3 [03:02] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved3_MASK              0x0000000c
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved3_SHIFT             2

/* MISC1 :: HIF_RX_ERROR_STATUS :: RX_L0_FIFO_FULL_ERRORS [01:01] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_FIFO_FULL_ERRORS_MASK 0x00000002
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_RX_L0_FIFO_FULL_ERRORS_SHIFT 1

/* MISC1 :: HIF_RX_ERROR_STATUS :: reserved4 [00:00] */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved4_MASK              0x00000001
#define BCHP_MISC1_HIF_RX_ERROR_STATUS_reserved4_SHIFT             0

/***************************************************************************
 *HIF_RX_LIST0_CUR_DESC_L_ADDR - HIF Rx List0 Current Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST0_CUR_DESC_L_ADDR :: RX_L0_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_L_ADDR_RX_L0_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_L_ADDR_RX_L0_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: HIF_RX_LIST0_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_L_ADDR_reserved0_MASK     0x0000001f
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_L_ADDR_reserved0_SHIFT    0

/***************************************************************************
 *HIF_RX_LIST0_CUR_DESC_U_ADDR - HIF Rx List0 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST0_CUR_DESC_U_ADDR :: RX_L0_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_U_ADDR_RX_L0_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_HIF_RX_LIST0_CUR_DESC_U_ADDR_RX_L0_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *HIF_RX_LIST0_CUR_BYTE_CNT - HIF Rx List0 Current Descriptor Byte Count
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST0_CUR_BYTE_CNT :: RX_L0_CUR_BYTE_CNT [31:00] */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_BYTE_CNT_RX_L0_CUR_BYTE_CNT_MASK 0xffffffff
#define BCHP_MISC1_HIF_RX_LIST0_CUR_BYTE_CNT_RX_L0_CUR_BYTE_CNT_SHIFT 0

/***************************************************************************
 *HIF_RX_LIST1_CUR_DESC_L_ADDR - HIF Rx List1 Current Descriptor Lower Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST1_CUR_DESC_L_ADDR :: RX_L1_CUR_DESC_L_ADDR [31:05] */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_L_ADDR_RX_L1_CUR_DESC_L_ADDR_MASK 0xffffffe0
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_L_ADDR_RX_L1_CUR_DESC_L_ADDR_SHIFT 5

/* MISC1 :: HIF_RX_LIST1_CUR_DESC_L_ADDR :: reserved0 [04:00] */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_L_ADDR_reserved0_MASK     0x0000001f
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_L_ADDR_reserved0_SHIFT    0

/***************************************************************************
 *HIF_RX_LIST1_CUR_DESC_U_ADDR - HIF Rx List1 Current Descriptor Upper Address
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST1_CUR_DESC_U_ADDR :: RX_L1_CUR_DESC_U_ADDR [31:00] */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_U_ADDR_RX_L1_CUR_DESC_U_ADDR_MASK 0xffffffff
#define BCHP_MISC1_HIF_RX_LIST1_CUR_DESC_U_ADDR_RX_L1_CUR_DESC_U_ADDR_SHIFT 0

/***************************************************************************
 *HIF_RX_LIST1_CUR_BYTE_CNT - HIF Rx List1 Current Descriptor Byte Count
 ***************************************************************************/
/* MISC1 :: HIF_RX_LIST1_CUR_BYTE_CNT :: RX_L1_CUR_BYTE_CNT [31:00] */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_BYTE_CNT_RX_L1_CUR_BYTE_CNT_MASK 0xffffffff
#define BCHP_MISC1_HIF_RX_LIST1_CUR_BYTE_CNT_RX_L1_CUR_BYTE_CNT_SHIFT 0

/***************************************************************************
 *HIF_DMA_CTRL - HIF Rx DMA Flea Interface Control
 ***************************************************************************/
/* MISC1 :: HIF_DMA_CTRL :: reserved0 [31:01] */
#define BCHP_MISC1_HIF_DMA_CTRL_reserved0_MASK                     0xfffffffe
#define BCHP_MISC1_HIF_DMA_CTRL_reserved0_SHIFT                    1

/* MISC1 :: HIF_DMA_CTRL :: RX_DMA_ENABLE [00:00] */
#define BCHP_MISC1_HIF_DMA_CTRL_RX_DMA_ENABLE_MASK                 0x00000001
#define BCHP_MISC1_HIF_DMA_CTRL_RX_DMA_ENABLE_SHIFT                0

/***************************************************************************
 *HIF_DMA_STATE - HIF Rx DMA Flea Interface State
 ***************************************************************************/
/* MISC1 :: HIF_DMA_STATE :: reserved0 [31:03] */
#define BCHP_MISC1_HIF_DMA_STATE_reserved0_MASK                    0xfffffff8
#define BCHP_MISC1_HIF_DMA_STATE_reserved0_SHIFT                   3

/* MISC1 :: HIF_DMA_STATE :: RX_DMA_ERROR [02:02] */
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_ERROR_MASK                 0x00000004
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_ERROR_SHIFT                2

/* MISC1 :: HIF_DMA_STATE :: RX_DMA_FIFO_ACTIVE [01:01] */
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_FIFO_ACTIVE_MASK           0x00000002
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_FIFO_ACTIVE_SHIFT          1

/* MISC1 :: HIF_DMA_STATE :: RX_DMA_ACTIVE [00:00] */
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_ACTIVE_MASK                0x00000001
#define BCHP_MISC1_HIF_DMA_STATE_RX_DMA_ACTIVE_SHIFT               0

/***************************************************************************
 *DMA_DEBUG_OPTIONS_REG - DMA Debug Options Register
 ***************************************************************************/
/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_TX_DMA_SOFT_RST [31:31] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_TX_DMA_SOFT_RST_MASK 0x80000000
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_TX_DMA_SOFT_RST_SHIFT 31

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_RX_DMA_SOFT_RST [30:30] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_RX_DMA_SOFT_RST_MASK 0x40000000
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_RX_DMA_SOFT_RST_SHIFT 30

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_TX_DMA_RD_Q_SOFT_RST [29:29] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_TX_DMA_RD_Q_SOFT_RST_MASK 0x20000000
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_TX_DMA_RD_Q_SOFT_RST_SHIFT 29

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_RX_DMA_WR_Q_SOFT_RST [28:28] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_RX_DMA_WR_Q_SOFT_RST_MASK 0x10000000
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_RX_DMA_WR_Q_SOFT_RST_SHIFT 28

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: RSVD_DMA_DEBUG_0 [27:05] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_0_MASK     0x0fffffe0
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_0_SHIFT    5

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_EN_RX_DMA_XFER_CNT [04:04] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_EN_RX_DMA_XFER_CNT_MASK 0x00000010
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_EN_RX_DMA_XFER_CNT_SHIFT 4

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: RSVD_DMA_DEBUG_1 [03:03] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_1_MASK     0x00000008
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_1_SHIFT    3

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_SINGLE_RD_Q [02:02] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_SINGLE_RD_Q_MASK 0x00000004
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_SINGLE_RD_Q_SHIFT 2

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: DMA_DEBUG_SINGLE_WR_Q [01:01] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_SINGLE_WR_Q_MASK 0x00000002
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_DMA_DEBUG_SINGLE_WR_Q_SHIFT 1

/* MISC1 :: DMA_DEBUG_OPTIONS_REG :: RSVD_DMA_DEBUG_2 [00:00] */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_2_MASK     0x00000001
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG_RSVD_DMA_DEBUG_2_SHIFT    0

/***************************************************************************
 *READ_CHANNEL_ERROR_STATUS - Read Channel Error Status
 ***************************************************************************/
/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_7 [31:28] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_7_MASK 0xf0000000
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_7_SHIFT 28

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_6 [27:24] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_6_MASK 0x0f000000
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_6_SHIFT 24

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_5 [23:20] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_5_MASK 0x00f00000
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_5_SHIFT 20

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_4 [19:16] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_4_MASK 0x000f0000
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_4_SHIFT 16

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_3 [15:12] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_3_MASK 0x0000f000
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_3_SHIFT 12

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_2 [11:08] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_2_MASK 0x00000f00
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_2_SHIFT 8

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_1 [07:04] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_1_MASK 0x000000f0
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_1_SHIFT 4

/* MISC1 :: READ_CHANNEL_ERROR_STATUS :: TX_ERR_STS_CHAN_0 [03:00] */
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_0_MASK 0x0000000f
#define BCHP_MISC1_READ_CHANNEL_ERROR_STATUS_TX_ERR_STS_CHAN_0_SHIFT 0

/***************************************************************************
 *PCIE_DMA_CTRL - PCIE DMA Control Register
 ***************************************************************************/
/* MISC1 :: PCIE_DMA_CTRL :: reserved0 [31:18] */
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved0_MASK                    0xfffc0000
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved0_SHIFT                   18

/* MISC1 :: PCIE_DMA_CTRL :: DESC_ENDIAN_MODE [17:16] */
#define BCHP_MISC1_PCIE_DMA_CTRL_DESC_ENDIAN_MODE_MASK             0x00030000
#define BCHP_MISC1_PCIE_DMA_CTRL_DESC_ENDIAN_MODE_SHIFT            16

/* MISC1 :: PCIE_DMA_CTRL :: reserved1 [15:09] */
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved1_MASK                    0x0000fe00
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved1_SHIFT                   9

/* MISC1 :: PCIE_DMA_CTRL :: EN_ROUND_ROBIN [08:08] */
#define BCHP_MISC1_PCIE_DMA_CTRL_EN_ROUND_ROBIN_MASK               0x00000100
#define BCHP_MISC1_PCIE_DMA_CTRL_EN_ROUND_ROBIN_SHIFT              8

/* MISC1 :: PCIE_DMA_CTRL :: reserved2 [07:05] */
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved2_MASK                    0x000000e0
#define BCHP_MISC1_PCIE_DMA_CTRL_reserved2_SHIFT                   5

/* MISC1 :: PCIE_DMA_CTRL :: RELAXED_ORDERING [04:04] */
#define BCHP_MISC1_PCIE_DMA_CTRL_RELAXED_ORDERING_MASK             0x00000010
#define BCHP_MISC1_PCIE_DMA_CTRL_RELAXED_ORDERING_SHIFT            4

/* MISC1 :: PCIE_DMA_CTRL :: NO_SNOOP [03:03] */
#define BCHP_MISC1_PCIE_DMA_CTRL_NO_SNOOP_MASK                     0x00000008
#define BCHP_MISC1_PCIE_DMA_CTRL_NO_SNOOP_SHIFT                    3

/* MISC1 :: PCIE_DMA_CTRL :: TRAFFIC_CLASS [02:00] */
#define BCHP_MISC1_PCIE_DMA_CTRL_TRAFFIC_CLASS_MASK                0x00000007
#define BCHP_MISC1_PCIE_DMA_CTRL_TRAFFIC_CLASS_SHIFT               0

/***************************************************************************
 *HIF_RXDMA_BASE_ADDR - HIF Rx DMA Base DRAM Address
 ***************************************************************************/
/* MISC1 :: HIF_RXDMA_BASE_ADDR :: BASE_ADDR [31:00] */
#define BCHP_MISC1_HIF_RXDMA_BASE_ADDR_BASE_ADDR_MASK              0xffffffff
#define BCHP_MISC1_HIF_RXDMA_BASE_ADDR_BASE_ADDR_SHIFT             0

/***************************************************************************
 *HIF_RXDMA_LENGTH - HIF Rx DMA Transfer Length
 ***************************************************************************/
/* MISC1 :: HIF_RXDMA_LENGTH :: ACTIVE [31:31] */
#define BCHP_MISC1_HIF_RXDMA_LENGTH_ACTIVE_MASK                    0x80000000
#define BCHP_MISC1_HIF_RXDMA_LENGTH_ACTIVE_SHIFT                   31

/* MISC1 :: HIF_RXDMA_LENGTH :: reserved0 [30:23] */
#define BCHP_MISC1_HIF_RXDMA_LENGTH_reserved0_MASK                 0x7f800000
#define BCHP_MISC1_HIF_RXDMA_LENGTH_reserved0_SHIFT                23

/* MISC1 :: HIF_RXDMA_LENGTH :: LENGTH [22:00] */
#define BCHP_MISC1_HIF_RXDMA_LENGTH_LENGTH_MASK                    0x007fffff
#define BCHP_MISC1_HIF_RXDMA_LENGTH_LENGTH_SHIFT                   0

#endif /* #ifndef BCHP_MISC1_H__ */

/* End of File */
