/*
 *  Copyright (C) 2010  Giorgio Wicklein <g.wicklein@giowisys.com>
 *
 *  This file is part of DaemonFS.
 *
 *  DaemonFS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DaemonFS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DaemonFS.  If not, see <http://www.gnu.org/licenses/>.
 */

//-----------------------------------------------------------------------------
// Hearders
//-----------------------------------------------------------------------------

#include <QApplication>
#include <QTranslator>
#include <QLocale>

#include "widgets/mainwindow.h"

#ifdef Q_WS_WIN
    #include "extras/qtwin.h"
#endif


//-----------------------------------------------------------------------------
// Main
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
             ":/languages");
    app.installTranslator(&qtTranslator);

    QTranslator myappTranslator;
    myappTranslator.load("daemonfs_" + QLocale::system().name(), ":/languages");
    app.installTranslator(&myappTranslator);

    MainWindow w;

    /*****************************Begin Nokia's Code******************************/
    /****************************************************************************
    **
    ** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
    **
    ** Use, modification and distribution is allowed without limitation,
    ** warranty, liability or support of any kind.
    **
    ****************************************************************************/

    #ifdef Q_WS_WIN
        if (QtWin::isCompositionEnabled()) {
            QtWin::extendFrameIntoClientArea(&w);
            w.setContentsMargins(0, 0, 0, 0);
        }
    #endif

    /*******************************End Nokia's Code******************************/


    w.show();

    return app.exec();
}
