macro( ectrans_find_cuda )
    if(NOT DEFINED CMAKE_CUDA_ARCHITECTURES)
      ecbuild_info("CMAKE_CUDA_ARCHITECTURES not defined, using 80")
      set(CMAKE_CUDA_ARCHITECTURES 80)
    endif()
    check_language(CUDA)
    if ( NOT CMAKE_CUDA_COMPILER )
      set( HAVE_CUDA OFF )
    else()
      enable_language(CUDA)
      set( HAVE_CUDA ON )
      find_package( CUDAToolkit )
      if( NOT TARGET CUDA::cublas )
        ecbuild_info("No target CUDA::cublas")
        set( HAVE_CUDA OFF )
      endif()
      if( NOT TARGET CUDA::cufft )
        ecbuild_info("No target CUDA::cufft")
        set( HAVE_CUDA OFF )
      endif()
      ecbuild_info( "cuda arch               : [${CMAKE_CUDA_ARCHITECTURES}]" )
      ecbuild_info( "cublas                  : [${CUDA_cublas_LIBRARY}]" )
      ecbuild_info( "cufft                   : [${CUDA_cufft_LIBRARY}]" )
    endif()
endmacro()
