/* DO NOT MODIFY THIS FILE AS IT IS AUTO-GENERATED */
/* IF IT IS CHANGED PLEASE COMMIT THE CHANGES */

static const char vertex_color_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform     mat4  uMatrixMvp;\n"
   "varying     vec4  vColor;\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_COLOR\n"
   "attribute   vec4  aColor0;\n"
   "#endif //VERTEX_COLOR\n"
   "#ifdef VERTEX_COLOR_BLEND\n"
   "attribute   vec4  aColor1;\n"
   "uniform     float uColorWeight;\n"
   "#endif //VERTEX_COLOR_BLEND\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_COLOR_BLEND\n"
   "   vec4 color = aColor0 * uColorWeight + aColor1 * (1.0 - uColorWeight);\n"
   "#else\n"
   "#ifdef VERTEX_COLOR\n"
   "   vec4 color = aColor0;\n"
   "#endif //VERTEX_COLOR\n"
   "#endif //VERTEX_COLOR_BLEND\n"
   "   vColor = color;\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "}\n";

static const char vertex_color_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying  vec4        vColor;\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "void main()\n"
   "{\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(vColor.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = vColor;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = vColor;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   \n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char diffuse_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform mat4  uMatrixMvp;\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "}\n";

static const char diffuse_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "#endif //TEX_COORD\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "#ifdef DIFFUSE\n"
   "uniform   vec4        uMaterialDiffuse;\n"
   "uniform   vec4        uLightDiffuse;\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "void main() {\n"
   "   vec4  color;\n"
   "   \n"
   "#ifdef  DIFFUSE_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   vec3 Tex1CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse1;\n"
   "   color = mix(texture2D(uTextureDiffuse1, vec2(Tex1CoordDiffuse)),\n"
   "               texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)), uTextureDiffuseWeight);\n"
   "   color *= uMaterialDiffuse;\n"
   "#else\n"
   "#ifdef  DIFFUSE_TEXTURE\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   color = texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)) * uMaterialDiffuse;\n"
   "#else\n"
   "   color = uMaterialDiffuse;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   \n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char flat_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform   mat4  uMatrixMvp;\n"
   "uniform   mat3  uMatrixNormal;\n"
   "uniform   mat4  uMatrixModelview;\n"
   "uniform   vec4  uLightPosition;\n"
   "varying   vec2  vFactor;\n"
   "#ifdef SHADOWED\n"
   "uniform mat4 uMatrixLight;\n"
   "varying vec4 vLightPosition;\n"
   "#endif //SHADOWED\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_NORMAL\n"
   "attribute   vec4  aNormal0;\n"
   "#endif //VERTEX_NORMAL\n"
   "#ifdef VERTEX_NORMAL_BLEND\n"
   "attribute   vec4  aNormal1;\n"
   "uniform     float uNormalWeight;\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "#ifdef LIGHT_SPOT\n"
   "uniform   vec3  uLightSpotDir;\n"
   "uniform   float uLightSpotExp;\n"
   "uniform   float uLightSpotCutoffCos;\n"
   "#endif //LIGHT_SPOT\n"
   "#ifdef SPECULAR\n"
   "uniform float   uMaterialShininess;\n"
   "#endif //SPECULAR\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "uniform   vec3  uLightAtten;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "void vertexFlat(vec4 position, vec3 normal)\n"
   "{\n"
   "   vec3  lv;\n"
   "   float factor;\n"
   "   normal = uMatrixNormal * normal;\n"
   "   position = uMatrixModelview * position;\n"
   "#ifdef NORMALIZE_NORMALS\n"
   "   normal = normalize(normal);\n"
   "#endif //NORMALIZE_NORMALS\n"
   "#ifdef LIGHT_DIRECTIONAL\n"
   "   lv = uLightPosition.xyz;\n"
   "#else\n"
   "   lv = uLightPosition.xyz - position.xyz;\n"
   "   lv = normalize(lv);\n"
   "#endif //LIGHT_DIRECTIONAL\n"
   "   factor = max(dot(lv, normal), 0.0);\n"
   "#ifdef LIGHT_SPOT\n"
   "   float f = dot(-lv, uLightSpotDir);\n"
   "   if (f > uLightSpotCutoffCos)\n"
   "     factor *= pow(f, uLightSpotExp);\n"
   "   else\n"
   "      factor = 0.0;\n"
   "#endif //LIGHT_SPOT\n"
   "   if (factor > 0.0)\n"
   "     {\n"
   "#ifdef DIFFUSE\n"
   "        vFactor.x = factor;\n"
   "#else\n"
   "        vFactor.x = 0.0;\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "        vec3  hv = normalize(normalize(-position.xyz) + lv);\n"
   "        factor = pow(max(dot(hv, normal), 0.0), uMaterialShininess);\n"
   "        vFactor.y = factor;\n"
   "#endif //SPECULAR\n"
   "     }\n"
   "   else\n"
   "     vFactor = vec2(0.0, 0.0);\n"
   "   /* Light attenuation. */\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   float dist = length(lv);\n"
   "   vFactor /= dot(uLightAtten, vec3(1.0, dist, dist * dist));\n"
   "#endif //LIGHT_ATTENUATION\n"
   "}\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   #ifdef VERTEX_NORMAL_BLEND\n"
   "   vec3 normal = mix(aNormal1.xyz, aNormal0.xyz, uNormalWeight);\n"
   "#else\n"
   "#ifdef VERTEX_NORMAL\n"
   "   vec3 normal = aNormal0.xyz;\n"
   "#endif //VERTEX_NORMAL\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "   vertexFlat(position, normal);\n"
   "   #ifdef SHADOWED\n"
   "   vLightPosition = uMatrixLight * position;\n"
   "#endif //SHADOWED\n"
   "}\n";

static const char flat_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying vec2   vFactor;\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "#endif //TEX_COORD\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "#ifdef  SHADOWED\n"
   "varying vec4 vLightPosition;\n"
   "uniform sampler2D uShadowMap;\n"
   "uniform float uShadowsPCFStep;\n"
   "uniform float uShadowsPCFSize;\n"
   "uniform float uShadowsConstantBias;\n"
   "float shadow;\n"
   "float pcf(vec4 lpos)\n"
   "{\n"
   "   vec3 smcoord = lpos.xyz / lpos.w * 0.5 + 0.5;\n"
   "   float i, j, shadow, q, c;\n"
   "   q = floor(uShadowsPCFStep * 2.0);\n"
   "   c = floor(uShadowsPCFStep * uShadowsPCFStep * 4.0);\n"
   "   shadow = 0.0;\n"
   "   const vec4 unpack = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n"
   "   for (i = -uShadowsPCFStep; i < uShadowsPCFStep; i += 1.0)\n"
   "     for (j = -uShadowsPCFStep; j < uShadowsPCFStep; j += 1.0)\n"
   "       {\n"
   "          vec4 zvalue = texture2D(uShadowMap, smcoord.xy + vec2(i / q, j / q) * uShadowsPCFSize);\n"
   "          shadow += float(smcoord.z < dot(zvalue, unpack) + uShadowsConstantBias);\n"
   "       }\n"
   "   return shadow / c;\n"
   "}\n"
   "#endif //SHADOWED\n"
   "#ifdef DIFFUSE\n"
   "uniform   vec4        uMaterialDiffuse;\n"
   "uniform   vec4        uLightDiffuse;\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "uniform   vec4     uLightSpecular;\n"
   "uniform   float    uMaterialShininess;\n"
   "uniform   vec4     uMaterialSpecular;\n"
   "#ifdef SPECULAR_TEXTURE\n"
   "uniform sampler2D  uTextureSpecular0;\n"
   "uniform mat3 uTextureMatrixTransformSpecular0;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#ifdef SPECULAR_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureSpecular1;\n"
   "uniform float      uTextureSpecularWeight;\n"
   "uniform mat3 uTextureMatrixTransformSpecular1;\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "#endif //SPECULAR\n"
   "#ifdef AMBIENT\n"
   "uniform  vec4       uMaterialAmbient;\n"
   "uniform  vec4       uLightAmbient;\n"
   "#ifdef AMBIENT_TEXTURE\n"
   "uniform sampler2D  uTextureAmbient0;\n"
   "uniform mat3 uTextureMatrixTransformAmbient0;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#ifdef AMBIENT_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureAmbient1;\n"
   "uniform float      uTextureAmbientWeight;\n"
   "uniform mat3 uTextureMatrixTransformAmbient1;\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "#endif //AMBIENT\n"
   "#ifdef EMISSION\n"
   "uniform vec4       uMaterialEmission;\n"
   "#ifdef EMISSION_TEXTURE\n"
   "uniform sampler2D  uTextureEmission0;\n"
   "uniform mat3 uTextureMatrixTransformEmission0;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#ifdef EMISSION_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureEmission1;\n"
   "uniform float      uTextureEmissionWeight;\n"
   "uniform mat3 uTextureMatrixTransformEmission1;\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "#endif //EMISSION\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "vec4 fragmentFlat()\n"
   "{\n"
   "   vec4 color;\n"
   "   vec4 fragcolor;\n"
   "#ifdef DIFFUSE\n"
   "   \n"
   "#ifdef  DIFFUSE_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   vec3 Tex1CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse1;\n"
   "   color = mix(texture2D(uTextureDiffuse1, vec2(Tex1CoordDiffuse)),\n"
   "               texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)), uTextureDiffuseWeight);\n"
   "   color *= uMaterialDiffuse;\n"
   "#else\n"
   "#ifdef  DIFFUSE_TEXTURE\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   color = texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)) * uMaterialDiffuse;\n"
   "#else\n"
   "   color = uMaterialDiffuse;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "   fragcolor = uLightDiffuse * color * vFactor.x;\n"
   "#else\n"
   "   fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "   \n"
   "#ifdef  SPECULAR_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   vec3 Tex1CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular1;\n"
   "   color = mix(texture2D(uTextureSpecular1, vec2(Tex1CoordSpecular)),\n"
   "               texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)), uTextureSpecularWeight);\n"
   "   color *= uMaterialSpecular;\n"
   "#else\n"
   "#ifdef  SPECULAR_TEXTURE\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   color = texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)) * uMaterialSpecular;\n"
   "#else\n"
   "   color = uMaterialSpecular;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "   fragcolor += uLightSpecular * color * vFactor.y;\n"
   "#endif //SPECULAR\n"
   "#ifdef SHADOWED\n"
   "   fragcolor *= shadow;\n"
   "#endif //SHADOWED\n"
   "#ifdef AMBIENT\n"
   "   \n"
   "#ifdef  AMBIENT_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   vec3 Tex1CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient1;\n"
   "   color = mix(texture2D(uTextureAmbient1, vec2(Tex1CoordAmbient)),\n"
   "               texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)), uTextureAmbientWeight);\n"
   "   color *= uMaterialAmbient;\n"
   "#else\n"
   "#ifdef  AMBIENT_TEXTURE\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   color = texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)) * uMaterialAmbient;\n"
   "#else\n"
   "   color = uMaterialAmbient;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "   fragcolor += uLightAmbient * color;\n"
   "#endif //AMBIENT\n"
   "#ifdef  EMISSION\n"
   "   \n"
   "#ifdef  EMISSION_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   vec3 Tex1CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission1;\n"
   "   color = mix(texture2D(uTextureEmission1, vec2(Tex1CoordEmission)),\n"
   "               texture2D(uTextureEmission0, vec2(Tex0CoordEmission)), uTextureEmissionWeight);\n"
   "   color *= uMaterialEmission;\n"
   "#else\n"
   "#ifdef  EMISSION_TEXTURE\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   color = texture2D(uTextureEmission0, vec2(Tex0CoordEmission)) * uMaterialEmission;\n"
   "#else\n"
   "   color = uMaterialEmission;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "   fragcolor += color;\n"
   "#endif //EMISSION\n"
   "   return fragcolor;\n"
   "}\n"
   "void main() {\n"
   "   vec4 color;\n"
   "#ifdef SHADOWED\n"
   "   shadow = pcf(vLightPosition);\n"
   "#endif //SHADOWED\n"
   "   color = fragmentFlat();\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   \n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char phong_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform  mat4  uMatrixMvp;\n"
   "uniform  mat3  uMatrixNormal;\n"
   "uniform  mat4  uMatrixModelview;\n"
   "uniform  vec4  uLightPosition;\n"
   "varying  vec3  vLightVector;\n"
   "varying  vec3  vLightHalfVector;\n"
   "varying  vec3  vNormal;\n"
   "#ifdef SHADOWED\n"
   "uniform mat4 uMatrixLight;\n"
   "varying vec4 vLightPosition;\n"
   "#endif //SHADOWED\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_NORMAL\n"
   "attribute   vec4  aNormal0;\n"
   "#endif //VERTEX_NORMAL\n"
   "#ifdef VERTEX_NORMAL_BLEND\n"
   "attribute   vec4  aNormal1;\n"
   "uniform     float uNormalWeight;\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying  float vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "void vertexPhong(vec4 position, vec3 normal)\n"
   "{\n"
   "   normal = uMatrixNormal * normal;\n"
   "   position = uMatrixModelview * position;\n"
   "#ifdef NORMALIZE_NORMALS\n"
   "   normal = normalize(normal);\n"
   "#endif //NORMALIZE_NORMALS\n"
   "#ifdef LIGHT_DIRECTIONAL\n"
   "   vLightVector = uLightPosition.xyz;\n"
   "#else\n"
   "   vLightVector = uLightPosition.xyz - position.xyz;\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   vLightDist = length(vLightVector);\n"
   "#endif //LIGHT_ATTENUATION\n"
   "   vLightVector = normalize(vLightVector);\n"
   "#endif //LIGHT_DIRECTIONAL\n"
   "   vLightHalfVector = normalize(normalize(-position.xyz) + vLightVector);\n"
   "   vNormal = normal;\n"
   "}\n"
   "void main() {\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   #ifdef VERTEX_NORMAL_BLEND\n"
   "   vec3 normal = mix(aNormal1.xyz, aNormal0.xyz, uNormalWeight);\n"
   "#else\n"
   "#ifdef VERTEX_NORMAL\n"
   "   vec3 normal = aNormal0.xyz;\n"
   "#endif //VERTEX_NORMAL\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "   vertexPhong(position, normal);\n"
   "   #ifdef SHADOWED\n"
   "   vLightPosition = uMatrixLight * position;\n"
   "#endif //SHADOWED\n"
   "}\n";

static const char phong_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying  vec3        vLightVector;\n"
   "varying  vec3        vLightHalfVector;\n"
   "varying  vec3        vNormal;\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "#endif //TEX_COORD\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "#ifdef  SHADOWED\n"
   "varying vec4 vLightPosition;\n"
   "uniform sampler2D uShadowMap;\n"
   "uniform float uShadowsPCFStep;\n"
   "uniform float uShadowsPCFSize;\n"
   "uniform float uShadowsConstantBias;\n"
   "float shadow;\n"
   "float pcf(vec4 lpos)\n"
   "{\n"
   "   vec3 smcoord = lpos.xyz / lpos.w * 0.5 + 0.5;\n"
   "   float i, j, shadow, q, c;\n"
   "   q = floor(uShadowsPCFStep * 2.0);\n"
   "   c = floor(uShadowsPCFStep * uShadowsPCFStep * 4.0);\n"
   "   shadow = 0.0;\n"
   "   const vec4 unpack = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n"
   "   for (i = -uShadowsPCFStep; i < uShadowsPCFStep; i += 1.0)\n"
   "     for (j = -uShadowsPCFStep; j < uShadowsPCFStep; j += 1.0)\n"
   "       {\n"
   "          vec4 zvalue = texture2D(uShadowMap, smcoord.xy + vec2(i / q, j / q) * uShadowsPCFSize);\n"
   "          shadow += float(smcoord.z < dot(zvalue, unpack) + uShadowsConstantBias);\n"
   "       }\n"
   "   return shadow / c;\n"
   "}\n"
   "#endif //SHADOWED\n"
   "#ifdef DIFFUSE\n"
   "uniform   vec4        uMaterialDiffuse;\n"
   "uniform   vec4        uLightDiffuse;\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "uniform   vec4     uLightSpecular;\n"
   "uniform   float    uMaterialShininess;\n"
   "uniform   vec4     uMaterialSpecular;\n"
   "#ifdef SPECULAR_TEXTURE\n"
   "uniform sampler2D  uTextureSpecular0;\n"
   "uniform mat3 uTextureMatrixTransformSpecular0;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#ifdef SPECULAR_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureSpecular1;\n"
   "uniform float      uTextureSpecularWeight;\n"
   "uniform mat3 uTextureMatrixTransformSpecular1;\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "#endif //SPECULAR\n"
   "#ifdef AMBIENT\n"
   "uniform  vec4       uMaterialAmbient;\n"
   "uniform  vec4       uLightAmbient;\n"
   "#ifdef AMBIENT_TEXTURE\n"
   "uniform sampler2D  uTextureAmbient0;\n"
   "uniform mat3 uTextureMatrixTransformAmbient0;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#ifdef AMBIENT_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureAmbient1;\n"
   "uniform float      uTextureAmbientWeight;\n"
   "uniform mat3 uTextureMatrixTransformAmbient1;\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "#endif //AMBIENT\n"
   "#ifdef EMISSION\n"
   "uniform vec4       uMaterialEmission;\n"
   "#ifdef EMISSION_TEXTURE\n"
   "uniform sampler2D  uTextureEmission0;\n"
   "uniform mat3 uTextureMatrixTransformEmission0;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#ifdef EMISSION_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureEmission1;\n"
   "uniform float      uTextureEmissionWeight;\n"
   "uniform mat3 uTextureMatrixTransformEmission1;\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "#endif //EMISSION\n"
   "#ifdef LIGHT_SPOT\n"
   "uniform   vec3  uLightSpotDir;\n"
   "uniform   float uLightSpotExp;\n"
   "uniform   float uLightSpotCutoffCos;\n"
   "#endif //LIGHT_SPOT\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying   float    vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "vec4 fragmentPhong()\n"
   "{\n"
   "   vec3  normal = normalize(vNormal);\n"
   "   vec3  lv = normalize(vLightVector);\n"
   "   float factor = dot(lv, normal);\n"
   "   vec4  color;\n"
   "   vec4 fragcolor;\n"
   "#ifdef  LIGHT_SPOT\n"
   "   float f = dot(-lv, normalize(uLightSpotDir));\n"
   "   if (f > uLightSpotCutoffCos)\n"
   "      factor *= pow(f, uLightSpotExp);\n"
   "   else\n"
   "     factor = 0.0;\n"
   "#endif //LIGHT_SPOT\n"
   "   if (factor > 0.0)\n"
   "     {\n"
   "   /* Diffuse term. */\n"
   "#ifdef  DIFFUSE\n"
   "        \n"
   "#ifdef  DIFFUSE_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   vec3 Tex1CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse1;\n"
   "   color = mix(texture2D(uTextureDiffuse1, vec2(Tex1CoordDiffuse)),\n"
   "               texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)), uTextureDiffuseWeight);\n"
   "   color *= uMaterialDiffuse;\n"
   "#else\n"
   "#ifdef  DIFFUSE_TEXTURE\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   color = texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)) * uMaterialDiffuse;\n"
   "#else\n"
   "   color = uMaterialDiffuse;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "        fragcolor = uLightDiffuse * color * factor;\n"
   "#else\n"
   "        fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#endif //DIFFUSE\n"
   "   /* Specular term. */\n"
   "#ifdef SPECULAR\n"
   "        factor = dot(normalize(vLightHalfVector), normal);\n"
   "        if (factor > 0.0)\n"
   "          {\n"
   "             factor = pow(factor, uMaterialShininess);\n"
   "             \n"
   "#ifdef  SPECULAR_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   vec3 Tex1CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular1;\n"
   "   color = mix(texture2D(uTextureSpecular1, vec2(Tex1CoordSpecular)),\n"
   "               texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)), uTextureSpecularWeight);\n"
   "   color *= uMaterialSpecular;\n"
   "#else\n"
   "#ifdef  SPECULAR_TEXTURE\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   color = texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)) * uMaterialSpecular;\n"
   "#else\n"
   "   color = uMaterialSpecular;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "             fragcolor += uLightSpecular * color * factor;\n"
   "          }\n"
   "#endif\n"
   "     }\n"
   "   else\n"
   "     fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#ifdef  SHADOWED\n"
   "   fragcolor *= shadow;\n"
   "#endif //SHADOWED\n"
   "#ifdef AMBIENT\n"
   "   \n"
   "#ifdef  AMBIENT_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   vec3 Tex1CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient1;\n"
   "   color = mix(texture2D(uTextureAmbient1, vec2(Tex1CoordAmbient)),\n"
   "               texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)), uTextureAmbientWeight);\n"
   "   color *= uMaterialAmbient;\n"
   "#else\n"
   "#ifdef  AMBIENT_TEXTURE\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   color = texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)) * uMaterialAmbient;\n"
   "#else\n"
   "   color = uMaterialAmbient;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "   fragcolor += uLightAmbient * color;\n"
   "#endif\n"
   "   /* Light attenuation. */\n"
   "#ifdef  LIGHT_ATTENUATION\n"
   "   fragcolor /= dot(uLightAtten, vec3(1.0, vLightDist, vLightDist * vLightDist));\n"
   "#endif\n"
   "   /* Emission term. */\n"
   "#ifdef  EMISSION\n"
   "   \n"
   "#ifdef  EMISSION_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   vec3 Tex1CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission1;\n"
   "   color = mix(texture2D(uTextureEmission1, vec2(Tex1CoordEmission)),\n"
   "               texture2D(uTextureEmission0, vec2(Tex0CoordEmission)), uTextureEmissionWeight);\n"
   "   color *= uMaterialEmission;\n"
   "#else\n"
   "#ifdef  EMISSION_TEXTURE\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   color = texture2D(uTextureEmission0, vec2(Tex0CoordEmission)) * uMaterialEmission;\n"
   "#else\n"
   "   color = uMaterialEmission;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "   fragcolor += color;\n"
   "#endif\n"
   "   return fragcolor;\n"
   "}\n"
   "void main()\n"
   "{\n"
   "   vec4 color;\n"
   "#ifdef SHADOWED\n"
   "   shadow = pcf(vLightPosition);\n"
   "#endif //SHADOWED\n"
   "   color = fragmentPhong();\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   \n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char normal_map_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform  mat4  uMatrixMvp;\n"
   "uniform  mat3  uMatrixNormal;\n"
   "uniform  mat4  uMatrixModelview;\n"
   "uniform  vec4  uLightPosition;\n"
   "varying  vec3  vLightVector;\n"
   "varying  vec3  vLightHalfVector;\n"
   "varying  vec3  vEyeVector;\n"
   "#ifndef VERTEX_TANGENT\n"
   "varying  vec3  vNormal;\n"
   "#endif //VERTEX_TANGENT\n"
   "#ifdef SHADOWED\n"
   "uniform mat4 uMatrixLight;\n"
   "varying vec4 vLightPosition;\n"
   "#endif //SHADOWED\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_NORMAL\n"
   "attribute   vec4  aNormal0;\n"
   "#endif //VERTEX_NORMAL\n"
   "#ifdef VERTEX_NORMAL_BLEND\n"
   "attribute   vec4  aNormal1;\n"
   "uniform     float uNormalWeight;\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TANGENT\n"
   "attribute   vec4  aTangent0;\n"
   "#endif //VERTEX_TANGENT\n"
   "#ifdef VERTEX_TANGENT_BLEND\n"
   "attribute   vec4  aTangent1;\n"
   "uniform     float uTangentWeight;\n"
   "#endif //VERTEX_TANGENT_BLEND\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying  float vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "#ifndef VERTEX_TANGENT\n"
   "void vertexNormalMap(vec4 position, vec3 normal)\n"
   "{\n"
   "   normal = uMatrixNormal * normal;\n"
   "   position = uMatrixModelview * position;\n"
   "   vEyeVector = normalize(-position.xyz);\n"
   "#ifdef NORMALIZE_NORMALS\n"
   "   normal = normalize(normal);\n"
   "#endif //NORMALIZE_NORMALS\n"
   "#ifdef LIGHT_DIRECTIONAL\n"
   "   vLightVector = uLightPosition.xyz;\n"
   "#else\n"
   "   vLightVector = uLightPosition.xyz - position.xyz;\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   vLightDist = length(vLightVector);\n"
   "#endif //LIGHT_ATTENUATION\n"
   "   vLightVector = normalize(vLightVector);\n"
   "#endif //LIGHT_DIRECTIONAL\n"
   "   vLightHalfVector = normalize(vEyeVector + vLightVector);\n"
   "   vNormal = normal;\n"
   "}\n"
   "#else\n"
   "void vertexNormalMap(vec4 position, vec3 normal, vec3 tangent)\n"
   "{\n"
   "   vec3 n = normalize(uMatrixNormal * normal);\n"
   "   vec3 t = normalize(uMatrixNormal * tangent);\n"
   "   vec3 b = cross(n, t);\n"
   "   vec3 tmp;\n"
   "   position = uMatrixModelview * position;\n"
   "#ifdef LIGHT_DIRECTIONAL\n"
   "   vec3 lightDir = uLightPosition.xyz;\n"
   "#else\n"
   "   vec3 lightDir = uLightPosition.xyz - position.xyz;\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   vLightDist = length(lightDir);\n"
   "#endif //LIGHT_ATTENUATION\n"
   "   lightDir = normalize(lightDir);\n"
   "#endif //LIGHT_DIRECTIONAL\n"
   "   tmp.x = dot(lightDir, t);\n"
   "   tmp.y = dot(lightDir, b);\n"
   "   tmp.z = dot(lightDir, n);\n"
   "   vLightVector = tmp;\n"
   "   tmp.x = dot(position.xyz, t);\n"
   "   tmp.y = dot(position.xyz, b);\n"
   "   tmp.z = dot(position.xyz, n);\n"
   "   vEyeVector = normalize(tmp);\n"
   "   vec3 hv = normalize(normalize(-position.xyz) + lightDir);\n"
   "   tmp.x = dot(hv, t);\n"
   "   tmp.y = dot(hv, b);\n"
   "   tmp.z = dot(hv, n);\n"
   "   vLightHalfVector = tmp;\n"
   "}\n"
   "#endif //VERTEX_TANGENT\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   #ifdef VERTEX_NORMAL_BLEND\n"
   "   vec3 normal = mix(aNormal1.xyz, aNormal0.xyz, uNormalWeight);\n"
   "#else\n"
   "#ifdef VERTEX_NORMAL\n"
   "   vec3 normal = aNormal0.xyz;\n"
   "#endif //VERTEX_NORMAL\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TANGENT_BLEND\n"
   "   vec3 tangent = aTangent0.xyz * uTangentWeight +\n"
   "   aTangent1.xyz * (1.0 - uTangentWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TANGENT\n"
   "   vec3 tangent = aTangent0.xyz;\n"
   "#endif //VERTEX_TANGENT\n"
   "#endif //VERTEX_TANGENT_BLEND\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "#ifdef  VERTEX_TANGENT\n"
   "   vertexNormalMap(position, normal, tangent);\n"
   "#else\n"
   "   vertexNormalMap(position, normal);\n"
   "#endif //VERTEX_TANGENT\n"
   "#ifdef SHADOWED\n"
   "   vLightPosition = uMatrixLight * position;\n"
   "#endif\n"
   "}\n";

static const char normal_map_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying  vec3        vLightVector;\n"
   "varying  vec3        vLightHalfVector;\n"
   "varying  vec3        vEyeVector;\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "#endif //TEX_COORD\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "#ifdef  SHADOWED\n"
   "varying vec4 vLightPosition;\n"
   "uniform sampler2D uShadowMap;\n"
   "uniform float uShadowsPCFStep;\n"
   "uniform float uShadowsPCFSize;\n"
   "uniform float uShadowsConstantBias;\n"
   "float shadow;\n"
   "float pcf(vec4 lpos)\n"
   "{\n"
   "   vec3 smcoord = lpos.xyz / lpos.w * 0.5 + 0.5;\n"
   "   float i, j, shadow, q, c;\n"
   "   q = floor(uShadowsPCFStep * 2.0);\n"
   "   c = floor(uShadowsPCFStep * uShadowsPCFStep * 4.0);\n"
   "   shadow = 0.0;\n"
   "   const vec4 unpack = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n"
   "   for (i = -uShadowsPCFStep; i < uShadowsPCFStep; i += 1.0)\n"
   "     for (j = -uShadowsPCFStep; j < uShadowsPCFStep; j += 1.0)\n"
   "       {\n"
   "          vec4 zvalue = texture2D(uShadowMap, smcoord.xy + vec2(i / q, j / q) * uShadowsPCFSize);\n"
   "          shadow += float(smcoord.z < dot(zvalue, unpack) + uShadowsConstantBias);\n"
   "       }\n"
   "   return shadow / c;\n"
   "}\n"
   "#endif //SHADOWED\n"
   "#ifdef NORMAL_TEXTURE\n"
   "uniform sampler2D  uTextureNormal0;\n"
   "uniform mat3 uTextureMatrixTransformNormal0;\n"
   "#endif //NORMAL_TEXTURE\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureNormal1;\n"
   "uniform float      uTextureNormalWeight;\n"
   "uniform mat3 uTextureMatrixTransformNormal1;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "#ifndef VERTEX_TANGENT\n"
   "varying  vec3        vNormal;\n"
   "#endif //VERTEX_TANGENT\n"
   "#ifdef DIFFUSE\n"
   "uniform   vec4        uMaterialDiffuse;\n"
   "uniform   vec4        uLightDiffuse;\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "uniform   vec4     uLightSpecular;\n"
   "uniform   float    uMaterialShininess;\n"
   "uniform   vec4     uMaterialSpecular;\n"
   "#ifdef SPECULAR_TEXTURE\n"
   "uniform sampler2D  uTextureSpecular0;\n"
   "uniform mat3 uTextureMatrixTransformSpecular0;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#ifdef SPECULAR_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureSpecular1;\n"
   "uniform float      uTextureSpecularWeight;\n"
   "uniform mat3 uTextureMatrixTransformSpecular1;\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "#endif //SPECULAR\n"
   "#ifdef AMBIENT\n"
   "uniform  vec4       uMaterialAmbient;\n"
   "uniform  vec4       uLightAmbient;\n"
   "#ifdef AMBIENT_TEXTURE\n"
   "uniform sampler2D  uTextureAmbient0;\n"
   "uniform mat3 uTextureMatrixTransformAmbient0;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#ifdef AMBIENT_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureAmbient1;\n"
   "uniform float      uTextureAmbientWeight;\n"
   "uniform mat3 uTextureMatrixTransformAmbient1;\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "#endif //AMBIENT\n"
   "#ifdef EMISSION\n"
   "uniform vec4       uMaterialEmission;\n"
   "#ifdef EMISSION_TEXTURE\n"
   "uniform sampler2D  uTextureEmission0;\n"
   "uniform mat3 uTextureMatrixTransformEmission0;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#ifdef EMISSION_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureEmission1;\n"
   "uniform float      uTextureEmissionWeight;\n"
   "uniform mat3 uTextureMatrixTransformEmission1;\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "#endif //EMISSION\n"
   "#ifdef LIGHT_SPOT\n"
   "uniform   vec3  uLightSpotDir;\n"
   "uniform   float uLightSpotExp;\n"
   "uniform   float uLightSpotCutoffCos;\n"
   "#endif //LIGHT_SPOT\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying   float    vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "#ifndef VERTEX_TANGENT\n"
   "mat3 cotangent_frame(vec3 n, vec3 p, vec2 uv)\n"
   "{\n"
   "   vec3 dp1 = dFdx(p);\n"
   "   vec3 dp2 = dFdy(p);\n"
   "   vec2 duv1 = dFdx(uv);\n"
   "   vec2 duv2 = dFdy(uv);\n"
   "   vec3 dp2perp = cross(dp2, n);\n"
   "   vec3 dp1perp = cross(n, dp1);\n"
   "   vec3 t = dp2perp * duv1.x + dp1perp * duv2.x;\n"
   "   vec3 b = dp2perp * duv1.y + dp1perp * duv2.y;\n"
   "   float invmax = inversesqrt(max(dot(t, t), dot(b, b)));\n"
   "   return mat3(t * invmax, b * invmax, n);\n"
   "}\n"
   "vec3 perturb_normal(vec3 normal)\n"
   "{\n"
   "   mat3 tbn = cotangent_frame(vNormal, -vEyeVector, vTexCoord);\n"
   "   return normalize(tbn * normal);\n"
   "}\n"
   "#endif //VERTEX_TANGENT\n"
   "vec4 fragmentNormalMap()\n"
   "{\n"
   "   float factor;\n"
   "   vec3  normal;\n"
   "   vec4  color;\n"
   "   vec4 fragcolor;\n"
   "   vec3 Tex0CoordNormal = vec3(vTexCoord, 1.0) * uTextureMatrixTransformNormal0;\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "   vec3 Tex1CoordNormal = vec3(vTexCoord, 1.0) * uTextureMatrixTransformNormal1;\n"
   "   normal = texture2D(uTextureNormal0, vec2(Tex0CoordNormal)).rgb * uTextureNormalWeight / texture2D(uTextureNormal0, vec2(Tex0CoordNormal)).a;\n"
   "   normal += texture2D(uTextureNormal1, vec2(Tex1CoordNormal)).rgb / texture2D(uTextureNormal1, vec2(Tex1CoordNormal)).a *\n"
   "   (1.0 - uTextureNormalWeight);\n"
   "#else\n"
   "   normal = texture2D(uTextureNormal0, vec2(Tex0CoordNormal)).rgb / texture2D(uTextureNormal0, vec2(Tex0CoordNormal)).a;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "   normal = 2.0 * normal - 1.0;\n"
   "#ifndef VERTEX_TANGENT\n"
   "   normal = perturb_normal(normal);\n"
   "#endif //VERTEX_TANGENT\n"
   "   vec3  lv = normalize(vLightVector);\n"
   "   normal = normalize(normal);\n"
   "   factor = dot(lv, normal);\n"
   "#ifdef LIGHT_SPOT\n"
   "   float f = dot(-lv, normalize(uLightSpotDir));\n"
   "   if (f > uLightSpotCutoffCos)\n"
   "     factor *= pow(f, uLightSpotExp);\n"
   "   else\n"
   "     factor = 0.0;\n"
   "#endif //LIGHT_SPOT\n"
   "   if (factor > 0.0)\n"
   "     {\n"
   "#ifdef DIFFUSE\n"
   "        \n"
   "#ifdef  DIFFUSE_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   vec3 Tex1CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse1;\n"
   "   color = mix(texture2D(uTextureDiffuse1, vec2(Tex1CoordDiffuse)),\n"
   "               texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)), uTextureDiffuseWeight);\n"
   "   color *= uMaterialDiffuse;\n"
   "#else\n"
   "#ifdef  DIFFUSE_TEXTURE\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   color = texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)) * uMaterialDiffuse;\n"
   "#else\n"
   "   color = uMaterialDiffuse;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "        fragcolor = uLightDiffuse * color * factor;\n"
   "#else\n"
   "        fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "        factor = dot(normalize(vLightHalfVector), normal);\n"
   "        if (factor > 0.0)\n"
   "          {\n"
   "             factor = pow(factor, uMaterialShininess);\n"
   "             \n"
   "#ifdef  SPECULAR_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   vec3 Tex1CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular1;\n"
   "   color = mix(texture2D(uTextureSpecular1, vec2(Tex1CoordSpecular)),\n"
   "               texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)), uTextureSpecularWeight);\n"
   "   color *= uMaterialSpecular;\n"
   "#else\n"
   "#ifdef  SPECULAR_TEXTURE\n"
   "   vec3 Tex0CoordSpecular = vec3(vTexCoord, 1.0) * uTextureMatrixTransformSpecular0;\n"
   "   color = texture2D(uTextureSpecular0, vec2(Tex0CoordSpecular)) * uMaterialSpecular;\n"
   "#else\n"
   "   color = uMaterialSpecular;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "             fragcolor += uLightSpecular * color * factor;\n"
   "          }\n"
   "#endif //SPECULAR\n"
   "#ifdef SHADOWED\n"
   "        fragcolor *= shadow;\n"
   "#endif //SHADOWED\n"
   "     }\n"
   "   else\n"
   "     fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#ifdef AMBIENT\n"
   "     \n"
   "#ifdef  AMBIENT_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   vec3 Tex1CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient1;\n"
   "   color = mix(texture2D(uTextureAmbient1, vec2(Tex1CoordAmbient)),\n"
   "               texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)), uTextureAmbientWeight);\n"
   "   color *= uMaterialAmbient;\n"
   "#else\n"
   "#ifdef  AMBIENT_TEXTURE\n"
   "   vec3 Tex0CoordAmbient = vec3(vTexCoord, 1.0) * uTextureMatrixTransformAmbient0;\n"
   "   color = texture2D(uTextureAmbient0, vec2(Tex0CoordAmbient)) * uMaterialAmbient;\n"
   "#else\n"
   "   color = uMaterialAmbient;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "     fragcolor += uLightAmbient * color;\n"
   "#endif //AMBIENT\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   fragcolor /= dot(uLightAtten, vec3(1.0, vLightDist, vLightDist * vLightDist));\n"
   "#endif //LIGHT_ATTENUATION\n"
   "#ifdef EMISSION\n"
   "   \n"
   "#ifdef  EMISSION_TEXTURE_BLEND\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   vec3 Tex1CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission1;\n"
   "   color = mix(texture2D(uTextureEmission1, vec2(Tex1CoordEmission)),\n"
   "               texture2D(uTextureEmission0, vec2(Tex0CoordEmission)), uTextureEmissionWeight);\n"
   "   color *= uMaterialEmission;\n"
   "#else\n"
   "#ifdef  EMISSION_TEXTURE\n"
   "   vec3 Tex0CoordEmission = vec3(vTexCoord, 1.0) * uTextureMatrixTransformEmission0;\n"
   "   color = texture2D(uTextureEmission0, vec2(Tex0CoordEmission)) * uMaterialEmission;\n"
   "#else\n"
   "   color = uMaterialEmission;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "   fragcolor += color;\n"
   "#endif //EMISSION\n"
   "   return fragcolor;\n"
   "}\n"
   "void main() {\n"
   "   vec4 color;\n"
   "#ifdef SHADOWED\n"
   "   shadow = pcf(vLightPosition);\n"
   "#endif //SHADOWED\n"
   "   color = fragmentNormalMap();\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char shadow_map_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform mat4  uMatrixMvp;\n"
   "varying vec4 shadowmapposition;\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "void main()\n"
   "{\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "   shadowmapposition = gl_Position;\n"
   "}\n";

static const char shadow_map_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying vec4 shadowmapposition;\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "#endif //TEX_COORD\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "#ifdef DIFFUSE\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "void main() {\n"
   "   vec4 color;\n"
   "#ifndef NEED_TEX_COORD\n"
   "   gl_FragColor = vec4(1);\n"
   "#endif\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "   vec3 Tex1CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse1;\n"
   "   color = (texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse)) *\n"
   "   uTextureDiffuseWeight + texture2D(uTextureDiffuse1, vec2(Tex1CoordDiffuse)) *\n"
   "   (1.0 - uTextureDiffuseWeight));\n"
   "#else\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "   vec3 Tex0CoordDiffuse = vec3(vTexCoord, 1.0) * uTextureMatrixTransformDiffuse0;\n"
   "   color = texture2D(uTextureDiffuse0, vec2(Tex0CoordDiffuse));\n"
   "#else\n"
   "   color = vec4(1);\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   const vec4 pack = vec4(256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);\n"
   "   const vec4 mask = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);\n"
   "   vec4 depthcolor;\n"
   "   float normdist = shadowmapposition.z / shadowmapposition.w;\n"
   "   normdist = ((normdist + 1.0) / 2.0);\n"
   "   depthcolor = vec4(fract(pack * normdist));\n"
   "   depthcolor -= depthcolor.xxyz * mask;\n"
   "   gl_FragColor = depthcolor;\n"
   "}\n";

static const char color_pick_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform mat4  uMatrixMvp;\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "}\n";

static const char color_pick_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform vec4  uColorPick;\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "void main()\n"
   "{\n"
   "   vec4 color = uColorPick;\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "}\n";

static const char parallax_occlusion_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform  mat4  uMatrixMvp;\n"
   "uniform  mat3  uMatrixNormal;\n"
   "uniform  mat4  uMatrixModelview;\n"
   "uniform  vec4  uLightPosition;\n"
   "varying  vec3  vLightVector;\n"
   "varying  vec3  vLightHalfVector;\n"
   "varying  vec3  vEyeVector;\n"
   "#ifdef SHADOWED\n"
   "uniform mat4 uMatrixLight;\n"
   "varying vec4 vLightPosition;\n"
   "#endif //SHADOWED\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "#ifdef VERTEX_NORMAL\n"
   "attribute   vec4  aNormal0;\n"
   "#endif //VERTEX_NORMAL\n"
   "#ifdef VERTEX_NORMAL_BLEND\n"
   "attribute   vec4  aNormal1;\n"
   "uniform     float uNormalWeight;\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TANGENT\n"
   "attribute   vec4  aTangent0;\n"
   "#endif //VERTEX_TANGENT\n"
   "#ifdef VERTEX_TANGENT_BLEND\n"
   "attribute   vec4  aTangent1;\n"
   "uniform     float uTangentWeight;\n"
   "#endif //VERTEX_TANGENT_BLEND\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "attribute   vec4  aTexCoord0;\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#ifdef VERTEX_TEXCOORD_BLEND\n"
   "attribute   vec4  aTexCoord1;\n"
   "uniform     float uTexCoordWeight;\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2 vTexCoord;\n"
   "#endif //NEED_TEX_COORD\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying  float vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "void vertexParallaxOcclusion(vec4 position, vec3 normal, vec3 tangent)\n"
   "{\n"
   "   vec3 n = normalize(uMatrixNormal * normal);\n"
   "   vec3 t = normalize(uMatrixNormal * tangent);\n"
   "   vec3 b = cross(n, t);\n"
   "   vec3 tmp;\n"
   "   position = uMatrixModelview * position;\n"
   "#ifdef LIGHT_DIRECTIONAL\n"
   "   vec3 lightDir = uLightPosition.xyz;\n"
   "#else\n"
   "   vec3 lightDir = uLightPosition.xyz - position.xyz;\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   vLightDist = length(lightDir);\n"
   "#endif //LIGHT_ATTENUATION\n"
   "   lightDir = normalize(lightDir);\n"
   "#endif //LIGHT_DIRECTIONAL\n"
   "   tmp.x = dot(lightDir, t);\n"
   "   tmp.y = dot(lightDir, b);\n"
   "   tmp.z = dot(lightDir, n);\n"
   "   vLightVector = tmp;\n"
   "   tmp.x = dot(position.xyz, t);\n"
   "   tmp.y = dot(position.xyz, b);\n"
   "   tmp.z = dot(position.xyz, n);\n"
   "   vEyeVector = normalize(tmp);\n"
   "   vec3 hv = normalize(normalize(-position.xyz) + lightDir);\n"
   "   tmp.x = dot(hv, t);\n"
   "   tmp.y = dot(hv, b);\n"
   "   tmp.z = dot(hv, n);\n"
   "   vLightHalfVector = tmp;\n"
   "}\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   #ifdef VERTEX_NORMAL_BLEND\n"
   "   vec3 normal = mix(aNormal1.xyz, aNormal0.xyz, uNormalWeight);\n"
   "#else\n"
   "#ifdef VERTEX_NORMAL\n"
   "   vec3 normal = aNormal0.xyz;\n"
   "#endif //VERTEX_NORMAL\n"
   "#endif //VERTEX_NORMAL_BLEND\n"
   "#ifdef VERTEX_TANGENT_BLEND\n"
   "   vec3 tangent = aTangent0.xyz * uTangentWeight +\n"
   "   aTangent1.xyz * (1.0 - uTangentWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TANGENT\n"
   "   vec3 tangent = aTangent0.xyz;\n"
   "#endif //VERTEX_TANGENT\n"
   "#endif //VERTEX_TANGENT_BLEND\n"
   "   #ifdef VERTEX_TEXCOORD_BLEND\n"
   "   vTexCoord = mix(vec2(aTexCoord1.s, 1.0 - aTexCoord1.t),\n"
   "                   vec2(aTexCoord0.s, 1.0 - aTexCoord0.t), uTexCoordWeight);\n"
   "#else\n"
   "#ifdef VERTEX_TEXCOORD\n"
   "   vTexCoord = vec2(aTexCoord0.s, 1.0 - aTexCoord0.t);\n"
   "#endif //VERTEX_TEXCOORD\n"
   "#endif //VERTEX_TEXCOORD_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "   vertexParallaxOcclusion(position, normal, tangent);\n"
   "   #ifdef SHADOWED\n"
   "   vLightPosition = uMatrixLight * position;\n"
   "#endif //SHADOWED\n"
   "}\n";

static const char parallax_occlusion_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "varying  vec3        vLightVector;\n"
   "varying  vec3        vLightHalfVector;\n"
   "varying  vec3        vEyeVector;\n"
   "uniform  sampler2D   uTextureNormal0;\n"
   "uniform  mat3        uTextureMatrixTransformNormal0;\n"
   "#ifdef NEED_TEX_COORD\n"
   "varying vec2   vTexCoord;\n"
   "vec3 Tex0CoordNormal;\n"
   "#endif //TEX_COORD\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "uniform  sampler2D  uTextureNormal1;\n"
   "uniform  float      uTextureNormalWeight;\n"
   "uniform mat3 uTextureMatrixTransformNormal1;\n"
   "vec3 Tex1CoordNormal;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "#ifdef FOG_ENABLED\n"
   "uniform float uFogFactor;\n"
   "uniform vec4  uFogColor;\n"
   "#endif //FOG_ENABLED\n"
   "#ifdef  SHADOWED\n"
   "varying vec4 vLightPosition;\n"
   "uniform sampler2D uShadowMap;\n"
   "uniform float uShadowsPCFStep;\n"
   "uniform float uShadowsPCFSize;\n"
   "uniform float uShadowsConstantBias;\n"
   "float shadow;\n"
   "float pcf(vec4 lpos)\n"
   "{\n"
   "   vec3 smcoord = lpos.xyz / lpos.w * 0.5 + 0.5;\n"
   "   float i, j, shadow, q, c;\n"
   "   q = floor(uShadowsPCFStep * 2.0);\n"
   "   c = floor(uShadowsPCFStep * uShadowsPCFStep * 4.0);\n"
   "   shadow = 0.0;\n"
   "   const vec4 unpack = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);\n"
   "   for (i = -uShadowsPCFStep; i < uShadowsPCFStep; i += 1.0)\n"
   "     for (j = -uShadowsPCFStep; j < uShadowsPCFStep; j += 1.0)\n"
   "       {\n"
   "          vec4 zvalue = texture2D(uShadowMap, smcoord.xy + vec2(i / q, j / q) * uShadowsPCFSize);\n"
   "          shadow += float(smcoord.z < dot(zvalue, unpack) + uShadowsConstantBias);\n"
   "       }\n"
   "   return shadow / c;\n"
   "}\n"
   "#endif //SHADOWED\n"
   "#ifdef DIFFUSE\n"
   "uniform   vec4        uMaterialDiffuse;\n"
   "uniform   vec4        uLightDiffuse;\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "uniform sampler2D  uTextureDiffuse0;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse0;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureDiffuse1;\n"
   "uniform float      uTextureDiffuseWeight;\n"
   "uniform mat3 uTextureMatrixTransformDiffuse1;\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "uniform   vec4     uLightSpecular;\n"
   "uniform   float    uMaterialShininess;\n"
   "uniform   vec4     uMaterialSpecular;\n"
   "#ifdef SPECULAR_TEXTURE\n"
   "uniform sampler2D  uTextureSpecular0;\n"
   "uniform mat3 uTextureMatrixTransformSpecular0;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#ifdef SPECULAR_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureSpecular1;\n"
   "uniform float      uTextureSpecularWeight;\n"
   "uniform mat3 uTextureMatrixTransformSpecular1;\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "#endif //SPECULAR\n"
   "#ifdef AMBIENT\n"
   "uniform  vec4       uMaterialAmbient;\n"
   "uniform  vec4       uLightAmbient;\n"
   "#ifdef AMBIENT_TEXTURE\n"
   "uniform sampler2D  uTextureAmbient0;\n"
   "uniform mat3 uTextureMatrixTransformAmbient0;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#ifdef AMBIENT_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureAmbient1;\n"
   "uniform float      uTextureAmbientWeight;\n"
   "uniform mat3 uTextureMatrixTransformAmbient1;\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "#endif //AMBIENT\n"
   "#ifdef EMISSION\n"
   "uniform vec4       uMaterialEmission;\n"
   "#ifdef EMISSION_TEXTURE\n"
   "uniform sampler2D  uTextureEmission0;\n"
   "uniform mat3 uTextureMatrixTransformEmission0;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#ifdef EMISSION_TEXTURE_BLEND\n"
   "uniform sampler2D  uTextureEmission1;\n"
   "uniform float      uTextureEmissionWeight;\n"
   "uniform mat3 uTextureMatrixTransformEmission1;\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "#endif //EMISSION\n"
   "#ifdef LIGHT_SPOT\n"
   "uniform   vec3  uLightSpotDir;\n"
   "uniform   float uLightSpotExp;\n"
   "uniform   float uLightSpotCutoffCos;\n"
   "#endif //LIGHT_SPOT\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "varying   float    vLightDist;\n"
   "#endif //LIGHT_ATTENUATION\n"
   "uniform int   uAlphaTestComparison;\n"
   "uniform float uAlphaTestRefValue;\n"
   "const float parallaxScale = 0.2;\n"
   "vec2 parallaxMapping(in vec3 view, in vec2 tex, out float parallaxHeight)\n"
   "{\n"
   "   const float numLayers = 15.0;\n"
   "   vec2 texStep = parallaxScale * view.xy / view.z / numLayers;\n"
   "   float layerHeight = 1.0 / numLayers;\n"
   "   float curLayerHeight = 0.0;\n"
   "   vec2 dtex = parallaxScale * view.xy / view.z / numLayers;\n"
   "   vec2 currentTextureCoords = tex;\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "   float heightFromTexture = (1.0 - texture2D(uTextureNormal0, vec2(Tex0CoordNormal)).a) * uTextureNormalWeight;\n"
   "   heightFromTexture += (1.0 - texture2D(uTextureNormal1, vec2(Tex1CoordNormal)).a) *\n"
   "   (1.0 - uTextureNormalWeight);\n"
   "#else\n"
   "   float heightFromTexture = 1.0 - texture2D(uTextureNormal0, currentTextureCoords).a;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "   while(heightFromTexture > curLayerHeight)\n"
   "   {\n"
   "      curLayerHeight += layerHeight;\n"
   "      currentTextureCoords -= dtex;\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "      heightFromTexture = (1.0 - texture2D(uTextureNormal0, currentTextureCoords).a) * uTextureNormalWeight;\n"
   "      heightFromTexture += (1.0 - texture2D(uTextureNormal1, currentTextureCoords).a) *\n"
   "      (1.0 - uTextureNormalWeight);\n"
   "#else\n"
   "      heightFromTexture = 1.0 - texture2D(uTextureNormal0, currentTextureCoords).a;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "   }\n"
   "   vec2 prevTCoords = currentTextureCoords + texStep;\n"
   "   float nextH = heightFromTexture - curLayerHeight;\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "   float prevH = (1.0 - texture2D(uTextureNormal0, prevTCoords).a\n"
   "                           - curLayerHeight + layerHeight) * uTextureNormalWeight;\n"
   "   prevH += (1.0 - texture2D(uTextureNormal1, prevTCoords).a\n"
   "                           - curLayerHeight + layerHeight) * (1.0 - uTextureNormalWeight);\n"
   "#else\n"
   "   float prevH = 1.0 - texture2D(uTextureNormal0, prevTCoords).a\n"
   "                           - curLayerHeight + layerHeight;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "   float weight = nextH / (nextH - prevH);\n"
   "   vec2 finalTexCoords = prevTCoords * weight + currentTextureCoords * (1.0-weight);\n"
   "   parallaxHeight = curLayerHeight + prevH * weight + nextH * (1.0 - weight);\n"
   "   return finalTexCoords;\n"
   "}\n"
   "vec4 fragmentParallaxMap()\n"
   "{\n"
   "   float factor;\n"
   "   vec3  normal;\n"
   "   vec4  color;\n"
   "   vec4 fragcolor;\n"
   "   float parallaxHeight;\n"
   "   vec2 tex = parallaxMapping(vEyeVector, vec2(Tex0CoordNormal), parallaxHeight);\n"
   "   vec3  lv = normalize(vLightVector);\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "   normal = texture2D(uTextureNormal0, tex).rgb * uTextureNormalWeight / texture2D(uTextureNormal0, tex).a;\n"
   "   normal += texture2D(uTextureNormal1, tex).rgb *\n"
   "   (1.0 - uTextureNormalWeight) / texture2D(uTextureNormal1, tex).a;\n"
   "#else\n"
   "   normal = texture2D(uTextureNormal0, tex).rgb / texture2D(uTextureNormal0, tex).a;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "   normal = 2.0 * normal - 1.0;\n"
   "   normal = normalize(normal);\n"
   "   factor = dot(lv, normal);\n"
   "#ifdef LIGHT_SPOT\n"
   "   float f = dot(-lv, normalize(uLightSpotDir));\n"
   "   if (f > uLightSpotCutoffCos)\n"
   "     factor *= pow(f, uLightSpotExp);\n"
   "   else\n"
   "     factor = 0.0;\n"
   "#endif //LIGHT_SPOT\n"
   "   if (factor > 0.0)\n"
   "     {\n"
   "#ifdef DIFFUSE\n"
   "#ifdef DIFFUSE_TEXTURE_BLEND\n"
   "        color = texture2D(uTextureDiffuse0, tex) * uTextureDiffuseWeight +\n"
   "        texture2D(uTextureDiffuse1, tex) * (1.0 - uTextureDiffuseWeight);\n"
   "#else\n"
   "#ifdef DIFFUSE_TEXTURE\n"
   "        color = texture2D(uTextureDiffuse0, tex);\n"
   "#else\n"
   "        color = uMaterialDiffuse;\n"
   "#endif //DIFFUSE_TEXTURE\n"
   "#endif //DIFFUSE_TEXTURE_BLEND\n"
   "        fragcolor = uLightDiffuse * color * factor;\n"
   "#else\n"
   "        fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#endif //DIFFUSE\n"
   "#ifdef SPECULAR\n"
   "        factor = dot(normalize(vLightHalfVector), normal);\n"
   "        if (factor > 0.0)\n"
   "          {\n"
   "             factor = pow(factor, uMaterialShininess);\n"
   "#ifdef SPECULAR_TEXTURE_BLEND\n"
   "             color = texture2D(uTextureSpecular0, tex) * uTextureSpecularWeight +\n"
   "             texture2D(uTextureSpecular1, tex) * (1.0 - uTextureSpecularWeight);\n"
   "#else\n"
   "#ifdef SPECULAR_TEXTURE\n"
   "             color = texture2D(uTextureSpecular0, tex);\n"
   "#else\n"
   "             color = uMaterialSpecular;\n"
   "#endif //SPECULAR_TEXTURE\n"
   "#endif //SPECULAR_TEXTURE_BLEND\n"
   "             fragcolor += uLightSpecular * color * factor;\n"
   "          }\n"
   "#endif //SPECULAR\n"
   "#ifdef SHADOWED\n"
   "        fragcolor *= shadow;\n"
   "#endif //SHADOWED\n"
   "     }\n"
   "   else\n"
   "     fragcolor = vec4(0.0, 0.0, 0.0, 0.0);\n"
   "#ifdef AMBIENT\n"
   "#ifdef AMBIENT_TEXTURE_BLEND\n"
   "   color = texture2D(uTextureAmbient0, tex) * uTextureAmbientWeight +\n"
   "   texture2D(uTextureAmbient1, tex) * (1.0 - uTextureAmbientWeight);\n"
   "#else\n"
   "#ifdef AMBIENT_TEXTURE\n"
   "   color = texture2D(uTextureAmbient0, tex);\n"
   "#else\n"
   "   color = uMaterialAmbient;\n"
   "#endif //AMBIENT_TEXTURE\n"
   "#endif //AMBIENT_TEXTURE_BLEND\n"
   "   fragcolor += uLightAmbient * color;\n"
   "#endif //AMBIENT\n"
   "#ifdef LIGHT_ATTENUATION\n"
   "   fragcolor /= dot(uLightAtten, vec3(1.0, vLightDist, vLightDist * vLightDist));\n"
   "#endif //LIGHT_ATTENUATION\n"
   "#ifdef EMISSION\n"
   "#ifdef EMISSION_TEXTURE_BLEND\n"
   "   color = texture2D(uTextureEmission0, tex) * uTextureEmissionWeight +\n"
   "   texture2D(uTextureEmission1, tex) * (1.0 - uTextureEmissionWeight);\n"
   "#else\n"
   "#ifdef EMISSION_TEXTURE\n"
   "   color = texture2D(uTextureEmission0, tex);\n"
   "#else\n"
   "   color = uMaterialEmission;\n"
   "#endif //EMISSION_TEXTURE\n"
   "#endif //EMISSION_TEXTURE_BLEND\n"
   "   fragcolor += color;\n"
   "#endif //EMISSION\n"
   "   return fragcolor;\n"
   "}\n"
   "void main() {\n"
   "   vec4 color;\n"
   "#ifdef NEED_TEX_COORD\n"
   "   Tex0CoordNormal = vec3(vTexCoord, 1.0) * uTextureMatrixTransformNormal0;\n"
   "#endif // NEED_TEX_COORD\n"
   "#ifdef NORMAL_TEXTURE_BLEND\n"
   "   Tex1CoordNormal = vec3(vTexCoord, 1.0) * uTextureMatrixTransformNormal1;\n"
   "#endif //NORMAL_TEXTURE_BLEND\n"
   "#ifdef SHADOWED\n"
   "   shadow = pcf(vLightPosition);\n"
   "#endif //SHADOWED\n"
   "   color = fragmentParallaxMap();\n"
   "#ifdef ALPHA_TEST_ENABLED\n"
   "   /*uAlphaTestComparison is value of the Evas_3D_Comparison type*/\n"
   "   const float p = 1000000.0;\n"
   "   float acolor = floor(color.a * p);\n"
   "   float refvalue = floor(uAlphaTestRefValue * p);\n"
   "   if (uAlphaTestComparison == 0) discard;\n"
   "   else if (uAlphaTestComparison == 1)\n"
   "     {\n"
   "        if (acolor < refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 2)\n"
   "     {\n"
   "        if (acolor == refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 3)\n"
   "     {\n"
   "        if (acolor <= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 4)\n"
   "     {\n"
   "        if (acolor > refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 5)\n"
   "     {\n"
   "        if (acolor != refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 6)\n"
   "     {\n"
   "        if (acolor >= refvalue) gl_FragColor = color;\n"
   "        else discard;\n"
   "     }\n"
   "   else if (uAlphaTestComparison == 7) ;\n"
   "#else\n"
   "   gl_FragColor = color;\n"
   "#endif //ALPHA_TEST_ENABLED\n"
   "   \n"
   "#ifdef FOG_ENABLED\n"
   "   float z = gl_FragCoord.z / gl_FragCoord.w;\n"
   "   float fogFactor = exp2(-uFogFactor * uFogFactor * z * z * 1.44);\n"
   "   fogFactor = clamp(fogFactor, 0.0, 1.0);\n"
   "   gl_FragColor = mix(uFogColor, gl_FragColor, fogFactor);\n"
   "#endif //FOG_ENABLED\n"
   "}\n";

static const char post_processing_fxaa_vert_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "uniform mat4  uMatrixMvp;\n"
   "#ifdef VERTEX_POSITION\n"
   "attribute   vec4  aPosition0;\n"
   "#endif //VERTEX_POSITION\n"
   "#ifdef VERTEX_POSITION_BLEND\n"
   "attribute   vec4  aPosition1;\n"
   "uniform     float uPositionWeight;\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "varying vec2 tc0;\n"
   "void main()\n"
   "{\n"
   "   #ifdef VERTEX_POSITION_BLEND\n"
   "   vec4 position = mix(aPosition1, aPosition0, uPositionWeight);\n"
   "   position = vec4(position.xyz, 1.0);\n"
   "#else\n"
   "#ifdef VERTEX_POSITION\n"
   "   vec4 position = vec4(aPosition0.xyz, 1.0);\n"
   "#endif // VERTEX_POSITION\n"
   "#endif //VERTEX_POSITION_BLEND\n"
   "   gl_Position = uMatrixMvp * position;\n"
   "   tc0 = position.xy * 0.5 + 0.5;\n"
   "}\n";

static const char post_processing_fxaa_frag_glsl[] =
   "#ifdef GL_ES\n"
   "precision mediump float;\n"
   "precision mediump int;\n"
   "precision lowp sampler2D;\n"
   "#endif\n"
   "//FXAA fragment shader by Timothy Lottes\n"
   "//http://developer.download.nvidia.com/assets/gamedev/files/sdk/11/FXAA_WhitePaper.pdf\n"
   "//modified and adapted to www.enlightenment.org by Oleksander Shcherbina\n"
   "uniform sampler2D uColorTexture;\n"
   "uniform float uFrameSizeH;\n"
   "uniform float uFrameSizeW;\n"
   "varying vec2 tc0;\n"
   "vec4 fxaa()\n"
   "{\n"
   "   float _SPAN_MAX_ = 8.0;\n"
   "   float _REDUCE_MUL_ = (1.0/8.0);\n"
   "   float _REDUCE_MIN_ = (1.0/128.0);\n"
   "   vec4 l = vec4(0.299, 0.587, 0.114, 0.0);\n"
   "   vec2 frameBufSize = vec2(uFrameSizeW, uFrameSizeH);\n"
   "   vec2 direction;\n"
   "   vec4 colorNW = texture2D(uColorTexture, tc0 + (vec2(-1.0, -1.0)/frameBufSize));\n"
   "   vec4 colorNE = texture2D(uColorTexture, tc0 + (vec2(1.0, -1.0)/frameBufSize));\n"
   "   vec4 colorSW = texture2D(uColorTexture, tc0 + (vec2(-1.0, 1.0)/frameBufSize));\n"
   "   vec4 colorSE = texture2D(uColorTexture, tc0 + (vec2(1.0, 1.0)/frameBufSize));\n"
   "   vec4 colorM = texture2D(uColorTexture,tc0);\n"
   "   float lNW = dot(colorNW, l);\n"
   "   float lNE = dot(colorNE, l);\n"
   "   float lSW = dot(colorSW, l);\n"
   "   float lSE = dot(colorSE, l);\n"
   "   float lM  = dot(colorM,  l);\n"
   "   float lMin = min(lM, min(min(lNW, lNE), min(lSW, lSE)));\n"
   "   float lMax = max(lM, max(max(lNW, lNE), max(lSW, lSE)));\n"
   "   direction.x = -((lNW + lNE) - (lSW + lSE));\n"
   "   direction.y = ((lNW + lSW) - (lNE + lSE));\n"
   "   float directionReduce = max(\n"
   "          (lNW + lNE + lSW + lSE) * (0.25 * _REDUCE_MUL_),\n"
   "          _REDUCE_MIN_);\n"
   "   float rcpDirMin = 1.0/(min(abs(direction.x), abs(direction.y)) + directionReduce);\n"
   "   direction = min(vec2(_SPAN_MAX_,  _SPAN_MAX_),\n"
   "             max(vec2(-_SPAN_MAX_, -_SPAN_MAX_),\n"
   "             direction * rcpDirMin)) / frameBufSize;\n"
   "   vec4 colorA = 0.5 * (\n"
   "          texture2D(uColorTexture, tc0.xy + direction * (1.0/3.0 - 0.5)) +\n"
   "          texture2D(uColorTexture, tc0.xy + direction * (2.0/3.0 - 0.5)));\n"
   "   vec4 colorB = colorA * 0.5 + 0.25 * (\n"
   "          texture2D(uColorTexture, tc0.xy + direction * (- 0.5)) +\n"
   "          texture2D(uColorTexture, tc0.xy + direction * 0.5));\n"
   "   float lB = dot(colorB, l);\n"
   "   if((lB < lMin) || (lB > lMax))\n"
   "     return colorA;\n"
   "   else\n"
   "     return colorB;\n"
   "}\n"
   "void main()\n"
   "{\n"
   "   gl_FragColor = fxaa();\n"
   "}\n";

static const char *vertex_shaders[] =
{
    vertex_color_vert_glsl,
    diffuse_vert_glsl,
    flat_vert_glsl,
    phong_vert_glsl,
    normal_map_vert_glsl,
    shadow_map_vert_glsl,
    color_pick_vert_glsl,
    parallax_occlusion_vert_glsl,
    post_processing_fxaa_vert_glsl,
};

static const char *fragment_shaders[] =
{
    vertex_color_frag_glsl,
    diffuse_frag_glsl,
    flat_frag_glsl,
    phong_frag_glsl,
    normal_map_frag_glsl,
    shadow_map_frag_glsl,
    color_pick_frag_glsl,
    parallax_occlusion_frag_glsl,
    post_processing_fxaa_frag_glsl,
};
