#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import time

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        self.last_time = time.time()

    def shutdown(self):
        pass

    def get_description(self):
        return "No description found"

    def run(self):
        play_sound = False
        device_list = self.env["runtime"][
            "InputManager"
        ].get_last_detected_devices()
        try:
            for deviceEntry in device_list:
                # dont play sounds for virtual devices
                play_sound = play_sound or not deviceEntry["virtual"]
        except Exception as e:
            play_sound = True
        if play_sound:
            if time.time() - self.last_time > 5:
                self.env["runtime"]["OutputManager"].play_sound_icon(
                    sound_icon="accept", interrupt=True
                )
                last_time = time.time()

    def set_callback(self, callback):
        pass
