/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1BinaryDataSection {
    private static final float UNDEFINED = -9999.0f;
    private int length;
    private int bitBuf = 0;
    private int bitPos = 0;
    private float[] values;
    private boolean isConstant = false;

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale, Grib1BitMapSection bms) throws IOException, NotSupportedException {
        this(raf, decimalscale, bms, 64, -1);
    }

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale, Grib1BitMapSection bms, int scanMode, int Xlength) throws IOException, NotSupportedException {
        this(raf, decimalscale, bms, scanMode, Xlength, -1);
    }

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale, Grib1BitMapSection bms, int scanMode, int Xlength, int Ylength) throws IOException, NotSupportedException {
        this.length = GribNumbers.uint3(raf);
        int unusedbits = raf.read();
        if ((unusedbits & 0xC0) != 0) {
            throw new NotSupportedException("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing ");
        }
        unusedbits &= 0xF;
        int binscale = GribNumbers.int2(raf);
        float refvalue = GribNumbers.float4(raf);
        int numbits = raf.read();
        if (numbits == 0) {
            this.isConstant = true;
        }
        float ref = (float)(Math.pow(10.0, -decimalscale) * (double)refvalue);
        float scale = (float)(Math.pow(10.0, -decimalscale) * Math.pow(2.0, binscale));
        if (bms != null) {
            boolean[] bitmap = bms.getBitmap();
            this.values = new float[bitmap.length];
            for (int i = 0; i < bitmap.length; ++i) {
                if (bitmap[i]) {
                    if (!this.isConstant) {
                        this.values[i] = ref + scale * (float)this.bits2UInt(numbits, raf);
                        continue;
                    }
                    this.values[i] = ref;
                    continue;
                }
                this.values[i] = -9999.0f;
            }
            this.scanningModeCheck(scanMode, Xlength);
        } else if (!this.isConstant) {
            this.values = Xlength != -1 && Ylength != -1 ? new float[Xlength * Ylength] : new float[((this.length - 11) * 8 - unusedbits) / numbits];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ref + scale * (float)this.bits2UInt(numbits, raf);
            }
            this.scanningModeCheck(scanMode, Xlength);
        } else {
            if (Xlength != -1 && Ylength != -1) {
                this.values = new float[Xlength * Ylength];
            } else {
                short x = 0;
                short y = 0;
                raf.seek(raf.getFilePointer() - 53L);
                this.length = GribNumbers.uint3(raf);
                if (this.length == 42) {
                    raf.skipBytes(3);
                    x = raf.readShort();
                    y = raf.readShort();
                } else {
                    raf.skipBytes(7);
                    this.length = GribNumbers.uint3(raf);
                    if (this.length == 32) {
                        raf.skipBytes(3);
                        x = raf.readShort();
                        y = raf.readShort();
                    } else {
                        y = 1;
                        x = 1;
                        System.out.println("Grib1BinaryDataSection constant value, can't determine array size");
                    }
                }
                this.values = new float[x * y];
            }
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ref;
            }
        }
    }

    private void scanningModeCheck(int scanMode, int Xlength) {
        if (Xlength == -1) {
            return;
        }
        if (scanMode == 0 || scanMode == 64) {
            return;
        }
        if (scanMode == 128 || scanMode == 192) {
            int mid = Xlength / 2;
            for (int index = 0; index < this.values.length; index += Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = this.values[index + idx];
                    this.values[index + idx] = this.values[index + Xlength - idx - 1];
                    this.values[index + Xlength - idx - 1] = tmp;
                }
            }
            return;
        }
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public final float[] getValues() {
        return this.values;
    }
}

