/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Integer1DSet;
import visad.IntegerSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class Integer2DSet
extends Linear2DSet
implements IntegerSet {
    public Integer2DSet(MathType type, Integer1DSet[] sets) throws VisADException {
        this(type, sets, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer2DSet(int length1, int length2) throws VisADException {
        this((MathType)RealTupleType.Generic2D, Integer2DSet.get_integer1d_array(RealTupleType.Generic2D, length1, length2, null), (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer2DSet(MathType type, int length1, int length2) throws VisADException {
        this(type, Integer2DSet.get_integer1d_array(type, length1, length2, null), (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer2DSet(MathType type, Integer1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, sets, coord_sys, units, errors);
    }

    public Integer2DSet(MathType type, int length1, int length2, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Integer2DSet.get_integer1d_array(type, length1, length2, units), coord_sys, units, errors);
    }

    private static Integer1DSet[] get_integer1d_array(MathType type, int length1, int length2, Unit[] units) throws VisADException {
        type = Set.adjustType(type);
        Integer1DSet[] sets = new Integer1DSet[2];
        RealType[] types = new RealType[1];
        Unit[] us = new Unit[]{null};
        types[0] = (RealType)((SetType)type).getDomain().getComponent(0);
        SetType set_type = new SetType(new RealTupleType(types));
        if (units != null && units.length > 0) {
            us[0] = units[0];
        }
        sets[0] = new Integer1DSet(set_type, length1, null, us, null);
        types[0] = (RealType)((SetType)type).getDomain().getComponent(1);
        set_type = new SetType(new RealTupleType(types));
        if (units != null && units.length > 1) {
            us[0] = units[1];
        }
        sets[1] = new Integer1DSet(set_type, length2, null, us, null);
        return sets;
    }

    public Object cloneButType(MathType type) throws VisADException {
        Integer1DSet[] sets = new Integer1DSet[]{(Integer1DSet)this.X.clone(), (Integer1DSet)this.Y.clone()};
        return new Integer2DSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "Integer2DSet: Length = " + this.Length + "\n";
        s = s + pre + "  Dimension 1: Length = " + this.X.getLength() + "\n";
        s = s + pre + "  Dimension 2: Length = " + this.Y.getLength() + "\n";
        return s;
    }
}

