/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file ab_speedfon.c
 * \brief SpeedFon addressbook plugin
 */

#include <ffgtk.h>
#include <sys/stat.h>

extern const gchar *getProfilesDir( void );

#define VALID_NUMBER( x ) ( ( x != NULL ) && ( strlen( x ) > 0 ) )

/** Swap first/last name */
static gboolean speedfonGetSwap( void ) {
	return prefsGetBool( getActiveProfile(), "/plugins/speedfon/swap" );
}

/** Swap first/last name */
static void speedfonSetSwap( gboolean bSwap ) {
	prefsSetBool( getActiveProfile(), "/plugins/speedfon/swap", bSwap );
}
		
/**
 * \brief Read book list
 * \return error code
 */
static int speedfonReadBook( void ) {
	struct sUrlHandler *psHandler;
	gchar anUrl[ 1024 ];
	gint nError = -1;
	struct sProfile *psProfile = getActiveProfile();
	gint nStart = 0;
	gint nEnd = -1;

	if ( routerLogin( psProfile ) == -1 ) {
		return -1;
	}

	snprintf( anUrl, sizeof( anUrl ), "%s%s/cgi-bin/webcm?getpage=../html/hcti_telefon_kuwa.htm", /*getRouterProtocol( psProfile )*/"http://", routerGetHost( psProfile ) );
	psHandler = urlHandler( anUrl, /*getRouterPort( psProfile )*/80);
	nError = readUrl( psHandler, psProfile );

	if ( nError == 0 ) {
		gchar *pnName = NULL;
		gchar *pnNumber = NULL;
		gchar *pnTmp = NULL;
		int nCount = 0;

		saveDebugData( "speedport_kuwa.html", psHandler -> pnData, psHandler -> nSize );

		while ( nStart != -1 ) {
			nStart = findString( psHandler -> pnData, nStart, "Kurzwahl: " );
			Debug( KERN_DEBUG, "nStart: %d\n", nStart );
			if ( nStart == -1 ) {
				break;
			}
			nStart = findString( psHandler -> pnData, nStart, ">" );
			Debug( KERN_DEBUG, "nStart: %d\n", nStart );
			if ( nStart == -1 ) {
				break;
			}
			nEnd = findString( psHandler -> pnData, nStart + 1, "<" );
			if ( nEnd == -1 ) {
				break;
			}

			pnName = getSubString( psHandler -> pnData, nStart + 1, nEnd - nStart - 1 );
			if ( pnName == NULL ) {
				nStart++;
				continue;
			}

			nStart = findString( psHandler -> pnData, nStart, "colLast" );
			Debug( KERN_DEBUG, "nStart: %d\n", nStart );
			if ( nStart == -1 ) {
				break;
			}
			nStart = findString( psHandler -> pnData, nStart, ">" );
			Debug( KERN_DEBUG, "nStart: %d\n", nStart );
			if ( nStart == -1 ) {
				break;
			}
			nEnd = findString( psHandler -> pnData, nStart + 1, "<" );
			if ( nEnd == -1 ) {
				break;
			}

			pnNumber = getSubString( psHandler -> pnData, nStart + 1, nEnd - nStart - 1 );
			if ( pnNumber == NULL ) {
				g_free( pnName );
				nStart++;
				continue;
			}

			if ( pnName != NULL && pnNumber != NULL ) {
				/* Create person hash table, fill structure and add them to internal list */
				GHashTable *psTable = g_hash_table_new( NULL, NULL );
				gchar *pnFirstName;
				gchar *pnLastName;
				gchar *pnId = g_strdup_printf( "%d", nCount );
				gchar *pnRealName = convertEntities( pnName );

				Debug( KERN_DEBUG, "pnName: '%s' = '%s'\n", pnRealName, pnNumber );

				pnTmp = strchr( pnRealName, ' ' );
				if ( pnTmp != NULL ) {
					gint nLen = 0;
					pnLastName = strrchr( pnRealName, ' ' ) + 1;
					nLen = strlen( pnRealName ) - strlen( pnLastName ) - 1;
					pnFirstName = g_malloc0( nLen + 1 );
					strncpy( pnFirstName, pnRealName, nLen );
					pnFirstName[ nLen ] = '\0';
				} else {
					pnFirstName = NULL;
					pnLastName = pnRealName;
				}

				AddInfo( psTable, PERSON_ID, pnId );
				if ( speedfonGetSwap() == FALSE ) {
					AddInfo( psTable, PERSON_FIRST_NAME, pnFirstName );
					AddInfo( psTable, PERSON_LAST_NAME, pnLastName );
				} else {
					AddInfo( psTable, PERSON_FIRST_NAME, pnLastName );
					AddInfo( psTable, PERSON_LAST_NAME, pnFirstName );
				}
				AddInfo( psTable, PERSON_DISPLAY_NAME, pnRealName );
				AddInfo( psTable, PERSON_PRIVATE_PHONE, pnNumber );

				Debug( KERN_DEBUG, "AddPerson() %s\n", pnId );
				AddPerson( psTable, FALSE );
				g_free( pnId );

				g_hash_table_destroy( psTable );

				g_free( pnName );
				//g_free( pnNumber );
				//g_free( pnRealName );
				nCount++;
			}
		}
	}

	freeHandler( psHandler );

	routerLogout( psProfile );
		
	return 0;
}

/**
 * \brief Write ebook list
 * \return error code
 */
static int speedfonWriteBook( void ) {
	/*struct sUrlHandler *psHandler;
	gchar anBuffer[ 1024 ];
	gint nError = -1;*/

	if ( routerLogin( getActiveProfile() ) == -1 ) {
		return -1;
	}

	routerLogout( getActiveProfile() );

	return 0;
}

void prefsAddNone( struct sProfile *psProfile, const char *pnName );

/**
 * \brief Display speedfon preferences window
 */
static void speedfonPreferences( void ) {
	GtkWidget *psDialog = gtk_dialog_new_with_buttons( _( "SpeedFon Preferences" ), NULL, 0, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL );
	GtkWidget *psCheckBox = gtk_check_button_new_with_label( _( "Swap first/lastname" ) );
	GtkWidget *psBox;

	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( psCheckBox ), speedfonGetSwap() );

	psBox = gtk_dialog_get_content_area( GTK_DIALOG( psDialog ) );
	gtk_box_pack_start( GTK_BOX( psBox ), psCheckBox, FALSE, TRUE, 15 );

	gtk_widget_set_size_request( psDialog, 300, 80 );
	gtk_widget_show( GTK_WIDGET( psCheckBox ) );
	gtk_dialog_run( GTK_DIALOG( psDialog ) );

	prefsAddNone( getActiveProfile(), "/plugins/speedfon" );

	speedfonSetSwap( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( psCheckBox ) ) );
	gtk_widget_destroy( psDialog );
	SavePreferences( getActiveProfile() );

	freePersons();
	speedfonReadBook();
}

/** book definition */
static struct sAddressBook sSpeedFon = {
	speedfonReadBook,
	speedfonWriteBook,
	PERSON_FIRST_NAME | PERSON_LAST_NAME | PERSON_DISPLAY_NAME |
	PERSON_PRIVATE_PHONE,
	0,
	/*PERSON_FIRST_NAME | PERSON_LAST_NAME | PERSON_DISPLAY_NAME |
	PERSON_PRIVATE_PHONE | PERSON_PRIVATE_MOBILE |
	PERSON_BUSINESS_PHONE,*/
	speedfonPreferences
};

MODULE_INIT( PLUGIN_TYPE_BOOK, _( "SpeedFon Addressbook" ), &sSpeedFon, NULL, NULL );
