/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.awt.VCodeLayout;
import friendless.games.filler.ChoosePlayerList;
import friendless.games.filler.MainPanel;
import friendless.games.filler.PlayerWrapper;
import friendless.games.filler.PlayerWrappers;
import friendless.games.filler.TournamentRules;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class EditTournamentPanel
extends JPanel {
    private JRadioButton robin;
    private JRadioButton knock;
    private JRadioButton basho;
    private JRadioButton challenge;
    private JCheckBox continuous;
    private ButtonGroup ruleGroup;
    private ChoosePlayerList playerList;
    private PlayerWrappers players;
    private ResourceBundle resources;
    private JButton playTournament;
    private JTextArea description;
    private JTextArea tournDesc;
    private MainPanel mainPanel;
    private SetTournamentDescriptionListener std = new SetTournamentDescriptionListener();

    public EditTournamentPanel(PlayerWrappers playerWrappers, ResourceBundle resourceBundle, MainPanel mainPanel) {
        this.resources = resourceBundle;
        this.players = playerWrappers;
        playerWrappers.sortByRatings();
        this.mainPanel = mainPanel;
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridLayout(1, 3));
        JPanel jPanel = new JPanel(new VCodeLayout("f", 4));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new VCodeLayout("l", 4));
        jPanel2.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("filler.label.tournrules")));
        this.ruleGroup = new ButtonGroup();
        this.robin = new JRadioButton(resourceBundle.getString("filler.label.roundrobin"));
        jPanel2.add("", this.robin);
        this.ruleGroup.add(this.robin);
        this.robin.setSelected(true);
        this.robin.addActionListener(this.std);
        this.knock = new JRadioButton(resourceBundle.getString("filler.label.knockout"));
        jPanel2.add("", this.knock);
        this.ruleGroup.add(this.knock);
        this.knock.addActionListener(this.std);
        this.basho = new JRadioButton(resourceBundle.getString("filler.label.basho"));
        jPanel2.add("", this.basho);
        this.ruleGroup.add(this.basho);
        this.basho.addActionListener(this.std);
        this.challenge = new JRadioButton(resourceBundle.getString("filler.label.challenge"));
        jPanel2.add("", this.challenge);
        this.ruleGroup.add(this.challenge);
        this.challenge.addActionListener(this.std);
        jPanel.add("", jPanel2);
        this.continuous = new JCheckBox(resourceBundle.getString("filler.label.continuous"));
        jPanel.add(this.continuous);
        this.tournDesc = new JTextArea("");
        jPanel.add("x", this.tournDesc);
        this.tournDesc.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("filler.label.description")));
        this.tournDesc.setEditable(false);
        this.tournDesc.setLineWrap(true);
        this.tournDesc.setWrapStyleWord(true);
        this.tournDesc.setToolTipText(resourceBundle.getString("filler.string.tourndescription"));
        this.tournDesc.setBackground(this.getBackground());
        this.playerList = new ChoosePlayerList(playerWrappers, 2);
        JScrollPane jScrollPane = new JScrollPane(this.playerList);
        this.add(jScrollPane);
        this.playerList.setToolTipText(resourceBundle.getString("filler.string.choose2edit"));
        this.playerList.setBackground(this.getBackground());
        this.playerList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JList jList = (JList)listSelectionEvent.getSource();
                int n = jList.getAnchorSelectionIndex();
                PlayerWrapper playerWrapper = (PlayerWrapper)jList.getModel().getElementAt(n);
                Object[] objectArray = new Object[]{playerWrapper.getName()};
                String string = MessageFormat.format(playerWrapper.getDescription(), objectArray);
                EditTournamentPanel.this.description.setText(string);
            }
        });
        jScrollPane.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("filler.label.players")));
        jPanel = new JPanel(new VCodeLayout("", 4));
        this.add(jPanel);
        this.description = new JTextArea();
        jPanel.add("x", this.description);
        this.description.setEditable(false);
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setToolTipText(resourceBundle.getString("filler.string.playerdescription"));
        this.description.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("filler.label.description")));
        this.description.setBackground(this.getBackground());
        jPanel.add("x", new JPanel());
        this.playTournament = new JButton(resourceBundle.getString("filler.label.playtournament"));
        jPanel.add("", this.playTournament);
        this.playTournament.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditTournamentPanel.this.mainPanel.playTournament(EditTournamentPanel.this.getRules(), EditTournamentPanel.this.getSelectedPlayers());
            }
        });
        this.setTournamentDescription("roundrobin");
    }

    PlayerWrappers getSelectedPlayers() {
        return this.players.getSelected();
    }

    TournamentRules getRules() {
        TournamentRules tournamentRules = null;
        if (this.robin.isSelected()) {
            tournamentRules = new TournamentRules(0);
        } else if (this.knock.isSelected()) {
            tournamentRules = new TournamentRules(1);
        } else if (this.basho.isSelected()) {
            tournamentRules = new TournamentRules(2);
            tournamentRules.bashoRounds = this.players.size() * 3 / 8;
        } else if (this.challenge.isSelected()) {
            tournamentRules = new TournamentRules(3);
        }
        tournamentRules.setContinuous(this.continuous.isSelected());
        return tournamentRules;
    }

    void setTournamentDescription(String string) {
        try {
            String string2 = this.resources.getString("description." + string);
            this.tournDesc.setText(string2);
        }
        catch (MissingResourceException missingResourceException) {
            this.tournDesc.setText("");
        }
    }

    class SetTournamentDescriptionListener
    implements ActionListener {
        SetTournamentDescriptionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = null;
            if (object == EditTournamentPanel.this.basho) {
                string = "basho";
            } else if (object == EditTournamentPanel.this.knock) {
                string = "knockout";
            } else if (object == EditTournamentPanel.this.challenge) {
                string = "challenge";
            } else if (object == EditTournamentPanel.this.robin) {
                string = "roundrobin";
            }
            EditTournamentPanel.this.setTournamentDescription(string);
        }
    }
}

