/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * Time Zone Redirection
 *
 * Copyright 2012 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <winpr/crt.h>

#include "liblocale.h"

#include <freerdp/utils/time.h>

#include <freerdp/locale/timezone.h>

/* Time Zone Redirection table generated with TimeZones.cs script */


struct _SYSTEM_TIME_ENTRY
{
	UINT16 wYear;
	UINT16 wMonth;
	UINT16 wDayOfWeek;
	UINT16 wDay;
	UINT16 wHour;
	UINT16 wMinute;
	UINT16 wSecond;
	UINT16 wMilliseconds;
};
typedef struct _SYSTEM_TIME_ENTRY SYSTEM_TIME_ENTRY;

struct _TIME_ZONE_RULE_ENTRY
{
	UINT64 TicksStart;
	UINT64 TicksEnd;
	INT32 DaylightDelta;
	SYSTEM_TIME_ENTRY StandardDate;
	SYSTEM_TIME_ENTRY DaylightDate;
};
typedef struct _TIME_ZONE_RULE_ENTRY TIME_ZONE_RULE_ENTRY;

struct _TIME_ZONE_ENTRY
{
	const char* Id;
	UINT32 Bias;
	BOOL SupportsDST;
	const char* DisplayName;
	const char* StandardName;
	const char* DaylightName;
	TIME_ZONE_RULE_ENTRY* RuleTable;
	UINT32 RuleTableCount;
};
typedef struct _TIME_ZONE_ENTRY TIME_ZONE_ENTRY;

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_3[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_4[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_5[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_7[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_8[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_10[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_11[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_14[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_15[] =
{
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_17[] =
{
	{ 633662964000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_18[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_19[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 2, 0, 1, 2, 0 }, { 0, 11, 0, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 2, 0, 1, 0, 0 }, { 0, 10, 0, 1, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 2, 0, 1, 0, 0 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638712180000000000ULL, 638396820000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639027540000000000ULL, 638713044000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639342900000000000ULL, 639028404000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639658260000000000ULL, 639343764000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639974484000000000ULL, 639659124000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640289844000000000ULL, 639975348000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640605204000000000ULL, 640290708000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640920564000000000ULL, 640606068000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641236788000000000ULL, 640921428000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641552148000000000ULL, 641237652000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641867508000000000ULL, 641553012000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642182868000000000ULL, 641868372000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642499092000000000ULL, 642183732000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642814452000000000ULL, 642499956000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643129812000000000ULL, 642815316000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643445172000000000ULL, 643130676000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 643446036000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_21[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 5, 6, 1, 23, 59 }, { 0, 8, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 634609908000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_22[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 0, 1 }, { 0, 4, 0, 1, 0, 1 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 1, 0, 1 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 1, 0, 1 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 1, 0, 1 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 1, 0, 1 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 0, 1 }, },
	{ 3155378292000000000ULL, 634609908000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_23[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 2, 0, 1, 2, 0 }, { 0, 11, 0, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 2, 0, 1, 0, 0 }, { 0, 10, 0, 1, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 2, 0, 1, 0, 0 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638712180000000000ULL, 638396820000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639027540000000000ULL, 638713044000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639342900000000000ULL, 639028404000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639658260000000000ULL, 639343764000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639974484000000000ULL, 639659124000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640289844000000000ULL, 639975348000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640605204000000000ULL, 640290708000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640920564000000000ULL, 640606068000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641236788000000000ULL, 640921428000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641552148000000000ULL, 641237652000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641867508000000000ULL, 641553012000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642182868000000000ULL, 641868372000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642499092000000000ULL, 642183732000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642814452000000000ULL, 642499956000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643129812000000000ULL, 642815316000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643445172000000000ULL, 643130676000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 643446036000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_24[] =
{
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 1, 1, 1, 0, 0 }, { 0, 12, 0, 1, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 0, 1, 0, 0 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_26[] =
{
	{ 633662964000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 10, 6, 1, 23, 0 }, { 0, 3, 6, 1, 22, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_27[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 1, 2, 0 }, { 0, 9, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 1, 2, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_28[] =
{
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 638712180000000000ULL, 638396820000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639027540000000000ULL, 638713044000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639342900000000000ULL, 639028404000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639658260000000000ULL, 639343764000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 639974484000000000ULL, 639659124000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640289844000000000ULL, 639975348000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640605204000000000ULL, 640290708000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 640920564000000000ULL, 640606068000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641236788000000000ULL, 640921428000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641552148000000000ULL, 641237652000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 641867508000000000ULL, 641553012000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642182868000000000ULL, 641868372000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642499092000000000ULL, 642183732000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 642814452000000000ULL, 642499956000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643129812000000000ULL, 642815316000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 643445172000000000ULL, 643130676000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 643446036000000000ULL, 60, { 0, 2, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_30[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_31[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_33[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 8, 0, 1, 23, 59 }, { 0, 5, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 8, 4, 1, 23, 59 }, { 0, 5, 0, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 8, 6, 1, 23, 59 }, { 0, 5, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 7, 6, 1, 23, 59 }, { 0, 4, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_35[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 0, 1, 1, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_37[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_38[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_39[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_40[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_42[] =
{
	{ 634293684000000000ULL, 180000000000ULL, -60, { 0, 9, 0, 1, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 634294548000000000ULL, 60, { 0, 4, 0, 1, 2, 0 }, { 0, 9, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_43[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 9, 5, 1, 1, 0 }, { 0, 3, 4, 1, 0, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 10, 5, 1, 1, 0 }, { 0, 3, 4, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_44[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 3, 0, 1, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_45[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 0, 0 }, { 0, 3, 0, 1, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_46[] =
{
	{ 632716020000000000ULL, 180000000000ULL, 60, { 0, 9, 4, 1, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 9, 4, 1, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 9, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 8, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 8, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 9, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_47[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 9, 3, 1, 23, 59 }, { 0, 3, 5, 1, 23, 59 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 11, 4, 1, 23, 59 }, { 0, 3, 4, 1, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 5, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 3, 4, 1, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 3, 4, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 3, 4, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 636188436000000000ULL, 60, { 0, 10, 4, 1, 23, 59 }, { 0, 4, 4, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_49[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 3, 0, 1, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_50[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 3, 0, 1, 3, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 3, 1, 1, 3, 0 }, },
	{ 3155378292000000000ULL, 634609908000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 3, 0, 1, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_51[] =
{
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 9, 0, 1, 2, 0 }, { 0, 3, 5, 1, 2, 0 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_52[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_53[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 4, 0, 1, 3, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 10, 1, 1, 4, 0 }, { 0, 4, 0, 1, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_54[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_57[] =
{
	{ 632716020000000000ULL, 180000000000ULL, 60, { 0, 9, 2, 1, 2, 0 }, { 0, 3, 0, 1, 2, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 9, 6, 1, 23, 59 }, { 0, 3, 4, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 633663828000000000ULL, 60, { 0, 9, 1, 1, 23, 59 }, { 0, 3, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_59[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 5, 0 }, { 0, 3, 0, 1, 4, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_60[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_61[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 1, 2, 1, 0, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 0, 1, 2, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_63[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_65[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 5, 1, 23, 59 }, { 0, 5, 6, 1, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 6, 1, 23, 59 }, { 0, 4, 2, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_71[] =
{
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 12, 4, 1, 23, 59 }, { 0, 6, 5, 1, 23, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_72[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_75[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_77[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_79[] =
{
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 1, 0, 1, 0, 0 }, { 0, 12, 0, 1, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_82[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_85[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_88[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_90[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_91[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_93[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_94[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 9, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 9, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_96[] =
{
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 11, 0, 1, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 1, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 634926132000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_97[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_98[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 1, 3, 0 }, { 0, 3, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_100[] =
{
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 1, 5, 1, 0, 0 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 634294548000000000ULL, 60, { 0, 4, 0, 1, 1, 0 }, { 0, 9, 0, 1, 0, 0 }, }
};

static const TIME_ZONE_ENTRY TimeZoneTable[] =
{
	{
		"Dateline Standard Time", 720, FALSE, "(UTC-12:00) International Date Line West",
		"Dateline Standard Time", "Dateline Daylight Time",
		NULL, 0
	},
	{
		"UTC-11", 780, FALSE, "(UTC-11:00) Coordinated Universal Time-11",
		"UTC-11", "UTC-11",
		NULL, 0
	},
	{
		"Hawaiian Standard Time", 840, FALSE, "(UTC-10:00) Hawaii",
		"Hawaiian Standard Time", "Hawaiian Daylight Time",
		NULL, 0
	},
	{
		"Alaskan Standard Time", 900, TRUE, "(UTC-09:00) Alaska",
		"Alaskan Standard Time", "Alaskan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_3, 2
	},
	{
		"Pacific Standard Time (Mexico)", 960, TRUE, "(UTC-08:00) Baja California",
		"Pacific Standard Time (Mexico)", "Pacific Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_4, 1
	},
	{
		"Pacific Standard Time", 960, TRUE, "(UTC-08:00) Pacific Time (US & Canada)",
		"Pacific Standard Time", "Pacific Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_5, 2
	},
	{
		"US Mountain Standard Time", 1020, FALSE, "(UTC-07:00) Arizona",
		"US Mountain Standard Time", "US Mountain Daylight Time",
		NULL, 0
	},
	{
		"Mountain Standard Time (Mexico)", 1020, TRUE, "(UTC-07:00) Chihuahua, La Paz, Mazatlan",
		"Mountain Standard Time (Mexico)", "Mountain Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_7, 1
	},
	{
		"Mountain Standard Time", 1020, TRUE, "(UTC-07:00) Mountain Time (US & Canada)",
		"Mountain Standard Time", "Mountain Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_8, 2
	},
	{
		"Central America Standard Time", 1080, FALSE, "(UTC-06:00) Central America",
		"Central America Standard Time", "Central America Daylight Time",
		NULL, 0
	},
	{
		"Central Standard Time", 1080, TRUE, "(UTC-06:00) Central Time (US & Canada)",
		"Central Standard Time", "Central Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_10, 2
	},
	{
		"Central Standard Time (Mexico)", 1080, TRUE, "(UTC-06:00) Guadalajara, Mexico City, Monterrey",
		"Central Standard Time (Mexico)", "Central Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_11, 1
	},
	{
		"Canada Central Standard Time", 1080, FALSE, "(UTC-06:00) Saskatchewan",
		"Canada Central Standard Time", "Canada Central Daylight Time",
		NULL, 0
	},
	{
		"SA Pacific Standard Time", 1140, FALSE, "(UTC-05:00) Bogota, Lima, Quito",
		"SA Pacific Standard Time", "SA Pacific Daylight Time",
		NULL, 0
	},
	{
		"Eastern Standard Time", 1140, TRUE, "(UTC-05:00) Eastern Time (US & Canada)",
		"Eastern Standard Time", "Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_14, 2
	},
	{
		"US Eastern Standard Time", 1140, TRUE, "(UTC-05:00) Indiana (East)",
		"US Eastern Standard Time", "US Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_15, 2
	},
	{
		"Venezuela Standard Time", 1170, FALSE, "(UTC-04:30) Caracas",
		"Venezuela Standard Time", "Venezuela Daylight Time",
		NULL, 0
	},
	{
		"Paraguay Standard Time", 1200, TRUE, "(UTC-04:00) Asuncion",
		"Paraguay Standard Time", "Paraguay Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_17, 14
	},
	{
		"Atlantic Standard Time", 1200, TRUE, "(UTC-04:00) Atlantic Time (Canada)",
		"Atlantic Standard Time", "Atlantic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_18, 2
	},
	{
		"Central Brazilian Standard Time", 1200, TRUE, "(UTC-04:00) Cuiaba",
		"Central Brazilian Standard Time", "Central Brazilian Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_19, 35
	},
	{
		"SA Western Standard Time", 1200, FALSE, "(UTC-04:00) Georgetown, La Paz, Manaus, San Juan",
		"SA Western Standard Time", "SA Western Daylight Time",
		NULL, 0
	},
	{
		"Pacific SA Standard Time", 1200, TRUE, "(UTC-04:00) Santiago",
		"Pacific SA Standard Time", "Pacific SA Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_21, 6
	},
	{
		"Newfoundland Standard Time", 1230, TRUE, "(UTC-03:30) Newfoundland",
		"Newfoundland Standard Time", "Newfoundland Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_22, 7
	},
	{
		"E. South America Standard Time", 1260, TRUE, "(UTC-03:00) Brasilia",
		"E. South America Standard Time", "E. South America Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_23, 35
	},
	{
		"Argentina Standard Time", 1260, TRUE, "(UTC-03:00) Buenos Aires",
		"Argentina Standard Time", "Argentina Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_24, 3
	},
	{
		"SA Eastern Standard Time", 1260, FALSE, "(UTC-03:00) Cayenne, Fortaleza",
		"SA Eastern Standard Time", "SA Eastern Daylight Time",
		NULL, 0
	},
	{
		"Greenland Standard Time", 1260, TRUE, "(UTC-03:00) Greenland",
		"Greenland Standard Time", "Greenland Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_26, 14
	},
	{
		"Montevideo Standard Time", 1260, TRUE, "(UTC-03:00) Montevideo",
		"Montevideo Standard Time", "Montevideo Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_27, 2
	},
	{
		"Bahia Standard Time", 1260, TRUE, "(UTC-03:00) Salvador",
		"Bahia Standard Time", "Bahia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_28, 30
	},
	{
		"UTC-02", 1320, FALSE, "(UTC-02:00) Coordinated Universal Time-02",
		"UTC-02", "UTC-02",
		NULL, 0
	},
	{
		"Mid-Atlantic Standard Time", 1320, TRUE, "(UTC-02:00) Mid-Atlantic",
		"Mid-Atlantic Standard Time", "Mid-Atlantic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_30, 1
	},
	{
		"Azores Standard Time", 1380, TRUE, "(UTC-01:00) Azores",
		"Azores Standard Time", "Azores Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_31, 1
	},
	{
		"Cape Verde Standard Time", 1380, FALSE, "(UTC-01:00) Cape Verde Is.",
		"Cape Verde Standard Time", "Cape Verde Daylight Time",
		NULL, 0
	},
	{
		"Morocco Standard Time", 0, TRUE, "(UTC) Casablanca",
		"Morocco Standard Time", "Morocco Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_33, 4
	},
	{
		"UTC", 0, FALSE, "(UTC) Coordinated Universal Time",
		"Coordinated Universal Time", "Coordinated Universal Time",
		NULL, 0
	},
	{
		"GMT Standard Time", 0, TRUE, "(UTC) Dublin, Edinburgh, Lisbon, London",
		"GMT Standard Time", "GMT Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_35, 1
	},
	{
		"Greenwich Standard Time", 0, FALSE, "(UTC) Monrovia, Reykjavik",
		"Greenwich Standard Time", "Greenwich Daylight Time",
		NULL, 0
	},
	{
		"W. Europe Standard Time", 60, TRUE, "(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
		"W. Europe Standard Time", "W. Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_37, 1
	},
	{
		"Central Europe Standard Time", 60, TRUE, "(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
		"Central Europe Standard Time", "Central Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_38, 1
	},
	{
		"Romance Standard Time", 60, TRUE, "(UTC+01:00) Brussels, Copenhagen, Madrid, Paris",
		"Romance Standard Time", "Romance Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_39, 1
	},
	{
		"Central European Standard Time", 60, TRUE, "(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb",
		"Central European Standard Time", "Central European Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_40, 1
	},
	{
		"W. Central Africa Standard Time", 60, FALSE, "(UTC+01:00) West Central Africa",
		"W. Central Africa Standard Time", "W. Central Africa Daylight Time",
		NULL, 0
	},
	{
		"Namibia Standard Time", 60, TRUE, "(UTC+01:00) Windhoek",
		"Namibia Standard Time", "Namibia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_42, 2
	},
	{
		"Jordan Standard Time", 120, TRUE, "(UTC+02:00) Amman",
		"Jordan Standard Time", "Jordan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_43, 2
	},
	{
		"GTB Standard Time", 120, TRUE, "(UTC+02:00) Athens, Bucharest, Istanbul",
		"GTB Standard Time", "GTB Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_44, 1
	},
	{
		"Middle East Standard Time", 120, TRUE, "(UTC+02:00) Beirut",
		"Middle East Standard Time", "Middle East Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_45, 13
	},
	{
		"Egypt Standard Time", 120, TRUE, "(UTC+02:00) Cairo",
		"Egypt Standard Time", "Egypt Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_46, 6
	},
	{
		"Syria Standard Time", 120, TRUE, "(UTC+02:00) Damascus",
		"Syria Standard Time", "Syria Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_47, 12
	},
	{
		"South Africa Standard Time", 120, FALSE, "(UTC+02:00) Harare, Pretoria",
		"South Africa Standard Time", "South Africa Daylight Time",
		NULL, 0
	},
	{
		"FLE Standard Time", 120, TRUE, "(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
		"FLE Standard Time", "FLE Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_49, 1
	},
	{
		"Turkey Standard Time", 120, TRUE, "(UTC+02:00) Istanbul",
		"Turkey Standard Time", "Turkey Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_50, 3
	},
	{
		"Israel Standard Time", 120, TRUE, "(UTC+02:00) Jerusalem",
		"Jerusalem Standard Time", "Jerusalem Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_51, 18
	},
	{
		"E. Europe Standard Time", 120, TRUE, "(UTC+02:00) Nicosia",
		"E. Europe Standard Time", "E. Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_52, 1
	},
	{
		"Arabic Standard Time", 180, TRUE, "(UTC+03:00) Baghdad",
		"Arabic Standard Time", "Arabic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_53, 2
	},
	{
		"Kaliningrad Standard Time", 180, TRUE, "(UTC+03:00) Kaliningrad, Minsk",
		"Kaliningrad Standard Time", "Kaliningrad Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_54, 1
	},
	{
		"Arab Standard Time", 180, FALSE, "(UTC+03:00) Kuwait, Riyadh",
		"Arab Standard Time", "Arab Daylight Time",
		NULL, 0
	},
	{
		"E. Africa Standard Time", 180, FALSE, "(UTC+03:00) Nairobi",
		"E. Africa Standard Time", "E. Africa Daylight Time",
		NULL, 0
	},
	{
		"Iran Standard Time", 210, TRUE, "(UTC+03:30) Tehran",
		"Iran Standard Time", "Iran Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_57, 3
	},
	{
		"Arabian Standard Time", 240, FALSE, "(UTC+04:00) Abu Dhabi, Muscat",
		"Arabian Standard Time", "Arabian Daylight Time",
		NULL, 0
	},
	{
		"Azerbaijan Standard Time", 240, TRUE, "(UTC+04:00) Baku",
		"Azerbaijan Standard Time", "Azerbaijan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_59, 1
	},
	{
		"Russian Standard Time", 240, TRUE, "(UTC+04:00) Moscow, St. Petersburg, Volgograd",
		"Russian Standard Time", "Russian Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_60, 1
	},
	{
		"Mauritius Standard Time", 240, TRUE, "(UTC+04:00) Port Louis",
		"Mauritius Standard Time", "Mauritius Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_61, 2
	},
	{
		"Georgian Standard Time", 240, FALSE, "(UTC+04:00) Tbilisi",
		"Georgian Standard Time", "Georgian Daylight Time",
		NULL, 0
	},
	{
		"Caucasus Standard Time", 240, TRUE, "(UTC+04:00) Yerevan",
		"Caucasus Standard Time", "Caucasus Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_63, 1
	},
	{
		"Afghanistan Standard Time", 270, FALSE, "(UTC+04:30) Kabul",
		"Afghanistan Standard Time", "Afghanistan Daylight Time",
		NULL, 0
	},
	{
		"Pakistan Standard Time", 300, TRUE, "(UTC+05:00) Islamabad, Karachi",
		"Pakistan Standard Time", "Pakistan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_65, 2
	},
	{
		"West Asia Standard Time", 300, FALSE, "(UTC+05:00) Tashkent",
		"West Asia Standard Time", "West Asia Daylight Time",
		NULL, 0
	},
	{
		"India Standard Time", 330, FALSE, "(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi",
		"India Standard Time", "India Daylight Time",
		NULL, 0
	},
	{
		"Sri Lanka Standard Time", 330, FALSE, "(UTC+05:30) Sri Jayawardenepura",
		"Sri Lanka Standard Time", "Sri Lanka Daylight Time",
		NULL, 0
	},
	{
		"Nepal Standard Time", 345, FALSE, "(UTC+05:45) Kathmandu",
		"Nepal Standard Time", "Nepal Daylight Time",
		NULL, 0
	},
	{
		"Central Asia Standard Time", 360, FALSE, "(UTC+06:00) Astana",
		"Central Asia Standard Time", "Central Asia Daylight Time",
		NULL, 0
	},
	{
		"Bangladesh Standard Time", 360, TRUE, "(UTC+06:00) Dhaka",
		"Bangladesh Standard Time", "Bangladesh Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_71, 1
	},
	{
		"Ekaterinburg Standard Time", 360, TRUE, "(UTC+06:00) Ekaterinburg",
		"Ekaterinburg Standard Time", "Ekaterinburg Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_72, 1
	},
	{
		"Myanmar Standard Time", 390, FALSE, "(UTC+06:30) Yangon (Rangoon)",
		"Myanmar Standard Time", "Myanmar Daylight Time",
		NULL, 0
	},
	{
		"SE Asia Standard Time", 420, FALSE, "(UTC+07:00) Bangkok, Hanoi, Jakarta",
		"SE Asia Standard Time", "SE Asia Daylight Time",
		NULL, 0
	},
	{
		"N. Central Asia Standard Time", 420, TRUE, "(UTC+07:00) Novosibirsk",
		"N. Central Asia Standard Time", "N. Central Asia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_75, 1
	},
	{
		"China Standard Time", 480, FALSE, "(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
		"China Standard Time", "China Daylight Time",
		NULL, 0
	},
	{
		"North Asia Standard Time", 480, TRUE, "(UTC+08:00) Krasnoyarsk",
		"North Asia Standard Time", "North Asia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_77, 1
	},
	{
		"Singapore Standard Time", 480, FALSE, "(UTC+08:00) Kuala Lumpur, Singapore",
		"Malay Peninsula Standard Time", "Malay Peninsula Daylight Time",
		NULL, 0
	},
	{
		"W. Australia Standard Time", 480, TRUE, "(UTC+08:00) Perth",
		"W. Australia Standard Time", "W. Australia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_79, 4
	},
	{
		"Taipei Standard Time", 480, FALSE, "(UTC+08:00) Taipei",
		"Taipei Standard Time", "Taipei Daylight Time",
		NULL, 0
	},
	{
		"Ulaanbaatar Standard Time", 480, FALSE, "(UTC+08:00) Ulaanbaatar",
		"Ulaanbaatar Standard Time", "Ulaanbaatar Daylight Time",
		NULL, 0
	},
	{
		"North Asia East Standard Time", 540, TRUE, "(UTC+09:00) Irkutsk",
		"North Asia East Standard Time", "North Asia East Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_82, 1
	},
	{
		"Tokyo Standard Time", 540, FALSE, "(UTC+09:00) Osaka, Sapporo, Tokyo",
		"Tokyo Standard Time", "Tokyo Daylight Time",
		NULL, 0
	},
	{
		"Korea Standard Time", 540, FALSE, "(UTC+09:00) Seoul",
		"Korea Standard Time", "Korea Daylight Time",
		NULL, 0
	},
	{
		"Cen. Australia Standard Time", 570, TRUE, "(UTC+09:30) Adelaide",
		"Cen. Australia Standard Time", "Cen. Australia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_85, 2
	},
	{
		"AUS Central Standard Time", 570, FALSE, "(UTC+09:30) Darwin",
		"AUS Central Standard Time", "AUS Central Daylight Time",
		NULL, 0
	},
	{
		"E. Australia Standard Time", 600, FALSE, "(UTC+10:00) Brisbane",
		"E. Australia Standard Time", "E. Australia Daylight Time",
		NULL, 0
	},
	{
		"AUS Eastern Standard Time", 600, TRUE, "(UTC+10:00) Canberra, Melbourne, Sydney",
		"AUS Eastern Standard Time", "AUS Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_88, 2
	},
	{
		"West Pacific Standard Time", 600, FALSE, "(UTC+10:00) Guam, Port Moresby",
		"West Pacific Standard Time", "West Pacific Daylight Time",
		NULL, 0
	},
	{
		"Tasmania Standard Time", 600, TRUE, "(UTC+10:00) Hobart",
		"Tasmania Standard Time", "Tasmania Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_90, 2
	},
	{
		"Yakutsk Standard Time", 600, TRUE, "(UTC+10:00) Yakutsk",
		"Yakutsk Standard Time", "Yakutsk Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_91, 1
	},
	{
		"Central Pacific Standard Time", 660, FALSE, "(UTC+11:00) Solomon Is., New Caledonia",
		"Central Pacific Standard Time", "Central Pacific Daylight Time",
		NULL, 0
	},
	{
		"Vladivostok Standard Time", 660, TRUE, "(UTC+11:00) Vladivostok",
		"Vladivostok Standard Time", "Vladivostok Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_93, 1
	},
	{
		"New Zealand Standard Time", 720, TRUE, "(UTC+12:00) Auckland, Wellington",
		"New Zealand Standard Time", "New Zealand Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_94, 3
	},
	{
		"UTC+12", 720, FALSE, "(UTC+12:00) Coordinated Universal Time+12",
		"UTC+12", "UTC+12",
		NULL, 0
	},
	{
		"Fiji Standard Time", 720, TRUE, "(UTC+12:00) Fiji",
		"Fiji Standard Time", "Fiji Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_96, 5
	},
	{
		"Magadan Standard Time", 720, TRUE, "(UTC+12:00) Magadan",
		"Magadan Standard Time", "Magadan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_97, 1
	},
	{
		"Kamchatka Standard Time", 720, TRUE, "(UTC+12:00) Petropavlovsk-Kamchatsky - Old",
		"Kamchatka Standard Time", "Kamchatka Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_98, 1
	},
	{
		"Tonga Standard Time", 780, FALSE, "(UTC+13:00) Nuku'alofa",
		"Tonga Standard Time", "Tonga Daylight Time",
		NULL, 0
	},
	{
		"Samoa Standard Time", 780, TRUE, "(UTC+13:00) Samoa",
		"Samoa Standard Time", "Samoa Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_100, 2
	}
};

/* Table generated with WindowsZones.cs */

struct _WINDOWS_TZID_ENTRY
{
	const char* windows;
	const char* tzid;
};
typedef struct _WINDOWS_TZID_ENTRY WINDOWS_TZID_ENTRY;

const WINDOWS_TZID_ENTRY WindowsTimeZoneIdTable[] =
{
	{ "Afghanistan Standard Time", "Asia/Kabul" },
	{ "Alaskan Standard Time", "America/Anchorage America/Juneau "
			"America/Nome America/Sitka America/Yakutat" },
	{ "Alaskan Standard Time", "America/Anchorage" },
	{ "Arab Standard Time", "Asia/Aden" },
	{ "Arab Standard Time", "Asia/Bahrain" },
	{ "Arab Standard Time", "Asia/Kuwait" },
	{ "Arab Standard Time", "Asia/Qatar" },
	{ "Arab Standard Time", "Asia/Riyadh" },
	{ "Arabian Standard Time", "Asia/Dubai" },
	{ "Arabian Standard Time", "Asia/Muscat" },
	{ "Arabian Standard Time", "Etc/GMT-4" },
	{ "Arabic Standard Time", "Asia/Baghdad" },
	{ "Argentina Standard Time", "America/Buenos_Aires America/Argentina/La_Rioja "
			"America/Argentina/Rio_Gallegos America/Argentina/Salta "
			"America/Argentina/San_Juan America/Argentina/San_Luis "
			"America/Argentina/Tucuman America/Argentina/Ushuaia America/Catamarca "
			"America/Cordoba America/Jujuy America/Mendoza" },
	{ "Argentina Standard Time", "America/Buenos_Aires" },
	{ "Atlantic Standard Time", "America/Halifax America/Glace_Bay "
			"America/Goose_Bay America/Moncton" },
	{ "Atlantic Standard Time", "America/Halifax" },
	{ "Atlantic Standard Time", "America/Thule" },
	{ "Atlantic Standard Time", "Atlantic/Bermuda" },
	{ "AUS Central Standard Time", "Australia/Darwin" },
	{ "AUS Eastern Standard Time", "Australia/Sydney Australia/Melbourne" },
	{ "AUS Eastern Standard Time", "Australia/Sydney" },
	{ "Azerbaijan Standard Time", "Asia/Baku" },
	{ "Azores Standard Time", "America/Scoresbysund" },
	{ "Azores Standard Time", "Atlantic/Azores" },
	{ "Bahia Standard Time", "America/Bahia" },
	{ "Bangladesh Standard Time", "Asia/Dhaka" },
	{ "Bangladesh Standard Time", "Asia/Thimphu" },
	{ "Canada Central Standard Time", "America/Regina America/Swift_Current" },
	{ "Canada Central Standard Time", "America/Regina" },
	{ "Cape Verde Standard Time", "Atlantic/Cape_Verde" },
	{ "Cape Verde Standard Time", "Etc/GMT+1" },
	{ "Caucasus Standard Time", "Asia/Yerevan" },
	{ "Cen. Australia Standard Time", "Australia/Adelaide Australia/Broken_Hill" },
	{ "Cen. Australia Standard Time", "Australia/Adelaide" },
	{ "Central America Standard Time", "America/Belize" },
	{ "Central America Standard Time", "America/Costa_Rica" },
	{ "Central America Standard Time", "America/El_Salvador" },
	{ "Central America Standard Time", "America/Guatemala" },
	{ "Central America Standard Time", "America/Managua" },
	{ "Central America Standard Time", "America/Tegucigalpa" },
	{ "Central America Standard Time", "Etc/GMT+6" },
	{ "Central America Standard Time", "Pacific/Galapagos" },
	{ "Central Asia Standard Time", "Antarctica/Vostok" },
	{ "Central Asia Standard Time", "Asia/Almaty Asia/Qyzylorda" },
	{ "Central Asia Standard Time", "Asia/Almaty" },
	{ "Central Asia Standard Time", "Asia/Bishkek" },
	{ "Central Asia Standard Time", "Etc/GMT-6" },
	{ "Central Asia Standard Time", "Indian/Chagos" },
	{ "Central Brazilian Standard Time", "America/Cuiaba America/Campo_Grande" },
	{ "Central Brazilian Standard Time", "America/Cuiaba" },
	{ "Central Europe Standard Time", "Europe/Belgrade" },
	{ "Central Europe Standard Time", "Europe/Bratislava" },
	{ "Central Europe Standard Time", "Europe/Budapest" },
	{ "Central Europe Standard Time", "Europe/Ljubljana" },
	{ "Central Europe Standard Time", "Europe/Podgorica" },
	{ "Central Europe Standard Time", "Europe/Prague" },
	{ "Central Europe Standard Time", "Europe/Tirane" },
	{ "Central European Standard Time", "Europe/Sarajevo" },
	{ "Central European Standard Time", "Europe/Skopje" },
	{ "Central European Standard Time", "Europe/Warsaw" },
	{ "Central European Standard Time", "Europe/Zagreb" },
	{ "Central Pacific Standard Time", "Antarctica/Macquarie" },
	{ "Central Pacific Standard Time", "Etc/GMT-11" },
	{ "Central Pacific Standard Time", "Pacific/Efate" },
	{ "Central Pacific Standard Time", "Pacific/Guadalcanal" },
	{ "Central Pacific Standard Time", "Pacific/Noumea" },
	{ "Central Pacific Standard Time", "Pacific/Ponape Pacific/Kosrae" },
	{ "Central Standard Time (Mexico)", "America/Mexico_City America/Bahia_Banderas "
			"America/Cancun America/Merida America/Monterrey" },
	{ "Central Standard Time (Mexico)", "America/Mexico_City" },
	{ "Central Standard Time", "America/Chicago America/Indiana/Knox "
			"America/Indiana/Tell_City America/Menominee "
			"America/North_Dakota/Beulah America/North_Dakota/Center "
			"America/North_Dakota/New_Salem" },
	{ "Central Standard Time", "America/Chicago" },
	{ "Central Standard Time", "America/Matamoros" },
	{ "Central Standard Time", "America/Winnipeg America/Rainy_River "
			"America/Rankin_Inlet America/Resolute" },
	{ "Central Standard Time", "CST6CDT" },
	{ "China Standard Time", "Asia/Hong_Kong" },
	{ "China Standard Time", "Asia/Macau" },
	{ "China Standard Time", "Asia/Shanghai Asia/Chongqing Asia/Harbin Asia/Kashgar Asia/Urumqi" },
	{ "China Standard Time", "Asia/Shanghai" },
	{ "Dateline Standard Time", "Etc/GMT+12" },
	{ "E. Africa Standard Time", "Africa/Addis_Ababa" },
	{ "E. Africa Standard Time", "Africa/Asmera" },
	{ "E. Africa Standard Time", "Africa/Dar_es_Salaam" },
	{ "E. Africa Standard Time", "Africa/Djibouti" },
	{ "E. Africa Standard Time", "Africa/Juba" },
	{ "E. Africa Standard Time", "Africa/Kampala" },
	{ "E. Africa Standard Time", "Africa/Khartoum" },
	{ "E. Africa Standard Time", "Africa/Mogadishu" },
	{ "E. Africa Standard Time", "Africa/Nairobi" },
	{ "E. Africa Standard Time", "Antarctica/Syowa" },
	{ "E. Africa Standard Time", "Etc/GMT-3" },
	{ "E. Africa Standard Time", "Indian/Antananarivo" },
	{ "E. Africa Standard Time", "Indian/Comoro" },
	{ "E. Africa Standard Time", "Indian/Mayotte" },
	{ "E. Australia Standard Time", "Australia/Brisbane Australia/Lindeman" },
	{ "E. Australia Standard Time", "Australia/Brisbane" },
	{ "E. Europe Standard Time", "Asia/Nicosia" },
	{ "E. South America Standard Time", "America/Sao_Paulo" },
	{ "Eastern Standard Time", "America/Grand_Turk" },
	{ "Eastern Standard Time", "America/Nassau" },
	{ "Eastern Standard Time", "America/New_York America/Detroit "
			"America/Indiana/Petersburg America/Indiana/Vincennes "
			"America/Indiana/Winamac America/Kentucky/Monticello America/Louisville" },
	{ "Eastern Standard Time", "America/New_York" },
	{ "Eastern Standard Time", "America/Toronto America/Iqaluit America/Montreal "
			"America/Nipigon America/Pangnirtung America/Thunder_Bay" },
	{ "Eastern Standard Time", "EST5EDT" },
	{ "Egypt Standard Time", "Africa/Cairo" },
	{ "Egypt Standard Time", "Asia/Gaza Asia/Hebron" },
	{ "Ekaterinburg Standard Time", "Asia/Yekaterinburg" },
	{ "Fiji Standard Time", "Pacific/Fiji" },
	{ "FLE Standard Time", "Europe/Helsinki" },
	{ "FLE Standard Time", "Europe/Kiev Europe/Simferopol Europe/Uzhgorod Europe/Zaporozhye" },
	{ "FLE Standard Time", "Europe/Kiev" },
	{ "FLE Standard Time", "Europe/Mariehamn" },
	{ "FLE Standard Time", "Europe/Riga" },
	{ "FLE Standard Time", "Europe/Sofia" },
	{ "FLE Standard Time", "Europe/Tallinn" },
	{ "FLE Standard Time", "Europe/Vilnius" },
	{ "Georgian Standard Time", "Asia/Tbilisi" },
	{ "GMT Standard Time", "Atlantic/Canary" },
	{ "GMT Standard Time", "Atlantic/Faeroe" },
	{ "GMT Standard Time", "Europe/Dublin" },
	{ "GMT Standard Time", "Europe/Guernsey" },
	{ "GMT Standard Time", "Europe/Isle_of_Man" },
	{ "GMT Standard Time", "Europe/Jersey" },
	{ "GMT Standard Time", "Europe/Lisbon Atlantic/Madeira" },
	{ "GMT Standard Time", "Europe/London" },
	{ "Greenland Standard Time", "America/Godthab" },
	{ "Greenwich Standard Time", "Africa/Abidjan" },
	{ "Greenwich Standard Time", "Africa/Accra" },
	{ "Greenwich Standard Time", "Africa/Bamako" },
	{ "Greenwich Standard Time", "Africa/Banjul" },
	{ "Greenwich Standard Time", "Africa/Bissau" },
	{ "Greenwich Standard Time", "Africa/Conakry" },
	{ "Greenwich Standard Time", "Africa/Dakar" },
	{ "Greenwich Standard Time", "Africa/El_Aaiun" },
	{ "Greenwich Standard Time", "Africa/Freetown" },
	{ "Greenwich Standard Time", "Africa/Lome" },
	{ "Greenwich Standard Time", "Africa/Monrovia" },
	{ "Greenwich Standard Time", "Africa/Nouakchott" },
	{ "Greenwich Standard Time", "Africa/Ouagadougou" },
	{ "Greenwich Standard Time", "Africa/Sao_Tome" },
	{ "Greenwich Standard Time", "Atlantic/Reykjavik" },
	{ "Greenwich Standard Time", "Atlantic/St_Helena" },
	{ "GTB Standard Time", "Europe/Athens" },
	{ "GTB Standard Time", "Europe/Bucharest" },
	{ "GTB Standard Time", "Europe/Chisinau" },
	{ "GTB Standard Time", "Europe/Istanbul" },
	{ "Hawaiian Standard Time", "Etc/GMT+10" },
	{ "Hawaiian Standard Time", "Pacific/Fakaofo" },
	{ "Hawaiian Standard Time", "Pacific/Honolulu" },
	{ "Hawaiian Standard Time", "Pacific/Johnston" },
	{ "Hawaiian Standard Time", "Pacific/Rarotonga" },
	{ "Hawaiian Standard Time", "Pacific/Tahiti" },
	{ "India Standard Time", "Asia/Calcutta Asia/Kolkata" },
	{ "Iran Standard Time", "Asia/Tehran" },
	{ "Israel Standard Time", "Asia/Jerusalem" },
	{ "Jordan Standard Time", "Asia/Amman" },
	{ "Kaliningrad Standard Time", "Europe/Kaliningrad" },
	{ "Kaliningrad Standard Time", "Europe/Minsk" },
	{ "Korea Standard Time", "Asia/Pyongyang" },
	{ "Korea Standard Time", "Asia/Seoul" },
	{ "Magadan Standard Time", "Asia/Magadan Asia/Anadyr Asia/Kamchatka" },
	{ "Magadan Standard Time", "Asia/Magadan" },
	{ "Mauritius Standard Time", "Indian/Mahe" },
	{ "Mauritius Standard Time", "Indian/Mauritius" },
	{ "Mauritius Standard Time", "Indian/Reunion" },
	{ "Middle East Standard Time", "Asia/Beirut" },
	{ "Montevideo Standard Time", "America/Montevideo" },
	{ "Morocco Standard Time", "Africa/Casablanca" },
	{ "Mountain Standard Time (Mexico)", "America/Chihuahua America/Mazatlan" },
	{ "Mountain Standard Time (Mexico)", "America/Chihuahua" },
	{ "Mountain Standard Time", "America/Denver America/Boise America/Shiprock" },
	{ "Mountain Standard Time", "America/Denver" },
	{ "Mountain Standard Time", "America/Edmonton "
			"America/Cambridge_Bay America/Inuvik America/Yellowknife" },
	{ "Mountain Standard Time", "America/Ojinaga" },
	{ "Mountain Standard Time", "MST7MDT" },
	{ "Myanmar Standard Time", "Asia/Rangoon" },
	{ "Myanmar Standard Time", "Indian/Cocos" },
	{ "N. Central Asia Standard Time", "Asia/Novosibirsk Asia/Novokuznetsk Asia/Omsk" },
	{ "N. Central Asia Standard Time", "Asia/Novosibirsk" },
	{ "Namibia Standard Time", "Africa/Windhoek" },
	{ "Nepal Standard Time", "Asia/Katmandu Asia/Kathmandu" },
	{ "New Zealand Standard Time", "Antarctica/South_Pole Antarctica/McMurdo" },
	{ "New Zealand Standard Time", "Pacific/Auckland" },
	{ "Newfoundland Standard Time", "America/St_Johns" },
	{ "North Asia East Standard Time", "Asia/Irkutsk" },
	{ "North Asia Standard Time", "Asia/Krasnoyarsk" },
	{ "Pacific SA Standard Time", "America/Santiago" },
	{ "Pacific SA Standard Time", "Antarctica/Palmer" },
	{ "Pacific Standard Time (Mexico)", "America/Santa_Isabel" },
	{ "Pacific Standard Time", "America/Los_Angeles" },
	{ "Pacific Standard Time", "America/Tijuana America/Ensenada" },
	{ "Pacific Standard Time", "America/Vancouver America/Dawson America/Whitehorse" },
	{ "Pacific Standard Time", "PST8PDT" },
	{ "Pakistan Standard Time", "Asia/Karachi" },
	{ "Paraguay Standard Time", "America/Asuncion" },
	{ "Romance Standard Time", "Europe/Brussels" },
	{ "Romance Standard Time", "Europe/Copenhagen" },
	{ "Romance Standard Time", "Europe/Madrid Africa/Ceuta" },
	{ "Romance Standard Time", "Europe/Paris" },
	{ "Russian Standard Time", "Europe/Moscow Europe/Samara Europe/Volgograd" },
	{ "Russian Standard Time", "Europe/Moscow" },
	{ "SA Eastern Standard Time", "America/Cayenne" },
	{ "SA Eastern Standard Time", "America/Fortaleza America/Araguaina "
			"America/Belem America/Maceio America/Recife America/Santarem" },
	{ "SA Eastern Standard Time", "America/Paramaribo" },
	{ "SA Eastern Standard Time", "Antarctica/Rothera" },
	{ "SA Eastern Standard Time", "Etc/GMT+3" },
	{ "SA Pacific Standard Time", "America/Bogota" },
	{ "SA Pacific Standard Time", "America/Cayman" },
	{ "SA Pacific Standard Time", "America/Coral_Harbour" },
	{ "SA Pacific Standard Time", "America/Guayaquil" },
	{ "SA Pacific Standard Time", "America/Jamaica" },
	{ "SA Pacific Standard Time", "America/Lima" },
	{ "SA Pacific Standard Time", "America/Panama" },
	{ "SA Pacific Standard Time", "America/Port-au-Prince" },
	{ "SA Pacific Standard Time", "Etc/GMT+5" },
	{ "SA Western Standard Time", "America/Anguilla" },
	{ "SA Western Standard Time", "America/Antigua" },
	{ "SA Western Standard Time", "America/Aruba" },
	{ "SA Western Standard Time", "America/Barbados" },
	{ "SA Western Standard Time", "America/Blanc-Sablon" },
	{ "SA Western Standard Time", "America/Curacao" },
	{ "SA Western Standard Time", "America/Dominica" },
	{ "SA Western Standard Time", "America/Grenada" },
	{ "SA Western Standard Time", "America/Guadeloupe" },
	{ "SA Western Standard Time", "America/Guyana" },
	{ "SA Western Standard Time", "America/La_Paz" },
	{ "SA Western Standard Time", "America/Manaus America/Boa_Vista "
			"America/Eirunepe America/Porto_Velho America/Rio_Branco" },
	{ "SA Western Standard Time", "America/Marigot" },
	{ "SA Western Standard Time", "America/Martinique" },
	{ "SA Western Standard Time", "America/Montserrat" },
	{ "SA Western Standard Time", "America/Port_of_Spain" },
	{ "SA Western Standard Time", "America/Puerto_Rico" },
	{ "SA Western Standard Time", "America/Santo_Domingo" },
	{ "SA Western Standard Time", "America/St_Barthelemy" },
	{ "SA Western Standard Time", "America/St_Kitts" },
	{ "SA Western Standard Time", "America/St_Lucia" },
	{ "SA Western Standard Time", "America/St_Thomas" },
	{ "SA Western Standard Time", "America/St_Vincent" },
	{ "SA Western Standard Time", "America/Tortola" },
	{ "SA Western Standard Time", "Etc/GMT+4" },
	{ "Samoa Standard Time", "Pacific/Apia Pacific/Samoa" },
	{ "SE Asia Standard Time", "Antarctica/Davis" },
	{ "SE Asia Standard Time", "Asia/Bangkok" },
	{ "SE Asia Standard Time", "Asia/Hovd" },
	{ "SE Asia Standard Time", "Asia/Jakarta Asia/Pontianak" },
	{ "SE Asia Standard Time", "Asia/Phnom_Penh" },
	{ "SE Asia Standard Time", "Asia/Saigon Asia/Ho_Chi_Minh" },
	{ "SE Asia Standard Time", "Asia/Vientiane" },
	{ "SE Asia Standard Time", "Etc/GMT-7" },
	{ "SE Asia Standard Time", "Indian/Christmas" },
	{ "Singapore Standard Time", "Asia/Brunei" },
	{ "Singapore Standard Time", "Asia/Kuala_Lumpur Asia/Kuching" },
	{ "Singapore Standard Time", "Asia/Makassar" },
	{ "Singapore Standard Time", "Asia/Manila" },
	{ "Singapore Standard Time", "Asia/Singapore" },
	{ "Singapore Standard Time", "Etc/GMT-8" },
	{ "South Africa Standard Time", "Africa/Blantyre" },
	{ "South Africa Standard Time", "Africa/Bujumbura" },
	{ "South Africa Standard Time", "Africa/Gaborone" },
	{ "South Africa Standard Time", "Africa/Harare" },
	{ "South Africa Standard Time", "Africa/Johannesburg" },
	{ "South Africa Standard Time", "Africa/Kigali" },
	{ "South Africa Standard Time", "Africa/Lubumbashi" },
	{ "South Africa Standard Time", "Africa/Lusaka" },
	{ "South Africa Standard Time", "Africa/Maputo" },
	{ "South Africa Standard Time", "Africa/Maseru" },
	{ "South Africa Standard Time", "Africa/Mbabane" },
	{ "South Africa Standard Time", "Africa/Tripoli" },
	{ "South Africa Standard Time", "Etc/GMT-2" },
	{ "Sri Lanka Standard Time", "Asia/Colombo" },
	{ "Syria Standard Time", "Asia/Damascus" },
	{ "Taipei Standard Time", "Asia/Taipei" },
	{ "Tasmania Standard Time", "Australia/Hobart Australia/Currie" },
	{ "Tasmania Standard Time", "Australia/Hobart" },
	{ "Tokyo Standard Time", "Asia/Dili" },
	{ "Tokyo Standard Time", "Asia/Jayapura" },
	{ "Tokyo Standard Time", "Asia/Tokyo" },
	{ "Tokyo Standard Time", "Etc/GMT-9" },
	{ "Tokyo Standard Time", "Pacific/Palau" },
	{ "Tonga Standard Time", "Etc/GMT-13" },
	{ "Tonga Standard Time", "Pacific/Enderbury" },
	{ "Tonga Standard Time", "Pacific/Tongatapu" },
	/* { "Turkey Standard Time", "Europe/Istanbul" }, */
	{ "Ulaanbaatar Standard Time", "Asia/Ulaanbaatar Asia/Choibalsan" },
	{ "Ulaanbaatar Standard Time", "Asia/Ulaanbaatar" },
	{ "US Eastern Standard Time", "America/Indianapolis "
			"America/Indiana/Marengo America/Indiana/Vevay" },
	{ "US Eastern Standard Time", "America/Indianapolis" },
	{ "US Mountain Standard Time", "America/Dawson_Creek" },
	{ "US Mountain Standard Time", "America/Hermosillo" },
	{ "US Mountain Standard Time", "America/Phoenix" },
	{ "US Mountain Standard Time", "Etc/GMT+7" },
	{ "UTC", "America/Danmarkshavn" },
	{ "UTC", "Etc/GMT" },
	{ "UTC+12", "Etc/GMT-12" },
	{ "UTC+12", "Pacific/Funafuti" },
	{ "UTC+12", "Pacific/Majuro Pacific/Kwajalein" },
	{ "UTC+12", "Pacific/Nauru" },
	{ "UTC+12", "Pacific/Tarawa" },
	{ "UTC+12", "Pacific/Wake" },
	{ "UTC+12", "Pacific/Wallis" },
	{ "UTC-02", "America/Noronha" },
	{ "UTC-02", "Atlantic/South_Georgia" },
	{ "UTC-02", "Etc/GMT+2" },
	{ "UTC-11", "Etc/GMT+11" },
	{ "UTC-11", "Pacific/Midway" },
	{ "UTC-11", "Pacific/Niue" },
	{ "UTC-11", "Pacific/Pago_Pago" },
	{ "Venezuela Standard Time", "America/Caracas" },
	{ "Vladivostok Standard Time", "Asia/Vladivostok Asia/Sakhalin" },
	{ "Vladivostok Standard Time", "Asia/Vladivostok" },
	{ "W. Australia Standard Time", "Antarctica/Casey" },
	{ "W. Australia Standard Time", "Australia/Perth" },
	{ "W. Central Africa Standard Time", "Africa/Algiers" },
	{ "W. Central Africa Standard Time", "Africa/Bangui" },
	{ "W. Central Africa Standard Time", "Africa/Brazzaville" },
	{ "W. Central Africa Standard Time", "Africa/Douala" },
	{ "W. Central Africa Standard Time", "Africa/Kinshasa" },
	{ "W. Central Africa Standard Time", "Africa/Lagos" },
	{ "W. Central Africa Standard Time", "Africa/Libreville" },
	{ "W. Central Africa Standard Time", "Africa/Luanda" },
	{ "W. Central Africa Standard Time", "Africa/Malabo" },
	{ "W. Central Africa Standard Time", "Africa/Ndjamena" },
	{ "W. Central Africa Standard Time", "Africa/Niamey" },
	{ "W. Central Africa Standard Time", "Africa/Porto-Novo" },
	{ "W. Central Africa Standard Time", "Africa/Tunis" },
	{ "W. Central Africa Standard Time", "Etc/GMT-1" },
	{ "W. Europe Standard Time", "Arctic/Longyearbyen" },
	{ "W. Europe Standard Time", "Europe/Amsterdam" },
	{ "W. Europe Standard Time", "Europe/Andorra" },
	{ "W. Europe Standard Time", "Europe/Berlin" },
	{ "W. Europe Standard Time", "Europe/Gibraltar" },
	{ "W. Europe Standard Time", "Europe/Luxembourg" },
	{ "W. Europe Standard Time", "Europe/Malta" },
	{ "W. Europe Standard Time", "Europe/Monaco" },
	{ "W. Europe Standard Time", "Europe/Oslo" },
	{ "W. Europe Standard Time", "Europe/Rome" },
	{ "W. Europe Standard Time", "Europe/San_Marino" },
	{ "W. Europe Standard Time", "Europe/Stockholm" },
	{ "W. Europe Standard Time", "Europe/Vaduz" },
	{ "W. Europe Standard Time", "Europe/Vatican" },
	{ "W. Europe Standard Time", "Europe/Vienna" },
	{ "W. Europe Standard Time", "Europe/Zurich" },
	{ "West Asia Standard Time", "Antarctica/Mawson" },
	{ "West Asia Standard Time", "Asia/Ashgabat" },
	{ "West Asia Standard Time", "Asia/Dushanbe" },
	{ "West Asia Standard Time", "Asia/Oral Asia/Aqtau Asia/Aqtobe" },
	{ "West Asia Standard Time", "Asia/Tashkent Asia/Samarkand" },
	{ "West Asia Standard Time", "Asia/Tashkent" },
	{ "West Asia Standard Time", "Etc/GMT-5" },
	{ "West Asia Standard Time", "Indian/Kerguelen" },
	{ "West Asia Standard Time", "Indian/Maldives" },
	{ "West Pacific Standard Time", "Antarctica/DumontDUrville" },
	{ "West Pacific Standard Time", "Etc/GMT-10" },
	{ "West Pacific Standard Time", "Pacific/Guam" },
	{ "West Pacific Standard Time", "Pacific/Port_Moresby" },
	{ "West Pacific Standard Time", "Pacific/Saipan" },
	{ "West Pacific Standard Time", "Pacific/Truk" },
	{ "Yakutsk Standard Time", "Asia/Yakutsk" }
};

char* freerdp_get_unix_timezone_identifier()
{
#ifndef _WIN32
	FILE* fp;
	ssize_t len;
	char* tz_env;
	size_t length;
	char* tzid = NULL;
	char buf[1024];

	tz_env = getenv("TZ");

	if (tz_env != NULL)
	{
		tzid = _strdup(tz_env);
		return tzid;
	}

	fp = fopen("/etc/timezone", "r");

	if (fp != NULL)
	{
		fseek(fp, 0, SEEK_END);
		length = ftell(fp);
		fseek(fp, 0, SEEK_SET);

		if (length < 2)
		{
			fclose(fp) ;
			return NULL;
		}

		tzid = (char*) malloc(length + 1);
		fread(tzid, length, 1, fp);
		tzid[length] = '\0';

		if (tzid[length - 1] == '\n')
			tzid[length - 1] = '\0';

		fclose(fp);

		return tzid;
	}

	/*
	 * On linux distros such as Redhat or Archlinux, a symlink at /etc/localtime
	 * will point to /usr/share/zoneinfo/region/place where region/place could be
	 * America/Montreal for example.
	 */
	
	if ((len = readlink("/etc/localtime", buf, sizeof(buf) - 1)) != -1)
	{
		int num = 0;
		int pos = len;

		buf[len] = '\0';

		/* find the position of the 2nd to last "/" */

		while (num < 2)
		{
			if (pos == 0)
				break;

			pos -= 1;

			if (buf[pos] == '/')
				num++;
		}

		tzid = (char*) malloc(len - pos + 1);
		strncpy(tzid, buf + pos + 1, len - pos);

		return tzid;	
	}

	fprintf(stderr, "Unable to detect time zone\n");
	return tzid;
#else
	return 0;
#endif
}

BOOL freerdp_match_unix_timezone_identifier_with_list(const char* tzid, const char* list)
{
	char* p;
	char* list_copy;

	list_copy = _strdup(list);

	p = strtok(list_copy, " ");

	while (p != NULL)
	{
		if (strcmp(p, tzid) == 0)
		{
			free(list_copy);
			return TRUE;
		}

		p = strtok(NULL, " ");
	}

	free(list_copy);

	return FALSE;
}

TIME_ZONE_ENTRY* freerdp_detect_windows_time_zone(UINT32 bias)
{
	int i, j;
	char* tzid;
	TIME_ZONE_ENTRY* timezone;

	tzid = freerdp_get_unix_timezone_identifier();

	if (tzid == NULL)
		return NULL;

	for (i = 0; i < ARRAYSIZE(TimeZoneTable); i++)
	{
		for (j = 0; j < ARRAYSIZE(WindowsTimeZoneIdTable); j++)
		{
			if (strcmp(TimeZoneTable[i].Id, WindowsTimeZoneIdTable[j].windows) != 0)
				continue;

			if (freerdp_match_unix_timezone_identifier_with_list(tzid, WindowsTimeZoneIdTable[j].tzid))
			{
				timezone = (TIME_ZONE_ENTRY*) malloc(sizeof(TIME_ZONE_ENTRY));
				memcpy((void*) timezone, (void*) &TimeZoneTable[i], sizeof(TIME_ZONE_ENTRY));
				timezone->Bias = bias;
				free(tzid);
				return timezone;
			}
		}
	}

	fprintf(stderr, "Unable to find a match for unix timezone: %s\n", tzid);
	free(tzid);
	return NULL;
}

TIME_ZONE_RULE_ENTRY* freerdp_get_current_time_zone_rule(TIME_ZONE_RULE_ENTRY* rules, UINT32 count)
{
	int i;
	UINT64 windows_time;

	windows_time = freerdp_windows_gmtime();

	for (i = 0; i < (int) count; i++)
	{
		if ((rules[i].TicksStart >= windows_time) && (windows_time >= rules[i].TicksEnd))
		{
			/*fprintf(stderr, "Got rule %d from table at %p with count %u\n", i, rules, count);*/
			return &rules[i];
		}
	}

	fprintf(stderr, "Unable to get current timezone rule\n");
	return NULL;
}

void freerdp_time_zone_detect(TIME_ZONE_INFO* clientTimeZone)
{
	time_t t;
	TIME_ZONE_ENTRY* tz;
	struct tm* local_time;

	clientTimeZone->standardBias = 0;
	
	time(&t);
	local_time = localtime(&t);

#ifdef HAVE_TM_GMTOFF
    clientTimeZone->bias = timezone / 60;
	DEBUG_TIMEZONE("tzname[std]: %s, tzname[dst]: %s, timezone: %ld, Daylight: %d", tzname[0], tzname[1], timezone, daylight);
#elif defined(sun)
	if (local_time->tm_isdst > 0)
		clientTimeZone->bias = (UINT32) (altzone / 3600);
	else
		clientTimeZone->bias = (UINT32) (timezone / 3600);
#else
	clientTimeZone->bias = 0;
#endif

	tz = freerdp_detect_windows_time_zone(clientTimeZone->bias);

	if (tz!= NULL)
	{
		DEBUG_TIMEZONE("tz: Id='%s' Bias=%d DST=%d dn='%s' sn='%s' dln='%s'",
			tz->Id, tz->Bias, tz->SupportsDST, tz->DisplayName,
			tz->StandardName, tz->DaylightName);

		sprintf(clientTimeZone->standardName, "%s", tz->StandardName);
		sprintf(clientTimeZone->daylightName, "%s", tz->DaylightName);

		if ((tz->SupportsDST) && (tz->RuleTableCount > 0))
		{
			TIME_ZONE_RULE_ENTRY* rule;
			rule = freerdp_get_current_time_zone_rule(tz->RuleTable, tz->RuleTableCount);

			if (rule != NULL)
			{
				clientTimeZone->daylightBias = -rule->DaylightDelta;

				clientTimeZone->standardDate.wYear = rule->StandardDate.wYear;
				clientTimeZone->standardDate.wMonth = rule->StandardDate.wMonth;
				clientTimeZone->standardDate.wDayOfWeek = rule->StandardDate.wDayOfWeek;
				clientTimeZone->standardDate.wDay = rule->StandardDate.wDay;
				clientTimeZone->standardDate.wHour = rule->StandardDate.wHour;
				clientTimeZone->standardDate.wMinute = rule->StandardDate.wMinute;
				clientTimeZone->standardDate.wSecond = rule->StandardDate.wSecond;
				clientTimeZone->standardDate.wMilliseconds = rule->StandardDate.wMilliseconds;

				clientTimeZone->daylightDate.wYear = rule->DaylightDate.wYear;
				clientTimeZone->daylightDate.wMonth = rule->DaylightDate.wMonth;
				clientTimeZone->daylightDate.wDayOfWeek = rule->DaylightDate.wDayOfWeek;
				clientTimeZone->daylightDate.wDay = rule->DaylightDate.wDay;
				clientTimeZone->daylightDate.wHour = rule->DaylightDate.wHour;
				clientTimeZone->daylightDate.wMinute = rule->DaylightDate.wMinute;
				clientTimeZone->daylightDate.wSecond = rule->DaylightDate.wSecond;
				clientTimeZone->daylightDate.wMilliseconds = rule->DaylightDate.wMilliseconds;
			}
		}
		free(tz);
	}
	else
	{
		/* could not detect timezone, fallback to using GMT */
		DEBUG_TIMEZONE("tz not found, using GMT.");
		sprintf(clientTimeZone->standardName, "%s", "GMT Standard Time");
		sprintf(clientTimeZone->daylightName, "%s", "GMT Daylight Time");
	}
}
