// CLASSIFICATION: UNCLASSIFIED
package mspccs_spreadsheet_tester.gui;


import mspccs_spreadsheet_tester.gui.AppResultsWindow;
import mspccs_spreadsheet_tester.gui.FilePanel;
import mspccs_spreadsheet_tester.utility.Directory;
import mspccs_spreadsheet_tester.utility.Platform;
import mspccs_spreadsheet_tester.utility.StartBrowser;
import mspccs_spreadsheet_tester.utility.Utility;


/*
 * MSPCCS_SpreadsheetTester.java
 *
 * Created on October 30, 2002, 10:59 AM
 */

/**
 *
 * @author  amyc
 */
public class MSPCCS_SpreadsheetTester extends javax.swing.JFrame
{
  private Directory currentDir;
  private FilePanel inputFilePanel;
  private FilePanel outputFilePanel;

  /**
   * Creates new form MSPCCS_SpreadsheetTester
   */
  public MSPCCS_SpreadsheetTester()
  {
    currentDir = new Directory(".");
    inputFilePanel = new FilePanel("Input File", currentDir);
    outputFilePanel = new FilePanel("Output File", currentDir);

    initComponents();

    java.awt.GridBagConstraints gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.insets = new java.awt.Insets(0, 0, 2, 0);
    getContentPane().add(inputFilePanel, gridBagConstraints1);

    gridBagConstraints1 = new java.awt.GridBagConstraints();
    gridBagConstraints1.gridx = 0;
    gridBagConstraints1.gridy = 1;
    gridBagConstraints1.insets = new java.awt.Insets(2, 0, 0, 0);
    getContentPane().add(outputFilePanel, gridBagConstraints1);

    pack();
    Utility.setIcon(this, "/mspccs_spreadsheet_tester/gui/icons/NGA.gif");
    Utility.center(null, this);
  }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    buttonPanel = new javax.swing.JPanel();
    runButton = new javax.swing.JButton();
    mspccsSpreadsheetTesterMenuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    exitMenuItem = new javax.swing.JMenuItem();
    optionsMenu = new javax.swing.JMenu();
    warningsCheckBoxMenuItem = new javax.swing.JCheckBoxMenuItem();
    helpMenu = new javax.swing.JMenu();
    contentsMenuItem = new javax.swing.JMenuItem();
    helpMenuSeparator = new javax.swing.JSeparator();
    aboutMenuItem = new javax.swing.JMenuItem();

    setTitle("MSP CCS Spreadsheet Tester");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitForm(evt);
      }
    });
    getContentPane().setLayout(new java.awt.GridBagLayout());

    buttonPanel.setMinimumSize(new java.awt.Dimension(306, 47));
    buttonPanel.setPreferredSize(new java.awt.Dimension(306, 47));
    buttonPanel.setLayout(new java.awt.GridBagLayout());

    runButton.setText("Run");
    runButton.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
    runButton.setMaximumSize(new java.awt.Dimension(26, 25));
    runButton.setMinimumSize(new java.awt.Dimension(26, 25));
    runButton.setPreferredSize(new java.awt.Dimension(26, 25));
    runButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        runButtonActionPerformed(evt);
      }
    });
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.ipadx = 32;
    gridBagConstraints.insets = new java.awt.Insets(17, 0, 10, 0);
    buttonPanel.add(runButton, gridBagConstraints);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    getContentPane().add(buttonPanel, gridBagConstraints);

    fileMenu.setMnemonic(java.awt.event.KeyEvent.VK_F);
    fileMenu.setText("File");

    exitMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_X);
    exitMenuItem.setText("Exit");
    exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitActionPerformed(evt);
      }
    });
    fileMenu.add(exitMenuItem);

    mspccsSpreadsheetTesterMenuBar.add(fileMenu);

    optionsMenu.setText("Options");

    warningsCheckBoxMenuItem.setSelected(true);
    warningsCheckBoxMenuItem.setText("Warnings");
    warningsCheckBoxMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        warningsCheckBoxMenuItemActionPerformed(evt);
      }
    });
    optionsMenu.add(warningsCheckBoxMenuItem);

    mspccsSpreadsheetTesterMenuBar.add(optionsMenu);

    helpMenu.setMnemonic(java.awt.event.KeyEvent.VK_H);
    helpMenu.setText("Help");

    contentsMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, 0));
    contentsMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mspccs_spreadsheet_tester/gui/icons/Space16.gif"))); // NOI18N
    contentsMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_C);
    contentsMenuItem.setText("Contents");
    contentsMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        helpContentsActionPerformed(evt);
      }
    });
    helpMenu.add(contentsMenuItem);
    helpMenu.add(helpMenuSeparator);

    aboutMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.ALT_MASK));
    aboutMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/mspccs_spreadsheet_tester/gui/icons/Question16.gif"))); // NOI18N
    aboutMenuItem.setMnemonic(java.awt.event.KeyEvent.VK_A);
    aboutMenuItem.setText("About MSP CCS Spreadsheet Tester...");
    aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        aboutActionPerformed(evt);
      }
    });
    helpMenu.add(aboutMenuItem);

    mspccsSpreadsheetTesterMenuBar.add(helpMenu);

    setJMenuBar(mspccsSpreadsheetTesterMenuBar);

    pack();
  }// </editor-fold>//GEN-END:initComponents

    private void helpContentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpContentsActionPerformed
      java.io.File helpFile = new java.io.File ("..");
      try
      {
         if (StartBrowser.isWindowsPlatform())
             StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "\\help\\MSPCCS_SpreadsheetTester_Contents.htm");
         else
             StartBrowser.displayURL(this, "file:" + helpFile.getCanonicalPath() + "/help/MSPCCS_SpreadsheetTester_Contents.htm");
      }
      catch(Exception e)
      {
          javax.swing.JOptionPane.showMessageDialog(this, "Could not invoke browser", "Error", javax.swing.JOptionPane.ERROR_MESSAGE);
      }
    }//GEN-LAST:event_helpContentsActionPerformed

    private void aboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutActionPerformed
    String helpText = "   MSP CCS SpreadsheetTester\n\n";
    helpText += "   Tests the coordinate conversion accuracy \n";
    helpText += "   of the MSP 3.0 coordinate conversion service.\n";
    javax.swing.JOptionPane.showMessageDialog(this, helpText, "About MSP CCS SpreadsheetTester", javax.swing.JOptionPane.PLAIN_MESSAGE);
    }//GEN-LAST:event_aboutActionPerformed

    private void exitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitActionPerformed

    private void runButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_runButtonActionPerformed
    // Check if a input, files file are specified
    String inputFilePath = inputFilePanel.getFileName();
    String outputFilePath = outputFilePanel.getFileName();
    if ((inputFilePath.length() > 1) && (outputFilePath.length() > 1))
    {
            boolean errorCheck = false;
            Process p = null;
            
            // Delete any existing stf files with same name
            java.io.File file = new java.io.File(outputFilePath);
            if (file.exists())
                file.delete();

            int showWarnings = 0;
            if(warningsCheckBoxMenuItem.isSelected())
              showWarnings = 1;
    
            if ((Platform.isWindows) /* || (Platform.isWindows2000)*/)
            {
                try
                {
                    p = Runtime.getRuntime().exec("MSPCCS_SpreadsheetTester " + "\"" + inputFilePath + "\"" + " " + "\"" + outputFilePath + "\"" + " " + String.valueOf(showWarnings));
                }
                catch(java.io.IOException ioex)
                {
                    javax.swing.JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", javax.swing.JOptionPane.ERROR_MESSAGE);
                    errorCheck = true;
                }
            }
            else if (Platform.isUnix)
            {
                try
                {
                    p = Runtime.getRuntime().exec( "MSPCCS_SpreadsheetTester " + inputFilePath + " " + outputFilePath + " " + String.valueOf(showWarnings));
                }
                catch(java.io.IOException ioex)
                {
                    javax.swing.JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", javax.swing.JOptionPane.ERROR_MESSAGE);
                    errorCheck = true;
                }
            }
            else if (Platform.isLinux)
            {
                try
                {
                    p = Runtime.getRuntime().exec( "./MSPCCS_SpreadsheetTester " + inputFilePath + " " + outputFilePath + " " + String.valueOf(showWarnings));
                }
                catch(java.io.IOException ioex)
                {
                    javax.swing.JOptionPane.showMessageDialog(this, "Error Running MSPCCS_SpreadsheetTester", "Error", javax.swing.JOptionPane.ERROR_MESSAGE);
                    errorCheck = true;
                }
            }
            else
            {
                javax.swing.JOptionPane.showMessageDialog(this, "OS undetermined\nCan't continue!", "Run Error!", javax.swing.JOptionPane.ERROR_MESSAGE);
                errorCheck = true;
                p = null;
            }
            
            if(!errorCheck)
                new AppResultsWindow(p, "MSPCCS_SpreadsheetTester", (inputFilePath + " " + outputFilePath + " " + String.valueOf(showWarnings)), outputFilePanel.getCurrentDir());
        }
    }//GEN-LAST:event_runButtonActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm

private void warningsCheckBoxMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_warningsCheckBoxMenuItemActionPerformed
    //showWarnings = warningsCheckBoxMenuItem.isSelected();
}//GEN-LAST:event_warningsCheckBoxMenuItemActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new MSPCCS_SpreadsheetTester().show();
    }


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JPanel buttonPanel;
  private javax.swing.JMenuItem contentsMenuItem;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JSeparator helpMenuSeparator;
  private javax.swing.JMenuBar mspccsSpreadsheetTesterMenuBar;
  private javax.swing.JMenu optionsMenu;
  private javax.swing.JButton runButton;
  private javax.swing.JCheckBoxMenuItem warningsCheckBoxMenuItem;
  // End of variables declaration//GEN-END:variables

}
// CLASSIFICATION: UNCLASSIFIED
