/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */



package com.sun.enterprise.tools.verifier.tests.web.ias;


import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.tests.web.*;
import com.sun.enterprise.tools.common.dd.webapp.*;

//<addition author="irfan@sun.com" [bug/rfe]-id="4711198" >
/* Changed the result messages to reflect consistency between the result messages generated 
 * for the EJB test cases for SunONE specific deployment descriptors*/
//</addition>

public class ASLocaleCharsetInfo extends WebTest implements WebCheck {


    public Result check(WebBundleDescriptor descriptor) {
	Result result = getInitializedResult();
	WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean notApp = false;

        String defaultLocale;
        String locale;
        String charset;
        String formHintField;
        LocaleCharsetMap[] localeCharMaps;
        //Nlsinfo nlsInfo = descriptor.getIasWebApp().getNlsinfo();
        LocaleCharsetInfo nlsInfo = descriptor.getIasWebApp().getLocaleCharsetInfo();
        //System.out.println(">>>>>>>>>>>>checking for res " +nlsInfo);
	if (nlsInfo != null) {

            defaultLocale=nlsInfo.getAttributeValue(MetaData.DEFAULT_LOCALE);
            localeCharMaps= nlsInfo.getLocaleCharsetMap();
            //System.out.println(">>>>>>>>>>>> defaultLocale " +defaultLocale);
            if (defaultLocale!=null || defaultLocale.length() != 0) {
                    result.passed(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "PASSED [AS-WEB locale-charset-info] Proper "+ MetaData.DEFAULT_LOCALE+"  [ {0} ] defined in the war file.",
					   new Object[] {defaultLocale}));

            } else{
                    if (!oneFailed)
                        oneFailed = true;
                    result.failed(smh.getLocalString
					   (getClass().getName() + ".failed",
					    "FAILED [AS-WEB local-charset-info] Empty "+ MetaData.DEFAULT_LOCALE+" [ {0} ] is not valid.",
					    new Object[] {defaultLocale}));
           }

	    for (int rep=0; rep<localeCharMaps.length; rep++ ) {
		locale = localeCharMaps[rep].getAttributeValue(MetaData.LOCALE);
                charset = localeCharMaps[rep].getAttributeValue(MetaData.CHARSET);
                //System.out.println(".>>>>>>>>>>>>>checking for locale: "+  locale+" charset : "+ charset);
                if (locale!=null && charset!=null && locale.length() != 0 && charset.length() != 0) {
                    result.passed(smh.getLocalString
					  (getClass().getName() + ".passed1",
					   "PASSED [AS-WEB locale-charset-map] attributes locale  [ {0} ] and charset [ {1} ] properly defined.",
					   new Object[] {locale, charset}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
                    result.failed(smh.getLocalString
                                      (getClass().getName() + ".failed1",
                                      "FAILED [AS-WEB local-charset-map] attributes locale [ {0} ] and charset [ {1} ] must be of finite length.",
                                      new Object[] {locale, charset}));
                }
            }


            //chk for parameter encoding pending, as NLSInfo object still dont support it.// to-do vkv#

        } else {
            //System.out.println("There are no NLS info defined within the ias-web archive");
            notApp = true;
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "NOT APPLICABLE [AS-WEB sun-web-app] locale-charset-info element not defined in this web archive [ {0} ].",
				  new Object[] {descriptor.getName()}));
        }
        if (oneFailed) {
            result.setStatus(Result.FAILED);
        } else if(notApp) {
            result.setStatus(Result.NOT_APPLICABLE);
        }else {
            result.setStatus(Result.PASSED);
            result.passed
		    (smh.getLocalString
		     (getClass().getName() + ".passed2",
		      "PASSED [AS-WEB sun-web-app] locale-charset-info elements are valid within the web archive [ {0} ] .",
                            new Object[] {descriptor.getName()} ));
        }
	return result;
    }
}

    