------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-binds.adb,v 1.13 2008/07/03 06:22:48 vagul Exp $

with OCI.Thread;

package body OCI.Thick.Binds is

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Stmt    : in     Statement;
      Var     : in out Abstract_Bind'Class;
      Name    : in     String;
      Type_Id : in     Ub2;
      Value   : in     DVoid;
      Size    : in     Sb4;
      Ind     : in     A_Sb2) is
   begin
      Check_Error (OCIBindByName
                     (Stmtp       => OCIStmt (Handle (Stmt)),
                      Bindpp      => Var.Bind'Access,
                      Errhp       => Thread.Error,
                      Placeholder => C.To_C (Name),
                      Placeh_Len  => Name'Length,
                      Valuep      => Value,
                      Value_Sz    => Size,
                      Dty         => Type_Id,
                      Indp        => Ind));
      Var.Stmt := Stmt;
   end Bind;

   -------------
   -- Destroy --
   -------------

   procedure Destroy (Item : in out Abstract_Bind) is
      pragma Unreferenced (Item);
   begin
      null;
   end Destroy;

end OCI.Thick.Binds;
