/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NetworkLoadBalancerForwardingRuleProperties struct for NetworkLoadBalancerForwardingRuleProperties
type NetworkLoadBalancerForwardingRuleProperties struct {
	// Balancing algorithm
	Algorithm   *string                                       `json:"algorithm"`
	HealthCheck *NetworkLoadBalancerForwardingRuleHealthCheck `json:"healthCheck,omitempty"`
	// Listening (inbound) IP.
	ListenerIp *string `json:"listenerIp"`
	// Listening (inbound) port number; valid range is 1 to 65535.
	ListenerPort *int32 `json:"listenerPort"`
	// The name of the Network Load Balancer forwarding rule.
	Name *string `json:"name"`
	// Balancing protocol
	Protocol *string `json:"protocol"`
	// Array of items in the collection.
	Targets *[]NetworkLoadBalancerForwardingRuleTarget `json:"targets"`
}

// NewNetworkLoadBalancerForwardingRuleProperties instantiates a new NetworkLoadBalancerForwardingRuleProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNetworkLoadBalancerForwardingRuleProperties(algorithm string, listenerIp string, listenerPort int32, name string, protocol string, targets []NetworkLoadBalancerForwardingRuleTarget) *NetworkLoadBalancerForwardingRuleProperties {
	this := NetworkLoadBalancerForwardingRuleProperties{}

	this.Algorithm = &algorithm
	this.ListenerIp = &listenerIp
	this.ListenerPort = &listenerPort
	this.Name = &name
	this.Protocol = &protocol
	this.Targets = &targets

	return &this
}

// NewNetworkLoadBalancerForwardingRulePropertiesWithDefaults instantiates a new NetworkLoadBalancerForwardingRuleProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNetworkLoadBalancerForwardingRulePropertiesWithDefaults() *NetworkLoadBalancerForwardingRuleProperties {
	this := NetworkLoadBalancerForwardingRuleProperties{}
	return &this
}

// GetAlgorithm returns the Algorithm field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetAlgorithm() *string {
	if o == nil {
		return nil
	}

	return o.Algorithm

}

// GetAlgorithmOk returns a tuple with the Algorithm field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetAlgorithmOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Algorithm, true
}

// SetAlgorithm sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetAlgorithm(v string) {

	o.Algorithm = &v

}

// HasAlgorithm returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasAlgorithm() bool {
	if o != nil && o.Algorithm != nil {
		return true
	}

	return false
}

// GetHealthCheck returns the HealthCheck field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetHealthCheck() *NetworkLoadBalancerForwardingRuleHealthCheck {
	if o == nil {
		return nil
	}

	return o.HealthCheck

}

// GetHealthCheckOk returns a tuple with the HealthCheck field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetHealthCheckOk() (*NetworkLoadBalancerForwardingRuleHealthCheck, bool) {
	if o == nil {
		return nil, false
	}

	return o.HealthCheck, true
}

// SetHealthCheck sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetHealthCheck(v NetworkLoadBalancerForwardingRuleHealthCheck) {

	o.HealthCheck = &v

}

// HasHealthCheck returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasHealthCheck() bool {
	if o != nil && o.HealthCheck != nil {
		return true
	}

	return false
}

// GetListenerIp returns the ListenerIp field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetListenerIp() *string {
	if o == nil {
		return nil
	}

	return o.ListenerIp

}

// GetListenerIpOk returns a tuple with the ListenerIp field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetListenerIpOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.ListenerIp, true
}

// SetListenerIp sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetListenerIp(v string) {

	o.ListenerIp = &v

}

// HasListenerIp returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasListenerIp() bool {
	if o != nil && o.ListenerIp != nil {
		return true
	}

	return false
}

// GetListenerPort returns the ListenerPort field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetListenerPort() *int32 {
	if o == nil {
		return nil
	}

	return o.ListenerPort

}

// GetListenerPortOk returns a tuple with the ListenerPort field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetListenerPortOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.ListenerPort, true
}

// SetListenerPort sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetListenerPort(v int32) {

	o.ListenerPort = &v

}

// HasListenerPort returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasListenerPort() bool {
	if o != nil && o.ListenerPort != nil {
		return true
	}

	return false
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetProtocol returns the Protocol field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetProtocol() *string {
	if o == nil {
		return nil
	}

	return o.Protocol

}

// GetProtocolOk returns a tuple with the Protocol field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetProtocolOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Protocol, true
}

// SetProtocol sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetProtocol(v string) {

	o.Protocol = &v

}

// HasProtocol returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasProtocol() bool {
	if o != nil && o.Protocol != nil {
		return true
	}

	return false
}

// GetTargets returns the Targets field value
// If the value is explicit nil, nil is returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetTargets() *[]NetworkLoadBalancerForwardingRuleTarget {
	if o == nil {
		return nil
	}

	return o.Targets

}

// GetTargetsOk returns a tuple with the Targets field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerForwardingRuleProperties) GetTargetsOk() (*[]NetworkLoadBalancerForwardingRuleTarget, bool) {
	if o == nil {
		return nil, false
	}

	return o.Targets, true
}

// SetTargets sets field value
func (o *NetworkLoadBalancerForwardingRuleProperties) SetTargets(v []NetworkLoadBalancerForwardingRuleTarget) {

	o.Targets = &v

}

// HasTargets returns a boolean if a field has been set.
func (o *NetworkLoadBalancerForwardingRuleProperties) HasTargets() bool {
	if o != nil && o.Targets != nil {
		return true
	}

	return false
}

func (o NetworkLoadBalancerForwardingRuleProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Algorithm != nil {
		toSerialize["algorithm"] = o.Algorithm
	}

	if o.HealthCheck != nil {
		toSerialize["healthCheck"] = o.HealthCheck
	}

	if o.ListenerIp != nil {
		toSerialize["listenerIp"] = o.ListenerIp
	}

	if o.ListenerPort != nil {
		toSerialize["listenerPort"] = o.ListenerPort
	}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	if o.Protocol != nil {
		toSerialize["protocol"] = o.Protocol
	}

	if o.Targets != nil {
		toSerialize["targets"] = o.Targets
	}

	return json.Marshal(toSerialize)
}

type NullableNetworkLoadBalancerForwardingRuleProperties struct {
	value *NetworkLoadBalancerForwardingRuleProperties
	isSet bool
}

func (v NullableNetworkLoadBalancerForwardingRuleProperties) Get() *NetworkLoadBalancerForwardingRuleProperties {
	return v.value
}

func (v *NullableNetworkLoadBalancerForwardingRuleProperties) Set(val *NetworkLoadBalancerForwardingRuleProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableNetworkLoadBalancerForwardingRuleProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableNetworkLoadBalancerForwardingRuleProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNetworkLoadBalancerForwardingRuleProperties(val *NetworkLoadBalancerForwardingRuleProperties) *NullableNetworkLoadBalancerForwardingRuleProperties {
	return &NullableNetworkLoadBalancerForwardingRuleProperties{value: val, isSet: true}
}

func (v NullableNetworkLoadBalancerForwardingRuleProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNetworkLoadBalancerForwardingRuleProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
