// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/knowledge_base.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents knowledge base resource.
//
// Note: The `projects.agent.knowledgeBases` resource is deprecated;
// only use `projects.knowledgeBases`.
type KnowledgeBase struct {
	// The knowledge base resource name.
	// The name must be empty when creating a knowledge base.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the knowledge base. The name must be 1024
	// bytes or less; otherwise, the creation request fails.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Language which represents the KnowledgeBase. When the KnowledgeBase is
	// created/updated, this is populated for all non en-us languages. If not
	// populated, the default language en-us applies.
	LanguageCode         string   `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KnowledgeBase) Reset()         { *m = KnowledgeBase{} }
func (m *KnowledgeBase) String() string { return proto.CompactTextString(m) }
func (*KnowledgeBase) ProtoMessage()    {}
func (*KnowledgeBase) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{0}
}

func (m *KnowledgeBase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeBase.Unmarshal(m, b)
}
func (m *KnowledgeBase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeBase.Marshal(b, m, deterministic)
}
func (m *KnowledgeBase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeBase.Merge(m, src)
}
func (m *KnowledgeBase) XXX_Size() int {
	return xxx_messageInfo_KnowledgeBase.Size(m)
}
func (m *KnowledgeBase) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeBase.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeBase proto.InternalMessageInfo

func (m *KnowledgeBase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *KnowledgeBase) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *KnowledgeBase) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Request message for [KnowledgeBases.ListKnowledgeBases][google.cloud.dialogflow.v2beta1.KnowledgeBases.ListKnowledgeBases].
type ListKnowledgeBasesRequest struct {
	// Required. The project to list of knowledge bases for.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 10 and at most 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKnowledgeBasesRequest) Reset()         { *m = ListKnowledgeBasesRequest{} }
func (m *ListKnowledgeBasesRequest) String() string { return proto.CompactTextString(m) }
func (*ListKnowledgeBasesRequest) ProtoMessage()    {}
func (*ListKnowledgeBasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{1}
}

func (m *ListKnowledgeBasesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKnowledgeBasesRequest.Unmarshal(m, b)
}
func (m *ListKnowledgeBasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKnowledgeBasesRequest.Marshal(b, m, deterministic)
}
func (m *ListKnowledgeBasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKnowledgeBasesRequest.Merge(m, src)
}
func (m *ListKnowledgeBasesRequest) XXX_Size() int {
	return xxx_messageInfo_ListKnowledgeBasesRequest.Size(m)
}
func (m *ListKnowledgeBasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKnowledgeBasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKnowledgeBasesRequest proto.InternalMessageInfo

func (m *ListKnowledgeBasesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListKnowledgeBasesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKnowledgeBasesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [KnowledgeBases.ListKnowledgeBases][google.cloud.dialogflow.v2beta1.KnowledgeBases.ListKnowledgeBases].
type ListKnowledgeBasesResponse struct {
	// The list of knowledge bases.
	KnowledgeBases []*KnowledgeBase `protobuf:"bytes,1,rep,name=knowledge_bases,json=knowledgeBases,proto3" json:"knowledge_bases,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKnowledgeBasesResponse) Reset()         { *m = ListKnowledgeBasesResponse{} }
func (m *ListKnowledgeBasesResponse) String() string { return proto.CompactTextString(m) }
func (*ListKnowledgeBasesResponse) ProtoMessage()    {}
func (*ListKnowledgeBasesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{2}
}

func (m *ListKnowledgeBasesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKnowledgeBasesResponse.Unmarshal(m, b)
}
func (m *ListKnowledgeBasesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKnowledgeBasesResponse.Marshal(b, m, deterministic)
}
func (m *ListKnowledgeBasesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKnowledgeBasesResponse.Merge(m, src)
}
func (m *ListKnowledgeBasesResponse) XXX_Size() int {
	return xxx_messageInfo_ListKnowledgeBasesResponse.Size(m)
}
func (m *ListKnowledgeBasesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKnowledgeBasesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKnowledgeBasesResponse proto.InternalMessageInfo

func (m *ListKnowledgeBasesResponse) GetKnowledgeBases() []*KnowledgeBase {
	if m != nil {
		return m.KnowledgeBases
	}
	return nil
}

func (m *ListKnowledgeBasesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [KnowledgeBases.GetKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.GetKnowledgeBase].
type GetKnowledgeBaseRequest struct {
	// Required. The name of the knowledge base to retrieve.
	// Format `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKnowledgeBaseRequest) Reset()         { *m = GetKnowledgeBaseRequest{} }
func (m *GetKnowledgeBaseRequest) String() string { return proto.CompactTextString(m) }
func (*GetKnowledgeBaseRequest) ProtoMessage()    {}
func (*GetKnowledgeBaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{3}
}

func (m *GetKnowledgeBaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKnowledgeBaseRequest.Unmarshal(m, b)
}
func (m *GetKnowledgeBaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKnowledgeBaseRequest.Marshal(b, m, deterministic)
}
func (m *GetKnowledgeBaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKnowledgeBaseRequest.Merge(m, src)
}
func (m *GetKnowledgeBaseRequest) XXX_Size() int {
	return xxx_messageInfo_GetKnowledgeBaseRequest.Size(m)
}
func (m *GetKnowledgeBaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKnowledgeBaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKnowledgeBaseRequest proto.InternalMessageInfo

func (m *GetKnowledgeBaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KnowledgeBases.CreateKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.CreateKnowledgeBase].
type CreateKnowledgeBaseRequest struct {
	// Required. The project to create a knowledge base for.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The knowledge base to create.
	KnowledgeBase        *KnowledgeBase `protobuf:"bytes,2,opt,name=knowledge_base,json=knowledgeBase,proto3" json:"knowledge_base,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CreateKnowledgeBaseRequest) Reset()         { *m = CreateKnowledgeBaseRequest{} }
func (m *CreateKnowledgeBaseRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKnowledgeBaseRequest) ProtoMessage()    {}
func (*CreateKnowledgeBaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{4}
}

func (m *CreateKnowledgeBaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKnowledgeBaseRequest.Unmarshal(m, b)
}
func (m *CreateKnowledgeBaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKnowledgeBaseRequest.Marshal(b, m, deterministic)
}
func (m *CreateKnowledgeBaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKnowledgeBaseRequest.Merge(m, src)
}
func (m *CreateKnowledgeBaseRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKnowledgeBaseRequest.Size(m)
}
func (m *CreateKnowledgeBaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKnowledgeBaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKnowledgeBaseRequest proto.InternalMessageInfo

func (m *CreateKnowledgeBaseRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateKnowledgeBaseRequest) GetKnowledgeBase() *KnowledgeBase {
	if m != nil {
		return m.KnowledgeBase
	}
	return nil
}

// Request message for [KnowledgeBases.DeleteKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.DeleteKnowledgeBase].
type DeleteKnowledgeBaseRequest struct {
	// Required. The name of the knowledge base to delete.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Force deletes the knowledge base. When set to true, any documents
	// in the knowledge base are also deleted.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteKnowledgeBaseRequest) Reset()         { *m = DeleteKnowledgeBaseRequest{} }
func (m *DeleteKnowledgeBaseRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteKnowledgeBaseRequest) ProtoMessage()    {}
func (*DeleteKnowledgeBaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{5}
}

func (m *DeleteKnowledgeBaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteKnowledgeBaseRequest.Unmarshal(m, b)
}
func (m *DeleteKnowledgeBaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteKnowledgeBaseRequest.Marshal(b, m, deterministic)
}
func (m *DeleteKnowledgeBaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteKnowledgeBaseRequest.Merge(m, src)
}
func (m *DeleteKnowledgeBaseRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteKnowledgeBaseRequest.Size(m)
}
func (m *DeleteKnowledgeBaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteKnowledgeBaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteKnowledgeBaseRequest proto.InternalMessageInfo

func (m *DeleteKnowledgeBaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteKnowledgeBaseRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for [KnowledgeBases.UpdateKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.UpdateKnowledgeBase].
type UpdateKnowledgeBaseRequest struct {
	// Required. The knowledge base to update.
	KnowledgeBase *KnowledgeBase `protobuf:"bytes,1,opt,name=knowledge_base,json=knowledgeBase,proto3" json:"knowledge_base,omitempty"`
	// Optional. Not specified means `update all`.
	// Currently, only `display_name` can be updated, an InvalidArgument will be
	// returned for attempting to update other fields.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateKnowledgeBaseRequest) Reset()         { *m = UpdateKnowledgeBaseRequest{} }
func (m *UpdateKnowledgeBaseRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateKnowledgeBaseRequest) ProtoMessage()    {}
func (*UpdateKnowledgeBaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9cdbbb049e0ce16a, []int{6}
}

func (m *UpdateKnowledgeBaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateKnowledgeBaseRequest.Unmarshal(m, b)
}
func (m *UpdateKnowledgeBaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateKnowledgeBaseRequest.Marshal(b, m, deterministic)
}
func (m *UpdateKnowledgeBaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateKnowledgeBaseRequest.Merge(m, src)
}
func (m *UpdateKnowledgeBaseRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateKnowledgeBaseRequest.Size(m)
}
func (m *UpdateKnowledgeBaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateKnowledgeBaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateKnowledgeBaseRequest proto.InternalMessageInfo

func (m *UpdateKnowledgeBaseRequest) GetKnowledgeBase() *KnowledgeBase {
	if m != nil {
		return m.KnowledgeBase
	}
	return nil
}

func (m *UpdateKnowledgeBaseRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterType((*KnowledgeBase)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeBase")
	proto.RegisterType((*ListKnowledgeBasesRequest)(nil), "google.cloud.dialogflow.v2beta1.ListKnowledgeBasesRequest")
	proto.RegisterType((*ListKnowledgeBasesResponse)(nil), "google.cloud.dialogflow.v2beta1.ListKnowledgeBasesResponse")
	proto.RegisterType((*GetKnowledgeBaseRequest)(nil), "google.cloud.dialogflow.v2beta1.GetKnowledgeBaseRequest")
	proto.RegisterType((*CreateKnowledgeBaseRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateKnowledgeBaseRequest")
	proto.RegisterType((*DeleteKnowledgeBaseRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteKnowledgeBaseRequest")
	proto.RegisterType((*UpdateKnowledgeBaseRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateKnowledgeBaseRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/knowledge_base.proto", fileDescriptor_9cdbbb049e0ce16a)
}

var fileDescriptor_9cdbbb049e0ce16a = []byte{
	// 805 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4d, 0x4f, 0x13, 0x4f,
	0x18, 0xcf, 0x94, 0x97, 0xc0, 0x94, 0xc2, 0x3f, 0xc3, 0x3f, 0x50, 0x16, 0x0d, 0xb8, 0x24, 0x86,
	0x54, 0xd9, 0x0d, 0xc5, 0x83, 0x29, 0x31, 0x11, 0x8a, 0x10, 0xe3, 0x4b, 0x48, 0x15, 0x8d, 0x5c,
	0x9a, 0x69, 0x77, 0xba, 0xac, 0xdd, 0xee, 0xac, 0x9d, 0xa9, 0x05, 0x0c, 0x17, 0xe2, 0xc5, 0x98,
	0x78, 0xf1, 0x6c, 0x62, 0xbc, 0x98, 0x18, 0x0f, 0x7c, 0x0e, 0x8f, 0xea, 0x47, 0x30, 0x7e, 0x05,
	0x3d, 0x9a, 0x9d, 0xd9, 0xd2, 0xee, 0x76, 0xd7, 0x52, 0xe2, 0xad, 0x3b, 0xcf, 0xdb, 0xef, 0xf7,
	0xfc, 0x9e, 0x67, 0x3a, 0xf0, 0x9a, 0x49, 0xa9, 0x69, 0x13, 0xbd, 0x6c, 0xd3, 0x86, 0xa1, 0x1b,
	0x16, 0xb6, 0xa9, 0x59, 0xb1, 0x69, 0x53, 0x7f, 0x9e, 0x2d, 0x11, 0x8e, 0x97, 0xf5, 0xaa, 0x43,
	0x9b, 0x36, 0x31, 0x4c, 0x52, 0x2c, 0x61, 0x46, 0x34, 0xb7, 0x4e, 0x39, 0x45, 0x73, 0x32, 0x4a,
	0x13, 0x51, 0x5a, 0x3b, 0x4a, 0xf3, 0xa3, 0x94, 0x0b, 0x7e, 0x5a, 0xec, 0x5a, 0x3a, 0x76, 0x1c,
	0xca, 0x31, 0xb7, 0xa8, 0xc3, 0x64, 0xb8, 0x32, 0xeb, 0x5b, 0xc5, 0x57, 0xa9, 0x51, 0xd1, 0x49,
	0xcd, 0xe5, 0x07, 0xbe, 0x71, 0x3e, 0x6c, 0xac, 0x58, 0xc4, 0x36, 0x8a, 0x35, 0xcc, 0xaa, 0xbe,
	0xc7, 0x74, 0x47, 0xf2, 0xb2, 0x6d, 0x11, 0x87, 0x4b, 0x83, 0x5a, 0x85, 0xa9, 0x3b, 0x2d, 0xb8,
	0xeb, 0x98, 0x11, 0x84, 0xe0, 0xa0, 0x83, 0x6b, 0x24, 0x0d, 0xe6, 0xc1, 0xe2, 0x68, 0x41, 0xfc,
	0x46, 0x97, 0xe0, 0x98, 0x61, 0x31, 0xd7, 0xc6, 0x07, 0x45, 0x61, 0x4b, 0x08, 0x5b, 0xd2, 0x3f,
	0xbb, 0xef, 0xb9, 0x2c, 0xc0, 0x94, 0x8d, 0x1d, 0xb3, 0x81, 0x4d, 0x52, 0x2c, 0x53, 0x83, 0xa4,
	0x07, 0x85, 0xcf, 0x58, 0xeb, 0x30, 0x4f, 0x0d, 0xa2, 0x52, 0x38, 0x73, 0xd7, 0x62, 0x3c, 0x50,
	0x90, 0x15, 0xc8, 0xb3, 0x06, 0x61, 0x1c, 0x4d, 0xc1, 0x61, 0x17, 0xd7, 0x89, 0xc3, 0xfd, 0xd2,
	0xfe, 0x17, 0x9a, 0x85, 0xa3, 0xae, 0x97, 0x95, 0x59, 0x87, 0xb2, 0xf2, 0x50, 0x61, 0xc4, 0x3b,
	0x78, 0x60, 0x1d, 0x12, 0x74, 0x11, 0x42, 0x61, 0xe4, 0xb4, 0x4a, 0x9c, 0xf4, 0x80, 0x08, 0x14,
	0xee, 0x0f, 0xbd, 0x03, 0xf5, 0x1d, 0x80, 0x4a, 0x54, 0x45, 0xe6, 0x52, 0x87, 0x11, 0xf4, 0x18,
	0x4e, 0x04, 0xb5, 0x62, 0x69, 0x30, 0x3f, 0xb0, 0x98, 0xcc, 0x6a, 0x5a, 0x0f, 0xb5, 0xb4, 0x40,
	0xc6, 0xc2, 0x78, 0x35, 0x50, 0x00, 0x5d, 0x86, 0x13, 0x0e, 0xd9, 0xe7, 0xc5, 0x0e, 0x6c, 0xb2,
	0x67, 0x29, 0xef, 0x78, 0xfb, 0x14, 0xdf, 0x12, 0x9c, 0xde, 0x22, 0x41, 0x74, 0xad, 0x76, 0x44,
	0xe8, 0xa0, 0xbe, 0x06, 0x50, 0xc9, 0xd7, 0x09, 0xe6, 0x24, 0x32, 0x24, 0xae, 0x83, 0x3b, 0x70,
	0x3c, 0x48, 0x53, 0x80, 0xe9, 0x9f, 0x65, 0x2a, 0xc0, 0x52, 0xdd, 0x84, 0xca, 0x06, 0xb1, 0x49,
	0x0c, 0x98, 0xa8, 0x39, 0xfa, 0x1f, 0x0e, 0x55, 0x68, 0xbd, 0x2c, 0xeb, 0x8f, 0x14, 0xe4, 0x87,
	0x7a, 0x02, 0xa0, 0xb2, 0xe3, 0x1a, 0x71, 0xac, 0xba, 0xd1, 0x83, 0x7f, 0x80, 0x1e, 0xad, 0xc2,
	0x64, 0x43, 0x14, 0x15, 0x6b, 0xe2, 0x77, 0x44, 0x69, 0xe5, 0x6c, 0x6d, 0x92, 0xb6, 0xe9, 0x6d,
	0xd2, 0x3d, 0xcc, 0xaa, 0x05, 0x28, 0xdd, 0xbd, 0xdf, 0xd9, 0x97, 0x49, 0x38, 0x1e, 0x9c, 0x29,
	0xf4, 0x0b, 0x40, 0xd4, 0x3d, 0x6a, 0x28, 0xd7, 0x13, 0x65, 0xec, 0x46, 0x28, 0xab, 0xe7, 0x8a,
	0x95, 0xb3, 0xad, 0xee, 0x1d, 0x7f, 0xfb, 0xf1, 0x36, 0x51, 0x42, 0x57, 0x4e, 0xaf, 0xa5, 0x17,
	0x72, 0x1c, 0x6e, 0xb8, 0x75, 0xfa, 0x94, 0x94, 0x39, 0xd3, 0x33, 0x47, 0x7a, 0x70, 0x6e, 0x77,
	0x57, 0xd0, 0xf2, 0x5f, 0xdc, 0x75, 0x6c, 0x12, 0x87, 0x87, 0x83, 0xd0, 0x4f, 0x00, 0xff, 0x0b,
	0x4f, 0x31, 0xba, 0xde, 0x13, 0x7b, 0xcc, 0xe0, 0x2b, 0x7d, 0xea, 0x1a, 0x45, 0xd4, 0x1b, 0xb6,
	0x4e, 0xdc, 0x41, 0xc0, 0x7a, 0xe6, 0x28, 0x48, 0x34, 0xec, 0x2e, 0x68, 0x76, 0x07, 0xa1, 0x37,
	0x09, 0x38, 0x19, 0xb1, 0x7e, 0xa8, 0xb7, 0x4e, 0xf1, 0x4b, 0xdb, 0x37, 0xdd, 0x57, 0x40, 0xf0,
	0x3d, 0x06, 0x6a, 0x3f, 0xca, 0xe6, 0x42, 0x3b, 0xb4, 0x9b, 0x57, 0xfb, 0x57, 0x3a, 0x9c, 0x04,
	0x7d, 0x07, 0x70, 0x32, 0xe2, 0x0a, 0x38, 0x43, 0x43, 0xe2, 0x2f, 0x0e, 0x65, 0xaa, 0x6b, 0x07,
	0x6f, 0x79, 0x7f, 0x75, 0x2d, 0x9d, 0x33, 0xfd, 0xe9, 0x9c, 0x39, 0x87, 0xce, 0x9f, 0x13, 0x70,
	0x32, 0xe2, 0x42, 0x3a, 0x03, 0xad, 0xf8, 0x6b, 0xac, 0x6f, 0x9d, 0x3f, 0x4a, 0x9d, 0xdf, 0x83,
	0x6c, 0xae, 0xcd, 0x20, 0xf4, 0xb2, 0xe8, 0xc9, 0xbf, 0x4b, 0xf6, 0x42, 0xf6, 0xe6, 0x99, 0xb3,
	0xc5, 0xb4, 0x27, 0x9c, 0x53, 0xd9, 0xff, 0xb2, 0x36, 0xd3, 0x41, 0x47, 0xd2, 0xc4, 0xae, 0xc5,
	0xb4, 0x32, 0xad, 0x7d, 0x5d, 0x7b, 0xb2, 0xc7, 0xb9, 0xcb, 0x72, 0xba, 0xde, 0x6c, 0x86, 0x8d,
	0x3a, 0x6e, 0xf0, 0x3d, 0xf9, 0x8e, 0x5a, 0x72, 0x6d, 0xcc, 0x2b, 0xb4, 0x5e, 0xbb, 0xda, 0xcb,
	0xbd, 0x5d, 0x6a, 0xfd, 0x04, 0xc0, 0x85, 0x32, 0xad, 0xf5, 0xea, 0xec, 0x3a, 0x0a, 0xb4, 0x76,
	0xdb, 0x9b, 0xab, 0x6d, 0xb0, 0x7b, 0xdb, 0x0f, 0x33, 0xa9, 0xf7, 0x48, 0xd1, 0x68, 0xdd, 0xd4,
	0x4d, 0xe2, 0x88, 0xa9, 0xd3, 0xdb, 0x85, 0x63, 0x9f, 0x79, 0xab, 0xed, 0xa3, 0xdf, 0x00, 0x7c,
	0x48, 0x24, 0x36, 0x36, 0x3f, 0x25, 0xe6, 0xb6, 0x64, 0xce, 0xbc, 0x80, 0xb2, 0xd1, 0x86, 0xf2,
	0x48, 0x06, 0x95, 0x86, 0x45, 0xfe, 0x95, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x09, 0x74, 0x9f,
	0x44, 0x45, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KnowledgeBasesClient is the client API for KnowledgeBases service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KnowledgeBasesClient interface {
	// Returns the list of all knowledge bases of the specified agent.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	ListKnowledgeBases(ctx context.Context, in *ListKnowledgeBasesRequest, opts ...grpc.CallOption) (*ListKnowledgeBasesResponse, error)
	// Retrieves the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	GetKnowledgeBase(ctx context.Context, in *GetKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error)
	// Creates a knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	CreateKnowledgeBase(ctx context.Context, in *CreateKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error)
	// Deletes the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	DeleteKnowledgeBase(ctx context.Context, in *DeleteKnowledgeBaseRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	UpdateKnowledgeBase(ctx context.Context, in *UpdateKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error)
}

type knowledgeBasesClient struct {
	cc *grpc.ClientConn
}

func NewKnowledgeBasesClient(cc *grpc.ClientConn) KnowledgeBasesClient {
	return &knowledgeBasesClient{cc}
}

func (c *knowledgeBasesClient) ListKnowledgeBases(ctx context.Context, in *ListKnowledgeBasesRequest, opts ...grpc.CallOption) (*ListKnowledgeBasesResponse, error) {
	out := new(ListKnowledgeBasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.KnowledgeBases/ListKnowledgeBases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *knowledgeBasesClient) GetKnowledgeBase(ctx context.Context, in *GetKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error) {
	out := new(KnowledgeBase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.KnowledgeBases/GetKnowledgeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *knowledgeBasesClient) CreateKnowledgeBase(ctx context.Context, in *CreateKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error) {
	out := new(KnowledgeBase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.KnowledgeBases/CreateKnowledgeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *knowledgeBasesClient) DeleteKnowledgeBase(ctx context.Context, in *DeleteKnowledgeBaseRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.KnowledgeBases/DeleteKnowledgeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *knowledgeBasesClient) UpdateKnowledgeBase(ctx context.Context, in *UpdateKnowledgeBaseRequest, opts ...grpc.CallOption) (*KnowledgeBase, error) {
	out := new(KnowledgeBase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.KnowledgeBases/UpdateKnowledgeBase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KnowledgeBasesServer is the server API for KnowledgeBases service.
type KnowledgeBasesServer interface {
	// Returns the list of all knowledge bases of the specified agent.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	ListKnowledgeBases(context.Context, *ListKnowledgeBasesRequest) (*ListKnowledgeBasesResponse, error)
	// Retrieves the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	GetKnowledgeBase(context.Context, *GetKnowledgeBaseRequest) (*KnowledgeBase, error)
	// Creates a knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	CreateKnowledgeBase(context.Context, *CreateKnowledgeBaseRequest) (*KnowledgeBase, error)
	// Deletes the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	DeleteKnowledgeBase(context.Context, *DeleteKnowledgeBaseRequest) (*empty.Empty, error)
	// Updates the specified knowledge base.
	//
	// Note: The `projects.agent.knowledgeBases` resource is deprecated;
	// only use `projects.knowledgeBases`.
	UpdateKnowledgeBase(context.Context, *UpdateKnowledgeBaseRequest) (*KnowledgeBase, error)
}

// UnimplementedKnowledgeBasesServer can be embedded to have forward compatible implementations.
type UnimplementedKnowledgeBasesServer struct {
}

func (*UnimplementedKnowledgeBasesServer) ListKnowledgeBases(ctx context.Context, req *ListKnowledgeBasesRequest) (*ListKnowledgeBasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKnowledgeBases not implemented")
}
func (*UnimplementedKnowledgeBasesServer) GetKnowledgeBase(ctx context.Context, req *GetKnowledgeBaseRequest) (*KnowledgeBase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKnowledgeBase not implemented")
}
func (*UnimplementedKnowledgeBasesServer) CreateKnowledgeBase(ctx context.Context, req *CreateKnowledgeBaseRequest) (*KnowledgeBase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKnowledgeBase not implemented")
}
func (*UnimplementedKnowledgeBasesServer) DeleteKnowledgeBase(ctx context.Context, req *DeleteKnowledgeBaseRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKnowledgeBase not implemented")
}
func (*UnimplementedKnowledgeBasesServer) UpdateKnowledgeBase(ctx context.Context, req *UpdateKnowledgeBaseRequest) (*KnowledgeBase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKnowledgeBase not implemented")
}

func RegisterKnowledgeBasesServer(s *grpc.Server, srv KnowledgeBasesServer) {
	s.RegisterService(&_KnowledgeBases_serviceDesc, srv)
}

func _KnowledgeBases_ListKnowledgeBases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKnowledgeBasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KnowledgeBasesServer).ListKnowledgeBases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.KnowledgeBases/ListKnowledgeBases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KnowledgeBasesServer).ListKnowledgeBases(ctx, req.(*ListKnowledgeBasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KnowledgeBases_GetKnowledgeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKnowledgeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KnowledgeBasesServer).GetKnowledgeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.KnowledgeBases/GetKnowledgeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KnowledgeBasesServer).GetKnowledgeBase(ctx, req.(*GetKnowledgeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KnowledgeBases_CreateKnowledgeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKnowledgeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KnowledgeBasesServer).CreateKnowledgeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.KnowledgeBases/CreateKnowledgeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KnowledgeBasesServer).CreateKnowledgeBase(ctx, req.(*CreateKnowledgeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KnowledgeBases_DeleteKnowledgeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKnowledgeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KnowledgeBasesServer).DeleteKnowledgeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.KnowledgeBases/DeleteKnowledgeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KnowledgeBasesServer).DeleteKnowledgeBase(ctx, req.(*DeleteKnowledgeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KnowledgeBases_UpdateKnowledgeBase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKnowledgeBaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KnowledgeBasesServer).UpdateKnowledgeBase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.KnowledgeBases/UpdateKnowledgeBase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KnowledgeBasesServer).UpdateKnowledgeBase(ctx, req.(*UpdateKnowledgeBaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KnowledgeBases_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.KnowledgeBases",
	HandlerType: (*KnowledgeBasesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListKnowledgeBases",
			Handler:    _KnowledgeBases_ListKnowledgeBases_Handler,
		},
		{
			MethodName: "GetKnowledgeBase",
			Handler:    _KnowledgeBases_GetKnowledgeBase_Handler,
		},
		{
			MethodName: "CreateKnowledgeBase",
			Handler:    _KnowledgeBases_CreateKnowledgeBase_Handler,
		},
		{
			MethodName: "DeleteKnowledgeBase",
			Handler:    _KnowledgeBases_DeleteKnowledgeBase_Handler,
		},
		{
			MethodName: "UpdateKnowledgeBase",
			Handler:    _KnowledgeBases_UpdateKnowledgeBase_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/knowledge_base.proto",
}
